# Generated by Django 3.2.18 on 2023-04-06 00:34

import django.db.models.deletion
from django.db import migrations, models

import chrono.apps.ants_hub.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('agendas', '0152_auto_20230331_0834'),
    ]

    operations = [
        migrations.CreateModel(
            name='City',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', chrono.apps.ants_hub.models.CharField(unique=True, verbose_name='Name')),
                (
                    'url',
                    chrono.apps.ants_hub.models.URLField(
                        blank=True,
                        default=chrono.apps.ants_hub.models.get_portal_url,
                        verbose_name='Portal URL',
                    ),
                ),
                ('logo_url', chrono.apps.ants_hub.models.URLField(blank=True, verbose_name='Logo URL')),
                (
                    'meeting_url',
                    chrono.apps.ants_hub.models.URLField(
                        blank=True,
                        help_text='URL of the web form to make a booking.',
                        verbose_name='Booking URL',
                    ),
                ),
                (
                    'management_url',
                    chrono.apps.ants_hub.models.URLField(
                        blank=True,
                        help_text='Generic URL to find and manage an existing booking.',
                        verbose_name='Booking management URL',
                    ),
                ),
                (
                    'cancel_url',
                    chrono.apps.ants_hub.models.URLField(
                        blank=True,
                        help_text='Generic URL to find and cancel an existing booking.',
                        verbose_name='Booking cancellation URL',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Last update')),
                ('full_sync', models.BooleanField(default=False, verbose_name='Full sync')),
                ('last_sync', models.DateTimeField(editable=False, null=True, verbose_name='Last sync')),
            ],
            options={
                'verbose_name': 'City',
                'verbose_name_plural': 'Cities',
            },
        ),
        migrations.CreateModel(
            name='Place',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', chrono.apps.ants_hub.models.CharField(verbose_name='Name')),
                ('address', chrono.apps.ants_hub.models.CharField(verbose_name='Address')),
                ('zipcode', chrono.apps.ants_hub.models.CharField(verbose_name='Code postal')),
                ('city_name', chrono.apps.ants_hub.models.CharField(verbose_name='City name')),
                ('longitude', models.FloatField(default=2.476, verbose_name='Longitude')),
                ('latitude', models.FloatField(default=46.596, verbose_name='Latitude')),
                ('url', chrono.apps.ants_hub.models.URLField(blank=True, verbose_name='Portal URL')),
                ('logo_url', chrono.apps.ants_hub.models.URLField(blank=True, verbose_name='Logo URL')),
                (
                    'meeting_url',
                    chrono.apps.ants_hub.models.URLField(
                        blank=True,
                        help_text='URL of the web form to make a booking.',
                        verbose_name='Booking URL',
                    ),
                ),
                (
                    'management_url',
                    chrono.apps.ants_hub.models.URLField(
                        blank=True,
                        help_text='Generic URL to find and manage an existing booking.',
                        verbose_name='Booking management URL',
                    ),
                ),
                (
                    'cancel_url',
                    chrono.apps.ants_hub.models.URLField(
                        blank=True,
                        help_text='Generic URL to find and cancel an existing booking.',
                        verbose_name='Booking cancellation URL',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Last update')),
                ('full_sync', models.BooleanField(default=False, verbose_name='Full sync')),
                ('last_sync', models.DateTimeField(editable=False, null=True, verbose_name='Last sync')),
                (
                    'city',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='places',
                        to='ants_hub.city',
                        verbose_name='City',
                    ),
                ),
            ],
            options={
                'verbose_name': 'place',
                'verbose_name_plural': 'places',
                'unique_together': {('city', 'name')},
            },
        ),
        migrations.CreateModel(
            name='PlaceAgenda',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('setting', models.JSONField(blank=True, default=dict, verbose_name='Setting')),
                (
                    'agenda',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        related_query_name='ants_place',
                        to='agendas.agenda',
                        verbose_name='Agenda',
                    ),
                ),
                (
                    'place',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='agendas',
                        to='ants_hub.place',
                        verbose_name='Place',
                    ),
                ),
            ],
            options={
                'unique_together': {('place', 'agenda')},
            },
        ),
    ]
