# Generated by Django 4.2.15 on 2025-05-05 14:59

import os

from django.db import migrations

with open(
    os.path.join(
        os.path.dirname(os.path.realpath(__file__)),
        '..',
        'sql',
        'event_triggers_for_tstzrange_constraint.sql',
    )
) as sql_file:
    sql_forwards = sql_file.read()


sql_backwards = '''

CREATE OR REPLACE FUNCTION set_ignore_reason() RETURNS TRIGGER AS $$
    BEGIN
        IF (TG_OP = 'INSERT') THEN
            IF NEW.cancellation_datetime IS NOT NULL THEN
                UPDATE agendas_event SET _ignore_reason = 'cancel' WHERE id = NEW.event_id;
            END IF;
            RETURN NEW;
        ELSIF (TG_OP = 'DELETE') THEN
            UPDATE agendas_event SET _ignore_reason = 'delete' WHERE id = OLD.event_id;
            RETURN OLD;
        ELSE
            PERFORM 1 FROM agendas_booking b WHERE b.event_id = NEW.event_id AND b.cancellation_datetime IS NOT NULL;
            IF FOUND THEN
                UPDATE agendas_event SET _ignore_reason = 'cancel' WHERE id = NEW.event_id;
            ELSE
                UPDATE agendas_event SET _ignore_reason = NULL WHERE id = NEW.event_id;
            END IF;
            RETURN NEW;
        END IF;
    END;
$$ LANGUAGE plpgsql;

'''


class Migration(migrations.Migration):

    dependencies = [
        ('agendas', '0191_agenda_check_option'),
    ]

    operations = [
        migrations.RunSQL(sql=sql_forwards, reverse_sql=sql_backwards),
    ]
