# Generated by Django 1.11.18 on 2020-09-15 12:01

import django.db.models.deletion
from django.db import migrations, models

import chrono


class Migration(migrations.Migration):
    dependencies = [
        ('agendas', '0061_auto_20200909_1752'),
    ]

    operations = [
        migrations.CreateModel(
            name='AgendaReminderSettings',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                (
                    'days',
                    models.IntegerField(
                        blank=True,
                        choices=chrono.agendas.models.AgendaReminderSettings.CHOICES,
                        null=True,
                        verbose_name='Send email reminder',
                        help_text=(
                            'In order to prevent users from getting a reminder shortly after booking, '
                            'a reminder is sent less only if at least 12 hours have elapsed since booking time.'
                        ),
                    ),
                ),
                ('send_email', models.BooleanField(default=False, verbose_name='Notify by email')),
                (
                    'email_extra_info',
                    models.TextField(
                        blank=True,
                        validators=[chrono.agendas.models.booking_template_validator],
                        help_text=(
                            'Basic information such as event name, time and date are already included. '
                            'Booking object can be accessed using standard template syntax. '
                            'This allows to access agenda name via {{ booking.event.agenda.label }}, '
                            'meeting type name via {{ booking.event.meeting_type.label }}, or any extra '
                            'parameter passed on booking creation via {{ booking.extra_data.xxx }}.'
                        ),
                        verbose_name='Additional text to include in emails',
                    ),
                ),
                ('send_sms', models.BooleanField(default=False, verbose_name='Notify by SMS')),
                (
                    'sms_extra_info',
                    models.TextField(
                        blank=True,
                        validators=[chrono.agendas.models.booking_template_validator],
                        help_text=(
                            'Basic information such as event name, time and date are already included. '
                            'Booking object can be accessed using standard template syntax. '
                            'This allows to access agenda name via {{ booking.event.agenda.label }}, '
                            'meeting type name via {{ booking.event.meeting_type.label }}, or any extra '
                            'parameter passed on booking creation via {{ booking.extra_data.xxx }}.'
                        ),
                        verbose_name='Additional text to include in SMS',
                    ),
                ),
                (
                    'agenda',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='reminder_settings',
                        to='agendas.Agenda',
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name='booking',
            name='reminder_datetime',
            field=models.DateTimeField(null=True),
        ),
    ]
