# Generated by Django 3.2.18 on 2023-06-28 10:47

from django.db import migrations, models
from django.db.models import F, Func, OuterRef, Subquery


class ArraySubquery(Subquery):
    template = 'ARRAY(%(subquery)s)'


def convert_week_days(apps, schema_editor):
    Event = apps.get_model('agendas', 'Event')
    SharedCustodyRule = apps.get_model('agendas', 'SharedCustodyRule')  # TODO

    events_with_days = (
        Event.objects.filter(pk=OuterRef('pk'))
        .annotate(week_day=Func(F('recurrence_days'), function='unnest', output_field=models.IntegerField()))
        .annotate(new_week_day=F('week_day') + 1)
        .values('new_week_day')
    )
    Event.objects.filter(recurrence_days__isnull=False).update(
        recurrence_days=ArraySubquery(events_with_days)
    )

    rules_with_days = (
        SharedCustodyRule.objects.filter(pk=OuterRef('pk'))
        .annotate(week_day=Func(F('days'), function='unnest', output_field=models.IntegerField()))
        .annotate(new_week_day=F('week_day') + 1)
        .values('new_week_day')
    )
    SharedCustodyRule.objects.update(days=ArraySubquery(rules_with_days))


class Migration(migrations.Migration):
    dependencies = [
        ('agendas', '0156_update_dow_index'),
    ]

    operations = [
        migrations.RunPython(convert_week_days, migrations.RunPython.noop),
    ]
