import pytest
from django.contrib.auth.models import Group, User


@pytest.fixture
def simple_user():
    try:
        user = User.objects.get(username='user')
    except User.DoesNotExist:
        user = User.objects.create_user('user', password='user')
    return user


@pytest.fixture
def managers_group():
    group, _ = Group.objects.get_or_create(name='Managers')
    return group


@pytest.fixture
def manager_user(managers_group):
    try:
        user = User.objects.get(username='manager')
    except User.DoesNotExist:
        user = User.objects.create_user('manager', password='manager')
    user.groups.set([managers_group])
    return user
