# Generated by Django 2.2.19 on 2022-02-02 16:36

from django.db import migrations
from django.db.models import F


def migrate_reminder_fields(apps, schema_editor):
    AgendaReminderSettings = apps.get_model('agendas', 'AgendaReminderSettings')
    for settings in AgendaReminderSettings.objects.filter(days_before_email__isnull=False):
        if settings.send_sms:
            settings.days_before_sms = settings.days_before_email

        if not settings.send_email:
            settings.days_before_email = None

        settings.save()

    Booking = apps.get_model('agendas', 'Booking')
    Booking.objects.update(sms_reminder_datetime=F('email_reminder_datetime'))


class Migration(migrations.Migration):
    dependencies = [
        ('agendas', '0107_auto_20220202_1730'),
    ]

    operations = [
        migrations.RunPython(migrate_reminder_fields, reverse_code=migrations.RunPython.noop),
    ]
