# Generated by Django 4.2.15 on 2025-02-19 10:35

import datetime

from django.db import migrations
from django.db.models import F

from chrono.utils.timezone import localtime


def populate_event_end_datetime(apps, schema_editor):
    Event = apps.get_model('agendas', 'Event')

    # compute end_datetime for events in normal events agenda, which may have a duration set
    Event.objects.filter(
        agenda__kind='events',
        duration__isnull=False,
    ).update(end_datetime=F('start_datetime') + datetime.timedelta(minutes=1) * F('duration'))

    # compute end_datetime for events in partial bookings events agenda, which all have end_time set
    events_to_update = Event.objects.filter(agenda__kind='events', end_time__isnull=False)
    for event in events_to_update:
        event.end_datetime = localtime(event.start_datetime).replace(
            hour=event.end_time.hour, minute=event.end_time.minute
        )

    Event.objects.bulk_update(events_to_update, ['end_datetime'])


class Migration(migrations.Migration):

    dependencies = [
        ('agendas', '0189_remove_set_end_datetime_trigger'),
    ]

    operations = [
        migrations.RunPython(populate_event_end_datetime, migrations.RunPython.noop),
    ]
