import pytest

from chrono.agendas.models import Agenda
from tests.utils import login

pytestmark = pytest.mark.django_db


def test_reports_home(settings, app, admin_user):
    settings.KNOWN_SERVICES = {}

    login(app)

    resp = app.get('/manage/')
    assert '/manage/reports/' in resp
    resp = app.get('/manage/reports/')
    assert '/manage/journal/' in resp
    assert '/manage/reports/pso/' not in resp
    assert '/manage/agendas/events/report/' not in resp

    settings.REPORTS_PSO_ENABLED = True
    resp = app.get('/manage/reports/')
    assert '/manage/journal/' in resp
    assert '/reports/pso/' in resp
    assert '/manage/agendas/events/report/' not in resp

    settings.REPORTS_PSO_ENABLED = False
    settings.KNOWN_SERVICES['lingo'] = {'default': {'url': 'https://lingo.dev/'}}
    resp = app.get('/manage/reports/')
    assert '/manage/journal/' in resp
    assert '/reports/pso/' not in resp
    assert '/manage/agendas/events/report/' in resp


def test_reports_home_as_manager(settings, app, manager_user):
    settings.KNOWN_SERVICES = {}
    Agenda.objects.create(label='Foo bar', view_role=manager_user.groups.all()[0])

    login(app, username='manager', password='manager')

    resp = app.get('/manage/')
    assert '/manage/reports/' not in resp
    resp = app.get('/manage/reports/')
    assert '/manage/journal/' not in resp
    assert '/manage/reports/pso/' not in resp
    assert '/manage/agendas/events/report/' not in resp

    settings.REPORTS_PSO_ENABLED = True
    resp = app.get('/manage/')
    assert '/manage/reports/' in resp
    resp = app.get('/manage/reports/')
    assert '/manage/journal/' not in resp
    assert '/reports/pso/' in resp
    assert '/manage/agendas/events/report/' not in resp

    settings.REPORTS_PSO_ENABLED = False
    settings.KNOWN_SERVICES['lingo'] = {'default': {'url': 'https://lingo.dev/'}}
    resp = app.get('/manage/')
    assert '/manage/reports/' in resp
    resp = app.get('/manage/reports/')
    assert '/manage/journal/' not in resp
    assert '/reports/pso/' not in resp
    assert '/manage/agendas/events/report/' in resp
