# Generated by Django 3.2.18 on 2023-08-22 15:47

from django.db import migrations


def migrate_booking_check_data(apps, schema_editor):
    Booking = apps.get_model('agendas', 'Booking')
    BookingCheck = apps.get_model('agendas', 'BookingCheck')

    booking_checks = []
    bookings = list(Booking.objects.filter(user_was_present__isnull=False))
    for booking in bookings:
        booking_check = BookingCheck(
            booking=booking,
            presence=booking.user_was_present,
            start_time=booking.user_check_start_time,
            end_time=booking.user_check_end_time,
            computed_start_time=booking.computed_start_time,
            computed_end_time=booking.computed_end_time,
            type_slug=booking.user_check_type_slug,
            type_label=booking.user_check_type_label,
        )
        booking_checks.append(booking_check)

    BookingCheck.objects.bulk_create(booking_checks)


def reverse_migrate_booking_check_data(apps, schema_editor):
    Booking = apps.get_model('agendas', 'Booking')

    bookings = list(Booking.objects.filter(user_check__isnull=False).select_related('user_check'))
    for booking in bookings:
        booking.user_was_present = booking.user_check.presence
        booking.user_check_start_time = booking.user_check.start_time
        booking.user_check_end_time = booking.user_check.end_time
        booking.computed_start_time = booking.computed_start_time
        booking.computed_end_time = booking.computed_end_time
        booking.user_check_type_slug = booking.user_check.type_slug
        booking.user_check_type_label = booking.user_check.type_label

    Booking.objects.bulk_update(
        bookings,
        fields=[
            'user_was_present',
            'user_check_start_time',
            'user_check_end_time',
            'computed_start_time',
            'computed_end_time',
            'user_check_type_slug',
            'user_check_type_label',
        ],
    )


class Migration(migrations.Migration):
    dependencies = [
        ('agendas', '0161_add_booking_check_model'),
    ]

    operations = [
        migrations.RunPython(migrate_booking_check_data, reverse_migrate_booking_check_data),
    ]
