import uuid

import django.core.serializers.json
from django.db import migrations, models

import chrono.manager.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('manager', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ManagerAsyncJob',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('label', models.CharField(max_length=100)),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('registered', 'Registered'),
                            ('running', 'Running'),
                            ('failed', 'Failed'),
                            ('completed', 'Completed'),
                        ],
                        default='registered',
                        max_length=100,
                    ),
                ),
                ('exception', models.TextField()),
                ('action', models.CharField(max_length=100)),
                (
                    'params',
                    models.JSONField(default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ('total_count', models.PositiveIntegerField(default=0)),
                ('current_count', models.PositiveIntegerField(default=0)),
                (
                    'result',
                    models.FileField(
                        blank=True, null=True, upload_to=chrono.manager.models.manager_async_job_path
                    ),
                ),
                ('creation_timestamp', models.DateTimeField(auto_now_add=True)),
                ('last_update_timestamp', models.DateTimeField(auto_now=True)),
                ('completion_timestamp', models.DateTimeField(default=None, null=True)),
            ],
        ),
    ]
