import django_webtest
import pytest
from django.contrib.auth import get_user_model
from django.core.signals import setting_changed
from django.dispatch import receiver

from chrono.utils.timezone import get_default_timezone

User = get_user_model()


@pytest.fixture
def user():
    user, _ = User.objects.get_or_create(
        username='john.doe', first_name='John', last_name='Doe', email='john.doe@example.net'
    )
    user.set_password('password')
    user.save()
    return user


@pytest.fixture
def app(request, user):
    wtm = django_webtest.WebTestMixin()
    wtm.setup_auth = False
    wtm._patch_settings()
    request.addfinalizer(wtm._unpatch_settings)
    app = django_webtest.DjangoTestApp()
    app.authorization = ('Basic', ('john.doe', 'password'))
    return app


@pytest.fixture(autouse=True)
def media_root(settings, tmpdir):
    settings.MEDIA_ROOT = str(tmpdir.mkdir('media_root'))


@pytest.fixture
def nocache(settings):
    settings.CACHES = {
        'default': {
            'BACKEND': 'django.core.cache.backends.dummy.DummyCache',
        }
    }


@receiver(setting_changed)
def update_connections_time_zone(**kwargs):
    if kwargs['setting'] == 'TIME_ZONE':
        # Reset local time zone lru cache
        get_default_timezone.cache_clear()
