# Generated by Django 2.2.26 on 2022-11-28 13:41

from django.db import migrations


def populate_child_column(apps, schema_editor):
    SharedCustodyAgenda = apps.get_model('agendas', 'SharedCustodyAgenda')

    for agenda in SharedCustodyAgenda.objects.all():
        child = agenda.children.first()
        if child:
            agenda.child = child
            agenda.save()
        else:
            agenda.delete()


class Migration(migrations.Migration):
    dependencies = [
        ('agendas', '0141_shared_custody_add_child_field'),
    ]

    operations = [migrations.RunPython(populate_child_column, migrations.RunPython.noop)]
