# Generated by Django 1.11.12 on 2019-03-28 07:17

from django.db import migrations, models
from django.utils.text import slugify


class Migration(migrations.Migration):
    dependencies = [
        ('visualization', '0002_rename_parameters'),
    ]

    def forward_func(apps, schema_editor):
        Visualization = apps.get_model('visualization', 'Visualization')
        new_slugs = {}
        for instance in Visualization.objects.all():
            if not instance.slug:
                new_slug = slugify(instance.name[:40]).strip('-')
                if new_slug in new_slugs:
                    i = 2
                    while True:
                        suffixed_slug = new_slug + '-%s' % i
                        if not suffixed_slug in new_slugs:
                            new_slug = suffixed_slug
                            break
                        i += 1
                new_slugs[new_slug] = True
                instance.slug = new_slug
                instance.save()

    def reverse_func(apps, schema_editor):
        pass

    operations = [
        migrations.AddField(
            model_name='visualization',
            name='slug',
            field=models.SlugField(null=True, unique=True, verbose_name='Identifier'),
        ),
        migrations.RunPython(forward_func, reverse_func),
    ]
