--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET default_tablespace = '';

SET default_with_oids = false;


/* custom dates table */
CREATE TABLE dates AS (SELECT
	the_date.the_date::date AS date,
	to_char(the_date.the_date, 'TMday') AS day,
	to_char(the_date.the_date, 'TMmonth') AS month
  FROM
	generate_series('2010-01-01'::date, '2020-01-01'::date, '1 day'::interval)
  AS the_date(the_date));

--
-- Name: agent; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE agent (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE agent; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE agent IS 'agents';


--
-- Name: agent_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE agent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: agent_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE agent_id_seq OWNED BY agent.id;


--
-- Name: category; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE category (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE category; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE category IS 'catégorie';


--
-- Name: channel; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE channel (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE channel; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE channel IS 'canal';


--
-- Name: evolution; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution (
    id integer NOT NULL,
    generic_status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution IS 'evolution générique';


--
-- Name: evolution_acceder_aux_services_pour_les_professionnels; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_acceder_aux_services_pour_les_professionnels (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_acceder_aux_services_pour_les_professionnels; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_acceder_aux_services_pour_les_professionnels IS 'evolution des demandes Accéder aux services pour les professionnels';


--
-- Name: evolution_acceder_aux_services_pour_les_professionnels_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_acceder_aux_services_pour_les_professionnels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_acceder_aux_services_pour_les_professionnels_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_acceder_aux_services_pour_les_professionnels_id_seq OWNED BY evolution_acceder_aux_services_pour_les_professionnels.id;


--
-- Name: evolution_candidater_aux_avis_de_marches_publics; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_candidater_aux_avis_de_marches_publics (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_candidater_aux_avis_de_marches_publics; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_candidater_aux_avis_de_marches_publics IS 'evolution des demandes Candidater aux avis de marchés publics';


--
-- Name: evolution_candidater_aux_avis_de_marches_publics_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_candidater_aux_avis_de_marches_publics_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_candidater_aux_avis_de_marches_publics_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_candidater_aux_avis_de_marches_publics_id_seq OWNED BY evolution_candidater_aux_avis_de_marches_publics.id;


--
-- Name: evolution_candidater_aux_offres_d_emplois_de_la_metropole; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_candidater_aux_offres_d_emplois_de_la_metropole (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_candidater_aux_offres_d_emplois_de_la_metropole; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_candidater_aux_offres_d_emplois_de_la_metropole IS 'evolution des demandes Candidater aux offres d''emplois de la Métropole';


--
-- Name: evolution_candidater_aux_offres_d_emplois_de_la_metropol_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_candidater_aux_offres_d_emplois_de_la_metropol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_candidater_aux_offres_d_emplois_de_la_metropol_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_candidater_aux_offres_d_emplois_de_la_metropol_id_seq OWNED BY evolution_candidater_aux_offres_d_emplois_de_la_metropole.id;


--
-- Name: evolution_commander_un_bac_un_composteur_ou_un_lombricomposteur; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_commander_un_bac_un_composteur_ou_un_lombricomposteur (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_commander_un_bac_un_composteur_ou_un_lombricomposteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_commander_un_bac_un_composteur_ou_un_lombricomposteur IS 'evolution des demandes Commander un bac, un composteur ou un lombricomposteur';


--
-- Name: evolution_commander_un_bac_un_composteur_ou_un_lombricom_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_commander_un_bac_un_composteur_ou_un_lombricom_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_commander_un_bac_un_composteur_ou_un_lombricom_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_commander_un_bac_un_composteur_ou_un_lombricom_id_seq OWNED BY evolution_commander_un_bac_un_composteur_ou_un_lombricomposteur.id;


--
-- Name: evolution_creer_ou_acceder_a_ma_demande_de_logement_social; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_creer_ou_acceder_a_ma_demande_de_logement_social (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_creer_ou_acceder_a_ma_demande_de_logement_social; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_creer_ou_acceder_a_ma_demande_de_logement_social IS 'evolution des demandes Créer ou accéder à ma demande de logement social';


--
-- Name: evolution_creer_ou_acceder_a_ma_demande_de_logement_soci_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_creer_ou_acceder_a_ma_demande_de_logement_soci_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_creer_ou_acceder_a_ma_demande_de_logement_soci_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_creer_ou_acceder_a_ma_demande_de_logement_soci_id_seq OWNED BY evolution_creer_ou_acceder_a_ma_demande_de_logement_social.id;


--
-- Name: evolution_dechets_mesdechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_dechets_mesdechets (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_dechets_mesdechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_dechets_mesdechets IS 'evolution des demandes Déchets : mes signalements';


--
-- Name: evolution_dechets_mesdechets_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_dechets_mesdechets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_dechets_mesdechets_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_dechets_mesdechets_id_seq OWNED BY evolution_dechets_mesdechets.id;


--
-- Name: evolution_declarer_et_payer_ma_taxe_de_sejour; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_declarer_et_payer_ma_taxe_de_sejour (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_declarer_et_payer_ma_taxe_de_sejour; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_declarer_et_payer_ma_taxe_de_sejour IS 'evolution des demandes Déclarer et payer ma taxe de séjour';


--
-- Name: evolution_declarer_et_payer_ma_taxe_de_sejour_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_declarer_et_payer_ma_taxe_de_sejour_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_declarer_et_payer_ma_taxe_de_sejour_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_declarer_et_payer_ma_taxe_de_sejour_id_seq OWNED BY evolution_declarer_et_payer_ma_taxe_de_sejour.id;


--
-- Name: evolution_demander_des_renseignements_sur_la_voirie_backoffice; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_des_renseignements_sur_la_voirie_backoffice (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_des_renseignements_sur_la_voirie_backoffice; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_des_renseignements_sur_la_voirie_backoffice IS 'evolution des demandes Demander des renseignements sur la voirie';


--
-- Name: evolution_demander_des_renseignements_sur_la_voirie_back_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_des_renseignements_sur_la_voirie_back_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_des_renseignements_sur_la_voirie_back_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_des_renseignements_sur_la_voirie_back_id_seq OWNED BY evolution_demander_des_renseignements_sur_la_voirie_backoffice.id;


--
-- Name: evolution_demander_des_renseignements_sur_les_dechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_des_renseignements_sur_les_dechets (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_des_renseignements_sur_les_dechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_des_renseignements_sur_les_dechets IS 'evolution des demandes Demander des renseignements sur les déchets';


--
-- Name: evolution_demander_des_renseignements_sur_les_dechets_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_des_renseignements_sur_les_dechets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_des_renseignements_sur_les_dechets_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_des_renseignements_sur_les_dechets_id_seq OWNED BY evolution_demander_des_renseignements_sur_les_dechets.id;


--
-- Name: evolution_demander_un_badge_d_acces_a_une_zone_pietonne; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_un_badge_d_acces_a_une_zone_pietonne (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_un_badge_d_acces_a_une_zone_pietonne; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_un_badge_d_acces_a_une_zone_pietonne IS 'evolution des demandes Demander un badge d''accès à une zone piétonne';


--
-- Name: evolution_demander_un_badge_d_acces_a_une_zone_pietonne_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_un_badge_d_acces_a_une_zone_pietonne_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_un_badge_d_acces_a_une_zone_pietonne_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_un_badge_d_acces_a_une_zone_pietonne_id_seq OWNED BY evolution_demander_un_badge_d_acces_a_une_zone_pietonne.id;


--
-- Name: evolution_demander_un_renseignement_a_d_autres_services; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_un_renseignement_a_d_autres_services (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_un_renseignement_a_d_autres_services; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_un_renseignement_a_d_autres_services IS 'evolution des demandes Demander un renseignement à d''autres services';


--
-- Name: evolution_demander_un_renseignement_a_d_autres_services_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_un_renseignement_a_d_autres_services_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_un_renseignement_a_d_autres_services_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_un_renseignement_a_d_autres_services_id_seq OWNED BY evolution_demander_un_renseignement_a_d_autres_services.id;


--
-- Name: evolution_demander_un_renseignement_concernant_l_economie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_un_renseignement_concernant_l_economie (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_un_renseignement_concernant_l_economie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_un_renseignement_concernant_l_economie IS 'evolution des demandes Demander un renseignement concernant l''économie ou le tourisme';


--
-- Name: evolution_demander_un_renseignement_concernant_l_economi_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_un_renseignement_concernant_l_economi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_un_renseignement_concernant_l_economi_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_un_renseignement_concernant_l_economi_id_seq OWNED BY evolution_demander_un_renseignement_concernant_l_economie.id;


--
-- Name: evolution_demander_un_renseignement_concernant_l_urbanisme; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_un_renseignement_concernant_l_urbanisme (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_un_renseignement_concernant_l_urbanisme; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_un_renseignement_concernant_l_urbanisme IS 'evolution des demandes Demander un renseignement concernant l''urbanisme';


--
-- Name: evolution_demander_un_renseignement_concernant_l_urbanis_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_un_renseignement_concernant_l_urbanis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_un_renseignement_concernant_l_urbanis_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_un_renseignement_concernant_l_urbanis_id_seq OWNED BY evolution_demander_un_renseignement_concernant_l_urbanisme.id;


--
-- Name: evolution_demander_un_renseignement_concernant_la_directi8df794; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_un_renseignement_concernant_la_directi8df794 (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_un_renseignement_concernant_la_directi8df794; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_un_renseignement_concernant_la_directi8df794 IS 'evolution des demandes Demander un renseignement concernant la direction de la communication';


--
-- Name: evolution_demander_un_renseignement_concernant_la_direct_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_un_renseignement_concernant_la_direct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_un_renseignement_concernant_la_direct_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_un_renseignement_concernant_la_direct_id_seq OWNED BY evolution_demander_un_renseignement_concernant_la_directi8df794.id;


--
-- Name: evolution_demander_un_renseignement_concernant_le_logement; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_un_renseignement_concernant_le_logement (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_un_renseignement_concernant_le_logement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_un_renseignement_concernant_le_logement IS 'evolution des demandes Demander un renseignement concernant le logement';


--
-- Name: evolution_demander_un_renseignement_concernant_le_logeme_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_un_renseignement_concernant_le_logeme_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_un_renseignement_concernant_le_logeme_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_un_renseignement_concernant_le_logeme_id_seq OWNED BY evolution_demander_un_renseignement_concernant_le_logement.id;


--
-- Name: evolution_demander_un_renseignement_concernant_les_ressou3bb429; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_un_renseignement_concernant_les_ressou3bb429 (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_un_renseignement_concernant_les_ressou3bb429; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_un_renseignement_concernant_les_ressou3bb429 IS 'evolution des demandes Demander un renseignement concernant les ressources humaines';


--
-- Name: evolution_demander_un_renseignement_concernant_les_resso_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_un_renseignement_concernant_les_resso_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_un_renseignement_concernant_les_resso_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_un_renseignement_concernant_les_resso_id_seq OWNED BY evolution_demander_un_renseignement_concernant_les_ressou3bb429.id;


--
-- Name: evolution_demander_un_stage; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_un_stage (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_un_stage; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_un_stage IS 'evolution des demandes Demander un stage';


--
-- Name: evolution_demander_un_stage_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_un_stage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_un_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_un_stage_id_seq OWNED BY evolution_demander_un_stage.id;


--
-- Name: evolution_demander_une_alternance; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_une_alternance (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_une_alternance; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_une_alternance IS 'evolution des demandes Demander une alternance';


--
-- Name: evolution_demander_une_alternance_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_une_alternance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_une_alternance_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_une_alternance_id_seq OWNED BY evolution_demander_une_alternance.id;


--
-- Name: evolution_demander_une_autorisation_de_stationnement; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_demander_une_autorisation_de_stationnement (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_demander_une_autorisation_de_stationnement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_demander_une_autorisation_de_stationnement IS 'evolution des demandes Demander une autorisation de stationnement';


--
-- Name: evolution_demander_une_autorisation_de_stationnement_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_demander_une_autorisation_de_stationnement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_demander_une_autorisation_de_stationnement_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_demander_une_autorisation_de_stationnement_id_seq OWNED BY evolution_demander_une_autorisation_de_stationnement.id;


--
-- Name: evolution_envoyer_une_candidature_spontanee; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_envoyer_une_candidature_spontanee (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_envoyer_une_candidature_spontanee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_envoyer_une_candidature_spontanee IS 'evolution des demandes Envoyer une candidature spontanée';


--
-- Name: evolution_envoyer_une_candidature_spontanee_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_envoyer_une_candidature_spontanee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_envoyer_une_candidature_spontanee_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_envoyer_une_candidature_spontanee_id_seq OWNED BY evolution_envoyer_une_candidature_spontanee.id;


--
-- Name: evolution_gerer_mon_contrat_payer_ma_facture_resilier_mon402aba; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_gerer_mon_contrat_payer_ma_facture_resilier_mon402aba (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_gerer_mon_contrat_payer_ma_facture_resilier_mon402aba; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_gerer_mon_contrat_payer_ma_facture_resilier_mon402aba IS 'evolution des demandes Gérer mon contrat, payer ma facture, résilier mon abonnement';


--
-- Name: evolution_gerer_mon_contrat_payer_ma_facture_resilier_mo_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_gerer_mon_contrat_payer_ma_facture_resilier_mo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_gerer_mon_contrat_payer_ma_facture_resilier_mo_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_gerer_mon_contrat_payer_ma_facture_resilier_mo_id_seq OWNED BY evolution_gerer_mon_contrat_payer_ma_facture_resilier_mon402aba.id;


--
-- Name: evolution_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_id_seq OWNED BY evolution.id;


--
-- Name: evolution_payer_une_facture_editee_par_la_metropole; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_payer_une_facture_editee_par_la_metropole (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_payer_une_facture_editee_par_la_metropole; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_payer_une_facture_editee_par_la_metropole IS 'evolution des demandes Payer une facture éditée par la Métropole';


--
-- Name: evolution_payer_une_facture_editee_par_la_metropole_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_payer_une_facture_editee_par_la_metropole_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_payer_une_facture_editee_par_la_metropole_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_payer_une_facture_editee_par_la_metropole_id_seq OWNED BY evolution_payer_une_facture_editee_par_la_metropole.id;


--
-- Name: evolution_probleme_sur_la_voirie_elus; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_probleme_sur_la_voirie_elus (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_probleme_sur_la_voirie_elus; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_probleme_sur_la_voirie_elus IS 'evolution des demandes Voirie : déclarer un problème';


--
-- Name: evolution_probleme_sur_la_voirie_elus_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_probleme_sur_la_voirie_elus_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_probleme_sur_la_voirie_elus_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_probleme_sur_la_voirie_elus_id_seq OWNED BY evolution_probleme_sur_la_voirie_elus.id;


--
-- Name: evolution_s_abonner; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_s_abonner (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_s_abonner; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_s_abonner IS 'evolution des demandes S''abonner';


--
-- Name: evolution_s_abonner_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_s_abonner_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_s_abonner_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_s_abonner_id_seq OWNED BY evolution_s_abonner.id;


--
-- Name: evolution_se_renseigner_et_participer_aux_appels_a_projetcb79dd; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_se_renseigner_et_participer_aux_appels_a_projetcb79dd (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_se_renseigner_et_participer_aux_appels_a_projetcb79dd; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_se_renseigner_et_participer_aux_appels_a_projetcb79dd IS 'evolution des demandes Se renseigner et participer aux appels à projets, enquêtes publiques, consultations...';


--
-- Name: evolution_se_renseigner_et_participer_aux_appels_a_proje_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_se_renseigner_et_participer_aux_appels_a_proje_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_se_renseigner_et_participer_aux_appels_a_proje_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_se_renseigner_et_participer_aux_appels_a_proje_id_seq OWNED BY evolution_se_renseigner_et_participer_aux_appels_a_projetcb79dd.id;


--
-- Name: evolution_signaler_un_dysfonctionnement_sur_la_voirie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_signaler_un_dysfonctionnement_sur_la_voirie (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_signaler_un_dysfonctionnement_sur_la_voirie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_signaler_un_dysfonctionnement_sur_la_voirie IS 'evolution des demandes Signaler un problème concernant la voirie';


--
-- Name: evolution_signaler_un_dysfonctionnement_sur_la_voirie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_signaler_un_dysfonctionnement_sur_la_voirie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_signaler_un_dysfonctionnement_sur_la_voirie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_signaler_un_dysfonctionnement_sur_la_voirie_id_seq OWNED BY evolution_signaler_un_dysfonctionnement_sur_la_voirie.id;


--
-- Name: evolution_signaler_un_dysfonctionnement_sur_les_dechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_signaler_un_dysfonctionnement_sur_les_dechets (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_signaler_un_dysfonctionnement_sur_les_dechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_signaler_un_dysfonctionnement_sur_les_dechets IS 'evolution des demandes Signaler un problème concernant les déchets';


--
-- Name: evolution_signaler_un_dysfonctionnement_sur_les_dechets_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_signaler_un_dysfonctionnement_sur_les_dechets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_signaler_un_dysfonctionnement_sur_les_dechets_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_signaler_un_dysfonctionnement_sur_les_dechets_id_seq OWNED BY evolution_signaler_un_dysfonctionnement_sur_les_dechets.id;


--
-- Name: evolution_signaler_un_probleme_sur_les_dechets_elus; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_signaler_un_probleme_sur_les_dechets_elus (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_signaler_un_probleme_sur_les_dechets_elus; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_signaler_un_probleme_sur_les_dechets_elus IS 'evolution des demandes Déchets : déclarer un problème';


--
-- Name: evolution_signaler_un_probleme_sur_les_dechets_elus_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_signaler_un_probleme_sur_les_dechets_elus_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_signaler_un_probleme_sur_les_dechets_elus_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_signaler_un_probleme_sur_les_dechets_elus_id_seq OWNED BY evolution_signaler_un_probleme_sur_les_dechets_elus.id;


--
-- Name: evolution_signaler_une_discrimination; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_signaler_une_discrimination (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_signaler_une_discrimination; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_signaler_une_discrimination IS 'evolution des demandes Signaler une discrimination';


--
-- Name: evolution_signaler_une_discrimination_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_signaler_une_discrimination_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_signaler_une_discrimination_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_signaler_une_discrimination_id_seq OWNED BY evolution_signaler_une_discrimination.id;


--
-- Name: evolution_transmettre_mon_releve; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_transmettre_mon_releve (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_transmettre_mon_releve; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_transmettre_mon_releve IS 'evolution des demandes Transmettre mon relevé';


--
-- Name: evolution_transmettre_mon_releve_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_transmettre_mon_releve_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_transmettre_mon_releve_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_transmettre_mon_releve_id_seq OWNED BY evolution_transmettre_mon_releve.id;


--
-- Name: evolution_voirie_magru; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_voirie_magru (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_voirie_magru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_voirie_magru IS 'evolution des demandes Voirie : mes signalements';


--
-- Name: evolution_voirie_magru_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_voirie_magru_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_voirie_magru_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_voirie_magru_id_seq OWNED BY evolution_voirie_magru.id;


--
-- Name: evolution_votre_question_concerne_l_eau_potable; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_votre_question_concerne_l_eau_potable (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_votre_question_concerne_l_eau_potable; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_votre_question_concerne_l_eau_potable IS 'evolution des demandes Demander un renseignement ou signaler un problème concernant l''eau potable';


--
-- Name: evolution_votre_question_concerne_l_eau_potable_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_votre_question_concerne_l_eau_potable_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_votre_question_concerne_l_eau_potable_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_votre_question_concerne_l_eau_potable_id_seq OWNED BY evolution_votre_question_concerne_l_eau_potable.id;


--
-- Name: evolution_votre_question_concerne_les_eaux_usees; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE evolution_votre_question_concerne_les_eaux_usees (
    id integer NOT NULL,
    status_id smallint,
    formdata_id integer,
    "time" timestamp without time zone,
    date date,
    hour_id smallint
);


--
-- Name: TABLE evolution_votre_question_concerne_les_eaux_usees; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE evolution_votre_question_concerne_les_eaux_usees IS 'evolution des demandes Demander un renseignement ou signaler un problème concernant les eaux usées';


--
-- Name: evolution_votre_question_concerne_les_eaux_usees_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE evolution_votre_question_concerne_les_eaux_usees_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: evolution_votre_question_concerne_les_eaux_usees_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE evolution_votre_question_concerne_les_eaux_usees_id_seq OWNED BY evolution_votre_question_concerne_les_eaux_usees.id;


--
-- Name: formdata; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata (
    id integer NOT NULL,
    formdef_id smallint,
    receipt_time date,
    hour_id smallint,
    channel_id smallint,
    backoffice boolean,
    generic_status_id smallint,
    endpoint_delay interval,
    first_agent_id smallint,
    geolocation_base point,
    json_data jsonb
);


--
-- Name: TABLE formdata; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata IS 'tous les formulaires';


--
-- Name: COLUMN formdata.formdef_id; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata.formdef_id IS 'formulaire';


--
-- Name: COLUMN formdata.receipt_time; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata.receipt_time IS 'date de réception';


--
-- Name: COLUMN formdata.hour_id; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata.hour_id IS 'heure';


--
-- Name: COLUMN formdata.channel_id; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata.channel_id IS 'canal';


--
-- Name: COLUMN formdata.backoffice; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata.backoffice IS 'soumission backoffce';


--
-- Name: COLUMN formdata.generic_status_id; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata.generic_status_id IS 'statut simplifié';


--
-- Name: COLUMN formdata.endpoint_delay; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata.endpoint_delay IS 'délai de traitement';


--
-- Name: COLUMN formdata.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata.geolocation_base IS 'position géographique';


--
-- Name: formdata_acceder_aux_services_pour_les_professionnels; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_acceder_aux_services_pour_les_professionnels (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_acceder_aux_services_pour_les_professionnels; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_acceder_aux_services_pour_les_professionnels IS 'formulaire Accéder aux services pour les professionnels';


--
-- Name: COLUMN formdata_acceder_aux_services_pour_les_professionnels.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_acceder_aux_services_pour_les_professionnels.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_candidater_aux_avis_de_marches_publics; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_candidater_aux_avis_de_marches_publics (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_candidater_aux_avis_de_marches_publics; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_candidater_aux_avis_de_marches_publics IS 'formulaire Candidater aux avis de marchés publics';


--
-- Name: COLUMN formdata_candidater_aux_avis_de_marches_publics.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_candidater_aux_avis_de_marches_publics.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_candidater_aux_offres_d_emplois_de_la_metropole; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_candidater_aux_offres_d_emplois_de_la_metropole (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_candidater_aux_offres_d_emplois_de_la_metropole; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_candidater_aux_offres_d_emplois_de_la_metropole IS 'formulaire Candidater aux offres d''emplois de la Métropole';


--
-- Name: COLUMN formdata_candidater_aux_offres_d_emplois_de_la_metropole.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_candidater_aux_offres_d_emplois_de_la_metropole.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_commander_un_bac_un_composteur_ou_un_lombricomposteur; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_commander_un_bac_un_composteur_ou_un_lombricomposteur (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_commander_un_bac_un_composteur_ou_un_lombricomposteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_commander_un_bac_un_composteur_ou_un_lombricomposteur IS 'formulaire Commander un bac, un composteur ou un lombricomposteur';


--
-- Name: COLUMN formdata_commander_un_bac_un_composteur_ou_un_lombricomposteur.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_commander_un_bac_un_composteur_ou_un_lombricomposteur.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_creer_ou_acceder_a_ma_demande_de_logement_social; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_creer_ou_acceder_a_ma_demande_de_logement_social (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_creer_ou_acceder_a_ma_demande_de_logement_social; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_creer_ou_acceder_a_ma_demande_de_logement_social IS 'formulaire Créer ou accéder à ma demande de logement social';


--
-- Name: COLUMN formdata_creer_ou_acceder_a_ma_demande_de_logement_social.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_creer_ou_acceder_a_ma_demande_de_logement_social.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_dechets_mesdechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets (
    geolocation_base point,
    status_id smallint,
    field_qualif_form_decheterie smallint,
    field_qualif_form_collecte smallint,
    field_decheterie smallint,
    field_vip smallint,
    field_code_insee smallint,
    field_commune_stat smallint,
    field_guichet_commune smallint,
    field_secteur smallint,
    field_traite_n1_autorise smallint,
    field_secteur_ou_central smallint,
    field_communication_usager smallint,
    field_retard_stat smallint,
    field_qualification_stat smallint,
    field_origine smallint,
    field_saisie smallint,
    field_niveau_traitement_stat smallint,
    field_role_traite_n2 smallint,
    field_suivi smallint,
    field_hors_delais smallint,
    field_objet smallint,
    field_niveau_traitement smallint,
    function__receiver smallint,
    function__debug smallint,
    function__guichet smallint,
    function__agent_terrain smallint,
    function__guichet_commune smallint,
    function__superviseur smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_dechets_mesdechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets IS 'formulaire Déchets : mes signalements';


--
-- Name: COLUMN formdata_dechets_mesdechets.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.geolocation_base IS 'geoloc';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_qualif_form_decheterie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_qualif_form_decheterie IS 'Précisez la nature du problème :';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_qualif_form_collecte; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_qualif_form_collecte IS 'Précisez : ';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_decheterie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_decheterie IS 'Quelle déchèterie ?';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_vip; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_vip IS 'VIP';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_code_insee IS 'Code Insee commune';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_commune_stat IS 'Commune Stat';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_guichet_commune IS 'Guichet commune';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_secteur IS 'Secteur';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_traite_n1_autorise; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_traite_n1_autorise IS 'Traitement niveau 1 autorisé';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_secteur_ou_central; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_secteur_ou_central IS 'Secteur ou service central';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_communication_usager IS 'Mail envoyé à l''usager';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_retard_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_retard_stat IS 'Relance Stat';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_qualification_stat IS 'Qualification Stat';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_origine IS 'Origine Stat';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_saisie IS 'Saisi par';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_niveau_traitement_stat IS 'Niveau traitement stat';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_role_traite_n2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_role_traite_n2 IS 'Role de traitement niveau 2';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_suivi IS 'Type de suivi Bo';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_hors_delais IS 'Hors délais';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_objet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_objet IS 'Objet de la demande';


--
-- Name: COLUMN formdata_dechets_mesdechets.field_niveau_traitement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.field_niveau_traitement IS 'Supp - Niveau de traitement effectif';


--
-- Name: COLUMN formdata_dechets_mesdechets.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_dechets_mesdechets.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.function__debug IS 'fonction « Testeur »';


--
-- Name: COLUMN formdata_dechets_mesdechets.function__guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.function__guichet IS 'fonction « Guichet Métro »';


--
-- Name: COLUMN formdata_dechets_mesdechets.function__agent_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.function__agent_terrain IS 'fonction « Agent terrain »';


--
-- Name: COLUMN formdata_dechets_mesdechets.function__guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.function__guichet_commune IS 'fonction « Guichet commune »';


--
-- Name: COLUMN formdata_dechets_mesdechets.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_dechets_mesdechets.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: formdata_dechets_mesdechets_field_code_insee; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_code_insee (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_code_insee IS 'valeurs du champ « Code Insee commune » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_code_insee_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_code_insee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_code_insee_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_code_insee_id_seq OWNED BY formdata_dechets_mesdechets_field_code_insee.id;


--
-- Name: formdata_dechets_mesdechets_field_commune_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_commune_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_commune_stat IS 'valeurs du champ « Commune Stat » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_commune_stat_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_commune_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_commune_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_commune_stat_id_seq OWNED BY formdata_dechets_mesdechets_field_commune_stat.id;


--
-- Name: formdata_dechets_mesdechets_field_communication_usager; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_communication_usager (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_communication_usager IS 'valeurs du champ « Mail envoyé à l''usager » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_decheterie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_decheterie (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_decheterie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_decheterie IS 'valeurs du champ « Quelle déchèterie ? » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_decheterie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_decheterie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_decheterie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_decheterie_id_seq OWNED BY formdata_dechets_mesdechets_field_decheterie.id;


--
-- Name: formdata_dechets_mesdechets_field_guichet_commune; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_guichet_commune (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_guichet_commune IS 'valeurs du champ « Guichet commune » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_guichet_commune_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_guichet_commune_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_guichet_commune_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_guichet_commune_id_seq OWNED BY formdata_dechets_mesdechets_field_guichet_commune.id;


--
-- Name: formdata_dechets_mesdechets_field_hors_delais; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_hors_delais (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_hors_delais IS 'valeurs du champ « Hors délais » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_niveau_traitement; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_niveau_traitement (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_niveau_traitement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_niveau_traitement IS 'valeurs du champ « Supp - Niveau de traitement effectif » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_niveau_traitement_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_niveau_traitement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_niveau_traitement_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_niveau_traitement_id_seq OWNED BY formdata_dechets_mesdechets_field_niveau_traitement.id;


--
-- Name: formdata_dechets_mesdechets_field_niveau_traitement_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_niveau_traitement_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_niveau_traitement_stat IS 'valeurs du champ « Niveau traitement stat » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_niveau_traitement_stat_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_niveau_traitement_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_niveau_traitement_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_niveau_traitement_stat_id_seq OWNED BY formdata_dechets_mesdechets_field_niveau_traitement_stat.id;


--
-- Name: formdata_dechets_mesdechets_field_objet; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_objet (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_objet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_objet IS 'valeurs du champ « Objet de la demande » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_objet_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_objet_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_objet_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_objet_id_seq OWNED BY formdata_dechets_mesdechets_field_objet.id;


--
-- Name: formdata_dechets_mesdechets_field_origine; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_origine (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_origine IS 'valeurs du champ « Origine Stat » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_qualif_form_collecte; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_qualif_form_collecte (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_qualif_form_collecte; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_qualif_form_collecte IS 'valeurs du champ « Précisez :  » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_qualif_form_collecte_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_qualif_form_collecte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_qualif_form_collecte_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_qualif_form_collecte_id_seq OWNED BY formdata_dechets_mesdechets_field_qualif_form_collecte.id;


--
-- Name: formdata_dechets_mesdechets_field_qualif_form_decheterie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_qualif_form_decheterie (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_qualif_form_decheterie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_qualif_form_decheterie IS 'valeurs du champ « Précisez la nature du problème : » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_qualif_form_decheterie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_qualif_form_decheterie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_qualif_form_decheterie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_qualif_form_decheterie_id_seq OWNED BY formdata_dechets_mesdechets_field_qualif_form_decheterie.id;


--
-- Name: formdata_dechets_mesdechets_field_qualification_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_qualification_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_qualification_stat IS 'valeurs du champ « Qualification Stat » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_qualification_stat_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_qualification_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_qualification_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_qualification_stat_id_seq OWNED BY formdata_dechets_mesdechets_field_qualification_stat.id;


--
-- Name: formdata_dechets_mesdechets_field_retard_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_retard_stat (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_retard_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_retard_stat IS 'valeurs du champ « Relance Stat » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_role_traite_n2; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_role_traite_n2 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_role_traite_n2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_role_traite_n2 IS 'valeurs du champ « Role de traitement niveau 2 » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_role_traite_n2_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_role_traite_n2_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_role_traite_n2_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_role_traite_n2_id_seq OWNED BY formdata_dechets_mesdechets_field_role_traite_n2.id;


--
-- Name: formdata_dechets_mesdechets_field_saisie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_saisie (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_saisie IS 'valeurs du champ « Saisi par » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_saisie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_saisie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_saisie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_saisie_id_seq OWNED BY formdata_dechets_mesdechets_field_saisie.id;


--
-- Name: formdata_dechets_mesdechets_field_secteur; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_secteur (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_secteur IS 'valeurs du champ « Secteur » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_secteur_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_secteur_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_secteur_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_secteur_id_seq OWNED BY formdata_dechets_mesdechets_field_secteur.id;


--
-- Name: formdata_dechets_mesdechets_field_secteur_ou_central; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_secteur_ou_central (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_secteur_ou_central; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_secteur_ou_central IS 'valeurs du champ « Secteur ou service central » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_secteur_ou_central_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_dechets_mesdechets_field_secteur_ou_central_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_dechets_mesdechets_field_secteur_ou_central_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_dechets_mesdechets_field_secteur_ou_central_id_seq OWNED BY formdata_dechets_mesdechets_field_secteur_ou_central.id;


--
-- Name: formdata_dechets_mesdechets_field_suivi; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_suivi (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_suivi IS 'valeurs du champ « Type de suivi Bo » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_traite_n1_autorise; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_traite_n1_autorise (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_traite_n1_autorise; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_traite_n1_autorise IS 'valeurs du champ « Traitement niveau 1 autorisé » du formulaire Déchets : mes signalements';


--
-- Name: formdata_dechets_mesdechets_field_vip; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_dechets_mesdechets_field_vip (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_dechets_mesdechets_field_vip; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_dechets_mesdechets_field_vip IS 'valeurs du champ « VIP » du formulaire Déchets : mes signalements';


--
-- Name: formdata_declarer_et_payer_ma_taxe_de_sejour; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_declarer_et_payer_ma_taxe_de_sejour (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_declarer_et_payer_ma_taxe_de_sejour; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_declarer_et_payer_ma_taxe_de_sejour IS 'formulaire Déclarer et payer ma taxe de séjour';


--
-- Name: COLUMN formdata_declarer_et_payer_ma_taxe_de_sejour.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_declarer_et_payer_ma_taxe_de_sejour.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof692237; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof692237 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof692237; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof692237 IS 'valeurs du champ « Origine Stat » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq10; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq10
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq10; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq10 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backof692237.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof0f99d4; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof0f99d4 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof0f99d4; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof0f99d4 IS 'valeurs du champ « Commune hors GAM » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq11; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq11
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq11; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq11 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backof0f99d4.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backofe0aeed; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backofe0aeed (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backofe0aeed; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backofe0aeed IS 'valeurs du champ « Qualification Stat » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq12; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq12
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq12; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq12 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backofe0aeed.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backofa151d7; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backofa151d7 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backofa151d7; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backofa151d7 IS 'valeurs du champ « Service potentiel » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq13; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq13
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq13; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq13 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backofa151d7.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backofe5253c; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backofe5253c (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backofe5253c; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backofe5253c IS 'valeurs du champ « Secteur » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq14; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq14
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq14; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq14 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backofe5253c.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backofb29d9e; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backofb29d9e (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backofb29d9e; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backofb29d9e IS 'valeurs du champ « Type de suivi bo » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq15; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq15
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq15; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq15 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backofb29d9e.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof1ce86d; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof1ce86d (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof1ce86d; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof1ce86d IS 'valeurs du champ « Votre commune » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq1; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq1; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq1 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backof1ce86d.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backofdfb460; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backofdfb460 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backofdfb460; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backofdfb460 IS 'valeurs du champ « Souhaitez-vous avoir un suivi de votre demande ? » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq2; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq2
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq2; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq2 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backofdfb460.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof5d307d; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5d307d (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5d307d; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5d307d IS 'valeurs du champ « Rue, boulevard, place, chemin... » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq3; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq3
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq3; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq3 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backof5d307d.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof4b5317; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof4b5317 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof4b5317; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof4b5317 IS 'valeurs du champ « Numéro » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq4; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq4
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq4; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq4 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backof4b5317.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backofbf2c89; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backofbf2c89 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backofbf2c89; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backofbf2c89 IS 'valeurs du champ « Code Insee commune » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq5; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq5
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq5; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq5 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backofbf2c89.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof296f79; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof296f79 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof296f79; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof296f79 IS 'valeurs du champ « alerte wf » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq6; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq6
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq6; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq6 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backof296f79.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backofa4f9eb; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backofa4f9eb (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backofa4f9eb; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backofa4f9eb IS 'valeurs du champ « Commune Stat » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq7; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq7
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq7; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq7 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backofa4f9eb.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof5e8cb3; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5e8cb3 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5e8cb3; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5e8cb3 IS 'valeurs du champ « Niveau traitement stat » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq8; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq8
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq8; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq8 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backof5e8cb3.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backoffa829b; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backoffa829b (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backoffa829b; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backoffa829b IS 'valeurs du champ « Guichet commune » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq9; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq9
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_back_id_seq9; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_back_id_seq9 OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backoffa829b.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof962012; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof962012 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof962012; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof962012 IS 'valeurs du champ « Elle concerne : » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backo_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_backo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backo_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_la_voirie_backo_id_seq OWNED BY formdata_demander_des_renseignements_sur_la_voirie_backof962012.id;


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof055eff; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof055eff (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof055eff; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof055eff IS 'valeurs du champ « Civilité » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof4c310c; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof4c310c (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof4c310c; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof4c310c IS 'valeurs du champ « Mail envoyé à l''usager » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof5dc345; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5dc345 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5dc345; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof5dc345 IS 'valeurs du champ « Origine de la demande » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof617bc4; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof617bc4 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof617bc4; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof617bc4 IS 'valeurs du champ « Hors délais » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backof8a39e5; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backof8a39e5 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backof8a39e5; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backof8a39e5 IS 'valeurs du champ « Marquer la demande comme traitée » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backofd636fd; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backofd636fd (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backofd636fd; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backofd636fd IS 'valeurs du champ « Métro » du formulaire Demander des renseignements sur la voirie';


--
-- Name: formdata_demander_des_renseignements_sur_la_voirie_backoffice; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_la_voirie_backoffice (
    geolocation_base point,
    status_id smallint,
    field_origine_formulaire smallint,
    field_type smallint,
    field_adresse_commune smallint,
    field_civilite smallint,
    field_suivi_formulaire smallint,
    field_traite_formulaire smallint,
    field_nom_voie smallint,
    field_numero_voie smallint,
    field_metro smallint,
    field_code_insee smallint,
    field_alerte smallint,
    field_commune_stat smallint,
    field_niveau_traitement_stat smallint,
    field_communication_usager smallint,
    field_guichet_commune smallint,
    field_origine smallint,
    field_commune_hors_gam smallint,
    field_qualification_stat smallint,
    field_service_potentiel smallint,
    field_secteur smallint,
    field_hors_delais smallint,
    field_suivi smallint,
    function__debug smallint,
    function__receiver smallint,
    function__guichet_commune smallint,
    function__superviseur smallint,
    function__guichet smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_la_voirie_backoffice; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_la_voirie_backoffice IS 'formulaire Demander des renseignements sur la voirie';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.geolocation_base IS 'geoloc';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_origine_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_origine_formulaire IS 'Origine de la demande';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_type; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_type IS 'Elle concerne :';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_adresse_commune IS 'Votre commune';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_civilite; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_civilite IS 'Civilité';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_suivi_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_suivi_formulaire IS 'Souhaitez-vous avoir un suivi de votre demande ?';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_traite_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_traite_formulaire IS 'Marquer la demande comme traitée';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_nom_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_nom_voie IS 'Rue, boulevard, place, chemin...';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_numero_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_numero_voie IS 'Numéro';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_metro; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_metro IS 'Métro';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_code_insee IS 'Code Insee commune';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_alerte; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_alerte IS 'alerte wf';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_commune_stat IS 'Commune Stat';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_niveau_traitement_stat IS 'Niveau traitement stat';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_communication_usager IS 'Mail envoyé à l''usager';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_guichet_commune IS 'Guichet commune';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_origine IS 'Origine Stat';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_commune_hors_gam; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_commune_hors_gam IS 'Commune hors GAM';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_qualification_stat IS 'Qualification Stat';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_service_potentiel; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_service_potentiel IS 'Service potentiel';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_secteur IS 'Secteur';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_hors_delais IS 'Hors délais';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.field_suivi IS 'Type de suivi bo';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__debug IS 'fonction « Testeur »';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__guichet_commune IS 'fonction « Guichet commune »';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_la_voirie_backoffice.function__guichet IS 'fonction « Guichet Métro »';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets (
    geolocation_base point,
    status_id smallint,
    field_origine_formulaire smallint,
    field_type smallint,
    field_qualification_formulaire smallint,
    field_adresse_commune smallint,
    field_civilite smallint,
    field_suivi_formulaire smallint,
    field_traite_formulaire smallint,
    field_nom_voie smallint,
    field_numero_voie smallint,
    field_metro smallint,
    field_guichet_commune smallint,
    field_code_insee smallint,
    field_commune_stat smallint,
    field_traite_n1_autorise smallint,
    field_niveau_traitement smallint,
    field_secteur_ou_central smallint,
    field_secteur smallint,
    field_communication_usager smallint,
    field_qualification smallint,
    field_niveau_traitement_stat smallint,
    field_origine smallint,
    field_qualification_stat smallint,
    field_role_traite_n2 smallint,
    field_commune_hors_gam smallint,
    field_objet smallint,
    field_hors_delais smallint,
    field_suivi smallint,
    field_metro2 smallint,
    field_guichet_commune2 smallint,
    field_commune_stat2 smallint,
    function__receiver smallint,
    function__guichet smallint,
    function__guichet_commune smallint,
    function__debug smallint,
    function__superviseur smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets IS 'formulaire Demander des renseignements sur les déchets';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.geolocation_base IS 'geoloc';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_origine_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_origine_formulaire IS 'Origine de la demande';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_type; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_type IS 'Votre question concerne :';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_qualification_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_qualification_formulaire IS 'Plus précisément, votre demande porte sur :';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_adresse_commune IS 'Votre commune';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_civilite; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_civilite IS 'Civilité';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_suivi_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_suivi_formulaire IS 'Souhaitez-vous avoir un suivi de votre demande ?';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_traite_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_traite_formulaire IS 'Marquer la demande comme traitée';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_nom_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_nom_voie IS 'Rue, boulevard, place, chemin...';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_numero_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_numero_voie IS 'Numéro';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_metro; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_metro IS 'Métro';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_guichet_commune IS 'Guichet commune';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_code_insee IS 'Code Insee commune';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_commune_stat IS 'Commune Stat';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_traite_n1_autorise; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_traite_n1_autorise IS 'Traitement niveau 1 autorisé';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_niveau_traitement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_niveau_traitement IS 'Niveau de traitement effectif';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_secteur_ou_central; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_secteur_ou_central IS 'Secteur ou service central';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_secteur IS 'Secteur';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_communication_usager IS 'Communication usager';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_qualification; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_qualification IS 'Qualification';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_niveau_traitement_stat IS 'Niveau traitement stat';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_origine IS 'Origine Stat';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_qualification_stat IS 'Qualification Stat';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_role_traite_n2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_role_traite_n2 IS 'Role de traitement niveau 2';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_commune_hors_gam; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_commune_hors_gam IS 'Commune hors GAM';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_objet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_objet IS 'Objet de la demande';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_hors_delais IS 'Hors délais';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_suivi IS 'Type de suivi bo';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_metro2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_metro2 IS 'Supp - Métro 2';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_guichet_commune2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_guichet_commune2 IS 'Supp - Guichet commune 2';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_commune_stat2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.field_commune_stat2 IS 'Supp - Commune Stat 2';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__guichet IS 'fonction « Guichet Métro »';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__guichet_commune IS 'fonction « Guichet commune »';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__debug IS 'fonction « Testeur »';


--
-- Name: COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_des_renseignements_sur_les_dechets.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fielac2b60; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fielac2b60 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fielac2b60; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fielac2b60 IS 'valeurs du champ « Niveau de traitement effectif » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq10; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq10
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq10; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq10 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fielac2b60.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel121c99; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel121c99 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel121c99; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel121c99 IS 'valeurs du champ « Secteur ou service central » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq11; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq11
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq11; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq11 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel121c99.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel0072ab; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel0072ab (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel0072ab; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel0072ab IS 'valeurs du champ « Secteur » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq12; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq12
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq12; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq12 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel0072ab.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fielc06cbc; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc06cbc (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc06cbc; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc06cbc IS 'valeurs du champ « Communication usager » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq13; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq13
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq13; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq13 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fielc06cbc.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fielc0f3cb; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc0f3cb (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc0f3cb; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc0f3cb IS 'valeurs du champ « Qualification » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq14; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq14
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq14; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq14 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fielc0f3cb.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel985044; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel985044 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel985044; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel985044 IS 'valeurs du champ « Niveau traitement stat » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq15; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq15
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq15; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq15 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel985044.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel5c806e; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel5c806e (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel5c806e; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel5c806e IS 'valeurs du champ « Origine Stat » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq16; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq16
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq16; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq16 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel5c806e.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiela54bb6; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela54bb6 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela54bb6; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela54bb6 IS 'valeurs du champ « Qualification Stat » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq17; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq17
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq17; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq17 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiela54bb6.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel771713; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel771713 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel771713; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel771713 IS 'valeurs du champ « Role de traitement niveau 2 » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq18; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq18
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq18; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq18 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel771713.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel346d3b; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel346d3b (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel346d3b; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel346d3b IS 'valeurs du champ « Commune hors GAM » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq19; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq19
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq19; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq19 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel346d3b.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fielc135c3; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc135c3 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc135c3; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc135c3 IS 'valeurs du champ « Objet de la demande » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq20; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq20
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq20; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq20 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fielc135c3.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiela2fe26; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela2fe26 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela2fe26; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela2fe26 IS 'valeurs du champ « Type de suivi bo » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq21; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq21
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq21; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq21 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiela2fe26.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel91a9b9; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel91a9b9 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel91a9b9; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel91a9b9 IS 'valeurs du champ « Supp - Métro 2 » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq22; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq22
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq22; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq22 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel91a9b9.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel0074b5; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel0074b5 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel0074b5; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel0074b5 IS 'valeurs du champ « Supp - Guichet commune 2 » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq23; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq23
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq23; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq23 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel0074b5.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel6c50a9; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel6c50a9 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel6c50a9; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel6c50a9 IS 'valeurs du champ « Supp - Commune Stat 2 » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq24; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq24
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_f_id_seq24; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_f_id_seq24 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel6c50a9.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fieldd4246; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldd4246 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldd4246; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldd4246 IS 'valeurs du champ « Plus précisément, votre demande porte sur : » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq1; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq1; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq1 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fieldd4246.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel977bc5; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel977bc5 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel977bc5; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel977bc5 IS 'valeurs du champ « Votre commune » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq2; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq2
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq2; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq2 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel977bc5.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel910272; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel910272 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel910272; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel910272 IS 'valeurs du champ « Souhaitez-vous avoir un suivi de votre demande ? » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq3; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq3
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq3; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq3 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel910272.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel4eae74; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel4eae74 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel4eae74; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel4eae74 IS 'valeurs du champ « Rue, boulevard, place, chemin... » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq4; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq4
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq4; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq4 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel4eae74.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fieldfac8c; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldfac8c (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldfac8c; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldfac8c IS 'valeurs du champ « Numéro » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq5; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq5
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq5; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq5 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fieldfac8c.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiela9003b; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela9003b (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela9003b; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela9003b IS 'valeurs du champ « Guichet commune » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq6; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq6
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq6; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq6 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiela9003b.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fielbf42fe; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fielbf42fe (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fielbf42fe; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fielbf42fe IS 'valeurs du champ « Code Insee commune » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq7; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq7
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq7; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq7 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fielbf42fe.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel75eabc; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel75eabc (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel75eabc; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel75eabc IS 'valeurs du champ « Commune Stat » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq8; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq8
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq8; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq8 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel75eabc.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel61a26f; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel61a26f (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel61a26f; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel61a26f IS 'valeurs du champ « Traitement niveau 1 autorisé » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq9; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq9
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq9; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq9 OWNED BY formdata_demander_des_renseignements_sur_les_dechets_fiel61a26f.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_field_type; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_field_type (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_field_type; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_field_type IS 'valeurs du champ « Votre question concerne : » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_des_renseignements_sur_les_dechets_fie_id_seq OWNED BY formdata_demander_des_renseignements_sur_les_dechets_field_type.id;


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel6153c9; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel6153c9 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel6153c9; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel6153c9 IS 'valeurs du champ « Civilité » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiel628fd3; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel628fd3 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel628fd3; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiel628fd3 IS 'valeurs du champ « Hors délais » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fiela817fa; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela817fa (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela817fa; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fiela817fa IS 'valeurs du champ « Origine de la demande » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fielc5baec; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc5baec (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc5baec; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fielc5baec IS 'valeurs du champ « Marquer la demande comme traitée » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_des_renseignements_sur_les_dechets_fieldbf338; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldbf338 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldbf338; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_des_renseignements_sur_les_dechets_fieldbf338 IS 'valeurs du champ « Métro » du formulaire Demander des renseignements sur les déchets';


--
-- Name: formdata_demander_un_badge_d_acces_a_une_zone_pietonne; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_badge_d_acces_a_une_zone_pietonne (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_un_badge_d_acces_a_une_zone_pietonne; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_badge_d_acces_a_une_zone_pietonne IS 'formulaire Demander un badge d''accès à une zone piétonne';


--
-- Name: COLUMN formdata_demander_un_badge_d_acces_a_une_zone_pietonne.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_badge_d_acces_a_une_zone_pietonne.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_un_renseignement_a_d_autres_services; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_a_d_autres_services (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_un_renseignement_a_d_autres_services; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_a_d_autres_services IS 'formulaire Demander un renseignement à d''autres services';


--
-- Name: COLUMN formdata_demander_un_renseignement_a_d_autres_services.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_a_d_autres_services.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_un_renseignement_concernant_l_economie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_l_economie (
    status_id smallint,
    field_objet_demande smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_l_economie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_l_economie IS 'formulaire Demander un renseignement concernant l''économie ou le tourisme';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_l_economie.field_objet_demande; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_l_economie.field_objet_demande IS 'Elle concerne :';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_l_economie.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_l_economie.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_un_renseignement_concernant_l_economie_67ce21; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_l_economie_67ce21 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_l_economie_67ce21; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_l_economie_67ce21 IS 'valeurs du champ « Elle concerne : » du formulaire Demander un renseignement concernant l''économie ou le tourisme';


--
-- Name: formdata_demander_un_renseignement_concernant_l_urbanisme0f7c9c; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_l_urbanisme0f7c9c (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_l_urbanisme0f7c9c; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_l_urbanisme0f7c9c IS 'valeurs du champ « Elle concerne : » du formulaire Demander un renseignement concernant l''urbanisme';


--
-- Name: formdata_demander_un_renseignement_concernant_l_urbanism_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_un_renseignement_concernant_l_urbanism_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_un_renseignement_concernant_l_urbanism_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_un_renseignement_concernant_l_urbanism_id_seq OWNED BY formdata_demander_un_renseignement_concernant_l_urbanisme0f7c9c.id;


--
-- Name: formdata_demander_un_renseignement_concernant_l_urbanisme; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_l_urbanisme (
    status_id smallint,
    field_objet_demande smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_l_urbanisme; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_l_urbanisme IS 'formulaire Demander un renseignement concernant l''urbanisme';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_l_urbanisme.field_objet_demande; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_l_urbanisme.field_objet_demande IS 'Elle concerne :';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_l_urbanisme.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_l_urbanisme.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_un_renseignement_concernant_la_directio6b537b; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_la_directio6b537b (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_la_directio6b537b; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_la_directio6b537b IS 'valeurs du champ « Commune » du formulaire Demander un renseignement concernant la direction de la communication';


--
-- Name: formdata_demander_un_renseignement_concernant_la_directi_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_demander_un_renseignement_concernant_la_directi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_demander_un_renseignement_concernant_la_directi_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_demander_un_renseignement_concernant_la_directi_id_seq OWNED BY formdata_demander_un_renseignement_concernant_la_directio6b537b.id;


--
-- Name: formdata_demander_un_renseignement_concernant_la_directio0af105; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_la_directio0af105 (
    status_id smallint,
    field_adresse_commune smallint,
    field_objet_demande smallint,
    function__receiver smallint,
    function__superviseur smallint,
    function__debug smallint,
    function__testeur smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_la_directio0af105; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_la_directio0af105 IS 'formulaire Demander un renseignement concernant la direction de la communication';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.field_adresse_commune IS 'Commune';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.field_objet_demande; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.field_objet_demande IS 'Elle concerne :';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.function__debug IS 'fonction « Debug »';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.function__testeur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_la_directio0af105.function__testeur IS 'fonction « Testeur »';


--
-- Name: formdata_demander_un_renseignement_concernant_la_directio2454ba; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_la_directio2454ba (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_la_directio2454ba; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_la_directio2454ba IS 'valeurs du champ « Elle concerne : » du formulaire Demander un renseignement concernant la direction de la communication';


--
-- Name: formdata_demander_un_renseignement_concernant_le_logement; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_le_logement (
    status_id smallint,
    field_objet_demande smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_le_logement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_le_logement IS 'formulaire Demander un renseignement concernant le logement';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_le_logement.field_objet_demande; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_le_logement.field_objet_demande IS 'Elle concerne :';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_le_logement.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_le_logement.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_un_renseignement_concernant_le_logement56697d; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_le_logement56697d (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_le_logement56697d; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_le_logement56697d IS 'valeurs du champ « Elle concerne : » du formulaire Demander un renseignement concernant le logement';


--
-- Name: formdata_demander_un_renseignement_concernant_les_ressour78a2e1; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_les_ressour78a2e1 (
    status_id smallint,
    field_objet_demande smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_les_ressour78a2e1; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_les_ressour78a2e1 IS 'formulaire Demander un renseignement concernant les ressources humaines';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_les_ressour78a2e1.field_objet_demande; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_les_ressour78a2e1.field_objet_demande IS 'Objet';


--
-- Name: COLUMN formdata_demander_un_renseignement_concernant_les_ressour78a2e1.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_renseignement_concernant_les_ressour78a2e1.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_un_renseignement_concernant_les_ressourdf2824; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_renseignement_concernant_les_ressourdf2824 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_demander_un_renseignement_concernant_les_ressourdf2824; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_renseignement_concernant_les_ressourdf2824 IS 'valeurs du champ « Objet » du formulaire Demander un renseignement concernant les ressources humaines';


--
-- Name: formdata_demander_un_stage; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_un_stage (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_un_stage; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_un_stage IS 'formulaire Demander un stage';


--
-- Name: COLUMN formdata_demander_un_stage.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_un_stage.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_une_alternance; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_une_alternance (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_une_alternance; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_une_alternance IS 'formulaire Demander une alternance';


--
-- Name: COLUMN formdata_demander_une_alternance.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_une_alternance.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_demander_une_autorisation_de_stationnement; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_demander_une_autorisation_de_stationnement (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_demander_une_autorisation_de_stationnement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_demander_une_autorisation_de_stationnement IS 'formulaire Demander une autorisation de stationnement';


--
-- Name: COLUMN formdata_demander_une_autorisation_de_stationnement.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_demander_une_autorisation_de_stationnement.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_envoyer_une_candidature_spontanee; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_envoyer_une_candidature_spontanee (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_envoyer_une_candidature_spontanee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_envoyer_une_candidature_spontanee IS 'formulaire Envoyer une candidature spontanée';


--
-- Name: COLUMN formdata_envoyer_une_candidature_spontanee.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_envoyer_une_candidature_spontanee.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_gerer_mon_contrat_payer_ma_facture_resilier_mon_505224; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_gerer_mon_contrat_payer_ma_facture_resilier_mon_505224 (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_gerer_mon_contrat_payer_ma_facture_resilier_mon_505224; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_gerer_mon_contrat_payer_ma_facture_resilier_mon_505224 IS 'formulaire Gérer mon contrat, payer ma facture, résilier mon abonnement';


--
-- Name: COLUMN formdata_gerer_mon_contrat_payer_ma_facture_resilier_mon_505224.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_gerer_mon_contrat_payer_ma_facture_resilier_mon_505224.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_id_seq OWNED BY formdata.id;


--
-- Name: formdata_payer_une_facture_editee_par_la_metropole; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_payer_une_facture_editee_par_la_metropole (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_payer_une_facture_editee_par_la_metropole; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_payer_une_facture_editee_par_la_metropole IS 'formulaire Payer une facture éditée par la Métropole';


--
-- Name: COLUMN formdata_payer_une_facture_editee_par_la_metropole.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_payer_une_facture_editee_par_la_metropole.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_probleme_sur_la_voirie_elus; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus (
    geolocation_base point,
    status_id smallint,
    field_type_terrain smallint,
    field_motif_intervention_terrain smallint,
    field_code_insee smallint,
    field_adresse_commune smallint,
    field_commune_stat smallint,
    field_guichet_commune smallint,
    field_secteur smallint,
    field_communication_usager smallint,
    field_niveau_traitement smallint,
    field_service_traitant_gru smallint,
    field_niveau_traitement_stat smallint,
    field_qualification_stat smallint,
    field_type_intervention_gru smallint,
    field_reponse_directe smallint,
    field_suivi smallint,
    field_origine smallint,
    field_adresse_signalement_numero smallint,
    field_adresse_signalement_voie smallint,
    field_saisie smallint,
    field_hors_delais smallint,
    field_mode_de_contact_stat smallint,
    function__receiver smallint,
    function__guichet smallint,
    function__debug smallint,
    function__agent_terrain smallint,
    function__guichet_commune smallint,
    function__superviseur smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus IS 'formulaire Voirie : déclarer un problème';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.geolocation_base IS 'geoloc';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_type_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_type_terrain IS 'Objet';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_motif_intervention_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_motif_intervention_terrain IS 'Motif de l''intervention';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_code_insee IS 'Code Insee commune';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_adresse_commune IS 'Commune';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_commune_stat IS 'Commune Stat';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_guichet_commune IS 'Guichet commune';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_secteur IS 'Secteur';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_communication_usager IS 'Mail envoyé à l''usager';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_niveau_traitement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_niveau_traitement IS 'Niveau de traitement effectif';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_service_traitant_gru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_service_traitant_gru IS 'Service traitant GRU';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_niveau_traitement_stat IS 'Niveau traitement stat';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_qualification_stat IS 'Qualification Stat';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_type_intervention_gru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_type_intervention_gru IS 'Type intervention GRU';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_reponse_directe; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_reponse_directe IS 'Réponse directe';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_suivi IS 'Type de suivi bo';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_origine IS 'Origine Stat';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_adresse_signalement_numero; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_adresse_signalement_numero IS 'Numéro';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_adresse_signalement_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_adresse_signalement_voie IS 'Voie';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_saisie IS 'Saisi par (liste)';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_hors_delais IS 'Hors délais';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.field_mode_de_contact_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.field_mode_de_contact_stat IS 'SUPP - Mode de contact Stat';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.function__guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.function__guichet IS 'fonction « Guichet Métro »';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.function__debug IS 'fonction « Testeur »';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.function__agent_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.function__agent_terrain IS 'fonction « Agent terrain »';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.function__guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.function__guichet_commune IS 'fonction « Guichet commune »';


--
-- Name: COLUMN formdata_probleme_sur_la_voirie_elus.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_probleme_sur_la_voirie_elus.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_commune; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_commune (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_commune IS 'valeurs du champ « Commune » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_commu_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_adresse_commu_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_commu_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_adresse_commu_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_adresse_commune.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_signal7c032d; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_signal7c032d (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_signal7c032d; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_signal7c032d IS 'valeurs du champ « Voie » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_sign_id_seq1; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_adresse_sign_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_sign_id_seq1; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_adresse_sign_id_seq1 OWNED BY formdata_probleme_sur_la_voirie_elus_field_adresse_signal7c032d.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_signalbea464; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_signalbea464 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_signalbea464; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_adresse_signalbea464 IS 'valeurs du champ « Numéro » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_signa_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_adresse_signa_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_adresse_signa_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_adresse_signa_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_adresse_signalbea464.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_code_insee; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_code_insee (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_code_insee IS 'valeurs du champ « Code Insee commune » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_code_insee_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_code_insee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_code_insee_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_code_insee_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_code_insee.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_commune_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_commune_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_commune_stat IS 'valeurs du champ « Commune Stat » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_commune_stat_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_commune_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_commune_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_commune_stat_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_commune_stat.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_communication_usager; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_communication_usager (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_communication_usager IS 'valeurs du champ « Mail envoyé à l''usager » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_guichet_commune; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_guichet_commune (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_guichet_commune IS 'valeurs du champ « Guichet commune » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_guichet_commu_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_guichet_commu_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_guichet_commu_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_guichet_commu_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_guichet_commune.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_hors_delais; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_hors_delais (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_hors_delais IS 'valeurs du champ « Hors délais » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_mode_de_contact_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_mode_de_contact_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_mode_de_contact_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_mode_de_contact_stat IS 'valeurs du champ « SUPP - Mode de contact Stat » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_mode_de_conta_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_mode_de_conta_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_mode_de_conta_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_mode_de_conta_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_mode_de_contact_stat.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_motif_intervend38b25; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_motif_intervend38b25 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_motif_intervend38b25; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_motif_intervend38b25 IS 'valeurs du champ « Motif de l''intervention » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_motif_interve_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_motif_interve_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_motif_interve_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_motif_interve_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_motif_intervend38b25.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_niveau_traiteme57649; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_niveau_traiteme57649 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_niveau_traiteme57649; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_niveau_traiteme57649 IS 'valeurs du champ « Niveau traitement stat » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_niveau_traite_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_niveau_traite_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_niveau_traite_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_niveau_traite_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_niveau_traiteme57649.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_niveau_traitement; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_niveau_traitement (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_niveau_traitement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_niveau_traitement IS 'valeurs du champ « Niveau de traitement effectif » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_origine; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_origine (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_origine IS 'valeurs du champ « Origine Stat » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_qualification_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_qualification_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_qualification_stat IS 'valeurs du champ « Qualification Stat » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_qualification_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_qualification_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_qualification_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_qualification_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_qualification_stat.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_reponse_directe; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_reponse_directe (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_reponse_directe; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_reponse_directe IS 'valeurs du champ « Réponse directe » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_reponse_direc_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_reponse_direc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_reponse_direc_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_reponse_direc_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_reponse_directe.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_saisie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_saisie (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_saisie IS 'valeurs du champ « Saisi par (liste) » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_saisie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_saisie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_saisie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_saisie_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_saisie.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_secteur; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_secteur (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_secteur IS 'valeurs du champ « Secteur » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_secteur_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_secteur_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_secteur_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_secteur_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_secteur.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_service_traitant_gru; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_service_traitant_gru (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_service_traitant_gru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_service_traitant_gru IS 'valeurs du champ « Service traitant GRU » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_service_trait_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_service_trait_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_service_trait_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_service_trait_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_service_traitant_gru.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_suivi; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_suivi (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_suivi IS 'valeurs du champ « Type de suivi bo » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_type_intervent3f537c; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_type_intervent3f537c (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_type_intervent3f537c; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_type_intervent3f537c IS 'valeurs du champ « Type intervention GRU » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_type_interven_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_type_interven_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_type_interven_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_type_interven_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_type_intervent3f537c.id;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_type_terrain; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_probleme_sur_la_voirie_elus_field_type_terrain (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_probleme_sur_la_voirie_elus_field_type_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_probleme_sur_la_voirie_elus_field_type_terrain IS 'valeurs du champ « Objet » du formulaire Voirie : déclarer un problème';


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_type_terrain_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_probleme_sur_la_voirie_elus_field_type_terrain_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_probleme_sur_la_voirie_elus_field_type_terrain_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_probleme_sur_la_voirie_elus_field_type_terrain_id_seq OWNED BY formdata_probleme_sur_la_voirie_elus_field_type_terrain.id;


--
-- Name: formdata_s_abonner; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_s_abonner (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_s_abonner; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_s_abonner IS 'formulaire S''abonner';


--
-- Name: COLUMN formdata_s_abonner.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_s_abonner.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_se_renseigner_et_participer_aux_appels_a_projets7201df; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_se_renseigner_et_participer_aux_appels_a_projets7201df (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_se_renseigner_et_participer_aux_appels_a_projets7201df; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_se_renseigner_et_participer_aux_appels_a_projets7201df IS 'formulaire Se renseigner et participer aux appels à projets, enquêtes publiques, consultations...';


--
-- Name: COLUMN formdata_se_renseigner_et_participer_aux_appels_a_projets7201df.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_se_renseigner_et_participer_aux_appels_a_projets7201df.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie (
    geolocation_base point,
    status_id smallint,
    field_type_guichet smallint,
    field_motif_intervention_guichet smallint,
    field_mode_de_contact_guichet smallint,
    field_adresse_commune_guichet smallint,
    field_adresse_signalement_voie_guichet smallint,
    field_adresse_signalement_numero_guichet smallint,
    field_type_adresse_guichet smallint,
    field_type_numero_guichet smallint,
    field_suivi_formulaire_guichet smallint,
    field_civilite_guichet smallint,
    field_civilite_usager smallint,
    field_suivi_formulaire_usager smallint,
    field_type_terrain smallint,
    field_motif_intervention_terrain smallint,
    field_type_adresse_terrain smallint,
    field_type_numero_terrain smallint,
    field_code_insee smallint,
    field_adresse_commune smallint,
    field_commune_stat smallint,
    field_guichet_commune smallint,
    field_secteur smallint,
    field_communication_usager smallint,
    field_niveau_traitement smallint,
    field_service_traitant_gru smallint,
    field_niveau_traitement_stat smallint,
    field_qualification_stat smallint,
    field_type_intervention_gru smallint,
    field_reponse_directe smallint,
    field_suivi smallint,
    field_origine smallint,
    field_adresse_signalement_numero smallint,
    field_adresse_signalement_voie smallint,
    field_saisie smallint,
    field_hors_delais smallint,
    field_mode_de_contact_stat smallint,
    function__receiver smallint,
    function__guichet smallint,
    function__debug smallint,
    function__agent_terrain smallint,
    function__guichet_commune smallint,
    function__superviseur smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie IS 'formulaire Signaler un problème concernant la voirie';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.geolocation_base IS 'geoloc';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_guichet IS 'Objet du signalement';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_motif_intervention_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_motif_intervention_guichet IS 'Motif de l''intervention';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_mode_de_contact_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_mode_de_contact_guichet IS 'Mode de contact';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_commune_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_commune_guichet IS 'Commune';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_signalement_voie_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_signalement_voie_guichet IS 'Voie';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_signalement_numero_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_signalement_numero_guichet IS 'Numéro';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_adresse_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_adresse_guichet IS 'Type d''adresse';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_numero_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_numero_guichet IS 'Type de numéro';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_suivi_formulaire_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_suivi_formulaire_guichet IS 'Vous souhaitez avoir un suivi de votre demande';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_civilite_guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_civilite_guichet IS 'Civilité';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_civilite_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_civilite_usager IS 'Civilité';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_suivi_formulaire_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_suivi_formulaire_usager IS 'Comment souhaitez-vous suivre votre demande ?';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_terrain IS 'Objet du signalement';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_motif_intervention_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_motif_intervention_terrain IS 'Motif de l''intervention';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_adresse_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_adresse_terrain IS 'Type d''adresse';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_numero_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_numero_terrain IS 'Type de numéro';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_code_insee IS 'Code Insee commune';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_commune IS 'Commune';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_commune_stat IS 'Commune Stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_guichet_commune IS 'Guichet commune';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_secteur IS 'Secteur';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_communication_usager IS 'Mail envoyé à l''usager';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_niveau_traitement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_niveau_traitement IS 'Niveau de traitement effectif';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_service_traitant_gru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_service_traitant_gru IS 'Service traitant GRU';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_niveau_traitement_stat IS 'Niveau traitement stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_qualification_stat IS 'Qualification Stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_intervention_gru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_type_intervention_gru IS 'Type intervention GRU';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_reponse_directe; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_reponse_directe IS 'Réponse directe';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_suivi IS 'Type de suivi bo';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_origine IS 'Origine Stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_signalement_numero; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_signalement_numero IS 'Numéro';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_signalement_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_adresse_signalement_voie IS 'Voie';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_saisie IS 'Saisi par (liste)';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_hors_delais IS 'Hors délais';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_mode_de_contact_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.field_mode_de_contact_stat IS 'SUPP - Mode de contact Stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__guichet IS 'fonction « Guichet Métro »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__debug IS 'fonction « Testeur »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__agent_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__agent_terrain IS 'fonction « Agent terrain »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__guichet_commune IS 'fonction « Guichet commune »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_la_voirie.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel15bea7; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel15bea7 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel15bea7; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel15bea7 IS 'valeurs du champ « Type d''adresse » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq10; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq10
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq10; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq10 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel15bea7.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela48dc3; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela48dc3 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela48dc3; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela48dc3 IS 'valeurs du champ « Type de numéro » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq11; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq11
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq11; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq11 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela48dc3.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4db287; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4db287 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4db287; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4db287 IS 'valeurs du champ « Code Insee commune » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq12; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq12
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq12; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq12 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4db287.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_field4bdd6; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_field4bdd6 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_field4bdd6; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_field4bdd6 IS 'valeurs du champ « Commune » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq13; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq13
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq13; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq13 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_field4bdd6.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel984ad4; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel984ad4 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel984ad4; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel984ad4 IS 'valeurs du champ « Commune Stat » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq14; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq14
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq14; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq14 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel984ad4.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fieladf2a2; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fieladf2a2 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fieladf2a2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fieladf2a2 IS 'valeurs du champ « Guichet commune » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq15; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq15
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq15; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq15 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fieladf2a2.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel7a9be8; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel7a9be8 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel7a9be8; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel7a9be8 IS 'valeurs du champ « Secteur » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq16; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq16
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq16; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq16 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel7a9be8.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel291910; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel291910 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel291910; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel291910 IS 'valeurs du champ « Service traitant GRU » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq17; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq17
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq17; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq17 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel291910.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel24eaf9; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel24eaf9 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel24eaf9; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel24eaf9 IS 'valeurs du champ « Niveau traitement stat » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq18; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq18
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq18; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq18 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel24eaf9.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1ac29; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1ac29 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1ac29; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1ac29 IS 'valeurs du champ « Qualification Stat » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq19; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq19
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq19; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq19 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1ac29.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb99979; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb99979 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb99979; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb99979 IS 'valeurs du champ « Type intervention GRU » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq20; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq20
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq20; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq20 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb99979.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel83a93d; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel83a93d (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel83a93d; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel83a93d IS 'valeurs du champ « Réponse directe » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq21; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq21
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq21; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq21 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel83a93d.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela60d12; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela60d12 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela60d12; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela60d12 IS 'valeurs du champ « Numéro » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq22; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq22
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq22; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq22 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela60d12.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel281775; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel281775 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel281775; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel281775 IS 'valeurs du champ « Voie » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq23; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq23
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq23; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq23 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel281775.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_field7025b; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_field7025b (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_field7025b; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_field7025b IS 'valeurs du champ « Saisi par (liste) » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq24; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq24
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq24; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq24 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_field7025b.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4ccb3e; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4ccb3e (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4ccb3e; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4ccb3e IS 'valeurs du champ « SUPP - Mode de contact Stat » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq25; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq25
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq25; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq25 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4ccb3e.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel57d802; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel57d802 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel57d802; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel57d802 IS 'valeurs du champ « Motif de l''intervention » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq1; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq1; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq1 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel57d802.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1b6b99; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1b6b99 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1b6b99; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1b6b99 IS 'valeurs du champ « Mode de contact » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq2; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq2
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq2; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq2 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1b6b99.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel6b1edc; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel6b1edc (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel6b1edc; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel6b1edc IS 'valeurs du champ « Commune » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq3; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq3
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq3; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq3 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel6b1edc.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiele0d169; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiele0d169 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiele0d169; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiele0d169 IS 'valeurs du champ « Voie » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq4; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq4
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq4; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq4 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiele0d169.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf8bd75; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf8bd75 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf8bd75; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf8bd75 IS 'valeurs du champ « Numéro » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq5; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq5
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq5; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq5 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf8bd75.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1bea01; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1bea01 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1bea01; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1bea01 IS 'valeurs du champ « Type d''adresse » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq6; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq6
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq6; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq6 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1bea01.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb1ac20; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb1ac20 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb1ac20; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb1ac20 IS 'valeurs du champ « Type de numéro » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq7; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq7
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq7; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq7 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb1ac20.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb4ac9e; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb4ac9e (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb4ac9e; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb4ac9e IS 'valeurs du champ « Objet du signalement » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq8; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq8
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq8; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq8 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb4ac9e.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel74395b; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel74395b (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel74395b; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel74395b IS 'valeurs du champ « Motif de l''intervention » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq9; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq9
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq9; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq9 OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel74395b.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel75cfdb; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel75cfdb (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel75cfdb; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel75cfdb IS 'valeurs du champ « Objet du signalement » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fie_id_seq OWNED BY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel75cfdb.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel01ba2c; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel01ba2c (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel01ba2c; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel01ba2c IS 'valeurs du champ « Comment souhaitez-vous suivre votre demande ? » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1c7dc6; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1c7dc6 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1c7dc6; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1c7dc6 IS 'valeurs du champ « Civilité » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel2298b6; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel2298b6 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel2298b6; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel2298b6 IS 'valeurs du champ « Vous souhaitez avoir un suivi de votre demande » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel2cd243; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel2cd243 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel2cd243; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel2cd243 IS 'valeurs du champ « Mail envoyé à l''usager » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel3a3b51; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel3a3b51 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel3a3b51; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel3a3b51 IS 'valeurs du champ « Hors délais » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel47d11f; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel47d11f (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel47d11f; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel47d11f IS 'valeurs du champ « Origine Stat » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel54d3c9; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel54d3c9 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel54d3c9; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel54d3c9 IS 'valeurs du champ « Type de suivi bo » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel8a552b; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel8a552b (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel8a552b; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel8a552b IS 'valeurs du champ « Civilité » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1f2de; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1f2de (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1f2de; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1f2de IS 'valeurs du champ « Niveau de traitement effectif » du formulaire Signaler un problème concernant la voirie';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets (
    geolocation_base point,
    status_id smallint,
    field_type smallint,
    field_decheterie smallint,
    field_adresse_commune smallint,
    field_adresse_signalement_voie smallint,
    field_adresse_signalement_numero smallint,
    field_origine_formulaire smallint,
    field_suivi_formulaire smallint,
    field_vip smallint,
    field_code_insee smallint,
    field_commune_stat smallint,
    field_guichet_commune smallint,
    field_secteur smallint,
    field_traite_n1_autorise smallint,
    field_secteur_ou_central smallint,
    field_communication_usager smallint,
    field_retard_stat smallint,
    field_qualification_stat smallint,
    field_origine smallint,
    field_saisie smallint,
    field_niveau_traitement_stat smallint,
    field_role_traite_n2 smallint,
    field_suivi smallint,
    field_hors_delais smallint,
    field_objet smallint,
    field_niveau_traitement smallint,
    function__receiver smallint,
    function__debug smallint,
    function__guichet smallint,
    function__agent_terrain smallint,
    function__guichet_commune smallint,
    function__superviseur smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets IS 'formulaire Signaler un problème concernant les déchets';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.geolocation_base IS 'geoloc';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_type; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_type IS 'Le problème concerne :';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_decheterie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_decheterie IS 'Sélectionnez la déchèterie concernée';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_adresse_commune IS 'Commune';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_adresse_signalement_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_adresse_signalement_voie IS 'Voie';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_adresse_signalement_numero; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_adresse_signalement_numero IS 'Numéro';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_origine_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_origine_formulaire IS 'Origine de la demande';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_suivi_formulaire; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_suivi_formulaire IS 'Comment souhaitez-vous suivre votre demande ?';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_vip; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_vip IS 'VIP';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_code_insee IS 'Code Insee commune';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_commune_stat IS 'Commune Stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_guichet_commune IS 'Guichet commune';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_secteur IS 'Secteur';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_traite_n1_autorise; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_traite_n1_autorise IS 'Traitement niveau 1 autorisé';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_secteur_ou_central; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_secteur_ou_central IS 'Secteur ou service central';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_communication_usager IS 'Mail envoyé à l''usager';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_retard_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_retard_stat IS 'Relance Stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_qualification_stat IS 'Qualification Stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_origine IS 'Origine Stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_saisie IS 'Saisi par';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_niveau_traitement_stat IS 'Niveau traitement stat';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_role_traite_n2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_role_traite_n2 IS 'Role de traitement niveau 2';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_suivi IS 'Type de suivi Bo';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_hors_delais IS 'Hors délais';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_objet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_objet IS 'Objet de la demande';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_niveau_traitement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.field_niveau_traitement IS 'Supp - Niveau de traitement effectif';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__debug IS 'fonction « Testeur »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__guichet IS 'fonction « Guichet Métro »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__agent_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__agent_terrain IS 'fonction « Agent terrain »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__guichet_commune IS 'fonction « Guichet commune »';


--
-- Name: COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_dysfonctionnement_sur_les_dechets.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi245373; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi245373 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi245373; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi245373 IS 'valeurs du champ « Sélectionnez la déchèterie concernée » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq1; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq1; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq1 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi245373.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fide6710; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fide6710 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fide6710; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fide6710 IS 'valeurs du champ « Commune » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq2; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq2
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq2; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq2 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fide6710.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi20702a; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi20702a (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi20702a; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi20702a IS 'valeurs du champ « Voie » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq3; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq3
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq3; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq3 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi20702a.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fiedf817; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fiedf817 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fiedf817; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fiedf817 IS 'valeurs du champ « Numéro » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq4; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq4
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq4; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq4 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fiedf817.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi51fe10; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi51fe10 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi51fe10; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi51fe10 IS 'valeurs du champ « Comment souhaitez-vous suivre votre demande ? » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq5; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq5
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq5; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq5 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi51fe10.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib2bc25; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib2bc25 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib2bc25; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib2bc25 IS 'valeurs du champ « Code Insee commune » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq6; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq6
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq6; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq6 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib2bc25.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fifdc07e; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fifdc07e (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fifdc07e; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fifdc07e IS 'valeurs du champ « Commune Stat » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq7; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq7
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq7; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq7 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fifdc07e.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fid4beeb; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fid4beeb (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fid4beeb; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fid4beeb IS 'valeurs du champ « Guichet commune » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq8; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq8
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq8; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq8 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fid4beeb.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi8670e9; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi8670e9 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi8670e9; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi8670e9 IS 'valeurs du champ « Secteur » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq9; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq9
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq9; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq9 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi8670e9.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4fdc2a; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4fdc2a (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4fdc2a; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4fdc2a IS 'valeurs du champ « Le problème concerne : » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_f_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_f_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_f_id_seq OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4fdc2a.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi00a915; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi00a915 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi00a915; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi00a915 IS 'valeurs du champ « Secteur ou service central » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi1164c5; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi1164c5 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi1164c5; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi1164c5 IS 'valeurs du champ « Niveau traitement stat » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi16e5df; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi16e5df (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi16e5df; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi16e5df IS 'valeurs du champ « Origine de la demande » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi36dcd7; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi36dcd7 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi36dcd7; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi36dcd7 IS 'valeurs du champ « Traitement niveau 1 autorisé » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi3e1224; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi3e1224 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi3e1224; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi3e1224 IS 'valeurs du champ « Role de traitement niveau 2 » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4ca6f3; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4ca6f3 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4ca6f3; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4ca6f3 IS 'valeurs du champ « Saisi par » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi6424db; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi6424db (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi6424db; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi6424db IS 'valeurs du champ « VIP » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi80e1a6; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi80e1a6 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi80e1a6; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi80e1a6 IS 'valeurs du champ « Objet de la demande » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi825212; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi825212 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi825212; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi825212 IS 'valeurs du champ « Origine Stat » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi912977; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi912977 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi912977; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi912977 IS 'valeurs du champ « Qualification Stat » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi9c18c2; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi9c18c2 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi9c18c2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi9c18c2 IS 'valeurs du champ « Hors délais » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib63ff8; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib63ff8 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib63ff8; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib63ff8 IS 'valeurs du champ « Type de suivi Bo » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fibdb9bd; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fibdb9bd (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fibdb9bd; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fibdb9bd IS 'valeurs du champ « Relance Stat » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_ficbc45f; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_ficbc45f (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_ficbc45f; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_ficbc45f IS 'valeurs du champ « Supp - Niveau de traitement effectif » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_fie7c664; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fie7c664 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fie7c664; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_dysfonctionnement_sur_les_dechets_fie7c664 IS 'valeurs du champ « Mail envoyé à l''usager » du formulaire Signaler un problème concernant les déchets';


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq10; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq10
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq10; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq10 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi00a915.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq11; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq11
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq11; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq11 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi912977.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq12; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq12
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq12; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq12 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4ca6f3.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq13; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq13
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq13; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq13 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi1164c5.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq14; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq14
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq14; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq14 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi3e1224.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq15; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq15
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq15; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq15 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi80e1a6.id;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq16; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq16
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq16; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq16 OWNED BY formdata_signaler_un_dysfonctionnement_sur_les_dechets_ficbc45f.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus (
    geolocation_base point,
    status_id smallint,
    field_type smallint,
    field_qualif_form_decheterie smallint,
    field_qualif_form_collecte smallint,
    field_decheterie smallint,
    field_vip smallint,
    field_code_insee smallint,
    field_commune_stat smallint,
    field_guichet_commune smallint,
    field_secteur smallint,
    field_traite_n1_autorise smallint,
    field_secteur_ou_central smallint,
    field_communication_usager smallint,
    field_retard_stat smallint,
    field_qualification_stat smallint,
    field_origine smallint,
    field_saisie smallint,
    field_niveau_traitement_stat smallint,
    field_role_traite_n2 smallint,
    field_suivi smallint,
    field_hors_delais smallint,
    field_objet smallint,
    field_niveau_traitement smallint,
    function__receiver smallint,
    function__debug smallint,
    function__guichet smallint,
    function__agent_terrain smallint,
    function__guichet_commune smallint,
    function__superviseur smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus IS 'formulaire Déchets : déclarer un problème';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.geolocation_base IS 'geoloc';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_type; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_type IS 'Le problème concerne :';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_qualif_form_decheterie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_qualif_form_decheterie IS 'Précisez la nature du problème :';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_qualif_form_collecte; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_qualif_form_collecte IS 'Précisez : ';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_decheterie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_decheterie IS 'Quelle déchèterie ?';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_vip; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_vip IS 'VIP';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_code_insee IS 'Code Insee commune';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_commune_stat IS 'Commune Stat';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_guichet_commune IS 'Guichet commune';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_secteur IS 'Secteur';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_traite_n1_autorise; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_traite_n1_autorise IS 'Traitement niveau 1 autorisé';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_secteur_ou_central; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_secteur_ou_central IS 'Secteur ou service central';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_communication_usager; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_communication_usager IS 'Mail envoyé à l''usager';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_retard_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_retard_stat IS 'Relance Stat';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_qualification_stat IS 'Qualification Stat';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_origine IS 'Origine Stat';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_saisie IS 'Saisi par';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_niveau_traitement_stat IS 'Niveau traitement stat';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_role_traite_n2; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_role_traite_n2 IS 'Role de traitement niveau 2';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_suivi IS 'Type de suivi Bo';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_hors_delais; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_hors_delais IS 'Hors délais';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_objet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_objet IS 'Objet de la demande';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_niveau_traitement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.field_niveau_traitement IS 'Supp - Niveau de traitement effectif';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__debug IS 'fonction « Testeur »';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__guichet IS 'fonction « Guichet Métro »';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__agent_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__agent_terrain IS 'fonction « Agent terrain »';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__guichet_commune IS 'fonction « Guichet commune »';


--
-- Name: COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_un_probleme_sur_les_dechets_elus.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_saisie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_saisie (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_saisie IS 'valeurs du champ « Saisi par » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq10; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq10
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq10; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq10 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_saisie.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_1aa5a6; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_1aa5a6 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_1aa5a6; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_1aa5a6 IS 'valeurs du champ « Niveau traitement stat » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq11; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq11
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq11; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq11 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_1aa5a6.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_4a6b20; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4a6b20 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4a6b20; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4a6b20 IS 'valeurs du champ « Role de traitement niveau 2 » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq12; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq12
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq12; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq12 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_4a6b20.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_objet; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_objet (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_objet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_objet IS 'valeurs du champ « Objet de la demande » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq13; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq13
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq13; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq13 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_objet.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_4fca67; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4fca67 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4fca67; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4fca67 IS 'valeurs du champ « Supp - Niveau de traitement effectif » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq14; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq14
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq14; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq14 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_4fca67.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_d11656; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_d11656 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_d11656; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_d11656 IS 'valeurs du champ « Précisez la nature du problème : » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq1; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq1; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq1 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_d11656.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_974b66; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_974b66 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_974b66; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_974b66 IS 'valeurs du champ « Précisez :  » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq2; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq2
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq2; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq2 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_974b66.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_efe841; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_efe841 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_efe841; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_efe841 IS 'valeurs du champ « Quelle déchèterie ? » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq3; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq3
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq3; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq3 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_efe841.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_ea6d66; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_ea6d66 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_ea6d66; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_ea6d66 IS 'valeurs du champ « Code Insee commune » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq4; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq4
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq4; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq4 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_ea6d66.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_b92e6b; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_b92e6b (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_b92e6b; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_b92e6b IS 'valeurs du champ « Commune Stat » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq5; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq5
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq5; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq5 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_b92e6b.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_a4140c; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_a4140c (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_a4140c; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_a4140c IS 'valeurs du champ « Guichet commune » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq6; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq6
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq6; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq6 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_a4140c.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_5b19d0; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_5b19d0 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_5b19d0; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_5b19d0 IS 'valeurs du champ « Secteur » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq7; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq7
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq7; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq7 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_5b19d0.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_85f9b4; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_85f9b4 (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_85f9b4; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_85f9b4 IS 'valeurs du champ « Secteur ou service central » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq8; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq8
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq8; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq8 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_85f9b4.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_2fe5be; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_2fe5be (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_2fe5be; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_2fe5be IS 'valeurs du champ « Qualification Stat » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq9; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq9
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq9; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq9 OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_2fe5be.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_0b8db7; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_0b8db7 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_0b8db7; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_0b8db7 IS 'valeurs du champ « Relance Stat » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_1b66f7; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_1b66f7 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_1b66f7; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_1b66f7 IS 'valeurs du champ « Traitement niveau 1 autorisé » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_4671f6; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4671f6 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4671f6; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_4671f6 IS 'valeurs du champ « Origine Stat » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_972ca8; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_972ca8 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_972ca8; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_972ca8 IS 'valeurs du champ « Hors délais » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_df868e; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_df868e (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_df868e; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_df868e IS 'valeurs du champ « Mail envoyé à l''usager » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_type; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_type (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_type; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_type IS 'valeurs du champ « Le problème concerne : » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_signaler_un_probleme_sur_les_dechets_elus_field_id_seq OWNED BY formdata_signaler_un_probleme_sur_les_dechets_elus_field_type.id;


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_suivi; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_suivi (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_suivi IS 'valeurs du champ « Type de suivi Bo » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_un_probleme_sur_les_dechets_elus_field_vip; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_vip (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_vip; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_un_probleme_sur_les_dechets_elus_field_vip IS 'valeurs du champ « VIP » du formulaire Déchets : déclarer un problème';


--
-- Name: formdata_signaler_une_discrimination; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_signaler_une_discrimination (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_signaler_une_discrimination; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_signaler_une_discrimination IS 'formulaire Signaler une discrimination';


--
-- Name: COLUMN formdata_signaler_une_discrimination.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_signaler_une_discrimination.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_transmettre_mon_releve; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_transmettre_mon_releve (
    status_id smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_transmettre_mon_releve; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_transmettre_mon_releve IS 'formulaire Transmettre mon relevé';


--
-- Name: COLUMN formdata_transmettre_mon_releve.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_transmettre_mon_releve.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_voirie_magru; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru (
    geolocation_base point,
    status_id smallint,
    field_type_terrain smallint,
    field_motif_intervention_terrain smallint,
    field_type_adresse_terrain smallint,
    field_type_numero_terrain smallint,
    field_code_insee smallint,
    field_adresse_commune smallint,
    field_commune_stat smallint,
    field_guichet_commune smallint,
    field_secteur smallint,
    field_niveau_traitement_stat smallint,
    field_qualification_stat smallint,
    field_type_intervention_gru smallint,
    field_suivi smallint,
    field_origine smallint,
    field_adresse_signalement_numero smallint,
    field_adresse_signalement_voie smallint,
    field_saisie smallint,
    field_mode_de_contact_stat smallint,
    function__receiver smallint,
    function__guichet smallint,
    function__debug smallint,
    function__agent_terrain smallint,
    function__guichet_commune smallint,
    function__superviseur smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_voirie_magru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru IS 'formulaire Voirie : mes signalements';


--
-- Name: COLUMN formdata_voirie_magru.geolocation_base; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.geolocation_base IS 'geoloc';


--
-- Name: COLUMN formdata_voirie_magru.field_type_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_type_terrain IS 'Objet';


--
-- Name: COLUMN formdata_voirie_magru.field_motif_intervention_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_motif_intervention_terrain IS 'Motif de l''intervention';


--
-- Name: COLUMN formdata_voirie_magru.field_type_adresse_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_type_adresse_terrain IS 'Type d''adresse';


--
-- Name: COLUMN formdata_voirie_magru.field_type_numero_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_type_numero_terrain IS 'Type de numéro';


--
-- Name: COLUMN formdata_voirie_magru.field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_code_insee IS 'Code Insee commune';


--
-- Name: COLUMN formdata_voirie_magru.field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_adresse_commune IS 'Commune';


--
-- Name: COLUMN formdata_voirie_magru.field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_commune_stat IS 'Commune Stat';


--
-- Name: COLUMN formdata_voirie_magru.field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_guichet_commune IS 'Guichet commune';


--
-- Name: COLUMN formdata_voirie_magru.field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_secteur IS 'Secteur';


--
-- Name: COLUMN formdata_voirie_magru.field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_niveau_traitement_stat IS 'Niveau traitement stat';


--
-- Name: COLUMN formdata_voirie_magru.field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_qualification_stat IS 'Qualification Stat';


--
-- Name: COLUMN formdata_voirie_magru.field_type_intervention_gru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_type_intervention_gru IS 'Type intervention GRU';


--
-- Name: COLUMN formdata_voirie_magru.field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_suivi IS 'Type de suivi bo';


--
-- Name: COLUMN formdata_voirie_magru.field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_origine IS 'Origine Stat';


--
-- Name: COLUMN formdata_voirie_magru.field_adresse_signalement_numero; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_adresse_signalement_numero IS 'Numéro';


--
-- Name: COLUMN formdata_voirie_magru.field_adresse_signalement_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_adresse_signalement_voie IS 'Voie';


--
-- Name: COLUMN formdata_voirie_magru.field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_saisie IS 'Saisi par (liste)';


--
-- Name: COLUMN formdata_voirie_magru.field_mode_de_contact_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.field_mode_de_contact_stat IS 'SUPP - Mode de contact Stat';


--
-- Name: COLUMN formdata_voirie_magru.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.function__receiver IS 'fonction « Destinataire »';


--
-- Name: COLUMN formdata_voirie_magru.function__guichet; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.function__guichet IS 'fonction « Guichet Métro »';


--
-- Name: COLUMN formdata_voirie_magru.function__debug; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.function__debug IS 'fonction « Testeur »';


--
-- Name: COLUMN formdata_voirie_magru.function__agent_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.function__agent_terrain IS 'fonction « Agent terrain »';


--
-- Name: COLUMN formdata_voirie_magru.function__guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.function__guichet_commune IS 'fonction « Guichet commune »';


--
-- Name: COLUMN formdata_voirie_magru.function__superviseur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_voirie_magru.function__superviseur IS 'fonction « Superviseur »';


--
-- Name: formdata_voirie_magru_field_adresse_commune; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_adresse_commune (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_adresse_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_adresse_commune IS 'valeurs du champ « Commune » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_adresse_commune_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_adresse_commune_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_adresse_commune_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_adresse_commune_id_seq OWNED BY formdata_voirie_magru_field_adresse_commune.id;


--
-- Name: formdata_voirie_magru_field_adresse_signalement_numero; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_adresse_signalement_numero (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_adresse_signalement_numero; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_adresse_signalement_numero IS 'valeurs du champ « Numéro » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_adresse_signalement_numero_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_adresse_signalement_numero_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_adresse_signalement_numero_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_adresse_signalement_numero_id_seq OWNED BY formdata_voirie_magru_field_adresse_signalement_numero.id;


--
-- Name: formdata_voirie_magru_field_adresse_signalement_voie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_adresse_signalement_voie (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_adresse_signalement_voie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_adresse_signalement_voie IS 'valeurs du champ « Voie » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_adresse_signalement_voie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_adresse_signalement_voie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_adresse_signalement_voie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_adresse_signalement_voie_id_seq OWNED BY formdata_voirie_magru_field_adresse_signalement_voie.id;


--
-- Name: formdata_voirie_magru_field_code_insee; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_code_insee (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_code_insee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_code_insee IS 'valeurs du champ « Code Insee commune » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_code_insee_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_code_insee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_code_insee_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_code_insee_id_seq OWNED BY formdata_voirie_magru_field_code_insee.id;


--
-- Name: formdata_voirie_magru_field_commune_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_commune_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_commune_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_commune_stat IS 'valeurs du champ « Commune Stat » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_commune_stat_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_commune_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_commune_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_commune_stat_id_seq OWNED BY formdata_voirie_magru_field_commune_stat.id;


--
-- Name: formdata_voirie_magru_field_guichet_commune; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_guichet_commune (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_guichet_commune; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_guichet_commune IS 'valeurs du champ « Guichet commune » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_guichet_commune_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_guichet_commune_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_guichet_commune_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_guichet_commune_id_seq OWNED BY formdata_voirie_magru_field_guichet_commune.id;


--
-- Name: formdata_voirie_magru_field_mode_de_contact_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_mode_de_contact_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_mode_de_contact_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_mode_de_contact_stat IS 'valeurs du champ « SUPP - Mode de contact Stat » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_mode_de_contact_stat_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_mode_de_contact_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_mode_de_contact_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_mode_de_contact_stat_id_seq OWNED BY formdata_voirie_magru_field_mode_de_contact_stat.id;


--
-- Name: formdata_voirie_magru_field_motif_intervention_terrain; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_motif_intervention_terrain (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_motif_intervention_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_motif_intervention_terrain IS 'valeurs du champ « Motif de l''intervention » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_motif_intervention_terrain_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_motif_intervention_terrain_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_motif_intervention_terrain_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_motif_intervention_terrain_id_seq OWNED BY formdata_voirie_magru_field_motif_intervention_terrain.id;


--
-- Name: formdata_voirie_magru_field_niveau_traitement_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_niveau_traitement_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_niveau_traitement_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_niveau_traitement_stat IS 'valeurs du champ « Niveau traitement stat » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_niveau_traitement_stat_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_niveau_traitement_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_niveau_traitement_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_niveau_traitement_stat_id_seq OWNED BY formdata_voirie_magru_field_niveau_traitement_stat.id;


--
-- Name: formdata_voirie_magru_field_origine; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_origine (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_origine; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_origine IS 'valeurs du champ « Origine Stat » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_qualification_stat; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_qualification_stat (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_qualification_stat; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_qualification_stat IS 'valeurs du champ « Qualification Stat » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_qualification_stat_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_qualification_stat_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_qualification_stat_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_qualification_stat_id_seq OWNED BY formdata_voirie_magru_field_qualification_stat.id;


--
-- Name: formdata_voirie_magru_field_saisie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_saisie (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_saisie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_saisie IS 'valeurs du champ « Saisi par (liste) » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_saisie_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_saisie_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_saisie_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_saisie_id_seq OWNED BY formdata_voirie_magru_field_saisie.id;


--
-- Name: formdata_voirie_magru_field_secteur; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_secteur (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_secteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_secteur IS 'valeurs du champ « Secteur » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_secteur_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_secteur_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_secteur_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_secteur_id_seq OWNED BY formdata_voirie_magru_field_secteur.id;


--
-- Name: formdata_voirie_magru_field_suivi; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_suivi (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_suivi; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_suivi IS 'valeurs du champ « Type de suivi bo » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_type_adresse_terrain; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_type_adresse_terrain (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_type_adresse_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_type_adresse_terrain IS 'valeurs du champ « Type d''adresse » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_type_adresse_terrain_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_type_adresse_terrain_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_type_adresse_terrain_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_type_adresse_terrain_id_seq OWNED BY formdata_voirie_magru_field_type_adresse_terrain.id;


--
-- Name: formdata_voirie_magru_field_type_intervention_gru; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_type_intervention_gru (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_type_intervention_gru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_type_intervention_gru IS 'valeurs du champ « Type intervention GRU » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_type_intervention_gru_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_type_intervention_gru_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_type_intervention_gru_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_type_intervention_gru_id_seq OWNED BY formdata_voirie_magru_field_type_intervention_gru.id;


--
-- Name: formdata_voirie_magru_field_type_numero_terrain; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_type_numero_terrain (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_type_numero_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_type_numero_terrain IS 'valeurs du champ « Type de numéro » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_type_numero_terrain_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_type_numero_terrain_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_type_numero_terrain_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_type_numero_terrain_id_seq OWNED BY formdata_voirie_magru_field_type_numero_terrain.id;


--
-- Name: formdata_voirie_magru_field_type_terrain; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_voirie_magru_field_type_terrain (
    id integer NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_voirie_magru_field_type_terrain; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_voirie_magru_field_type_terrain IS 'valeurs du champ « Objet » du formulaire Voirie : mes signalements';


--
-- Name: formdata_voirie_magru_field_type_terrain_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdata_voirie_magru_field_type_terrain_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdata_voirie_magru_field_type_terrain_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdata_voirie_magru_field_type_terrain_id_seq OWNED BY formdata_voirie_magru_field_type_terrain.id;


--
-- Name: formdata_votre_question_concerne_l_eau_potable; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_votre_question_concerne_l_eau_potable (
    status_id smallint,
    field_objet_demande smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_votre_question_concerne_l_eau_potable; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_votre_question_concerne_l_eau_potable IS 'formulaire Demander un renseignement ou signaler un problème concernant l''eau potable';


--
-- Name: COLUMN formdata_votre_question_concerne_l_eau_potable.field_objet_demande; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_votre_question_concerne_l_eau_potable.field_objet_demande IS 'Vous souhaitez :';


--
-- Name: COLUMN formdata_votre_question_concerne_l_eau_potable.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_votre_question_concerne_l_eau_potable.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_votre_question_concerne_l_eau_potable_field_objeac002e; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_votre_question_concerne_l_eau_potable_field_objeac002e (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_votre_question_concerne_l_eau_potable_field_objeac002e; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_votre_question_concerne_l_eau_potable_field_objeac002e IS 'valeurs du champ « Vous souhaitez : » du formulaire Demander un renseignement ou signaler un problème concernant l''eau potable';


--
-- Name: formdata_votre_question_concerne_les_eaux_usees; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_votre_question_concerne_les_eaux_usees (
    status_id smallint,
    field_objet_demande smallint,
    function__receiver smallint
)
INHERITS (formdata);


--
-- Name: TABLE formdata_votre_question_concerne_les_eaux_usees; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_votre_question_concerne_les_eaux_usees IS 'formulaire Demander un renseignement ou signaler un problème concernant les eaux usées';


--
-- Name: COLUMN formdata_votre_question_concerne_les_eaux_usees.field_objet_demande; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_votre_question_concerne_les_eaux_usees.field_objet_demande IS 'Elle concerne :';


--
-- Name: COLUMN formdata_votre_question_concerne_les_eaux_usees.function__receiver; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON COLUMN formdata_votre_question_concerne_les_eaux_usees.function__receiver IS 'fonction « Destinataire »';


--
-- Name: formdata_votre_question_concerne_les_eaux_usees_field_obj2cc370; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdata_votre_question_concerne_les_eaux_usees_field_obj2cc370 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE formdata_votre_question_concerne_les_eaux_usees_field_obj2cc370; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdata_votre_question_concerne_les_eaux_usees_field_obj2cc370 IS 'valeurs du champ « Elle concerne : » du formulaire Demander un renseignement ou signaler un problème concernant les eaux usées';


--
-- Name: formdef; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE formdef (
    id integer NOT NULL,
    category_id integer,
    label character varying
);


--
-- Name: TABLE formdef; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE formdef IS 'types de formulaire';


--
-- Name: formdef_id_seq; Type: SEQUENCE; Schema: services_demarches_lametro_fr; Owner: -
--

CREATE SEQUENCE formdef_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: formdef_id_seq; Type: SEQUENCE OWNED BY; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER SEQUENCE formdef_id_seq OWNED BY formdef.id;


--
-- Name: hour; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE hour (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE hour; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE hour IS 'heures';


--
-- Name: role; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE role (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE role; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE role IS 'role';


--
-- Name: status; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status IS 'statuts simplifiés';


--
-- Name: status_acceder_aux_services_pour_les_professionnels; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_acceder_aux_services_pour_les_professionnels (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_acceder_aux_services_pour_les_professionnels; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_acceder_aux_services_pour_les_professionnels IS 'statuts du formulaire « Accéder aux services pour les professionnels »';


--
-- Name: status_candidater_aux_avis_de_marches_publics; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_candidater_aux_avis_de_marches_publics (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_candidater_aux_avis_de_marches_publics; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_candidater_aux_avis_de_marches_publics IS 'statuts du formulaire « Candidater aux avis de marchés publics »';


--
-- Name: status_candidater_aux_offres_d_emplois_de_la_metropole; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_candidater_aux_offres_d_emplois_de_la_metropole (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_candidater_aux_offres_d_emplois_de_la_metropole; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_candidater_aux_offres_d_emplois_de_la_metropole IS 'statuts du formulaire « Candidater aux offres d''emplois de la Métropole »';


--
-- Name: status_commander_un_bac_un_composteur_ou_un_lombricomposteur; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_commander_un_bac_un_composteur_ou_un_lombricomposteur (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_commander_un_bac_un_composteur_ou_un_lombricomposteur; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_commander_un_bac_un_composteur_ou_un_lombricomposteur IS 'statuts du formulaire « Commander un bac, un composteur ou un lombricomposteur »';


--
-- Name: status_creer_ou_acceder_a_ma_demande_de_logement_social; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_creer_ou_acceder_a_ma_demande_de_logement_social (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_creer_ou_acceder_a_ma_demande_de_logement_social; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_creer_ou_acceder_a_ma_demande_de_logement_social IS 'statuts du formulaire « Créer ou accéder à ma demande de logement social »';


--
-- Name: status_dechets_mesdechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_dechets_mesdechets (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_dechets_mesdechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_dechets_mesdechets IS 'statuts du formulaire « Déchets : mes signalements »';


--
-- Name: status_declarer_et_payer_ma_taxe_de_sejour; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_declarer_et_payer_ma_taxe_de_sejour (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_declarer_et_payer_ma_taxe_de_sejour; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_declarer_et_payer_ma_taxe_de_sejour IS 'statuts du formulaire « Déclarer et payer ma taxe de séjour »';


--
-- Name: status_demander_des_renseignements_sur_la_voirie_backoffice; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_des_renseignements_sur_la_voirie_backoffice (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_des_renseignements_sur_la_voirie_backoffice; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_des_renseignements_sur_la_voirie_backoffice IS 'statuts du formulaire « Demander des renseignements sur la voirie »';


--
-- Name: status_demander_des_renseignements_sur_les_dechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_des_renseignements_sur_les_dechets (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_des_renseignements_sur_les_dechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_des_renseignements_sur_les_dechets IS 'statuts du formulaire « Demander des renseignements sur les déchets »';


--
-- Name: status_demander_un_badge_d_acces_a_une_zone_pietonne; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_un_badge_d_acces_a_une_zone_pietonne (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_un_badge_d_acces_a_une_zone_pietonne; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_un_badge_d_acces_a_une_zone_pietonne IS 'statuts du formulaire « Demander un badge d''accès à une zone piétonne »';


--
-- Name: status_demander_un_renseignement_a_d_autres_services; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_un_renseignement_a_d_autres_services (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_un_renseignement_a_d_autres_services; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_un_renseignement_a_d_autres_services IS 'statuts du formulaire « Demander un renseignement à d''autres services »';


--
-- Name: status_demander_un_renseignement_concernant_l_economie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_un_renseignement_concernant_l_economie (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_un_renseignement_concernant_l_economie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_un_renseignement_concernant_l_economie IS 'statuts du formulaire « Demander un renseignement concernant l''économie ou le tourisme »';


--
-- Name: status_demander_un_renseignement_concernant_l_urbanisme; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_un_renseignement_concernant_l_urbanisme (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_un_renseignement_concernant_l_urbanisme; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_un_renseignement_concernant_l_urbanisme IS 'statuts du formulaire « Demander un renseignement concernant l''urbanisme »';


--
-- Name: status_demander_un_renseignement_concernant_la_direction_7eda4d; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_un_renseignement_concernant_la_direction_7eda4d (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_un_renseignement_concernant_la_direction_7eda4d; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_un_renseignement_concernant_la_direction_7eda4d IS 'statuts du formulaire « Demander un renseignement concernant la direction de la communication »';


--
-- Name: status_demander_un_renseignement_concernant_le_logement; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_un_renseignement_concernant_le_logement (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_un_renseignement_concernant_le_logement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_un_renseignement_concernant_le_logement IS 'statuts du formulaire « Demander un renseignement concernant le logement »';


--
-- Name: status_demander_un_renseignement_concernant_les_ressourceeec005; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_un_renseignement_concernant_les_ressourceeec005 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_un_renseignement_concernant_les_ressourceeec005; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_un_renseignement_concernant_les_ressourceeec005 IS 'statuts du formulaire « Demander un renseignement concernant les ressources humaines »';


--
-- Name: status_demander_un_stage; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_un_stage (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_un_stage; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_un_stage IS 'statuts du formulaire « Demander un stage »';


--
-- Name: status_demander_une_alternance; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_une_alternance (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_une_alternance; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_une_alternance IS 'statuts du formulaire « Demander une alternance »';


--
-- Name: status_demander_une_autorisation_de_stationnement; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_demander_une_autorisation_de_stationnement (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_demander_une_autorisation_de_stationnement; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_demander_une_autorisation_de_stationnement IS 'statuts du formulaire « Demander une autorisation de stationnement »';


--
-- Name: status_envoyer_une_candidature_spontanee; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_envoyer_une_candidature_spontanee (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_envoyer_une_candidature_spontanee; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_envoyer_une_candidature_spontanee IS 'statuts du formulaire « Envoyer une candidature spontanée »';


--
-- Name: status_gerer_mon_contrat_payer_ma_facture_resilier_mon_ab3e01b6; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_gerer_mon_contrat_payer_ma_facture_resilier_mon_ab3e01b6 (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_gerer_mon_contrat_payer_ma_facture_resilier_mon_ab3e01b6; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_gerer_mon_contrat_payer_ma_facture_resilier_mon_ab3e01b6 IS 'statuts du formulaire « Gérer mon contrat, payer ma facture, résilier mon abonnement »';


--
-- Name: status_payer_une_facture_editee_par_la_metropole; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_payer_une_facture_editee_par_la_metropole (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_payer_une_facture_editee_par_la_metropole; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_payer_une_facture_editee_par_la_metropole IS 'statuts du formulaire « Payer une facture éditée par la Métropole »';


--
-- Name: status_probleme_sur_la_voirie_elus; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_probleme_sur_la_voirie_elus (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_probleme_sur_la_voirie_elus; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_probleme_sur_la_voirie_elus IS 'statuts du formulaire « Voirie : déclarer un problème »';


--
-- Name: status_s_abonner; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_s_abonner (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_s_abonner; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_s_abonner IS 'statuts du formulaire « S''abonner »';


--
-- Name: status_se_renseigner_et_participer_aux_appels_a_projets_e55494e; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_se_renseigner_et_participer_aux_appels_a_projets_e55494e (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_se_renseigner_et_participer_aux_appels_a_projets_e55494e; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_se_renseigner_et_participer_aux_appels_a_projets_e55494e IS 'statuts du formulaire « Se renseigner et participer aux appels à projets, enquêtes publiques, consultations... »';


--
-- Name: status_signaler_un_dysfonctionnement_sur_la_voirie; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_signaler_un_dysfonctionnement_sur_la_voirie (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_signaler_un_dysfonctionnement_sur_la_voirie; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_signaler_un_dysfonctionnement_sur_la_voirie IS 'statuts du formulaire « Signaler un problème concernant la voirie »';


--
-- Name: status_signaler_un_dysfonctionnement_sur_les_dechets; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_signaler_un_dysfonctionnement_sur_les_dechets (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_signaler_un_dysfonctionnement_sur_les_dechets; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_signaler_un_dysfonctionnement_sur_les_dechets IS 'statuts du formulaire « Signaler un problème concernant les déchets »';


--
-- Name: status_signaler_un_probleme_sur_les_dechets_elus; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_signaler_un_probleme_sur_les_dechets_elus (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_signaler_un_probleme_sur_les_dechets_elus; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_signaler_un_probleme_sur_les_dechets_elus IS 'statuts du formulaire « Déchets : déclarer un problème »';


--
-- Name: status_signaler_une_discrimination; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_signaler_une_discrimination (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_signaler_une_discrimination; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_signaler_une_discrimination IS 'statuts du formulaire « Signaler une discrimination »';


--
-- Name: status_transmettre_mon_releve; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_transmettre_mon_releve (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_transmettre_mon_releve; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_transmettre_mon_releve IS 'statuts du formulaire « Transmettre mon relevé »';


--
-- Name: status_voirie_magru; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_voirie_magru (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_voirie_magru; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_voirie_magru IS 'statuts du formulaire « Voirie : mes signalements »';


--
-- Name: status_votre_question_concerne_l_eau_potable; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_votre_question_concerne_l_eau_potable (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_votre_question_concerne_l_eau_potable; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_votre_question_concerne_l_eau_potable IS 'statuts du formulaire « Demander un renseignement ou signaler un problème concernant l''eau potable »';


--
-- Name: status_votre_question_concerne_les_eaux_usees; Type: TABLE; Schema: services_demarches_lametro_fr; Owner: -; Tablespace: 
--

CREATE TABLE status_votre_question_concerne_les_eaux_usees (
    id smallint NOT NULL,
    label character varying
);


--
-- Name: TABLE status_votre_question_concerne_les_eaux_usees; Type: COMMENT; Schema: services_demarches_lametro_fr; Owner: -
--

COMMENT ON TABLE status_votre_question_concerne_les_eaux_usees IS 'statuts du formulaire « Demander un renseignement ou signaler un problème concernant les eaux usées »';


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY agent ALTER COLUMN id SET DEFAULT nextval('agent_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution ALTER COLUMN id SET DEFAULT nextval('evolution_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_acceder_aux_services_pour_les_professionnels ALTER COLUMN id SET DEFAULT nextval('evolution_acceder_aux_services_pour_les_professionnels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_candidater_aux_avis_de_marches_publics ALTER COLUMN id SET DEFAULT nextval('evolution_candidater_aux_avis_de_marches_publics_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_candidater_aux_offres_d_emplois_de_la_metropole ALTER COLUMN id SET DEFAULT nextval('evolution_candidater_aux_offres_d_emplois_de_la_metropol_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_commander_un_bac_un_composteur_ou_un_lombricomposteur ALTER COLUMN id SET DEFAULT nextval('evolution_commander_un_bac_un_composteur_ou_un_lombricom_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_creer_ou_acceder_a_ma_demande_de_logement_social ALTER COLUMN id SET DEFAULT nextval('evolution_creer_ou_acceder_a_ma_demande_de_logement_soci_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_dechets_mesdechets ALTER COLUMN id SET DEFAULT nextval('evolution_dechets_mesdechets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_declarer_et_payer_ma_taxe_de_sejour ALTER COLUMN id SET DEFAULT nextval('evolution_declarer_et_payer_ma_taxe_de_sejour_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_des_renseignements_sur_la_voirie_backoffice ALTER COLUMN id SET DEFAULT nextval('evolution_demander_des_renseignements_sur_la_voirie_back_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_des_renseignements_sur_les_dechets ALTER COLUMN id SET DEFAULT nextval('evolution_demander_des_renseignements_sur_les_dechets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_un_badge_d_acces_a_une_zone_pietonne ALTER COLUMN id SET DEFAULT nextval('evolution_demander_un_badge_d_acces_a_une_zone_pietonne_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_un_renseignement_a_d_autres_services ALTER COLUMN id SET DEFAULT nextval('evolution_demander_un_renseignement_a_d_autres_services_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_un_renseignement_concernant_l_economie ALTER COLUMN id SET DEFAULT nextval('evolution_demander_un_renseignement_concernant_l_economi_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_un_renseignement_concernant_l_urbanisme ALTER COLUMN id SET DEFAULT nextval('evolution_demander_un_renseignement_concernant_l_urbanis_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_un_renseignement_concernant_la_directi8df794 ALTER COLUMN id SET DEFAULT nextval('evolution_demander_un_renseignement_concernant_la_direct_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_un_renseignement_concernant_le_logement ALTER COLUMN id SET DEFAULT nextval('evolution_demander_un_renseignement_concernant_le_logeme_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_un_renseignement_concernant_les_ressou3bb429 ALTER COLUMN id SET DEFAULT nextval('evolution_demander_un_renseignement_concernant_les_resso_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_un_stage ALTER COLUMN id SET DEFAULT nextval('evolution_demander_un_stage_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_une_alternance ALTER COLUMN id SET DEFAULT nextval('evolution_demander_une_alternance_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_demander_une_autorisation_de_stationnement ALTER COLUMN id SET DEFAULT nextval('evolution_demander_une_autorisation_de_stationnement_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_envoyer_une_candidature_spontanee ALTER COLUMN id SET DEFAULT nextval('evolution_envoyer_une_candidature_spontanee_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_gerer_mon_contrat_payer_ma_facture_resilier_mon402aba ALTER COLUMN id SET DEFAULT nextval('evolution_gerer_mon_contrat_payer_ma_facture_resilier_mo_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_payer_une_facture_editee_par_la_metropole ALTER COLUMN id SET DEFAULT nextval('evolution_payer_une_facture_editee_par_la_metropole_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_probleme_sur_la_voirie_elus ALTER COLUMN id SET DEFAULT nextval('evolution_probleme_sur_la_voirie_elus_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_s_abonner ALTER COLUMN id SET DEFAULT nextval('evolution_s_abonner_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_se_renseigner_et_participer_aux_appels_a_projetcb79dd ALTER COLUMN id SET DEFAULT nextval('evolution_se_renseigner_et_participer_aux_appels_a_proje_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_signaler_un_dysfonctionnement_sur_la_voirie ALTER COLUMN id SET DEFAULT nextval('evolution_signaler_un_dysfonctionnement_sur_la_voirie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_signaler_un_dysfonctionnement_sur_les_dechets ALTER COLUMN id SET DEFAULT nextval('evolution_signaler_un_dysfonctionnement_sur_les_dechets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_signaler_un_probleme_sur_les_dechets_elus ALTER COLUMN id SET DEFAULT nextval('evolution_signaler_un_probleme_sur_les_dechets_elus_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_signaler_une_discrimination ALTER COLUMN id SET DEFAULT nextval('evolution_signaler_une_discrimination_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_transmettre_mon_releve ALTER COLUMN id SET DEFAULT nextval('evolution_transmettre_mon_releve_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_voirie_magru ALTER COLUMN id SET DEFAULT nextval('evolution_voirie_magru_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_votre_question_concerne_l_eau_potable ALTER COLUMN id SET DEFAULT nextval('evolution_votre_question_concerne_l_eau_potable_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY evolution_votre_question_concerne_les_eaux_usees ALTER COLUMN id SET DEFAULT nextval('evolution_votre_question_concerne_les_eaux_usees_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_acceder_aux_services_pour_les_professionnels ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_candidater_aux_avis_de_marches_publics ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_candidater_aux_offres_d_emplois_de_la_metropole ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_commander_un_bac_un_composteur_ou_un_lombricomposteur ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_creer_ou_acceder_a_ma_demande_de_logement_social ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_code_insee ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_code_insee_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_commune_stat ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_commune_stat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_decheterie ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_decheterie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_guichet_commune ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_guichet_commune_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_niveau_traitement ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_niveau_traitement_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_niveau_traitement_stat ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_niveau_traitement_stat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_objet ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_objet_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_qualif_form_collecte ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_qualif_form_collecte_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_qualif_form_decheterie ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_qualif_form_decheterie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_qualification_stat ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_qualification_stat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_role_traite_n2 ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_role_traite_n2_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_saisie ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_saisie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_secteur ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_secteur_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_dechets_mesdechets_field_secteur_ou_central ALTER COLUMN id SET DEFAULT nextval('formdata_dechets_mesdechets_field_secteur_ou_central_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_declarer_et_payer_ma_taxe_de_sejour ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backof0f99d4 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq11'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backof1ce86d ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backof296f79 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq6'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backof4b5317 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq4'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backof5d307d ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq3'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backof5e8cb3 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq8'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backof692237 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq10'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backof962012 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_backo_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backofa151d7 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq13'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backofa4f9eb ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq7'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backofb29d9e ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq15'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backofbf2c89 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq5'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backofdfb460 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq2'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backofe0aeed ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq12'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backofe5253c ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_bac_id_seq14'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backoffa829b ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_la_voirie_back_id_seq9'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_la_voirie_backoffice ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel0072ab ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq12'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel0074b5 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq23'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel121c99 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq11'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel346d3b ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq19'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel4eae74 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq4'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel5c806e ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq16'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel61a26f ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq9'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel6c50a9 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq24'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel75eabc ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq8'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel771713 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq18'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel910272 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq3'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel91a9b9 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq22'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel977bc5 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq2'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiel985044 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq15'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiela2fe26 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq21'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiela54bb6 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq17'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fiela9003b ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq6'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fielac2b60 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq10'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fielbf42fe ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq7'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fielc06cbc ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq13'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fielc0f3cb ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq14'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fielc135c3 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_f_id_seq20'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_field_type ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fieldd4246 ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_des_renseignements_sur_les_dechets_fieldfac8c ALTER COLUMN id SET DEFAULT nextval('formdata_demander_des_renseignements_sur_les_dechets_fi_id_seq5'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_badge_d_acces_a_une_zone_pietonne ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_renseignement_a_d_autres_services ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_renseignement_concernant_l_economie ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_renseignement_concernant_l_urbanisme ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_renseignement_concernant_l_urbanisme0f7c9c ALTER COLUMN id SET DEFAULT nextval('formdata_demander_un_renseignement_concernant_l_urbanism_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_renseignement_concernant_la_directio0af105 ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_renseignement_concernant_la_directio6b537b ALTER COLUMN id SET DEFAULT nextval('formdata_demander_un_renseignement_concernant_la_directi_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_renseignement_concernant_le_logement ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_renseignement_concernant_les_ressour78a2e1 ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_un_stage ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_une_alternance ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_demander_une_autorisation_de_stationnement ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_envoyer_une_candidature_spontanee ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_gerer_mon_contrat_payer_ma_facture_resilier_mon_505224 ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_payer_une_facture_editee_par_la_metropole ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_adresse_commune ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_adresse_commu_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_adresse_signal7c032d ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_adresse_sign_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_adresse_signalbea464 ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_adresse_signa_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_code_insee ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_code_insee_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_commune_stat ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_commune_stat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_guichet_commune ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_guichet_commu_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_mode_de_contact_stat ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_mode_de_conta_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_motif_intervend38b25 ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_motif_interve_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_niveau_traiteme57649 ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_niveau_traite_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_qualification_stat ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_qualification_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_reponse_directe ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_reponse_direc_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_saisie ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_saisie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_secteur ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_secteur_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_service_traitant_gru ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_service_trait_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_type_intervent3f537c ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_type_interven_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_probleme_sur_la_voirie_elus_field_type_terrain ALTER COLUMN id SET DEFAULT nextval('formdata_probleme_sur_la_voirie_elus_field_type_terrain_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_s_abonner ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_se_renseigner_et_participer_aux_appels_a_projets7201df ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel15bea7 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq10'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1b6b99 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq2'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel1bea01 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq6'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel24eaf9 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq18'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel281775 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq23'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel291910 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq17'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4ccb3e ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq25'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel4db287 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq12'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel57d802 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel6b1edc ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq3'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel74395b ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq9'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel75cfdb ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel7a9be8 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq16'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel83a93d ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq21'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiel984ad4 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq14'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela48dc3 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq11'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiela60d12 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq22'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fieladf2a2 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq15'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb1ac20 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq7'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb4ac9e ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq8'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielb99979 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq20'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_field4bdd6 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq13'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_field7025b ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq24'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fiele0d169 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq4'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf1ac29 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_f_id_seq19'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_la_voirie_fielf8bd75 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_la_voirie_fi_id_seq5'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi00a915 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq10'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi1164c5 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq13'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi20702a ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq3'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi245373 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi3e1224 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq14'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4ca6f3 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq12'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi4fdc2a ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets_f_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi51fe10 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq5'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi80e1a6 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq15'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi8670e9 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq9'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fi912977 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq11'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fib2bc25 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq6'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_ficbc45f ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets_id_seq16'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fid4beeb ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq8'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fide6710 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq2'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fiedf817 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq4'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_dysfonctionnement_sur_les_dechets_fifdc07e ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_dysfonctionnement_sur_les_dechets__id_seq7'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_1aa5a6 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq11'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_2fe5be ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq9'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_4a6b20 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq12'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_4fca67 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq14'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_5b19d0 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq7'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_85f9b4 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq8'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_974b66 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq2'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_a4140c ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq6'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_b92e6b ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq5'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_d11656 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_ea6d66 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq4'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_efe841 ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fiel_id_seq3'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_objet ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq13'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_saisie ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_fie_id_seq10'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_un_probleme_sur_les_dechets_elus_field_type ALTER COLUMN id SET DEFAULT nextval('formdata_signaler_un_probleme_sur_les_dechets_elus_field_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_signaler_une_discrimination ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_transmettre_mon_releve ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_adresse_commune ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_adresse_commune_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_adresse_signalement_numero ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_adresse_signalement_numero_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_adresse_signalement_voie ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_adresse_signalement_voie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_code_insee ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_code_insee_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_commune_stat ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_commune_stat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_guichet_commune ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_guichet_commune_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_mode_de_contact_stat ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_mode_de_contact_stat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_motif_intervention_terrain ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_motif_intervention_terrain_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_niveau_traitement_stat ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_niveau_traitement_stat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_qualification_stat ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_qualification_stat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_saisie ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_saisie_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_secteur ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_secteur_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_type_adresse_terrain ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_type_adresse_terrain_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_type_intervention_gru ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_type_intervention_gru_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_type_numero_terrain ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_type_numero_terrain_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_voirie_magru_field_type_terrain ALTER COLUMN id SET DEFAULT nextval('formdata_voirie_magru_field_type_terrain_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_votre_question_concerne_l_eau_potable ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdata_votre_question_concerne_les_eaux_usees ALTER COLUMN id SET DEFAULT nextval('formdata_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: services_demarches_lametro_fr; Owner: -
--

ALTER TABLE ONLY formdef ALTER COLUMN id SET DEFAULT nextval('formdef_id_seq'::regclass);


--
-- Data for Name: agent; Type: TABLE DATA; Schema: services_demarches_lametro_fr; Owner: -
--

COPY agent (id, label) FROM stdin;
1	1
2	2
3	3
4	4
5	5
6	6
7	7
8	8
9	9
10	10
11	11
12	12
13	13
14	14
15	15
16	16
17	17
18	18
19	19
20	20
21	21
22	22
23	23
24	24
25	25
26	26
27	27
28	28
29	29
30	30
31	31
\.


--
-- Name: agent_id_seq; Type: SEQUENCE SET; Schema: services_demarches_lametro_fr; Owner: -
--

SELECT pg_catalog.setval('agent_id_seq', 31, true);


--
-- Data for Name: category; Type: TABLE DATA; Schema: services_demarches_lametro_fr; Owner: -
--

COPY category (id, label) FROM stdin;
0	Voirie / Stationnement
1	Eau potable
2	Eaux usées
3	Logement
4	Économie / Tourisme
5	Administration
6	Urbanisme
7	Ressources humaines
8	Proxi-communes
9	Proxi-Agents
10	Déchets
11	Lutte contre les discriminations
12	Démocratie participative
\.


--
-- Data for Name: channel; Type: TABLE DATA; Schema: services_demarches_lametro_fr; Owner: -
--

COPY channel (id, label) FROM stdin;
1	web
2	courrier
3	téléphone
4	guichet
5	backoffice
6	email
7	fax
\.


--
-- Data for Name: evolution; Type: TABLE DATA; Schema: services_demarches_lametro_fr; Owner: -
--

COPY evolution (id, generic_status_id, formdata_id, "time", date, hour_id) FROM stdin;
1	1	1	2018-12-05 11:47:54	2018-12-05	10
2	2	1	2018-12-05 11:48:01	2018-12-05	10
3	3	1	2018-12-05 11:48:10	2018-12-05	10
4	1	2	2018-12-06 18:48:00	2018-12-06	17
5	2	2	2018-12-06 18:48:03	2018-12-06	17
6	1	3	2018-12-06 16:49:32	2018-12-06	15
7	2	3	2018-12-06 16:49:35	2018-12-06	15
8	1	4	2018-12-06 16:45:07	2018-12-06	15
9	2	4	2018-12-06 16:45:09	2018-12-06	15
10	3	4	2018-12-06 16:45:11	2018-12-06	15
11	1	5	2018-12-06 16:33:05	2018-12-06	15
12	2	5	2018-12-06 16:33:07	2018-12-06	15
13	1	6	2018-12-06 15:46:04	2018-12-06	14
14	2	6	2018-12-06 15:46:06	2018-12-06	14
15	3	6	2018-12-06 15:46:08	2018-12-06	14
16	1	7	2018-12-06 15:44:44	2018-12-06	14
17	2	7	2018-12-06 15:44:45	2018-12-06	14
18	3	7	2018-12-06 15:44:48	2018-12-06	14
19	1	8	2018-12-06 15:43:45	2018-12-06	14
20	2	8	2018-12-06 15:43:49	2018-12-06	14
21	3	8	2018-12-06 16:39:53	2018-12-06	15
22	1	9	2018-12-06 15:31:43	2018-12-06	14
23	2	9	2018-12-06 15:31:47	2018-12-06	14
24	3	9	2018-12-06 15:31:49	2018-12-06	14
25	1	10	2018-12-06 15:29:14	2018-12-06	14
26	2	10	2018-12-06 15:29:15	2018-12-06	14
27	3	10	2018-12-06 15:29:17	2018-12-06	14
28	1	11	2018-12-06 15:23:08	2018-12-06	14
29	2	11	2018-12-06 15:23:10	2018-12-06	14
30	3	11	2018-12-06 15:23:12	2018-12-06	14
31	1	12	2018-12-06 15:22:15	2018-12-06	14
32	2	12	2018-12-06 15:22:17	2018-12-06	14
33	3	12	2018-12-06 15:22:19	2018-12-06	14
34	1	13	2018-12-06 15:12:41	2018-12-06	14
35	2	13	2018-12-06 15:12:43	2018-12-06	14
36	3	13	2018-12-06 15:12:44	2018-12-06	14
37	1	14	2018-12-06 15:02:58	2018-12-06	14
38	2	14	2018-12-06 15:03:00	2018-12-06	14
39	3	14	2018-12-06 15:04:29	2018-12-06	14
40	1	15	2018-12-06 14:51:55	2018-12-06	13
41	2	15	2018-12-06 14:51:58	2018-12-06	13
42	3	15	2018-12-06 16:50:03	2018-12-06	15
43	1	16	2018-12-06 14:49:13	2018-12-06	13
44	2	16	2018-12-06 14:49:17	2018-12-06	13
45	3	16	2018-12-06 14:49:20	2018-12-06	13
46	1	17	2018-12-06 14:44:05	2018-12-06	13
47	2	17	2018-12-06 14:44:07	2018-12-06	13
48	3	17	2018-12-06 14:44:09	2018-12-06	13
49	1	18	2018-12-06 14:43:26	2018-12-06	13
50	2	18	2018-12-06 14:43:29	2018-12-06	13
51	3	18	2018-12-06 14:43:31	2018-12-06	13
52	1	19	2018-12-06 14:43:02	2018-12-06	13
53	2	19	2018-12-06 14:43:05	2018-12-06	13
54	3	19	2018-12-06 14:43:07	2018-12-06	13
55	1	20	2018-12-06 14:41:58	2018-12-06	13
56	2	20	2018-12-06 14:42:00	2018-12-06	13
57	3	20	2018-12-06 14:42:02	2018-12-06	13
58	1	21	2018-12-06 14:44:00	2018-12-06	13
59	2	21	2018-12-06 14:44:03	2018-12-06	13
60	1	22	2018-12-06 14:40:38	2018-12-06	13
61	2	22	2018-12-06 14:40:40	2018-12-06	13
62	3	22	2018-12-06 14:40:42	2018-12-06	13
63	1	23	2018-12-06 14:26:39	2018-12-06	13
64	2	23	2018-12-06 14:26:41	2018-12-06	13
65	3	23	2018-12-06 14:26:43	2018-12-06	13
66	1	24	2018-12-06 14:23:04	2018-12-06	13
67	2	24	2018-12-06 14:23:05	2018-12-06	13
68	3	24	2018-12-06 14:23:07	2018-12-06	13
69	1	25	2018-12-06 14:16:09	2018-12-06	13
70	2	25	2018-12-06 14:16:12	2018-12-06	13
71	3	25	2018-12-06 14:20:02	2018-12-06	13
72	1	26	2018-12-06 14:04:33	2018-12-06	13
73	2	26	2018-12-06 14:04:35	2018-12-06	13
74	3	26	2018-12-06 14:04:37	2018-12-06	13
75	1	27	2018-12-06 12:26:28	2018-12-06	11
76	2	27	2018-12-06 12:26:30	2018-12-06	11
77	3	27	2018-12-06 12:26:31	2018-12-06	11
78	1	28	2018-12-06 12:24:04	2018-12-06	11
79	2	28	2018-12-06 12:24:06	2018-12-06	11
80	3	28	2018-12-06 13:07:03	2018-12-06	12
81	1	29	2018-12-06 12:19:29	2018-12-06	11
82	2	29	2018-12-06 12:19:31	2018-12-06	11
83	3	29	2018-12-06 12:19:33	2018-12-06	11
84	1	30	2018-12-06 12:09:48	2018-12-06	11
85	2	30	2018-12-06 12:09:50	2018-12-06	11
86	3	30	2018-12-06 16:51:09	2018-12-06	15
87	1	31	2018-12-06 12:10:58	2018-12-06	11
88	2	31	2018-12-06 12:11:02	2018-12-06	11
89	3	31	2018-12-06 14:37:50	2018-12-06	13
90	1	32	2018-12-06 11:54:25	2018-12-06	10
91	2	32	2018-12-06 11:54:27	2018-12-06	10
92	3	32	2018-12-06 11:54:29	2018-12-06	10
93	1	33	2018-12-06 11:33:24	2018-12-06	10
94	2	33	2018-12-06 11:33:27	2018-12-06	10
95	3	33	2018-12-06 11:33:30	2018-12-06	10
96	1	34	2018-12-06 11:32:59	2018-12-06	10
97	2	34	2018-12-06 11:33:02	2018-12-06	10
98	3	34	2018-12-06 11:33:03	2018-12-06	10
99	1	35	2018-12-06 11:22:38	2018-12-06	10
100	2	35	2018-12-06 11:22:40	2018-12-06	10
101	3	35	2018-12-06 11:22:42	2018-12-06	10
102	1	36	2018-12-06 11:14:34	2018-12-06	10
103	2	36	2018-12-06 11:14:36	2018-12-06	10
104	3	36	2018-12-06 11:14:38	2018-12-06	10
105	1	37	2018-12-06 11:13:57	2018-12-06	10
106	2	37	2018-12-06 11:13:59	2018-12-06	10
107	3	37	2018-12-06 11:14:01	2018-12-06	10
108	1	38	2018-12-06 11:01:09	2018-12-06	10
109	2	38	2018-12-06 11:01:11	2018-12-06	10
110	3	38	2018-12-06 11:01:13	2018-12-06	10
111	1	39	2018-12-06 10:53:23	2018-12-06	9
112	2	39	2018-12-06 10:53:24	2018-12-06	9
113	3	39	2018-12-06 10:53:26	2018-12-06	9
114	1	40	2018-12-06 10:14:16	2018-12-06	9
115	2	40	2018-12-06 10:14:18	2018-12-06	9
116	3	40	2018-12-06 10:21:18	2018-12-06	9
117	1	41	2018-12-06 10:06:47	2018-12-06	9
118	2	41	2018-12-06 10:06:49	2018-12-06	9
119	3	41	2018-12-06 16:53:13	2018-12-06	15
120	1	42	2018-12-06 09:54:37	2018-12-06	8
121	2	42	2018-12-06 09:54:39	2018-12-06	8
122	3	42	2018-12-06 09:54:41	2018-12-06	8
123	1	43	2018-12-06 09:52:59	2018-12-06	8
124	2	43	2018-12-06 09:53:00	2018-12-06	8
125	3	43	2018-12-06 09:53:02	2018-12-06	8
126	1	44	2018-12-06 09:54:43	2018-12-06	8
127	2	44	2018-12-06 09:54:45	2018-12-06	8
128	3	44	2018-12-06 10:14:50	2018-12-06	9
129	1	45	2018-12-06 09:43:06	2018-12-06	8
130	2	45	2018-12-06 09:43:09	2018-12-06	8
131	3	45	2018-12-06 09:43:10	2018-12-06	8
132	1	46	2018-12-06 09:36:15	2018-12-06	8
133	2	46	2018-12-06 09:36:17	2018-12-06	8
134	3	46	2018-12-06 09:36:19	2018-12-06	8
135	1	47	2018-12-06 09:18:10	2018-12-06	8
136	2	47	2018-12-06 09:18:12	2018-12-06	8
137	3	47	2018-12-06 09:18:14	2018-12-06	8
138	1	48	2018-12-06 09:22:07	2018-12-06	8
139	2	48	2018-12-06 09:22:08	2018-12-06	8
140	3	48	2018-12-06 09:32:37	2018-12-06	8
141	1	49	2018-12-06 09:04:07	2018-12-06	8
142	2	49	2018-12-06 09:04:10	2018-12-06	8
143	3	49	2018-12-06 09:32:13	2018-12-06	8
144	1	50	2018-12-06 08:55:01	2018-12-06	7
145	2	50	2018-12-06 08:55:03	2018-12-06	7
146	3	50	2018-12-06 08:55:04	2018-12-06	7
147	1	51	2018-12-06 08:49:06	2018-12-06	7
148	2	51	2018-12-06 08:49:08	2018-12-06	7
149	3	51	2018-12-06 08:49:10	2018-12-06	7
150	1	52	2018-12-06 08:44:27	2018-12-06	7
151	2	52	2018-12-06 08:44:29	2018-12-06	7
152	3	52	2018-12-06 08:44:31	2018-12-06	7
153	1	53	2018-12-06 08:32:36	2018-12-06	7
154	2	53	2018-12-06 08:32:38	2018-12-06	7
155	3	53	2018-12-06 08:32:39	2018-12-06	7
156	1	54	2018-12-05 17:37:18	2018-12-05	16
157	2	54	2018-12-05 17:37:22	2018-12-05	16
158	3	54	2018-12-06 09:42:16	2018-12-06	8
159	1	55	2018-12-05 16:58:53	2018-12-05	15
160	2	55	2018-12-05 16:58:55	2018-12-05	15
161	3	55	2018-12-05 16:58:57	2018-12-05	15
162	1	56	2018-12-05 16:44:13	2018-12-05	15
163	2	56	2018-12-05 16:44:15	2018-12-05	15
164	3	56	2018-12-05 16:44:17	2018-12-05	15
165	1	57	2018-12-05 16:41:57	2018-12-05	15
166	2	57	2018-12-05 16:41:59	2018-12-05	15
167	3	57	2018-12-05 16:42:01	2018-12-05	15
168	1	58	2018-12-05 16:40:25	2018-12-05	15
169	2	58	2018-12-05 16:40:27	2018-12-05	15
170	1	59	2018-12-05 16:39:56	2018-12-05	15
171	2	59	2018-12-05 16:39:57	2018-12-05	15
172	1	60	2018-12-05 16:36:58	2018-12-05	15
173	2	60	2018-12-05 16:37:00	2018-12-05	15
174	3	60	2018-12-05 16:37:02	2018-12-05	15
175	1	61	2018-12-05 16:25:23	2018-12-05	15
176	2	61	2018-12-05 16:25:24	2018-12-05	15
177	3	61	2018-12-05 16:29:41	2018-12-05	15
178	1	62	2018-12-05 16:14:28	2018-12-05	15
179	2	62	2018-12-05 16:14:31	2018-12-05	15
180	1	63	2018-12-05 16:59:09	2018-12-05	15
181	2	63	2018-12-05 16:59:12	2018-12-05	15
182	1	64	2018-12-05 15:36:46	2018-12-05	14
183	2	64	2018-12-05 15:36:48	2018-12-05	14
184	3	64	2018-12-05 15:36:49	2018-12-05	14
185	1	65	2018-12-05 15:24:35	2018-12-05	14
186	2	65	2018-12-05 15:24:36	2018-12-05	14
187	3	65	2018-12-05 15:24:38	2018-12-05	14
188	1	66	2018-12-05 15:03:11	2018-12-05	14
189	2	66	2018-12-05 15:03:13	2018-12-05	14
190	3	66	2018-12-05 15:15:28	2018-12-05	14
191	1	67	2018-12-05 14:52:30	2018-12-05	13
192	2	67	2018-12-05 14:52:32	2018-12-05	13
193	3	67	2018-12-05 14:52:34	2018-12-05	13
194	1	68	2018-12-05 14:49:18	2018-12-05	13
195	2	68	2018-12-05 14:49:20	2018-12-05	13
196	3	68	2018-12-05 15:39:09	2018-12-05	14
197	1	69	2018-12-05 14:48:08	2018-12-05	13
198	2	69	2018-12-05 14:48:10	2018-12-05	13
199	3	69	2018-12-05 14:50:11	2018-12-05	13
200	1	70	2018-12-05 14:41:01	2018-12-05	13
201	2	70	2018-12-05 14:41:03	2018-12-05	13
202	3	70	2018-12-05 14:41:05	2018-12-05	13
203	1	71	2018-12-05 14:31:12	2018-12-05	13
204	2	71	2018-12-05 14:31:14	2018-12-05	13
205	3	71	2018-12-05 14:31:16	2018-12-05	13
206	1	72	2018-12-05 14:29:11	2018-12-05	13
207	2	72	2018-12-05 14:29:13	2018-12-05	13
208	3	72	2018-12-05 14:29:15	2018-12-05	13
209	1	73	2018-12-05 14:23:47	2018-12-05	13
210	2	73	2018-12-05 14:23:48	2018-12-05	13
211	3	73	2018-12-05 14:23:50	2018-12-05	13
212	1	74	2018-12-05 14:17:43	2018-12-05	13
213	2	74	2018-12-05 14:17:46	2018-12-05	13
214	3	74	2018-12-05 14:17:49	2018-12-05	13
215	1	75	2018-12-05 14:16:39	2018-12-05	13
216	2	75	2018-12-05 14:16:41	2018-12-05	13
217	3	75	2018-12-05 14:16:43	2018-12-05	13
218	1	76	2018-12-05 14:14:10	2018-12-05	13
219	2	76	2018-12-05 14:14:12	2018-12-05	13
220	3	76	2018-12-05 14:14:14	2018-12-05	13
221	1	77	2018-12-05 14:08:11	2018-12-05	13
222	2	77	2018-12-05 14:08:13	2018-12-05	13
223	3	77	2018-12-05 14:08:16	2018-12-05	13
224	1	78	2018-12-05 12:00:18	2018-12-05	11
225	2	78	2018-12-05 12:00:20	2018-12-05	11
226	3	78	2018-12-05 12:00:22	2018-12-05	11
227	1	79	2018-12-05 11:43:23	2018-12-05	10
228	2	79	2018-12-05 11:43:25	2018-12-05	10
229	3	79	2018-12-05 11:43:27	2018-12-05	10
230	1	80	2018-12-05 11:41:29	2018-12-05	10
231	2	80	2018-12-05 11:41:31	2018-12-05	10
232	3	80	2018-12-05 11:41:33	2018-12-05	10
233	1	81	2018-12-05 11:37:23	2018-12-05	10
234	2	81	2018-12-05 11:37:25	2018-12-05	10
235	3	81	2018-12-05 11:59:40	2018-12-05	10
236	1	82	2018-12-05 11:16:24	2018-12-05	10
237	2	82	2018-12-05 11:16:25	2018-12-05	10
238	3	82	2018-12-05 11:16:27	2018-12-05	10
239	1	83	2018-12-05 11:08:55	2018-12-05	10
240	2	83	2018-12-05 11:08:57	2018-12-05	10
241	3	83	2018-12-05 11:09:00	2018-12-05	10
242	1	84	2018-12-05 11:03:52	2018-12-05	10
243	2	84	2018-12-05 11:03:54	2018-12-05	10
244	3	84	2018-12-05 11:03:56	2018-12-05	10
245	1	85	2018-12-05 11:03:44	2018-12-05	10
246	2	85	2018-12-05 11:03:46	2018-12-05	10
247	3	85	2018-12-05 11:03:48	2018-12-05	10
248	1	86	2018-12-05 11:00:35	2018-12-05	10
249	2	86	2018-12-05 11:00:37	2018-12-05	10
250	3	86	2018-12-05 15:32:41	2018-12-05	14
251	1	87	2018-12-05 10:56:14	2018-12-05	9
252	2	87	2018-12-05 10:56:17	2018-12-05	9
253	3	87	2018-12-05 11:00:52	2018-12-05	10
254	1	88	2018-12-05 10:52:36	2018-12-05	9
255	2	88	2018-12-05 10:52:38	2018-12-05	9
256	3	88	2018-12-05 10:52:40	2018-12-05	9
257	1	89	2018-12-05 10:51:57	2018-12-05	9
258	2	89	2018-12-05 10:51:59	2018-12-05	9
259	3	89	2018-12-05 10:52:01	2018-12-05	9
260	1	90	2018-12-05 10:37:05	2018-12-05	9
261	2	90	2018-12-05 10:37:07	2018-12-05	9
262	3	90	2018-12-05 10:37:09	2018-12-05	9
263	1	91	2018-12-05 10:30:58	2018-12-05	9
264	2	91	2018-12-05 10:31:00	2018-12-05	9
265	3	91	2018-12-05 10:31:02	2018-12-05	9
266	1	92	2018-12-05 10:26:11	2018-12-05	9
267	2	92	2018-12-05 10:26:14	2018-12-05	9
268	3	92	2018-12-05 10:38:22	2018-12-05	9
269	1	93	2018-12-05 10:05:12	2018-12-05	9
270	2	93	2018-12-05 10:05:13	2018-12-05	9
271	3	93	2018-12-05 10:05:15	2018-12-05	9
272	1	94	2018-12-05 10:04:31	2018-12-05	9
273	2	94	2018-12-05 10:04:33	2018-12-05	9
274	3	94	2018-12-05 10:04:35	2018-12-05	9
275	1	95	2018-12-05 10:00:43	2018-12-05	9
276	2	95	2018-12-05 10:00:45	2018-12-05	9
277	3	95	2018-12-05 10:07:58	2018-12-05	9
278	1	96	2018-12-05 09:44:19	2018-12-05	8
279	2	96	2018-12-05 09:44:21	2018-12-05	8
280	3	96	2018-12-05 09:44:22	2018-12-05	8
281	1	97	2018-12-05 09:39:34	2018-12-05	8
282	2	97	2018-12-05 09:39:35	2018-12-05	8
283	3	97	2018-12-05 09:39:38	2018-12-05	8
284	1	98	2018-12-05 09:32:19	2018-12-05	8
285	2	98	2018-12-05 09:32:21	2018-12-05	8
286	3	98	2018-12-05 09:32:23	2018-12-05	8
287	1	99	2018-12-05 09:28:25	2018-12-05	8
288	2	99	2018-12-05 09:28:27	2018-12-05	8
289	3	99	2018-12-05 09:28:29	2018-12-05	8
290	1	100	2018-12-05 09:22:22	2018-12-05	8
291	2	100	2018-12-05 09:22:24	2018-12-05	8
292	3	100	2018-12-05 09:22:26	2018-12-05	8
293	1	101	2018-12-05 09:08:18	2018-12-05	8
294	2	101	2018-12-05 09:08:19	2018-12-05	8
295	3	101	2018-12-05 09:08:21	2018-12-05	8
296	1	102	2018-12-05 09:07:33	2018-12-05	8
297	2	102	2018-12-05 09:07:35	2018-12-05	8
298	3	102	2018-12-05 10:32:35	2018-12-05	9
299	1	103	2018-12-05 09:02:27	2018-12-05	8
300	2	103	2018-12-05 09:02:29	2018-12-05	8
301	3	103	2018-12-05 09:02:31	2018-12-05	8
302	1	104	2018-12-05 08:49:39	2018-12-05	7
303	2	104	2018-12-05 08:49:41	2018-12-05	7
304	3	104	2018-12-05 13:54:35	2018-12-05	12
305	1	105	2018-12-05 08:42:44	2018-12-05	7
306	2	105	2018-12-05 08:42:45	2018-12-05	7
307	3	105	2018-12-05 08:42:47	2018-12-05	7
308	1	106	2018-12-05 07:39:36	2018-12-05	6
309	2	106	2018-12-05 07:39:38	2018-12-05	6
310	3	106	2018-12-05 07:41:40	2018-12-05	6
311	1	107	2018-12-04 17:41:49	2018-12-04	16
312	2	107	2018-12-04 17:41:52	2018-12-04	16
313	3	107	2018-12-05 15:27:39	2018-12-05	14
314	1	108	2018-12-04 16:58:02	2018-12-04	15
315	2	108	2018-12-04 16:58:06	2018-12-04	15
316	3	108	2018-12-05 15:45:08	2018-12-05	14
317	1	109	2018-12-04 16:47:07	2018-12-04	15
318	2	109	2018-12-04 16:47:10	2018-12-04	15
319	3	109	2018-12-04 16:47:13	2018-12-04	15
320	1	110	2018-12-04 16:33:58	2018-12-04	15
321	2	110	2018-12-04 16:34:00	2018-12-04	15
322	3	110	2018-12-04 16:34:01	2018-12-04	15
323	1	111	2018-12-04 16:00:45	2018-12-04	15
324	2	111	2018-12-04 16:00:47	2018-12-04	15
325	3	111	2018-12-04 16:00:49	2018-12-04	15
326	1	112	2018-12-04 16:00:41	2018-12-04	15
327	2	112	2018-12-04 16:00:42	2018-12-04	15
328	3	112	2018-12-04 16:00:44	2018-12-04	15
329	1	113	2018-12-04 15:48:24	2018-12-04	14
330	2	113	2018-12-04 15:48:25	2018-12-04	14
331	3	113	2018-12-04 15:48:27	2018-12-04	14
332	1	114	2018-12-04 15:46:24	2018-12-04	14
333	2	114	2018-12-04 15:46:26	2018-12-04	14
334	3	114	2018-12-04 15:46:28	2018-12-04	14
335	1	115	2018-12-04 15:47:17	2018-12-04	14
336	2	115	2018-12-04 15:47:20	2018-12-04	14
337	3	115	2018-12-05 15:10:04	2018-12-05	14
338	1	116	2018-12-04 15:36:10	2018-12-04	14
339	2	116	2018-12-04 15:36:12	2018-12-04	14
340	3	116	2018-12-04 15:36:14	2018-12-04	14
341	1	117	2018-12-04 15:29:35	2018-12-04	14
342	2	117	2018-12-04 15:29:36	2018-12-04	14
343	3	117	2018-12-04 15:29:38	2018-12-04	14
344	1	118	2018-12-04 15:21:55	2018-12-04	14
345	2	118	2018-12-04 15:21:57	2018-12-04	14
346	3	118	2018-12-04 15:21:59	2018-12-04	14
347	1	119	2018-12-04 15:13:58	2018-12-04	14
348	2	119	2018-12-04 15:14:00	2018-12-04	14
349	3	119	2018-12-04 15:14:02	2018-12-04	14
350	1	120	2018-12-04 15:11:14	2018-12-04	14
351	2	120	2018-12-04 15:11:16	2018-12-04	14
352	3	120	2018-12-04 15:11:18	2018-12-04	14
353	1	121	2018-12-04 15:06:30	2018-12-04	14
354	2	121	2018-12-04 15:06:33	2018-12-04	14
355	3	121	2018-12-04 15:06:34	2018-12-04	14
356	1	122	2018-12-04 15:05:11	2018-12-04	14
357	2	122	2018-12-04 15:05:13	2018-12-04	14
358	3	122	2018-12-04 15:05:15	2018-12-04	14
359	1	123	2018-12-04 15:03:09	2018-12-04	14
360	2	123	2018-12-04 15:03:11	2018-12-04	14
361	3	123	2018-12-05 08:04:14	2018-12-05	7
362	1	124	2018-12-04 15:00:47	2018-12-04	14
363	2	124	2018-12-04 15:00:49	2018-12-04	14
364	3	124	2018-12-05 11:55:46	2018-12-05	10
365	1	125	2018-12-04 15:08:34	2018-12-04	14
366	2	125	2018-12-04 15:08:36	2018-12-04	14
367	3	125	2018-12-05 15:08:05	2018-12-05	14
368	1	126	2018-12-04 14:44:43	2018-12-04	13
369	2	126	2018-12-04 14:44:45	2018-12-04	13
370	3	126	2018-12-04 14:44:47	2018-12-04	13
371	1	127	2018-12-04 14:41:05	2018-12-04	13
372	2	127	2018-12-04 14:41:06	2018-12-04	13
373	3	127	2018-12-04 14:41:08	2018-12-04	13
374	1	128	2018-12-04 14:38:10	2018-12-04	13
375	2	128	2018-12-04 14:38:12	2018-12-04	13
376	3	128	2018-12-04 14:38:14	2018-12-04	13
377	1	129	2018-12-04 14:33:59	2018-12-04	13
378	2	129	2018-12-04 14:34:02	2018-12-04	13
379	3	129	2018-12-04 14:34:17	2018-12-04	13
380	1	130	2018-12-04 14:30:17	2018-12-04	13
381	2	130	2018-12-04 14:30:19	2018-12-04	13
382	3	130	2018-12-04 14:30:21	2018-12-04	13
383	1	131	2018-12-04 14:24:32	2018-12-04	13
384	2	131	2018-12-04 14:24:34	2018-12-04	13
385	1	132	2018-12-04 14:21:25	2018-12-04	13
386	2	132	2018-12-04 14:21:27	2018-12-04	13
387	3	132	2018-12-04 14:21:29	2018-12-04	13
388	1	133	2018-12-04 14:10:06	2018-12-04	13
389	2	133	2018-12-04 14:10:08	2018-12-04	13
390	3	133	2018-12-04 14:10:10	2018-12-04	13
391	1	134	2018-12-04 14:01:13	2018-12-04	13
392	2	134	2018-12-04 14:01:14	2018-12-04	13
393	3	134	2018-12-04 14:01:16	2018-12-04	13
394	1	135	2018-12-04 12:04:40	2018-12-04	11
395	2	135	2018-12-04 12:04:43	2018-12-04	11
396	1	136	2018-12-04 12:00:50	2018-12-04	11
397	2	136	2018-12-04 12:00:53	2018-12-04	11
398	3	136	2018-12-04 15:30:59	2018-12-04	14
399	1	137	2018-12-04 11:18:14	2018-12-04	10
400	2	137	2018-12-04 11:18:16	2018-12-04	10
401	3	137	2018-12-04 11:18:18	2018-12-04	10
402	1	138	2018-12-04 11:15:49	2018-12-04	10
403	2	138	2018-12-04 11:15:51	2018-12-04	10
404	3	138	2018-12-04 11:15:53	2018-12-04	10
405	1	139	2018-12-04 11:09:14	2018-12-04	10
406	2	139	2018-12-04 11:09:17	2018-12-04	10
407	3	139	2018-12-04 11:09:20	2018-12-04	10
408	1	140	2018-12-04 11:04:07	2018-12-04	10
409	2	140	2018-12-04 11:04:09	2018-12-04	10
410	3	140	2018-12-04 11:04:11	2018-12-04	10
411	1	141	2018-12-04 11:03:20	2018-12-04	10
412	2	141	2018-12-04 11:03:23	2018-12-04	10
413	3	141	2018-12-04 11:03:26	2018-12-04	10
414	1	142	2018-12-04 11:02:34	2018-12-04	10
415	2	142	2018-12-04 11:02:36	2018-12-04	10
416	3	142	2018-12-04 11:09:52	2018-12-04	10
417	1	143	2018-12-04 10:58:06	2018-12-04	9
418	2	143	2018-12-04 10:58:08	2018-12-04	9
419	3	143	2018-12-04 10:58:09	2018-12-04	9
420	1	144	2018-12-04 10:55:53	2018-12-04	9
421	2	144	2018-12-04 10:55:55	2018-12-04	9
422	3	144	2018-12-04 10:55:57	2018-12-04	9
423	1	145	2018-12-04 10:44:13	2018-12-04	9
424	2	145	2018-12-04 10:44:15	2018-12-04	9
425	3	145	2018-12-04 10:44:17	2018-12-04	9
426	1	146	2018-12-04 10:38:00	2018-12-04	9
427	2	146	2018-12-04 10:38:02	2018-12-04	9
428	3	146	2018-12-04 10:38:04	2018-12-04	9
429	1	147	2018-12-04 10:31:10	2018-12-04	9
430	2	147	2018-12-04 10:31:12	2018-12-04	9
431	3	147	2018-12-04 10:31:14	2018-12-04	9
432	1	148	2018-12-04 10:29:33	2018-12-04	9
433	2	148	2018-12-04 10:29:37	2018-12-04	9
434	3	148	2018-12-04 11:26:03	2018-12-04	10
435	1	149	2018-12-04 10:27:19	2018-12-04	9
436	2	149	2018-12-04 10:27:21	2018-12-04	9
437	3	149	2018-12-04 10:27:23	2018-12-04	9
438	1	150	2018-12-04 10:25:02	2018-12-04	9
439	2	150	2018-12-04 10:25:03	2018-12-04	9
440	3	150	2018-12-04 10:25:05	2018-12-04	9
441	1	151	2018-12-04 10:16:13	2018-12-04	9
442	2	151	2018-12-04 10:16:15	2018-12-04	9
443	3	151	2018-12-04 10:16:17	2018-12-04	9
444	1	152	2018-12-04 10:01:36	2018-12-04	9
445	2	152	2018-12-04 10:01:38	2018-12-04	9
446	3	152	2018-12-04 10:14:04	2018-12-04	9
447	1	153	2018-12-04 09:59:20	2018-12-04	8
448	2	153	2018-12-04 09:59:21	2018-12-04	8
449	3	153	2018-12-04 09:59:23	2018-12-04	8
450	1	154	2018-12-04 09:56:58	2018-12-04	8
451	2	154	2018-12-04 09:56:59	2018-12-04	8
452	3	154	2018-12-04 09:57:01	2018-12-04	8
453	1	155	2018-12-04 09:54:50	2018-12-04	8
454	2	155	2018-12-04 09:54:52	2018-12-04	8
455	3	155	2018-12-04 09:54:54	2018-12-04	8
456	1	156	2018-12-04 09:50:45	2018-12-04	8
457	2	156	2018-12-04 09:50:46	2018-12-04	8
458	3	156	2018-12-04 09:50:48	2018-12-04	8
459	1	157	2018-12-04 09:40:29	2018-12-04	8
460	2	157	2018-12-04 09:40:31	2018-12-04	8
461	3	157	2018-12-04 09:44:28	2018-12-04	8
462	1	158	2018-12-04 09:26:55	2018-12-04	8
463	2	158	2018-12-04 09:26:58	2018-12-04	8
464	3	158	2018-12-04 09:27:04	2018-12-04	8
465	1	159	2018-12-04 09:23:31	2018-12-04	8
466	2	159	2018-12-04 09:23:34	2018-12-04	8
467	3	159	2018-12-04 09:23:36	2018-12-04	8
468	1	160	2018-12-04 09:19:53	2018-12-04	8
469	2	160	2018-12-04 09:19:55	2018-12-04	8
470	3	160	2018-12-04 09:19:57	2018-12-04	8
471	1	161	2018-12-04 09:05:25	2018-12-04	8
472	2	161	2018-12-04 09:05:27	2018-12-04	8
473	3	161	2018-12-04 09:05:29	2018-12-04	8
474	1	162	2018-12-04 08:45:23	2018-12-04	7
475	2	162	2018-12-04 08:45:25	2018-12-04	7
476	3	162	2018-12-04 08:45:27	2018-12-04	7
477	1	163	2018-12-04 08:41:42	2018-12-04	7
478	2	163	2018-12-04 08:41:43	2018-12-04	7
479	3	163	2018-12-04 08:41:45	2018-12-04	7
480	1	164	2018-12-04 08:38:20	2018-12-04	7
481	2	164	2018-12-04 08:38:22	2018-12-04	7
482	3	164	2018-12-04 08:38:24	2018-12-04	7
483	1	165	2018-12-04 07:40:38	2018-12-04	6
484	2	165	2018-12-04 07:40:40	2018-12-04	6
485	3	165	2018-12-04 07:42:13	2018-12-04	6
486	1	166	2018-12-03 16:41:04	2018-12-03	15
487	2	166	2018-12-03 16:41:06	2018-12-03	15
488	3	166	2018-12-05 15:05:14	2018-12-05	14
489	1	167	2018-12-03 16:35:20	2018-12-03	15
490	2	167	2018-12-03 16:35:22	2018-12-03	15
491	3	167	2018-12-05 14:53:08	2018-12-05	13
492	1	168	2018-12-03 16:08:45	2018-12-03	15
493	2	168	2018-12-03 16:08:47	2018-12-03	15
494	3	168	2018-12-03 16:08:49	2018-12-03	15
495	1	169	2018-12-03 15:25:55	2018-12-03	14
496	2	169	2018-12-03 15:25:57	2018-12-03	14
497	1	170	2018-12-03 15:27:21	2018-12-03	14
498	2	170	2018-12-03 15:27:23	2018-12-03	14
499	1	171	2018-12-03 15:13:45	2018-12-03	14
500	2	171	2018-12-03 15:13:47	2018-12-03	14
501	3	171	2018-12-03 15:13:49	2018-12-03	14
502	1	172	2018-12-03 15:02:27	2018-12-03	14
503	2	172	2018-12-03 15:02:29	2018-12-03	14
504	3	172	2018-12-03 15:02:31	2018-12-03	14
505	1	173	2018-12-03 14:50:53	2018-12-03	13
506	2	173	2018-12-03 14:50:55	2018-12-03	13
507	3	173	2018-12-03 14:50:57	2018-12-03	13
508	1	174	2018-12-03 14:31:02	2018-12-03	13
509	2	174	2018-12-03 14:31:05	2018-12-03	13
510	3	174	2018-12-03 14:31:07	2018-12-03	13
511	1	175	2018-12-03 14:31:10	2018-12-03	13
512	2	175	2018-12-03 14:31:13	2018-12-03	13
513	3	175	2018-12-05 14:47:29	2018-12-05	13
514	1	176	2018-12-03 14:21:59	2018-12-03	13
515	2	176	2018-12-03 14:22:00	2018-12-03	13
516	3	176	2018-12-03 14:22:02	2018-12-03	13
517	1	177	2018-12-03 14:13:15	2018-12-03	13
518	2	177	2018-12-03 14:13:16	2018-12-03	13
519	3	177	2018-12-03 14:13:18	2018-12-03	13
520	1	178	2018-12-03 14:06:39	2018-12-03	13
521	2	178	2018-12-03 14:06:41	2018-12-03	13
522	3	178	2018-12-03 14:06:43	2018-12-03	13
523	1	179	2018-12-03 14:04:34	2018-12-03	13
524	2	179	2018-12-03 14:04:36	2018-12-03	13
525	3	179	2018-12-03 14:04:38	2018-12-03	13
526	1	180	2018-12-03 13:42:42	2018-12-03	12
527	2	180	2018-12-03 13:42:43	2018-12-03	12
528	3	180	2018-12-03 13:48:53	2018-12-03	12
529	1	181	2018-12-03 13:48:56	2018-12-03	12
530	2	181	2018-12-03 13:48:58	2018-12-03	12
531	3	181	2018-12-04 09:08:35	2018-12-04	8
532	1	182	2018-12-03 12:11:27	2018-12-03	11
533	2	182	2018-12-03 12:11:30	2018-12-03	11
534	1	182	2018-12-03 14:39:54	2018-12-03	13
535	2	182	2018-12-03 14:39:56	2018-12-03	13
536	3	182	2018-12-03 14:39:57	2018-12-03	13
537	1	183	2018-12-03 12:01:07	2018-12-03	11
538	2	183	2018-12-03 12:01:09	2018-12-03	11
539	3	183	2018-12-03 12:01:11	2018-12-03	11
540	1	184	2018-12-03 11:52:46	2018-12-03	10
541	2	184	2018-12-03 11:52:49	2018-12-03	10
542	1	185	2018-12-03 11:41:35	2018-12-03	10
543	2	185	2018-12-03 11:41:37	2018-12-03	10
544	3	185	2018-12-03 11:41:39	2018-12-03	10
545	1	186	2018-12-03 11:34:30	2018-12-03	10
546	2	186	2018-12-03 11:34:32	2018-12-03	10
547	3	186	2018-12-04 12:16:12	2018-12-04	11
548	1	187	2018-12-03 11:19:13	2018-12-03	10
549	2	187	2018-12-03 11:19:16	2018-12-03	10
550	3	187	2018-12-03 11:19:18	2018-12-03	10
551	1	188	2018-12-03 11:19:01	2018-12-03	10
552	2	188	2018-12-03 11:19:03	2018-12-03	10
553	3	188	2018-12-03 11:19:05	2018-12-03	10
554	1	189	2018-12-03 11:10:01	2018-12-03	10
555	2	189	2018-12-03 11:10:03	2018-12-03	10
556	3	189	2018-12-03 11:10:05	2018-12-03	10
557	1	190	2018-12-03 11:00:44	2018-12-03	10
558	2	190	2018-12-03 11:00:46	2018-12-03	10
559	3	190	2018-12-03 11:00:48	2018-12-03	10
560	1	191	2018-12-03 11:01:29	2018-12-03	10
561	2	191	2018-12-03 11:01:32	2018-12-03	10
562	3	191	2018-12-05 14:20:44	2018-12-05	13
563	1	192	2018-12-03 10:43:14	2018-12-03	9
564	2	192	2018-12-03 10:43:16	2018-12-03	9
565	3	192	2018-12-03 10:44:14	2018-12-03	9
566	1	193	2018-12-03 10:41:05	2018-12-03	9
567	2	193	2018-12-03 10:41:08	2018-12-03	9
568	3	193	2018-12-04 09:05:00	2018-12-04	8
569	1	194	2018-12-03 10:34:24	2018-12-03	9
570	2	194	2018-12-03 10:34:26	2018-12-03	9
571	3	194	2018-12-03 10:34:28	2018-12-03	9
572	1	195	2018-12-03 10:14:52	2018-12-03	9
573	2	195	2018-12-03 10:14:55	2018-12-03	9
574	3	195	2018-12-03 10:30:15	2018-12-03	9
575	1	196	2018-12-03 10:13:28	2018-12-03	9
576	2	196	2018-12-03 10:13:30	2018-12-03	9
577	3	196	2018-12-03 10:13:32	2018-12-03	9
578	1	197	2018-12-03 10:03:28	2018-12-03	9
579	2	197	2018-12-03 10:03:31	2018-12-03	9
580	3	197	2018-12-03 10:03:33	2018-12-03	9
581	1	198	2018-12-03 10:02:32	2018-12-03	9
582	2	198	2018-12-03 10:02:36	2018-12-03	9
583	3	198	2018-12-04 09:30:43	2018-12-04	8
584	1	199	2018-12-03 09:56:05	2018-12-03	8
585	2	199	2018-12-03 09:56:07	2018-12-03	8
586	3	199	2018-12-03 09:56:09	2018-12-03	8
587	1	200	2018-12-03 09:48:06	2018-12-03	8
588	2	200	2018-12-03 09:48:08	2018-12-03	8
589	3	200	2018-12-03 09:48:10	2018-12-03	8
590	1	201	2018-12-03 09:43:13	2018-12-03	8
591	2	201	2018-12-03 09:43:15	2018-12-03	8
592	3	201	2018-12-03 09:43:17	2018-12-03	8
593	1	202	2018-12-03 09:37:47	2018-12-03	8
594	2	202	2018-12-03 09:37:49	2018-12-03	8
595	3	202	2018-12-03 09:37:51	2018-12-03	8
596	1	203	2018-12-03 09:35:17	2018-12-03	8
597	2	203	2018-12-03 09:35:19	2018-12-03	8
598	3	203	2018-12-03 09:35:21	2018-12-03	8
599	1	204	2018-12-03 08:52:02	2018-12-03	7
600	2	204	2018-12-03 08:52:04	2018-12-03	7
601	3	204	2018-12-03 08:52:06	2018-12-03	7
602	1	205	2018-12-03 08:36:19	2018-12-03	7
603	2	205	2018-12-03 08:36:22	2018-12-03	7
604	3	205	2018-12-03 08:43:58	2018-12-03	7
605	1	206	2018-12-03 07:43:43	2018-12-03	6
606	2	206	2018-12-03 07:43:45	2018-12-03	6
607	3	206	2018-12-03 07:45:26	2018-12-03	6
608	1	207	2018-12-03 07:39:33	2018-12-03	6
609	2	207	2018-12-03 07:39:38	2018-12-03	6
610	3	207	2018-12-05 14:11:49	2018-12-05	13
611	1	208	2018-12-02 21:27:42	2018-12-02	20
612	2	208	2018-12-02 21:27:44	2018-12-02	20
613	1	209	2018-12-01 16:03:22	2018-12-01	15
614	2	209	2018-12-01 16:03:25	2018-12-01	15
615	3	209	2018-12-03 07:51:34	2018-12-03	6
616	1	210	2018-11-30 16:28:37	2018-11-30	15
617	2	210	2018-11-30 16:28:39	2018-11-30	15
618	3	210	2018-11-30 16:28:41	2018-11-30	15
619	1	211	2018-11-30 15:11:29	2018-11-30	14
620	2	211	2018-11-30 15:11:32	2018-11-30	14
621	3	211	2018-12-03 16:20:10	2018-12-03	15
622	1	212	2018-11-30 14:47:57	2018-11-30	13
623	2	212	2018-11-30 14:47:59	2018-11-30	13
624	3	212	2018-11-30 14:48:00	2018-11-30	13
625	1	213	2018-11-30 14:31:54	2018-11-30	13
626	2	213	2018-11-30 14:31:57	2018-11-30	13
627	3	213	2018-11-30 15:11:36	2018-11-30	14
628	1	214	2018-11-30 14:15:32	2018-11-30	13
629	2	214	2018-11-30 14:15:34	2018-11-30	13
630	3	214	2018-11-30 14:15:36	2018-11-30	13
631	1	215	2018-11-30 14:14:25	2018-11-30	13
632	2	215	2018-11-30 14:14:27	2018-11-30	13
633	3	215	2018-11-30 14:20:35	2018-11-30	13
634	1	216	2018-11-30 14:17:26	2018-11-30	13
635	2	216	2018-11-30 14:17:28	2018-11-30	13
636	3	216	2018-12-04 10:44:58	2018-12-04	9
637	1	217	2018-11-30 14:09:16	2018-11-30	13
638	2	217	2018-11-30 14:09:17	2018-11-30	13
639	3	217	2018-11-30 14:09:19	2018-11-30	13
640	1	218	2018-11-30 14:05:54	2018-11-30	13
641	2	218	2018-11-30 14:05:56	2018-11-30	13
642	3	218	2018-11-30 14:05:58	2018-11-30	13
643	1	219	2018-11-30 13:59:49	2018-11-30	12
644	2	219	2018-11-30 13:59:51	2018-11-30	12
645	3	219	2018-12-03 16:21:33	2018-12-03	15
646	1	220	2018-11-30 12:02:11	2018-11-30	11
647	2	220	2018-11-30 12:02:13	2018-11-30	11
648	3	220	2018-11-30 13:25:37	2018-11-30	12
649	1	221	2018-11-30 11:56:02	2018-11-30	10
650	2	221	2018-11-30 11:56:04	2018-11-30	10
651	1	222	2018-11-30 11:47:37	2018-11-30	10
652	2	222	2018-11-30 11:47:39	2018-11-30	10
653	3	222	2018-11-30 11:47:41	2018-11-30	10
654	1	223	2018-11-30 11:13:29	2018-11-30	10
655	2	223	2018-11-30 11:13:31	2018-11-30	10
656	3	223	2018-11-30 11:29:42	2018-11-30	10
657	1	224	2018-11-30 11:09:47	2018-11-30	10
658	2	224	2018-11-30 11:09:48	2018-11-30	10
659	3	224	2018-11-30 11:09:50	2018-11-30	10
660	1	225	2018-11-30 10:04:01	2018-11-30	9
661	2	225	2018-11-30 10:04:03	2018-11-30	9
662	3	225	2018-11-30 10:04:04	2018-11-30	9
663	1	226	2018-11-30 09:55:10	2018-11-30	8
664	2	226	2018-11-30 09:55:12	2018-11-30	8
665	3	226	2018-11-30 09:55:14	2018-11-30	8
666	1	227	2018-11-30 09:32:25	2018-11-30	8
667	2	227	2018-11-30 09:32:27	2018-11-30	8
668	3	227	2018-11-30 09:32:29	2018-11-30	8
669	1	228	2018-11-30 09:07:48	2018-11-30	8
670	2	228	2018-11-30 09:07:50	2018-11-30	8
671	3	228	2018-11-30 09:07:51	2018-11-30	8
672	1	229	2018-11-30 08:53:54	2018-11-30	7
673	2	229	2018-11-30 08:53:57	2018-11-30	7
674	3	229	2018-11-30 08:54:00	2018-11-30	7
675	1	230	2018-11-30 08:53:53	2018-11-30	7
676	2	230	2018-11-30 08:53:57	2018-11-30	7
677	3	230	2018-11-30 09:11:17	2018-11-30	8
678	1	231	2018-11-30 08:44:19	2018-11-30	7
679	2	231	2018-11-30 08:44:21	2018-11-30	7
680	3	231	2018-11-30 08:44:23	2018-11-30	7
681	1	232	2018-11-30 08:45:21	2018-11-30	7
682	2	232	2018-11-30 08:45:23	2018-11-30	7
683	3	232	2018-11-30 08:50:27	2018-11-30	7
684	1	233	2018-11-30 08:39:14	2018-11-30	7
685	2	233	2018-11-30 08:39:16	2018-11-30	7
686	3	233	2018-11-30 08:39:18	2018-11-30	7
687	1	234	2018-11-30 08:28:03	2018-11-30	7
688	2	234	2018-11-30 08:28:05	2018-11-30	7
689	3	234	2018-11-30 08:42:57	2018-11-30	7
690	1	235	2018-11-29 17:32:41	2018-11-29	16
691	2	235	2018-11-29 17:32:43	2018-11-29	16
692	3	235	2018-11-30 09:58:05	2018-11-30	8
693	1	236	2018-11-29 16:49:17	2018-11-29	15
694	2	236	2018-11-29 16:49:19	2018-11-29	15
695	3	236	2018-11-29 16:49:25	2018-11-29	15
696	1	237	2018-11-29 16:41:53	2018-11-29	15
697	2	237	2018-11-29 16:41:55	2018-11-29	15
698	3	237	2018-11-29 16:41:58	2018-11-29	15
699	1	238	2018-11-29 16:28:28	2018-11-29	15
700	2	238	2018-11-29 16:28:32	2018-11-29	15
701	3	238	2018-11-30 09:56:09	2018-11-30	8
702	1	239	2018-11-29 16:13:00	2018-11-29	15
703	2	239	2018-11-29 16:13:05	2018-11-29	15
704	3	239	2018-11-30 08:14:27	2018-11-30	7
705	1	240	2018-11-29 15:50:35	2018-11-29	14
706	2	240	2018-11-29 15:50:38	2018-11-29	14
707	1	241	2018-11-29 15:42:21	2018-11-29	14
708	2	241	2018-11-29 15:42:24	2018-11-29	14
709	3	241	2018-11-29 17:24:58	2018-11-29	16
710	1	242	2018-11-29 15:20:38	2018-11-29	14
711	2	242	2018-11-29 15:20:40	2018-11-29	14
712	3	242	2018-11-29 15:20:43	2018-11-29	14
713	1	243	2018-11-29 15:12:31	2018-11-29	14
714	2	243	2018-11-29 15:12:33	2018-11-29	14
715	3	243	2018-11-29 15:18:31	2018-11-29	14
716	1	244	2018-11-29 15:13:12	2018-11-29	14
717	2	244	2018-11-29 15:13:14	2018-11-29	14
718	3	244	2018-11-30 09:59:41	2018-11-30	8
719	1	245	2018-11-29 14:59:00	2018-11-29	13
720	2	245	2018-11-29 14:59:04	2018-11-29	13
721	3	245	2018-11-29 14:59:06	2018-11-29	13
722	1	246	2018-11-29 14:48:42	2018-11-29	13
723	2	246	2018-11-29 14:48:51	2018-11-29	13
724	1	247	2018-11-29 14:11:55	2018-11-29	13
725	2	247	2018-11-29 14:11:57	2018-11-29	13
726	3	247	2018-11-29 14:12:00	2018-11-29	13
727	1	248	2018-11-29 14:10:26	2018-11-29	13
728	2	248	2018-11-29 14:10:30	2018-11-29	13
729	3	248	2018-11-29 14:10:32	2018-11-29	13
730	1	249	2018-11-29 14:10:01	2018-11-29	13
731	2	249	2018-11-29 14:10:06	2018-11-29	13
732	3	249	2018-11-29 14:10:08	2018-11-29	13
733	1	250	2018-11-29 11:25:00	2018-11-29	10
734	2	250	2018-11-29 11:25:03	2018-11-29	10
735	3	250	2018-11-29 11:25:05	2018-11-29	10
736	1	251	2018-11-29 11:09:53	2018-11-29	10
737	2	251	2018-11-29 11:09:56	2018-11-29	10
738	3	251	2018-11-29 11:09:58	2018-11-29	10
739	1	252	2018-11-29 10:57:36	2018-11-29	9
740	2	252	2018-11-29 10:57:38	2018-11-29	9
741	3	252	2018-11-29 10:57:40	2018-11-29	9
742	1	253	2018-11-29 10:49:07	2018-11-29	9
743	2	253	2018-11-29 10:49:09	2018-11-29	9
744	3	253	2018-11-29 10:49:11	2018-11-29	9
745	1	254	2018-11-29 10:47:24	2018-11-29	9
746	2	254	2018-11-29 10:47:26	2018-11-29	9
747	3	254	2018-11-29 10:47:28	2018-11-29	9
748	1	255	2018-11-29 10:46:01	2018-11-29	9
749	2	255	2018-11-29 10:46:03	2018-11-29	9
750	3	255	2018-11-29 10:46:05	2018-11-29	9
751	1	256	2018-11-29 10:41:26	2018-11-29	9
752	2	256	2018-11-29 10:41:28	2018-11-29	9
753	3	256	2018-11-29 10:41:30	2018-11-29	9
754	1	257	2018-11-29 10:36:40	2018-11-29	9
755	2	257	2018-11-29 10:36:42	2018-11-29	9
756	3	257	2018-11-29 10:36:44	2018-11-29	9
757	1	258	2018-11-29 10:23:46	2018-11-29	9
758	2	258	2018-11-29 10:23:47	2018-11-29	9
759	3	258	2018-11-29 10:57:16	2018-11-29	9
760	1	259	2018-11-29 10:05:58	2018-11-29	9
761	2	259	2018-11-29 10:06:00	2018-11-29	9
762	3	259	2018-11-29 10:06:02	2018-11-29	9
763	1	260	2018-11-29 09:44:50	2018-11-29	8
764	2	260	2018-11-29 09:44:52	2018-11-29	8
765	3	260	2018-11-29 10:45:29	2018-11-29	9
766	1	261	2018-11-29 09:40:05	2018-11-29	8
767	2	261	2018-11-29 09:40:08	2018-11-29	8
768	3	261	2018-11-29 12:07:16	2018-11-29	11
769	1	262	2018-11-29 09:33:48	2018-11-29	8
770	2	262	2018-11-29 09:33:51	2018-11-29	8
771	3	262	2018-11-29 09:49:01	2018-11-29	8
772	1	263	2018-11-29 09:28:40	2018-11-29	8
773	2	263	2018-11-29 09:28:42	2018-11-29	8
774	3	263	2018-11-29 09:28:44	2018-11-29	8
775	1	264	2018-11-29 09:10:12	2018-11-29	8
776	2	264	2018-11-29 09:10:14	2018-11-29	8
777	3	264	2018-11-29 09:10:16	2018-11-29	8
778	1	265	2018-11-29 09:08:27	2018-11-29	8
779	2	265	2018-11-29 09:08:29	2018-11-29	8
780	3	265	2018-11-29 09:08:30	2018-11-29	8
781	1	266	2018-11-29 08:55:59	2018-11-29	7
782	2	266	2018-11-29 08:56:00	2018-11-29	7
783	3	266	2018-11-29 08:56:02	2018-11-29	7
784	1	267	2018-11-29 08:33:50	2018-11-29	7
785	2	267	2018-11-29 08:33:53	2018-11-29	7
786	3	267	2018-11-29 08:33:56	2018-11-29	7
787	1	268	2018-11-29 07:48:16	2018-11-29	6
788	2	268	2018-11-29 07:48:19	2018-11-29	6
789	3	268	2018-11-29 12:08:53	2018-11-29	11
790	1	269	2018-11-29 07:44:28	2018-11-29	6
791	2	269	2018-11-29 07:44:31	2018-11-29	6
792	3	269	2018-11-29 10:50:57	2018-11-29	9
793	1	270	2018-11-28 22:49:07	2018-11-28	21
794	2	270	2018-11-28 22:49:13	2018-11-28	21
795	3	270	2018-11-29 12:17:44	2018-11-29	11
796	1	271	2018-11-28 22:12:28	2018-11-28	21
797	2	271	2018-11-28 22:12:33	2018-11-28	21
798	1	272	2018-11-28 18:10:09	2018-11-28	17
799	2	272	2018-11-28 18:10:11	2018-11-28	17
800	1	273	2018-11-28 16:52:28	2018-11-28	15
801	2	273	2018-11-28 16:52:30	2018-11-28	15
802	3	273	2018-11-28 16:52:32	2018-11-28	15
803	1	274	2018-11-28 16:37:36	2018-11-28	15
804	2	274	2018-11-28 16:37:38	2018-11-28	15
805	3	274	2018-11-28 16:37:40	2018-11-28	15
806	1	275	2018-11-28 16:33:03	2018-11-28	15
807	2	275	2018-11-28 16:33:05	2018-11-28	15
808	3	275	2018-11-28 16:33:07	2018-11-28	15
809	1	276	2018-11-28 16:29:34	2018-11-28	15
810	2	276	2018-11-28 16:29:35	2018-11-28	15
811	3	276	2018-11-28 16:29:37	2018-11-28	15
812	1	277	2018-11-28 16:26:41	2018-11-28	15
813	2	277	2018-11-28 16:26:43	2018-11-28	15
814	3	277	2018-11-28 16:26:45	2018-11-28	15
815	1	278	2018-11-28 16:13:15	2018-11-28	15
816	2	278	2018-11-28 16:13:17	2018-11-28	15
817	3	278	2018-11-28 16:13:19	2018-11-28	15
818	1	279	2018-11-28 15:37:35	2018-11-28	14
819	2	279	2018-11-28 15:37:37	2018-11-28	14
820	3	279	2018-11-28 15:37:39	2018-11-28	14
821	1	280	2018-11-28 15:22:23	2018-11-28	14
822	2	280	2018-11-28 15:22:25	2018-11-28	14
823	3	280	2018-11-28 15:22:27	2018-11-28	14
824	1	281	2018-11-28 15:18:00	2018-11-28	14
825	2	281	2018-11-28 15:18:02	2018-11-28	14
826	3	281	2018-11-28 15:18:04	2018-11-28	14
827	1	282	2018-11-28 15:16:42	2018-11-28	14
828	2	282	2018-11-28 15:16:44	2018-11-28	14
829	3	282	2018-11-28 15:16:46	2018-11-28	14
830	1	283	2018-11-28 14:56:18	2018-11-28	13
831	2	283	2018-11-28 14:56:20	2018-11-28	13
832	3	283	2018-11-28 14:56:22	2018-11-28	13
833	1	284	2018-11-28 14:55:36	2018-11-28	13
834	2	284	2018-11-28 14:55:38	2018-11-28	13
835	3	284	2018-11-28 14:55:40	2018-11-28	13
836	1	285	2018-11-28 14:45:15	2018-11-28	13
837	2	285	2018-11-28 14:45:16	2018-11-28	13
838	3	285	2018-11-28 14:45:18	2018-11-28	13
839	1	286	2018-11-28 14:27:13	2018-11-28	13
840	2	286	2018-11-28 14:27:15	2018-11-28	13
841	3	286	2018-11-28 14:27:17	2018-11-28	13
842	1	287	2018-11-28 14:25:49	2018-11-28	13
843	2	287	2018-11-28 14:25:51	2018-11-28	13
844	3	287	2018-11-28 14:25:52	2018-11-28	13
845	1	288	2018-11-28 14:23:49	2018-11-28	13
846	2	288	2018-11-28 14:23:51	2018-11-28	13
847	3	288	2018-11-28 14:23:53	2018-11-28	13
848	1	289	2018-11-28 14:22:55	2018-11-28	13
849	2	289	2018-11-28 14:22:56	2018-11-28	13
850	3	289	2018-11-28 14:22:58	2018-11-28	13
851	1	290	2018-11-28 14:18:50	2018-11-28	13
852	2	290	2018-11-28 14:18:52	2018-11-28	13
853	3	290	2018-11-28 14:18:54	2018-11-28	13
854	1	291	2018-11-28 14:13:08	2018-11-28	13
855	2	291	2018-11-28 14:13:11	2018-11-28	13
856	1	292	2018-11-28 13:57:15	2018-11-28	12
857	2	292	2018-11-28 13:57:19	2018-11-28	12
858	1	293	2018-11-28 13:15:55	2018-11-28	12
859	2	293	2018-11-28 13:15:59	2018-11-28	12
860	3	293	2018-11-28 13:22:20	2018-11-28	12
861	1	294	2018-11-28 12:01:52	2018-11-28	11
862	2	294	2018-11-28 12:01:54	2018-11-28	11
863	3	294	2018-11-28 12:01:57	2018-11-28	11
864	1	295	2018-11-28 11:56:13	2018-11-28	10
865	2	295	2018-11-28 11:56:15	2018-11-28	10
866	3	295	2018-11-28 11:56:18	2018-11-28	10
867	1	296	2018-11-28 11:52:11	2018-11-28	10
868	2	296	2018-11-28 11:52:13	2018-11-28	10
869	3	296	2018-11-28 11:52:15	2018-11-28	10
870	1	297	2018-11-28 11:50:25	2018-11-28	10
871	2	297	2018-11-28 11:50:27	2018-11-28	10
872	3	297	2018-11-28 11:50:29	2018-11-28	10
873	1	298	2018-11-28 11:22:08	2018-11-28	10
874	2	298	2018-11-28 11:22:10	2018-11-28	10
875	3	298	2018-11-28 11:22:12	2018-11-28	10
876	1	299	2018-11-28 11:23:18	2018-11-28	10
877	2	299	2018-11-28 11:23:20	2018-11-28	10
878	3	299	2018-11-28 13:28:02	2018-11-28	12
879	1	300	2018-11-28 11:20:36	2018-11-28	10
880	2	300	2018-11-28 11:20:38	2018-11-28	10
881	3	300	2018-11-28 11:20:40	2018-11-28	10
882	1	301	2018-11-28 11:19:05	2018-11-28	10
883	2	301	2018-11-28 11:19:07	2018-11-28	10
884	3	301	2018-11-28 11:19:09	2018-11-28	10
885	1	302	2018-11-28 11:12:30	2018-11-28	10
886	2	302	2018-11-28 11:12:32	2018-11-28	10
887	3	302	2018-11-28 11:12:34	2018-11-28	10
888	1	303	2018-11-28 10:44:16	2018-11-28	9
889	2	303	2018-11-28 10:44:18	2018-11-28	9
890	3	303	2018-12-04 10:54:48	2018-12-04	9
891	1	304	2018-11-28 10:39:15	2018-11-28	9
892	2	304	2018-11-28 10:39:19	2018-11-28	9
893	3	304	2018-11-28 10:39:22	2018-11-28	9
894	1	305	2018-11-28 10:25:25	2018-11-28	9
895	2	305	2018-11-28 10:25:28	2018-11-28	9
896	3	305	2018-11-28 10:25:30	2018-11-28	9
897	1	306	2018-11-28 10:24:17	2018-11-28	9
898	2	306	2018-11-28 10:24:19	2018-11-28	9
899	3	306	2018-11-28 10:24:21	2018-11-28	9
900	1	307	2018-11-28 10:22:53	2018-11-28	9
901	2	307	2018-11-28 10:22:56	2018-11-28	9
902	3	307	2018-11-28 10:22:58	2018-11-28	9
903	1	308	2018-11-28 10:14:12	2018-11-28	9
904	2	308	2018-11-28 10:14:14	2018-11-28	9
905	3	308	2018-11-28 10:14:16	2018-11-28	9
906	1	309	2018-11-28 10:05:06	2018-11-28	9
907	2	309	2018-11-28 10:05:09	2018-11-28	9
908	3	309	2018-11-28 10:05:11	2018-11-28	9
909	1	310	2018-11-28 10:04:54	2018-11-28	9
910	2	310	2018-11-28 10:04:56	2018-11-28	9
911	3	310	2018-11-28 10:04:58	2018-11-28	9
912	1	311	2018-11-28 09:43:26	2018-11-28	8
913	2	311	2018-11-28 09:43:30	2018-11-28	8
914	3	311	2018-11-28 11:19:56	2018-11-28	10
915	1	312	2018-11-28 09:35:10	2018-11-28	8
916	2	312	2018-11-28 09:35:12	2018-11-28	8
917	3	312	2018-11-28 09:35:14	2018-11-28	8
918	1	313	2018-11-28 09:24:47	2018-11-28	8
919	2	313	2018-11-28 09:24:50	2018-11-28	8
920	1	313	2018-11-29 09:24:23	2018-11-29	8
921	2	313	2018-11-29 09:24:25	2018-11-29	8
922	3	313	2018-11-29 09:24:27	2018-11-29	8
923	1	314	2018-11-28 09:14:58	2018-11-28	8
924	2	314	2018-11-28 09:15:00	2018-11-28	8
925	3	314	2018-11-28 09:15:01	2018-11-28	8
926	1	315	2018-11-28 08:49:03	2018-11-28	7
927	2	315	2018-11-28 08:49:05	2018-11-28	7
928	1	316	2018-11-28 07:59:24	2018-11-28	6
929	2	316	2018-11-28 07:59:27	2018-11-28	6
930	1	316	2018-11-29 09:27:17	2018-11-29	8
931	2	316	2018-11-29 09:27:19	2018-11-29	8
932	3	316	2018-11-29 11:55:49	2018-11-29	10
933	1	317	2018-11-27 18:15:09	2018-11-27	17
934	2	317	2018-11-27 18:15:11	2018-11-27	17
935	3	317	2018-11-28 13:36:23	2018-11-28	12
936	1	318	2018-11-27 17:30:36	2018-11-27	16
937	2	318	2018-11-27 17:30:40	2018-11-27	16
938	3	318	2018-11-28 11:14:15	2018-11-28	10
939	1	319	2018-11-27 17:01:17	2018-11-27	16
940	2	319	2018-11-27 17:01:18	2018-11-27	16
941	3	319	2018-11-28 13:38:51	2018-11-28	12
942	1	320	2018-11-27 16:55:57	2018-11-27	15
943	2	320	2018-11-27 16:55:58	2018-11-27	15
944	3	320	2018-11-27 16:56:00	2018-11-27	15
945	1	321	2018-11-27 16:36:48	2018-11-27	15
946	2	321	2018-11-27 16:36:49	2018-11-27	15
947	3	321	2018-11-27 16:36:51	2018-11-27	15
948	1	322	2018-11-27 16:18:04	2018-11-27	15
949	2	322	2018-11-27 16:18:06	2018-11-27	15
950	3	322	2018-11-27 16:18:08	2018-11-27	15
951	1	323	2018-11-27 16:13:58	2018-11-27	15
952	2	323	2018-11-27 16:14:00	2018-11-27	15
953	3	323	2018-11-27 16:14:03	2018-11-27	15
954	1	324	2018-11-27 16:12:36	2018-11-27	15
955	2	324	2018-11-27 16:12:38	2018-11-27	15
956	3	324	2018-11-27 16:12:40	2018-11-27	15
957	1	325	2018-11-27 16:01:54	2018-11-27	15
958	2	325	2018-11-27 16:01:56	2018-11-27	15
959	3	325	2018-11-27 16:20:27	2018-11-27	15
960	1	326	2018-11-27 15:52:37	2018-11-27	14
961	2	326	2018-11-27 15:52:39	2018-11-27	14
962	3	326	2018-11-27 15:52:41	2018-11-27	14
963	1	327	2018-11-27 15:46:46	2018-11-27	14
964	2	327	2018-11-27 15:46:48	2018-11-27	14
965	3	327	2018-11-27 15:46:50	2018-11-27	14
966	1	328	2018-11-27 15:36:25	2018-11-27	14
967	2	328	2018-11-27 15:36:27	2018-11-27	14
968	3	328	2018-11-27 15:36:29	2018-11-27	14
969	1	329	2018-11-27 15:18:21	2018-11-27	14
970	2	329	2018-11-27 15:18:23	2018-11-27	14
971	1	330	2018-11-27 15:17:52	2018-11-27	14
972	2	330	2018-11-27 15:17:53	2018-11-27	14
973	3	330	2018-11-27 15:18:18	2018-11-27	14
974	1	331	2018-11-27 15:12:39	2018-11-27	14
975	2	331	2018-11-27 15:12:41	2018-11-27	14
976	3	331	2018-11-27 15:12:43	2018-11-27	14
977	1	332	2018-11-27 15:06:25	2018-11-27	14
978	2	332	2018-11-27 15:06:27	2018-11-27	14
979	3	332	2018-11-27 15:06:28	2018-11-27	14
980	1	333	2018-11-27 15:04:36	2018-11-27	14
981	2	333	2018-11-27 15:04:37	2018-11-27	14
982	3	333	2018-11-27 15:04:44	2018-11-27	14
983	1	334	2018-11-27 14:49:55	2018-11-27	13
984	2	334	2018-11-27 14:50:00	2018-11-27	13
985	1	335	2018-11-27 14:46:39	2018-11-27	13
986	2	335	2018-11-27 14:46:41	2018-11-27	13
987	3	335	2018-11-27 14:46:43	2018-11-27	13
988	1	336	2018-11-27 14:36:17	2018-11-27	13
989	2	336	2018-11-27 14:36:18	2018-11-27	13
990	3	336	2018-11-27 14:36:21	2018-11-27	13
991	1	337	2018-11-27 14:30:33	2018-11-27	13
992	2	337	2018-11-27 14:30:35	2018-11-27	13
993	3	337	2018-11-27 14:30:37	2018-11-27	13
994	1	338	2018-11-27 14:08:51	2018-11-27	13
995	2	338	2018-11-27 14:08:53	2018-11-27	13
996	3	338	2018-11-27 14:08:54	2018-11-27	13
997	1	339	2018-11-27 14:04:55	2018-11-27	13
998	2	339	2018-11-27 14:04:57	2018-11-27	13
999	3	339	2018-11-27 14:04:59	2018-11-27	13
1000	1	340	2018-11-27 11:49:33	2018-11-27	10
1001	2	340	2018-11-27 11:49:35	2018-11-27	10
1002	3	340	2018-11-27 11:49:37	2018-11-27	10
1003	1	341	2018-11-27 11:47:45	2018-11-27	10
1004	2	341	2018-11-27 11:47:46	2018-11-27	10
1005	3	341	2018-11-27 11:47:48	2018-11-27	10
1006	1	342	2018-11-27 11:47:02	2018-11-27	10
1007	2	342	2018-11-27 11:47:05	2018-11-27	10
1008	3	342	2018-11-28 11:27:54	2018-11-28	10
1009	1	343	2018-11-27 11:41:12	2018-11-27	10
1010	2	343	2018-11-27 11:41:14	2018-11-27	10
1011	3	343	2018-11-27 11:41:16	2018-11-27	10
1012	1	344	2018-11-27 11:22:51	2018-11-27	10
1013	2	344	2018-11-27 11:22:53	2018-11-27	10
1014	3	344	2018-11-27 11:32:48	2018-11-27	10
1015	1	345	2018-11-27 11:18:11	2018-11-27	10
1016	2	345	2018-11-27 11:18:13	2018-11-27	10
1017	3	345	2018-11-27 11:18:15	2018-11-27	10
1018	1	346	2018-11-27 11:20:31	2018-11-27	10
1019	2	346	2018-11-27 11:20:33	2018-11-27	10
1020	1	347	2018-11-27 11:11:41	2018-11-27	10
1021	2	347	2018-11-27 11:11:43	2018-11-27	10
1022	3	347	2018-11-27 11:11:45	2018-11-27	10
1023	1	348	2018-11-27 11:12:11	2018-11-27	10
1024	2	348	2018-11-27 11:12:14	2018-11-27	10
1025	1	349	2018-11-27 11:05:06	2018-11-27	10
1026	2	349	2018-11-27 11:05:10	2018-11-27	10
1027	1	350	2018-11-27 11:03:03	2018-11-27	10
1028	2	350	2018-11-27 11:03:04	2018-11-27	10
1029	3	350	2018-11-27 11:03:06	2018-11-27	10
1030	1	351	2018-11-27 10:39:55	2018-11-27	9
1031	2	351	2018-11-27 10:39:57	2018-11-27	9
1032	3	351	2018-11-27 10:39:59	2018-11-27	9
1033	1	352	2018-11-27 10:35:09	2018-11-27	9
1034	2	352	2018-11-27 10:35:11	2018-11-27	9
1035	3	352	2018-11-27 10:35:13	2018-11-27	9
1036	1	353	2018-11-27 10:31:24	2018-11-27	9
1037	2	353	2018-11-27 10:31:26	2018-11-27	9
1038	3	353	2018-11-28 11:39:22	2018-11-28	10
1039	1	354	2018-11-27 10:28:58	2018-11-27	9
1040	2	354	2018-11-27 10:29:00	2018-11-27	9
1041	3	354	2018-11-27 10:29:02	2018-11-27	9
1042	1	355	2018-11-27 10:49:38	2018-11-27	9
1043	2	355	2018-11-27 10:49:41	2018-11-27	9
1044	1	356	2018-11-27 10:26:50	2018-11-27	9
1045	2	356	2018-11-27 10:26:52	2018-11-27	9
1046	3	356	2018-11-27 11:10:17	2018-11-27	10
1047	1	357	2018-11-27 10:13:55	2018-11-27	9
1048	2	357	2018-11-27 10:13:57	2018-11-27	9
1049	3	357	2018-11-27 10:15:17	2018-11-27	9
1050	1	358	2018-11-27 10:03:19	2018-11-27	9
1051	2	358	2018-11-27 10:03:21	2018-11-27	9
1052	3	358	2018-11-27 10:03:23	2018-11-27	9
1053	1	359	2018-11-27 09:54:08	2018-11-27	8
1054	2	359	2018-11-27 09:54:10	2018-11-27	8
1055	3	359	2018-11-27 09:54:12	2018-11-27	8
1056	1	360	2018-11-27 09:44:09	2018-11-27	8
1057	2	360	2018-11-27 09:44:11	2018-11-27	8
1058	3	360	2018-11-27 09:44:13	2018-11-27	8
1059	1	361	2018-11-27 09:41:32	2018-11-27	8
1060	2	361	2018-11-27 09:41:34	2018-11-27	8
1061	3	361	2018-11-27 09:41:35	2018-11-27	8
1062	1	362	2018-11-27 09:32:39	2018-11-27	8
1063	2	362	2018-11-27 09:32:40	2018-11-27	8
1064	3	362	2018-11-27 09:32:42	2018-11-27	8
1065	1	363	2018-11-27 09:20:15	2018-11-27	8
1066	2	363	2018-11-27 09:20:16	2018-11-27	8
1067	3	363	2018-11-27 09:20:19	2018-11-27	8
1068	1	364	2018-11-27 09:22:35	2018-11-27	8
1069	2	364	2018-11-27 09:22:38	2018-11-27	8
1070	3	364	2018-11-27 09:22:41	2018-11-27	8
1071	1	365	2018-11-27 09:18:58	2018-11-27	8
1072	2	365	2018-11-27 09:19:00	2018-11-27	8
1073	3	365	2018-11-27 09:19:02	2018-11-27	8
1074	1	366	2018-11-27 09:15:58	2018-11-27	8
1075	2	366	2018-11-27 09:16:00	2018-11-27	8
1076	3	366	2018-11-27 09:16:02	2018-11-27	8
1077	1	367	2018-11-27 09:15:32	2018-11-27	8
1078	2	367	2018-11-27 09:15:34	2018-11-27	8
1079	3	367	2018-11-27 09:15:35	2018-11-27	8
1080	1	368	2018-11-27 09:11:41	2018-11-27	8
1081	2	368	2018-11-27 09:11:43	2018-11-27	8
1082	3	368	2018-11-27 09:11:45	2018-11-27	8
1083	1	369	2018-11-27 09:08:53	2018-11-27	8
1084	2	369	2018-11-27 09:08:54	2018-11-27	8
1085	3	369	2018-11-27 09:08:56	2018-11-27	8
1086	1	370	2018-11-27 09:01:01	2018-11-27	8
1087	2	370	2018-11-27 09:01:03	2018-11-27	8
1088	3	370	2018-11-27 09:01:05	2018-11-27	8
1089	1	371	2018-11-27 08:59:49	2018-11-27	7
1090	2	371	2018-11-27 08:59:51	2018-11-27	7
1091	3	371	2018-11-27 09:11:00	2018-11-27	8
1092	1	372	2018-11-27 08:53:46	2018-11-27	7
1093	2	372	2018-11-27 08:53:49	2018-11-27	7
1094	3	372	2018-11-27 09:17:34	2018-11-27	8
1095	1	373	2018-11-27 08:35:41	2018-11-27	7
1096	2	373	2018-11-27 08:35:43	2018-11-27	7
1097	3	373	2018-11-27 08:35:45	2018-11-27	7
1098	1	374	2018-11-27 08:33:58	2018-11-27	7
1099	2	374	2018-11-27 08:34:01	2018-11-27	7
1100	3	374	2018-11-27 08:34:04	2018-11-27	7
1101	1	375	2018-11-26 21:17:37	2018-11-26	20
1102	2	375	2018-11-26 21:17:41	2018-11-26	20
1103	1	376	2018-11-26 16:36:48	2018-11-26	15
1104	2	376	2018-11-26 16:36:51	2018-11-26	15
1105	3	376	2018-11-27 09:16:13	2018-11-27	8
1106	1	377	2018-11-26 16:33:11	2018-11-26	15
1107	2	377	2018-11-26 16:33:14	2018-11-26	15
1108	3	377	2018-11-28 11:57:36	2018-11-28	10
1109	1	378	2018-11-26 16:25:24	2018-11-26	15
1110	2	378	2018-11-26 16:25:26	2018-11-26	15
1111	3	378	2018-11-26 16:25:28	2018-11-26	15
1112	1	379	2018-11-26 16:24:01	2018-11-26	15
1113	2	379	2018-11-26 16:24:03	2018-11-26	15
1114	3	379	2018-11-26 16:24:05	2018-11-26	15
1115	1	380	2018-11-26 16:18:26	2018-11-26	15
1116	2	380	2018-11-26 16:18:29	2018-11-26	15
1117	3	380	2018-11-27 08:53:32	2018-11-27	7
1118	1	381	2018-11-26 15:56:42	2018-11-26	14
1119	2	381	2018-11-26 15:56:44	2018-11-26	14
1120	3	381	2018-11-26 15:56:46	2018-11-26	14
1121	1	382	2018-11-26 15:49:41	2018-11-26	14
1122	2	382	2018-11-26 15:49:44	2018-11-26	14
1123	3	382	2018-11-28 12:08:47	2018-11-28	11
1124	1	383	2018-11-26 15:49:12	2018-11-26	14
1125	2	383	2018-11-26 15:49:14	2018-11-26	14
1126	3	383	2018-11-26 16:22:25	2018-11-26	15
1127	1	384	2018-11-26 15:52:04	2018-11-26	14
1128	2	384	2018-11-26 15:52:07	2018-11-26	14
1129	3	384	2018-11-28 12:02:35	2018-11-28	11
1130	1	385	2018-11-26 15:44:37	2018-11-26	14
1131	2	385	2018-11-26 15:44:39	2018-11-26	14
1132	3	385	2018-11-26 15:44:41	2018-11-26	14
1133	1	386	2018-11-26 15:32:00	2018-11-26	14
1134	2	386	2018-11-26 15:32:03	2018-11-26	14
1135	3	386	2018-11-26 15:32:05	2018-11-26	14
1136	1	387	2018-11-26 15:28:28	2018-11-26	14
1137	2	387	2018-11-26 15:28:30	2018-11-26	14
1138	3	387	2018-11-26 15:28:32	2018-11-26	14
1139	1	388	2018-11-26 15:23:08	2018-11-26	14
1140	2	388	2018-11-26 15:23:11	2018-11-26	14
1141	3	388	2018-11-26 15:23:14	2018-11-26	14
1142	1	389	2018-11-26 15:14:18	2018-11-26	14
1143	2	389	2018-11-26 15:14:20	2018-11-26	14
1144	3	389	2018-11-26 15:14:22	2018-11-26	14
1145	1	390	2018-11-26 15:08:01	2018-11-26	14
1146	2	390	2018-11-26 15:08:03	2018-11-26	14
1147	3	390	2018-11-26 15:08:05	2018-11-26	14
1148	1	391	2018-11-26 14:55:38	2018-11-26	13
1149	2	391	2018-11-26 14:55:40	2018-11-26	13
1150	3	391	2018-11-26 14:55:42	2018-11-26	13
1151	1	392	2018-11-26 14:44:37	2018-11-26	13
1152	2	392	2018-11-26 14:44:40	2018-11-26	13
1153	3	392	2018-11-27 10:03:45	2018-11-27	9
1154	1	393	2018-11-26 12:31:10	2018-11-26	11
1155	2	393	2018-11-26 12:31:12	2018-11-26	11
1156	3	393	2018-11-26 12:35:43	2018-11-26	11
1157	1	394	2018-11-26 11:45:50	2018-11-26	10
1158	2	394	2018-11-26 11:45:52	2018-11-26	10
1159	3	394	2018-11-26 11:45:54	2018-11-26	10
1160	1	395	2018-11-26 11:43:48	2018-11-26	10
1161	2	395	2018-11-26 11:43:49	2018-11-26	10
1162	3	395	2018-11-28 12:09:51	2018-11-28	11
1163	1	396	2018-11-26 11:30:13	2018-11-26	10
1164	2	396	2018-11-26 11:30:15	2018-11-26	10
1165	3	396	2018-11-27 11:15:12	2018-11-27	10
1166	1	397	2018-11-26 11:25:08	2018-11-26	10
1167	2	397	2018-11-26 11:25:09	2018-11-26	10
1168	3	397	2018-11-27 09:57:30	2018-11-27	8
1169	1	398	2018-11-26 11:10:04	2018-11-26	10
1170	2	398	2018-11-26 11:10:06	2018-11-26	10
1171	3	398	2018-11-26 11:10:07	2018-11-26	10
1172	1	399	2018-11-26 11:02:36	2018-11-26	10
1173	2	399	2018-11-26 11:02:40	2018-11-26	10
1174	3	399	2018-11-28 09:39:48	2018-11-28	8
1175	1	400	2018-11-26 10:52:24	2018-11-26	9
1176	2	400	2018-11-26 10:52:26	2018-11-26	9
1177	3	400	2018-12-03 14:57:40	2018-12-03	13
1178	1	401	2018-11-26 10:50:31	2018-11-26	9
1179	2	401	2018-11-26 10:50:35	2018-11-26	9
1180	3	401	2018-11-26 10:50:38	2018-11-26	9
1181	1	402	2018-11-26 10:41:28	2018-11-26	9
1182	2	402	2018-11-26 10:41:30	2018-11-26	9
1183	3	402	2018-11-26 10:41:32	2018-11-26	9
1184	1	403	2018-11-26 10:41:08	2018-11-26	9
1185	2	403	2018-11-26 10:41:12	2018-11-26	9
1186	3	403	2018-11-26 12:15:32	2018-11-26	11
1187	1	404	2018-11-26 10:36:38	2018-11-26	9
1188	2	404	2018-11-26 10:36:40	2018-11-26	9
1189	3	404	2018-11-26 10:36:42	2018-11-26	9
1190	1	405	2018-11-26 10:15:00	2018-11-26	9
1191	2	405	2018-11-26 10:15:02	2018-11-26	9
1192	3	405	2018-11-26 10:15:03	2018-11-26	9
1193	1	406	2018-11-26 10:10:51	2018-11-26	9
1194	2	406	2018-11-26 10:10:53	2018-11-26	9
1195	3	406	2018-11-27 08:50:01	2018-11-27	7
1196	1	407	2018-11-26 10:10:40	2018-11-26	9
1197	2	407	2018-11-26 10:10:42	2018-11-26	9
1198	3	407	2018-11-27 10:01:11	2018-11-27	9
1199	1	408	2018-11-26 10:07:45	2018-11-26	9
1200	2	408	2018-11-26 10:07:47	2018-11-26	9
1201	3	408	2018-11-26 10:07:49	2018-11-26	9
1202	1	409	2018-11-26 10:02:55	2018-11-26	9
1203	2	409	2018-11-26 10:02:57	2018-11-26	9
1204	3	409	2018-11-26 10:05:17	2018-11-26	9
1205	1	410	2018-11-26 09:53:12	2018-11-26	8
1206	2	410	2018-11-26 09:53:14	2018-11-26	8
1207	3	410	2018-11-26 09:53:16	2018-11-26	8
1208	1	411	2018-11-26 09:35:04	2018-11-26	8
1209	2	411	2018-11-26 09:35:06	2018-11-26	8
1210	3	411	2018-11-26 09:44:50	2018-11-26	8
1211	1	412	2018-11-26 09:30:02	2018-11-26	8
1212	2	412	2018-11-26 09:30:03	2018-11-26	8
1213	3	412	2018-11-27 08:49:10	2018-11-27	7
1214	1	413	2018-11-26 09:29:17	2018-11-26	8
1215	2	413	2018-11-26 09:29:20	2018-11-26	8
1216	3	413	2018-11-26 11:00:03	2018-11-26	10
1217	1	414	2018-11-26 09:24:33	2018-11-26	8
1218	2	414	2018-11-26 09:24:35	2018-11-26	8
1219	3	414	2018-11-26 09:24:37	2018-11-26	8
1220	1	415	2018-11-26 09:12:44	2018-11-26	8
1221	2	415	2018-11-26 09:12:46	2018-11-26	8
1222	3	415	2018-11-26 09:12:48	2018-11-26	8
1223	1	416	2018-11-26 09:09:51	2018-11-26	8
1224	2	416	2018-11-26 09:09:53	2018-11-26	8
1225	3	416	2018-11-26 09:09:55	2018-11-26	8
1226	1	417	2018-11-26 09:09:37	2018-11-26	8
1227	2	417	2018-11-26 09:09:38	2018-11-26	8
1228	3	417	2018-11-26 15:39:52	2018-11-26	14
1229	1	418	2018-11-26 09:05:04	2018-11-26	8
1230	2	418	2018-11-26 09:05:06	2018-11-26	8
1231	3	418	2018-11-26 09:05:07	2018-11-26	8
1232	1	419	2018-11-26 09:02:13	2018-11-26	8
1233	2	419	2018-11-26 09:02:15	2018-11-26	8
1234	3	419	2018-11-26 09:03:34	2018-11-26	8
1235	1	420	2018-11-26 08:59:25	2018-11-26	7
1236	2	420	2018-11-26 08:59:26	2018-11-26	7
1237	3	420	2018-11-26 08:59:28	2018-11-26	7
1238	1	421	2018-11-26 09:00:33	2018-11-26	8
1239	2	421	2018-11-26 09:00:36	2018-11-26	8
1240	3	421	2018-11-28 12:18:43	2018-11-28	11
1241	1	422	2018-11-26 08:57:42	2018-11-26	7
1242	2	422	2018-11-26 08:57:45	2018-11-26	7
1243	3	422	2018-11-28 12:14:12	2018-11-28	11
1244	1	423	2018-11-26 09:16:41	2018-11-26	8
1245	2	423	2018-11-26 09:16:44	2018-11-26	8
1246	3	423	2018-11-28 12:11:14	2018-11-28	11
1247	1	424	2018-11-26 08:54:18	2018-11-26	7
1248	2	424	2018-11-26 08:54:20	2018-11-26	7
1249	3	424	2018-11-26 08:56:01	2018-11-26	7
1250	1	425	2018-11-26 08:52:50	2018-11-26	7
1251	2	425	2018-11-26 08:52:52	2018-11-26	7
1252	3	425	2018-11-26 08:52:55	2018-11-26	7
1253	1	426	2018-11-26 08:46:32	2018-11-26	7
1254	2	426	2018-11-26 08:46:34	2018-11-26	7
1255	3	426	2018-11-26 08:46:35	2018-11-26	7
1256	1	427	2018-11-26 08:36:17	2018-11-26	7
1257	2	427	2018-11-26 08:36:19	2018-11-26	7
1258	3	427	2018-11-26 08:36:21	2018-11-26	7
1259	1	428	2018-11-25 20:56:46	2018-11-25	19
1260	2	428	2018-11-25 20:56:49	2018-11-25	19
1261	3	428	2018-11-28 12:15:05	2018-11-28	11
1262	1	429	2018-11-25 20:08:51	2018-11-25	19
1263	2	429	2018-11-25 20:08:53	2018-11-25	19
1264	3	429	2018-11-28 12:16:31	2018-11-28	11
1265	1	430	2018-11-24 20:59:41	2018-11-24	19
1266	2	430	2018-11-24 20:59:43	2018-11-24	19
1267	3	430	2018-11-26 15:47:52	2018-11-26	14
1268	1	431	2018-11-23 16:48:57	2018-11-23	15
1269	2	431	2018-11-23 16:48:59	2018-11-23	15
1270	3	431	2018-11-23 16:49:01	2018-11-23	15
1271	1	432	2018-11-23 16:38:44	2018-11-23	15
1272	2	432	2018-11-23 16:38:46	2018-11-23	15
1273	3	432	2018-11-23 16:38:48	2018-11-23	15
1274	1	433	2018-11-23 16:15:04	2018-11-23	15
1275	2	433	2018-11-23 16:15:06	2018-11-23	15
1276	3	433	2018-11-23 16:15:08	2018-11-23	15
1277	1	434	2018-11-23 16:08:32	2018-11-23	15
1278	2	434	2018-11-23 16:08:34	2018-11-23	15
1279	3	434	2018-11-23 16:08:36	2018-11-23	15
1280	1	435	2018-11-23 15:56:17	2018-11-23	14
1281	2	435	2018-11-23 15:56:18	2018-11-23	14
1282	3	435	2018-11-23 15:56:20	2018-11-23	14
1283	1	436	2018-11-23 15:49:10	2018-11-23	14
1284	2	436	2018-11-23 15:49:12	2018-11-23	14
1285	3	436	2018-11-23 15:49:13	2018-11-23	14
1286	1	437	2018-11-23 15:05:37	2018-11-23	14
1287	2	437	2018-11-23 15:05:39	2018-11-23	14
1288	3	437	2018-11-23 15:05:40	2018-11-23	14
1289	1	438	2018-11-23 15:03:41	2018-11-23	14
1290	2	438	2018-11-23 15:03:43	2018-11-23	14
1291	3	438	2018-11-23 15:03:45	2018-11-23	14
1292	1	439	2018-11-23 14:58:45	2018-11-23	13
1293	2	439	2018-11-23 14:58:47	2018-11-23	13
1294	3	439	2018-11-23 14:58:48	2018-11-23	13
1295	1	440	2018-11-23 14:38:01	2018-11-23	13
1296	2	440	2018-11-23 14:38:03	2018-11-23	13
1297	3	440	2018-11-23 14:59:06	2018-11-23	13
1298	1	441	2018-11-23 14:31:42	2018-11-23	13
1299	2	441	2018-11-23 14:31:44	2018-11-23	13
1300	3	441	2018-11-23 14:31:46	2018-11-23	13
1301	1	442	2018-11-23 14:13:33	2018-11-23	13
1302	2	442	2018-11-23 14:13:35	2018-11-23	13
1303	3	442	2018-11-23 14:13:38	2018-11-23	13
1304	1	443	2018-11-23 14:07:06	2018-11-23	13
1305	2	443	2018-11-23 14:07:08	2018-11-23	13
1306	3	443	2018-11-26 10:07:42	2018-11-26	9
1307	1	444	2018-11-23 14:00:02	2018-11-23	13
1308	2	444	2018-11-23 14:00:06	2018-11-23	13
1309	3	444	2018-11-28 12:34:55	2018-11-28	11
1310	1	445	2018-11-23 13:51:57	2018-11-23	12
1311	2	445	2018-11-23 13:52:01	2018-11-23	12
1312	3	445	2018-11-28 12:36:45	2018-11-28	11
1313	1	446	2018-11-23 13:11:32	2018-11-23	12
1314	2	446	2018-11-23 13:11:33	2018-11-23	12
1315	3	446	2018-11-23 14:14:48	2018-11-23	13
1316	1	447	2018-11-23 11:50:59	2018-11-23	10
1317	2	447	2018-11-23 11:51:01	2018-11-23	10
1318	3	447	2018-11-26 15:22:03	2018-11-26	14
1319	1	448	2018-11-23 14:45:26	2018-11-23	13
1320	2	448	2018-11-23 14:45:28	2018-11-23	13
1321	3	448	2018-11-23 14:45:30	2018-11-23	13
1322	1	449	2018-11-23 11:41:15	2018-11-23	10
1323	2	449	2018-11-23 11:41:16	2018-11-23	10
1324	3	449	2018-11-23 11:41:18	2018-11-23	10
1325	1	450	2018-11-23 11:39:58	2018-11-23	10
1326	2	450	2018-11-23 11:39:59	2018-11-23	10
1327	3	450	2018-11-23 11:40:02	2018-11-23	10
1328	1	451	2018-11-23 11:39:12	2018-11-23	10
1329	2	451	2018-11-23 11:39:13	2018-11-23	10
1330	3	451	2018-11-23 11:39:15	2018-11-23	10
1331	1	452	2018-11-23 11:36:57	2018-11-23	10
1332	2	452	2018-11-23 11:36:59	2018-11-23	10
1333	3	452	2018-11-23 11:37:00	2018-11-23	10
1334	1	453	2018-11-23 11:35:12	2018-11-23	10
1335	2	453	2018-11-23 11:35:15	2018-11-23	10
1336	1	454	2018-11-23 11:32:20	2018-11-23	10
1337	2	454	2018-11-23 11:32:22	2018-11-23	10
1338	3	454	2018-11-23 14:09:55	2018-11-23	13
1339	1	455	2018-11-23 11:11:18	2018-11-23	10
1340	2	455	2018-11-23 11:11:19	2018-11-23	10
1341	3	455	2018-11-23 11:11:22	2018-11-23	10
1342	1	456	2018-11-23 11:06:23	2018-11-23	10
1343	2	456	2018-11-23 11:06:26	2018-11-23	10
1344	3	456	2018-11-23 11:06:28	2018-11-23	10
1345	1	457	2018-11-23 11:04:17	2018-11-23	10
1346	2	457	2018-11-23 11:04:19	2018-11-23	10
1347	3	457	2018-11-23 11:04:21	2018-11-23	10
1348	1	458	2018-11-23 11:02:33	2018-11-23	10
1349	2	458	2018-11-23 11:02:34	2018-11-23	10
1350	3	458	2018-11-23 11:02:36	2018-11-23	10
1351	1	459	2018-11-23 10:53:41	2018-11-23	9
1352	2	459	2018-11-23 10:53:43	2018-11-23	9
1353	3	459	2018-11-23 10:53:45	2018-11-23	9
1354	1	460	2018-11-23 10:46:22	2018-11-23	9
1355	2	460	2018-11-23 10:46:23	2018-11-23	9
1356	3	460	2018-11-23 10:46:25	2018-11-23	9
1357	1	461	2018-11-23 10:44:13	2018-11-23	9
1358	2	461	2018-11-23 10:44:15	2018-11-23	9
1359	3	461	2018-11-23 10:44:17	2018-11-23	9
1360	1	462	2018-11-23 10:26:38	2018-11-23	9
1361	2	462	2018-11-23 10:26:39	2018-11-23	9
1362	3	462	2018-11-23 10:26:41	2018-11-23	9
1363	1	463	2018-11-23 10:24:55	2018-11-23	9
1364	2	463	2018-11-23 10:24:58	2018-11-23	9
1365	1	464	2018-11-23 10:14:33	2018-11-23	9
1366	2	464	2018-11-23 10:14:34	2018-11-23	9
1367	3	464	2018-11-23 10:14:36	2018-11-23	9
1368	1	465	2018-11-23 10:13:40	2018-11-23	9
1369	2	465	2018-11-23 10:13:42	2018-11-23	9
1370	3	465	2018-11-23 10:13:44	2018-11-23	9
1371	1	466	2018-11-23 10:08:43	2018-11-23	9
1372	2	466	2018-11-23 10:08:45	2018-11-23	9
1373	3	466	2018-11-23 10:08:47	2018-11-23	9
1374	1	467	2018-11-23 10:02:27	2018-11-23	9
1375	2	467	2018-11-23 10:02:31	2018-11-23	9
1376	3	467	2018-11-30 09:54:18	2018-11-30	8
1377	1	468	2018-11-23 09:58:07	2018-11-23	8
1378	2	468	2018-11-23 09:58:08	2018-11-23	8
1379	3	468	2018-11-23 09:58:11	2018-11-23	8
1380	1	469	2018-11-23 09:59:17	2018-11-23	8
1381	2	469	2018-11-23 09:59:20	2018-11-23	8
1382	1	470	2018-11-23 09:54:45	2018-11-23	8
1383	2	470	2018-11-23 09:54:46	2018-11-23	8
1384	3	470	2018-11-23 09:54:49	2018-11-23	8
1385	1	471	2018-11-23 09:54:13	2018-11-23	8
1386	2	471	2018-11-23 09:54:15	2018-11-23	8
1387	3	471	2018-11-23 09:54:17	2018-11-23	8
1388	1	472	2018-11-23 09:53:51	2018-11-23	8
1389	2	472	2018-11-23 09:53:55	2018-11-23	8
1390	3	472	2018-11-23 09:53:57	2018-11-23	8
1391	1	473	2018-11-23 09:48:32	2018-11-23	8
1392	2	473	2018-11-23 09:48:34	2018-11-23	8
1393	3	473	2018-11-23 09:48:36	2018-11-23	8
1394	1	474	2018-11-23 09:45:49	2018-11-23	8
1395	2	474	2018-11-23 09:45:51	2018-11-23	8
1396	3	474	2018-11-23 09:45:52	2018-11-23	8
1397	1	475	2018-11-23 09:46:35	2018-11-23	8
1398	2	475	2018-11-23 09:46:38	2018-11-23	8
1399	3	475	2018-11-26 08:17:05	2018-11-26	7
1400	1	476	2018-11-23 09:42:07	2018-11-23	8
1401	2	476	2018-11-23 09:42:10	2018-11-23	8
1402	1	477	2018-11-23 09:39:08	2018-11-23	8
1403	2	477	2018-11-23 09:39:10	2018-11-23	8
1404	3	477	2018-11-23 09:39:12	2018-11-23	8
1405	1	478	2018-11-23 09:34:34	2018-11-23	8
1406	2	478	2018-11-23 09:34:35	2018-11-23	8
1407	3	478	2018-11-23 09:34:38	2018-11-23	8
1408	1	479	2018-11-23 09:34:02	2018-11-23	8
1409	2	479	2018-11-23 09:34:04	2018-11-23	8
1410	3	479	2018-11-23 09:34:06	2018-11-23	8
1411	1	480	2018-11-23 09:33:25	2018-11-23	8
1412	2	480	2018-11-23 09:33:27	2018-11-23	8
1413	3	480	2018-11-23 09:33:29	2018-11-23	8
1414	1	481	2018-11-23 09:28:40	2018-11-23	8
1415	2	481	2018-11-23 09:28:42	2018-11-23	8
1416	3	481	2018-11-23 09:33:22	2018-11-23	8
1417	1	482	2018-11-23 09:27:20	2018-11-23	8
1418	2	482	2018-11-23 09:27:22	2018-11-23	8
1419	3	482	2018-11-23 09:27:24	2018-11-23	8
1420	1	483	2018-11-23 09:23:31	2018-11-23	8
1421	2	483	2018-11-23 09:23:32	2018-11-23	8
1422	3	483	2018-11-23 09:23:34	2018-11-23	8
1423	1	484	2018-11-23 09:47:48	2018-11-23	8
1424	2	484	2018-11-23 09:47:50	2018-11-23	8
1425	3	484	2018-11-23 09:47:52	2018-11-23	8
1426	1	485	2018-11-23 09:21:02	2018-11-23	8
1427	2	485	2018-11-23 09:21:04	2018-11-23	8
1428	3	485	2018-11-23 09:21:06	2018-11-23	8
1429	1	486	2018-11-23 09:06:33	2018-11-23	8
1430	2	486	2018-11-23 09:06:35	2018-11-23	8
1431	3	486	2018-11-23 09:06:37	2018-11-23	8
1432	1	487	2018-11-23 08:49:02	2018-11-23	7
1433	2	487	2018-11-23 08:49:03	2018-11-23	7
1434	3	487	2018-11-23 08:49:05	2018-11-23	7
1435	1	488	2018-11-23 08:11:18	2018-11-23	7
1436	2	488	2018-11-23 08:11:20	2018-11-23	7
1437	3	488	2018-11-23 09:10:13	2018-11-23	8
1438	1	489	2018-11-23 07:58:50	2018-11-23	6
1439	2	489	2018-11-23 07:58:52	2018-11-23	6
1440	3	489	2018-11-23 07:58:54	2018-11-23	6
1441	1	490	2018-11-22 16:59:11	2018-11-22	15
1442	2	490	2018-11-22 16:59:13	2018-11-22	15
1443	3	490	2018-11-22 16:59:15	2018-11-22	15
1444	1	491	2018-11-22 16:28:19	2018-11-22	15
1445	2	491	2018-11-22 16:28:22	2018-11-22	15
1446	3	491	2018-11-22 16:28:25	2018-11-22	15
1447	1	492	2018-11-22 16:26:26	2018-11-22	15
1448	2	492	2018-11-22 16:26:28	2018-11-22	15
1449	3	492	2018-11-22 16:26:30	2018-11-22	15
1450	1	493	2018-11-22 16:17:50	2018-11-22	15
1451	2	493	2018-11-22 16:17:52	2018-11-22	15
1452	3	493	2018-11-22 16:17:54	2018-11-22	15
1453	1	494	2018-11-22 15:52:48	2018-11-22	14
1454	2	494	2018-11-22 15:52:50	2018-11-22	14
1455	3	494	2018-11-22 15:52:51	2018-11-22	14
1456	1	495	2018-11-22 15:49:18	2018-11-22	14
1457	2	495	2018-11-22 15:49:20	2018-11-22	14
1458	3	495	2018-11-22 15:49:23	2018-11-22	14
1459	1	496	2018-11-22 15:48:13	2018-11-22	14
1460	2	496	2018-11-22 15:48:15	2018-11-22	14
1461	3	496	2018-11-22 15:48:16	2018-11-22	14
1462	1	497	2018-11-22 15:47:08	2018-11-22	14
1463	2	497	2018-11-22 15:47:10	2018-11-22	14
1464	3	497	2018-11-22 15:47:13	2018-11-22	14
1465	1	498	2018-11-22 15:47:59	2018-11-22	14
1466	2	498	2018-11-22 15:48:01	2018-11-22	14
1467	3	498	2018-11-28 13:57:57	2018-11-28	12
1468	1	499	2018-11-22 15:21:53	2018-11-22	14
1469	2	499	2018-11-22 15:21:55	2018-11-22	14
1470	3	499	2018-11-22 15:21:57	2018-11-22	14
1471	1	500	2018-11-22 15:21:12	2018-11-22	14
1472	2	500	2018-11-22 15:21:13	2018-11-22	14
1473	3	500	2018-11-22 15:21:15	2018-11-22	14
1474	1	501	2018-11-22 15:32:05	2018-11-22	14
1475	2	501	2018-11-22 15:32:07	2018-11-22	14
1476	3	501	2018-11-22 15:32:08	2018-11-22	14
1477	1	502	2018-11-22 14:57:23	2018-11-22	13
1478	2	502	2018-11-22 14:57:26	2018-11-22	13
1479	1	503	2018-11-22 14:47:28	2018-11-22	13
1480	2	503	2018-11-22 14:47:30	2018-11-22	13
1481	3	503	2018-11-22 14:47:32	2018-11-22	13
1482	1	504	2018-11-22 14:24:01	2018-11-22	13
1483	2	504	2018-11-22 14:24:03	2018-11-22	13
1484	3	504	2018-11-22 14:24:05	2018-11-22	13
1485	1	505	2018-11-22 14:21:39	2018-11-22	13
1486	2	505	2018-11-22 14:21:41	2018-11-22	13
1487	3	505	2018-11-22 14:21:43	2018-11-22	13
1488	1	506	2018-11-22 14:21:04	2018-11-22	13
1489	2	506	2018-11-22 14:21:06	2018-11-22	13
1490	3	506	2018-11-22 14:21:08	2018-11-22	13
1491	1	507	2018-11-22 14:20:41	2018-11-22	13
1492	2	507	2018-11-22 14:20:44	2018-11-22	13
1493	3	507	2018-11-22 14:20:47	2018-11-22	13
1494	1	508	2018-11-22 14:14:40	2018-11-22	13
1495	2	508	2018-11-22 14:14:42	2018-11-22	13
1496	3	508	2018-11-22 14:14:44	2018-11-22	13
1497	1	509	2018-11-22 14:13:49	2018-11-22	13
1498	2	509	2018-11-22 14:13:51	2018-11-22	13
1499	3	509	2018-11-22 14:13:53	2018-11-22	13
1500	1	510	2018-11-22 14:08:25	2018-11-22	13
1501	2	510	2018-11-22 14:08:26	2018-11-22	13
1502	3	510	2018-11-22 14:08:28	2018-11-22	13
1503	1	511	2018-11-22 14:06:12	2018-11-22	13
1504	2	511	2018-11-22 14:06:14	2018-11-22	13
1505	1	512	2018-11-22 13:28:49	2018-11-22	12
1506	2	512	2018-11-22 13:28:50	2018-11-22	12
1507	3	512	2018-11-22 14:21:58	2018-11-22	13
1508	1	513	2018-11-22 12:06:59	2018-11-22	11
1509	2	513	2018-11-22 12:07:00	2018-11-22	11
1510	3	513	2018-11-22 15:24:34	2018-11-22	14
1511	1	514	2018-11-22 12:18:42	2018-11-22	11
1512	2	514	2018-11-22 12:18:44	2018-11-22	11
1513	3	514	2018-11-22 12:18:45	2018-11-22	11
1514	1	515	2018-11-22 11:30:44	2018-11-22	10
1515	2	515	2018-11-22 11:30:45	2018-11-22	10
1516	3	515	2018-11-22 11:30:47	2018-11-22	10
1517	1	516	2018-11-22 11:30:11	2018-11-22	10
1518	2	516	2018-11-22 11:30:13	2018-11-22	10
1519	3	516	2018-11-22 11:30:15	2018-11-22	10
1520	1	517	2018-11-22 11:25:51	2018-11-22	10
1521	2	517	2018-11-22 11:25:53	2018-11-22	10
1522	3	517	2018-11-22 11:25:55	2018-11-22	10
1523	1	518	2018-11-22 11:21:18	2018-11-22	10
1524	2	518	2018-11-22 11:21:20	2018-11-22	10
1525	3	518	2018-11-22 11:21:22	2018-11-22	10
1526	1	519	2018-11-22 11:19:45	2018-11-22	10
1527	2	519	2018-11-22 11:19:46	2018-11-22	10
1528	3	519	2018-11-22 11:19:48	2018-11-22	10
1529	1	520	2018-11-22 11:18:41	2018-11-22	10
1530	2	520	2018-11-22 11:18:44	2018-11-22	10
1531	1	521	2018-11-22 11:10:29	2018-11-22	10
1532	2	521	2018-11-22 11:10:32	2018-11-22	10
1533	3	521	2018-11-22 11:10:33	2018-11-22	10
1534	1	522	2018-11-22 11:11:30	2018-11-22	10
1535	2	522	2018-11-22 11:11:34	2018-11-22	10
1536	3	522	2018-11-28 13:26:36	2018-11-28	12
1537	1	523	2018-11-22 10:53:01	2018-11-22	9
1538	2	523	2018-11-22 10:53:03	2018-11-22	9
1539	3	523	2018-11-22 10:53:05	2018-11-22	9
1540	1	524	2018-11-22 11:09:25	2018-11-22	10
1541	2	524	2018-11-22 11:09:27	2018-11-22	10
1542	3	524	2018-11-22 11:09:29	2018-11-22	10
1543	1	525	2018-11-22 10:50:35	2018-11-22	9
1544	2	525	2018-11-22 10:50:37	2018-11-22	9
1545	3	525	2018-11-22 10:50:39	2018-11-22	9
1546	1	526	2018-11-22 10:47:28	2018-11-22	9
1547	2	526	2018-11-22 10:47:30	2018-11-22	9
1548	3	526	2018-11-22 10:47:32	2018-11-22	9
1549	1	527	2018-11-22 10:41:09	2018-11-22	9
1550	2	527	2018-11-22 10:41:11	2018-11-22	9
1551	3	527	2018-11-22 10:41:13	2018-11-22	9
1552	1	528	2018-11-22 10:39:58	2018-11-22	9
1553	2	528	2018-11-22 10:40:00	2018-11-22	9
1554	3	528	2018-11-22 10:40:02	2018-11-22	9
1555	1	529	2018-11-22 10:24:56	2018-11-22	9
1556	2	529	2018-11-22 10:24:58	2018-11-22	9
1557	3	529	2018-11-22 10:25:00	2018-11-22	9
1558	1	530	2018-11-22 10:22:04	2018-11-22	9
1559	2	530	2018-11-22 10:22:06	2018-11-22	9
1560	3	530	2018-11-22 10:22:08	2018-11-22	9
1561	1	531	2018-11-22 10:20:14	2018-11-22	9
1562	2	531	2018-11-22 10:20:17	2018-11-22	9
1563	3	531	2018-11-22 10:20:19	2018-11-22	9
1564	1	532	2018-11-22 10:19:36	2018-11-22	9
1565	2	532	2018-11-22 10:19:37	2018-11-22	9
1566	3	532	2018-11-22 10:19:39	2018-11-22	9
1567	1	533	2018-11-22 10:17:33	2018-11-22	9
1568	2	533	2018-11-22 10:17:35	2018-11-22	9
1569	3	533	2018-11-22 10:17:37	2018-11-22	9
1570	1	534	2018-11-22 10:18:02	2018-11-22	9
1571	2	534	2018-11-22 10:18:04	2018-11-22	9
1572	3	534	2018-12-05 14:07:03	2018-12-05	13
1573	1	535	2018-11-22 10:12:17	2018-11-22	9
1574	2	535	2018-11-22 10:12:19	2018-11-22	9
1575	3	535	2018-11-22 10:12:20	2018-11-22	9
1576	1	536	2018-11-22 09:56:28	2018-11-22	8
1577	2	536	2018-11-22 09:56:30	2018-11-22	8
1578	3	536	2018-11-22 09:56:32	2018-11-22	8
1579	1	537	2018-11-22 09:52:04	2018-11-22	8
1580	2	537	2018-11-22 09:52:06	2018-11-22	8
1581	3	537	2018-11-22 10:55:37	2018-11-22	9
1582	1	538	2018-11-22 09:44:54	2018-11-22	8
1583	2	538	2018-11-22 09:44:56	2018-11-22	8
1584	3	538	2018-11-22 09:44:59	2018-11-22	8
1585	1	539	2018-11-22 09:42:10	2018-11-22	8
1586	2	539	2018-11-22 09:42:12	2018-11-22	8
1587	3	539	2018-11-22 09:55:05	2018-11-22	8
1588	1	540	2018-11-22 09:41:46	2018-11-22	8
1589	2	540	2018-11-22 09:41:48	2018-11-22	8
1590	3	540	2018-11-22 09:41:49	2018-11-22	8
1591	1	541	2018-11-22 09:40:04	2018-11-22	8
1592	2	541	2018-11-22 09:40:05	2018-11-22	8
1593	3	541	2018-11-22 09:40:07	2018-11-22	8
1594	1	542	2018-11-22 09:29:14	2018-11-22	8
1595	2	542	2018-11-22 09:29:15	2018-11-22	8
1596	3	542	2018-11-22 09:29:17	2018-11-22	8
1597	1	543	2018-11-22 09:25:55	2018-11-22	8
1598	2	543	2018-11-22 09:25:56	2018-11-22	8
1599	3	543	2018-11-22 09:25:58	2018-11-22	8
1600	1	544	2018-11-22 09:20:37	2018-11-22	8
1601	2	544	2018-11-22 09:20:39	2018-11-22	8
1602	3	544	2018-11-22 09:20:41	2018-11-22	8
1603	1	545	2018-11-22 09:22:34	2018-11-22	8
1604	2	545	2018-11-22 09:22:36	2018-11-22	8
1605	3	545	2018-12-06 10:51:28	2018-12-06	9
1606	1	546	2018-11-22 09:24:43	2018-11-22	8
1607	2	546	2018-11-22 09:24:45	2018-11-22	8
1608	3	546	2018-11-22 09:24:47	2018-11-22	8
1609	1	547	2018-11-22 09:17:10	2018-11-22	8
1610	2	547	2018-11-22 09:17:12	2018-11-22	8
1611	3	547	2018-11-22 09:17:13	2018-11-22	8
1612	1	548	2018-11-22 09:14:40	2018-11-22	8
1613	2	548	2018-11-22 09:14:42	2018-11-22	8
1614	3	548	2018-11-22 09:14:44	2018-11-22	8
1615	1	549	2018-11-22 09:12:42	2018-11-22	8
1616	2	549	2018-11-22 09:12:44	2018-11-22	8
1617	3	549	2018-11-22 09:12:45	2018-11-22	8
1618	1	550	2018-11-21 16:59:42	2018-11-21	15
1619	2	550	2018-11-21 16:59:44	2018-11-21	15
1620	3	550	2018-11-21 16:59:46	2018-11-21	15
1621	1	551	2018-11-21 16:26:36	2018-11-21	15
1622	2	551	2018-11-21 16:26:38	2018-11-21	15
1623	3	551	2018-11-21 16:26:40	2018-11-21	15
1624	1	552	2018-11-21 15:57:06	2018-11-21	14
1625	2	552	2018-11-21 15:57:07	2018-11-21	14
1626	3	552	2018-11-21 16:03:05	2018-11-21	15
1627	1	553	2018-11-21 15:42:28	2018-11-21	14
1628	2	553	2018-11-21 15:42:29	2018-11-21	14
1629	3	553	2018-11-21 15:42:31	2018-11-21	14
1630	1	554	2018-11-21 15:24:54	2018-11-21	14
1631	2	554	2018-11-21 15:24:56	2018-11-21	14
1632	3	554	2018-11-21 15:24:58	2018-11-21	14
1633	1	555	2018-11-21 15:17:18	2018-11-21	14
1634	2	555	2018-11-21 15:17:19	2018-11-21	14
1635	3	555	2018-11-21 15:17:21	2018-11-21	14
1636	1	556	2018-11-21 15:06:23	2018-11-21	14
1637	2	556	2018-11-21 15:06:25	2018-11-21	14
1638	3	556	2018-11-21 15:14:40	2018-11-21	14
1639	1	557	2018-11-21 14:56:42	2018-11-21	13
1640	2	557	2018-11-21 14:56:43	2018-11-21	13
1641	3	557	2018-11-21 14:56:45	2018-11-21	13
1642	1	558	2018-11-21 14:52:29	2018-11-21	13
1643	2	558	2018-11-21 14:52:31	2018-11-21	13
1644	3	558	2018-11-21 14:52:33	2018-11-21	13
1645	1	559	2018-11-21 14:52:34	2018-11-21	13
1646	2	559	2018-11-21 14:52:35	2018-11-21	13
1647	3	559	2018-11-21 15:12:22	2018-11-21	14
1648	1	560	2018-11-21 14:49:38	2018-11-21	13
1649	2	560	2018-11-21 14:49:40	2018-11-21	13
1650	3	560	2018-11-21 15:03:07	2018-11-21	14
1651	1	561	2018-11-21 14:38:21	2018-11-21	13
1652	2	561	2018-11-21 14:38:23	2018-11-21	13
1653	3	561	2018-11-21 14:38:25	2018-11-21	13
1654	1	562	2018-11-21 14:31:32	2018-11-21	13
1655	2	562	2018-11-21 14:31:34	2018-11-21	13
1656	3	562	2018-11-21 14:31:36	2018-11-21	13
1657	1	563	2018-11-21 14:29:00	2018-11-21	13
1658	2	563	2018-11-21 14:29:02	2018-11-21	13
1659	3	563	2018-11-21 14:29:03	2018-11-21	13
1660	1	564	2018-11-21 14:25:29	2018-11-21	13
1661	2	564	2018-11-21 14:25:31	2018-11-21	13
1662	3	564	2018-11-21 14:40:40	2018-11-21	13
1663	1	565	2018-11-21 14:22:24	2018-11-21	13
1664	2	565	2018-11-21 14:22:26	2018-11-21	13
1665	3	565	2018-11-21 14:22:28	2018-11-21	13
1666	1	566	2018-11-21 14:18:28	2018-11-21	13
1667	2	566	2018-11-21 14:18:30	2018-11-21	13
1668	3	566	2018-11-21 14:18:32	2018-11-21	13
1669	1	567	2018-11-21 14:16:22	2018-11-21	13
1670	2	567	2018-11-21 14:16:23	2018-11-21	13
1671	3	567	2018-11-21 14:16:25	2018-11-21	13
1672	1	568	2018-11-21 14:12:36	2018-11-21	13
1673	2	568	2018-11-21 14:12:39	2018-11-21	13
1674	3	568	2018-11-21 14:44:39	2018-11-21	13
1675	1	569	2018-11-21 14:08:27	2018-11-21	13
1676	2	569	2018-11-21 14:08:29	2018-11-21	13
1677	3	569	2018-11-21 16:30:10	2018-11-21	15
1678	1	570	2018-11-21 12:23:53	2018-11-21	11
1679	2	570	2018-11-21 12:23:56	2018-11-21	11
1680	3	570	2018-11-21 13:10:13	2018-11-21	12
1681	1	571	2018-11-21 12:09:49	2018-11-21	11
1682	2	571	2018-11-21 12:09:50	2018-11-21	11
1683	3	571	2018-11-21 12:09:52	2018-11-21	11
1684	1	572	2018-11-21 11:56:23	2018-11-21	10
1685	2	572	2018-11-21 11:56:25	2018-11-21	10
1686	3	572	2018-11-21 11:56:27	2018-11-21	10
1687	1	573	2018-11-21 11:48:52	2018-11-21	10
1688	2	573	2018-11-21 11:48:54	2018-11-21	10
1689	3	573	2018-11-21 11:48:56	2018-11-21	10
1690	1	574	2018-11-21 11:44:20	2018-11-21	10
1691	2	574	2018-11-21 11:44:22	2018-11-21	10
1692	3	574	2018-11-22 16:39:24	2018-11-22	15
1693	1	575	2018-11-21 11:38:07	2018-11-21	10
1694	2	575	2018-11-21 11:38:09	2018-11-21	10
1695	3	575	2018-11-21 13:48:43	2018-11-21	12
1696	1	576	2018-11-21 11:31:46	2018-11-21	10
1697	2	576	2018-11-21 11:31:47	2018-11-21	10
1698	3	576	2018-11-21 11:31:49	2018-11-21	10
1699	1	577	2018-11-21 11:30:39	2018-11-21	10
1700	2	577	2018-11-21 11:30:41	2018-11-21	10
1701	3	577	2018-11-21 11:30:43	2018-11-21	10
1702	1	578	2018-11-21 11:18:52	2018-11-21	10
1703	2	578	2018-11-21 11:18:55	2018-11-21	10
1704	3	578	2018-11-21 11:18:57	2018-11-21	10
1705	1	579	2018-11-21 11:18:10	2018-11-21	10
1706	2	579	2018-11-21 11:18:12	2018-11-21	10
1707	3	579	2018-11-21 11:18:14	2018-11-21	10
1708	1	580	2018-11-21 11:16:14	2018-11-21	10
1709	2	580	2018-11-21 11:16:16	2018-11-21	10
1710	3	580	2018-11-21 11:45:32	2018-11-21	10
1711	1	581	2018-11-21 11:14:40	2018-11-21	10
1712	2	581	2018-11-21 11:14:43	2018-11-21	10
1713	3	581	2018-11-22 08:11:46	2018-11-22	7
1714	1	582	2018-11-21 11:07:13	2018-11-21	10
1715	2	582	2018-11-21 11:07:15	2018-11-21	10
1716	3	582	2018-11-21 11:07:17	2018-11-21	10
1717	1	583	2018-11-21 10:57:51	2018-11-21	9
1718	2	583	2018-11-21 10:57:53	2018-11-21	9
1719	3	583	2018-11-21 10:57:55	2018-11-21	9
1720	1	584	2018-11-21 10:51:47	2018-11-21	9
1721	2	584	2018-11-21 10:51:49	2018-11-21	9
1722	3	584	2018-11-21 10:51:51	2018-11-21	9
1723	1	585	2018-11-21 10:49:05	2018-11-21	9
1724	2	585	2018-11-21 10:49:07	2018-11-21	9
1725	3	585	2018-11-21 10:49:10	2018-11-21	9
1726	1	586	2018-11-21 10:39:27	2018-11-21	9
1727	2	586	2018-11-21 10:39:28	2018-11-21	9
1728	3	586	2018-11-21 10:48:35	2018-11-21	9
1729	1	587	2018-11-21 10:33:39	2018-11-21	9
1730	2	587	2018-11-21 10:33:41	2018-11-21	9
1731	3	587	2018-12-05 10:24:41	2018-12-05	9
1732	1	588	2018-11-21 10:32:17	2018-11-21	9
1733	2	588	2018-11-21 10:32:19	2018-11-21	9
1734	3	588	2018-11-21 10:32:21	2018-11-21	9
1735	1	589	2018-11-21 10:10:15	2018-11-21	9
1736	2	589	2018-11-21 10:10:17	2018-11-21	9
1737	3	589	2018-11-21 10:10:19	2018-11-21	9
1738	1	590	2018-11-21 10:08:11	2018-11-21	9
1739	2	590	2018-11-21 10:08:13	2018-11-21	9
1740	3	590	2018-11-21 10:08:14	2018-11-21	9
1741	1	591	2018-11-21 10:02:27	2018-11-21	9
1742	2	591	2018-11-21 10:02:30	2018-11-21	9
1743	3	591	2018-11-21 14:06:09	2018-11-21	13
1744	1	592	2018-11-21 09:53:56	2018-11-21	8
1745	2	592	2018-11-21 09:53:58	2018-11-21	8
1746	3	592	2018-11-21 09:53:59	2018-11-21	8
1747	1	593	2018-11-21 09:51:33	2018-11-21	8
1748	2	593	2018-11-21 09:51:35	2018-11-21	8
1749	3	593	2018-11-21 09:51:36	2018-11-21	8
1750	1	594	2018-11-21 09:54:49	2018-11-21	8
1751	2	594	2018-11-21 09:54:50	2018-11-21	8
1752	3	594	2018-11-21 10:32:06	2018-11-21	9
1753	1	595	2018-11-21 09:38:27	2018-11-21	8
1754	2	595	2018-11-21 09:38:28	2018-11-21	8
1755	3	595	2018-11-21 09:38:30	2018-11-21	8
1756	1	596	2018-11-21 09:30:08	2018-11-21	8
1757	2	596	2018-11-21 09:30:10	2018-11-21	8
1758	3	596	2018-11-21 09:30:12	2018-11-21	8
1759	1	597	2018-11-21 09:19:24	2018-11-21	8
1760	2	597	2018-11-21 09:19:25	2018-11-21	8
1761	3	597	2018-11-21 09:19:28	2018-11-21	8
1762	1	598	2018-11-21 08:54:31	2018-11-21	7
1763	2	598	2018-11-21 08:54:35	2018-11-21	7
1764	3	598	2018-11-21 09:01:47	2018-11-21	8
1765	1	599	2018-11-21 08:50:31	2018-11-21	7
1766	2	599	2018-11-21 08:50:32	2018-11-21	7
1767	3	599	2018-11-21 08:50:34	2018-11-21	7
1768	1	600	2018-11-21 08:42:16	2018-11-21	7
1769	2	600	2018-11-21 08:42:18	2018-11-21	7
1770	3	600	2018-11-21 08:42:20	2018-11-21	7
1771	1	601	2018-11-21 08:41:58	2018-11-21	7
1772	2	601	2018-11-21 08:41:59	2018-11-21	7
1773	3	601	2018-11-21 08:42:01	2018-11-21	7
1774	1	602	2018-11-21 07:39:03	2018-11-21	6
1775	2	602	2018-11-21 07:39:06	2018-11-21	6
1776	3	602	2018-11-21 14:09:51	2018-11-21	13
1777	1	603	2018-11-21 07:29:35	2018-11-21	6
1778	2	603	2018-11-21 07:29:37	2018-11-21	6
1779	3	603	2018-11-21 08:55:13	2018-11-21	7
1780	1	604	2018-11-20 17:36:38	2018-11-20	16
1781	2	604	2018-11-20 17:36:40	2018-11-20	16
1782	3	604	2018-11-21 08:37:28	2018-11-21	7
1783	1	605	2018-11-20 16:58:13	2018-11-20	15
1784	2	605	2018-11-20 16:58:15	2018-11-20	15
1785	3	605	2018-11-20 16:58:17	2018-11-20	15
1786	1	606	2018-11-20 16:48:09	2018-11-20	15
1787	2	606	2018-11-20 16:48:12	2018-11-20	15
1788	3	606	2018-11-21 14:11:49	2018-11-21	13
1789	1	607	2018-11-20 16:45:02	2018-11-20	15
1790	2	607	2018-11-20 16:45:04	2018-11-20	15
1791	3	607	2018-11-20 16:45:06	2018-11-20	15
1792	1	608	2018-11-20 16:09:33	2018-11-20	15
1793	2	608	2018-11-20 16:09:34	2018-11-20	15
1794	3	608	2018-11-21 14:15:41	2018-11-21	13
1795	1	609	2018-11-20 16:07:17	2018-11-20	15
1796	2	609	2018-11-20 16:07:19	2018-11-20	15
1797	3	609	2018-11-20 16:07:21	2018-11-20	15
1798	1	610	2018-11-20 15:55:43	2018-11-20	14
1799	2	610	2018-11-20 15:55:44	2018-11-20	14
1800	3	610	2018-11-20 15:55:46	2018-11-20	14
1801	1	611	2018-11-20 15:42:09	2018-11-20	14
1802	2	611	2018-11-20 15:42:12	2018-11-20	14
1803	3	611	2018-11-20 15:42:14	2018-11-20	14
1804	1	612	2018-11-20 15:12:36	2018-11-20	14
1805	2	612	2018-11-20 15:12:38	2018-11-20	14
1806	3	612	2018-11-20 15:12:40	2018-11-20	14
1807	1	613	2018-11-20 15:05:42	2018-11-20	14
1808	2	613	2018-11-20 15:05:44	2018-11-20	14
1809	3	613	2018-11-20 15:05:45	2018-11-20	14
1810	1	614	2018-11-20 14:49:52	2018-11-20	13
1811	2	614	2018-11-20 14:49:55	2018-11-20	13
1812	3	614	2018-11-20 14:50:02	2018-11-20	13
1813	1	615	2018-11-20 14:50:12	2018-11-20	13
1814	2	615	2018-11-20 14:50:15	2018-11-20	13
1815	3	615	2018-11-21 14:45:48	2018-11-21	13
1816	1	616	2018-11-20 14:46:15	2018-11-20	13
1817	2	616	2018-11-20 14:46:17	2018-11-20	13
1818	3	616	2018-11-20 16:01:04	2018-11-20	15
1819	1	617	2018-11-20 14:44:15	2018-11-20	13
1820	2	617	2018-11-20 14:44:19	2018-11-20	13
1821	3	617	2018-11-20 15:58:23	2018-11-20	14
1822	1	618	2018-11-20 14:28:54	2018-11-20	13
1823	2	618	2018-11-20 14:28:58	2018-11-20	13
1824	3	618	2018-11-21 14:47:45	2018-11-21	13
1825	1	619	2018-11-20 14:27:36	2018-11-20	13
1826	2	619	2018-11-20 14:27:38	2018-11-20	13
1827	3	619	2018-11-20 14:27:40	2018-11-20	13
1828	1	620	2018-11-20 14:26:59	2018-11-20	13
1829	2	620	2018-11-20 14:27:01	2018-11-20	13
1830	3	620	2018-11-20 14:27:02	2018-11-20	13
1831	1	621	2018-11-20 14:26:07	2018-11-20	13
1832	2	621	2018-11-20 14:26:08	2018-11-20	13
1833	3	621	2018-11-20 14:26:10	2018-11-20	13
1834	1	622	2018-11-20 14:12:42	2018-11-20	13
1835	2	622	2018-11-20 14:12:44	2018-11-20	13
1836	3	622	2018-11-20 14:12:46	2018-11-20	13
1837	1	623	2018-11-20 14:06:03	2018-11-20	13
1838	2	623	2018-11-20 14:06:06	2018-11-20	13
1839	3	623	2018-11-21 14:17:58	2018-11-21	13
1840	1	624	2018-11-20 13:51:11	2018-11-20	12
1841	2	624	2018-11-20 13:51:14	2018-11-20	12
1842	3	624	2018-11-27 10:35:08	2018-11-27	9
1843	1	625	2018-11-20 13:38:56	2018-11-20	12
1844	2	625	2018-11-20 13:38:58	2018-11-20	12
1845	1	626	2018-11-20 13:37:34	2018-11-20	12
1846	2	626	2018-11-20 13:37:36	2018-11-20	12
1847	3	626	2018-11-20 13:39:32	2018-11-20	12
1848	1	627	2018-11-20 11:48:30	2018-11-20	10
1849	2	627	2018-11-20 11:48:33	2018-11-20	10
1850	3	627	2018-11-21 14:52:21	2018-11-21	13
1851	1	628	2018-11-20 11:42:31	2018-11-20	10
1852	2	628	2018-11-20 11:42:32	2018-11-20	10
1853	3	628	2018-11-20 11:42:35	2018-11-20	10
1854	1	629	2018-11-20 11:35:48	2018-11-20	10
1855	2	629	2018-11-20 11:35:49	2018-11-20	10
1856	3	629	2018-11-20 11:35:51	2018-11-20	10
1857	1	630	2018-11-20 11:27:43	2018-11-20	10
1858	2	630	2018-11-20 11:27:45	2018-11-20	10
1859	3	630	2018-11-20 11:27:47	2018-11-20	10
1860	1	631	2018-11-20 11:23:34	2018-11-20	10
1861	2	631	2018-11-20 11:23:36	2018-11-20	10
1862	3	631	2018-11-20 11:23:57	2018-11-20	10
1863	1	632	2018-11-20 11:22:00	2018-11-20	10
1864	2	632	2018-11-20 11:22:02	2018-11-20	10
1865	3	632	2018-11-20 11:22:04	2018-11-20	10
1866	1	633	2018-11-20 11:20:07	2018-11-20	10
1867	2	633	2018-11-20 11:20:09	2018-11-20	10
1868	3	633	2018-11-20 11:20:11	2018-11-20	10
1869	1	634	2018-11-20 11:19:44	2018-11-20	10
1870	2	634	2018-11-20 11:19:46	2018-11-20	10
1871	3	634	2018-11-20 11:19:47	2018-11-20	10
1872	1	635	2018-11-20 10:55:52	2018-11-20	9
1873	2	635	2018-11-20 10:55:54	2018-11-20	9
1874	3	635	2018-11-20 10:55:56	2018-11-20	9
1875	1	636	2018-11-20 10:51:16	2018-11-20	9
1876	2	636	2018-11-20 10:51:17	2018-11-20	9
1877	3	636	2018-11-20 10:51:19	2018-11-20	9
1878	1	637	2018-11-20 10:34:12	2018-11-20	9
1879	2	637	2018-11-20 10:34:13	2018-11-20	9
1880	3	637	2018-11-20 10:34:15	2018-11-20	9
1881	1	638	2018-11-20 10:20:10	2018-11-20	9
1882	2	638	2018-11-20 10:20:12	2018-11-20	9
1883	3	638	2018-11-20 10:20:14	2018-11-20	9
1884	1	639	2018-11-20 10:12:26	2018-11-20	9
1885	2	639	2018-11-20 10:12:28	2018-11-20	9
1886	3	639	2018-11-20 10:43:09	2018-11-20	9
1887	1	640	2018-11-20 10:08:25	2018-11-20	9
1888	2	640	2018-11-20 10:08:26	2018-11-20	9
1889	3	640	2018-11-20 10:08:28	2018-11-20	9
1890	1	641	2018-11-20 09:59:51	2018-11-20	8
1891	2	641	2018-11-20 09:59:53	2018-11-20	8
1892	3	641	2018-11-20 09:59:55	2018-11-20	8
1893	1	642	2018-11-20 09:53:03	2018-11-20	8
1894	2	642	2018-11-20 09:53:05	2018-11-20	8
1895	3	642	2018-11-20 09:53:07	2018-11-20	8
1896	1	643	2018-11-20 09:42:32	2018-11-20	8
1897	2	643	2018-11-20 09:42:34	2018-11-20	8
1898	3	643	2018-11-20 09:42:36	2018-11-20	8
1899	1	644	2018-11-20 09:38:12	2018-11-20	8
1900	2	644	2018-11-20 09:38:14	2018-11-20	8
1901	3	644	2018-11-20 09:38:16	2018-11-20	8
1902	1	645	2018-11-20 09:36:57	2018-11-20	8
1903	2	645	2018-11-20 09:36:59	2018-11-20	8
1904	3	645	2018-11-20 11:31:53	2018-11-20	10
1905	1	646	2018-11-20 09:32:49	2018-11-20	8
1906	2	646	2018-11-20 09:32:50	2018-11-20	8
1907	3	646	2018-11-20 09:32:52	2018-11-20	8
1908	1	647	2018-11-20 09:30:51	2018-11-20	8
1909	2	647	2018-11-20 09:30:52	2018-11-20	8
1910	3	647	2018-11-20 09:30:54	2018-11-20	8
1911	1	648	2018-11-20 09:29:11	2018-11-20	8
1912	2	648	2018-11-20 09:29:13	2018-11-20	8
1913	3	648	2018-11-20 09:29:15	2018-11-20	8
1914	1	649	2018-11-20 09:29:21	2018-11-20	8
1915	2	649	2018-11-20 09:29:23	2018-11-20	8
1916	3	649	2018-11-21 15:24:10	2018-11-21	14
1917	1	650	2018-11-20 09:26:58	2018-11-20	8
1918	2	650	2018-11-20 09:26:59	2018-11-20	8
1919	3	650	2018-11-20 11:44:38	2018-11-20	10
1920	1	651	2018-11-20 09:22:16	2018-11-20	8
1921	2	651	2018-11-20 09:22:18	2018-11-20	8
1922	3	651	2018-11-20 09:22:19	2018-11-20	8
1923	1	652	2018-11-20 09:19:09	2018-11-20	8
1924	2	652	2018-11-20 09:19:11	2018-11-20	8
1925	3	652	2018-11-20 09:19:13	2018-11-20	8
1926	1	653	2018-11-20 09:16:43	2018-11-20	8
1927	2	653	2018-11-20 09:16:45	2018-11-20	8
1928	3	653	2018-11-20 09:16:47	2018-11-20	8
1929	1	654	2018-11-20 09:12:48	2018-11-20	8
1930	2	654	2018-11-20 09:12:49	2018-11-20	8
1931	3	654	2018-11-20 09:12:51	2018-11-20	8
1932	1	655	2018-11-20 09:08:14	2018-11-20	8
1933	2	655	2018-11-20 09:08:15	2018-11-20	8
1934	3	655	2018-11-20 09:08:17	2018-11-20	8
1935	1	656	2018-11-20 09:05:23	2018-11-20	8
1936	2	656	2018-11-20 09:05:25	2018-11-20	8
1937	3	656	2018-11-20 09:05:27	2018-11-20	8
1938	1	657	2018-11-20 09:04:07	2018-11-20	8
1939	2	657	2018-11-20 09:04:09	2018-11-20	8
1940	3	657	2018-11-20 09:04:11	2018-11-20	8
1941	1	658	2018-11-20 09:02:13	2018-11-20	8
1942	2	658	2018-11-20 09:02:15	2018-11-20	8
1943	3	658	2018-11-20 09:02:17	2018-11-20	8
1944	1	659	2018-11-20 09:00:27	2018-11-20	8
1945	2	659	2018-11-20 09:00:29	2018-11-20	8
1946	3	659	2018-11-20 09:00:32	2018-11-20	8
1947	1	660	2018-11-20 08:59:26	2018-11-20	7
1948	2	660	2018-11-20 08:59:27	2018-11-20	7
1949	3	660	2018-11-20 08:59:29	2018-11-20	7
1950	1	661	2018-11-20 08:57:54	2018-11-20	7
1951	2	661	2018-11-20 08:57:58	2018-11-20	7
1952	3	661	2018-11-20 09:16:09	2018-11-20	8
1953	1	662	2018-11-20 08:44:42	2018-11-20	7
1954	2	662	2018-11-20 08:44:46	2018-11-20	7
1955	3	662	2018-11-21 15:26:45	2018-11-21	14
1956	1	663	2018-11-20 07:43:22	2018-11-20	6
1957	2	663	2018-11-20 07:43:25	2018-11-20	6
1958	3	663	2018-11-21 15:28:59	2018-11-21	14
1959	1	664	2018-11-20 07:41:33	2018-11-20	6
1960	2	664	2018-11-20 07:41:35	2018-11-20	6
1961	3	664	2018-11-21 15:30:43	2018-11-21	14
1962	1	665	2018-11-19 18:15:50	2018-11-19	17
1963	2	665	2018-11-19 18:15:52	2018-11-19	17
1964	3	665	2018-11-21 09:45:49	2018-11-21	8
1965	1	666	2018-11-19 16:48:01	2018-11-19	15
1966	2	666	2018-11-19 16:48:02	2018-11-19	15
1967	3	666	2018-11-19 16:48:04	2018-11-19	15
1968	1	667	2018-11-19 16:47:39	2018-11-19	15
1969	2	667	2018-11-19 16:47:42	2018-11-19	15
1970	3	667	2018-11-21 15:35:42	2018-11-21	14
1971	1	668	2018-11-19 16:34:23	2018-11-19	15
1972	2	668	2018-11-19 16:34:25	2018-11-19	15
1973	3	668	2018-11-19 16:34:28	2018-11-19	15
1974	1	669	2018-11-19 16:24:22	2018-11-19	15
1975	2	669	2018-11-19 16:24:24	2018-11-19	15
1976	3	669	2018-11-20 09:19:33	2018-11-20	8
1977	1	670	2018-11-19 16:10:04	2018-11-19	15
1978	2	670	2018-11-19 16:10:06	2018-11-19	15
1979	3	670	2018-11-19 16:10:07	2018-11-19	15
1980	1	671	2018-11-19 15:51:29	2018-11-19	14
1981	2	671	2018-11-19 15:51:31	2018-11-19	14
1982	3	671	2018-11-21 15:38:22	2018-11-21	14
1983	1	672	2018-11-19 15:34:37	2018-11-19	14
1984	2	672	2018-11-19 15:34:39	2018-11-19	14
1985	3	672	2018-11-19 15:34:41	2018-11-19	14
1986	1	673	2018-11-19 15:34:15	2018-11-19	14
1987	2	673	2018-11-19 15:34:17	2018-11-19	14
1988	3	673	2018-11-19 15:34:19	2018-11-19	14
1989	1	674	2018-11-19 15:29:53	2018-11-19	14
1990	2	674	2018-11-19 15:29:55	2018-11-19	14
1991	3	674	2018-11-19 15:29:57	2018-11-19	14
1992	1	675	2018-11-19 15:09:41	2018-11-19	14
1993	2	675	2018-11-19 15:09:43	2018-11-19	14
1994	3	675	2018-11-19 15:09:45	2018-11-19	14
1995	1	676	2018-11-19 15:00:41	2018-11-19	14
1996	2	676	2018-11-19 15:00:44	2018-11-19	14
1997	3	676	2018-11-19 15:00:46	2018-11-19	14
1998	1	677	2018-11-19 14:59:05	2018-11-19	13
1999	2	677	2018-11-19 14:59:07	2018-11-19	13
2000	3	677	2018-11-19 14:59:09	2018-11-19	13
2001	1	678	2018-11-19 14:55:53	2018-11-19	13
2002	2	678	2018-11-19 14:55:55	2018-11-19	13
2003	3	678	2018-11-19 14:55:57	2018-11-19	13
2004	1	679	2018-11-19 14:51:52	2018-11-19	13
2005	2	679	2018-11-19 14:51:54	2018-11-19	13
2006	3	679	2018-11-19 14:51:56	2018-11-19	13
2007	1	680	2018-11-19 14:50:59	2018-11-19	13
2008	2	680	2018-11-19 14:51:01	2018-11-19	13
2009	3	680	2018-11-19 14:51:03	2018-11-19	13
2010	1	681	2018-11-19 14:46:59	2018-11-19	13
2011	2	681	2018-11-19 14:47:02	2018-11-19	13
2012	3	681	2018-12-05 14:07:55	2018-12-05	13
2013	1	682	2018-11-19 14:40:40	2018-11-19	13
2014	2	682	2018-11-19 14:40:42	2018-11-19	13
2015	3	682	2018-11-19 14:40:44	2018-11-19	13
2016	1	683	2018-11-19 14:21:51	2018-11-19	13
2017	2	683	2018-11-19 14:21:53	2018-11-19	13
2018	3	683	2018-11-20 09:06:57	2018-11-20	8
2019	1	684	2018-11-19 14:18:10	2018-11-19	13
2020	2	684	2018-11-19 14:18:12	2018-11-19	13
2021	3	684	2018-11-19 14:18:13	2018-11-19	13
2022	1	685	2018-11-19 14:17:57	2018-11-19	13
2023	2	685	2018-11-19 14:17:59	2018-11-19	13
2024	3	685	2018-11-19 14:18:01	2018-11-19	13
2025	1	686	2018-11-19 14:04:09	2018-11-19	13
2026	2	686	2018-11-19 14:04:10	2018-11-19	13
2027	3	686	2018-11-19 14:04:12	2018-11-19	13
2028	1	687	2018-11-19 13:36:08	2018-11-19	12
2029	2	687	2018-11-19 13:36:11	2018-11-19	12
2030	3	687	2018-11-21 15:44:45	2018-11-21	14
2031	1	688	2018-11-19 11:58:46	2018-11-19	10
2032	2	688	2018-11-19 11:58:48	2018-11-19	10
2033	3	688	2018-11-19 11:58:50	2018-11-19	10
2034	1	689	2018-11-19 11:53:12	2018-11-19	10
2035	2	689	2018-11-19 11:53:14	2018-11-19	10
2036	3	689	2018-11-19 11:53:16	2018-11-19	10
2037	1	690	2018-11-19 11:52:43	2018-11-19	10
2038	2	690	2018-11-19 11:52:44	2018-11-19	10
2039	3	690	2018-11-19 11:52:46	2018-11-19	10
2040	1	691	2018-11-19 11:52:04	2018-11-19	10
2041	2	691	2018-11-19 11:52:06	2018-11-19	10
2042	3	691	2018-11-19 11:52:08	2018-11-19	10
2043	1	692	2018-11-19 11:37:37	2018-11-19	10
2044	2	692	2018-11-19 11:37:38	2018-11-19	10
2045	3	692	2018-11-20 09:04:48	2018-11-20	8
2046	1	693	2018-11-19 11:33:17	2018-11-19	10
2047	2	693	2018-11-19 11:33:19	2018-11-19	10
2048	3	693	2018-11-20 09:03:44	2018-11-20	8
2049	1	694	2018-11-19 11:31:04	2018-11-19	10
2050	2	694	2018-11-19 11:31:07	2018-11-19	10
2051	3	694	2018-11-20 09:05:25	2018-11-20	8
2052	1	695	2018-11-19 11:25:04	2018-11-19	10
2053	2	695	2018-11-19 11:25:06	2018-11-19	10
2054	3	695	2018-11-19 11:25:08	2018-11-19	10
2055	1	696	2018-11-19 11:17:59	2018-11-19	10
2056	2	696	2018-11-19 11:18:01	2018-11-19	10
2057	3	696	2018-11-19 11:18:03	2018-11-19	10
2058	1	697	2018-11-19 11:04:19	2018-11-19	10
2059	2	697	2018-11-19 11:04:21	2018-11-19	10
2060	3	697	2018-11-19 11:04:23	2018-11-19	10
2061	1	698	2018-11-19 10:59:35	2018-11-19	9
2062	2	698	2018-11-19 10:59:37	2018-11-19	9
2063	3	698	2018-11-19 11:15:00	2018-11-19	10
2064	1	699	2018-11-19 10:56:37	2018-11-19	9
2065	2	699	2018-11-19 10:56:41	2018-11-19	9
2066	3	699	2018-11-21 15:45:49	2018-11-21	14
2067	1	700	2018-11-19 10:54:23	2018-11-19	9
2068	2	700	2018-11-19 10:54:24	2018-11-19	9
2069	3	700	2018-11-19 10:54:26	2018-11-19	9
2070	1	701	2018-11-19 10:39:43	2018-11-19	9
2071	2	701	2018-11-19 10:39:45	2018-11-19	9
2072	3	701	2018-11-19 10:39:47	2018-11-19	9
2073	1	702	2018-11-19 10:35:24	2018-11-19	9
2074	2	702	2018-11-19 10:35:26	2018-11-19	9
2075	3	702	2018-11-20 09:01:22	2018-11-20	8
2076	1	703	2018-11-19 10:29:15	2018-11-19	9
2077	2	703	2018-11-19 10:29:17	2018-11-19	9
2078	3	703	2018-11-19 10:29:19	2018-11-19	9
2079	1	704	2018-11-19 10:23:33	2018-11-19	9
2080	2	704	2018-11-19 10:23:35	2018-11-19	9
2081	3	704	2018-11-19 10:23:37	2018-11-19	9
2082	1	705	2018-11-19 10:12:38	2018-11-19	9
2083	2	705	2018-11-19 10:12:41	2018-11-19	9
2084	3	705	2018-11-26 11:27:19	2018-11-26	10
2085	1	706	2018-11-19 09:52:50	2018-11-19	8
2086	2	706	2018-11-19 09:52:52	2018-11-19	8
2087	3	706	2018-11-19 09:52:54	2018-11-19	8
2088	1	707	2018-11-19 09:41:21	2018-11-19	8
2089	2	707	2018-11-19 09:41:24	2018-11-19	8
2090	3	707	2018-11-19 09:45:09	2018-11-19	8
2091	1	708	2018-11-19 09:42:00	2018-11-19	8
2092	2	708	2018-11-19 09:42:02	2018-11-19	8
2093	3	708	2018-11-20 08:59:34	2018-11-20	7
2094	1	709	2018-11-19 09:30:10	2018-11-19	8
2095	2	709	2018-11-19 09:30:12	2018-11-19	8
2096	3	709	2018-11-19 09:31:07	2018-11-19	8
2097	1	710	2018-11-19 09:29:22	2018-11-19	8
2098	2	710	2018-11-19 09:29:24	2018-11-19	8
2099	3	710	2018-11-19 09:29:26	2018-11-19	8
2100	1	711	2018-11-19 09:26:48	2018-11-19	8
2101	2	711	2018-11-19 09:26:49	2018-11-19	8
2102	3	711	2018-11-19 09:26:51	2018-11-19	8
2103	1	712	2018-11-19 09:23:27	2018-11-19	8
2104	2	712	2018-11-19 09:23:29	2018-11-19	8
2105	3	712	2018-11-19 09:23:31	2018-11-19	8
2106	1	713	2018-11-19 09:22:00	2018-11-19	8
2107	2	713	2018-11-19 09:22:02	2018-11-19	8
2108	3	713	2018-11-19 09:24:07	2018-11-19	8
2109	1	714	2018-11-19 09:20:54	2018-11-19	8
2110	2	714	2018-11-19 09:20:57	2018-11-19	8
2111	3	714	2018-11-19 09:21:00	2018-11-19	8
2112	1	715	2018-11-19 09:19:59	2018-11-19	8
2113	2	715	2018-11-19 09:20:01	2018-11-19	8
2114	3	715	2018-11-21 16:08:58	2018-11-21	15
2115	1	716	2018-11-19 09:19:54	2018-11-19	8
2116	2	716	2018-11-19 09:19:57	2018-11-19	8
2117	3	716	2018-11-20 08:57:03	2018-11-20	7
2118	1	717	2018-11-19 09:17:42	2018-11-19	8
2119	2	717	2018-11-19 09:17:44	2018-11-19	8
2120	3	717	2018-11-21 16:13:09	2018-11-21	15
2121	1	718	2018-11-19 09:15:53	2018-11-19	8
2122	2	718	2018-11-19 09:15:55	2018-11-19	8
2123	3	718	2018-11-19 09:15:58	2018-11-19	8
2124	1	719	2018-11-19 09:16:26	2018-11-19	8
2125	2	719	2018-11-19 09:16:28	2018-11-19	8
2126	3	719	2018-11-19 09:16:30	2018-11-19	8
2127	1	720	2018-11-19 09:13:05	2018-11-19	8
2128	2	720	2018-11-19 09:13:07	2018-11-19	8
2129	3	720	2018-11-19 11:11:30	2018-11-19	10
2130	1	721	2018-11-19 09:09:56	2018-11-19	8
2131	2	721	2018-11-19 09:09:58	2018-11-19	8
2132	3	721	2018-11-19 09:10:00	2018-11-19	8
2133	1	722	2018-11-19 09:06:25	2018-11-19	8
2134	2	722	2018-11-19 09:06:27	2018-11-19	8
2135	3	722	2018-11-19 09:06:29	2018-11-19	8
2136	1	723	2018-11-19 09:05:31	2018-11-19	8
2137	2	723	2018-11-19 09:05:33	2018-11-19	8
2138	3	723	2018-11-19 09:05:35	2018-11-19	8
2139	1	724	2018-11-19 08:52:40	2018-11-19	7
2140	2	724	2018-11-19 08:52:42	2018-11-19	7
2141	3	724	2018-11-19 08:52:44	2018-11-19	7
2142	1	725	2018-11-19 08:50:44	2018-11-19	7
2143	2	725	2018-11-19 08:50:45	2018-11-19	7
2144	1	726	2018-11-19 09:12:12	2018-11-19	8
2145	2	726	2018-11-19 09:12:14	2018-11-19	8
2146	3	726	2018-11-21 16:16:11	2018-11-21	15
2147	1	727	2018-11-19 08:29:50	2018-11-19	7
2148	2	727	2018-11-19 08:29:51	2018-11-19	7
2149	3	727	2018-11-19 10:00:32	2018-11-19	9
2150	1	728	2018-11-19 08:27:41	2018-11-19	7
2151	2	728	2018-11-19 08:27:43	2018-11-19	7
2152	3	728	2018-11-28 13:43:18	2018-11-28	12
2153	1	729	2018-11-19 08:23:20	2018-11-19	7
2154	2	729	2018-11-19 08:23:22	2018-11-19	7
2155	3	729	2018-11-19 09:55:02	2018-11-19	8
2156	1	730	2018-11-19 07:50:48	2018-11-19	6
2157	2	730	2018-11-19 07:50:50	2018-11-19	6
2158	3	730	2018-11-19 08:21:57	2018-11-19	7
2159	1	731	2018-11-17 21:39:48	2018-11-17	20
2160	2	731	2018-11-17 21:39:51	2018-11-17	20
2161	3	731	2018-11-21 16:06:22	2018-11-21	15
2162	1	732	2018-11-17 18:34:37	2018-11-17	17
2163	2	732	2018-11-17 18:34:40	2018-11-17	17
2164	3	732	2018-11-19 09:55:29	2018-11-19	8
2165	1	733	2018-11-16 16:56:53	2018-11-16	15
2166	2	733	2018-11-16 16:56:55	2018-11-16	15
2167	3	733	2018-11-16 16:56:56	2018-11-16	15
2168	1	734	2018-11-16 16:53:56	2018-11-16	15
2169	2	734	2018-11-16 16:53:57	2018-11-16	15
2170	3	734	2018-11-16 16:53:59	2018-11-16	15
2171	1	735	2018-11-16 16:50:22	2018-11-16	15
2172	2	735	2018-11-16 16:50:24	2018-11-16	15
2173	3	735	2018-11-16 16:50:26	2018-11-16	15
2174	1	736	2018-11-16 16:23:32	2018-11-16	15
2175	2	736	2018-11-16 16:23:34	2018-11-16	15
2176	3	736	2018-11-16 16:23:36	2018-11-16	15
2177	1	737	2018-11-16 15:57:30	2018-11-16	14
2178	2	737	2018-11-16 15:57:32	2018-11-16	14
2179	3	737	2018-11-16 15:57:34	2018-11-16	14
2180	1	738	2018-11-16 15:31:47	2018-11-16	14
2181	2	738	2018-11-16 15:31:48	2018-11-16	14
2182	3	738	2018-11-16 15:31:50	2018-11-16	14
2183	1	739	2018-11-16 15:07:33	2018-11-16	14
2184	2	739	2018-11-16 15:07:36	2018-11-16	14
2185	3	739	2018-11-21 16:50:22	2018-11-21	15
2186	1	740	2018-11-16 14:52:10	2018-11-16	13
2187	2	740	2018-11-16 14:52:12	2018-11-16	13
2188	3	740	2018-11-16 14:52:14	2018-11-16	13
2189	1	741	2018-11-16 14:49:29	2018-11-16	13
2190	2	741	2018-11-16 14:49:31	2018-11-16	13
2191	3	741	2018-11-21 16:51:16	2018-11-21	15
2192	1	742	2018-11-16 14:46:04	2018-11-16	13
2193	2	742	2018-11-16 14:46:06	2018-11-16	13
2194	3	742	2018-11-16 14:46:08	2018-11-16	13
2195	1	743	2018-11-16 14:40:22	2018-11-16	13
2196	2	743	2018-11-16 14:40:24	2018-11-16	13
2197	3	743	2018-11-16 14:40:26	2018-11-16	13
2198	1	744	2018-11-16 14:39:06	2018-11-16	13
2199	2	744	2018-11-16 14:39:08	2018-11-16	13
2200	3	744	2018-11-16 14:39:10	2018-11-16	13
2201	1	745	2018-11-16 14:37:42	2018-11-16	13
2202	2	745	2018-11-16 14:37:44	2018-11-16	13
2203	3	745	2018-11-16 14:37:46	2018-11-16	13
2204	1	746	2018-11-16 14:32:15	2018-11-16	13
2205	2	746	2018-11-16 14:32:16	2018-11-16	13
2206	3	746	2018-11-16 14:32:19	2018-11-16	13
2207	1	747	2018-11-16 14:20:36	2018-11-16	13
2208	2	747	2018-11-16 14:20:38	2018-11-16	13
2209	3	747	2018-11-16 14:20:40	2018-11-16	13
2210	1	748	2018-11-16 14:13:25	2018-11-16	13
2211	2	748	2018-11-16 14:13:27	2018-11-16	13
2212	3	748	2018-11-16 14:13:29	2018-11-16	13
2213	1	749	2018-11-16 14:08:32	2018-11-16	13
2214	2	749	2018-11-16 14:08:34	2018-11-16	13
2215	3	749	2018-11-16 14:08:36	2018-11-16	13
2216	1	750	2018-11-16 12:04:44	2018-11-16	11
2217	2	750	2018-11-16 12:04:46	2018-11-16	11
2218	3	750	2018-11-16 12:04:48	2018-11-16	11
2219	1	751	2018-11-16 11:55:15	2018-11-16	10
2220	2	751	2018-11-16 11:55:18	2018-11-16	10
2221	3	751	2018-11-20 10:20:32	2018-11-20	9
2222	1	752	2018-11-16 11:35:34	2018-11-16	10
2223	2	752	2018-11-16 11:35:36	2018-11-16	10
2224	3	752	2018-11-16 11:35:37	2018-11-16	10
2225	1	753	2018-11-16 11:32:40	2018-11-16	10
2226	2	753	2018-11-16 11:32:42	2018-11-16	10
2227	3	753	2018-11-16 11:32:44	2018-11-16	10
2228	1	754	2018-11-16 11:30:07	2018-11-16	10
2229	2	754	2018-11-16 11:30:10	2018-11-16	10
2230	3	754	2018-11-16 11:30:13	2018-11-16	10
2231	1	755	2018-11-16 11:26:10	2018-11-16	10
2232	2	755	2018-11-16 11:26:12	2018-11-16	10
2233	3	755	2018-11-16 11:26:14	2018-11-16	10
2234	1	756	2018-11-16 11:09:23	2018-11-16	10
2235	2	756	2018-11-16 11:09:25	2018-11-16	10
2236	3	756	2018-11-16 11:09:26	2018-11-16	10
2237	1	757	2018-11-16 11:07:59	2018-11-16	10
2238	2	757	2018-11-16 11:08:01	2018-11-16	10
2239	3	757	2018-11-16 11:08:03	2018-11-16	10
2240	1	758	2018-11-16 11:03:47	2018-11-16	10
2241	2	758	2018-11-16 11:03:49	2018-11-16	10
2242	3	758	2018-11-16 11:03:51	2018-11-16	10
2243	1	759	2018-11-16 11:01:21	2018-11-16	10
2244	2	759	2018-11-16 11:01:23	2018-11-16	10
2245	3	759	2018-11-16 11:01:24	2018-11-16	10
2246	1	760	2018-11-16 11:00:36	2018-11-16	10
2247	2	760	2018-11-16 11:00:38	2018-11-16	10
2248	3	760	2018-11-16 11:00:40	2018-11-16	10
2249	1	761	2018-11-16 10:57:52	2018-11-16	9
2250	2	761	2018-11-16 10:57:54	2018-11-16	9
2251	3	761	2018-11-16 10:57:56	2018-11-16	9
2252	1	762	2018-11-16 10:55:34	2018-11-16	9
2253	2	762	2018-11-16 10:55:36	2018-11-16	9
2254	3	762	2018-11-16 10:55:38	2018-11-16	9
2255	1	763	2018-11-16 10:52:06	2018-11-16	9
2256	2	763	2018-11-16 10:52:08	2018-11-16	9
2257	3	763	2018-11-16 10:52:09	2018-11-16	9
2258	1	764	2018-11-16 10:58:28	2018-11-16	9
2259	2	764	2018-11-16 10:58:31	2018-11-16	9
2260	3	764	2018-11-21 16:52:57	2018-11-21	15
2261	1	765	2018-11-16 10:50:16	2018-11-16	9
2262	2	765	2018-11-16 10:50:18	2018-11-16	9
2263	3	765	2018-11-16 10:50:21	2018-11-16	9
2264	1	766	2018-11-16 10:49:10	2018-11-16	9
2265	2	766	2018-11-16 10:49:12	2018-11-16	9
2266	3	766	2018-11-16 10:49:14	2018-11-16	9
2267	1	767	2018-11-16 10:46:34	2018-11-16	9
2268	2	767	2018-11-16 10:46:35	2018-11-16	9
2269	3	767	2018-11-16 10:46:37	2018-11-16	9
2270	1	768	2018-11-16 10:36:15	2018-11-16	9
2271	2	768	2018-11-16 10:36:17	2018-11-16	9
2272	3	768	2018-11-16 10:36:19	2018-11-16	9
2273	1	769	2018-11-16 10:33:38	2018-11-16	9
2274	2	769	2018-11-16 10:33:40	2018-11-16	9
2275	3	769	2018-11-16 10:33:42	2018-11-16	9
2276	1	770	2018-11-16 10:25:42	2018-11-16	9
2277	2	770	2018-11-16 10:25:44	2018-11-16	9
2278	3	770	2018-11-16 10:27:48	2018-11-16	9
2279	1	771	2018-11-16 10:15:33	2018-11-16	9
2280	2	771	2018-11-16 10:15:35	2018-11-16	9
2281	3	771	2018-11-16 10:49:17	2018-11-16	9
2282	1	772	2018-11-16 10:00:30	2018-11-16	9
2283	2	772	2018-11-16 10:00:31	2018-11-16	9
2284	3	772	2018-11-16 10:00:33	2018-11-16	9
2285	1	773	2018-11-16 09:57:37	2018-11-16	8
2286	2	773	2018-11-16 09:57:39	2018-11-16	8
2287	3	773	2018-11-16 09:57:40	2018-11-16	8
2288	1	774	2018-11-16 09:56:38	2018-11-16	8
2289	2	774	2018-11-16 09:56:40	2018-11-16	8
2290	3	774	2018-11-16 10:26:02	2018-11-16	9
2291	1	775	2018-11-16 09:56:16	2018-11-16	8
2292	2	775	2018-11-16 09:56:18	2018-11-16	8
2293	3	775	2018-11-16 10:03:35	2018-11-16	9
2294	1	776	2018-11-16 09:51:52	2018-11-16	8
2295	2	776	2018-11-16 09:51:53	2018-11-16	8
2296	3	776	2018-11-16 09:51:56	2018-11-16	8
2297	1	777	2018-11-16 09:42:44	2018-11-16	8
2298	2	777	2018-11-16 09:42:47	2018-11-16	8
2299	3	777	2018-11-16 09:51:58	2018-11-16	8
2300	1	778	2018-11-16 09:42:03	2018-11-16	8
2301	2	778	2018-11-16 09:42:06	2018-11-16	8
2302	3	778	2018-11-19 08:07:33	2018-11-19	7
2303	1	779	2018-11-16 09:37:54	2018-11-16	8
2304	2	779	2018-11-16 09:37:56	2018-11-16	8
2305	3	779	2018-11-16 09:37:58	2018-11-16	8
2306	1	780	2018-11-16 09:34:22	2018-11-16	8
2307	2	780	2018-11-16 09:34:24	2018-11-16	8
2308	3	780	2018-11-16 09:34:26	2018-11-16	8
2309	1	781	2018-11-16 09:28:14	2018-11-16	8
2310	2	781	2018-11-16 09:28:16	2018-11-16	8
2311	3	781	2018-11-16 09:28:18	2018-11-16	8
2312	1	782	2018-11-16 09:23:33	2018-11-16	8
2313	2	782	2018-11-16 09:23:35	2018-11-16	8
2314	3	782	2018-11-16 09:23:37	2018-11-16	8
2315	1	783	2018-11-16 09:29:44	2018-11-16	8
2316	2	783	2018-11-16 09:29:46	2018-11-16	8
2317	1	784	2018-11-16 09:19:01	2018-11-16	8
2318	2	784	2018-11-16 09:19:03	2018-11-16	8
2319	3	784	2018-11-16 09:19:05	2018-11-16	8
2320	1	785	2018-11-16 09:21:01	2018-11-16	8
2321	2	785	2018-11-16 09:21:04	2018-11-16	8
2322	3	785	2018-11-16 09:21:06	2018-11-16	8
2323	1	786	2018-11-16 09:15:32	2018-11-16	8
2324	2	786	2018-11-16 09:15:33	2018-11-16	8
2325	3	786	2018-11-16 09:15:35	2018-11-16	8
2326	1	787	2018-11-16 09:13:33	2018-11-16	8
2327	2	787	2018-11-16 09:13:35	2018-11-16	8
2328	3	787	2018-11-16 09:13:37	2018-11-16	8
2329	1	788	2018-11-16 09:07:10	2018-11-16	8
2330	2	788	2018-11-16 09:07:12	2018-11-16	8
2331	3	788	2018-11-16 09:07:13	2018-11-16	8
2332	1	789	2018-11-16 09:06:29	2018-11-16	8
2333	2	789	2018-11-16 09:06:31	2018-11-16	8
2334	3	789	2018-11-16 09:06:33	2018-11-16	8
2335	1	790	2018-11-16 09:05:18	2018-11-16	8
2336	2	790	2018-11-16 09:05:20	2018-11-16	8
2337	3	790	2018-11-16 09:05:22	2018-11-16	8
2338	1	791	2018-11-16 09:03:29	2018-11-16	8
2339	2	791	2018-11-16 09:03:30	2018-11-16	8
2340	3	791	2018-11-16 09:03:33	2018-11-16	8
2341	1	792	2018-11-16 09:02:18	2018-11-16	8
2342	2	792	2018-11-16 09:02:20	2018-11-16	8
2343	3	792	2018-11-16 09:02:22	2018-11-16	8
2344	1	793	2018-11-16 08:58:02	2018-11-16	7
2345	2	793	2018-11-16 08:58:04	2018-11-16	7
2346	3	793	2018-11-16 09:30:24	2018-11-16	8
2347	1	794	2018-11-16 08:52:50	2018-11-16	7
2348	2	794	2018-11-16 08:52:52	2018-11-16	7
2349	3	794	2018-11-16 08:52:54	2018-11-16	7
2350	1	795	2018-11-16 08:49:22	2018-11-16	7
2351	2	795	2018-11-16 08:49:24	2018-11-16	7
2352	3	795	2018-11-16 08:49:26	2018-11-16	7
2353	1	796	2018-11-15 17:08:55	2018-11-15	16
2354	2	796	2018-11-15 17:08:58	2018-11-15	16
2355	3	796	2018-11-16 07:38:46	2018-11-16	6
2356	1	797	2018-11-15 16:31:42	2018-11-15	15
2357	2	797	2018-11-15 16:31:44	2018-11-15	15
2358	3	797	2018-11-15 16:31:46	2018-11-15	15
2359	1	798	2018-11-15 16:29:28	2018-11-15	15
2360	2	798	2018-11-15 16:29:31	2018-11-15	15
2361	3	798	2018-11-15 16:29:33	2018-11-15	15
2362	1	799	2018-11-15 16:24:32	2018-11-15	15
2363	2	799	2018-11-15 16:24:34	2018-11-15	15
2364	3	799	2018-11-15 16:24:36	2018-11-15	15
2365	1	800	2018-11-15 16:24:17	2018-11-15	15
2366	2	800	2018-11-15 16:24:19	2018-11-15	15
2367	3	800	2018-11-16 09:43:24	2018-11-16	8
2368	1	801	2018-11-15 16:23:57	2018-11-15	15
2369	2	801	2018-11-15 16:23:59	2018-11-15	15
2370	3	801	2018-11-16 09:42:35	2018-11-16	8
2371	1	802	2018-11-15 16:17:28	2018-11-15	15
2372	2	802	2018-11-15 16:17:30	2018-11-15	15
2373	3	802	2018-11-15 16:17:32	2018-11-15	15
2374	1	803	2018-11-15 16:04:44	2018-11-15	15
2375	2	803	2018-11-15 16:04:46	2018-11-15	15
2376	3	803	2018-11-16 08:40:43	2018-11-16	7
2377	1	804	2018-11-15 15:53:27	2018-11-15	14
2378	2	804	2018-11-15 15:53:29	2018-11-15	14
2379	3	804	2018-11-15 15:53:31	2018-11-15	14
2380	1	805	2018-11-15 15:48:19	2018-11-15	14
2381	2	805	2018-11-15 15:48:21	2018-11-15	14
2382	3	805	2018-11-15 15:48:23	2018-11-15	14
2383	1	806	2018-11-15 15:37:38	2018-11-15	14
2384	2	806	2018-11-15 15:37:40	2018-11-15	14
2385	3	806	2018-11-15 15:37:42	2018-11-15	14
2386	1	807	2018-11-15 15:32:32	2018-11-15	14
2387	2	807	2018-11-15 15:32:34	2018-11-15	14
2388	3	807	2018-11-15 16:01:13	2018-11-15	15
2389	1	808	2018-11-15 15:14:42	2018-11-15	14
2390	2	808	2018-11-15 15:14:44	2018-11-15	14
2391	3	808	2018-11-15 15:14:46	2018-11-15	14
2392	1	809	2018-11-15 15:13:17	2018-11-15	14
2393	2	809	2018-11-15 15:13:19	2018-11-15	14
2394	3	809	2018-11-15 15:13:21	2018-11-15	14
2395	1	810	2018-11-15 15:12:19	2018-11-15	14
2396	2	810	2018-11-15 15:12:21	2018-11-15	14
2397	3	810	2018-11-21 17:02:41	2018-11-21	16
2398	1	811	2018-11-15 15:09:34	2018-11-15	14
2399	2	811	2018-11-15 15:09:36	2018-11-15	14
2400	3	811	2018-11-15 15:09:38	2018-11-15	14
2401	1	812	2018-11-15 15:07:28	2018-11-15	14
2402	2	812	2018-11-15 15:07:30	2018-11-15	14
2403	3	812	2018-11-15 15:07:32	2018-11-15	14
2404	1	813	2018-11-15 14:56:30	2018-11-15	13
2405	2	813	2018-11-15 14:56:31	2018-11-15	13
2406	3	813	2018-11-15 14:56:33	2018-11-15	13
2407	1	814	2018-11-15 14:55:24	2018-11-15	13
2408	2	814	2018-11-15 14:55:27	2018-11-15	13
2409	3	814	2018-11-15 14:55:29	2018-11-15	13
2410	1	815	2018-11-15 14:52:41	2018-11-15	13
2411	2	815	2018-11-15 14:52:43	2018-11-15	13
2412	3	815	2018-11-15 14:59:50	2018-11-15	13
2413	1	816	2018-11-15 14:41:10	2018-11-15	13
2414	2	816	2018-11-15 14:41:12	2018-11-15	13
2415	3	816	2018-11-15 14:41:14	2018-11-15	13
2416	1	817	2018-11-15 14:23:38	2018-11-15	13
2417	2	817	2018-11-15 14:23:40	2018-11-15	13
2418	3	817	2018-11-15 14:23:42	2018-11-15	13
2419	1	818	2018-11-15 14:18:57	2018-11-15	13
2420	2	818	2018-11-15 14:18:58	2018-11-15	13
2421	3	818	2018-11-15 14:19:01	2018-11-15	13
2422	1	819	2018-11-15 14:23:11	2018-11-15	13
2423	2	819	2018-11-15 14:23:14	2018-11-15	13
2424	3	819	2018-12-05 13:56:42	2018-12-05	12
2425	1	820	2018-11-15 14:16:26	2018-11-15	13
2426	2	820	2018-11-15 14:16:29	2018-11-15	13
2427	3	820	2018-11-21 16:55:09	2018-11-21	15
2428	1	821	2018-11-15 14:12:14	2018-11-15	13
2429	2	821	2018-11-15 14:12:17	2018-11-15	13
2430	3	821	2018-11-15 14:12:20	2018-11-15	13
2431	1	822	2018-11-15 14:11:16	2018-11-15	13
2432	2	822	2018-11-15 14:11:18	2018-11-15	13
2433	3	822	2018-11-15 14:11:20	2018-11-15	13
2434	1	823	2018-11-15 11:58:13	2018-11-15	10
2435	2	823	2018-11-15 11:58:15	2018-11-15	10
2436	3	823	2018-11-15 11:58:17	2018-11-15	10
2437	1	824	2018-11-15 11:53:44	2018-11-15	10
2438	2	824	2018-11-15 11:53:45	2018-11-15	10
2439	3	824	2018-11-15 11:53:47	2018-11-15	10
2440	1	825	2018-11-15 11:51:26	2018-11-15	10
2441	2	825	2018-11-15 11:51:28	2018-11-15	10
2442	3	825	2018-11-15 11:51:30	2018-11-15	10
2443	1	826	2018-11-15 11:47:10	2018-11-15	10
2444	2	826	2018-11-15 11:47:11	2018-11-15	10
2445	3	826	2018-11-15 11:47:13	2018-11-15	10
2446	1	827	2018-11-15 11:35:50	2018-11-15	10
2447	2	827	2018-11-15 11:35:52	2018-11-15	10
2448	3	827	2018-11-15 11:35:54	2018-11-15	10
2449	1	828	2018-11-15 11:24:01	2018-11-15	10
2450	2	828	2018-11-15 11:24:03	2018-11-15	10
2451	3	828	2018-11-15 11:24:06	2018-11-15	10
2452	1	829	2018-11-15 11:17:05	2018-11-15	10
2453	2	829	2018-11-15 11:17:07	2018-11-15	10
2454	3	829	2018-11-15 11:17:09	2018-11-15	10
2455	1	830	2018-11-15 11:10:47	2018-11-15	10
2456	2	830	2018-11-15 11:10:49	2018-11-15	10
2457	3	830	2018-11-15 11:10:51	2018-11-15	10
2458	1	831	2018-11-15 11:04:25	2018-11-15	10
2459	2	831	2018-11-15 11:04:27	2018-11-15	10
2460	3	831	2018-11-15 11:04:28	2018-11-15	10
2461	1	832	2018-11-15 11:04:00	2018-11-15	10
2462	2	832	2018-11-15 11:04:02	2018-11-15	10
2463	3	832	2018-11-15 11:04:04	2018-11-15	10
2464	1	833	2018-11-15 11:01:24	2018-11-15	10
2465	2	833	2018-11-15 11:01:26	2018-11-15	10
2466	3	833	2018-11-15 11:01:28	2018-11-15	10
2467	1	834	2018-11-15 10:55:31	2018-11-15	9
2468	2	834	2018-11-15 10:55:33	2018-11-15	9
2469	3	834	2018-11-15 10:55:35	2018-11-15	9
2470	1	835	2018-11-15 10:55:15	2018-11-15	9
2471	2	835	2018-11-15 10:55:17	2018-11-15	9
2472	3	835	2018-11-15 10:55:19	2018-11-15	9
2473	1	836	2018-11-15 10:41:06	2018-11-15	9
2474	2	836	2018-11-15 10:41:07	2018-11-15	9
2475	3	836	2018-11-15 10:41:09	2018-11-15	9
2476	1	837	2018-11-15 10:34:00	2018-11-15	9
2477	2	837	2018-11-15 10:34:03	2018-11-15	9
2478	3	837	2018-11-15 10:54:54	2018-11-15	9
2479	1	838	2018-11-15 10:32:36	2018-11-15	9
2480	2	838	2018-11-15 10:32:41	2018-11-15	9
2481	3	838	2018-11-15 10:52:08	2018-11-15	9
2482	1	839	2018-11-15 10:28:20	2018-11-15	9
2483	2	839	2018-11-15 10:28:23	2018-11-15	9
2484	3	839	2018-11-15 10:28:26	2018-11-15	9
2485	1	840	2018-11-15 10:22:12	2018-11-15	9
2486	2	840	2018-11-15 10:22:13	2018-11-15	9
2487	3	840	2018-11-15 10:22:15	2018-11-15	9
2488	1	841	2018-11-15 10:21:04	2018-11-15	9
2489	2	841	2018-11-15 10:21:06	2018-11-15	9
2490	3	841	2018-11-15 10:21:08	2018-11-15	9
2491	1	842	2018-11-15 10:18:54	2018-11-15	9
2492	2	842	2018-11-15 10:18:56	2018-11-15	9
2493	3	842	2018-11-15 10:18:58	2018-11-15	9
2494	1	843	2018-11-15 10:10:04	2018-11-15	9
2495	2	843	2018-11-15 10:10:06	2018-11-15	9
2496	3	843	2018-11-15 10:10:08	2018-11-15	9
2497	1	844	2018-11-15 10:03:14	2018-11-15	9
2498	2	844	2018-11-15 10:03:16	2018-11-15	9
2499	3	844	2018-11-15 10:03:18	2018-11-15	9
2500	1	845	2018-11-15 09:59:30	2018-11-15	8
2501	2	845	2018-11-15 09:59:31	2018-11-15	8
2502	3	845	2018-11-15 09:59:33	2018-11-15	8
2503	1	846	2018-11-15 10:01:19	2018-11-15	9
2504	2	846	2018-11-15 10:01:20	2018-11-15	9
2505	3	846	2018-11-22 16:38:34	2018-11-22	15
2506	1	847	2018-11-15 09:45:19	2018-11-15	8
2507	2	847	2018-11-15 09:45:21	2018-11-15	8
2508	3	847	2018-11-15 09:45:23	2018-11-15	8
2509	1	848	2018-11-15 09:43:22	2018-11-15	8
2510	2	848	2018-11-15 09:43:26	2018-11-15	8
2511	3	848	2018-11-15 09:43:28	2018-11-15	8
2512	1	849	2018-11-15 09:35:32	2018-11-15	8
2513	2	849	2018-11-15 09:35:34	2018-11-15	8
2514	3	849	2018-11-22 09:09:31	2018-11-22	8
2515	1	850	2018-11-15 09:33:59	2018-11-15	8
2516	2	850	2018-11-15 09:34:00	2018-11-15	8
2517	3	850	2018-11-15 09:34:02	2018-11-15	8
2518	1	851	2018-11-15 09:32:55	2018-11-15	8
2519	2	851	2018-11-15 09:32:57	2018-11-15	8
2520	3	851	2018-11-15 09:32:59	2018-11-15	8
2521	1	852	2018-11-15 09:31:52	2018-11-15	8
2522	2	852	2018-11-15 09:31:54	2018-11-15	8
2523	3	852	2018-11-15 09:39:55	2018-11-15	8
2524	1	853	2018-11-15 09:21:29	2018-11-15	8
2525	2	853	2018-11-15 09:21:32	2018-11-15	8
2526	3	853	2018-11-15 09:21:34	2018-11-15	8
2527	1	854	2018-11-15 09:12:22	2018-11-15	8
2528	2	854	2018-11-15 09:12:24	2018-11-15	8
2529	3	854	2018-11-15 09:12:26	2018-11-15	8
2530	1	855	2018-11-15 09:10:13	2018-11-15	8
2531	2	855	2018-11-15 09:10:16	2018-11-15	8
2532	3	855	2018-11-15 09:10:18	2018-11-15	8
2533	1	856	2018-11-15 09:08:08	2018-11-15	8
2534	2	856	2018-11-15 09:08:10	2018-11-15	8
2535	3	856	2018-11-15 09:08:12	2018-11-15	8
2536	1	857	2018-11-15 08:58:39	2018-11-15	7
2537	2	857	2018-11-15 08:58:41	2018-11-15	7
2538	3	857	2018-11-15 09:14:33	2018-11-15	8
2539	1	858	2018-11-15 08:42:53	2018-11-15	7
2540	2	858	2018-11-15 08:42:54	2018-11-15	7
2541	3	858	2018-11-15 09:10:05	2018-11-15	8
2542	1	859	2018-11-15 08:39:55	2018-11-15	7
2543	2	859	2018-11-15 08:39:56	2018-11-15	7
2544	3	859	2018-11-15 08:39:58	2018-11-15	7
2545	1	860	2018-11-15 08:37:39	2018-11-15	7
2546	2	860	2018-11-15 08:37:41	2018-11-15	7
2547	3	860	2018-11-15 08:37:43	2018-11-15	7
2548	1	861	2018-11-15 08:35:29	2018-11-15	7
2549	2	861	2018-11-15 08:35:31	2018-11-15	7
2550	3	861	2018-11-15 08:35:33	2018-11-15	7
2551	1	862	2018-11-15 07:36:12	2018-11-15	6
2552	2	862	2018-11-15 07:36:14	2018-11-15	6
2553	3	862	2018-11-15 09:02:18	2018-11-15	8
2554	1	863	2018-11-14 17:01:44	2018-11-14	16
2555	2	863	2018-11-14 17:01:46	2018-11-14	16
2556	3	863	2018-11-15 09:40:54	2018-11-15	8
2557	1	864	2018-11-14 16:57:54	2018-11-14	15
2558	2	864	2018-11-14 16:57:56	2018-11-14	15
2559	3	864	2018-11-14 16:57:58	2018-11-14	15
2560	1	865	2018-11-14 16:41:45	2018-11-14	15
2561	2	865	2018-11-14 16:41:47	2018-11-14	15
2562	3	865	2018-11-14 16:41:49	2018-11-14	15
2563	1	866	2018-11-14 16:26:36	2018-11-14	15
2564	2	866	2018-11-14 16:26:38	2018-11-14	15
2565	3	866	2018-11-14 16:26:39	2018-11-14	15
2566	1	867	2018-11-14 16:19:28	2018-11-14	15
2567	2	867	2018-11-14 16:19:30	2018-11-14	15
2568	3	867	2018-11-14 16:19:32	2018-11-14	15
2569	1	868	2018-11-14 16:15:28	2018-11-14	15
2570	2	868	2018-11-14 16:15:30	2018-11-14	15
2571	3	868	2018-11-14 16:15:31	2018-11-14	15
2572	1	869	2018-11-14 16:07:03	2018-11-14	15
2573	2	869	2018-11-14 16:07:06	2018-11-14	15
2574	3	869	2018-11-22 09:11:45	2018-11-22	8
2575	1	870	2018-11-14 16:00:57	2018-11-14	15
2576	2	870	2018-11-14 16:00:59	2018-11-14	15
2577	3	870	2018-11-14 16:02:26	2018-11-14	15
2578	1	871	2018-11-14 15:56:41	2018-11-14	14
2579	2	871	2018-11-14 15:56:43	2018-11-14	14
2580	3	871	2018-11-28 12:30:54	2018-11-28	11
2581	1	872	2018-11-14 15:52:20	2018-11-14	14
2582	2	872	2018-11-14 15:52:22	2018-11-14	14
2583	3	872	2018-11-14 15:52:23	2018-11-14	14
2584	1	873	2018-11-14 15:47:57	2018-11-14	14
2585	2	873	2018-11-14 15:47:59	2018-11-14	14
2586	3	873	2018-11-14 15:57:47	2018-11-14	14
2587	1	874	2018-11-14 15:16:05	2018-11-14	14
2588	2	874	2018-11-14 15:16:07	2018-11-14	14
2589	3	874	2018-11-14 15:16:09	2018-11-14	14
2590	1	875	2018-11-14 15:15:20	2018-11-14	14
2591	2	875	2018-11-14 15:15:22	2018-11-14	14
2592	3	875	2018-11-14 15:15:24	2018-11-14	14
2593	1	876	2018-11-14 15:14:37	2018-11-14	14
2594	2	876	2018-11-14 15:14:39	2018-11-14	14
2595	3	876	2018-11-14 15:14:40	2018-11-14	14
2596	1	877	2018-11-14 15:08:26	2018-11-14	14
2597	2	877	2018-11-14 15:08:28	2018-11-14	14
2598	3	877	2018-11-14 15:08:29	2018-11-14	14
2599	1	878	2018-11-14 14:29:48	2018-11-14	13
2600	2	878	2018-11-14 14:29:52	2018-11-14	13
2601	3	878	2018-11-14 14:29:54	2018-11-14	13
2602	1	879	2018-11-14 14:27:56	2018-11-14	13
2603	2	879	2018-11-14 14:27:58	2018-11-14	13
2604	3	879	2018-11-14 14:28:00	2018-11-14	13
2605	1	880	2018-11-14 14:24:42	2018-11-14	13
2606	2	880	2018-11-14 14:24:44	2018-11-14	13
2607	3	880	2018-11-14 14:24:47	2018-11-14	13
2608	1	881	2018-11-14 14:20:36	2018-11-14	13
2609	2	881	2018-11-14 14:20:38	2018-11-14	13
2610	3	881	2018-11-14 14:50:07	2018-11-14	13
2611	1	882	2018-11-14 14:16:39	2018-11-14	13
2612	2	882	2018-11-14 14:16:43	2018-11-14	13
2613	3	882	2018-11-14 14:16:45	2018-11-14	13
2614	1	883	2018-11-14 14:11:19	2018-11-14	13
2615	2	883	2018-11-14 14:11:21	2018-11-14	13
2616	3	883	2018-11-14 14:11:22	2018-11-14	13
2617	1	884	2018-11-14 11:46:39	2018-11-14	10
2618	2	884	2018-11-14 11:46:41	2018-11-14	10
2619	3	884	2018-11-14 11:46:43	2018-11-14	10
2620	1	885	2018-11-14 11:43:03	2018-11-14	10
2621	2	885	2018-11-14 11:43:05	2018-11-14	10
2622	3	885	2018-11-14 13:27:35	2018-11-14	12
2623	1	886	2018-11-14 11:40:27	2018-11-14	10
2624	2	886	2018-11-14 11:40:29	2018-11-14	10
2625	3	886	2018-11-14 11:42:56	2018-11-14	10
2626	1	887	2018-11-14 11:40:19	2018-11-14	10
2627	2	887	2018-11-14 11:40:21	2018-11-14	10
2628	3	887	2018-11-14 11:40:23	2018-11-14	10
2629	1	888	2018-11-14 11:38:32	2018-11-14	10
2630	2	888	2018-11-14 11:38:34	2018-11-14	10
2631	3	888	2018-11-14 11:44:47	2018-11-14	10
2632	1	889	2018-11-14 11:32:37	2018-11-14	10
2633	2	889	2018-11-14 11:32:39	2018-11-14	10
2634	3	889	2018-11-14 11:32:41	2018-11-14	10
2635	1	890	2018-11-14 11:30:42	2018-11-14	10
2636	2	890	2018-11-14 11:30:43	2018-11-14	10
2637	3	890	2018-11-14 11:30:45	2018-11-14	10
2638	1	891	2018-11-14 11:26:57	2018-11-14	10
2639	2	891	2018-11-14 11:27:00	2018-11-14	10
2640	3	891	2018-11-22 09:28:24	2018-11-22	8
2641	1	892	2018-11-14 11:21:42	2018-11-14	10
2642	2	892	2018-11-14 11:21:44	2018-11-14	10
2643	3	892	2018-11-14 11:21:46	2018-11-14	10
2644	1	893	2018-11-14 11:18:44	2018-11-14	10
2645	2	893	2018-11-14 11:18:45	2018-11-14	10
2646	3	893	2018-11-14 11:18:47	2018-11-14	10
2647	1	894	2018-11-14 11:15:02	2018-11-14	10
2648	2	894	2018-11-14 11:15:04	2018-11-14	10
2649	3	894	2018-11-14 11:15:06	2018-11-14	10
2650	1	895	2018-11-14 11:09:02	2018-11-14	10
2651	2	895	2018-11-14 11:09:04	2018-11-14	10
2652	3	895	2018-11-14 11:09:06	2018-11-14	10
2653	1	896	2018-11-14 11:13:18	2018-11-14	10
2654	2	896	2018-11-14 11:13:20	2018-11-14	10
2655	3	896	2018-12-05 16:56:41	2018-12-05	15
2656	1	897	2018-11-14 11:02:18	2018-11-14	10
2657	2	897	2018-11-14 11:02:20	2018-11-14	10
2658	3	897	2018-11-14 11:02:22	2018-11-14	10
2659	1	898	2018-11-14 10:59:50	2018-11-14	9
2660	2	898	2018-11-14 10:59:51	2018-11-14	9
2661	3	898	2018-11-14 10:59:53	2018-11-14	9
2662	1	899	2018-11-14 10:58:11	2018-11-14	9
2663	2	899	2018-11-14 10:58:12	2018-11-14	9
2664	3	899	2018-11-14 10:58:14	2018-11-14	9
2665	1	900	2018-11-14 10:51:43	2018-11-14	9
2666	2	900	2018-11-14 10:51:46	2018-11-14	9
2667	3	900	2018-11-22 09:32:03	2018-11-22	8
2668	1	901	2018-11-14 10:49:56	2018-11-14	9
2669	2	901	2018-11-14 10:49:57	2018-11-14	9
2670	3	901	2018-11-14 10:49:59	2018-11-14	9
2671	1	902	2018-11-14 10:46:22	2018-11-14	9
2672	2	902	2018-11-14 10:46:24	2018-11-14	9
2673	3	902	2018-11-14 10:46:26	2018-11-14	9
2674	1	903	2018-11-14 10:43:35	2018-11-14	9
2675	2	903	2018-11-14 10:43:37	2018-11-14	9
2676	3	903	2018-11-14 10:43:39	2018-11-14	9
2677	1	904	2018-11-14 10:44:09	2018-11-14	9
2678	2	904	2018-11-14 10:44:11	2018-11-14	9
2679	3	904	2018-11-22 10:05:05	2018-11-22	9
2680	1	905	2018-11-14 10:36:20	2018-11-14	9
2681	2	905	2018-11-14 10:36:22	2018-11-14	9
2682	3	905	2018-11-14 10:36:24	2018-11-14	9
2683	1	906	2018-11-14 10:34:09	2018-11-14	9
2684	2	906	2018-11-14 10:34:12	2018-11-14	9
2685	3	906	2018-11-21 14:41:36	2018-11-21	13
2686	1	907	2018-11-14 10:29:57	2018-11-14	9
2687	2	907	2018-11-14 10:29:59	2018-11-14	9
2688	3	907	2018-11-14 10:33:08	2018-11-14	9
2689	1	908	2018-11-14 10:27:52	2018-11-14	9
2690	2	908	2018-11-14 10:27:54	2018-11-14	9
2691	3	908	2018-11-22 10:07:19	2018-11-22	9
2692	1	909	2018-11-14 10:25:44	2018-11-14	9
2693	2	909	2018-11-14 10:25:45	2018-11-14	9
2694	3	909	2018-11-14 10:25:47	2018-11-14	9
2695	1	910	2018-11-14 10:08:44	2018-11-14	9
2696	2	910	2018-11-14 10:08:46	2018-11-14	9
2697	3	910	2018-11-14 10:08:48	2018-11-14	9
2698	1	911	2018-11-14 10:08:12	2018-11-14	9
2699	2	911	2018-11-14 10:08:14	2018-11-14	9
2700	3	911	2018-11-14 10:08:19	2018-11-14	9
2701	1	912	2018-11-14 10:06:59	2018-11-14	9
2702	2	912	2018-11-14 10:07:02	2018-11-14	9
2703	3	912	2018-11-14 10:56:00	2018-11-14	9
2704	1	913	2018-11-14 10:02:03	2018-11-14	9
2705	2	913	2018-11-14 10:02:05	2018-11-14	9
2706	3	913	2018-11-14 10:02:07	2018-11-14	9
2707	1	914	2018-11-14 10:01:09	2018-11-14	9
2708	2	914	2018-11-14 10:01:10	2018-11-14	9
2709	3	914	2018-11-14 10:01:12	2018-11-14	9
2710	1	915	2018-11-14 10:00:57	2018-11-14	9
2711	2	915	2018-11-14 10:00:59	2018-11-14	9
2712	3	915	2018-11-14 10:01:01	2018-11-14	9
2713	1	916	2018-11-14 09:57:35	2018-11-14	8
2714	2	916	2018-11-14 09:57:38	2018-11-14	8
2715	3	916	2018-11-14 09:57:40	2018-11-14	8
2716	1	917	2018-11-14 09:54:34	2018-11-14	8
2717	2	917	2018-11-14 09:54:36	2018-11-14	8
2718	3	917	2018-11-14 09:54:38	2018-11-14	8
2719	1	918	2018-11-14 09:50:33	2018-11-14	8
2720	2	918	2018-11-14 09:50:35	2018-11-14	8
2721	3	918	2018-11-14 09:50:37	2018-11-14	8
2722	1	919	2018-11-14 09:46:42	2018-11-14	8
2723	2	919	2018-11-14 09:46:44	2018-11-14	8
2724	3	919	2018-11-14 09:46:45	2018-11-14	8
2725	1	920	2018-11-14 09:43:47	2018-11-14	8
2726	2	920	2018-11-14 09:43:50	2018-11-14	8
2727	3	920	2018-11-14 09:49:19	2018-11-14	8
2728	1	921	2018-11-14 09:39:03	2018-11-14	8
2729	2	921	2018-11-14 09:39:05	2018-11-14	8
2730	3	921	2018-11-14 09:39:06	2018-11-14	8
2731	1	922	2018-11-14 09:35:50	2018-11-14	8
2732	2	922	2018-11-14 09:35:52	2018-11-14	8
2733	3	922	2018-11-14 09:35:54	2018-11-14	8
2734	1	923	2018-11-14 09:28:14	2018-11-14	8
2735	2	923	2018-11-14 09:28:16	2018-11-14	8
2736	3	923	2018-11-14 09:28:18	2018-11-14	8
2737	1	924	2018-11-14 09:27:30	2018-11-14	8
2738	2	924	2018-11-14 09:27:32	2018-11-14	8
2739	3	924	2018-11-14 09:27:34	2018-11-14	8
2740	1	925	2018-11-14 09:22:56	2018-11-14	8
2741	2	925	2018-11-14 09:22:57	2018-11-14	8
2742	3	925	2018-11-14 09:23:00	2018-11-14	8
2743	1	926	2018-11-14 09:12:53	2018-11-14	8
2744	2	926	2018-11-14 09:12:55	2018-11-14	8
2745	3	926	2018-11-14 09:12:57	2018-11-14	8
2746	1	927	2018-11-14 09:10:23	2018-11-14	8
2747	2	927	2018-11-14 09:10:25	2018-11-14	8
2748	3	927	2018-11-14 09:10:27	2018-11-14	8
2749	1	928	2018-11-14 09:12:08	2018-11-14	8
2750	2	928	2018-11-14 09:12:10	2018-11-14	8
2751	3	928	2018-11-14 10:59:05	2018-11-14	9
2752	1	929	2018-11-14 09:00:55	2018-11-14	8
2753	2	929	2018-11-14 09:00:57	2018-11-14	8
2754	3	929	2018-11-14 09:00:59	2018-11-14	8
2755	1	930	2018-11-14 08:55:36	2018-11-14	7
2756	2	930	2018-11-14 08:55:38	2018-11-14	7
2757	3	930	2018-11-14 08:55:39	2018-11-14	7
2758	1	931	2018-11-13 21:42:48	2018-11-13	20
2759	2	931	2018-11-13 21:42:51	2018-11-13	20
2760	3	931	2018-11-28 13:15:50	2018-11-28	12
2761	1	932	2018-11-13 16:49:29	2018-11-13	15
2762	2	932	2018-11-13 16:49:31	2018-11-13	15
2763	3	932	2018-11-13 16:49:33	2018-11-13	15
2764	1	933	2018-11-13 16:46:39	2018-11-13	15
2765	2	933	2018-11-13 16:46:41	2018-11-13	15
2766	3	933	2018-11-13 16:46:43	2018-11-13	15
2767	1	934	2018-11-13 16:23:17	2018-11-13	15
2768	2	934	2018-11-13 16:23:18	2018-11-13	15
2769	3	934	2018-11-13 16:23:21	2018-11-13	15
2770	1	935	2018-11-13 16:23:17	2018-11-13	15
2771	2	935	2018-11-13 16:23:18	2018-11-13	15
2772	3	935	2018-11-13 16:23:20	2018-11-13	15
2773	1	936	2018-11-13 16:14:51	2018-11-13	15
2774	2	936	2018-11-13 16:14:53	2018-11-13	15
2775	3	936	2018-11-13 16:14:55	2018-11-13	15
2776	1	937	2018-11-13 16:08:33	2018-11-13	15
2777	2	937	2018-11-13 16:08:35	2018-11-13	15
2778	3	937	2018-11-13 16:39:14	2018-11-13	15
2779	1	938	2018-11-13 15:42:09	2018-11-13	14
2780	2	938	2018-11-13 15:42:11	2018-11-13	14
2781	3	938	2018-11-13 15:42:13	2018-11-13	14
2782	1	939	2018-11-13 15:32:25	2018-11-13	14
2783	2	939	2018-11-13 15:32:27	2018-11-13	14
2784	3	939	2018-11-13 15:32:28	2018-11-13	14
2785	1	940	2018-11-13 15:30:50	2018-11-13	14
2786	2	940	2018-11-13 15:30:52	2018-11-13	14
2787	3	940	2018-11-14 10:56:43	2018-11-14	9
2788	1	941	2018-11-13 15:23:21	2018-11-13	14
2789	2	941	2018-11-13 15:23:23	2018-11-13	14
2790	3	941	2018-11-13 15:23:25	2018-11-13	14
2791	1	942	2018-11-13 15:23:08	2018-11-13	14
2792	2	942	2018-11-13 15:23:10	2018-11-13	14
2793	3	942	2018-11-13 15:23:12	2018-11-13	14
2794	1	943	2018-11-13 15:15:18	2018-11-13	14
2795	2	943	2018-11-13 15:15:20	2018-11-13	14
2796	3	943	2018-11-13 15:15:22	2018-11-13	14
2797	1	944	2018-11-13 15:03:55	2018-11-13	14
2798	2	944	2018-11-13 15:03:57	2018-11-13	14
2799	3	944	2018-11-13 15:03:59	2018-11-13	14
2800	1	945	2018-11-13 15:09:16	2018-11-13	14
2801	2	945	2018-11-13 15:09:19	2018-11-13	14
2802	3	945	2018-11-14 08:25:33	2018-11-14	7
2803	1	946	2018-11-13 14:23:58	2018-11-13	13
2804	2	946	2018-11-13 14:24:00	2018-11-13	13
2805	3	946	2018-11-13 14:37:30	2018-11-13	13
2806	1	947	2018-11-13 14:24:05	2018-11-13	13
2807	2	947	2018-11-13 14:24:08	2018-11-13	13
2808	3	947	2018-11-21 13:38:47	2018-11-21	12
2809	1	948	2018-11-13 14:24:07	2018-11-13	13
2810	2	948	2018-11-13 14:24:10	2018-11-13	13
2811	3	948	2018-11-13 14:24:13	2018-11-13	13
2812	1	949	2018-11-13 14:11:00	2018-11-13	13
2813	2	949	2018-11-13 14:11:02	2018-11-13	13
2814	3	949	2018-11-13 14:11:04	2018-11-13	13
2815	1	950	2018-11-13 14:10:13	2018-11-13	13
2816	2	950	2018-11-13 14:10:15	2018-11-13	13
2817	3	950	2018-11-13 14:10:18	2018-11-13	13
2818	1	951	2018-11-13 12:11:39	2018-11-13	11
2819	2	951	2018-11-13 12:11:42	2018-11-13	11
2820	3	951	2018-11-22 10:15:25	2018-11-22	9
2821	1	952	2018-11-13 12:13:33	2018-11-13	11
2822	2	952	2018-11-13 12:13:37	2018-11-13	11
2823	3	952	2018-11-13 13:28:13	2018-11-13	12
2824	1	953	2018-11-13 12:02:26	2018-11-13	11
2825	2	953	2018-11-13 12:02:28	2018-11-13	11
2826	3	953	2018-11-13 12:02:29	2018-11-13	11
2827	1	954	2018-11-13 11:53:48	2018-11-13	10
2828	2	954	2018-11-13 11:53:50	2018-11-13	10
2829	3	954	2018-11-13 11:53:52	2018-11-13	10
2830	1	955	2018-11-13 11:53:08	2018-11-13	10
2831	2	955	2018-11-13 11:53:10	2018-11-13	10
2832	3	955	2018-11-13 11:53:12	2018-11-13	10
2833	1	956	2018-11-13 11:48:16	2018-11-13	10
2834	2	956	2018-11-13 11:48:17	2018-11-13	10
2835	3	956	2018-11-13 11:48:19	2018-11-13	10
2836	1	957	2018-11-13 11:35:40	2018-11-13	10
2837	2	957	2018-11-13 11:35:42	2018-11-13	10
2838	3	957	2018-11-13 11:35:44	2018-11-13	10
2839	1	958	2018-11-13 11:32:21	2018-11-13	10
2840	2	958	2018-11-13 11:32:23	2018-11-13	10
2841	3	958	2018-11-13 11:32:25	2018-11-13	10
2842	1	959	2018-11-13 11:22:19	2018-11-13	10
2843	2	959	2018-11-13 11:22:20	2018-11-13	10
2844	3	959	2018-11-13 11:22:22	2018-11-13	10
2845	1	960	2018-11-13 11:22:20	2018-11-13	10
2846	2	960	2018-11-13 11:22:22	2018-11-13	10
2847	3	960	2018-11-13 11:22:23	2018-11-13	10
2848	1	961	2018-11-13 11:13:07	2018-11-13	10
2849	2	961	2018-11-13 11:13:10	2018-11-13	10
2850	3	961	2018-11-21 14:12:35	2018-11-21	13
2851	1	962	2018-11-13 11:07:31	2018-11-13	10
2852	2	962	2018-11-13 11:07:34	2018-11-13	10
2853	3	962	2018-11-13 11:07:37	2018-11-13	10
2854	1	963	2018-11-13 11:04:28	2018-11-13	10
2855	2	963	2018-11-13 11:04:31	2018-11-13	10
2856	3	963	2018-11-13 11:04:34	2018-11-13	10
2857	1	964	2018-11-13 10:58:26	2018-11-13	9
2858	2	964	2018-11-13 10:58:28	2018-11-13	9
2859	3	964	2018-11-13 10:58:30	2018-11-13	9
2860	1	965	2018-11-13 10:56:14	2018-11-13	9
2861	2	965	2018-11-13 10:56:16	2018-11-13	9
2862	3	965	2018-11-13 10:56:18	2018-11-13	9
2863	1	966	2018-11-13 10:54:01	2018-11-13	9
2864	2	966	2018-11-13 10:54:03	2018-11-13	9
2865	3	966	2018-11-13 11:56:17	2018-11-13	10
2866	1	967	2018-11-13 10:41:18	2018-11-13	9
2867	2	967	2018-11-13 10:41:20	2018-11-13	9
2868	3	967	2018-11-13 10:41:22	2018-11-13	9
2869	1	968	2018-11-13 10:28:15	2018-11-13	9
2870	2	968	2018-11-13 10:28:17	2018-11-13	9
2871	3	968	2018-11-13 10:28:19	2018-11-13	9
2872	1	969	2018-11-13 10:09:49	2018-11-13	9
2873	2	969	2018-11-13 10:09:51	2018-11-13	9
2874	3	969	2018-11-13 10:09:53	2018-11-13	9
2875	1	970	2018-11-13 10:05:27	2018-11-13	9
2876	2	970	2018-11-13 10:05:29	2018-11-13	9
2877	3	970	2018-11-13 10:05:30	2018-11-13	9
2878	1	971	2018-11-13 10:04:06	2018-11-13	9
2879	2	971	2018-11-13 10:04:08	2018-11-13	9
2880	3	971	2018-11-13 10:04:09	2018-11-13	9
2881	1	972	2018-11-13 10:01:05	2018-11-13	9
2882	2	972	2018-11-13 10:01:07	2018-11-13	9
2883	3	972	2018-11-13 10:01:10	2018-11-13	9
2884	1	973	2018-11-13 09:58:40	2018-11-13	8
2885	2	973	2018-11-13 09:58:41	2018-11-13	8
2886	3	973	2018-11-13 09:58:43	2018-11-13	8
2887	1	974	2018-11-13 10:00:00	2018-11-13	9
2888	2	974	2018-11-13 10:00:02	2018-11-13	9
2889	3	974	2018-11-13 10:28:13	2018-11-13	9
2890	1	975	2018-11-13 09:52:16	2018-11-13	8
2891	2	975	2018-11-13 09:52:17	2018-11-13	8
2892	3	975	2018-11-13 09:52:19	2018-11-13	8
2893	1	976	2018-11-13 09:52:33	2018-11-13	8
2894	2	976	2018-11-13 09:52:34	2018-11-13	8
2895	3	976	2018-11-13 09:52:36	2018-11-13	8
2896	1	977	2018-11-13 09:48:37	2018-11-13	8
2897	2	977	2018-11-13 09:48:39	2018-11-13	8
2898	3	977	2018-11-13 09:48:40	2018-11-13	8
2899	1	978	2018-11-13 09:42:41	2018-11-13	8
2900	2	978	2018-11-13 09:42:43	2018-11-13	8
2901	3	978	2018-11-13 09:42:45	2018-11-13	8
2902	1	979	2018-11-13 09:38:06	2018-11-13	8
2903	2	979	2018-11-13 09:38:08	2018-11-13	8
2904	3	979	2018-11-13 09:38:10	2018-11-13	8
2905	1	980	2018-11-13 09:32:35	2018-11-13	8
2906	2	980	2018-11-13 09:32:37	2018-11-13	8
2907	3	980	2018-11-13 10:13:37	2018-11-13	9
2908	1	981	2018-11-13 09:30:07	2018-11-13	8
2909	2	981	2018-11-13 09:30:09	2018-11-13	8
2910	3	981	2018-11-13 09:30:10	2018-11-13	8
2911	1	982	2018-11-13 09:19:13	2018-11-13	8
2912	2	982	2018-11-13 09:19:14	2018-11-13	8
2913	3	982	2018-11-13 09:19:17	2018-11-13	8
2914	1	983	2018-11-13 09:19:26	2018-11-13	8
2915	2	983	2018-11-13 09:19:28	2018-11-13	8
2916	3	983	2018-11-13 09:21:30	2018-11-13	8
2917	1	984	2018-11-13 09:13:14	2018-11-13	8
2918	2	984	2018-11-13 09:13:16	2018-11-13	8
2919	3	984	2018-11-13 09:13:18	2018-11-13	8
2920	1	985	2018-11-13 09:12:40	2018-11-13	8
2921	2	985	2018-11-13 09:12:41	2018-11-13	8
2922	3	985	2018-11-13 09:12:44	2018-11-13	8
2923	1	986	2018-11-13 09:13:56	2018-11-13	8
2924	2	986	2018-11-13 09:13:58	2018-11-13	8
2925	3	986	2018-11-13 09:15:52	2018-11-13	8
2926	1	987	2018-11-13 09:08:30	2018-11-13	8
2927	2	987	2018-11-13 09:08:31	2018-11-13	8
2928	3	987	2018-11-13 09:08:33	2018-11-13	8
2929	1	988	2018-11-13 09:07:08	2018-11-13	8
2930	2	988	2018-11-13 09:07:10	2018-11-13	8
2931	3	988	2018-11-13 09:07:12	2018-11-13	8
2932	1	989	2018-11-13 09:01:41	2018-11-13	8
2933	2	989	2018-11-13 09:01:43	2018-11-13	8
2934	3	989	2018-11-13 09:01:45	2018-11-13	8
2935	1	990	2018-11-13 08:53:59	2018-11-13	7
2936	2	990	2018-11-13 08:54:00	2018-11-13	7
2937	3	990	2018-11-13 08:54:02	2018-11-13	7
2938	1	991	2018-11-13 08:49:20	2018-11-13	7
2939	2	991	2018-11-13 08:49:22	2018-11-13	7
2940	3	991	2018-11-13 08:49:24	2018-11-13	7
2941	1	992	2018-11-13 08:38:16	2018-11-13	7
2942	2	992	2018-11-13 08:38:17	2018-11-13	7
2943	3	992	2018-11-13 08:38:19	2018-11-13	7
2944	1	993	2018-11-13 08:37:20	2018-11-13	7
2945	2	993	2018-11-13 08:37:22	2018-11-13	7
2946	3	993	2018-11-13 08:37:24	2018-11-13	7
2947	1	994	2018-11-13 08:37:24	2018-11-13	7
2948	2	994	2018-11-13 08:37:26	2018-11-13	7
2949	3	994	2018-11-13 08:37:27	2018-11-13	7
2950	1	995	2018-11-13 08:36:21	2018-11-13	7
2951	2	995	2018-11-13 08:36:23	2018-11-13	7
2952	3	995	2018-11-13 08:36:25	2018-11-13	7
2953	1	996	2018-11-13 08:36:44	2018-11-13	7
2954	2	996	2018-11-13 08:36:46	2018-11-13	7
2955	3	996	2018-11-14 12:12:55	2018-11-14	11
2956	1	997	2018-11-13 08:34:57	2018-11-13	7
2957	2	997	2018-11-13 08:35:00	2018-11-13	7
2958	3	997	2018-11-13 08:35:03	2018-11-13	7
2959	1	998	2018-11-12 18:57:15	2018-11-12	17
2960	2	998	2018-11-12 18:57:16	2018-11-12	17
2961	3	998	2018-11-13 07:56:47	2018-11-13	6
2962	1	999	2018-11-12 17:29:45	2018-11-12	16
2963	2	999	2018-11-12 17:29:47	2018-11-12	16
2964	3	999	2018-11-22 10:17:40	2018-11-22	9
2965	1	1000	2018-11-12 16:51:19	2018-11-12	15
2966	2	1000	2018-11-12 16:51:20	2018-11-12	15
2967	3	1000	2018-11-12 16:51:22	2018-11-12	15
2968	1	1001	2018-11-12 16:38:50	2018-11-12	15
2969	2	1001	2018-11-12 16:38:52	2018-11-12	15
2970	3	1001	2018-11-12 16:38:54	2018-11-12	15
2971	1	1002	2018-11-12 16:38:29	2018-11-12	15
2972	2	1002	2018-11-12 16:38:31	2018-11-12	15
2973	3	1002	2018-11-12 16:38:33	2018-11-12	15
2974	1	1003	2018-11-12 16:30:14	2018-11-12	15
2975	2	1003	2018-11-12 16:30:16	2018-11-12	15
2976	3	1003	2018-11-12 16:30:18	2018-11-12	15
2977	1	1004	2018-11-12 16:18:43	2018-11-12	15
2978	2	1004	2018-11-12 16:18:45	2018-11-12	15
2979	3	1004	2018-11-12 16:18:47	2018-11-12	15
2980	1	1005	2018-11-12 16:05:38	2018-11-12	15
2981	2	1005	2018-11-12 16:05:40	2018-11-12	15
2982	3	1005	2018-11-12 16:05:41	2018-11-12	15
2983	1	1006	2018-11-12 15:32:54	2018-11-12	14
2984	2	1006	2018-11-12 15:32:56	2018-11-12	14
2985	3	1006	2018-11-12 15:32:58	2018-11-12	14
2986	1	1007	2018-11-12 15:30:51	2018-11-12	14
2987	2	1007	2018-11-12 15:30:53	2018-11-12	14
2988	3	1007	2018-11-12 15:30:54	2018-11-12	14
2989	1	1008	2018-11-12 15:29:43	2018-11-12	14
2990	2	1008	2018-11-12 15:29:45	2018-11-12	14
2991	3	1008	2018-11-12 15:29:47	2018-11-12	14
2992	1	1009	2018-11-12 15:16:04	2018-11-12	14
2993	2	1009	2018-11-12 15:16:06	2018-11-12	14
2994	3	1009	2018-11-12 15:16:08	2018-11-12	14
2995	1	1010	2018-11-12 15:08:25	2018-11-12	14
2996	2	1010	2018-11-12 15:08:27	2018-11-12	14
2997	3	1010	2018-11-12 15:08:29	2018-11-12	14
2998	1	1011	2018-11-12 15:01:17	2018-11-12	14
2999	2	1011	2018-11-12 15:01:20	2018-11-12	14
3000	3	1011	2018-11-12 15:01:23	2018-11-12	14
3001	1	1012	2018-11-12 15:00:52	2018-11-12	14
3002	2	1012	2018-11-12 15:00:55	2018-11-12	14
3003	3	1012	2018-11-12 16:46:47	2018-11-12	15
3004	1	1013	2018-11-12 14:46:25	2018-11-12	13
3005	2	1013	2018-11-12 14:46:28	2018-11-12	13
3006	3	1013	2018-11-28 13:35:42	2018-11-28	12
3007	1	1014	2018-11-12 14:42:39	2018-11-12	13
3008	2	1014	2018-11-12 14:42:40	2018-11-12	13
3009	3	1014	2018-11-12 15:46:24	2018-11-12	14
3010	1	1015	2018-11-12 14:51:02	2018-11-12	13
3011	2	1015	2018-11-12 14:51:04	2018-11-12	13
3012	3	1015	2018-11-12 14:51:06	2018-11-12	13
3013	1	1016	2018-11-12 14:36:25	2018-11-12	13
3014	2	1016	2018-11-12 14:36:27	2018-11-12	13
3015	3	1016	2018-11-12 14:36:28	2018-11-12	13
3016	1	1017	2018-11-12 14:33:30	2018-11-12	13
3017	2	1017	2018-11-12 14:33:32	2018-11-12	13
3018	3	1017	2018-11-12 14:33:34	2018-11-12	13
3019	1	1018	2018-11-12 14:29:39	2018-11-12	13
3020	2	1018	2018-11-12 14:29:41	2018-11-12	13
3021	3	1018	2018-11-12 14:29:43	2018-11-12	13
3022	1	1019	2018-11-12 14:25:56	2018-11-12	13
3023	2	1019	2018-11-12 14:25:58	2018-11-12	13
3024	3	1019	2018-11-13 08:49:23	2018-11-13	7
3025	1	1020	2018-11-12 14:21:04	2018-11-12	13
3026	2	1020	2018-11-12 14:21:06	2018-11-12	13
3027	3	1020	2018-11-12 14:21:08	2018-11-12	13
3028	1	1021	2018-11-12 14:11:30	2018-11-12	13
3029	2	1021	2018-11-12 14:11:32	2018-11-12	13
3030	3	1021	2018-11-12 14:11:34	2018-11-12	13
3031	1	1022	2018-11-12 12:05:00	2018-11-12	11
3032	2	1022	2018-11-12 12:05:02	2018-11-12	11
3033	3	1022	2018-11-12 12:05:04	2018-11-12	11
3034	1	1023	2018-11-12 12:05:56	2018-11-12	11
3035	2	1023	2018-11-12 12:05:59	2018-11-12	11
3036	3	1023	2018-11-22 10:31:52	2018-11-22	9
3037	1	1024	2018-11-12 12:03:13	2018-11-12	11
3038	2	1024	2018-11-12 12:03:15	2018-11-12	11
3039	3	1024	2018-11-13 09:08:54	2018-11-13	8
3040	1	1025	2018-11-12 11:59:54	2018-11-12	10
3041	2	1025	2018-11-12 11:59:56	2018-11-12	10
3042	3	1025	2018-11-12 12:03:25	2018-11-12	11
3043	1	1026	2018-11-12 11:56:27	2018-11-12	10
3044	2	1026	2018-11-12 11:56:30	2018-11-12	10
3045	3	1026	2018-11-16 09:34:16	2018-11-16	8
3046	1	1027	2018-11-12 11:51:53	2018-11-12	10
3047	2	1027	2018-11-12 11:51:54	2018-11-12	10
3048	3	1027	2018-11-12 11:51:56	2018-11-12	10
3049	1	1028	2018-11-12 11:44:55	2018-11-12	10
3050	2	1028	2018-11-12 11:44:57	2018-11-12	10
3051	3	1028	2018-11-13 08:50:28	2018-11-13	7
3052	1	1029	2018-11-12 11:40:35	2018-11-12	10
3053	2	1029	2018-11-12 11:40:37	2018-11-12	10
3054	3	1029	2018-11-12 11:40:39	2018-11-12	10
3055	1	1030	2018-11-12 11:39:52	2018-11-12	10
3056	2	1030	2018-11-12 11:39:54	2018-11-12	10
3057	3	1030	2018-11-12 11:39:56	2018-11-12	10
3058	1	1031	2018-11-12 11:40:49	2018-11-12	10
3059	2	1031	2018-11-12 11:40:52	2018-11-12	10
3060	1	1032	2018-11-12 11:38:15	2018-11-12	10
3061	2	1032	2018-11-12 11:38:17	2018-11-12	10
3062	3	1032	2018-11-12 11:38:19	2018-11-12	10
3063	1	1033	2018-11-12 11:34:48	2018-11-12	10
3064	2	1033	2018-11-12 11:34:50	2018-11-12	10
3065	3	1033	2018-11-12 11:34:52	2018-11-12	10
3066	1	1034	2018-11-12 11:35:42	2018-11-12	10
3067	2	1034	2018-11-12 11:35:44	2018-11-12	10
3068	3	1034	2018-11-12 11:50:43	2018-11-12	10
3069	1	1035	2018-11-12 11:29:51	2018-11-12	10
3070	2	1035	2018-11-12 11:29:54	2018-11-12	10
3071	3	1035	2018-11-12 11:29:57	2018-11-12	10
3072	1	1036	2018-11-12 11:29:30	2018-11-12	10
3073	2	1036	2018-11-12 11:29:32	2018-11-12	10
3074	3	1036	2018-11-12 11:29:34	2018-11-12	10
3075	1	1037	2018-11-12 11:23:43	2018-11-12	10
3076	2	1037	2018-11-12 11:23:45	2018-11-12	10
3077	3	1037	2018-11-12 11:23:47	2018-11-12	10
3078	1	1038	2018-11-12 11:22:40	2018-11-12	10
3079	2	1038	2018-11-12 11:22:42	2018-11-12	10
3080	3	1038	2018-11-12 11:24:36	2018-11-12	10
3081	1	1039	2018-11-12 11:20:27	2018-11-12	10
3082	2	1039	2018-11-12 11:20:29	2018-11-12	10
3083	3	1039	2018-11-13 10:17:39	2018-11-13	9
3084	1	1040	2018-11-12 11:03:38	2018-11-12	10
3085	2	1040	2018-11-12 11:03:40	2018-11-12	10
3086	3	1040	2018-11-12 11:03:42	2018-11-12	10
3087	1	1041	2018-11-12 11:00:47	2018-11-12	10
3088	2	1041	2018-11-12 11:00:49	2018-11-12	10
3089	3	1041	2018-11-12 11:00:52	2018-11-12	10
3090	1	1042	2018-11-12 10:53:03	2018-11-12	9
3091	2	1042	2018-11-12 10:53:05	2018-11-12	9
3092	3	1042	2018-11-12 10:53:07	2018-11-12	9
3093	1	1043	2018-11-12 10:46:58	2018-11-12	9
3094	2	1043	2018-11-12 10:47:00	2018-11-12	9
3095	3	1043	2018-11-12 10:47:02	2018-11-12	9
3096	1	1044	2018-11-12 10:51:07	2018-11-12	9
3097	2	1044	2018-11-12 10:51:09	2018-11-12	9
3098	3	1044	2018-11-13 08:53:02	2018-11-13	7
3099	1	1045	2018-11-12 10:46:45	2018-11-12	9
3100	2	1045	2018-11-12 10:46:47	2018-11-12	9
3101	3	1045	2018-11-12 11:06:16	2018-11-12	10
3102	1	1046	2018-11-12 10:39:04	2018-11-12	9
3103	2	1046	2018-11-12 10:39:07	2018-11-12	9
3104	3	1046	2018-11-12 10:39:10	2018-11-12	9
3105	1	1047	2018-11-12 10:42:07	2018-11-12	9
3106	2	1047	2018-11-12 10:42:09	2018-11-12	9
3107	3	1047	2018-11-12 10:51:07	2018-11-12	9
3108	1	1048	2018-11-12 10:37:43	2018-11-12	9
3109	2	1048	2018-11-12 10:37:44	2018-11-12	9
3110	3	1048	2018-11-13 08:28:15	2018-11-13	7
3111	1	1049	2018-11-12 10:33:32	2018-11-12	9
3112	2	1049	2018-11-12 10:33:34	2018-11-12	9
3113	3	1049	2018-11-12 10:33:36	2018-11-12	9
3114	1	1050	2018-11-12 10:32:40	2018-11-12	9
3115	2	1050	2018-11-12 10:32:41	2018-11-12	9
3116	3	1050	2018-11-12 10:32:43	2018-11-12	9
3117	1	1051	2018-11-12 10:23:52	2018-11-12	9
3118	2	1051	2018-11-12 10:23:53	2018-11-12	9
3119	3	1051	2018-11-12 10:23:56	2018-11-12	9
3120	1	1052	2018-11-12 10:21:51	2018-11-12	9
3121	2	1052	2018-11-12 10:21:53	2018-11-12	9
3122	3	1052	2018-11-12 10:21:55	2018-11-12	9
3123	1	1053	2018-11-12 10:17:07	2018-11-12	9
3124	2	1053	2018-11-12 10:17:09	2018-11-12	9
3125	3	1053	2018-11-12 10:17:11	2018-11-12	9
3126	1	1054	2018-11-12 10:15:59	2018-11-12	9
3127	2	1054	2018-11-12 10:16:01	2018-11-12	9
3128	3	1054	2018-11-12 10:16:03	2018-11-12	9
3129	1	1055	2018-11-12 10:11:37	2018-11-12	9
3130	2	1055	2018-11-12 10:11:39	2018-11-12	9
3131	3	1055	2018-11-12 10:11:41	2018-11-12	9
3132	1	1056	2018-11-12 09:58:18	2018-11-12	8
3133	2	1056	2018-11-12 09:58:20	2018-11-12	8
3134	3	1056	2018-11-12 09:58:22	2018-11-12	8
3135	1	1057	2018-11-12 09:56:14	2018-11-12	8
3136	2	1057	2018-11-12 09:56:16	2018-11-12	8
3137	3	1057	2018-11-12 09:56:17	2018-11-12	8
3138	1	1058	2018-11-12 09:48:41	2018-11-12	8
3139	2	1058	2018-11-12 09:48:45	2018-11-12	8
3140	3	1058	2018-11-12 09:48:48	2018-11-12	8
3141	1	1059	2018-11-12 09:42:25	2018-11-12	8
3142	2	1059	2018-11-12 09:42:27	2018-11-12	8
3143	3	1059	2018-11-12 09:42:29	2018-11-12	8
3144	1	1060	2018-11-12 09:41:31	2018-11-12	8
3145	2	1060	2018-11-12 09:41:32	2018-11-12	8
3146	3	1060	2018-11-13 08:53:42	2018-11-13	7
3147	1	1061	2018-11-12 09:36:29	2018-11-12	8
3148	2	1061	2018-11-12 09:36:31	2018-11-12	8
3149	3	1061	2018-11-12 09:36:33	2018-11-12	8
3150	1	1062	2018-11-12 09:35:45	2018-11-12	8
3151	2	1062	2018-11-12 09:35:47	2018-11-12	8
3152	3	1062	2018-11-12 09:35:49	2018-11-12	8
3153	1	1063	2018-11-12 09:05:16	2018-11-12	8
3154	2	1063	2018-11-12 09:05:18	2018-11-12	8
3155	3	1063	2018-11-13 09:24:27	2018-11-13	8
3156	1	1064	2018-11-12 08:49:57	2018-11-12	7
3157	2	1064	2018-11-12 08:49:58	2018-11-12	7
3158	3	1064	2018-11-12 08:50:00	2018-11-12	7
3159	1	1065	2018-11-12 08:45:47	2018-11-12	7
3160	2	1065	2018-11-12 08:45:49	2018-11-12	7
3161	3	1065	2018-11-12 08:45:51	2018-11-12	7
3162	1	1066	2018-11-12 08:44:06	2018-11-12	7
3163	2	1066	2018-11-12 08:44:08	2018-11-12	7
3164	3	1066	2018-11-12 08:44:10	2018-11-12	7
3165	1	1067	2018-11-12 08:39:19	2018-11-12	7
3166	2	1067	2018-11-12 08:39:21	2018-11-12	7
3167	3	1067	2018-11-12 08:39:23	2018-11-12	7
3168	1	1068	2018-11-12 07:39:40	2018-11-12	6
3169	2	1068	2018-11-12 07:39:43	2018-11-12	6
3170	3	1068	2018-11-22 10:34:00	2018-11-22	9
3171	1	1069	2018-11-12 07:33:00	2018-11-12	6
3172	2	1069	2018-11-12 07:33:02	2018-11-12	6
3173	3	1069	2018-11-12 07:35:55	2018-11-12	6
3174	1	1070	2018-11-12 07:30:05	2018-11-12	6
3175	2	1070	2018-11-12 07:30:08	2018-11-12	6
3176	3	1070	2018-11-22 10:39:50	2018-11-22	9
3177	1	1071	2018-11-12 07:28:36	2018-11-12	6
3178	2	1071	2018-11-12 07:28:38	2018-11-12	6
3179	3	1071	2018-11-22 10:42:12	2018-11-22	9
3180	1	1072	2018-11-11 16:54:30	2018-11-11	15
3181	2	1072	2018-11-11 16:54:32	2018-11-11	15
3182	3	1072	2018-11-12 09:51:26	2018-11-12	8
3183	1	1073	2018-11-11 12:55:58	2018-11-11	11
3184	2	1073	2018-11-11 12:56:01	2018-11-11	11
3185	3	1073	2018-11-22 12:43:30	2018-11-22	11
3186	1	1074	2018-11-11 11:52:06	2018-11-11	10
3187	2	1074	2018-11-11 11:52:09	2018-11-11	10
3188	3	1074	2018-11-12 11:54:40	2018-11-12	10
3189	1	1075	2018-11-10 16:07:42	2018-11-10	15
3190	2	1075	2018-11-10 16:07:44	2018-11-10	15
3191	3	1075	2018-11-13 09:00:26	2018-11-13	8
3192	1	1076	2018-11-09 16:47:38	2018-11-09	15
3193	2	1076	2018-11-09 16:47:40	2018-11-09	15
3194	3	1076	2018-11-09 16:47:42	2018-11-09	15
3195	1	1077	2018-11-09 16:33:45	2018-11-09	15
3196	2	1077	2018-11-09 16:33:46	2018-11-09	15
3197	3	1077	2018-11-09 16:33:49	2018-11-09	15
3198	1	1078	2018-11-09 16:31:59	2018-11-09	15
3199	2	1078	2018-11-09 16:32:02	2018-11-09	15
3200	3	1078	2018-11-09 16:32:04	2018-11-09	15
3201	1	1079	2018-11-09 16:28:41	2018-11-09	15
3202	2	1079	2018-11-09 16:28:42	2018-11-09	15
3203	3	1079	2018-11-09 16:29:53	2018-11-09	15
3204	1	1080	2018-11-09 16:24:09	2018-11-09	15
3205	2	1080	2018-11-09 16:24:11	2018-11-09	15
3206	3	1080	2018-11-14 12:11:18	2018-11-14	11
3207	1	1081	2018-11-09 16:13:26	2018-11-09	15
3208	2	1081	2018-11-09 16:13:28	2018-11-09	15
3209	3	1081	2018-11-09 16:13:30	2018-11-09	15
3210	1	1082	2018-11-09 16:25:23	2018-11-09	15
3211	2	1082	2018-11-09 16:25:25	2018-11-09	15
3212	3	1082	2018-11-22 10:44:43	2018-11-22	9
3213	1	1083	2018-11-09 15:41:34	2018-11-09	14
3214	2	1083	2018-11-09 15:41:36	2018-11-09	14
3215	3	1083	2018-11-09 15:41:39	2018-11-09	14
3216	1	1084	2018-11-09 15:29:39	2018-11-09	14
3217	2	1084	2018-11-09 15:29:41	2018-11-09	14
3218	3	1084	2018-11-12 10:22:20	2018-11-12	9
3219	1	1085	2018-11-09 15:26:12	2018-11-09	14
3220	2	1085	2018-11-09 15:26:14	2018-11-09	14
3221	3	1085	2018-11-09 15:26:16	2018-11-09	14
3222	1	1086	2018-11-09 15:16:18	2018-11-09	14
3223	2	1086	2018-11-09 15:16:20	2018-11-09	14
3224	3	1086	2018-11-09 15:16:21	2018-11-09	14
3225	1	1087	2018-11-09 14:46:10	2018-11-09	13
3226	2	1087	2018-11-09 14:46:12	2018-11-09	13
3227	3	1087	2018-11-09 14:46:13	2018-11-09	13
3228	1	1088	2018-11-09 14:40:59	2018-11-09	13
3229	2	1088	2018-11-09 14:41:01	2018-11-09	13
3230	3	1088	2018-11-09 14:41:03	2018-11-09	13
3231	1	1089	2018-11-09 14:36:14	2018-11-09	13
3232	2	1089	2018-11-09 14:36:17	2018-11-09	13
3233	3	1089	2018-11-09 14:36:19	2018-11-09	13
3234	1	1090	2018-11-09 14:37:01	2018-11-09	13
3235	2	1090	2018-11-09 14:37:04	2018-11-09	13
3236	3	1090	2018-11-22 10:45:58	2018-11-22	9
3237	1	1091	2018-11-09 14:35:18	2018-11-09	13
3238	2	1091	2018-11-09 14:35:20	2018-11-09	13
3239	3	1091	2018-11-09 14:35:22	2018-11-09	13
3240	1	1092	2018-11-09 14:34:13	2018-11-09	13
3241	2	1092	2018-11-09 14:34:15	2018-11-09	13
3242	3	1092	2018-11-09 14:34:16	2018-11-09	13
3243	1	1093	2018-11-09 14:31:10	2018-11-09	13
3244	2	1093	2018-11-09 14:31:12	2018-11-09	13
3245	3	1093	2018-11-09 14:31:15	2018-11-09	13
3246	1	1094	2018-11-09 14:20:41	2018-11-09	13
3247	2	1094	2018-11-09 14:20:43	2018-11-09	13
3248	3	1094	2018-11-09 14:20:44	2018-11-09	13
3249	1	1095	2018-11-09 14:18:40	2018-11-09	13
3250	2	1095	2018-11-09 14:18:42	2018-11-09	13
3251	3	1095	2018-11-09 14:18:44	2018-11-09	13
3252	1	1096	2018-11-09 14:16:02	2018-11-09	13
3253	2	1096	2018-11-09 14:16:04	2018-11-09	13
3254	3	1096	2018-11-09 14:16:06	2018-11-09	13
3255	1	1097	2018-11-09 14:15:22	2018-11-09	13
3256	2	1097	2018-11-09 14:15:25	2018-11-09	13
3257	3	1097	2018-11-09 14:15:26	2018-11-09	13
3258	1	1098	2018-11-09 14:16:17	2018-11-09	13
3259	2	1098	2018-11-09 14:16:19	2018-11-09	13
3260	3	1098	2018-11-22 10:52:53	2018-11-22	9
3261	1	1099	2018-11-09 14:09:42	2018-11-09	13
3262	2	1099	2018-11-09 14:09:44	2018-11-09	13
3263	3	1099	2018-11-09 14:09:46	2018-11-09	13
3264	1	1100	2018-11-09 14:08:31	2018-11-09	13
3265	2	1100	2018-11-09 14:08:33	2018-11-09	13
3266	3	1100	2018-11-09 14:08:35	2018-11-09	13
3267	1	1101	2018-11-09 13:27:01	2018-11-09	12
3268	2	1101	2018-11-09 13:27:03	2018-11-09	12
3269	3	1101	2018-11-22 10:53:40	2018-11-22	9
3270	1	1102	2018-11-09 12:29:41	2018-11-09	11
3271	2	1102	2018-11-09 12:29:42	2018-11-09	11
3272	3	1102	2018-11-09 12:29:44	2018-11-09	11
3273	1	1103	2018-11-09 12:15:47	2018-11-09	11
3274	2	1103	2018-11-09 12:15:49	2018-11-09	11
3275	3	1103	2018-11-09 12:15:50	2018-11-09	11
3276	1	1104	2018-11-09 12:11:00	2018-11-09	11
3277	2	1104	2018-11-09 12:11:03	2018-11-09	11
3278	3	1104	2018-11-09 12:11:05	2018-11-09	11
3279	1	1105	2018-11-09 11:41:42	2018-11-09	10
3280	2	1105	2018-11-09 11:41:44	2018-11-09	10
3281	3	1105	2018-11-09 11:41:46	2018-11-09	10
3282	1	1106	2018-11-09 11:38:19	2018-11-09	10
3283	2	1106	2018-11-09 11:38:21	2018-11-09	10
3284	3	1106	2018-11-09 11:38:23	2018-11-09	10
3285	1	1107	2018-11-09 11:35:51	2018-11-09	10
3286	2	1107	2018-11-09 11:35:52	2018-11-09	10
3287	3	1107	2018-11-09 11:40:42	2018-11-09	10
3288	1	1108	2018-11-09 11:23:30	2018-11-09	10
3289	2	1108	2018-11-09 11:23:32	2018-11-09	10
3290	3	1108	2018-11-09 11:23:34	2018-11-09	10
3291	1	1109	2018-11-09 11:20:52	2018-11-09	10
3292	2	1109	2018-11-09 11:20:54	2018-11-09	10
3293	3	1109	2018-11-13 09:33:09	2018-11-13	8
3294	1	1110	2018-11-09 11:16:01	2018-11-09	10
3295	2	1110	2018-11-09 11:16:03	2018-11-09	10
3296	3	1110	2018-11-09 11:16:05	2018-11-09	10
3297	1	1111	2018-11-09 11:17:49	2018-11-09	10
3298	2	1111	2018-11-09 11:17:51	2018-11-09	10
3299	3	1111	2018-11-12 10:12:17	2018-11-12	9
3300	1	1112	2018-11-09 11:16:48	2018-11-09	10
3301	2	1112	2018-11-09 11:16:51	2018-11-09	10
3302	3	1112	2018-11-12 10:08:22	2018-11-12	9
3303	1	1113	2018-11-09 11:07:02	2018-11-09	10
3304	2	1113	2018-11-09 11:07:05	2018-11-09	10
3305	3	1113	2018-11-09 11:07:08	2018-11-09	10
3306	1	1114	2018-11-09 10:58:42	2018-11-09	9
3307	2	1114	2018-11-09 10:58:44	2018-11-09	9
3308	3	1114	2018-11-09 10:58:46	2018-11-09	9
3309	1	1115	2018-11-09 10:52:26	2018-11-09	9
3310	2	1115	2018-11-09 10:52:28	2018-11-09	9
3311	3	1115	2018-11-09 10:52:30	2018-11-09	9
3312	1	1116	2018-11-09 10:48:26	2018-11-09	9
3313	2	1116	2018-11-09 10:48:29	2018-11-09	9
3314	3	1116	2018-11-09 11:00:12	2018-11-09	10
3315	1	1117	2018-11-09 10:40:20	2018-11-09	9
3316	2	1117	2018-11-09 10:40:24	2018-11-09	9
3317	3	1117	2018-11-09 10:40:26	2018-11-09	9
3318	1	1118	2018-11-09 10:34:53	2018-11-09	9
3319	2	1118	2018-11-09 10:34:56	2018-11-09	9
3320	3	1118	2018-11-09 10:34:59	2018-11-09	9
3321	1	1119	2018-11-09 10:34:39	2018-11-09	9
3322	2	1119	2018-11-09 10:34:41	2018-11-09	9
3323	3	1119	2018-11-12 10:39:55	2018-11-12	9
3324	1	1120	2018-11-09 10:25:48	2018-11-09	9
3325	2	1120	2018-11-09 10:25:50	2018-11-09	9
3326	3	1120	2018-11-12 13:20:25	2018-11-12	12
3327	1	1121	2018-11-09 10:11:42	2018-11-09	9
3328	2	1121	2018-11-09 10:11:44	2018-11-09	9
3329	3	1121	2018-11-09 10:24:40	2018-11-09	9
3330	1	1122	2018-11-09 10:14:20	2018-11-09	9
3331	2	1122	2018-11-09 10:14:22	2018-11-09	9
3332	3	1122	2018-11-22 11:04:40	2018-11-22	10
3333	1	1123	2018-11-09 10:05:09	2018-11-09	9
3334	2	1123	2018-11-09 10:05:11	2018-11-09	9
3335	3	1123	2018-11-09 10:05:12	2018-11-09	9
3336	1	1124	2018-11-09 10:03:26	2018-11-09	9
3337	2	1124	2018-11-09 10:03:28	2018-11-09	9
3338	3	1124	2018-11-09 10:03:30	2018-11-09	9
3339	1	1125	2018-11-09 10:02:25	2018-11-09	9
3340	2	1125	2018-11-09 10:02:27	2018-11-09	9
3341	3	1125	2018-11-09 10:02:29	2018-11-09	9
3342	1	1126	2018-11-09 10:00:16	2018-11-09	9
3343	2	1126	2018-11-09 10:00:18	2018-11-09	9
3344	3	1126	2018-11-09 10:00:20	2018-11-09	9
3345	1	1127	2018-11-09 09:58:56	2018-11-09	8
3346	2	1127	2018-11-09 09:58:57	2018-11-09	8
3347	3	1127	2018-11-09 09:58:59	2018-11-09	8
3348	1	1128	2018-11-09 09:54:10	2018-11-09	8
3349	2	1128	2018-11-09 09:54:12	2018-11-09	8
3350	3	1128	2018-11-09 09:54:14	2018-11-09	8
3351	1	1129	2018-11-09 09:57:09	2018-11-09	8
3352	2	1129	2018-11-09 09:57:11	2018-11-09	8
3353	3	1129	2018-11-13 14:52:30	2018-11-13	13
3354	1	1130	2018-11-09 09:51:17	2018-11-09	8
3355	2	1130	2018-11-09 09:51:18	2018-11-09	8
3356	3	1130	2018-11-09 09:51:20	2018-11-09	8
3357	1	1131	2018-11-09 09:46:42	2018-11-09	8
3358	2	1131	2018-11-09 09:46:44	2018-11-09	8
3359	3	1131	2018-11-09 09:46:46	2018-11-09	8
3360	1	1132	2018-11-09 09:35:06	2018-11-09	8
3361	2	1132	2018-11-09 09:35:08	2018-11-09	8
3362	3	1132	2018-11-09 09:35:10	2018-11-09	8
3363	1	1133	2018-11-09 09:32:08	2018-11-09	8
3364	2	1133	2018-11-09 09:32:10	2018-11-09	8
3365	3	1133	2018-11-09 09:32:12	2018-11-09	8
3366	1	1134	2018-11-09 09:18:13	2018-11-09	8
3367	2	1134	2018-11-09 09:18:15	2018-11-09	8
3368	3	1134	2018-11-09 09:18:17	2018-11-09	8
3369	1	1135	2018-11-09 09:13:40	2018-11-09	8
3370	2	1135	2018-11-09 09:13:42	2018-11-09	8
3371	3	1135	2018-11-09 09:13:44	2018-11-09	8
3372	1	1136	2018-11-09 09:08:44	2018-11-09	8
3373	2	1136	2018-11-09 09:08:46	2018-11-09	8
3374	3	1136	2018-11-09 09:08:48	2018-11-09	8
3375	1	1137	2018-11-09 09:07:19	2018-11-09	8
3376	2	1137	2018-11-09 09:07:20	2018-11-09	8
3377	3	1137	2018-11-09 09:07:22	2018-11-09	8
3378	1	1138	2018-11-09 08:58:45	2018-11-09	7
3379	2	1138	2018-11-09 08:58:47	2018-11-09	7
3380	3	1138	2018-11-09 08:58:49	2018-11-09	7
3381	1	1139	2018-11-09 08:51:51	2018-11-09	7
3382	2	1139	2018-11-09 08:51:54	2018-11-09	7
3383	3	1139	2018-11-09 08:51:56	2018-11-09	7
3384	1	1140	2018-11-09 08:49:17	2018-11-09	7
3385	2	1140	2018-11-09 08:49:18	2018-11-09	7
3386	3	1140	2018-11-09 08:49:20	2018-11-09	7
3387	1	1141	2018-11-09 08:49:49	2018-11-09	7
3388	2	1141	2018-11-09 08:49:52	2018-11-09	7
3389	3	1141	2018-11-09 09:53:54	2018-11-09	8
3390	1	1142	2018-11-09 08:41:25	2018-11-09	7
3391	2	1142	2018-11-09 08:41:27	2018-11-09	7
3392	3	1142	2018-11-09 08:41:29	2018-11-09	7
3393	1	1143	2018-11-09 08:42:16	2018-11-09	7
3394	2	1143	2018-11-09 08:42:18	2018-11-09	7
3395	3	1143	2018-11-09 09:14:33	2018-11-09	8
3396	1	1144	2018-11-09 08:37:37	2018-11-09	7
3397	2	1144	2018-11-09 08:37:41	2018-11-09	7
3398	3	1144	2018-11-12 07:59:56	2018-11-12	6
3399	1	1145	2018-11-09 08:34:28	2018-11-09	7
3400	2	1145	2018-11-09 08:34:30	2018-11-09	7
3401	3	1145	2018-11-09 08:34:32	2018-11-09	7
3402	1	1146	2018-11-09 07:38:30	2018-11-09	6
3403	2	1146	2018-11-09 07:38:32	2018-11-09	6
3404	3	1146	2018-11-09 09:35:01	2018-11-09	8
3405	1	1147	2018-11-08 20:12:59	2018-11-08	19
3406	2	1147	2018-11-08 20:13:01	2018-11-08	19
3407	3	1147	2018-11-09 09:03:34	2018-11-09	8
3408	1	1148	2018-11-08 17:03:14	2018-11-08	16
3409	2	1148	2018-11-08 17:03:16	2018-11-08	16
3410	3	1148	2018-11-08 17:03:18	2018-11-08	16
3411	1	1149	2018-11-08 16:57:08	2018-11-08	15
3412	2	1149	2018-11-08 16:57:09	2018-11-08	15
3413	3	1149	2018-11-08 16:57:11	2018-11-08	15
3414	1	1150	2018-11-08 16:53:49	2018-11-08	15
3415	2	1150	2018-11-08 16:53:52	2018-11-08	15
3416	3	1150	2018-11-08 16:53:55	2018-11-08	15
3417	1	1151	2018-11-08 16:46:07	2018-11-08	15
3418	2	1151	2018-11-08 16:46:09	2018-11-08	15
3419	3	1151	2018-11-08 16:46:11	2018-11-08	15
3420	1	1152	2018-11-08 16:45:52	2018-11-08	15
3421	2	1152	2018-11-08 16:45:54	2018-11-08	15
3422	3	1152	2018-11-08 16:45:55	2018-11-08	15
3423	1	1153	2018-11-08 16:31:20	2018-11-08	15
3424	2	1153	2018-11-08 16:31:22	2018-11-08	15
3425	3	1153	2018-11-22 16:40:19	2018-11-22	15
3426	1	1154	2018-11-08 16:22:42	2018-11-08	15
3427	2	1154	2018-11-08 16:22:43	2018-11-08	15
3428	3	1154	2018-11-08 16:22:45	2018-11-08	15
3429	1	1155	2018-11-08 16:19:26	2018-11-08	15
3430	2	1155	2018-11-08 16:19:28	2018-11-08	15
3431	3	1155	2018-11-08 16:19:30	2018-11-08	15
3432	1	1156	2018-11-08 16:16:23	2018-11-08	15
3433	2	1156	2018-11-08 16:16:25	2018-11-08	15
3434	3	1156	2018-11-08 16:20:10	2018-11-08	15
3435	1	1157	2018-11-08 15:58:00	2018-11-08	14
3436	2	1157	2018-11-08 15:58:01	2018-11-08	14
3437	3	1157	2018-11-13 09:43:53	2018-11-13	8
3438	1	1158	2018-11-08 15:18:49	2018-11-08	14
3439	2	1158	2018-11-08 15:18:51	2018-11-08	14
3440	3	1158	2018-11-08 15:18:53	2018-11-08	14
3441	1	1159	2018-11-08 15:10:19	2018-11-08	14
3442	2	1159	2018-11-08 15:10:20	2018-11-08	14
3443	3	1159	2018-11-08 15:20:17	2018-11-08	14
3444	1	1160	2018-11-08 15:02:22	2018-11-08	14
3445	2	1160	2018-11-08 15:02:23	2018-11-08	14
3446	3	1160	2018-11-08 15:13:20	2018-11-08	14
3447	1	1161	2018-11-08 15:00:14	2018-11-08	14
3448	2	1161	2018-11-08 15:00:18	2018-11-08	14
3449	3	1161	2018-11-08 15:00:21	2018-11-08	14
3450	1	1162	2018-11-08 14:48:35	2018-11-08	13
3451	2	1162	2018-11-08 14:48:38	2018-11-08	13
3452	3	1162	2018-11-09 13:17:35	2018-11-09	12
3453	1	1163	2018-11-08 14:35:22	2018-11-08	13
3454	2	1163	2018-11-08 14:35:24	2018-11-08	13
3455	3	1163	2018-11-08 14:35:26	2018-11-08	13
3456	1	1164	2018-11-08 14:31:54	2018-11-08	13
3457	2	1164	2018-11-08 14:31:56	2018-11-08	13
3458	3	1164	2018-11-08 14:31:59	2018-11-08	13
3459	1	1165	2018-11-08 14:26:12	2018-11-08	13
3460	2	1165	2018-11-08 14:26:14	2018-11-08	13
3461	3	1165	2018-11-08 14:26:16	2018-11-08	13
3462	1	1166	2018-11-08 14:15:20	2018-11-08	13
3463	2	1166	2018-11-08 14:15:21	2018-11-08	13
3464	3	1166	2018-11-08 14:15:23	2018-11-08	13
3465	1	1167	2018-11-08 14:09:39	2018-11-08	13
3466	2	1167	2018-11-08 14:09:41	2018-11-08	13
3467	3	1167	2018-11-08 14:09:43	2018-11-08	13
3468	1	1168	2018-11-08 14:12:26	2018-11-08	13
3469	2	1168	2018-11-08 14:12:28	2018-11-08	13
3470	3	1168	2018-11-08 14:12:30	2018-11-08	13
3471	1	1169	2018-11-08 14:09:30	2018-11-08	13
3472	2	1169	2018-11-08 14:09:33	2018-11-08	13
3473	3	1169	2018-11-08 14:37:31	2018-11-08	13
3474	1	1170	2018-11-08 14:05:26	2018-11-08	13
3475	2	1170	2018-11-08 14:05:28	2018-11-08	13
3476	3	1170	2018-11-08 14:35:48	2018-11-08	13
3477	1	1171	2018-11-08 14:02:37	2018-11-08	13
3478	2	1171	2018-11-08 14:02:39	2018-11-08	13
3479	3	1171	2018-11-09 08:47:21	2018-11-09	7
3480	1	1172	2018-11-08 13:47:23	2018-11-08	12
3481	2	1172	2018-11-08 13:47:25	2018-11-08	12
3482	3	1172	2018-11-08 13:47:26	2018-11-08	12
3483	1	1173	2018-11-08 12:11:06	2018-11-08	11
3484	2	1173	2018-11-08 12:11:08	2018-11-08	11
3485	3	1173	2018-11-08 12:11:10	2018-11-08	11
3486	1	1174	2018-11-08 12:10:59	2018-11-08	11
3487	2	1174	2018-11-08 12:11:02	2018-11-08	11
3488	3	1174	2018-11-22 14:14:33	2018-11-22	13
3489	1	1175	2018-11-08 12:00:54	2018-11-08	11
3490	2	1175	2018-11-08 12:00:56	2018-11-08	11
3491	3	1175	2018-11-08 12:15:28	2018-11-08	11
3492	1	1176	2018-11-08 11:55:15	2018-11-08	10
3493	2	1176	2018-11-08 11:55:18	2018-11-08	10
3494	3	1176	2018-11-08 11:55:21	2018-11-08	10
3495	1	1177	2018-11-08 11:48:31	2018-11-08	10
3496	2	1177	2018-11-08 11:48:33	2018-11-08	10
3497	3	1177	2018-11-08 11:48:35	2018-11-08	10
3498	1	1178	2018-11-08 11:44:08	2018-11-08	10
3499	2	1178	2018-11-08 11:44:10	2018-11-08	10
3500	3	1178	2018-11-08 11:44:11	2018-11-08	10
3501	1	1179	2018-11-08 11:38:38	2018-11-08	10
3502	2	1179	2018-11-08 11:38:40	2018-11-08	10
3503	3	1179	2018-11-08 11:38:42	2018-11-08	10
3504	1	1180	2018-11-08 11:31:07	2018-11-08	10
3505	2	1180	2018-11-08 11:31:09	2018-11-08	10
3506	3	1180	2018-11-08 11:53:06	2018-11-08	10
3507	1	1181	2018-11-08 11:20:55	2018-11-08	10
3508	2	1181	2018-11-08 11:20:57	2018-11-08	10
3509	3	1181	2018-11-08 11:20:59	2018-11-08	10
3510	1	1182	2018-11-08 11:16:11	2018-11-08	10
3511	2	1182	2018-11-08 11:16:13	2018-11-08	10
3512	3	1182	2018-11-08 11:16:15	2018-11-08	10
3513	1	1183	2018-11-08 11:15:57	2018-11-08	10
3514	2	1183	2018-11-08 11:15:59	2018-11-08	10
3515	3	1183	2018-11-08 11:16:07	2018-11-08	10
3516	1	1184	2018-11-08 11:03:46	2018-11-08	10
3517	2	1184	2018-11-08 11:03:48	2018-11-08	10
3518	3	1184	2018-11-13 09:38:37	2018-11-13	8
3519	1	1185	2018-11-08 10:59:57	2018-11-08	9
3520	2	1185	2018-11-08 10:59:59	2018-11-08	9
3521	3	1185	2018-11-08 11:00:00	2018-11-08	10
3522	1	1186	2018-11-08 10:58:55	2018-11-08	9
3523	2	1186	2018-11-08 10:58:57	2018-11-08	9
3524	3	1186	2018-11-08 11:02:05	2018-11-08	10
3525	1	1187	2018-11-08 10:57:14	2018-11-08	9
3526	2	1187	2018-11-08 10:57:16	2018-11-08	9
3527	3	1187	2018-11-08 10:57:18	2018-11-08	9
3528	1	1188	2018-11-08 10:57:44	2018-11-08	9
3529	2	1188	2018-11-08 10:57:46	2018-11-08	9
3530	3	1188	2018-11-08 10:57:48	2018-11-08	9
3531	1	1189	2018-11-08 10:55:51	2018-11-08	9
3532	2	1189	2018-11-08 10:55:53	2018-11-08	9
3533	3	1189	2018-11-08 10:55:56	2018-11-08	9
3534	1	1190	2018-11-08 10:53:53	2018-11-08	9
3535	2	1190	2018-11-08 10:53:57	2018-11-08	9
3536	3	1190	2018-11-08 10:53:59	2018-11-08	9
3537	1	1191	2018-11-08 10:55:42	2018-11-08	9
3538	2	1191	2018-11-08 10:55:44	2018-11-08	9
3539	3	1191	2018-11-08 10:55:45	2018-11-08	9
3540	1	1192	2018-11-08 10:51:33	2018-11-08	9
3541	2	1192	2018-11-08 10:51:34	2018-11-08	9
3542	3	1192	2018-11-08 11:44:37	2018-11-08	10
3543	1	1193	2018-11-08 10:43:38	2018-11-08	9
3544	2	1193	2018-11-08 10:43:40	2018-11-08	9
3545	3	1193	2018-11-08 10:43:41	2018-11-08	9
3546	1	1194	2018-11-08 10:42:02	2018-11-08	9
3547	2	1194	2018-11-08 10:42:03	2018-11-08	9
3548	3	1194	2018-11-08 10:42:06	2018-11-08	9
3549	1	1195	2018-11-08 10:39:43	2018-11-08	9
3550	2	1195	2018-11-08 10:39:45	2018-11-08	9
3551	3	1195	2018-11-08 10:39:47	2018-11-08	9
3552	1	1196	2018-11-08 10:31:09	2018-11-08	9
3553	2	1196	2018-11-08 10:31:11	2018-11-08	9
3554	3	1196	2018-11-08 10:31:13	2018-11-08	9
3555	1	1197	2018-11-08 10:27:09	2018-11-08	9
3556	2	1197	2018-11-08 10:27:11	2018-11-08	9
3557	3	1197	2018-11-08 10:27:13	2018-11-08	9
3558	1	1198	2018-11-08 10:25:19	2018-11-08	9
3559	2	1198	2018-11-08 10:25:21	2018-11-08	9
3560	3	1198	2018-11-08 10:25:23	2018-11-08	9
3561	1	1199	2018-11-08 10:24:06	2018-11-08	9
3562	2	1199	2018-11-08 10:24:09	2018-11-08	9
3563	3	1199	2018-11-08 10:24:12	2018-11-08	9
3564	1	1200	2018-11-08 10:20:17	2018-11-08	9
3565	2	1200	2018-11-08 10:20:21	2018-11-08	9
3566	3	1200	2018-11-08 10:20:24	2018-11-08	9
3567	1	1201	2018-11-08 10:13:47	2018-11-08	9
3568	2	1201	2018-11-08 10:13:49	2018-11-08	9
3569	3	1201	2018-11-08 10:13:50	2018-11-08	9
3570	1	1202	2018-11-08 10:06:05	2018-11-08	9
3571	2	1202	2018-11-08 10:06:08	2018-11-08	9
3572	3	1202	2018-11-08 10:06:12	2018-11-08	9
3573	1	1203	2018-11-08 10:02:23	2018-11-08	9
3574	2	1203	2018-11-08 10:02:26	2018-11-08	9
3575	3	1203	2018-11-08 10:02:28	2018-11-08	9
3576	1	1204	2018-11-08 09:58:42	2018-11-08	8
3577	2	1204	2018-11-08 09:58:44	2018-11-08	8
3578	3	1204	2018-11-08 09:58:46	2018-11-08	8
3579	1	1205	2018-11-08 09:55:50	2018-11-08	8
3580	2	1205	2018-11-08 09:55:52	2018-11-08	8
3581	3	1205	2018-11-08 09:55:53	2018-11-08	8
3582	1	1206	2018-11-08 09:55:15	2018-11-08	8
3583	2	1206	2018-11-08 09:55:16	2018-11-08	8
3584	3	1206	2018-11-08 09:55:18	2018-11-08	8
3585	1	1207	2018-11-08 09:37:04	2018-11-08	8
3586	2	1207	2018-11-08 09:37:06	2018-11-08	8
3587	3	1207	2018-11-08 10:06:28	2018-11-08	9
3588	1	1208	2018-11-08 09:36:06	2018-11-08	8
3589	2	1208	2018-11-08 09:36:08	2018-11-08	8
3590	3	1208	2018-11-08 11:39:14	2018-11-08	10
3591	1	1209	2018-11-08 09:31:53	2018-11-08	8
3592	2	1209	2018-11-08 09:31:56	2018-11-08	8
3593	3	1209	2018-11-08 09:46:34	2018-11-08	8
3594	1	1210	2018-11-08 09:28:35	2018-11-08	8
3595	2	1210	2018-11-08 09:28:37	2018-11-08	8
3596	3	1210	2018-11-08 09:28:38	2018-11-08	8
3597	1	1211	2018-11-08 09:30:39	2018-11-08	8
3598	2	1211	2018-11-08 09:30:42	2018-11-08	8
3599	3	1211	2018-11-08 09:30:45	2018-11-08	8
3600	1	1212	2018-11-08 09:26:51	2018-11-08	8
3601	2	1212	2018-11-08 09:26:53	2018-11-08	8
3602	3	1212	2018-11-08 09:26:54	2018-11-08	8
3603	1	1213	2018-11-08 09:25:44	2018-11-08	8
3604	2	1213	2018-11-08 09:25:48	2018-11-08	8
3605	3	1213	2018-11-08 09:25:50	2018-11-08	8
3606	1	1214	2018-11-08 09:24:12	2018-11-08	8
3607	2	1214	2018-11-08 09:24:14	2018-11-08	8
3608	3	1214	2018-11-08 09:24:16	2018-11-08	8
3609	1	1215	2018-11-08 09:24:59	2018-11-08	8
3610	2	1215	2018-11-08 09:25:01	2018-11-08	8
3611	1	1216	2018-11-08 09:22:32	2018-11-08	8
3612	2	1216	2018-11-08 09:22:34	2018-11-08	8
3613	3	1216	2018-11-08 09:22:36	2018-11-08	8
3614	1	1217	2018-11-08 09:22:40	2018-11-08	8
3615	2	1217	2018-11-08 09:22:43	2018-11-08	8
3616	3	1217	2018-11-08 09:22:46	2018-11-08	8
3617	1	1218	2018-11-08 09:21:48	2018-11-08	8
3618	2	1218	2018-11-08 09:21:50	2018-11-08	8
3619	3	1218	2018-11-08 09:21:51	2018-11-08	8
3620	1	1219	2018-11-08 09:21:21	2018-11-08	8
3621	2	1219	2018-11-08 09:21:24	2018-11-08	8
3622	3	1219	2018-11-08 09:21:26	2018-11-08	8
3623	1	1220	2018-11-08 09:13:44	2018-11-08	8
3624	2	1220	2018-11-08 09:13:46	2018-11-08	8
3625	3	1220	2018-11-08 09:18:53	2018-11-08	8
3626	1	1221	2018-11-08 09:02:08	2018-11-08	8
3627	2	1221	2018-11-08 09:02:10	2018-11-08	8
3628	3	1221	2018-11-08 09:02:12	2018-11-08	8
3629	1	1222	2018-11-08 08:56:37	2018-11-08	7
3630	2	1222	2018-11-08 08:56:39	2018-11-08	7
3631	3	1222	2018-11-08 08:56:41	2018-11-08	7
3632	1	1223	2018-11-08 08:56:24	2018-11-08	7
3633	2	1223	2018-11-08 08:56:26	2018-11-08	7
3634	3	1223	2018-11-08 08:56:28	2018-11-08	7
3635	1	1224	2018-11-08 08:55:43	2018-11-08	7
3636	2	1224	2018-11-08 08:55:47	2018-11-08	7
3637	3	1224	2018-11-08 08:55:49	2018-11-08	7
3638	1	1225	2018-11-08 08:54:57	2018-11-08	7
3639	2	1225	2018-11-08 08:54:58	2018-11-08	7
3640	3	1225	2018-11-08 08:55:00	2018-11-08	7
3641	1	1226	2018-11-08 08:41:24	2018-11-08	7
3642	2	1226	2018-11-08 08:41:26	2018-11-08	7
3643	3	1226	2018-11-08 08:41:27	2018-11-08	7
3644	1	1227	2018-11-08 08:41:31	2018-11-08	7
3645	2	1227	2018-11-08 08:41:35	2018-11-08	7
3646	3	1227	2018-11-08 09:22:04	2018-11-08	8
3647	1	1228	2018-11-08 08:35:23	2018-11-08	7
3648	2	1228	2018-11-08 08:35:25	2018-11-08	7
3649	3	1228	2018-11-08 08:35:27	2018-11-08	7
3650	1	1229	2018-11-08 08:02:08	2018-11-08	7
3651	2	1229	2018-11-08 08:02:11	2018-11-08	7
3652	3	1229	2018-11-08 11:57:49	2018-11-08	10
3653	1	1230	2018-11-07 18:15:20	2018-11-07	17
3654	2	1230	2018-11-07 18:15:22	2018-11-07	17
3655	3	1230	2018-11-08 11:37:59	2018-11-08	10
3656	1	1231	2018-11-07 17:05:03	2018-11-07	16
3657	2	1231	2018-11-07 17:05:04	2018-11-07	16
3658	3	1231	2018-11-08 09:44:40	2018-11-08	8
3659	1	1232	2018-11-07 16:51:20	2018-11-07	15
3660	2	1232	2018-11-07 16:51:22	2018-11-07	15
3661	3	1232	2018-11-07 16:51:23	2018-11-07	15
3662	1	1233	2018-11-07 16:45:57	2018-11-07	15
3663	2	1233	2018-11-07 16:45:59	2018-11-07	15
3664	3	1233	2018-11-08 10:46:36	2018-11-08	9
3665	1	1234	2018-11-07 16:36:34	2018-11-07	15
3666	2	1234	2018-11-07 16:36:35	2018-11-07	15
3667	3	1234	2018-11-07 16:36:38	2018-11-07	15
3668	1	1235	2018-11-07 16:21:35	2018-11-07	15
3669	2	1235	2018-11-07 16:21:37	2018-11-07	15
3670	3	1235	2018-11-07 16:21:38	2018-11-07	15
3671	1	1236	2018-11-07 16:19:20	2018-11-07	15
3672	2	1236	2018-11-07 16:19:22	2018-11-07	15
3673	3	1236	2018-11-07 16:19:24	2018-11-07	15
3674	1	1237	2018-11-07 16:04:31	2018-11-07	15
3675	2	1237	2018-11-07 16:04:33	2018-11-07	15
3676	3	1237	2018-11-07 16:04:35	2018-11-07	15
3677	1	1238	2018-11-07 15:56:13	2018-11-07	14
3678	2	1238	2018-11-07 15:56:15	2018-11-07	14
3679	3	1238	2018-11-07 15:56:17	2018-11-07	14
3680	1	1239	2018-11-07 15:53:24	2018-11-07	14
3681	2	1239	2018-11-07 15:53:26	2018-11-07	14
3682	3	1239	2018-11-07 15:53:27	2018-11-07	14
3683	1	1240	2018-11-07 15:36:16	2018-11-07	14
3684	2	1240	2018-11-07 15:36:17	2018-11-07	14
3685	3	1240	2018-11-07 15:36:19	2018-11-07	14
3686	1	1241	2018-11-07 15:36:46	2018-11-07	14
3687	2	1241	2018-11-07 15:36:48	2018-11-07	14
3688	3	1241	2018-11-07 15:36:50	2018-11-07	14
3689	1	1242	2018-11-07 15:35:10	2018-11-07	14
3690	2	1242	2018-11-07 15:35:12	2018-11-07	14
3691	3	1242	2018-11-07 15:35:14	2018-11-07	14
3692	1	1243	2018-11-07 15:35:14	2018-11-07	14
3693	2	1243	2018-11-07 15:35:16	2018-11-07	14
3694	1	1244	2018-11-07 15:29:54	2018-11-07	14
3695	2	1244	2018-11-07 15:29:56	2018-11-07	14
3696	3	1244	2018-11-07 15:29:58	2018-11-07	14
3697	1	1245	2018-11-07 15:27:17	2018-11-07	14
3698	2	1245	2018-11-07 15:27:19	2018-11-07	14
3699	3	1245	2018-11-07 15:27:21	2018-11-07	14
3700	1	1246	2018-11-07 15:18:48	2018-11-07	14
3701	2	1246	2018-11-07 15:18:50	2018-11-07	14
3702	3	1246	2018-11-07 15:18:52	2018-11-07	14
3703	1	1247	2018-11-07 15:15:48	2018-11-07	14
3704	2	1247	2018-11-07 15:15:50	2018-11-07	14
3705	3	1247	2018-11-07 15:15:52	2018-11-07	14
3706	1	1248	2018-11-07 15:11:05	2018-11-07	14
3707	2	1248	2018-11-07 15:11:06	2018-11-07	14
3708	3	1248	2018-11-07 15:11:08	2018-11-07	14
3709	1	1249	2018-11-07 15:06:53	2018-11-07	14
3710	2	1249	2018-11-07 15:06:55	2018-11-07	14
3711	3	1249	2018-11-07 15:06:56	2018-11-07	14
3712	1	1250	2018-11-07 14:52:35	2018-11-07	13
3713	2	1250	2018-11-07 14:52:37	2018-11-07	13
3714	3	1250	2018-11-07 14:52:39	2018-11-07	13
3715	1	1251	2018-11-07 14:53:45	2018-11-07	13
3716	2	1251	2018-11-07 14:53:48	2018-11-07	13
3717	3	1251	2018-11-07 15:15:21	2018-11-07	14
3718	1	1252	2018-11-07 14:48:51	2018-11-07	13
3719	2	1252	2018-11-07 14:48:53	2018-11-07	13
3720	3	1252	2018-11-07 15:11:41	2018-11-07	14
3721	1	1253	2018-11-07 14:47:13	2018-11-07	13
3722	2	1253	2018-11-07 14:47:15	2018-11-07	13
3723	3	1253	2018-11-07 14:47:17	2018-11-07	13
3724	1	1254	2018-11-07 14:45:01	2018-11-07	13
3725	2	1254	2018-11-07 14:45:03	2018-11-07	13
3726	3	1254	2018-11-07 14:45:05	2018-11-07	13
3727	1	1255	2018-11-07 14:51:36	2018-11-07	13
3728	2	1255	2018-11-07 14:51:37	2018-11-07	13
3729	3	1255	2018-11-07 14:51:39	2018-11-07	13
3730	1	1256	2018-11-07 14:38:53	2018-11-07	13
3731	2	1256	2018-11-07 14:38:55	2018-11-07	13
3732	3	1256	2018-11-07 14:38:57	2018-11-07	13
3733	1	1257	2018-11-07 14:37:31	2018-11-07	13
3734	2	1257	2018-11-07 14:37:32	2018-11-07	13
3735	3	1257	2018-11-07 14:37:35	2018-11-07	13
3736	1	1258	2018-11-07 14:26:45	2018-11-07	13
3737	2	1258	2018-11-07 14:26:47	2018-11-07	13
3738	3	1258	2018-11-07 14:26:49	2018-11-07	13
3739	1	1259	2018-11-07 14:25:34	2018-11-07	13
3740	2	1259	2018-11-07 14:25:36	2018-11-07	13
3741	3	1259	2018-11-07 14:25:38	2018-11-07	13
3742	1	1260	2018-11-07 14:24:20	2018-11-07	13
3743	2	1260	2018-11-07 14:24:23	2018-11-07	13
3744	3	1260	2018-11-07 14:24:26	2018-11-07	13
3745	1	1261	2018-11-07 14:20:03	2018-11-07	13
3746	2	1261	2018-11-07 14:20:04	2018-11-07	13
3747	3	1261	2018-11-07 14:20:06	2018-11-07	13
3748	1	1262	2018-11-07 14:20:16	2018-11-07	13
3749	2	1262	2018-11-07 14:20:19	2018-11-07	13
3750	3	1262	2018-11-22 11:11:37	2018-11-22	10
3751	1	1263	2018-11-07 14:20:21	2018-11-07	13
3752	2	1263	2018-11-07 14:20:24	2018-11-07	13
3753	3	1263	2018-11-07 14:20:27	2018-11-07	13
3754	1	1264	2018-11-07 14:15:02	2018-11-07	13
3755	2	1264	2018-11-07 14:15:05	2018-11-07	13
3756	3	1264	2018-11-07 14:15:08	2018-11-07	13
3757	1	1265	2018-11-07 13:30:51	2018-11-07	12
3758	2	1265	2018-11-07 13:30:54	2018-11-07	12
3759	3	1265	2018-11-08 16:24:16	2018-11-08	15
3760	1	1266	2018-11-07 12:48:18	2018-11-07	11
3761	2	1266	2018-11-07 12:48:20	2018-11-07	11
3762	3	1266	2018-11-07 12:48:22	2018-11-07	11
3763	1	1267	2018-11-07 12:47:34	2018-11-07	11
3764	2	1267	2018-11-07 12:47:36	2018-11-07	11
3765	3	1267	2018-11-07 12:47:38	2018-11-07	11
3766	1	1268	2018-11-07 12:47:02	2018-11-07	11
3767	2	1268	2018-11-07 12:47:04	2018-11-07	11
3768	3	1268	2018-11-07 12:47:06	2018-11-07	11
3769	1	1269	2018-11-07 12:46:26	2018-11-07	11
3770	2	1269	2018-11-07 12:46:28	2018-11-07	11
3771	3	1269	2018-11-07 12:46:30	2018-11-07	11
3772	1	1270	2018-11-07 12:39:35	2018-11-07	11
3773	2	1270	2018-11-07 12:39:37	2018-11-07	11
3774	3	1270	2018-11-08 10:28:34	2018-11-08	9
3775	1	1271	2018-11-07 12:27:29	2018-11-07	11
3776	2	1271	2018-11-07 12:27:31	2018-11-07	11
3777	3	1271	2018-11-07 12:27:33	2018-11-07	11
3778	1	1272	2018-11-07 12:19:38	2018-11-07	11
3779	2	1272	2018-11-07 12:19:39	2018-11-07	11
3780	3	1272	2018-11-07 12:19:41	2018-11-07	11
3781	1	1273	2018-11-07 12:04:03	2018-11-07	11
3782	2	1273	2018-11-07 12:04:07	2018-11-07	11
3783	3	1273	2018-11-08 10:15:19	2018-11-08	9
3784	1	1274	2018-11-07 11:57:20	2018-11-07	10
3785	2	1274	2018-11-07 11:57:22	2018-11-07	10
3786	3	1274	2018-11-07 11:57:24	2018-11-07	10
3787	1	1275	2018-11-07 11:37:39	2018-11-07	10
3788	2	1275	2018-11-07 11:37:41	2018-11-07	10
3789	3	1275	2018-11-07 11:37:44	2018-11-07	10
3790	1	1276	2018-11-07 11:37:53	2018-11-07	10
3791	2	1276	2018-11-07 11:37:56	2018-11-07	10
3792	3	1276	2018-11-07 11:37:57	2018-11-07	10
3793	1	1277	2018-11-07 11:31:08	2018-11-07	10
3794	2	1277	2018-11-07 11:31:11	2018-11-07	10
3795	3	1277	2018-11-07 11:31:14	2018-11-07	10
3796	1	1278	2018-11-07 11:21:43	2018-11-07	10
3797	2	1278	2018-11-07 11:21:45	2018-11-07	10
3798	3	1278	2018-11-07 11:21:46	2018-11-07	10
3799	1	1279	2018-11-07 10:44:13	2018-11-07	9
3800	2	1279	2018-11-07 10:44:14	2018-11-07	9
3801	3	1279	2018-11-07 10:44:16	2018-11-07	9
3802	1	1280	2018-11-07 10:29:28	2018-11-07	9
3803	2	1280	2018-11-07 10:29:30	2018-11-07	9
3804	3	1280	2018-11-07 10:29:32	2018-11-07	9
3805	1	1281	2018-11-07 10:30:41	2018-11-07	9
3806	2	1281	2018-11-07 10:30:43	2018-11-07	9
3807	1	1282	2018-11-07 10:22:51	2018-11-07	9
3808	2	1282	2018-11-07 10:22:52	2018-11-07	9
3809	3	1282	2018-11-07 10:22:55	2018-11-07	9
3810	1	1283	2018-11-07 10:23:44	2018-11-07	9
3811	2	1283	2018-11-07 10:23:47	2018-11-07	9
3812	3	1283	2018-11-07 10:23:50	2018-11-07	9
3813	1	1284	2018-11-07 10:18:15	2018-11-07	9
3814	2	1284	2018-11-07 10:18:17	2018-11-07	9
3815	3	1284	2018-12-05 16:01:29	2018-12-05	15
3816	1	1285	2018-11-07 10:10:47	2018-11-07	9
3817	2	1285	2018-11-07 10:10:49	2018-11-07	9
3818	3	1285	2018-11-07 10:10:51	2018-11-07	9
3819	1	1286	2018-11-07 10:08:50	2018-11-07	9
3820	2	1286	2018-11-07 10:08:52	2018-11-07	9
3821	3	1286	2018-11-12 09:18:49	2018-11-12	8
3822	1	1287	2018-11-07 10:07:21	2018-11-07	9
3823	2	1287	2018-11-07 10:07:25	2018-11-07	9
3824	3	1287	2018-11-07 11:43:33	2018-11-07	10
3825	1	1288	2018-11-07 10:06:03	2018-11-07	9
3826	2	1288	2018-11-07 10:06:07	2018-11-07	9
3827	3	1288	2018-11-14 11:08:04	2018-11-14	10
3828	1	1289	2018-11-07 10:01:39	2018-11-07	9
3829	2	1289	2018-11-07 10:01:41	2018-11-07	9
3830	3	1289	2018-11-07 10:09:00	2018-11-07	9
3831	1	1290	2018-11-07 09:52:37	2018-11-07	8
3832	2	1290	2018-11-07 09:52:39	2018-11-07	8
3833	3	1290	2018-11-07 09:52:41	2018-11-07	8
3834	1	1291	2018-11-07 09:54:21	2018-11-07	8
3835	2	1291	2018-11-07 09:54:23	2018-11-07	8
3836	3	1291	2018-11-07 13:30:11	2018-11-07	12
3837	1	1292	2018-11-07 09:44:52	2018-11-07	8
3838	2	1292	2018-11-07 09:44:54	2018-11-07	8
3839	3	1292	2018-11-07 09:44:55	2018-11-07	8
3840	1	1293	2018-11-07 09:44:27	2018-11-07	8
3841	2	1293	2018-11-07 09:44:29	2018-11-07	8
3842	3	1293	2018-11-07 12:06:01	2018-11-07	11
3843	1	1294	2018-11-07 09:41:56	2018-11-07	8
3844	2	1294	2018-11-07 09:41:57	2018-11-07	8
3845	3	1294	2018-11-07 09:41:59	2018-11-07	8
3846	1	1295	2018-11-07 09:39:53	2018-11-07	8
3847	2	1295	2018-11-07 09:39:54	2018-11-07	8
3848	3	1295	2018-11-07 09:40:10	2018-11-07	8
3849	1	1296	2018-11-07 09:39:38	2018-11-07	8
3850	2	1296	2018-11-07 09:39:39	2018-11-07	8
3851	3	1296	2018-11-07 09:39:41	2018-11-07	8
3852	1	1297	2018-11-07 09:38:17	2018-11-07	8
3853	2	1297	2018-11-07 09:38:19	2018-11-07	8
3854	3	1297	2018-11-07 09:38:20	2018-11-07	8
3855	1	1298	2018-11-07 09:40:10	2018-11-07	8
3856	2	1298	2018-11-07 09:40:12	2018-11-07	8
3857	3	1298	2018-11-07 09:51:12	2018-11-07	8
3858	1	1299	2018-11-07 09:26:34	2018-11-07	8
3859	2	1299	2018-11-07 09:26:36	2018-11-07	8
3860	3	1299	2018-11-07 13:32:16	2018-11-07	12
3861	1	1300	2018-11-07 09:12:10	2018-11-07	8
3862	2	1300	2018-11-07 09:12:12	2018-11-07	8
3863	3	1300	2018-11-07 09:43:00	2018-11-07	8
3864	1	1301	2018-11-07 09:05:04	2018-11-07	8
3865	2	1301	2018-11-07 09:05:06	2018-11-07	8
3866	3	1301	2018-11-07 09:05:08	2018-11-07	8
3867	1	1302	2018-11-07 09:01:59	2018-11-07	8
3868	2	1302	2018-11-07 09:02:01	2018-11-07	8
3869	3	1302	2018-11-07 09:02:02	2018-11-07	8
3870	1	1303	2018-11-07 08:53:40	2018-11-07	7
3871	2	1303	2018-11-07 08:53:42	2018-11-07	7
3872	3	1303	2018-11-07 08:53:44	2018-11-07	7
3873	1	1304	2018-11-07 08:52:55	2018-11-07	7
3874	2	1304	2018-11-07 08:52:57	2018-11-07	7
3875	3	1304	2018-11-07 08:52:59	2018-11-07	7
3876	1	1305	2018-11-07 08:48:33	2018-11-07	7
3877	2	1305	2018-11-07 08:48:35	2018-11-07	7
3878	3	1305	2018-11-07 08:48:37	2018-11-07	7
3879	1	1306	2018-11-07 08:44:57	2018-11-07	7
3880	2	1306	2018-11-07 08:44:59	2018-11-07	7
3881	3	1306	2018-11-07 11:36:36	2018-11-07	10
3882	1	1307	2018-11-07 08:43:32	2018-11-07	7
3883	2	1307	2018-11-07 08:43:34	2018-11-07	7
3884	3	1307	2018-11-07 08:43:36	2018-11-07	7
3885	1	1308	2018-11-07 08:40:26	2018-11-07	7
3886	2	1308	2018-11-07 08:40:29	2018-11-07	7
3887	3	1308	2018-11-07 08:40:31	2018-11-07	7
3888	1	1309	2018-11-07 08:21:25	2018-11-07	7
3889	2	1309	2018-11-07 08:21:27	2018-11-07	7
3890	3	1309	2018-11-07 11:46:55	2018-11-07	10
3891	1	1310	2018-11-06 16:40:05	2018-11-06	15
3892	2	1310	2018-11-06 16:40:07	2018-11-06	15
3893	3	1310	2018-11-06 16:40:09	2018-11-06	15
3894	1	1311	2018-11-06 16:34:34	2018-11-06	15
3895	2	1311	2018-11-06 16:34:36	2018-11-06	15
3896	3	1311	2018-11-06 16:34:38	2018-11-06	15
3897	1	1312	2018-11-06 16:32:10	2018-11-06	15
3898	2	1312	2018-11-06 16:32:12	2018-11-06	15
3899	3	1312	2018-11-06 16:32:14	2018-11-06	15
3900	1	1313	2018-11-06 16:29:56	2018-11-06	15
3901	2	1313	2018-11-06 16:29:58	2018-11-06	15
3902	3	1313	2018-11-06 16:30:00	2018-11-06	15
3903	1	1314	2018-11-06 16:28:19	2018-11-06	15
3904	2	1314	2018-11-06 16:28:22	2018-11-06	15
3905	3	1314	2018-11-06 16:28:25	2018-11-06	15
3906	1	1315	2018-11-06 16:23:08	2018-11-06	15
3907	2	1315	2018-11-06 16:23:10	2018-11-06	15
3908	3	1315	2018-11-06 16:23:12	2018-11-06	15
3909	1	1316	2018-11-06 16:21:01	2018-11-06	15
3910	2	1316	2018-11-06 16:21:03	2018-11-06	15
3911	3	1316	2018-11-06 16:21:05	2018-11-06	15
3912	1	1317	2018-11-06 16:18:09	2018-11-06	15
3913	2	1317	2018-11-06 16:18:10	2018-11-06	15
3914	3	1317	2018-11-06 16:18:13	2018-11-06	15
3915	1	1318	2018-11-06 16:07:14	2018-11-06	15
3916	2	1318	2018-11-06 16:07:16	2018-11-06	15
3917	3	1318	2018-11-06 16:07:18	2018-11-06	15
3918	1	1319	2018-11-06 16:01:23	2018-11-06	15
3919	2	1319	2018-11-06 16:01:27	2018-11-06	15
3920	3	1319	2018-11-06 16:01:29	2018-11-06	15
3921	1	1320	2018-11-06 15:57:53	2018-11-06	14
3922	2	1320	2018-11-06 15:57:55	2018-11-06	14
3923	3	1320	2018-11-06 15:57:57	2018-11-06	14
3924	1	1321	2018-11-06 15:56:54	2018-11-06	14
3925	2	1321	2018-11-06 15:56:56	2018-11-06	14
3926	3	1321	2018-11-06 15:56:58	2018-11-06	14
3927	1	1322	2018-11-06 15:54:55	2018-11-06	14
3928	2	1322	2018-11-06 15:54:57	2018-11-06	14
3929	3	1322	2018-11-06 15:54:59	2018-11-06	14
3930	1	1323	2018-11-06 15:47:53	2018-11-06	14
3931	2	1323	2018-11-06 15:47:55	2018-11-06	14
3932	3	1323	2018-11-06 16:12:26	2018-11-06	15
3933	1	1324	2018-11-06 15:41:14	2018-11-06	14
3934	2	1324	2018-11-06 15:41:15	2018-11-06	14
3935	3	1324	2018-11-06 15:41:17	2018-11-06	14
3936	1	1325	2018-11-06 15:33:58	2018-11-06	14
3937	2	1325	2018-11-06 15:34:00	2018-11-06	14
3938	3	1325	2018-11-06 15:51:04	2018-11-06	14
3939	1	1326	2018-11-06 15:28:01	2018-11-06	14
3940	2	1326	2018-11-06 15:28:03	2018-11-06	14
3941	3	1326	2018-11-06 15:28:05	2018-11-06	14
3942	1	1327	2018-11-06 15:22:23	2018-11-06	14
3943	2	1327	2018-11-06 15:22:25	2018-11-06	14
3944	3	1327	2018-11-06 15:22:27	2018-11-06	14
3945	1	1328	2018-11-06 15:27:46	2018-11-06	14
3946	2	1328	2018-11-06 15:27:48	2018-11-06	14
3947	3	1328	2018-11-07 11:57:02	2018-11-07	10
3948	1	1329	2018-11-06 15:10:23	2018-11-06	14
3949	2	1329	2018-11-06 15:10:25	2018-11-06	14
3950	3	1329	2018-11-06 15:10:27	2018-11-06	14
3951	1	1330	2018-11-06 15:07:04	2018-11-06	14
3952	2	1330	2018-11-06 15:07:05	2018-11-06	14
3953	3	1330	2018-11-06 15:07:07	2018-11-06	14
3954	1	1331	2018-11-06 15:08:04	2018-11-06	14
3955	2	1331	2018-11-06 15:08:06	2018-11-06	14
3956	3	1331	2018-11-06 15:24:13	2018-11-06	14
3957	1	1332	2018-11-06 15:06:07	2018-11-06	14
3958	2	1332	2018-11-06 15:06:10	2018-11-06	14
3959	3	1332	2018-11-07 11:59:46	2018-11-07	10
3960	1	1333	2018-11-06 14:44:59	2018-11-06	13
3961	2	1333	2018-11-06 14:45:01	2018-11-06	13
3962	3	1333	2018-11-06 14:45:02	2018-11-06	13
3963	1	1334	2018-11-06 14:37:54	2018-11-06	13
3964	2	1334	2018-11-06 14:37:56	2018-11-06	13
3965	3	1334	2018-11-06 15:03:45	2018-11-06	14
3966	1	1335	2018-11-06 14:32:52	2018-11-06	13
3967	2	1335	2018-11-06 14:32:54	2018-11-06	13
3968	3	1335	2018-11-06 14:32:56	2018-11-06	13
3969	1	1336	2018-11-06 14:30:12	2018-11-06	13
3970	2	1336	2018-11-06 14:30:15	2018-11-06	13
3971	3	1336	2018-11-07 12:01:59	2018-11-07	11
3972	1	1337	2018-11-06 14:28:34	2018-11-06	13
3973	2	1337	2018-11-06 14:28:35	2018-11-06	13
3974	3	1337	2018-11-06 14:28:37	2018-11-06	13
3975	1	1338	2018-11-06 14:26:57	2018-11-06	13
3976	2	1338	2018-11-06 14:27:00	2018-11-06	13
3977	3	1338	2018-11-06 14:27:02	2018-11-06	13
3978	1	1339	2018-11-06 14:24:51	2018-11-06	13
3979	2	1339	2018-11-06 14:24:53	2018-11-06	13
3980	3	1339	2018-11-06 14:24:55	2018-11-06	13
3981	1	1340	2018-11-06 14:24:23	2018-11-06	13
3982	2	1340	2018-11-06 14:24:25	2018-11-06	13
3983	3	1340	2018-11-07 12:03:25	2018-11-07	11
3984	1	1341	2018-11-06 14:21:14	2018-11-06	13
3985	2	1341	2018-11-06 14:21:18	2018-11-06	13
3986	3	1341	2018-11-07 12:04:59	2018-11-07	11
3987	1	1342	2018-11-06 14:18:40	2018-11-06	13
3988	2	1342	2018-11-06 14:18:42	2018-11-06	13
3989	3	1342	2018-11-06 14:18:45	2018-11-06	13
3990	1	1343	2018-11-06 14:16:48	2018-11-06	13
3991	2	1343	2018-11-06 14:16:49	2018-11-06	13
3992	3	1343	2018-11-06 14:16:51	2018-11-06	13
3993	1	1344	2018-11-06 14:14:07	2018-11-06	13
3994	2	1344	2018-11-06 14:14:09	2018-11-06	13
3995	3	1344	2018-11-06 14:14:10	2018-11-06	13
3996	1	1345	2018-11-06 14:11:05	2018-11-06	13
3997	2	1345	2018-11-06 14:11:07	2018-11-06	13
3998	3	1345	2018-11-07 12:06:51	2018-11-07	11
3999	1	1346	2018-11-06 12:24:23	2018-11-06	11
4000	2	1346	2018-11-06 12:24:26	2018-11-06	11
4001	3	1346	2018-11-06 12:24:28	2018-11-06	11
4002	1	1347	2018-11-06 12:22:26	2018-11-06	11
4003	2	1347	2018-11-06 12:22:27	2018-11-06	11
4004	3	1347	2018-11-06 12:22:30	2018-11-06	11
4005	1	1348	2018-11-06 12:07:43	2018-11-06	11
4006	2	1348	2018-11-06 12:07:45	2018-11-06	11
4007	3	1348	2018-11-06 12:07:47	2018-11-06	11
4008	1	1349	2018-11-06 12:01:16	2018-11-06	11
4009	2	1349	2018-11-06 12:01:18	2018-11-06	11
4010	3	1349	2018-11-06 12:08:04	2018-11-06	11
4011	1	1350	2018-11-06 11:47:23	2018-11-06	10
4012	2	1350	2018-11-06 11:47:26	2018-11-06	10
4013	3	1350	2018-11-06 11:47:36	2018-11-06	10
4014	1	1351	2018-11-06 11:38:34	2018-11-06	10
4015	2	1351	2018-11-06 11:38:36	2018-11-06	10
4016	3	1351	2018-11-06 11:55:21	2018-11-06	10
4017	1	1352	2018-11-06 11:27:35	2018-11-06	10
4018	2	1352	2018-11-06 11:27:37	2018-11-06	10
4019	3	1352	2018-11-06 11:27:39	2018-11-06	10
4020	1	1353	2018-11-06 11:25:14	2018-11-06	10
4021	2	1353	2018-11-06 11:25:16	2018-11-06	10
4022	3	1353	2018-11-06 11:25:18	2018-11-06	10
4023	1	1354	2018-11-06 11:18:54	2018-11-06	10
4024	2	1354	2018-11-06 11:18:56	2018-11-06	10
4025	3	1354	2018-11-06 11:18:58	2018-11-06	10
4026	1	1355	2018-11-06 11:15:04	2018-11-06	10
4027	2	1355	2018-11-06 11:15:06	2018-11-06	10
4028	3	1355	2018-11-06 11:15:08	2018-11-06	10
4029	1	1356	2018-11-06 11:12:59	2018-11-06	10
4030	2	1356	2018-11-06 11:13:01	2018-11-06	10
4031	3	1356	2018-11-06 11:13:03	2018-11-06	10
4032	1	1357	2018-11-06 11:06:08	2018-11-06	10
4033	2	1357	2018-11-06 11:06:10	2018-11-06	10
4034	3	1357	2018-11-06 11:06:12	2018-11-06	10
4035	1	1358	2018-11-06 11:01:33	2018-11-06	10
4036	2	1358	2018-11-06 11:01:34	2018-11-06	10
4037	3	1358	2018-11-06 11:01:37	2018-11-06	10
4038	1	1359	2018-11-06 10:57:34	2018-11-06	9
4039	2	1359	2018-11-06 10:57:37	2018-11-06	9
4040	3	1359	2018-11-06 10:57:40	2018-11-06	9
4041	1	1360	2018-11-06 11:00:11	2018-11-06	10
4042	2	1360	2018-11-06 11:00:13	2018-11-06	10
4043	3	1360	2018-11-09 07:45:45	2018-11-09	6
4044	1	1361	2018-11-06 10:51:31	2018-11-06	9
4045	2	1361	2018-11-06 10:51:32	2018-11-06	9
4046	3	1361	2018-11-06 10:51:35	2018-11-06	9
4047	1	1362	2018-11-06 10:51:05	2018-11-06	9
4048	2	1362	2018-11-06 10:51:07	2018-11-06	9
4049	3	1362	2018-11-06 10:51:09	2018-11-06	9
4050	1	1363	2018-11-06 10:51:15	2018-11-06	9
4051	2	1363	2018-11-06 10:51:17	2018-11-06	9
4052	3	1363	2018-11-06 12:46:53	2018-11-06	11
4053	1	1364	2018-11-06 10:48:12	2018-11-06	9
4054	2	1364	2018-11-06 10:48:14	2018-11-06	9
4055	3	1364	2018-11-06 10:48:16	2018-11-06	9
4056	1	1365	2018-11-06 10:47:54	2018-11-06	9
4057	2	1365	2018-11-06 10:47:56	2018-11-06	9
4058	3	1365	2018-11-06 10:47:57	2018-11-06	9
4059	1	1366	2018-11-06 10:48:20	2018-11-06	9
4060	2	1366	2018-11-06 10:48:22	2018-11-06	9
4061	3	1366	2018-11-07 12:08:19	2018-11-07	11
4062	1	1367	2018-11-06 10:42:53	2018-11-06	9
4063	2	1367	2018-11-06 10:42:54	2018-11-06	9
4064	3	1367	2018-11-06 10:42:57	2018-11-06	9
4065	1	1368	2018-11-06 10:42:58	2018-11-06	9
4066	2	1368	2018-11-06 10:43:00	2018-11-06	9
4067	3	1368	2018-11-06 10:59:48	2018-11-06	9
4068	1	1369	2018-11-06 10:43:36	2018-11-06	9
4069	2	1369	2018-11-06 10:43:40	2018-11-06	9
4070	3	1369	2018-11-06 10:43:42	2018-11-06	9
4071	1	1370	2018-11-06 10:40:07	2018-11-06	9
4072	2	1370	2018-11-06 10:40:09	2018-11-06	9
4073	3	1370	2018-11-06 10:40:12	2018-11-06	9
4074	1	1371	2018-11-06 10:39:08	2018-11-06	9
4075	2	1371	2018-11-06 10:39:10	2018-11-06	9
4076	3	1371	2018-11-06 10:39:12	2018-11-06	9
4077	1	1372	2018-11-06 10:23:28	2018-11-06	9
4078	2	1372	2018-11-06 10:23:30	2018-11-06	9
4079	3	1372	2018-11-06 10:23:32	2018-11-06	9
4080	1	1373	2018-11-06 10:17:48	2018-11-06	9
4081	2	1373	2018-11-06 10:17:51	2018-11-06	9
4082	3	1373	2018-11-06 10:17:54	2018-11-06	9
4083	1	1374	2018-11-06 10:11:05	2018-11-06	9
4084	2	1374	2018-11-06 10:11:07	2018-11-06	9
4085	3	1374	2018-11-07 13:34:01	2018-11-07	12
4086	1	1375	2018-11-06 10:04:21	2018-11-06	9
4087	2	1375	2018-11-06 10:04:23	2018-11-06	9
4088	3	1375	2018-11-06 10:04:25	2018-11-06	9
4089	1	1376	2018-11-06 10:03:48	2018-11-06	9
4090	2	1376	2018-11-06 10:03:52	2018-11-06	9
4091	3	1376	2018-11-07 13:35:27	2018-11-07	12
4092	1	1377	2018-11-06 10:00:32	2018-11-06	9
4093	2	1377	2018-11-06 10:00:35	2018-11-06	9
4094	3	1377	2018-11-07 13:43:51	2018-11-07	12
4095	1	1378	2018-11-06 10:01:27	2018-11-06	9
4096	2	1378	2018-11-06 10:01:30	2018-11-06	9
4097	3	1378	2018-11-06 11:52:39	2018-11-06	10
4098	1	1379	2018-11-06 09:55:48	2018-11-06	8
4099	2	1379	2018-11-06 09:55:52	2018-11-06	8
4100	3	1379	2018-11-06 09:55:54	2018-11-06	8
4101	1	1380	2018-11-06 09:52:25	2018-11-06	8
4102	2	1380	2018-11-06 09:52:27	2018-11-06	8
4103	3	1380	2018-11-06 09:52:29	2018-11-06	8
4104	1	1381	2018-11-06 09:46:31	2018-11-06	8
4105	2	1381	2018-11-06 09:46:33	2018-11-06	8
4106	3	1381	2018-11-06 09:46:35	2018-11-06	8
4107	1	1382	2018-11-06 09:47:37	2018-11-06	8
4108	2	1382	2018-11-06 09:47:41	2018-11-06	8
4109	3	1382	2018-11-06 09:48:37	2018-11-06	8
4110	1	1383	2018-11-06 09:42:13	2018-11-06	8
4111	2	1383	2018-11-06 09:42:15	2018-11-06	8
4112	3	1383	2018-11-06 09:42:17	2018-11-06	8
4113	1	1384	2018-11-06 09:37:14	2018-11-06	8
4114	2	1384	2018-11-06 09:37:16	2018-11-06	8
4115	3	1384	2018-11-06 09:37:18	2018-11-06	8
4116	1	1385	2018-11-06 09:31:11	2018-11-06	8
4117	2	1385	2018-11-06 09:31:13	2018-11-06	8
4118	3	1385	2018-11-06 09:31:15	2018-11-06	8
4119	1	1386	2018-11-06 09:30:11	2018-11-06	8
4120	2	1386	2018-11-06 09:30:13	2018-11-06	8
4121	3	1386	2018-11-06 09:30:15	2018-11-06	8
4122	1	1387	2018-11-06 09:28:40	2018-11-06	8
4123	2	1387	2018-11-06 09:28:42	2018-11-06	8
4124	3	1387	2018-11-06 09:28:44	2018-11-06	8
4125	1	1388	2018-11-06 09:28:24	2018-11-06	8
4126	2	1388	2018-11-06 09:28:28	2018-11-06	8
4127	3	1388	2018-11-06 09:28:31	2018-11-06	8
4128	1	1389	2018-11-06 09:20:49	2018-11-06	8
4129	2	1389	2018-11-06 09:20:51	2018-11-06	8
4130	3	1389	2018-11-06 09:20:52	2018-11-06	8
4131	1	1390	2018-11-06 09:18:14	2018-11-06	8
4132	2	1390	2018-11-06 09:18:16	2018-11-06	8
4133	3	1390	2018-11-06 09:18:19	2018-11-06	8
4134	1	1391	2018-11-06 09:18:57	2018-11-06	8
4135	2	1391	2018-11-06 09:18:58	2018-11-06	8
4136	3	1391	2018-11-06 14:26:27	2018-11-06	13
4137	1	1392	2018-11-06 09:03:11	2018-11-06	8
4138	2	1392	2018-11-06 09:03:13	2018-11-06	8
4139	3	1392	2018-11-06 09:03:15	2018-11-06	8
4140	1	1393	2018-11-06 09:01:31	2018-11-06	8
4141	2	1393	2018-11-06 09:01:32	2018-11-06	8
4142	3	1393	2018-11-06 09:01:34	2018-11-06	8
4143	1	1394	2018-11-06 08:59:00	2018-11-06	7
4144	2	1394	2018-11-06 08:59:02	2018-11-06	7
4145	3	1394	2018-11-06 08:59:04	2018-11-06	7
4146	1	1395	2018-11-06 08:53:29	2018-11-06	7
4147	2	1395	2018-11-06 08:53:31	2018-11-06	7
4148	3	1395	2018-11-06 08:53:33	2018-11-06	7
4149	1	1396	2018-11-06 08:53:19	2018-11-06	7
4150	2	1396	2018-11-06 08:53:21	2018-11-06	7
4151	3	1396	2018-11-06 13:02:38	2018-11-06	12
4152	1	1397	2018-11-06 08:51:22	2018-11-06	7
4153	2	1397	2018-11-06 08:51:24	2018-11-06	7
4154	3	1397	2018-11-06 08:51:26	2018-11-06	7
4155	1	1398	2018-11-06 08:49:01	2018-11-06	7
4156	2	1398	2018-11-06 08:49:03	2018-11-06	7
4157	3	1398	2018-11-06 08:49:05	2018-11-06	7
4158	1	1399	2018-11-06 08:46:58	2018-11-06	7
4159	2	1399	2018-11-06 08:46:59	2018-11-06	7
4160	3	1399	2018-11-06 09:35:32	2018-11-06	8
4161	1	1400	2018-11-06 08:43:46	2018-11-06	7
4162	2	1400	2018-11-06 08:43:48	2018-11-06	7
4163	3	1400	2018-11-06 08:43:50	2018-11-06	7
4164	1	1401	2018-11-06 08:41:19	2018-11-06	7
4165	2	1401	2018-11-06 08:41:21	2018-11-06	7
4166	3	1401	2018-11-06 08:41:24	2018-11-06	7
4167	1	1402	2018-11-05 19:50:11	2018-11-05	18
4168	2	1402	2018-11-05 19:50:12	2018-11-05	18
4169	3	1402	2018-11-06 10:18:32	2018-11-06	9
4170	1	1403	2018-11-05 19:45:51	2018-11-05	18
4171	2	1403	2018-11-05 19:45:55	2018-11-05	18
4172	3	1403	2018-11-22 14:12:59	2018-11-22	13
4173	1	1404	2018-11-05 18:54:30	2018-11-05	17
4174	2	1404	2018-11-05 18:54:33	2018-11-05	17
4175	3	1404	2018-11-06 12:16:30	2018-11-06	11
4176	1	1405	2018-11-05 16:50:20	2018-11-05	15
4177	2	1405	2018-11-05 16:50:22	2018-11-05	15
4178	3	1405	2018-11-05 16:50:24	2018-11-05	15
4179	1	1406	2018-11-05 16:49:24	2018-11-05	15
4180	2	1406	2018-11-05 16:49:25	2018-11-05	15
4181	3	1406	2018-11-05 16:49:27	2018-11-05	15
4182	1	1407	2018-11-05 16:48:31	2018-11-05	15
4183	2	1407	2018-11-05 16:48:33	2018-11-05	15
4184	3	1407	2018-11-05 16:48:34	2018-11-05	15
4185	1	1408	2018-11-05 16:49:10	2018-11-05	15
4186	2	1408	2018-11-05 16:49:13	2018-11-05	15
4187	3	1408	2018-11-05 16:49:15	2018-11-05	15
4188	1	1409	2018-11-05 16:47:26	2018-11-05	15
4189	2	1409	2018-11-05 16:47:28	2018-11-05	15
4190	3	1409	2018-11-06 07:56:27	2018-11-06	6
4191	1	1410	2018-11-05 16:31:09	2018-11-05	15
4192	2	1410	2018-11-05 16:31:11	2018-11-05	15
4193	3	1410	2018-11-05 16:31:13	2018-11-05	15
4194	1	1411	2018-11-05 16:27:26	2018-11-05	15
4195	2	1411	2018-11-05 16:27:28	2018-11-05	15
4196	1	1412	2018-11-05 16:26:54	2018-11-05	15
4197	2	1412	2018-11-05 16:26:56	2018-11-05	15
4198	3	1412	2018-11-05 16:26:58	2018-11-05	15
4199	1	1413	2018-11-05 16:26:18	2018-11-05	15
4200	2	1413	2018-11-05 16:26:20	2018-11-05	15
4201	3	1413	2018-11-06 10:21:33	2018-11-06	9
4202	1	1414	2018-11-05 16:24:37	2018-11-05	15
4203	2	1414	2018-11-05 16:24:40	2018-11-05	15
4204	1	1415	2018-11-05 16:22:04	2018-11-05	15
4205	2	1415	2018-11-05 16:22:05	2018-11-05	15
4206	3	1415	2018-11-05 16:22:08	2018-11-05	15
4207	1	1416	2018-11-05 16:15:45	2018-11-05	15
4208	2	1416	2018-11-05 16:15:47	2018-11-05	15
4209	3	1416	2018-11-06 08:59:02	2018-11-06	7
4210	1	1417	2018-11-05 16:09:59	2018-11-05	15
4211	2	1417	2018-11-05 16:10:01	2018-11-05	15
4212	3	1417	2018-11-05 16:10:03	2018-11-05	15
4213	1	1418	2018-11-05 16:07:38	2018-11-05	15
4214	2	1418	2018-11-05 16:07:40	2018-11-05	15
4215	3	1418	2018-11-05 16:07:42	2018-11-05	15
4216	1	1419	2018-11-05 16:06:11	2018-11-05	15
4217	2	1419	2018-11-05 16:06:13	2018-11-05	15
4218	3	1419	2018-11-05 16:06:15	2018-11-05	15
4219	1	1420	2018-11-05 15:58:25	2018-11-05	14
4220	2	1420	2018-11-05 15:58:28	2018-11-05	14
4221	3	1420	2018-11-06 07:56:13	2018-11-06	6
4222	1	1421	2018-11-05 15:56:15	2018-11-05	14
4223	2	1421	2018-11-05 15:56:17	2018-11-05	14
4224	3	1421	2018-11-05 15:56:19	2018-11-05	14
4225	1	1422	2018-11-05 15:55:48	2018-11-05	14
4226	2	1422	2018-11-05 15:55:50	2018-11-05	14
4227	3	1422	2018-11-05 15:55:52	2018-11-05	14
4228	1	1423	2018-11-05 15:49:46	2018-11-05	14
4229	2	1423	2018-11-05 15:49:47	2018-11-05	14
4230	3	1423	2018-11-05 15:49:49	2018-11-05	14
4231	1	1424	2018-11-05 15:42:40	2018-11-05	14
4232	2	1424	2018-11-05 15:42:42	2018-11-05	14
4233	3	1424	2018-11-05 15:42:43	2018-11-05	14
4234	1	1425	2018-11-05 15:26:02	2018-11-05	14
4235	2	1425	2018-11-05 15:26:04	2018-11-05	14
4236	3	1425	2018-11-05 15:26:06	2018-11-05	14
4237	1	1426	2018-11-05 15:23:42	2018-11-05	14
4238	2	1426	2018-11-05 15:23:45	2018-11-05	14
4239	3	1426	2018-11-05 15:23:48	2018-11-05	14
4240	1	1427	2018-11-05 15:16:31	2018-11-05	14
4241	2	1427	2018-11-05 15:16:33	2018-11-05	14
4242	3	1427	2018-11-05 15:16:34	2018-11-05	14
4243	1	1428	2018-11-05 15:13:56	2018-11-05	14
4244	2	1428	2018-11-05 15:13:59	2018-11-05	14
4245	3	1428	2018-11-07 14:00:49	2018-11-07	13
4246	1	1429	2018-11-05 15:09:58	2018-11-05	14
4247	2	1429	2018-11-05 15:10:00	2018-11-05	14
4248	3	1429	2018-11-05 15:10:03	2018-11-05	14
4249	1	1430	2018-11-05 14:48:32	2018-11-05	13
4250	2	1430	2018-11-05 14:48:33	2018-11-05	13
4251	3	1430	2018-11-05 14:48:35	2018-11-05	13
4252	1	1431	2018-11-05 14:48:10	2018-11-05	13
4253	2	1431	2018-11-05 14:48:12	2018-11-05	13
4254	3	1431	2018-11-05 14:48:13	2018-11-05	13
4255	1	1432	2018-11-05 14:46:25	2018-11-05	13
4256	2	1432	2018-11-05 14:46:27	2018-11-05	13
4257	3	1432	2018-11-05 14:46:29	2018-11-05	13
4258	1	1433	2018-11-05 14:42:27	2018-11-05	13
4259	2	1433	2018-11-05 14:42:29	2018-11-05	13
4260	3	1433	2018-11-05 14:42:31	2018-11-05	13
4261	1	1434	2018-11-05 14:41:06	2018-11-05	13
4262	2	1434	2018-11-05 14:41:09	2018-11-05	13
4263	3	1434	2018-11-05 14:41:12	2018-11-05	13
4264	1	1435	2018-11-05 14:38:39	2018-11-05	13
4265	2	1435	2018-11-05 14:38:41	2018-11-05	13
4266	3	1435	2018-11-06 09:27:56	2018-11-06	8
4267	1	1436	2018-11-05 14:40:35	2018-11-05	13
4268	2	1436	2018-11-05 14:40:39	2018-11-05	13
4269	3	1436	2018-11-05 16:31:49	2018-11-05	15
4270	1	1437	2018-11-05 14:32:42	2018-11-05	13
4271	2	1437	2018-11-05 14:32:44	2018-11-05	13
4272	3	1437	2018-11-05 14:32:45	2018-11-05	13
4273	1	1438	2018-11-05 14:32:05	2018-11-05	13
4274	2	1438	2018-11-05 14:32:07	2018-11-05	13
4275	3	1438	2018-11-05 14:32:09	2018-11-05	13
4276	1	1439	2018-11-05 14:30:17	2018-11-05	13
4277	2	1439	2018-11-05 14:30:19	2018-11-05	13
4278	3	1439	2018-11-05 14:30:21	2018-11-05	13
4279	1	1440	2018-11-05 14:27:14	2018-11-05	13
4280	2	1440	2018-11-05 14:27:15	2018-11-05	13
4281	3	1440	2018-11-05 14:27:18	2018-11-05	13
4282	1	1441	2018-11-05 14:26:32	2018-11-05	13
4283	2	1441	2018-11-05 14:26:34	2018-11-05	13
4284	3	1441	2018-11-05 14:27:24	2018-11-05	13
4285	1	1442	2018-11-05 14:25:32	2018-11-05	13
4286	2	1442	2018-11-05 14:25:34	2018-11-05	13
4287	3	1442	2018-11-05 14:25:36	2018-11-05	13
4288	1	1443	2018-11-05 14:26:48	2018-11-05	13
4289	2	1443	2018-11-05 14:26:51	2018-11-05	13
4290	3	1443	2018-11-05 14:26:54	2018-11-05	13
4291	1	1444	2018-11-05 14:19:34	2018-11-05	13
4292	2	1444	2018-11-05 14:19:36	2018-11-05	13
4293	3	1444	2018-11-05 14:19:38	2018-11-05	13
4294	1	1445	2018-11-05 14:19:59	2018-11-05	13
4295	2	1445	2018-11-05 14:20:02	2018-11-05	13
4296	3	1445	2018-11-05 14:20:04	2018-11-05	13
4297	1	1446	2018-11-05 14:15:09	2018-11-05	13
4298	2	1446	2018-11-05 14:15:11	2018-11-05	13
4299	3	1446	2018-11-05 14:15:12	2018-11-05	13
4300	1	1447	2018-11-05 14:09:57	2018-11-05	13
4301	2	1447	2018-11-05 14:09:58	2018-11-05	13
4302	3	1447	2018-11-05 16:03:28	2018-11-05	15
4303	1	1448	2018-11-05 14:05:42	2018-11-05	13
4304	2	1448	2018-11-05 14:05:43	2018-11-05	13
4305	3	1448	2018-11-05 14:05:45	2018-11-05	13
4306	1	1449	2018-11-05 13:27:01	2018-11-05	12
4307	2	1449	2018-11-05 13:27:04	2018-11-05	12
4308	3	1449	2018-11-07 13:47:04	2018-11-07	12
4309	1	1450	2018-11-05 12:50:02	2018-11-05	11
4310	2	1450	2018-11-05 12:50:04	2018-11-05	11
4311	3	1450	2018-11-05 15:50:22	2018-11-05	14
4312	1	1451	2018-11-05 12:04:22	2018-11-05	11
4313	2	1451	2018-11-05 12:04:26	2018-11-05	11
4314	3	1451	2018-11-07 13:59:07	2018-11-07	12
4315	1	1452	2018-11-05 12:08:29	2018-11-05	11
4316	2	1452	2018-11-05 12:08:31	2018-11-05	11
4317	3	1452	2018-11-22 14:11:14	2018-11-22	13
4318	1	1453	2018-11-05 11:50:06	2018-11-05	10
4319	2	1453	2018-11-05 11:50:08	2018-11-05	10
4320	3	1453	2018-11-05 16:21:00	2018-11-05	15
4321	1	1454	2018-11-05 11:38:59	2018-11-05	10
4322	2	1454	2018-11-05 11:39:01	2018-11-05	10
4323	3	1454	2018-11-05 11:39:03	2018-11-05	10
4324	1	1455	2018-11-05 11:33:55	2018-11-05	10
4325	2	1455	2018-11-05 11:33:57	2018-11-05	10
4326	3	1455	2018-11-05 11:33:59	2018-11-05	10
4327	1	1456	2018-11-05 11:35:04	2018-11-05	10
4328	2	1456	2018-11-05 11:35:06	2018-11-05	10
4329	3	1456	2018-11-05 11:35:08	2018-11-05	10
4330	1	1457	2018-11-05 11:33:01	2018-11-05	10
4331	2	1457	2018-11-05 11:33:03	2018-11-05	10
4332	3	1457	2018-11-05 11:33:06	2018-11-05	10
4333	1	1458	2018-11-05 11:26:04	2018-11-05	10
4334	2	1458	2018-11-05 11:26:06	2018-11-05	10
4335	3	1458	2018-11-05 11:26:08	2018-11-05	10
4336	1	1459	2018-11-05 11:25:11	2018-11-05	10
4337	2	1459	2018-11-05 11:25:13	2018-11-05	10
4338	3	1459	2018-11-05 11:25:15	2018-11-05	10
4339	1	1460	2018-11-05 11:25:23	2018-11-05	10
4340	2	1460	2018-11-05 11:25:26	2018-11-05	10
4341	3	1460	2018-11-05 11:25:28	2018-11-05	10
4342	1	1461	2018-11-05 11:20:04	2018-11-05	10
4343	2	1461	2018-11-05 11:20:06	2018-11-05	10
4344	3	1461	2018-11-05 11:20:08	2018-11-05	10
4345	1	1462	2018-11-05 11:16:50	2018-11-05	10
4346	2	1462	2018-11-05 11:16:52	2018-11-05	10
4347	3	1462	2018-11-05 11:16:53	2018-11-05	10
4348	1	1463	2018-11-05 11:19:11	2018-11-05	10
4349	2	1463	2018-11-05 11:19:13	2018-11-05	10
4350	3	1463	2018-11-05 11:19:15	2018-11-05	10
4351	1	1464	2018-11-05 11:12:04	2018-11-05	10
4352	2	1464	2018-11-05 11:12:06	2018-11-05	10
4353	3	1464	2018-11-05 11:12:08	2018-11-05	10
4354	1	1465	2018-11-05 11:12:12	2018-11-05	10
4355	2	1465	2018-11-05 11:12:13	2018-11-05	10
4356	3	1465	2018-11-05 11:12:15	2018-11-05	10
4357	1	1466	2018-11-05 11:16:39	2018-11-05	10
4358	2	1466	2018-11-05 11:16:42	2018-11-05	10
4359	3	1466	2018-12-05 14:01:16	2018-12-05	13
4360	1	1467	2018-11-05 11:08:15	2018-11-05	10
4361	2	1467	2018-11-05 11:08:17	2018-11-05	10
4362	3	1467	2018-11-05 12:04:27	2018-11-05	11
4363	1	1468	2018-11-05 11:06:02	2018-11-05	10
4364	2	1468	2018-11-05 11:06:03	2018-11-05	10
4365	3	1468	2018-11-05 11:14:31	2018-11-05	10
4366	1	1469	2018-11-05 11:01:18	2018-11-05	10
4367	2	1469	2018-11-05 11:01:21	2018-11-05	10
4368	3	1469	2018-11-05 11:01:23	2018-11-05	10
4369	1	1470	2018-11-05 10:54:15	2018-11-05	9
4370	2	1470	2018-11-05 10:54:16	2018-11-05	9
4371	3	1470	2018-11-05 10:54:18	2018-11-05	9
4372	1	1471	2018-11-05 10:53:08	2018-11-05	9
4373	2	1471	2018-11-05 10:53:11	2018-11-05	9
4374	3	1471	2018-11-05 10:53:14	2018-11-05	9
4375	1	1472	2018-11-05 10:49:14	2018-11-05	9
4376	2	1472	2018-11-05 10:49:17	2018-11-05	9
4377	3	1472	2018-11-05 10:49:19	2018-11-05	9
4378	1	1473	2018-11-05 10:49:33	2018-11-05	9
4379	2	1473	2018-11-05 10:49:35	2018-11-05	9
4380	3	1473	2018-11-05 10:49:37	2018-11-05	9
4381	1	1474	2018-11-05 10:52:30	2018-11-05	9
4382	2	1474	2018-11-05 10:52:32	2018-11-05	9
4383	3	1474	2018-11-05 10:52:34	2018-11-05	9
4384	1	1475	2018-11-05 10:42:31	2018-11-05	9
4385	2	1475	2018-11-05 10:42:32	2018-11-05	9
4386	3	1475	2018-11-05 10:42:34	2018-11-05	9
4387	1	1476	2018-11-05 10:45:00	2018-11-05	9
4388	2	1476	2018-11-05 10:45:04	2018-11-05	9
4389	3	1476	2018-11-06 14:10:36	2018-11-06	13
4390	1	1477	2018-11-05 10:43:32	2018-11-05	9
4391	2	1477	2018-11-05 10:43:36	2018-11-05	9
4392	3	1477	2018-11-05 10:43:38	2018-11-05	9
4393	1	1478	2018-11-05 10:39:57	2018-11-05	9
4394	2	1478	2018-11-05 10:39:58	2018-11-05	9
4395	3	1478	2018-11-05 10:40:00	2018-11-05	9
4396	1	1479	2018-11-05 10:36:25	2018-11-05	9
4397	2	1479	2018-11-05 10:36:27	2018-11-05	9
4398	3	1479	2018-11-05 10:36:29	2018-11-05	9
4399	1	1480	2018-11-05 10:32:20	2018-11-05	9
4400	2	1480	2018-11-05 10:32:23	2018-11-05	9
4401	3	1480	2018-11-05 10:32:26	2018-11-05	9
4402	1	1481	2018-11-05 10:30:59	2018-11-05	9
4403	2	1481	2018-11-05 10:31:00	2018-11-05	9
4404	3	1481	2018-11-05 10:31:02	2018-11-05	9
4405	1	1482	2018-11-05 10:35:32	2018-11-05	9
4406	2	1482	2018-11-05 10:35:34	2018-11-05	9
4407	3	1482	2018-11-05 10:35:37	2018-11-05	9
4408	1	1483	2018-11-05 10:28:34	2018-11-05	9
4409	2	1483	2018-11-05 10:28:37	2018-11-05	9
4410	3	1483	2018-11-05 10:28:40	2018-11-05	9
4411	1	1484	2018-11-05 10:24:33	2018-11-05	9
4412	2	1484	2018-11-05 10:24:34	2018-11-05	9
4413	3	1484	2018-11-05 10:24:36	2018-11-05	9
4414	1	1485	2018-11-05 10:24:11	2018-11-05	9
4415	2	1485	2018-11-05 10:24:13	2018-11-05	9
4416	3	1485	2018-11-05 10:24:15	2018-11-05	9
4417	1	1486	2018-11-05 10:21:33	2018-11-05	9
4418	2	1486	2018-11-05 10:21:36	2018-11-05	9
4419	3	1486	2018-11-07 14:08:55	2018-11-07	13
4420	1	1487	2018-11-05 10:17:56	2018-11-05	9
4421	2	1487	2018-11-05 10:17:59	2018-11-05	9
4422	3	1487	2018-11-05 10:18:02	2018-11-05	9
4423	1	1488	2018-11-05 10:15:20	2018-11-05	9
4424	2	1488	2018-11-05 10:15:23	2018-11-05	9
4425	3	1488	2018-11-05 10:15:26	2018-11-05	9
4426	1	1489	2018-11-05 10:13:19	2018-11-05	9
4427	2	1489	2018-11-05 10:13:21	2018-11-05	9
4428	3	1489	2018-11-05 10:13:22	2018-11-05	9
4429	1	1490	2018-11-05 10:12:40	2018-11-05	9
4430	2	1490	2018-11-05 10:12:42	2018-11-05	9
4431	3	1490	2018-11-05 10:12:44	2018-11-05	9
4432	1	1491	2018-11-05 10:06:27	2018-11-05	9
4433	2	1491	2018-11-05 10:06:29	2018-11-05	9
4434	3	1491	2018-11-05 10:06:31	2018-11-05	9
4435	1	1492	2018-11-05 10:04:37	2018-11-05	9
4436	2	1492	2018-11-05 10:04:41	2018-11-05	9
4437	3	1492	2018-11-07 14:12:25	2018-11-07	13
4438	1	1493	2018-11-05 10:02:27	2018-11-05	9
4439	2	1493	2018-11-05 10:02:29	2018-11-05	9
4440	3	1493	2018-11-05 10:02:31	2018-11-05	9
4441	1	1494	2018-11-05 09:59:48	2018-11-05	8
4442	2	1494	2018-11-05 09:59:49	2018-11-05	8
4443	3	1494	2018-11-05 14:41:16	2018-11-05	13
4444	1	1495	2018-11-05 09:58:00	2018-11-05	8
4445	2	1495	2018-11-05 09:58:02	2018-11-05	8
4446	3	1495	2018-11-05 09:58:04	2018-11-05	8
4447	1	1496	2018-11-05 09:57:04	2018-11-05	8
4448	2	1496	2018-11-05 09:57:08	2018-11-05	8
4449	3	1496	2018-11-05 11:03:24	2018-11-05	10
4450	1	1497	2018-11-05 09:55:15	2018-11-05	8
4451	2	1497	2018-11-05 09:55:17	2018-11-05	8
4452	3	1497	2018-11-05 09:55:19	2018-11-05	8
4453	1	1498	2018-11-05 09:53:28	2018-11-05	8
4454	2	1498	2018-11-05 09:53:30	2018-11-05	8
4455	3	1498	2018-11-05 09:53:32	2018-11-05	8
4456	1	1499	2018-11-05 09:52:31	2018-11-05	8
4457	2	1499	2018-11-05 09:52:33	2018-11-05	8
4458	3	1499	2018-11-05 09:52:35	2018-11-05	8
4459	1	1500	2018-11-05 09:45:56	2018-11-05	8
4460	2	1500	2018-11-05 09:45:57	2018-11-05	8
4461	3	1500	2018-11-05 09:45:59	2018-11-05	8
4462	1	1501	2018-11-05 09:46:25	2018-11-05	8
4463	2	1501	2018-11-05 09:46:28	2018-11-05	8
4464	3	1501	2018-11-05 10:29:16	2018-11-05	9
4465	1	1502	2018-11-05 09:41:55	2018-11-05	8
4466	2	1502	2018-11-05 09:41:57	2018-11-05	8
4467	3	1502	2018-11-05 09:41:58	2018-11-05	8
4468	1	1503	2018-11-05 09:41:45	2018-11-05	8
4469	2	1503	2018-11-05 09:41:48	2018-11-05	8
4470	3	1503	2018-11-06 11:22:39	2018-11-06	10
4471	1	1504	2018-11-05 09:40:15	2018-11-05	8
4472	2	1504	2018-11-05 09:40:17	2018-11-05	8
4473	3	1504	2018-11-05 09:40:19	2018-11-05	8
4474	1	1505	2018-11-05 09:39:02	2018-11-05	8
4475	2	1505	2018-11-05 09:39:04	2018-11-05	8
4476	3	1505	2018-11-05 09:39:06	2018-11-05	8
4477	1	1506	2018-11-05 09:37:50	2018-11-05	8
4478	2	1506	2018-11-05 09:37:52	2018-11-05	8
4479	3	1506	2018-11-05 09:37:54	2018-11-05	8
4480	1	1507	2018-11-05 09:36:25	2018-11-05	8
4481	2	1507	2018-11-05 09:36:29	2018-11-05	8
4482	3	1507	2018-11-05 10:42:49	2018-11-05	9
4483	1	1508	2018-11-05 09:32:49	2018-11-05	8
4484	2	1508	2018-11-05 09:32:51	2018-11-05	8
4485	3	1508	2018-11-05 09:32:54	2018-11-05	8
4486	1	1509	2018-11-05 09:30:06	2018-11-05	8
4487	2	1509	2018-11-05 09:30:10	2018-11-05	8
4488	3	1509	2018-11-05 09:30:12	2018-11-05	8
4489	1	1510	2018-11-05 09:37:46	2018-11-05	8
4490	2	1510	2018-11-05 09:37:48	2018-11-05	8
4491	3	1510	2018-11-05 09:44:20	2018-11-05	8
4492	1	1511	2018-11-05 09:29:58	2018-11-05	8
4493	2	1511	2018-11-05 09:30:01	2018-11-05	8
4494	3	1511	2018-11-06 11:19:32	2018-11-06	10
4495	1	1512	2018-11-05 09:26:58	2018-11-05	8
4496	2	1512	2018-11-05 09:27:01	2018-11-05	8
4497	3	1512	2018-11-05 09:27:03	2018-11-05	8
4498	1	1513	2018-11-05 09:23:30	2018-11-05	8
4499	2	1513	2018-11-05 09:23:31	2018-11-05	8
4500	3	1513	2018-11-05 11:17:54	2018-11-05	10
4501	1	1514	2018-11-05 09:20:34	2018-11-05	8
4502	2	1514	2018-11-05 09:20:36	2018-11-05	8
4503	3	1514	2018-11-05 09:20:39	2018-11-05	8
4504	1	1515	2018-11-05 09:18:23	2018-11-05	8
4505	2	1515	2018-11-05 09:18:24	2018-11-05	8
4506	3	1515	2018-11-05 09:18:26	2018-11-05	8
4507	1	1516	2018-11-05 09:20:40	2018-11-05	8
4508	2	1516	2018-11-05 09:20:44	2018-11-05	8
4509	3	1516	2018-11-05 09:20:46	2018-11-05	8
4510	1	1517	2018-11-05 09:21:17	2018-11-05	8
4511	2	1517	2018-11-05 09:21:20	2018-11-05	8
4512	3	1517	2018-11-05 09:21:22	2018-11-05	8
4513	1	1518	2018-11-05 09:13:44	2018-11-05	8
4514	2	1518	2018-11-05 09:13:46	2018-11-05	8
4515	3	1518	2018-11-05 09:13:47	2018-11-05	8
4516	1	1519	2018-11-05 09:11:33	2018-11-05	8
4517	2	1519	2018-11-05 09:11:35	2018-11-05	8
4518	3	1519	2018-11-05 09:11:37	2018-11-05	8
4519	1	1520	2018-11-05 09:08:18	2018-11-05	8
4520	2	1520	2018-11-05 09:08:20	2018-11-05	8
4521	3	1520	2018-11-06 07:54:19	2018-11-06	6
4522	1	1521	2018-11-05 09:05:17	2018-11-05	8
4523	2	1521	2018-11-05 09:05:18	2018-11-05	8
4524	3	1521	2018-11-05 09:05:20	2018-11-05	8
4525	1	1522	2018-11-05 09:01:18	2018-11-05	8
4526	2	1522	2018-11-05 09:01:22	2018-11-05	8
4527	3	1522	2018-11-07 14:13:45	2018-11-07	13
4528	1	1523	2018-11-05 08:57:16	2018-11-05	7
4529	2	1523	2018-11-05 08:57:18	2018-11-05	7
4530	3	1523	2018-11-05 08:57:20	2018-11-05	7
4531	1	1524	2018-11-05 08:52:16	2018-11-05	7
4532	2	1524	2018-11-05 08:52:17	2018-11-05	7
4533	3	1524	2018-11-05 08:52:19	2018-11-05	7
4534	1	1525	2018-11-05 08:50:25	2018-11-05	7
4535	2	1525	2018-11-05 08:50:29	2018-11-05	7
4536	3	1525	2018-11-05 08:50:31	2018-11-05	7
4537	1	1526	2018-11-05 08:46:44	2018-11-05	7
4538	2	1526	2018-11-05 08:46:47	2018-11-05	7
4539	3	1526	2018-11-05 08:46:49	2018-11-05	7
4540	1	1527	2018-11-05 08:38:12	2018-11-05	7
4541	2	1527	2018-11-05 08:38:16	2018-11-05	7
4542	3	1527	2018-11-07 14:20:14	2018-11-07	13
4543	1	1528	2018-11-05 08:35:13	2018-11-05	7
4544	2	1528	2018-11-05 08:35:15	2018-11-05	7
4545	3	1528	2018-11-14 12:08:45	2018-11-14	11
4546	1	1529	2018-11-05 08:29:05	2018-11-05	7
4547	2	1529	2018-11-05 08:29:08	2018-11-05	7
4548	3	1529	2018-11-07 15:30:21	2018-11-07	14
4549	1	1530	2018-11-05 08:24:00	2018-11-05	7
4550	2	1530	2018-11-05 08:24:04	2018-11-05	7
4551	3	1530	2018-11-07 15:32:12	2018-11-07	14
4552	1	1531	2018-11-05 07:40:39	2018-11-05	6
4553	2	1531	2018-11-05 07:40:41	2018-11-05	6
4554	3	1531	2018-11-05 07:45:39	2018-11-05	6
4555	1	1532	2018-11-05 07:39:07	2018-11-05	6
4556	2	1532	2018-11-05 07:39:09	2018-11-05	6
4557	3	1532	2018-11-07 15:34:16	2018-11-07	14
4558	1	1533	2018-11-05 07:36:14	2018-11-05	6
4559	2	1533	2018-11-05 07:36:16	2018-11-05	6
4560	3	1533	2018-11-07 15:42:53	2018-11-07	14
4561	1	1534	2018-11-05 07:34:49	2018-11-05	6
4562	2	1534	2018-11-05 07:34:52	2018-11-05	6
4563	3	1534	2018-11-07 15:44:25	2018-11-07	14
4564	1	1535	2018-11-05 07:28:43	2018-11-05	6
4565	2	1535	2018-11-05 07:28:46	2018-11-05	6
4566	3	1535	2018-11-07 15:41:30	2018-11-07	14
4567	1	1536	2018-11-04 18:29:58	2018-11-04	17
4568	2	1536	2018-11-04 18:30:00	2018-11-04	17
4569	3	1536	2018-11-07 14:18:37	2018-11-07	13
4570	1	1537	2018-11-02 20:43:36	2018-11-02	19
4571	2	1537	2018-11-02 20:43:39	2018-11-02	19
4572	3	1537	2018-11-05 12:05:37	2018-11-05	11
4573	1	1538	2018-11-02 20:26:49	2018-11-02	19
4574	2	1538	2018-11-02 20:26:51	2018-11-02	19
4575	3	1538	2018-11-05 14:55:51	2018-11-05	13
4576	1	1539	2018-11-02 17:34:35	2018-11-02	16
4577	2	1539	2018-11-02 17:34:37	2018-11-02	16
4578	3	1539	2018-11-05 08:55:44	2018-11-05	7
4579	1	1540	2018-11-02 18:03:31	2018-11-02	17
4580	2	1540	2018-11-02 18:03:33	2018-11-02	17
4581	3	1540	2018-11-07 14:15:14	2018-11-07	13
4582	1	1541	2018-11-02 15:47:02	2018-11-02	14
4583	2	1541	2018-11-02 15:47:05	2018-11-02	14
4584	3	1541	2018-11-05 11:46:13	2018-11-05	10
4585	1	1542	2018-11-02 14:31:33	2018-11-02	13
4586	2	1542	2018-11-02 14:31:36	2018-11-02	13
4587	3	1542	2018-11-05 09:04:14	2018-11-05	8
4588	1	1543	2018-11-02 09:58:38	2018-11-02	8
4589	2	1543	2018-11-02 09:58:40	2018-11-02	8
4590	3	1543	2018-11-05 11:36:42	2018-11-05	10
4591	1	1544	2018-11-01 20:12:25	2018-11-01	19
4592	2	1544	2018-11-01 20:12:27	2018-11-01	19
4593	1	1545	2018-11-01 11:51:01	2018-11-01	10
4594	2	1545	2018-11-01 11:51:03	2018-11-01	10
4595	3	1545	2018-11-22 11:19:29	2018-11-22	10
4596	1	1546	2018-11-01 11:46:24	2018-11-01	10
4597	2	1546	2018-11-01 11:46:27	2018-11-01	10
4598	3	1546	2018-12-05 14:08:46	2018-12-05	13
4599	1	1547	2018-10-31 17:00:01	2018-10-31	16
4600	2	1547	2018-10-31 17:00:04	2018-10-31	16
4601	3	1547	2018-10-31 17:00:06	2018-10-31	16
4602	1	1548	2018-10-31 16:59:10	2018-10-31	15
4603	2	1548	2018-10-31 16:59:11	2018-10-31	15
4604	3	1548	2018-10-31 16:59:13	2018-10-31	15
4605	1	1549	2018-10-31 16:53:10	2018-10-31	15
4606	2	1549	2018-10-31 16:53:12	2018-10-31	15
4607	3	1549	2018-11-06 16:11:46	2018-11-06	15
4608	1	1550	2018-10-31 16:41:15	2018-10-31	15
4609	2	1550	2018-10-31 16:41:17	2018-10-31	15
4610	3	1550	2018-10-31 16:47:50	2018-10-31	15
4611	1	1551	2018-10-31 16:36:11	2018-10-31	15
4612	2	1551	2018-10-31 16:36:14	2018-10-31	15
4613	3	1551	2018-11-07 15:48:57	2018-11-07	14
4614	1	1552	2018-10-31 16:31:18	2018-10-31	15
4615	2	1552	2018-10-31 16:31:19	2018-10-31	15
4616	3	1552	2018-10-31 16:31:21	2018-10-31	15
4617	1	1553	2018-10-31 16:30:09	2018-10-31	15
4618	2	1553	2018-10-31 16:30:11	2018-10-31	15
4619	3	1553	2018-10-31 16:30:13	2018-10-31	15
4620	1	1554	2018-10-31 16:29:31	2018-10-31	15
4621	2	1554	2018-10-31 16:29:33	2018-10-31	15
4622	3	1554	2018-10-31 16:29:35	2018-10-31	15
4623	1	1555	2018-10-31 16:22:07	2018-10-31	15
4624	2	1555	2018-10-31 16:22:10	2018-10-31	15
4625	3	1555	2018-10-31 16:22:12	2018-10-31	15
4626	1	1556	2018-10-31 16:16:04	2018-10-31	15
4627	2	1556	2018-10-31 16:16:06	2018-10-31	15
4628	3	1556	2018-10-31 16:16:08	2018-10-31	15
4629	1	1557	2018-10-31 16:11:38	2018-10-31	15
4630	2	1557	2018-10-31 16:11:40	2018-10-31	15
4631	3	1557	2018-11-02 15:40:03	2018-11-02	14
4632	1	1558	2018-10-31 16:09:13	2018-10-31	15
4633	2	1558	2018-10-31 16:09:16	2018-10-31	15
4634	3	1558	2018-10-31 16:09:19	2018-10-31	15
4635	1	1559	2018-10-31 16:06:39	2018-10-31	15
4636	2	1559	2018-10-31 16:06:42	2018-10-31	15
4637	3	1559	2018-10-31 16:06:44	2018-10-31	15
4638	1	1560	2018-10-31 16:05:01	2018-10-31	15
4639	2	1560	2018-10-31 16:05:03	2018-10-31	15
4640	3	1560	2018-10-31 16:45:59	2018-10-31	15
4641	1	1561	2018-10-31 15:55:16	2018-10-31	14
4642	2	1561	2018-10-31 15:55:17	2018-10-31	14
4643	3	1561	2018-10-31 15:55:19	2018-10-31	14
4644	1	1562	2018-10-31 15:53:19	2018-10-31	14
4645	2	1562	2018-10-31 15:53:21	2018-10-31	14
4646	3	1562	2018-10-31 15:53:23	2018-10-31	14
4647	1	1563	2018-10-31 15:54:19	2018-10-31	14
4648	2	1563	2018-10-31 15:54:21	2018-10-31	14
4649	3	1563	2018-11-06 12:33:38	2018-11-06	11
4650	1	1564	2018-10-31 15:40:58	2018-10-31	14
4651	2	1564	2018-10-31 15:41:00	2018-10-31	14
4652	3	1564	2018-10-31 15:41:02	2018-10-31	14
4653	1	1565	2018-10-31 15:38:36	2018-10-31	14
4654	2	1565	2018-10-31 15:38:38	2018-10-31	14
4655	3	1565	2018-10-31 15:38:40	2018-10-31	14
4656	1	1566	2018-10-31 16:07:37	2018-10-31	15
4657	2	1566	2018-10-31 16:07:41	2018-10-31	15
4658	3	1566	2018-10-31 16:07:43	2018-10-31	15
4659	1	1567	2018-10-31 15:37:45	2018-10-31	14
4660	2	1567	2018-10-31 15:37:47	2018-10-31	14
4661	3	1567	2018-10-31 15:37:49	2018-10-31	14
4662	1	1568	2018-10-31 15:30:56	2018-10-31	14
4663	2	1568	2018-10-31 15:30:58	2018-10-31	14
4664	3	1568	2018-10-31 15:31:00	2018-10-31	14
4665	1	1569	2018-10-31 15:24:03	2018-10-31	14
4666	2	1569	2018-10-31 15:24:05	2018-10-31	14
4667	3	1569	2018-10-31 15:24:07	2018-10-31	14
4668	1	1570	2018-10-31 15:18:16	2018-10-31	14
4669	2	1570	2018-10-31 15:18:18	2018-10-31	14
4670	3	1570	2018-10-31 15:51:28	2018-10-31	14
4671	1	1571	2018-10-31 15:10:22	2018-10-31	14
4672	2	1571	2018-10-31 15:10:26	2018-10-31	14
4673	3	1571	2018-10-31 15:10:29	2018-10-31	14
4674	1	1572	2018-10-31 15:07:52	2018-10-31	14
4675	2	1572	2018-10-31 15:07:54	2018-10-31	14
4676	3	1572	2018-10-31 15:07:55	2018-10-31	14
4677	1	1573	2018-10-31 15:00:20	2018-10-31	14
4678	2	1573	2018-10-31 15:00:22	2018-10-31	14
4679	3	1573	2018-10-31 15:00:24	2018-10-31	14
4680	1	1574	2018-10-31 15:02:33	2018-10-31	14
4681	2	1574	2018-10-31 15:02:35	2018-10-31	14
4682	3	1574	2018-10-31 15:02:37	2018-10-31	14
4683	1	1575	2018-10-31 14:53:28	2018-10-31	13
4684	2	1575	2018-10-31 14:53:30	2018-10-31	13
4685	3	1575	2018-10-31 14:53:32	2018-10-31	13
4686	1	1576	2018-10-31 14:49:48	2018-10-31	13
4687	2	1576	2018-10-31 14:49:50	2018-10-31	13
4688	3	1576	2018-10-31 15:03:28	2018-10-31	14
4689	1	1577	2018-10-31 14:43:50	2018-10-31	13
4690	2	1577	2018-10-31 14:43:51	2018-10-31	13
4691	3	1577	2018-10-31 14:43:53	2018-10-31	13
4692	1	1578	2018-10-31 14:44:22	2018-10-31	13
4693	2	1578	2018-10-31 14:44:23	2018-10-31	13
4694	1	1579	2018-10-31 14:40:15	2018-10-31	13
4695	2	1579	2018-10-31 14:40:16	2018-10-31	13
4696	3	1579	2018-10-31 14:40:18	2018-10-31	13
4697	1	1580	2018-10-31 14:28:54	2018-10-31	13
4698	2	1580	2018-10-31 14:28:55	2018-10-31	13
4699	3	1580	2018-10-31 14:28:57	2018-10-31	13
4700	1	1581	2018-10-31 14:23:19	2018-10-31	13
4701	2	1581	2018-10-31 14:23:21	2018-10-31	13
4702	3	1581	2018-10-31 14:23:23	2018-10-31	13
4703	1	1582	2018-10-31 14:21:36	2018-10-31	13
4704	2	1582	2018-10-31 14:21:38	2018-10-31	13
4705	3	1582	2018-10-31 14:21:40	2018-10-31	13
4706	1	1583	2018-10-31 14:20:29	2018-10-31	13
4707	2	1583	2018-10-31 14:20:31	2018-10-31	13
4708	3	1583	2018-10-31 14:20:34	2018-10-31	13
4709	1	1584	2018-10-31 14:19:39	2018-10-31	13
4710	2	1584	2018-10-31 14:19:41	2018-10-31	13
4711	3	1584	2018-10-31 14:19:43	2018-10-31	13
4712	1	1585	2018-10-31 14:18:54	2018-10-31	13
4713	2	1585	2018-10-31 14:18:56	2018-10-31	13
4714	3	1585	2018-10-31 14:18:58	2018-10-31	13
4715	1	1586	2018-10-31 14:15:03	2018-10-31	13
4716	2	1586	2018-10-31 14:15:06	2018-10-31	13
4717	3	1586	2018-10-31 14:15:09	2018-10-31	13
4718	1	1587	2018-10-31 14:05:15	2018-10-31	13
4719	2	1587	2018-10-31 14:05:17	2018-10-31	13
4720	3	1587	2018-10-31 14:05:18	2018-10-31	13
4721	1	1588	2018-10-31 12:33:26	2018-10-31	11
4722	2	1588	2018-10-31 12:33:29	2018-10-31	11
4723	3	1588	2018-10-31 12:33:32	2018-10-31	11
4724	1	1589	2018-10-31 12:26:39	2018-10-31	11
4725	2	1589	2018-10-31 12:26:41	2018-10-31	11
4726	3	1589	2018-10-31 12:26:44	2018-10-31	11
4727	1	1590	2018-10-31 11:55:12	2018-10-31	10
4728	2	1590	2018-10-31 11:55:14	2018-10-31	10
4729	3	1590	2018-10-31 11:55:16	2018-10-31	10
4730	1	1591	2018-10-31 11:51:36	2018-10-31	10
4731	2	1591	2018-10-31 11:51:38	2018-10-31	10
4732	3	1591	2018-10-31 12:18:58	2018-10-31	11
4733	1	1592	2018-10-31 11:48:44	2018-10-31	10
4734	2	1592	2018-10-31 11:48:46	2018-10-31	10
4735	3	1592	2018-10-31 11:48:48	2018-10-31	10
4736	1	1593	2018-10-31 11:46:50	2018-10-31	10
4737	2	1593	2018-10-31 11:46:52	2018-10-31	10
4738	3	1593	2018-10-31 11:46:54	2018-10-31	10
4739	1	1594	2018-10-31 11:48:12	2018-10-31	10
4740	2	1594	2018-10-31 11:48:14	2018-10-31	10
4741	3	1594	2018-10-31 11:48:16	2018-10-31	10
4742	1	1595	2018-10-31 11:39:23	2018-10-31	10
4743	2	1595	2018-10-31 11:39:27	2018-10-31	10
4744	3	1595	2018-10-31 11:50:44	2018-10-31	10
4745	1	1596	2018-10-31 11:33:31	2018-10-31	10
4746	2	1596	2018-10-31 11:33:33	2018-10-31	10
4747	3	1596	2018-10-31 11:33:35	2018-10-31	10
4748	1	1597	2018-10-31 11:29:16	2018-10-31	10
4749	2	1597	2018-10-31 11:29:18	2018-10-31	10
4750	3	1597	2018-10-31 11:29:20	2018-10-31	10
4751	1	1598	2018-10-31 11:27:31	2018-10-31	10
4752	2	1598	2018-10-31 11:27:33	2018-10-31	10
4753	3	1598	2018-10-31 11:27:35	2018-10-31	10
4754	1	1599	2018-10-31 11:24:03	2018-10-31	10
4755	2	1599	2018-10-31 11:24:05	2018-10-31	10
4756	3	1599	2018-10-31 11:24:06	2018-10-31	10
4757	1	1600	2018-10-31 11:20:32	2018-10-31	10
4758	2	1600	2018-10-31 11:20:34	2018-10-31	10
4759	3	1600	2018-10-31 11:20:36	2018-10-31	10
4760	1	1601	2018-10-31 11:18:34	2018-10-31	10
4761	2	1601	2018-10-31 11:18:36	2018-10-31	10
4762	3	1601	2018-10-31 11:18:38	2018-10-31	10
4763	1	1602	2018-10-31 11:15:56	2018-10-31	10
4764	2	1602	2018-10-31 11:15:58	2018-10-31	10
4765	3	1602	2018-10-31 11:33:33	2018-10-31	10
4766	1	1603	2018-10-31 11:10:35	2018-10-31	10
4767	2	1603	2018-10-31 11:10:38	2018-10-31	10
4768	3	1603	2018-10-31 11:10:39	2018-10-31	10
4769	1	1604	2018-10-31 11:09:15	2018-10-31	10
4770	2	1604	2018-10-31 11:09:17	2018-10-31	10
4771	3	1604	2018-10-31 11:29:26	2018-10-31	10
4772	1	1605	2018-10-31 11:05:36	2018-10-31	10
4773	2	1605	2018-10-31 11:05:38	2018-10-31	10
4774	3	1605	2018-10-31 11:05:40	2018-10-31	10
4775	1	1606	2018-10-31 11:04:54	2018-10-31	10
4776	2	1606	2018-10-31 11:04:56	2018-10-31	10
4777	3	1606	2018-10-31 11:04:57	2018-10-31	10
4778	1	1607	2018-10-31 10:59:43	2018-10-31	9
4779	2	1607	2018-10-31 10:59:44	2018-10-31	9
4780	3	1607	2018-10-31 10:59:51	2018-10-31	9
4781	1	1608	2018-10-31 10:57:37	2018-10-31	9
4782	2	1608	2018-10-31 10:57:39	2018-10-31	9
4783	3	1608	2018-10-31 10:57:41	2018-10-31	9
4784	1	1609	2018-10-31 10:57:35	2018-10-31	9
4785	2	1609	2018-10-31 10:57:37	2018-10-31	9
4786	3	1609	2018-10-31 10:57:39	2018-10-31	9
4787	1	1610	2018-10-31 10:55:42	2018-10-31	9
4788	2	1610	2018-10-31 10:55:44	2018-10-31	9
4789	3	1610	2018-10-31 10:55:46	2018-10-31	9
4790	1	1611	2018-10-31 10:46:46	2018-10-31	9
4791	2	1611	2018-10-31 10:46:48	2018-10-31	9
4792	3	1611	2018-10-31 10:46:50	2018-10-31	9
4793	1	1612	2018-10-31 10:43:44	2018-10-31	9
4794	2	1612	2018-10-31 10:43:45	2018-10-31	9
4795	3	1612	2018-10-31 10:43:47	2018-10-31	9
4796	1	1613	2018-10-31 10:43:18	2018-10-31	9
4797	2	1613	2018-10-31 10:43:20	2018-10-31	9
4798	3	1613	2018-10-31 10:43:22	2018-10-31	9
4799	1	1614	2018-10-31 10:39:16	2018-10-31	9
4800	2	1614	2018-10-31 10:39:19	2018-10-31	9
4801	3	1614	2018-10-31 10:39:27	2018-10-31	9
4802	1	1615	2018-10-31 10:36:54	2018-10-31	9
4803	2	1615	2018-10-31 10:36:56	2018-10-31	9
4804	3	1615	2018-10-31 10:36:58	2018-10-31	9
4805	1	1616	2018-10-31 10:36:40	2018-10-31	9
4806	2	1616	2018-10-31 10:36:44	2018-10-31	9
4807	3	1616	2018-10-31 10:36:46	2018-10-31	9
4808	1	1617	2018-10-31 10:24:57	2018-10-31	9
4809	2	1617	2018-10-31 10:24:58	2018-10-31	9
4810	3	1617	2018-10-31 10:25:00	2018-10-31	9
4811	1	1618	2018-10-31 10:19:13	2018-10-31	9
4812	2	1618	2018-10-31 10:19:15	2018-10-31	9
4813	3	1618	2018-10-31 10:19:17	2018-10-31	9
4814	1	1619	2018-10-31 10:16:33	2018-10-31	9
4815	2	1619	2018-10-31 10:16:35	2018-10-31	9
4816	3	1619	2018-10-31 10:16:37	2018-10-31	9
4817	1	1620	2018-10-31 10:13:33	2018-10-31	9
4818	2	1620	2018-10-31 10:13:35	2018-10-31	9
4819	3	1620	2018-10-31 10:13:37	2018-10-31	9
4820	1	1621	2018-10-31 10:10:02	2018-10-31	9
4821	2	1621	2018-10-31 10:10:05	2018-10-31	9
4822	3	1621	2018-10-31 10:10:08	2018-10-31	9
4823	1	1622	2018-10-31 10:07:31	2018-10-31	9
4824	2	1622	2018-10-31 10:07:34	2018-10-31	9
4825	3	1622	2018-10-31 10:07:36	2018-10-31	9
4826	1	1623	2018-10-31 10:01:02	2018-10-31	9
4827	2	1623	2018-10-31 10:01:04	2018-10-31	9
4828	3	1623	2018-10-31 10:01:05	2018-10-31	9
4829	1	1624	2018-10-31 10:00:25	2018-10-31	9
4830	2	1624	2018-10-31 10:00:28	2018-10-31	9
4831	3	1624	2018-10-31 10:00:30	2018-10-31	9
4832	1	1625	2018-10-31 09:57:44	2018-10-31	8
4833	2	1625	2018-10-31 09:57:46	2018-10-31	8
4834	3	1625	2018-10-31 09:57:48	2018-10-31	8
4835	1	1626	2018-10-31 09:59:59	2018-10-31	8
4836	2	1626	2018-10-31 10:00:05	2018-10-31	9
4837	3	1626	2018-10-31 10:00:07	2018-10-31	9
4838	1	1627	2018-10-31 09:44:52	2018-10-31	8
4839	2	1627	2018-10-31 09:44:54	2018-10-31	8
4840	3	1627	2018-10-31 09:44:56	2018-10-31	8
4841	1	1628	2018-10-31 11:41:27	2018-10-31	10
4842	2	1628	2018-10-31 11:41:28	2018-10-31	10
4843	3	1628	2018-10-31 11:41:30	2018-10-31	10
4844	1	1629	2018-10-31 09:46:02	2018-10-31	8
4845	2	1629	2018-10-31 09:46:03	2018-10-31	8
4846	3	1629	2018-10-31 10:26:21	2018-10-31	9
4847	1	1630	2018-10-31 09:42:56	2018-10-31	8
4848	2	1630	2018-10-31 09:42:57	2018-10-31	8
4849	3	1630	2018-10-31 09:42:59	2018-10-31	8
4850	1	1631	2018-10-31 09:38:59	2018-10-31	8
4851	2	1631	2018-10-31 09:39:01	2018-10-31	8
4852	3	1631	2018-10-31 09:39:03	2018-10-31	8
4853	1	1632	2018-10-31 09:39:50	2018-10-31	8
4854	2	1632	2018-10-31 09:39:52	2018-10-31	8
4855	3	1632	2018-10-31 09:39:54	2018-10-31	8
4856	1	1633	2018-10-31 09:41:44	2018-10-31	8
4857	2	1633	2018-10-31 09:41:46	2018-10-31	8
4858	3	1633	2018-11-14 12:06:44	2018-11-14	11
4859	1	1634	2018-10-31 09:37:18	2018-10-31	8
4860	2	1634	2018-10-31 09:37:20	2018-10-31	8
4861	3	1634	2018-10-31 09:37:22	2018-10-31	8
4862	1	1635	2018-10-31 09:36:41	2018-10-31	8
4863	2	1635	2018-10-31 09:36:42	2018-10-31	8
4864	3	1635	2018-10-31 09:36:44	2018-10-31	8
4865	1	1636	2018-10-31 09:36:32	2018-10-31	8
4866	2	1636	2018-10-31 09:36:34	2018-10-31	8
4867	3	1636	2018-10-31 09:36:36	2018-10-31	8
4868	1	1637	2018-10-31 09:34:25	2018-10-31	8
4869	2	1637	2018-10-31 09:34:27	2018-10-31	8
4870	3	1637	2018-10-31 09:34:29	2018-10-31	8
4871	1	1638	2018-10-31 09:27:59	2018-10-31	8
4872	2	1638	2018-10-31 09:28:01	2018-10-31	8
4873	3	1638	2018-10-31 09:28:03	2018-10-31	8
4874	1	1639	2018-10-31 09:22:16	2018-10-31	8
4875	2	1639	2018-10-31 09:22:18	2018-10-31	8
4876	3	1639	2018-10-31 09:32:02	2018-10-31	8
4877	1	1640	2018-10-31 09:20:08	2018-10-31	8
4878	2	1640	2018-10-31 09:20:11	2018-10-31	8
4879	3	1640	2018-10-31 09:20:13	2018-10-31	8
4880	1	1641	2018-10-31 09:18:35	2018-10-31	8
4881	2	1641	2018-10-31 09:18:37	2018-10-31	8
4882	3	1641	2018-10-31 09:18:39	2018-10-31	8
4883	1	1642	2018-10-31 09:13:48	2018-10-31	8
4884	2	1642	2018-10-31 09:13:50	2018-10-31	8
4885	3	1642	2018-10-31 09:13:52	2018-10-31	8
4886	1	1643	2018-10-31 09:13:34	2018-10-31	8
4887	2	1643	2018-10-31 09:13:36	2018-10-31	8
4888	3	1643	2018-11-05 17:20:54	2018-11-05	16
4889	1	1644	2018-10-31 09:11:25	2018-10-31	8
4890	2	1644	2018-10-31 09:11:27	2018-10-31	8
4891	3	1644	2018-10-31 09:11:28	2018-10-31	8
4892	1	1645	2018-10-31 09:10:30	2018-10-31	8
4893	2	1645	2018-10-31 09:10:32	2018-10-31	8
4894	3	1645	2018-10-31 09:10:34	2018-10-31	8
4895	1	1646	2018-10-31 09:08:01	2018-10-31	8
4896	2	1646	2018-10-31 09:08:03	2018-10-31	8
4897	3	1646	2018-10-31 09:08:05	2018-10-31	8
4898	1	1647	2018-10-31 09:07:02	2018-10-31	8
4899	2	1647	2018-10-31 09:07:04	2018-10-31	8
4900	3	1647	2018-10-31 09:07:06	2018-10-31	8
4901	1	1648	2018-10-31 09:07:10	2018-10-31	8
4902	2	1648	2018-10-31 09:07:12	2018-10-31	8
4903	3	1648	2018-10-31 09:07:14	2018-10-31	8
4904	1	1649	2018-10-31 08:59:31	2018-10-31	7
4905	2	1649	2018-10-31 08:59:33	2018-10-31	7
4906	3	1649	2018-10-31 08:59:35	2018-10-31	7
4907	1	1650	2018-10-31 08:53:04	2018-10-31	7
4908	2	1650	2018-10-31 08:53:05	2018-10-31	7
4909	3	1650	2018-10-31 08:53:07	2018-10-31	7
4910	1	1651	2018-10-31 08:52:12	2018-10-31	7
4911	2	1651	2018-10-31 08:52:15	2018-10-31	7
4912	3	1651	2018-10-31 08:52:18	2018-10-31	7
4913	1	1652	2018-10-31 08:49:45	2018-10-31	7
4914	2	1652	2018-10-31 08:49:47	2018-10-31	7
4915	3	1652	2018-10-31 08:49:49	2018-10-31	7
4916	1	1653	2018-10-31 08:39:53	2018-10-31	7
4917	2	1653	2018-10-31 08:39:57	2018-10-31	7
4918	3	1653	2018-10-31 08:40:00	2018-10-31	7
4919	1	1654	2018-10-31 08:37:57	2018-10-31	7
4920	2	1654	2018-10-31 08:38:00	2018-10-31	7
4921	3	1654	2018-10-31 08:38:03	2018-10-31	7
4922	1	1655	2018-10-31 08:35:29	2018-10-31	7
4923	2	1655	2018-10-31 08:35:31	2018-10-31	7
4924	3	1655	2018-10-31 08:35:33	2018-10-31	7
4925	1	1656	2018-10-31 08:17:09	2018-10-31	7
4926	2	1656	2018-10-31 08:17:11	2018-10-31	7
4927	3	1656	2018-10-31 08:22:26	2018-10-31	7
4928	1	1657	2018-10-31 08:14:49	2018-10-31	7
4929	2	1657	2018-10-31 08:14:51	2018-10-31	7
4930	3	1657	2018-11-05 15:35:33	2018-11-05	14
4931	1	1658	2018-10-31 08:01:47	2018-10-31	7
4932	2	1658	2018-10-31 08:01:50	2018-10-31	7
4933	3	1658	2018-10-31 08:04:16	2018-10-31	7
4934	1	1659	2018-10-31 07:47:32	2018-10-31	6
4935	2	1659	2018-10-31 07:47:34	2018-10-31	6
4936	3	1659	2018-11-07 15:50:50	2018-11-07	14
4937	1	1660	2018-10-31 07:43:29	2018-10-31	6
4938	2	1660	2018-10-31 07:43:32	2018-10-31	6
4939	3	1660	2018-12-05 13:57:21	2018-12-05	12
4940	1	1661	2018-10-31 07:34:47	2018-10-31	6
4941	2	1661	2018-10-31 07:34:49	2018-10-31	6
4942	3	1661	2018-10-31 07:36:53	2018-10-31	6
4943	1	1662	2018-10-30 17:02:23	2018-10-30	16
4944	2	1662	2018-10-30 17:02:25	2018-10-30	16
4945	3	1662	2018-10-31 09:33:32	2018-10-31	8
4946	1	1663	2018-10-30 17:00:12	2018-10-30	16
4947	2	1663	2018-10-30 17:00:14	2018-10-30	16
4948	3	1663	2018-10-30 17:00:17	2018-10-30	16
4949	1	1664	2018-10-30 16:50:36	2018-10-30	15
4950	2	1664	2018-10-30 16:50:38	2018-10-30	15
4951	3	1664	2018-10-30 16:50:39	2018-10-30	15
4952	1	1665	2018-10-30 16:45:47	2018-10-30	15
4953	2	1665	2018-10-30 16:45:48	2018-10-30	15
4954	3	1665	2018-10-30 16:45:50	2018-10-30	15
4955	1	1666	2018-10-30 16:44:28	2018-10-30	15
4956	2	1666	2018-10-30 16:44:30	2018-10-30	15
4957	3	1666	2018-10-30 16:48:21	2018-10-30	15
4958	1	1667	2018-10-30 16:41:24	2018-10-30	15
4959	2	1667	2018-10-30 16:41:26	2018-10-30	15
4960	3	1667	2018-10-30 16:41:28	2018-10-30	15
4961	1	1668	2018-10-30 16:39:39	2018-10-30	15
4962	2	1668	2018-10-30 16:39:41	2018-10-30	15
4963	3	1668	2018-10-30 16:39:43	2018-10-30	15
4964	1	1669	2018-10-30 16:29:54	2018-10-30	15
4965	2	1669	2018-10-30 16:29:57	2018-10-30	15
4966	3	1669	2018-10-30 16:29:59	2018-10-30	15
4967	1	1670	2018-10-30 16:18:37	2018-10-30	15
4968	2	1670	2018-10-30 16:18:39	2018-10-30	15
4969	3	1670	2018-10-31 08:32:38	2018-10-31	7
4970	1	1671	2018-10-30 16:12:10	2018-10-30	15
4971	2	1671	2018-10-30 16:12:12	2018-10-30	15
4972	3	1671	2018-10-30 16:12:13	2018-10-30	15
4973	1	1672	2018-10-30 16:07:57	2018-10-30	15
4974	2	1672	2018-10-30 16:08:00	2018-10-30	15
4975	3	1672	2018-10-30 16:08:02	2018-10-30	15
4976	1	1673	2018-10-30 16:01:38	2018-10-30	15
4977	2	1673	2018-10-30 16:01:40	2018-10-30	15
4978	3	1673	2018-10-30 16:01:42	2018-10-30	15
4979	1	1674	2018-10-30 15:59:05	2018-10-30	14
4980	2	1674	2018-10-30 15:59:08	2018-10-30	14
4981	3	1674	2018-10-30 15:59:11	2018-10-30	14
4982	1	1675	2018-10-30 15:58:57	2018-10-30	14
4983	2	1675	2018-10-30 15:59:00	2018-10-30	14
4984	3	1675	2018-11-07 15:58:10	2018-11-07	14
4985	1	1676	2018-10-30 16:07:19	2018-10-30	15
4986	2	1676	2018-10-30 16:07:21	2018-10-30	15
4987	3	1676	2018-10-30 16:10:30	2018-10-30	15
4988	1	1677	2018-10-30 15:48:07	2018-10-30	14
4989	2	1677	2018-10-30 15:48:09	2018-10-30	14
4990	3	1677	2018-10-30 15:48:11	2018-10-30	14
4991	1	1678	2018-10-30 15:46:33	2018-10-30	14
4992	2	1678	2018-10-30 15:46:36	2018-10-30	14
4993	3	1678	2018-10-30 15:46:39	2018-10-30	14
4994	1	1679	2018-10-30 15:40:39	2018-10-30	14
4995	2	1679	2018-10-30 15:40:41	2018-10-30	14
4996	3	1679	2018-10-30 15:40:43	2018-10-30	14
4997	1	1680	2018-10-30 15:31:36	2018-10-30	14
4998	2	1680	2018-10-30 15:31:38	2018-10-30	14
4999	3	1680	2018-10-31 07:36:19	2018-10-31	6
5000	1	1681	2018-10-30 15:22:40	2018-10-30	14
5001	2	1681	2018-10-30 15:22:41	2018-10-30	14
5002	3	1681	2018-10-30 15:22:43	2018-10-30	14
5003	1	1682	2018-10-30 15:20:31	2018-10-30	14
5004	2	1682	2018-10-30 15:20:32	2018-10-30	14
5005	3	1682	2018-10-30 15:20:34	2018-10-30	14
5006	1	1683	2018-10-30 15:11:10	2018-10-30	14
5007	2	1683	2018-10-30 15:11:11	2018-10-30	14
5008	3	1683	2018-10-30 15:11:13	2018-10-30	14
5009	1	1684	2018-10-30 14:58:58	2018-10-30	13
5010	2	1684	2018-10-30 14:58:59	2018-10-30	13
5011	3	1684	2018-10-30 14:59:01	2018-10-30	13
5012	1	1685	2018-10-30 14:58:51	2018-10-30	13
5013	2	1685	2018-10-30 14:58:53	2018-10-30	13
5014	3	1685	2018-10-30 14:58:55	2018-10-30	13
5015	1	1686	2018-10-30 14:56:53	2018-10-30	13
5016	2	1686	2018-10-30 14:56:56	2018-10-30	13
5017	3	1686	2018-10-30 14:56:59	2018-10-30	13
5018	1	1687	2018-10-30 14:45:37	2018-10-30	13
5019	2	1687	2018-10-30 14:45:39	2018-10-30	13
5020	3	1687	2018-10-30 14:45:41	2018-10-30	13
5021	1	1688	2018-10-30 14:42:30	2018-10-30	13
5022	2	1688	2018-10-30 14:42:32	2018-10-30	13
5023	3	1688	2018-10-30 14:42:34	2018-10-30	13
5024	1	1689	2018-10-30 14:39:45	2018-10-30	13
5025	2	1689	2018-10-30 14:39:47	2018-10-30	13
5026	3	1689	2018-10-30 14:39:49	2018-10-30	13
5027	1	1690	2018-10-30 14:36:44	2018-10-30	13
5028	2	1690	2018-10-30 14:36:46	2018-10-30	13
5029	3	1690	2018-10-30 14:36:48	2018-10-30	13
5030	1	1691	2018-10-30 14:26:44	2018-10-30	13
5031	2	1691	2018-10-30 14:26:47	2018-10-30	13
5032	3	1691	2018-10-30 14:26:50	2018-10-30	13
5033	1	1692	2018-10-30 14:25:45	2018-10-30	13
5034	2	1692	2018-10-30 14:25:47	2018-10-30	13
5035	3	1692	2018-10-30 14:25:48	2018-10-30	13
5036	1	1693	2018-10-30 14:23:27	2018-10-30	13
5037	2	1693	2018-10-30 14:23:29	2018-10-30	13
5038	3	1693	2018-10-30 14:23:30	2018-10-30	13
5039	1	1694	2018-10-30 14:20:05	2018-10-30	13
5040	2	1694	2018-10-30 14:20:07	2018-10-30	13
5041	3	1694	2018-10-30 14:20:09	2018-10-30	13
5042	1	1695	2018-10-30 14:19:51	2018-10-30	13
5043	2	1695	2018-10-30 14:19:54	2018-10-30	13
5044	3	1695	2018-10-30 14:19:57	2018-10-30	13
5045	1	1696	2018-10-30 14:17:39	2018-10-30	13
5046	2	1696	2018-10-30 14:17:41	2018-10-30	13
5047	3	1696	2018-10-30 15:20:40	2018-10-30	14
5048	1	1697	2018-10-30 14:14:47	2018-10-30	13
5049	2	1697	2018-10-30 14:14:49	2018-10-30	13
5050	3	1697	2018-10-30 14:14:51	2018-10-30	13
5051	1	1698	2018-10-30 14:24:43	2018-10-30	13
5052	2	1698	2018-10-30 14:24:44	2018-10-30	13
5053	3	1698	2018-10-30 14:24:46	2018-10-30	13
5054	1	1699	2018-10-30 14:09:53	2018-10-30	13
5055	2	1699	2018-10-30 14:09:55	2018-10-30	13
5056	3	1699	2018-10-30 14:09:57	2018-10-30	13
5057	1	1700	2018-10-30 14:06:55	2018-10-30	13
5058	2	1700	2018-10-30 14:06:57	2018-10-30	13
5059	3	1700	2018-10-30 14:06:58	2018-10-30	13
5060	1	1701	2018-10-30 14:06:57	2018-10-30	13
5061	2	1701	2018-10-30 14:06:59	2018-10-30	13
5062	3	1701	2018-10-30 14:07:01	2018-10-30	13
5063	1	1702	2018-10-30 14:04:05	2018-10-30	13
5064	2	1702	2018-10-30 14:04:06	2018-10-30	13
5065	3	1702	2018-10-30 14:04:08	2018-10-30	13
5066	1	1703	2018-10-30 14:03:14	2018-10-30	13
5067	2	1703	2018-10-30 14:03:15	2018-10-30	13
5068	3	1703	2018-10-30 14:03:18	2018-10-30	13
5069	1	1704	2018-10-30 12:08:19	2018-10-30	11
5070	2	1704	2018-10-30 12:08:20	2018-10-30	11
5071	3	1704	2018-10-30 12:08:22	2018-10-30	11
5072	1	1705	2018-10-30 12:07:16	2018-10-30	11
5073	2	1705	2018-10-30 12:07:18	2018-10-30	11
5074	3	1705	2018-10-30 12:07:20	2018-10-30	11
5075	1	1706	2018-10-30 11:40:53	2018-10-30	10
5076	2	1706	2018-10-30 11:40:55	2018-10-30	10
5077	3	1706	2018-10-30 11:40:56	2018-10-30	10
5078	1	1707	2018-10-30 11:39:01	2018-10-30	10
5079	2	1707	2018-10-30 11:39:03	2018-10-30	10
5080	3	1707	2018-10-30 11:39:05	2018-10-30	10
5081	1	1708	2018-10-30 11:33:56	2018-10-30	10
5082	2	1708	2018-10-30 11:33:58	2018-10-30	10
5083	3	1708	2018-10-30 11:34:00	2018-10-30	10
5084	1	1709	2018-10-30 11:36:38	2018-10-30	10
5085	2	1709	2018-10-30 11:36:41	2018-10-30	10
5086	3	1709	2018-10-30 15:36:28	2018-10-30	14
5087	1	1710	2018-10-30 11:32:06	2018-10-30	10
5088	2	1710	2018-10-30 11:32:08	2018-10-30	10
5089	3	1710	2018-10-30 11:32:10	2018-10-30	10
5090	1	1711	2018-10-30 11:32:02	2018-10-30	10
5091	2	1711	2018-10-30 11:32:04	2018-10-30	10
5092	3	1711	2018-10-30 11:32:06	2018-10-30	10
5093	1	1712	2018-10-30 11:30:41	2018-10-30	10
5094	2	1712	2018-10-30 11:30:43	2018-10-30	10
5095	3	1712	2018-10-30 11:30:45	2018-10-30	10
5096	1	1713	2018-10-30 11:28:17	2018-10-30	10
5097	2	1713	2018-10-30 11:28:19	2018-10-30	10
5098	3	1713	2018-10-30 11:28:21	2018-10-30	10
5099	1	1714	2018-10-30 11:28:13	2018-10-30	10
5100	2	1714	2018-10-30 11:28:15	2018-10-30	10
5101	3	1714	2018-10-30 11:28:17	2018-10-30	10
5102	1	1715	2018-10-30 11:22:20	2018-10-30	10
5103	2	1715	2018-10-30 11:22:22	2018-10-30	10
5104	3	1715	2018-10-30 11:22:24	2018-10-30	10
5105	1	1716	2018-10-30 11:34:08	2018-10-30	10
5106	2	1716	2018-10-30 11:34:09	2018-10-30	10
5107	3	1716	2018-10-30 11:34:11	2018-10-30	10
5108	1	1717	2018-10-30 11:11:38	2018-10-30	10
5109	2	1717	2018-10-30 11:11:40	2018-10-30	10
5110	3	1717	2018-10-30 11:11:42	2018-10-30	10
5111	1	1718	2018-10-30 11:09:50	2018-10-30	10
5112	2	1718	2018-10-30 11:09:51	2018-10-30	10
5113	3	1718	2018-10-30 11:36:04	2018-10-30	10
5114	1	1719	2018-10-30 11:05:14	2018-10-30	10
5115	2	1719	2018-10-30 11:05:17	2018-10-30	10
5116	3	1719	2018-10-30 11:05:20	2018-10-30	10
5117	1	1720	2018-10-30 11:04:57	2018-10-30	10
5118	2	1720	2018-10-30 11:04:59	2018-10-30	10
5119	3	1720	2018-10-30 11:05:01	2018-10-30	10
5120	1	1721	2018-10-30 11:00:45	2018-10-30	10
5121	2	1721	2018-10-30 11:00:47	2018-10-30	10
5122	3	1721	2018-10-30 11:00:49	2018-10-30	10
5123	1	1722	2018-10-30 10:58:43	2018-10-30	9
5124	2	1722	2018-10-30 10:58:44	2018-10-30	9
5125	3	1722	2018-10-30 10:58:46	2018-10-30	9
5126	1	1723	2018-10-30 10:51:07	2018-10-30	9
5127	2	1723	2018-10-30 10:51:09	2018-10-30	9
5128	3	1723	2018-10-30 10:51:11	2018-10-30	9
5129	1	1724	2018-10-30 10:50:52	2018-10-30	9
5130	2	1724	2018-10-30 10:50:54	2018-10-30	9
5131	3	1724	2018-10-30 10:50:56	2018-10-30	9
5132	1	1725	2018-10-30 10:41:26	2018-10-30	9
5133	2	1725	2018-10-30 10:41:28	2018-10-30	9
5134	3	1725	2018-10-30 10:41:30	2018-10-30	9
5135	1	1726	2018-10-30 10:39:26	2018-10-30	9
5136	2	1726	2018-10-30 10:39:28	2018-10-30	9
5137	3	1726	2018-10-30 10:39:30	2018-10-30	9
5138	1	1727	2018-10-30 10:34:20	2018-10-30	9
5139	2	1727	2018-10-30 10:34:22	2018-10-30	9
5140	3	1727	2018-10-30 10:34:24	2018-10-30	9
5141	1	1728	2018-10-30 10:31:32	2018-10-30	9
5142	2	1728	2018-10-30 10:31:34	2018-10-30	9
5143	3	1728	2018-10-30 12:21:05	2018-10-30	11
5144	1	1729	2018-10-30 10:27:30	2018-10-30	9
5145	2	1729	2018-10-30 10:27:31	2018-10-30	9
5146	3	1729	2018-10-30 10:27:33	2018-10-30	9
5147	1	1730	2018-10-30 10:34:55	2018-10-30	9
5148	2	1730	2018-10-30 10:34:57	2018-10-30	9
5149	3	1730	2018-10-31 13:23:47	2018-10-31	12
5150	1	1731	2018-10-30 10:20:48	2018-10-30	9
5151	2	1731	2018-10-30 10:20:50	2018-10-30	9
5152	3	1731	2018-10-30 10:20:51	2018-10-30	9
5153	1	1732	2018-10-30 10:18:10	2018-10-30	9
5154	2	1732	2018-10-30 10:18:12	2018-10-30	9
5155	3	1732	2018-11-02 15:36:43	2018-11-02	14
5156	1	1733	2018-10-30 10:15:57	2018-10-30	9
5157	2	1733	2018-10-30 10:15:59	2018-10-30	9
5158	3	1733	2018-10-30 10:16:01	2018-10-30	9
5159	1	1734	2018-10-30 10:13:28	2018-10-30	9
5160	2	1734	2018-10-30 10:13:31	2018-10-30	9
5161	3	1734	2018-10-30 10:13:33	2018-10-30	9
5162	1	1735	2018-10-30 10:11:56	2018-10-30	9
5163	2	1735	2018-10-30 10:12:00	2018-10-30	9
5164	3	1735	2018-10-30 10:12:03	2018-10-30	9
5165	1	1736	2018-10-30 09:58:43	2018-10-30	8
5166	2	1736	2018-10-30 09:58:45	2018-10-30	8
5167	3	1736	2018-10-30 09:58:47	2018-10-30	8
5168	1	1737	2018-10-30 10:05:08	2018-10-30	9
5169	2	1737	2018-10-30 10:05:09	2018-10-30	9
5170	3	1737	2018-10-30 15:26:26	2018-10-30	14
5171	1	1738	2018-10-30 09:55:21	2018-10-30	8
5172	2	1738	2018-10-30 09:55:23	2018-10-30	8
5173	3	1738	2018-10-30 09:55:25	2018-10-30	8
5174	1	1739	2018-10-30 09:54:42	2018-10-30	8
5175	2	1739	2018-10-30 09:54:44	2018-10-30	8
5176	3	1739	2018-10-30 09:54:46	2018-10-30	8
5177	1	1740	2018-10-30 09:56:22	2018-10-30	8
5178	2	1740	2018-10-30 09:56:26	2018-10-30	8
5179	3	1740	2018-10-30 09:56:28	2018-10-30	8
5180	1	1741	2018-10-30 09:54:16	2018-10-30	8
5181	2	1741	2018-10-30 09:54:18	2018-10-30	8
5182	3	1741	2018-10-30 09:54:46	2018-10-30	8
5183	1	1742	2018-10-30 09:49:42	2018-10-30	8
5184	2	1742	2018-10-30 09:49:44	2018-10-30	8
5185	3	1742	2018-10-30 09:49:46	2018-10-30	8
5186	1	1743	2018-10-30 09:42:16	2018-10-30	8
5187	2	1743	2018-10-30 09:42:18	2018-10-30	8
5188	3	1743	2018-10-30 09:42:20	2018-10-30	8
5189	1	1744	2018-10-30 09:40:23	2018-10-30	8
5190	2	1744	2018-10-30 09:40:25	2018-10-30	8
5191	3	1744	2018-10-30 09:50:11	2018-10-30	8
5192	1	1745	2018-10-30 09:32:48	2018-10-30	8
5193	2	1745	2018-10-30 09:32:50	2018-10-30	8
5194	3	1745	2018-10-30 09:32:52	2018-10-30	8
5195	1	1746	2018-10-30 09:45:58	2018-10-30	8
5196	2	1746	2018-10-30 09:46:00	2018-10-30	8
5197	3	1746	2018-10-30 09:46:02	2018-10-30	8
5198	1	1747	2018-10-30 09:23:18	2018-10-30	8
5199	2	1747	2018-10-30 09:23:20	2018-10-30	8
5200	3	1747	2018-10-30 09:23:22	2018-10-30	8
5201	1	1748	2018-10-30 09:16:57	2018-10-30	8
5202	2	1748	2018-10-30 09:16:59	2018-10-30	8
5203	3	1748	2018-10-30 09:17:01	2018-10-30	8
5204	1	1749	2018-10-30 09:22:49	2018-10-30	8
5205	2	1749	2018-10-30 09:22:51	2018-10-30	8
5206	3	1749	2018-10-30 10:20:14	2018-10-30	9
5207	1	1750	2018-10-30 09:14:28	2018-10-30	8
5208	2	1750	2018-10-30 09:14:30	2018-10-30	8
5209	3	1750	2018-10-30 09:43:08	2018-10-30	8
5210	1	1751	2018-10-30 09:06:36	2018-10-30	8
5211	2	1751	2018-10-30 09:06:37	2018-10-30	8
5212	3	1751	2018-10-30 09:06:39	2018-10-30	8
5213	1	1752	2018-10-30 09:01:10	2018-10-30	8
5214	2	1752	2018-10-30 09:01:13	2018-10-30	8
5215	3	1752	2018-10-30 09:01:16	2018-10-30	8
5216	1	1753	2018-10-30 08:59:40	2018-10-30	7
5217	2	1753	2018-10-30 08:59:42	2018-10-30	7
5218	3	1753	2018-10-30 08:59:44	2018-10-30	7
5219	1	1754	2018-10-30 09:16:32	2018-10-30	8
5220	2	1754	2018-10-30 09:16:35	2018-10-30	8
5221	3	1754	2018-10-30 09:16:38	2018-10-30	8
5222	1	1755	2018-10-30 08:41:48	2018-10-30	7
5223	2	1755	2018-10-30 08:41:52	2018-10-30	7
5224	3	1755	2018-10-30 08:41:54	2018-10-30	7
5225	1	1756	2018-10-30 08:40:09	2018-10-30	7
5226	2	1756	2018-10-30 08:40:11	2018-10-30	7
5227	3	1756	2018-10-30 08:40:13	2018-10-30	7
5228	1	1757	2018-10-30 08:38:34	2018-10-30	7
5229	2	1757	2018-10-30 08:38:36	2018-10-30	7
5230	3	1757	2018-10-30 08:38:38	2018-10-30	7
5231	1	1758	2018-10-29 17:10:01	2018-10-29	16
5232	2	1758	2018-10-29 17:10:04	2018-10-29	16
5233	3	1758	2018-10-30 17:09:03	2018-10-30	16
5234	1	1759	2018-10-29 16:52:41	2018-10-29	15
5235	2	1759	2018-10-29 16:52:42	2018-10-29	15
5236	3	1759	2018-10-29 16:52:44	2018-10-29	15
5237	1	1760	2018-10-29 16:44:35	2018-10-29	15
5238	2	1760	2018-10-29 16:44:37	2018-10-29	15
5239	3	1760	2018-10-29 16:44:39	2018-10-29	15
5240	1	1761	2018-10-29 16:44:03	2018-10-29	15
5241	2	1761	2018-10-29 16:44:05	2018-10-29	15
5242	3	1761	2018-10-29 16:44:07	2018-10-29	15
5243	1	1762	2018-10-29 16:40:24	2018-10-29	15
5244	2	1762	2018-10-29 16:40:27	2018-10-29	15
5245	3	1762	2018-10-29 16:40:30	2018-10-29	15
5246	1	1763	2018-10-29 16:31:51	2018-10-29	15
5247	2	1763	2018-10-29 16:31:53	2018-10-29	15
5248	3	1763	2018-10-29 16:31:55	2018-10-29	15
5249	1	1764	2018-10-29 16:24:35	2018-10-29	15
5250	2	1764	2018-10-29 16:24:37	2018-10-29	15
5251	3	1764	2018-10-29 16:24:38	2018-10-29	15
5252	1	1765	2018-10-29 16:21:27	2018-10-29	15
5253	2	1765	2018-10-29 16:21:29	2018-10-29	15
5254	3	1765	2018-10-30 08:50:09	2018-10-30	7
5255	1	1766	2018-10-29 16:09:49	2018-10-29	15
5256	2	1766	2018-10-29 16:09:51	2018-10-29	15
5257	3	1766	2018-10-29 16:09:53	2018-10-29	15
5258	1	1767	2018-10-29 16:01:45	2018-10-29	15
5259	2	1767	2018-10-29 16:01:48	2018-10-29	15
5260	3	1767	2018-11-15 11:02:59	2018-11-15	10
5261	1	1768	2018-10-29 15:55:56	2018-10-29	14
5262	2	1768	2018-10-29 15:55:58	2018-10-29	14
5263	3	1768	2018-10-29 15:56:00	2018-10-29	14
5264	1	1769	2018-10-29 15:49:09	2018-10-29	14
5265	2	1769	2018-10-29 15:49:11	2018-10-29	14
5266	3	1769	2018-10-29 15:49:14	2018-10-29	14
5267	1	1770	2018-10-29 15:37:01	2018-10-29	14
5268	2	1770	2018-10-29 15:37:03	2018-10-29	14
5269	3	1770	2018-10-29 15:37:05	2018-10-29	14
5270	1	1771	2018-10-29 15:34:00	2018-10-29	14
5271	2	1771	2018-10-29 15:34:02	2018-10-29	14
5272	3	1771	2018-10-29 15:34:04	2018-10-29	14
5273	1	1772	2018-10-29 15:26:51	2018-10-29	14
5274	2	1772	2018-10-29 15:26:52	2018-10-29	14
5275	3	1772	2018-10-29 15:26:54	2018-10-29	14
5276	1	1773	2018-10-29 15:18:14	2018-10-29	14
5277	2	1773	2018-10-29 15:18:15	2018-10-29	14
5278	3	1773	2018-10-29 15:18:17	2018-10-29	14
5279	1	1774	2018-10-29 15:12:39	2018-10-29	14
5280	2	1774	2018-10-29 15:12:40	2018-10-29	14
5281	3	1774	2018-10-29 15:12:42	2018-10-29	14
5282	1	1775	2018-10-29 15:07:09	2018-10-29	14
5283	2	1775	2018-10-29 15:07:11	2018-10-29	14
5284	3	1775	2018-10-29 15:07:12	2018-10-29	14
5285	1	1776	2018-10-29 15:03:55	2018-10-29	14
5286	2	1776	2018-10-29 15:03:57	2018-10-29	14
5287	3	1776	2018-10-30 09:16:50	2018-10-30	8
5288	1	1777	2018-10-29 14:58:11	2018-10-29	13
5289	2	1777	2018-10-29 14:58:13	2018-10-29	13
5290	3	1777	2018-10-29 14:58:14	2018-10-29	13
5291	1	1778	2018-10-29 14:57:30	2018-10-29	13
5292	2	1778	2018-10-29 14:57:32	2018-10-29	13
5293	3	1778	2018-10-29 14:57:33	2018-10-29	13
5294	1	1779	2018-10-29 14:57:00	2018-10-29	13
5295	2	1779	2018-10-29 14:57:03	2018-10-29	13
5296	3	1779	2018-10-29 14:57:06	2018-10-29	13
5297	1	1780	2018-10-29 14:42:17	2018-10-29	13
5298	2	1780	2018-10-29 14:42:18	2018-10-29	13
5299	3	1780	2018-10-30 09:14:11	2018-10-30	8
5300	1	1781	2018-10-29 14:41:09	2018-10-29	13
5301	2	1781	2018-10-29 14:41:12	2018-10-29	13
5302	3	1781	2018-10-29 14:41:14	2018-10-29	13
5303	1	1782	2018-10-29 14:35:54	2018-10-29	13
5304	2	1782	2018-10-29 14:35:57	2018-10-29	13
5305	3	1782	2018-10-29 14:35:59	2018-10-29	13
5306	1	1783	2018-10-29 14:37:24	2018-10-29	13
5307	2	1783	2018-10-29 14:37:26	2018-10-29	13
5308	3	1783	2018-10-29 14:37:28	2018-10-29	13
5309	1	1784	2018-10-29 14:34:34	2018-10-29	13
5310	2	1784	2018-10-29 14:34:36	2018-10-29	13
5311	3	1784	2018-10-29 14:34:38	2018-10-29	13
5312	1	1785	2018-10-29 14:32:42	2018-10-29	13
5313	2	1785	2018-10-29 14:32:44	2018-10-29	13
5314	3	1785	2018-11-05 12:02:30	2018-11-05	11
5315	1	1786	2018-10-29 14:29:09	2018-10-29	13
5316	2	1786	2018-10-29 14:29:12	2018-10-29	13
5317	3	1786	2018-10-31 10:46:35	2018-10-31	9
5318	1	1787	2018-10-29 14:25:01	2018-10-29	13
5319	2	1787	2018-10-29 14:25:03	2018-10-29	13
5320	3	1787	2018-10-29 14:25:13	2018-10-29	13
5321	1	1788	2018-10-29 14:14:38	2018-10-29	13
5322	2	1788	2018-10-29 14:14:40	2018-10-29	13
5323	3	1788	2018-10-29 14:38:42	2018-10-29	13
5324	1	1789	2018-10-29 14:11:14	2018-10-29	13
5325	2	1789	2018-10-29 14:11:16	2018-10-29	13
5326	3	1789	2018-10-29 14:11:18	2018-10-29	13
5327	1	1790	2018-10-29 14:10:08	2018-10-29	13
5328	2	1790	2018-10-29 14:10:10	2018-10-29	13
5329	3	1790	2018-10-29 14:10:12	2018-10-29	13
5330	1	1791	2018-10-29 14:09:22	2018-10-29	13
5331	2	1791	2018-10-29 14:09:24	2018-10-29	13
5332	3	1791	2018-10-29 14:09:26	2018-10-29	13
5333	1	1792	2018-10-29 14:06:14	2018-10-29	13
5334	2	1792	2018-10-29 14:06:18	2018-10-29	13
5335	3	1792	2018-11-07 16:04:29	2018-11-07	15
5336	1	1793	2018-10-29 13:16:50	2018-10-29	12
5337	2	1793	2018-10-29 13:16:51	2018-10-29	12
5338	3	1793	2018-10-29 15:02:58	2018-10-29	14
5339	1	1794	2018-10-29 13:13:28	2018-10-29	12
5340	2	1794	2018-10-29 13:13:30	2018-10-29	12
5341	3	1794	2018-10-29 13:43:12	2018-10-29	12
5342	1	1795	2018-10-29 12:31:33	2018-10-29	11
5343	2	1795	2018-10-29 12:31:37	2018-10-29	11
5344	3	1795	2018-10-30 17:11:39	2018-10-30	16
5345	1	1796	2018-10-29 12:14:04	2018-10-29	11
5346	2	1796	2018-10-29 12:14:05	2018-10-29	11
5347	3	1796	2018-10-30 08:52:53	2018-10-30	7
5348	1	1797	2018-10-29 12:08:04	2018-10-29	11
5349	2	1797	2018-10-29 12:08:07	2018-10-29	11
5350	3	1797	2018-10-29 12:08:09	2018-10-29	11
5351	1	1798	2018-10-29 12:02:07	2018-10-29	11
5352	2	1798	2018-10-29 12:02:09	2018-10-29	11
5353	3	1798	2018-10-29 12:02:11	2018-10-29	11
5354	1	1799	2018-10-29 12:00:26	2018-10-29	11
5355	2	1799	2018-10-29 12:00:28	2018-10-29	11
5356	3	1799	2018-10-30 11:06:34	2018-10-30	10
5357	1	1800	2018-10-29 11:56:37	2018-10-29	10
5358	2	1800	2018-10-29 11:56:40	2018-10-29	10
5359	3	1800	2018-10-29 11:56:43	2018-10-29	10
5360	1	1801	2018-10-29 11:40:47	2018-10-29	10
5361	2	1801	2018-10-29 11:40:49	2018-10-29	10
5362	3	1801	2018-11-07 16:06:26	2018-11-07	15
5363	1	1802	2018-10-29 11:35:30	2018-10-29	10
5364	2	1802	2018-10-29 11:35:32	2018-10-29	10
5365	3	1802	2018-10-29 11:35:35	2018-10-29	10
5366	1	1803	2018-10-29 11:31:58	2018-10-29	10
5367	2	1803	2018-10-29 11:32:00	2018-10-29	10
5368	3	1803	2018-10-29 11:32:02	2018-10-29	10
5369	1	1804	2018-10-29 11:33:02	2018-10-29	10
5370	2	1804	2018-10-29 11:33:05	2018-10-29	10
5371	3	1804	2018-11-07 16:09:19	2018-11-07	15
5372	1	1805	2018-10-29 11:29:43	2018-10-29	10
5373	2	1805	2018-10-29 11:29:45	2018-10-29	10
5374	3	1805	2018-10-29 11:29:47	2018-10-29	10
5375	1	1806	2018-10-29 11:20:21	2018-10-29	10
5376	2	1806	2018-10-29 11:20:22	2018-10-29	10
5377	3	1806	2018-10-29 11:20:24	2018-10-29	10
5378	1	1807	2018-10-29 11:22:06	2018-10-29	10
5379	2	1807	2018-10-29 11:22:08	2018-10-29	10
5380	3	1807	2018-10-30 14:58:14	2018-10-30	13
5381	1	1808	2018-10-29 11:19:52	2018-10-29	10
5382	2	1808	2018-10-29 11:19:54	2018-10-29	10
5383	3	1808	2018-10-29 11:19:56	2018-10-29	10
5384	1	1809	2018-10-29 11:18:58	2018-10-29	10
5385	2	1809	2018-10-29 11:19:00	2018-10-29	10
5386	3	1809	2018-10-29 11:19:02	2018-10-29	10
5387	1	1810	2018-10-29 10:57:58	2018-10-29	9
5388	2	1810	2018-10-29 10:58:00	2018-10-29	9
5389	3	1810	2018-10-29 10:58:02	2018-10-29	9
5390	1	1811	2018-10-29 10:58:38	2018-10-29	9
5391	2	1811	2018-10-29 10:58:40	2018-10-29	9
5392	3	1811	2018-10-29 11:14:43	2018-10-29	10
5393	1	1812	2018-10-29 10:54:02	2018-10-29	9
5394	2	1812	2018-10-29 10:54:05	2018-10-29	9
5395	3	1812	2018-10-29 10:54:08	2018-10-29	9
5396	1	1813	2018-10-29 10:45:02	2018-10-29	9
5397	2	1813	2018-10-29 10:45:05	2018-10-29	9
5398	3	1813	2018-10-29 10:45:07	2018-10-29	9
5399	1	1814	2018-10-29 10:50:10	2018-10-29	9
5400	2	1814	2018-10-29 10:50:12	2018-10-29	9
5401	3	1814	2018-10-29 11:34:21	2018-10-29	10
5402	1	1815	2018-10-29 10:43:38	2018-10-29	9
5403	2	1815	2018-10-29 10:43:40	2018-10-29	9
5404	3	1815	2018-11-07 16:12:18	2018-11-07	15
5405	1	1816	2018-10-29 10:35:59	2018-10-29	9
5406	2	1816	2018-10-29 10:36:00	2018-10-29	9
5407	3	1816	2018-10-29 10:36:02	2018-10-29	9
5408	1	1817	2018-10-29 10:36:12	2018-10-29	9
5409	2	1817	2018-10-29 10:36:16	2018-10-29	9
5410	3	1817	2018-10-29 10:36:18	2018-10-29	9
5411	1	1818	2018-10-29 10:39:52	2018-10-29	9
5412	2	1818	2018-10-29 10:39:56	2018-10-29	9
5413	3	1818	2018-10-29 10:39:58	2018-10-29	9
5414	1	1819	2018-10-29 10:26:50	2018-10-29	9
5415	2	1819	2018-10-29 10:26:52	2018-10-29	9
5416	3	1819	2018-10-29 10:26:54	2018-10-29	9
5417	1	1820	2018-10-29 10:24:07	2018-10-29	9
5418	2	1820	2018-10-29 10:24:08	2018-10-29	9
5419	3	1820	2018-10-29 10:24:10	2018-10-29	9
5420	1	1821	2018-10-29 10:23:23	2018-10-29	9
5421	2	1821	2018-10-29 10:23:24	2018-10-29	9
5422	3	1821	2018-10-29 10:23:26	2018-10-29	9
5423	1	1822	2018-10-29 10:19:35	2018-10-29	9
5424	2	1822	2018-10-29 10:19:37	2018-10-29	9
5425	3	1822	2018-10-29 10:54:25	2018-10-29	9
5426	1	1823	2018-10-29 10:18:15	2018-10-29	9
5427	2	1823	2018-10-29 10:18:17	2018-10-29	9
5428	3	1823	2018-10-29 10:18:19	2018-10-29	9
5429	1	1824	2018-10-29 10:17:44	2018-10-29	9
5430	2	1824	2018-10-29 10:17:45	2018-10-29	9
5431	3	1824	2018-10-29 10:17:47	2018-10-29	9
5432	1	1825	2018-10-29 10:16:39	2018-10-29	9
5433	2	1825	2018-10-29 10:16:41	2018-10-29	9
5434	3	1825	2018-10-29 10:16:42	2018-10-29	9
5435	1	1826	2018-10-29 10:09:28	2018-10-29	9
5436	2	1826	2018-10-29 10:09:31	2018-10-29	9
5437	3	1826	2018-10-29 10:09:34	2018-10-29	9
5438	1	1827	2018-10-29 10:06:52	2018-10-29	9
5439	2	1827	2018-10-29 10:06:54	2018-10-29	9
5440	3	1827	2018-10-29 10:06:56	2018-10-29	9
5441	1	1828	2018-10-29 10:03:01	2018-10-29	9
5442	2	1828	2018-10-29 10:03:03	2018-10-29	9
5443	3	1828	2018-10-29 10:03:05	2018-10-29	9
5444	1	1829	2018-10-29 09:59:59	2018-10-29	8
5445	2	1829	2018-10-29 10:00:01	2018-10-29	9
5446	3	1829	2018-10-29 10:00:03	2018-10-29	9
5447	1	1830	2018-10-29 09:58:03	2018-10-29	8
5448	2	1830	2018-10-29 09:58:05	2018-10-29	8
5449	3	1830	2018-10-31 11:20:45	2018-10-31	10
5450	1	1831	2018-10-29 09:45:01	2018-10-29	8
5451	2	1831	2018-10-29 09:45:02	2018-10-29	8
5452	3	1831	2018-10-29 09:45:04	2018-10-29	8
5453	1	1832	2018-10-29 09:41:05	2018-10-29	8
5454	2	1832	2018-10-29 09:41:07	2018-10-29	8
5455	3	1832	2018-10-29 09:41:09	2018-10-29	8
5456	1	1833	2018-10-29 09:41:35	2018-10-29	8
5457	2	1833	2018-10-29 09:41:37	2018-10-29	8
5458	3	1833	2018-10-31 11:17:11	2018-10-31	10
5459	1	1834	2018-10-29 09:39:05	2018-10-29	8
5460	2	1834	2018-10-29 09:39:07	2018-10-29	8
5461	3	1834	2018-10-29 09:39:09	2018-10-29	8
5462	1	1835	2018-10-29 09:38:16	2018-10-29	8
5463	2	1835	2018-10-29 09:38:17	2018-10-29	8
5464	3	1835	2018-10-29 09:38:19	2018-10-29	8
5465	1	1836	2018-10-29 09:35:34	2018-10-29	8
5466	2	1836	2018-10-29 09:35:35	2018-10-29	8
5467	3	1836	2018-10-29 09:35:37	2018-10-29	8
5468	1	1837	2018-10-29 09:35:59	2018-10-29	8
5469	2	1837	2018-10-29 09:36:01	2018-10-29	8
5470	3	1837	2018-10-29 09:36:03	2018-10-29	8
5471	1	1838	2018-10-29 09:33:32	2018-10-29	8
5472	2	1838	2018-10-29 09:33:34	2018-10-29	8
5473	3	1838	2018-10-29 09:33:35	2018-10-29	8
5474	1	1839	2018-10-29 09:22:55	2018-10-29	8
5475	2	1839	2018-10-29 09:22:56	2018-10-29	8
5476	3	1839	2018-10-29 09:22:58	2018-10-29	8
5477	1	1840	2018-10-29 09:21:55	2018-10-29	8
5478	2	1840	2018-10-29 09:21:57	2018-10-29	8
5479	3	1840	2018-10-29 10:57:28	2018-10-29	9
5480	1	1841	2018-10-29 09:19:17	2018-10-29	8
5481	2	1841	2018-10-29 09:19:19	2018-10-29	8
5482	3	1841	2018-10-29 09:19:21	2018-10-29	8
5483	1	1842	2018-10-29 09:17:57	2018-10-29	8
5484	2	1842	2018-10-29 09:17:58	2018-10-29	8
5485	3	1842	2018-10-29 09:18:00	2018-10-29	8
5486	1	1843	2018-10-29 09:16:01	2018-10-29	8
5487	2	1843	2018-10-29 09:16:03	2018-10-29	8
5488	3	1843	2018-10-29 09:16:04	2018-10-29	8
5489	1	1844	2018-10-29 09:13:03	2018-10-29	8
5490	2	1844	2018-10-29 09:13:05	2018-10-29	8
5491	3	1844	2018-10-29 09:13:07	2018-10-29	8
5492	1	1845	2018-10-29 09:05:11	2018-10-29	8
5493	2	1845	2018-10-29 09:05:14	2018-10-29	8
5494	3	1845	2018-10-29 09:05:16	2018-10-29	8
5495	1	1846	2018-10-29 08:44:04	2018-10-29	7
5496	2	1846	2018-10-29 08:44:06	2018-10-29	7
5497	3	1846	2018-10-29 08:44:08	2018-10-29	7
5498	1	1847	2018-10-29 08:29:45	2018-10-29	7
5499	2	1847	2018-10-29 08:29:47	2018-10-29	7
5500	3	1847	2018-11-07 16:19:59	2018-11-07	15
5501	1	1848	2018-10-29 08:27:29	2018-10-29	7
5502	2	1848	2018-10-29 08:27:33	2018-10-29	7
5503	3	1848	2018-11-06 11:53:21	2018-11-06	10
5504	1	1849	2018-10-29 08:18:27	2018-10-29	7
5505	2	1849	2018-10-29 08:18:29	2018-10-29	7
5506	3	1849	2018-11-07 16:22:46	2018-11-07	15
5507	1	1850	2018-10-29 08:10:48	2018-10-29	7
5508	2	1850	2018-10-29 08:10:51	2018-10-29	7
5509	3	1850	2018-11-09 10:12:26	2018-11-09	9
5510	1	1851	2018-10-26 18:06:03	2018-10-26	16
5511	2	1851	2018-10-26 18:06:05	2018-10-26	16
5512	3	1851	2018-11-07 16:03:12	2018-11-07	15
5513	1	1852	2018-10-26 16:58:46	2018-10-26	14
5514	2	1852	2018-10-26 16:58:47	2018-10-26	14
5515	3	1852	2018-10-26 16:58:49	2018-10-26	14
5516	1	1853	2018-10-26 16:49:59	2018-10-26	14
5517	2	1853	2018-10-26 16:50:00	2018-10-26	14
5518	3	1853	2018-10-26 16:50:03	2018-10-26	14
5519	1	1854	2018-10-26 16:40:41	2018-10-26	14
5520	2	1854	2018-10-26 16:40:43	2018-10-26	14
5521	3	1854	2018-10-26 16:44:02	2018-10-26	14
5522	1	1855	2018-10-26 16:40:43	2018-10-26	14
5523	2	1855	2018-10-26 16:40:45	2018-10-26	14
5524	3	1855	2018-10-26 16:40:46	2018-10-26	14
5525	1	1856	2018-10-26 16:24:26	2018-10-26	14
5526	2	1856	2018-10-26 16:24:29	2018-10-26	14
5527	3	1856	2018-10-26 16:24:31	2018-10-26	14
5528	1	1857	2018-10-26 16:23:02	2018-10-26	14
5529	2	1857	2018-10-26 16:23:04	2018-10-26	14
5530	3	1857	2018-10-26 16:23:06	2018-10-26	14
5531	1	1858	2018-10-26 16:21:53	2018-10-26	14
5532	2	1858	2018-10-26 16:21:55	2018-10-26	14
5533	3	1858	2018-10-26 16:21:57	2018-10-26	14
5534	1	1859	2018-10-26 16:19:58	2018-10-26	14
5535	2	1859	2018-10-26 16:19:59	2018-10-26	14
5536	3	1859	2018-10-26 16:20:01	2018-10-26	14
5537	1	1860	2018-10-26 16:19:32	2018-10-26	14
5538	2	1860	2018-10-26 16:19:35	2018-10-26	14
5539	3	1860	2018-10-26 16:19:38	2018-10-26	14
5540	1	1861	2018-10-26 15:57:08	2018-10-26	13
5541	2	1861	2018-10-26 15:57:12	2018-10-26	13
5542	3	1861	2018-11-08 09:56:35	2018-11-08	8
5543	1	1862	2018-10-26 15:53:55	2018-10-26	13
5544	2	1862	2018-10-26 15:53:57	2018-10-26	13
5545	3	1862	2018-10-26 15:53:59	2018-10-26	13
5546	1	1863	2018-10-26 15:53:20	2018-10-26	13
5547	2	1863	2018-10-26 15:53:21	2018-10-26	13
5548	3	1863	2018-10-26 15:53:23	2018-10-26	13
5549	1	1864	2018-10-26 15:50:18	2018-10-26	13
5550	2	1864	2018-10-26 15:50:20	2018-10-26	13
5551	3	1864	2018-10-26 16:17:13	2018-10-26	14
5552	1	1865	2018-10-26 15:45:35	2018-10-26	13
5553	2	1865	2018-10-26 15:45:38	2018-10-26	13
5554	3	1865	2018-10-26 15:45:40	2018-10-26	13
5555	1	1866	2018-10-26 15:36:50	2018-10-26	13
5556	2	1866	2018-10-26 15:36:52	2018-10-26	13
5557	3	1866	2018-10-26 15:36:54	2018-10-26	13
5558	1	1867	2018-10-26 15:33:34	2018-10-26	13
5559	2	1867	2018-10-26 15:33:36	2018-10-26	13
5560	3	1867	2018-10-26 15:33:38	2018-10-26	13
5561	1	1868	2018-10-26 15:32:23	2018-10-26	13
5562	2	1868	2018-10-26 15:32:26	2018-10-26	13
5563	3	1868	2018-10-26 15:32:29	2018-10-26	13
5564	1	1869	2018-10-26 15:20:34	2018-10-26	13
5565	2	1869	2018-10-26 15:20:37	2018-10-26	13
5566	3	1869	2018-10-26 15:20:40	2018-10-26	13
5567	1	1870	2018-10-26 15:19:34	2018-10-26	13
5568	2	1870	2018-10-26 15:19:36	2018-10-26	13
5569	3	1870	2018-10-29 09:47:08	2018-10-29	8
5570	1	1871	2018-10-26 15:16:42	2018-10-26	13
5571	2	1871	2018-10-26 15:16:44	2018-10-26	13
5572	3	1871	2018-10-31 11:14:45	2018-10-31	10
5573	1	1872	2018-10-26 15:13:28	2018-10-26	13
5574	2	1872	2018-10-26 15:13:31	2018-10-26	13
5575	3	1872	2018-10-26 15:13:33	2018-10-26	13
5576	1	1873	2018-10-26 15:12:36	2018-10-26	13
5577	2	1873	2018-10-26 15:12:38	2018-10-26	13
5578	3	1873	2018-10-26 15:12:40	2018-10-26	13
5579	1	1874	2018-10-26 15:01:01	2018-10-26	13
5580	2	1874	2018-10-26 15:01:02	2018-10-26	13
5581	3	1874	2018-10-26 15:01:04	2018-10-26	13
5582	1	1875	2018-10-26 14:53:36	2018-10-26	12
5583	2	1875	2018-10-26 14:53:38	2018-10-26	12
5584	3	1875	2018-11-07 10:19:37	2018-11-07	9
5585	1	1876	2018-10-26 14:50:00	2018-10-26	12
5586	2	1876	2018-10-26 14:50:02	2018-10-26	12
5587	3	1876	2018-10-26 14:50:04	2018-10-26	12
5588	1	1877	2018-10-26 14:38:18	2018-10-26	12
5589	2	1877	2018-10-26 14:38:20	2018-10-26	12
5590	3	1877	2018-10-26 14:38:22	2018-10-26	12
5591	1	1878	2018-10-26 14:35:09	2018-10-26	12
5592	2	1878	2018-10-26 14:35:12	2018-10-26	12
5593	3	1878	2018-10-26 14:35:15	2018-10-26	12
5594	1	1879	2018-10-26 14:33:43	2018-10-26	12
5595	2	1879	2018-10-26 14:33:46	2018-10-26	12
5596	3	1879	2018-10-26 14:33:48	2018-10-26	12
5597	1	1880	2018-10-26 14:26:19	2018-10-26	12
5598	2	1880	2018-10-26 14:26:21	2018-10-26	12
5599	3	1880	2018-10-26 14:26:23	2018-10-26	12
5600	1	1881	2018-10-26 14:23:44	2018-10-26	12
5601	2	1881	2018-10-26 14:23:47	2018-10-26	12
5602	3	1881	2018-10-26 14:23:50	2018-10-26	12
5603	1	1882	2018-10-26 14:17:45	2018-10-26	12
5604	2	1882	2018-10-26 14:17:48	2018-10-26	12
5605	3	1882	2018-10-26 14:17:50	2018-10-26	12
5606	1	1883	2018-10-26 14:15:59	2018-10-26	12
5607	2	1883	2018-10-26 14:16:00	2018-10-26	12
5608	3	1883	2018-10-26 14:16:02	2018-10-26	12
5609	1	1884	2018-10-26 14:13:58	2018-10-26	12
5610	2	1884	2018-10-26 14:13:59	2018-10-26	12
5611	3	1884	2018-10-26 14:14:02	2018-10-26	12
5612	1	1885	2018-10-26 14:13:19	2018-10-26	12
5613	2	1885	2018-10-26 14:13:21	2018-10-26	12
5614	3	1885	2018-10-26 14:13:23	2018-10-26	12
5615	1	1886	2018-10-26 14:12:07	2018-10-26	12
5616	2	1886	2018-10-26 14:12:10	2018-10-26	12
5617	3	1886	2018-10-26 14:12:13	2018-10-26	12
5618	1	1887	2018-10-26 14:10:45	2018-10-26	12
5619	2	1887	2018-10-26 14:10:47	2018-10-26	12
5620	3	1887	2018-10-26 14:10:49	2018-10-26	12
5621	1	1888	2018-10-26 14:11:14	2018-10-26	12
5622	2	1888	2018-10-26 14:11:16	2018-10-26	12
5623	3	1888	2018-10-26 14:11:19	2018-10-26	12
5624	1	1889	2018-10-26 14:09:43	2018-10-26	12
5625	2	1889	2018-10-26 14:09:45	2018-10-26	12
5626	3	1889	2018-10-26 14:09:47	2018-10-26	12
5627	1	1890	2018-10-26 14:09:10	2018-10-26	12
5628	2	1890	2018-10-26 14:09:12	2018-10-26	12
5629	3	1890	2018-10-26 14:09:14	2018-10-26	12
5630	1	1891	2018-10-26 14:08:12	2018-10-26	12
5631	2	1891	2018-10-26 14:08:15	2018-10-26	12
5632	3	1891	2018-10-26 14:08:18	2018-10-26	12
5633	1	1892	2018-10-26 14:04:47	2018-10-26	12
5634	2	1892	2018-10-26 14:04:49	2018-10-26	12
5635	3	1892	2018-10-26 14:04:51	2018-10-26	12
5636	1	1893	2018-10-26 12:27:31	2018-10-26	10
5637	2	1893	2018-10-26 12:27:33	2018-10-26	10
5638	3	1893	2018-10-26 12:27:35	2018-10-26	10
5639	1	1894	2018-10-26 12:23:37	2018-10-26	10
5640	2	1894	2018-10-26 12:23:40	2018-10-26	10
5641	3	1894	2018-10-26 12:23:43	2018-10-26	10
5642	1	1895	2018-10-26 12:18:02	2018-10-26	10
5643	2	1895	2018-10-26 12:18:04	2018-10-26	10
5644	3	1895	2018-10-26 12:18:06	2018-10-26	10
5645	1	1896	2018-10-26 12:12:41	2018-10-26	10
5646	2	1896	2018-10-26 12:12:43	2018-10-26	10
5647	3	1896	2018-10-26 12:12:45	2018-10-26	10
5648	1	1897	2018-10-26 11:48:17	2018-10-26	9
5649	2	1897	2018-10-26 11:48:19	2018-10-26	9
5650	3	1897	2018-10-26 11:48:20	2018-10-26	9
5651	1	1898	2018-10-26 11:45:22	2018-10-26	9
5652	2	1898	2018-10-26 11:45:24	2018-10-26	9
5653	3	1898	2018-10-26 11:45:26	2018-10-26	9
5654	1	1899	2018-10-26 11:43:47	2018-10-26	9
5655	2	1899	2018-10-26 11:43:50	2018-10-26	9
5656	3	1899	2018-10-26 11:43:52	2018-10-26	9
5657	1	1900	2018-10-26 11:40:16	2018-10-26	9
5658	2	1900	2018-10-26 11:40:19	2018-10-26	9
5659	3	1900	2018-10-26 11:40:22	2018-10-26	9
5660	1	1901	2018-10-26 11:37:58	2018-10-26	9
5661	2	1901	2018-10-26 11:38:00	2018-10-26	9
5662	1	1902	2018-10-26 11:34:59	2018-10-26	9
5663	2	1902	2018-10-26 11:35:01	2018-10-26	9
5664	3	1902	2018-10-26 11:35:03	2018-10-26	9
5665	1	1903	2018-10-26 11:35:53	2018-10-26	9
5666	2	1903	2018-10-26 11:35:56	2018-10-26	9
5667	3	1903	2018-10-26 11:35:59	2018-10-26	9
5668	1	1904	2018-10-26 11:34:02	2018-10-26	9
5669	2	1904	2018-10-26 11:34:05	2018-10-26	9
5670	3	1904	2018-10-26 11:34:08	2018-10-26	9
5671	1	1905	2018-10-26 11:34:54	2018-10-26	9
5672	2	1905	2018-10-26 11:34:57	2018-10-26	9
5673	3	1905	2018-10-30 09:29:33	2018-10-30	8
5674	1	1906	2018-10-26 11:18:25	2018-10-26	9
5675	2	1906	2018-10-26 11:18:27	2018-10-26	9
5676	3	1906	2018-10-26 11:18:29	2018-10-26	9
5677	1	1907	2018-10-26 11:21:54	2018-10-26	9
5678	2	1907	2018-10-26 11:21:57	2018-10-26	9
5679	3	1907	2018-10-30 07:56:41	2018-10-30	6
5680	1	1908	2018-10-26 11:15:19	2018-10-26	9
5681	2	1908	2018-10-26 11:15:22	2018-10-26	9
5682	3	1908	2018-10-26 11:15:25	2018-10-26	9
5683	1	1909	2018-10-26 11:02:37	2018-10-26	9
5684	2	1909	2018-10-26 11:02:40	2018-10-26	9
5685	3	1909	2018-10-26 11:02:43	2018-10-26	9
5686	1	1910	2018-10-26 11:00:44	2018-10-26	9
5687	2	1910	2018-10-26 11:00:46	2018-10-26	9
5688	3	1910	2018-10-26 11:00:48	2018-10-26	9
5689	1	1911	2018-10-26 10:56:07	2018-10-26	8
5690	2	1911	2018-10-26 10:56:08	2018-10-26	8
5691	3	1911	2018-10-26 10:56:10	2018-10-26	8
5692	1	1912	2018-10-26 10:51:49	2018-10-26	8
5693	2	1912	2018-10-26 10:51:51	2018-10-26	8
5694	3	1912	2018-10-26 10:51:53	2018-10-26	8
5695	1	1913	2018-10-26 10:50:39	2018-10-26	8
5696	2	1913	2018-10-26 10:50:40	2018-10-26	8
5697	3	1913	2018-10-26 10:50:42	2018-10-26	8
5698	1	1914	2018-10-26 10:50:09	2018-10-26	8
5699	2	1914	2018-10-26 10:50:11	2018-10-26	8
5700	3	1914	2018-10-26 10:50:14	2018-10-26	8
5701	1	1915	2018-10-26 10:48:42	2018-10-26	8
5702	2	1915	2018-10-26 10:48:43	2018-10-26	8
5703	3	1915	2018-10-26 10:48:45	2018-10-26	8
5704	1	1916	2018-10-26 10:47:06	2018-10-26	8
5705	2	1916	2018-10-26 10:47:07	2018-10-26	8
5706	3	1916	2018-10-26 10:47:09	2018-10-26	8
5707	1	1917	2018-10-26 10:48:23	2018-10-26	8
5708	2	1917	2018-10-26 10:48:25	2018-10-26	8
5709	3	1917	2018-10-26 10:48:27	2018-10-26	8
5710	1	1918	2018-10-26 10:46:29	2018-10-26	8
5711	2	1918	2018-10-26 10:46:32	2018-10-26	8
5712	3	1918	2018-10-26 10:46:34	2018-10-26	8
5713	1	1919	2018-10-26 14:39:39	2018-10-26	12
5714	2	1919	2018-10-26 14:39:42	2018-10-26	12
5715	3	1919	2018-10-26 14:39:44	2018-10-26	12
5716	1	1920	2018-10-26 10:30:34	2018-10-26	8
5717	2	1920	2018-10-26 10:30:38	2018-10-26	8
5718	3	1920	2018-10-26 12:01:32	2018-10-26	10
5719	1	1921	2018-10-26 10:27:33	2018-10-26	8
5720	2	1921	2018-10-26 10:27:35	2018-10-26	8
5721	3	1921	2018-10-26 10:27:37	2018-10-26	8
5722	1	1922	2018-10-26 10:26:45	2018-10-26	8
5723	2	1922	2018-10-26 10:26:47	2018-10-26	8
5724	3	1922	2018-10-26 10:26:49	2018-10-26	8
5725	1	1923	2018-10-26 10:23:09	2018-10-26	8
5726	2	1923	2018-10-26 10:23:11	2018-10-26	8
5727	3	1923	2018-10-26 10:23:13	2018-10-26	8
5728	1	1924	2018-10-26 10:12:21	2018-10-26	8
5729	2	1924	2018-10-26 10:12:22	2018-10-26	8
5730	3	1924	2018-10-26 10:12:24	2018-10-26	8
5731	1	1925	2018-10-26 10:13:39	2018-10-26	8
5732	2	1925	2018-10-26 10:13:41	2018-10-26	8
5733	3	1925	2018-10-26 10:13:43	2018-10-26	8
5734	1	1926	2018-10-26 10:11:43	2018-10-26	8
5735	2	1926	2018-10-26 10:11:45	2018-10-26	8
5736	3	1926	2018-10-26 10:11:47	2018-10-26	8
5737	1	1927	2018-10-26 10:10:02	2018-10-26	8
5738	2	1927	2018-10-26 10:10:04	2018-10-26	8
5739	3	1927	2018-10-26 11:30:00	2018-10-26	9
5740	1	1928	2018-10-26 10:07:29	2018-10-26	8
5741	2	1928	2018-10-26 10:07:31	2018-10-26	8
5742	3	1928	2018-10-26 10:32:47	2018-10-26	8
5743	1	1929	2018-10-26 10:04:30	2018-10-26	8
5744	2	1929	2018-10-26 10:04:33	2018-10-26	8
5745	3	1929	2018-10-26 10:21:44	2018-10-26	8
5746	1	1930	2018-10-26 09:58:58	2018-10-26	7
5747	2	1930	2018-10-26 09:59:00	2018-10-26	7
5748	3	1930	2018-10-26 09:59:02	2018-10-26	7
5749	1	1931	2018-10-26 09:52:40	2018-10-26	7
5750	2	1931	2018-10-26 09:52:41	2018-10-26	7
5751	3	1931	2018-10-26 09:52:43	2018-10-26	7
5752	1	1932	2018-10-26 09:43:09	2018-10-26	7
5753	2	1932	2018-10-26 09:43:11	2018-10-26	7
5754	3	1932	2018-10-26 09:43:13	2018-10-26	7
5755	1	1933	2018-10-26 09:42:19	2018-10-26	7
5756	2	1933	2018-10-26 09:42:21	2018-10-26	7
5757	3	1933	2018-10-26 09:42:23	2018-10-26	7
5758	1	1934	2018-10-26 09:31:45	2018-10-26	7
5759	2	1934	2018-10-26 09:31:48	2018-10-26	7
5760	3	1934	2018-11-08 09:58:27	2018-11-08	8
5761	1	1935	2018-10-26 09:29:50	2018-10-26	7
5762	2	1935	2018-10-26 09:29:52	2018-10-26	7
5763	3	1935	2018-10-26 09:29:53	2018-10-26	7
5764	1	1936	2018-10-26 09:26:55	2018-10-26	7
5765	2	1936	2018-10-26 09:26:57	2018-10-26	7
5766	3	1936	2018-10-26 11:32:19	2018-10-26	9
5767	1	1937	2018-10-26 09:17:16	2018-10-26	7
5768	2	1937	2018-10-26 09:17:20	2018-10-26	7
5769	3	1937	2018-10-26 09:17:22	2018-10-26	7
5770	1	1938	2018-10-26 09:14:22	2018-10-26	7
5771	2	1938	2018-10-26 09:14:25	2018-10-26	7
5772	3	1938	2018-10-26 09:14:28	2018-10-26	7
5773	1	1939	2018-10-26 09:13:39	2018-10-26	7
5774	2	1939	2018-10-26 09:13:42	2018-10-26	7
5775	3	1939	2018-10-26 10:29:34	2018-10-26	8
5776	1	1940	2018-10-26 09:09:36	2018-10-26	7
5777	2	1940	2018-10-26 09:09:38	2018-10-26	7
5778	3	1940	2018-10-26 09:09:40	2018-10-26	7
5779	1	1941	2018-10-26 09:07:48	2018-10-26	7
5780	2	1941	2018-10-26 09:07:50	2018-10-26	7
5781	3	1941	2018-10-26 09:07:52	2018-10-26	7
5782	1	1942	2018-10-26 09:06:22	2018-10-26	7
5783	2	1942	2018-10-26 09:06:24	2018-10-26	7
5784	3	1942	2018-10-26 09:06:26	2018-10-26	7
5785	1	1943	2018-10-26 09:04:48	2018-10-26	7
5786	2	1943	2018-10-26 09:04:51	2018-10-26	7
5787	3	1943	2018-10-26 09:04:54	2018-10-26	7
5788	1	1944	2018-10-26 09:02:16	2018-10-26	7
5789	2	1944	2018-10-26 09:02:18	2018-10-26	7
5790	3	1944	2018-10-26 09:02:20	2018-10-26	7
5791	1	1945	2018-10-26 08:48:49	2018-10-26	6
5792	2	1945	2018-10-26 08:48:52	2018-10-26	6
5793	3	1945	2018-10-26 08:48:54	2018-10-26	6
5794	1	1946	2018-10-26 08:45:40	2018-10-26	6
5795	2	1946	2018-10-26 08:45:43	2018-10-26	6
5796	3	1946	2018-10-26 08:54:09	2018-10-26	6
5797	1	1947	2018-10-26 08:38:24	2018-10-26	6
5798	2	1947	2018-10-26 08:38:27	2018-10-26	6
5799	3	1947	2018-11-08 09:59:58	2018-11-08	8
5800	1	1948	2018-10-25 16:53:58	2018-10-25	14
5801	2	1948	2018-10-25 16:53:59	2018-10-25	14
5802	3	1948	2018-10-25 16:54:01	2018-10-25	14
5803	1	1949	2018-10-25 16:47:27	2018-10-25	14
5804	2	1949	2018-10-25 16:47:29	2018-10-25	14
5805	3	1949	2018-10-25 16:47:31	2018-10-25	14
5806	1	1950	2018-10-25 16:37:17	2018-10-25	14
5807	2	1950	2018-10-25 16:37:19	2018-10-25	14
5808	3	1950	2018-10-25 16:37:21	2018-10-25	14
5809	1	1951	2018-10-25 16:31:49	2018-10-25	14
5810	2	1951	2018-10-25 16:31:51	2018-10-25	14
5811	3	1951	2018-10-25 16:31:53	2018-10-25	14
5812	1	1952	2018-10-25 16:30:44	2018-10-25	14
5813	2	1952	2018-10-25 16:30:47	2018-10-25	14
5814	3	1952	2018-10-25 16:30:50	2018-10-25	14
5815	1	1953	2018-10-25 16:23:36	2018-10-25	14
5816	2	1953	2018-10-25 16:23:38	2018-10-25	14
5817	3	1953	2018-10-25 16:23:40	2018-10-25	14
5818	1	1954	2018-10-25 16:24:40	2018-10-25	14
5819	2	1954	2018-10-25 16:24:43	2018-10-25	14
5820	3	1954	2018-10-25 16:24:45	2018-10-25	14
5821	1	1955	2018-10-25 16:21:16	2018-10-25	14
5822	2	1955	2018-10-25 16:21:18	2018-10-25	14
5823	3	1955	2018-10-25 16:21:20	2018-10-25	14
5824	1	1956	2018-10-25 16:22:55	2018-10-25	14
5825	2	1956	2018-10-25 16:22:58	2018-10-25	14
5826	3	1956	2018-10-25 16:23:04	2018-10-25	14
5827	1	1957	2018-10-25 16:19:32	2018-10-25	14
5828	2	1957	2018-10-25 16:19:34	2018-10-25	14
5829	3	1957	2018-10-25 16:19:36	2018-10-25	14
5830	1	1958	2018-10-25 16:04:08	2018-10-25	14
5831	2	1958	2018-10-25 16:04:11	2018-10-25	14
5832	3	1958	2018-10-25 16:04:14	2018-10-25	14
5833	1	1959	2018-10-25 16:01:58	2018-10-25	14
5834	2	1959	2018-10-25 16:02:00	2018-10-25	14
5835	3	1959	2018-10-25 16:02:01	2018-10-25	14
5836	1	1960	2018-10-25 15:50:20	2018-10-25	13
5837	2	1960	2018-10-25 15:50:22	2018-10-25	13
5838	3	1960	2018-10-25 15:50:24	2018-10-25	13
5839	1	1961	2018-10-25 15:46:02	2018-10-25	13
5840	2	1961	2018-10-25 15:46:06	2018-10-25	13
5841	3	1961	2018-10-25 15:46:08	2018-10-25	13
5842	1	1962	2018-10-25 15:42:47	2018-10-25	13
5843	2	1962	2018-10-25 15:42:49	2018-10-25	13
5844	3	1962	2018-11-07 09:17:08	2018-11-07	8
5845	1	1963	2018-10-25 15:30:30	2018-10-25	13
5846	2	1963	2018-10-25 15:30:32	2018-10-25	13
5847	3	1963	2018-10-25 15:30:34	2018-10-25	13
5848	1	1964	2018-10-25 15:25:31	2018-10-25	13
5849	2	1964	2018-10-25 15:25:33	2018-10-25	13
5850	3	1964	2018-10-25 15:25:35	2018-10-25	13
5851	1	1965	2018-10-25 15:26:59	2018-10-25	13
5852	2	1965	2018-10-25 15:27:01	2018-10-25	13
5853	3	1965	2018-11-05 10:28:51	2018-11-05	9
5854	1	1966	2018-10-25 15:14:17	2018-10-25	13
5855	2	1966	2018-10-25 15:14:21	2018-10-25	13
5856	3	1966	2018-10-25 15:14:23	2018-10-25	13
5857	1	1967	2018-10-25 15:12:47	2018-10-25	13
5858	2	1967	2018-10-25 15:12:50	2018-10-25	13
5859	3	1967	2018-11-08 10:03:00	2018-11-08	9
5860	1	1968	2018-10-25 15:09:08	2018-10-25	13
5861	2	1968	2018-10-25 15:09:10	2018-10-25	13
5862	3	1968	2018-10-25 15:09:12	2018-10-25	13
5863	1	1969	2018-10-25 14:55:33	2018-10-25	12
5864	2	1969	2018-10-25 14:55:35	2018-10-25	12
5865	3	1969	2018-10-25 14:55:36	2018-10-25	12
5866	1	1970	2018-10-25 14:48:06	2018-10-25	12
5867	2	1970	2018-10-25 14:48:08	2018-10-25	12
5868	3	1970	2018-10-25 14:48:09	2018-10-25	12
5869	1	1971	2018-10-25 14:40:38	2018-10-25	12
5870	2	1971	2018-10-25 14:40:40	2018-10-25	12
5871	3	1971	2018-10-25 14:40:43	2018-10-25	12
5872	1	1972	2018-10-25 14:40:21	2018-10-25	12
5873	2	1972	2018-10-25 14:40:23	2018-10-25	12
5874	3	1972	2018-10-25 14:40:26	2018-10-25	12
5875	1	1973	2018-10-25 14:38:02	2018-10-25	12
5876	2	1973	2018-10-25 14:38:05	2018-10-25	12
5877	3	1973	2018-10-25 14:38:06	2018-10-25	12
5878	1	1974	2018-10-25 14:37:33	2018-10-25	12
5879	2	1974	2018-10-25 14:37:34	2018-10-25	12
5880	3	1974	2018-10-25 14:37:36	2018-10-25	12
5881	1	1975	2018-10-25 14:39:15	2018-10-25	12
5882	2	1975	2018-10-25 14:39:17	2018-10-25	12
5883	3	1975	2018-10-26 09:38:00	2018-10-26	7
5884	1	1976	2018-10-25 14:33:22	2018-10-25	12
5885	2	1976	2018-10-25 14:33:26	2018-10-25	12
5886	3	1976	2018-10-25 14:33:28	2018-10-25	12
5887	1	1977	2018-10-25 14:29:10	2018-10-25	12
5888	2	1977	2018-10-25 14:29:12	2018-10-25	12
5889	3	1977	2018-10-25 14:29:13	2018-10-25	12
5890	1	1978	2018-10-25 14:26:56	2018-10-25	12
5891	2	1978	2018-10-25 14:26:57	2018-10-25	12
5892	3	1978	2018-10-25 14:26:59	2018-10-25	12
5893	1	1979	2018-10-25 14:21:09	2018-10-25	12
5894	2	1979	2018-10-25 14:21:11	2018-10-25	12
5895	3	1979	2018-10-25 14:21:13	2018-10-25	12
5896	1	1980	2018-10-25 14:18:48	2018-10-25	12
5897	2	1980	2018-10-25 14:18:49	2018-10-25	12
5898	3	1980	2018-10-25 14:18:51	2018-10-25	12
5899	1	1981	2018-10-25 14:16:06	2018-10-25	12
5900	2	1981	2018-10-25 14:16:08	2018-10-25	12
5901	3	1981	2018-10-25 14:16:10	2018-10-25	12
5902	1	1982	2018-10-25 14:17:24	2018-10-25	12
5903	2	1982	2018-10-25 14:17:25	2018-10-25	12
5904	3	1982	2018-11-08 10:09:56	2018-11-08	9
5905	1	1983	2018-10-25 14:14:10	2018-10-25	12
5906	2	1983	2018-10-25 14:14:11	2018-10-25	12
5907	3	1983	2018-10-25 14:14:13	2018-10-25	12
5908	1	1984	2018-10-25 14:07:46	2018-10-25	12
5909	2	1984	2018-10-25 14:07:47	2018-10-25	12
5910	3	1984	2018-10-25 14:07:49	2018-10-25	12
5911	1	1985	2018-10-25 14:14:46	2018-10-25	12
5912	2	1985	2018-10-25 14:14:49	2018-10-25	12
5913	3	1985	2018-11-22 11:25:20	2018-11-22	10
5914	1	1986	2018-10-25 12:21:34	2018-10-25	10
5915	2	1986	2018-10-25 12:21:37	2018-10-25	10
5916	3	1986	2018-10-25 12:21:38	2018-10-25	10
5917	1	1987	2018-10-25 12:18:35	2018-10-25	10
5918	2	1987	2018-10-25 12:18:38	2018-10-25	10
5919	3	1987	2018-10-25 12:18:42	2018-10-25	10
5920	1	1988	2018-10-25 12:07:57	2018-10-25	10
5921	2	1988	2018-10-25 12:08:00	2018-10-25	10
5922	3	1988	2018-10-25 12:08:02	2018-10-25	10
5923	1	1989	2018-10-25 12:07:54	2018-10-25	10
5924	2	1989	2018-10-25 12:07:56	2018-10-25	10
5925	3	1989	2018-10-25 12:10:59	2018-10-25	10
5926	1	1990	2018-10-25 12:02:35	2018-10-25	10
5927	2	1990	2018-10-25 12:02:38	2018-10-25	10
5928	3	1990	2018-10-25 12:02:40	2018-10-25	10
5929	1	1991	2018-10-25 12:00:36	2018-10-25	10
5930	2	1991	2018-10-25 12:00:38	2018-10-25	10
5931	3	1991	2018-10-25 15:22:43	2018-10-25	13
5932	1	1992	2018-10-25 11:47:34	2018-10-25	9
5933	2	1992	2018-10-25 11:47:37	2018-10-25	9
5934	3	1992	2018-10-25 11:47:39	2018-10-25	9
5935	1	1993	2018-10-25 11:45:04	2018-10-25	9
5936	2	1993	2018-10-25 11:45:06	2018-10-25	9
5937	3	1993	2018-10-25 11:45:14	2018-10-25	9
5938	1	1994	2018-10-25 11:37:45	2018-10-25	9
5939	2	1994	2018-10-25 11:37:47	2018-10-25	9
5940	3	1994	2018-10-25 11:37:49	2018-10-25	9
5941	1	1995	2018-10-25 11:34:29	2018-10-25	9
5942	2	1995	2018-10-25 11:34:31	2018-10-25	9
5943	3	1995	2018-10-25 11:34:33	2018-10-25	9
5944	1	1996	2018-10-25 11:36:38	2018-10-25	9
5945	2	1996	2018-10-25 11:36:41	2018-10-25	9
5946	3	1996	2018-10-26 14:01:17	2018-10-26	12
5947	1	1997	2018-10-25 11:29:52	2018-10-25	9
5948	2	1997	2018-10-25 11:29:54	2018-10-25	9
5949	3	1997	2018-10-26 15:09:07	2018-10-26	13
5950	1	1998	2018-10-25 11:26:19	2018-10-25	9
5951	2	1998	2018-10-25 11:26:21	2018-10-25	9
5952	3	1998	2018-10-25 11:26:23	2018-10-25	9
5953	1	1999	2018-10-25 11:23:07	2018-10-25	9
5954	2	1999	2018-10-25 11:23:09	2018-10-25	9
5955	3	1999	2018-11-07 14:05:29	2018-11-07	13
5956	1	2000	2018-10-25 11:20:09	2018-10-25	9
5957	2	2000	2018-10-25 11:20:11	2018-10-25	9
5958	3	2000	2018-10-25 11:20:13	2018-10-25	9
5959	1	2001	2018-10-25 11:14:24	2018-10-25	9
5960	2	2001	2018-10-25 11:14:27	2018-10-25	9
5961	3	2001	2018-10-25 11:14:30	2018-10-25	9
5962	1	2002	2018-10-25 11:13:30	2018-10-25	9
5963	2	2002	2018-10-25 11:13:33	2018-10-25	9
5964	3	2002	2018-10-26 14:08:32	2018-10-26	12
5965	1	2003	2018-10-25 11:09:00	2018-10-25	9
5966	2	2003	2018-10-25 11:09:03	2018-10-25	9
5967	3	2003	2018-10-26 14:54:54	2018-10-26	12
5968	1	2004	2018-10-25 10:59:06	2018-10-25	8
5969	2	2004	2018-10-25 10:59:08	2018-10-25	8
5970	3	2004	2018-10-25 10:59:10	2018-10-25	8
5971	1	2005	2018-10-25 10:59:06	2018-10-25	8
5972	2	2005	2018-10-25 10:59:08	2018-10-25	8
5973	3	2005	2018-10-25 10:59:11	2018-10-25	8
5974	1	2006	2018-10-25 11:00:00	2018-10-25	9
5975	2	2006	2018-10-25 11:00:02	2018-10-25	9
5976	3	2006	2018-10-26 07:52:25	2018-10-26	5
5977	1	2007	2018-10-25 10:54:37	2018-10-25	8
5978	2	2007	2018-10-25 10:54:39	2018-10-25	8
5979	3	2007	2018-10-25 11:00:34	2018-10-25	9
5980	1	2008	2018-10-25 10:45:56	2018-10-25	8
5981	2	2008	2018-10-25 10:45:57	2018-10-25	8
5982	3	2008	2018-10-25 10:45:59	2018-10-25	8
5983	1	2009	2018-10-25 10:39:15	2018-10-25	8
5984	2	2009	2018-10-25 10:39:17	2018-10-25	8
5985	3	2009	2018-10-25 10:39:19	2018-10-25	8
5986	1	2010	2018-10-25 10:36:06	2018-10-25	8
5987	2	2010	2018-10-25 10:36:08	2018-10-25	8
5988	3	2010	2018-10-25 14:07:33	2018-10-25	12
5989	1	2011	2018-10-25 10:34:59	2018-10-25	8
5990	2	2011	2018-10-25 10:35:01	2018-10-25	8
5991	3	2011	2018-10-25 11:40:58	2018-10-25	9
5992	1	2012	2018-10-25 10:26:10	2018-10-25	8
5993	2	2012	2018-10-25 10:26:12	2018-10-25	8
5994	3	2012	2018-10-26 13:43:39	2018-10-26	11
5995	1	2013	2018-10-25 10:17:29	2018-10-25	8
5996	2	2013	2018-10-25 10:17:31	2018-10-25	8
5997	3	2013	2018-10-25 10:17:33	2018-10-25	8
5998	1	2014	2018-10-25 10:07:19	2018-10-25	8
5999	2	2014	2018-10-25 10:07:22	2018-10-25	8
6000	3	2014	2018-10-25 10:07:24	2018-10-25	8
6001	1	2015	2018-10-25 10:02:35	2018-10-25	8
6002	2	2015	2018-10-25 10:02:37	2018-10-25	8
6003	3	2015	2018-10-25 10:02:38	2018-10-25	8
6004	1	2016	2018-10-25 10:13:36	2018-10-25	8
6005	2	2016	2018-10-25 10:13:39	2018-10-25	8
6006	3	2016	2018-10-25 10:13:42	2018-10-25	8
6007	1	2017	2018-10-25 10:03:08	2018-10-25	8
6008	2	2017	2018-10-25 10:03:11	2018-10-25	8
6009	3	2017	2018-10-25 15:17:09	2018-10-25	13
6010	1	2018	2018-10-25 09:55:15	2018-10-25	7
6011	2	2018	2018-10-25 09:55:17	2018-10-25	7
6012	3	2018	2018-10-25 09:55:19	2018-10-25	7
6013	1	2019	2018-10-25 09:55:10	2018-10-25	7
6014	2	2019	2018-10-25 09:55:14	2018-10-25	7
6015	3	2019	2018-10-25 09:55:16	2018-10-25	7
6016	1	2020	2018-10-25 09:51:10	2018-10-25	7
6017	2	2020	2018-10-25 09:51:12	2018-10-25	7
6018	3	2020	2018-10-25 09:52:44	2018-10-25	7
6019	1	2021	2018-10-25 09:46:06	2018-10-25	7
6020	2	2021	2018-10-25 09:46:08	2018-10-25	7
6021	3	2021	2018-10-25 10:39:25	2018-10-25	8
6022	1	2022	2018-10-25 09:46:34	2018-10-25	7
6023	2	2022	2018-10-25 09:46:36	2018-10-25	7
6024	3	2022	2018-10-25 11:26:54	2018-10-25	9
6025	1	2023	2018-10-25 09:42:34	2018-10-25	7
6026	2	2023	2018-10-25 09:42:37	2018-10-25	7
6027	3	2023	2018-10-25 10:35:07	2018-10-25	8
6028	1	2024	2018-10-25 09:35:21	2018-10-25	7
6029	2	2024	2018-10-25 09:35:23	2018-10-25	7
6030	3	2024	2018-10-25 09:35:25	2018-10-25	7
6031	1	2025	2018-10-25 09:32:49	2018-10-25	7
6032	2	2025	2018-10-25 09:32:51	2018-10-25	7
6033	3	2025	2018-10-25 09:32:54	2018-10-25	7
6034	1	2026	2018-10-25 09:30:07	2018-10-25	7
6035	2	2026	2018-10-25 09:30:09	2018-10-25	7
6036	3	2026	2018-10-25 09:30:11	2018-10-25	7
6037	1	2027	2018-10-25 09:28:01	2018-10-25	7
6038	2	2027	2018-10-25 09:28:03	2018-10-25	7
6039	3	2027	2018-10-25 09:28:05	2018-10-25	7
6040	1	2028	2018-10-25 09:27:11	2018-10-25	7
6041	2	2028	2018-10-25 09:27:14	2018-10-25	7
6042	3	2028	2018-10-25 10:50:56	2018-10-25	8
6043	1	2029	2018-10-25 09:19:53	2018-10-25	7
6044	2	2029	2018-10-25 09:19:55	2018-10-25	7
6045	3	2029	2018-10-25 09:45:12	2018-10-25	7
6046	1	2030	2018-10-25 09:17:17	2018-10-25	7
6047	2	2030	2018-10-25 09:17:19	2018-10-25	7
6048	3	2030	2018-10-25 09:17:21	2018-10-25	7
6049	1	2031	2018-10-25 09:17:54	2018-10-25	7
6050	2	2031	2018-10-25 09:17:57	2018-10-25	7
6051	3	2031	2018-10-25 10:15:04	2018-10-25	8
6052	1	2032	2018-10-25 09:08:16	2018-10-25	7
6053	2	2032	2018-10-25 09:08:18	2018-10-25	7
6054	3	2032	2018-10-25 09:46:46	2018-10-25	7
6055	1	2033	2018-10-25 09:01:10	2018-10-25	7
6056	2	2033	2018-10-25 09:01:12	2018-10-25	7
6057	3	2033	2018-10-25 10:05:02	2018-10-25	8
6058	1	2034	2018-10-25 08:45:12	2018-10-25	6
6059	2	2034	2018-10-25 08:45:16	2018-10-25	6
6060	3	2034	2018-10-26 07:38:21	2018-10-26	5
6061	1	2035	2018-10-25 08:42:26	2018-10-25	6
6062	2	2035	2018-10-25 08:42:28	2018-10-25	6
6063	3	2035	2018-11-30 11:59:31	2018-11-30	10
6064	1	2036	2018-10-25 07:40:36	2018-10-25	5
6065	2	2036	2018-10-25 07:40:40	2018-10-25	5
6066	3	2036	2018-10-25 08:59:03	2018-10-25	6
6067	1	2037	2018-10-24 18:02:15	2018-10-24	16
6068	2	2037	2018-10-24 18:02:18	2018-10-24	16
6069	3	2037	2018-10-25 11:44:24	2018-10-25	9
6070	1	2038	2018-10-24 16:50:33	2018-10-24	14
6071	2	2038	2018-10-24 16:50:35	2018-10-24	14
6072	3	2038	2018-10-24 16:50:37	2018-10-24	14
6073	1	2039	2018-10-24 16:43:31	2018-10-24	14
6074	2	2039	2018-10-24 16:43:33	2018-10-24	14
6075	3	2039	2018-10-24 16:43:35	2018-10-24	14
6076	1	2040	2018-10-24 16:42:58	2018-10-24	14
6077	2	2040	2018-10-24 16:43:00	2018-10-24	14
6078	3	2040	2018-10-25 09:31:40	2018-10-25	7
6079	1	2041	2018-10-24 16:38:47	2018-10-24	14
6080	2	2041	2018-10-24 16:38:49	2018-10-24	14
6081	3	2041	2018-10-24 16:38:51	2018-10-24	14
6082	1	2042	2018-10-24 16:25:26	2018-10-24	14
6083	2	2042	2018-10-24 16:25:28	2018-10-24	14
6084	3	2042	2018-10-25 07:55:20	2018-10-25	5
6085	1	2043	2018-10-24 16:09:11	2018-10-24	14
6086	2	2043	2018-10-24 16:09:13	2018-10-24	14
6087	3	2043	2018-10-24 16:09:16	2018-10-24	14
6088	1	2044	2018-10-24 16:07:59	2018-10-24	14
6089	2	2044	2018-10-24 16:08:01	2018-10-24	14
6090	3	2044	2018-10-24 16:08:03	2018-10-24	14
6091	1	2045	2018-10-24 16:07:38	2018-10-24	14
6092	2	2045	2018-10-24 16:07:41	2018-10-24	14
6093	3	2045	2018-10-24 16:07:44	2018-10-24	14
6094	1	2046	2018-10-24 16:05:45	2018-10-24	14
6095	2	2046	2018-10-24 16:05:47	2018-10-24	14
6096	3	2046	2018-10-24 16:22:14	2018-10-24	14
6097	1	2047	2018-10-24 16:05:38	2018-10-24	14
6098	2	2047	2018-10-24 16:05:40	2018-10-24	14
6099	3	2047	2018-10-25 10:55:15	2018-10-25	8
6100	1	2048	2018-10-24 15:57:39	2018-10-24	13
6101	2	2048	2018-10-24 15:57:41	2018-10-24	13
6102	3	2048	2018-10-25 08:27:56	2018-10-25	6
6103	1	2049	2018-10-24 15:53:44	2018-10-24	13
6104	2	2049	2018-10-24 15:53:46	2018-10-24	13
6105	3	2049	2018-11-08 10:10:23	2018-11-08	9
6106	1	2050	2018-10-24 15:50:24	2018-10-24	13
6107	2	2050	2018-10-24 15:50:26	2018-10-24	13
6108	3	2050	2018-10-24 15:50:28	2018-10-24	13
6109	1	2051	2018-10-24 15:49:23	2018-10-24	13
6110	2	2051	2018-10-24 15:49:25	2018-10-24	13
6111	3	2051	2018-10-24 15:49:27	2018-10-24	13
6112	1	2052	2018-10-24 15:47:21	2018-10-24	13
6113	2	2052	2018-10-24 15:47:23	2018-10-24	13
6114	3	2052	2018-10-24 15:47:25	2018-10-24	13
6115	1	2053	2018-10-24 15:50:28	2018-10-24	13
6116	2	2053	2018-10-24 15:50:30	2018-10-24	13
6117	3	2053	2018-10-25 11:18:22	2018-10-25	9
6118	1	2054	2018-10-24 15:46:24	2018-10-24	13
6119	2	2054	2018-10-24 15:46:26	2018-10-24	13
6120	3	2054	2018-10-24 15:46:28	2018-10-24	13
6121	1	2055	2018-10-24 15:43:10	2018-10-24	13
6122	2	2055	2018-10-24 15:43:12	2018-10-24	13
6123	3	2055	2018-10-24 15:43:14	2018-10-24	13
6124	1	2056	2018-10-24 15:40:34	2018-10-24	13
6125	2	2056	2018-10-24 15:40:36	2018-10-24	13
6126	3	2056	2018-10-25 09:04:12	2018-10-25	7
6127	1	2057	2018-10-24 15:36:49	2018-10-24	13
6128	2	2057	2018-10-24 15:36:51	2018-10-24	13
6129	3	2057	2018-10-25 09:09:56	2018-10-25	7
6130	1	2058	2018-10-24 15:33:31	2018-10-24	13
6131	2	2058	2018-10-24 15:33:32	2018-10-24	13
6132	3	2058	2018-10-24 15:33:34	2018-10-24	13
6133	1	2059	2018-10-24 15:32:50	2018-10-24	13
6134	2	2059	2018-10-24 15:32:52	2018-10-24	13
6135	3	2059	2018-11-08 09:26:32	2018-11-08	8
6136	1	2060	2018-10-24 15:29:55	2018-10-24	13
6137	2	2060	2018-10-24 15:29:58	2018-10-24	13
6138	3	2060	2018-10-24 15:30:00	2018-10-24	13
6139	1	2061	2018-10-24 15:29:01	2018-10-24	13
6140	2	2061	2018-10-24 15:29:02	2018-10-24	13
6141	3	2061	2018-10-24 15:29:04	2018-10-24	13
6142	1	2062	2018-10-24 15:26:23	2018-10-24	13
6143	2	2062	2018-10-24 15:26:25	2018-10-24	13
6144	3	2062	2018-10-24 15:26:27	2018-10-24	13
6145	1	2063	2018-10-24 15:15:11	2018-10-24	13
6146	2	2063	2018-10-24 15:15:14	2018-10-24	13
6147	3	2063	2018-10-24 15:15:16	2018-10-24	13
6148	1	2064	2018-10-24 15:12:50	2018-10-24	13
6149	2	2064	2018-10-24 15:12:53	2018-10-24	13
6150	3	2064	2018-11-08 10:16:08	2018-11-08	9
6151	1	2065	2018-10-24 15:06:19	2018-10-24	13
6152	2	2065	2018-10-24 15:06:21	2018-10-24	13
6153	3	2065	2018-10-24 15:06:23	2018-10-24	13
6154	1	2066	2018-10-24 15:02:51	2018-10-24	13
6155	2	2066	2018-10-24 15:02:53	2018-10-24	13
6156	3	2066	2018-10-25 09:07:42	2018-10-25	7
6157	1	2067	2018-10-24 15:00:40	2018-10-24	13
6158	2	2067	2018-10-24 15:00:41	2018-10-24	13
6159	3	2067	2018-10-24 15:00:43	2018-10-24	13
6160	1	2068	2018-10-24 15:02:37	2018-10-24	13
6161	2	2068	2018-10-24 15:02:41	2018-10-24	13
6162	3	2068	2018-10-24 15:02:44	2018-10-24	13
6163	1	2069	2018-10-24 14:57:58	2018-10-24	12
6164	2	2069	2018-10-24 14:58:01	2018-10-24	12
6165	3	2069	2018-10-24 15:33:51	2018-10-24	13
6166	1	2070	2018-10-24 14:55:56	2018-10-24	12
6167	2	2070	2018-10-24 14:55:57	2018-10-24	12
6168	3	2070	2018-10-24 14:55:59	2018-10-24	12
6169	1	2071	2018-10-24 14:54:52	2018-10-24	12
6170	2	2071	2018-10-24 14:54:54	2018-10-24	12
6171	3	2071	2018-10-24 14:54:56	2018-10-24	12
6172	1	2072	2018-10-24 14:54:09	2018-10-24	12
6173	2	2072	2018-10-24 14:54:11	2018-10-24	12
6174	3	2072	2018-10-25 09:03:01	2018-10-25	7
6175	1	2073	2018-10-24 14:48:11	2018-10-24	12
6176	2	2073	2018-10-24 14:48:14	2018-10-24	12
6177	3	2073	2018-10-24 14:48:16	2018-10-24	12
6178	1	2074	2018-10-24 14:46:22	2018-10-24	12
6179	2	2074	2018-10-24 14:46:24	2018-10-24	12
6180	3	2074	2018-10-24 14:46:27	2018-10-24	12
6181	1	2075	2018-10-24 14:41:34	2018-10-24	12
6182	2	2075	2018-10-24 14:41:37	2018-10-24	12
6183	3	2075	2018-10-24 14:45:42	2018-10-24	12
6184	1	2076	2018-10-24 14:34:18	2018-10-24	12
6185	2	2076	2018-10-24 14:34:21	2018-10-24	12
6186	3	2076	2018-10-24 14:34:24	2018-10-24	12
6187	1	2077	2018-10-24 14:30:19	2018-10-24	12
6188	2	2077	2018-10-24 14:30:21	2018-10-24	12
6189	3	2077	2018-10-24 14:30:23	2018-10-24	12
6190	1	2078	2018-10-24 14:31:48	2018-10-24	12
6191	2	2078	2018-10-24 14:31:51	2018-10-24	12
6192	3	2078	2018-10-24 14:31:55	2018-10-24	12
6193	1	2079	2018-10-24 14:23:20	2018-10-24	12
6194	2	2079	2018-10-24 14:23:22	2018-10-24	12
6195	3	2079	2018-10-24 14:23:24	2018-10-24	12
6196	1	2080	2018-10-24 14:22:57	2018-10-24	12
6197	2	2080	2018-10-24 14:22:59	2018-10-24	12
6198	3	2080	2018-10-25 09:01:45	2018-10-25	7
6199	1	2081	2018-10-24 14:20:34	2018-10-24	12
6200	2	2081	2018-10-24 14:20:37	2018-10-24	12
6201	3	2081	2018-10-24 14:20:41	2018-10-24	12
6202	1	2082	2018-10-24 13:13:34	2018-10-24	11
6203	2	2082	2018-10-24 13:13:36	2018-10-24	11
6204	3	2082	2018-11-07 16:18:25	2018-11-07	15
6205	1	2083	2018-10-24 12:20:30	2018-10-24	10
6206	2	2083	2018-10-24 12:20:32	2018-10-24	10
6207	3	2083	2018-10-24 12:20:34	2018-10-24	10
6208	1	2084	2018-10-24 12:20:08	2018-10-24	10
6209	2	2084	2018-10-24 12:20:12	2018-10-24	10
6210	3	2084	2018-10-24 12:27:40	2018-10-24	10
6211	1	2085	2018-10-24 12:11:13	2018-10-24	10
6212	2	2085	2018-10-24 12:11:16	2018-10-24	10
6213	3	2085	2018-10-24 12:11:19	2018-10-24	10
6214	1	2086	2018-10-24 11:58:39	2018-10-24	9
6215	2	2086	2018-10-24 11:58:41	2018-10-24	9
6216	3	2086	2018-10-26 11:11:44	2018-10-26	9
6217	1	2087	2018-10-24 11:52:35	2018-10-24	9
6218	2	2087	2018-10-24 11:52:38	2018-10-24	9
6219	3	2087	2018-10-24 11:52:40	2018-10-24	9
6220	1	2088	2018-10-24 11:45:02	2018-10-24	9
6221	2	2088	2018-10-24 11:45:05	2018-10-24	9
6222	3	2088	2018-10-24 11:45:08	2018-10-24	9
6223	1	2089	2018-10-24 11:43:00	2018-10-24	9
6224	2	2089	2018-10-24 11:43:02	2018-10-24	9
6225	3	2089	2018-10-24 11:43:04	2018-10-24	9
6226	1	2090	2018-10-24 11:41:27	2018-10-24	9
6227	2	2090	2018-10-24 11:41:29	2018-10-24	9
6228	3	2090	2018-10-24 11:41:31	2018-10-24	9
6229	1	2091	2018-10-24 11:41:56	2018-10-24	9
6230	2	2091	2018-10-24 11:41:58	2018-10-24	9
6231	3	2091	2018-10-24 12:08:35	2018-10-24	10
6232	1	2092	2018-10-24 11:38:21	2018-10-24	9
6233	2	2092	2018-10-24 11:38:23	2018-10-24	9
6234	3	2092	2018-10-24 11:38:26	2018-10-24	9
6235	1	2093	2018-10-24 11:36:05	2018-10-24	9
6236	2	2093	2018-10-24 11:36:08	2018-10-24	9
6237	3	2093	2018-10-24 11:36:11	2018-10-24	9
6238	1	2094	2018-10-24 11:35:05	2018-10-24	9
6239	2	2094	2018-10-24 11:35:07	2018-10-24	9
6240	3	2094	2018-10-24 11:35:09	2018-10-24	9
6241	1	2095	2018-10-24 11:30:04	2018-10-24	9
6242	2	2095	2018-10-24 11:30:06	2018-10-24	9
6243	3	2095	2018-10-24 11:30:08	2018-10-24	9
6244	1	2096	2018-10-24 11:29:57	2018-10-24	9
6245	2	2096	2018-10-24 11:29:59	2018-10-24	9
6246	3	2096	2018-10-24 11:30:01	2018-10-24	9
6247	1	2097	2018-10-24 11:28:00	2018-10-24	9
6248	2	2097	2018-10-24 11:28:02	2018-10-24	9
6249	3	2097	2018-10-24 11:28:04	2018-10-24	9
6250	1	2098	2018-10-24 11:27:18	2018-10-24	9
6251	2	2098	2018-10-24 11:27:20	2018-10-24	9
6252	3	2098	2018-10-24 11:27:22	2018-10-24	9
6253	1	2099	2018-10-24 11:20:46	2018-10-24	9
6254	2	2099	2018-10-24 11:20:48	2018-10-24	9
6255	3	2099	2018-10-24 11:20:50	2018-10-24	9
6256	1	2100	2018-10-24 11:18:06	2018-10-24	9
6257	2	2100	2018-10-24 11:18:08	2018-10-24	9
6258	3	2100	2018-10-24 11:18:10	2018-10-24	9
6259	1	2101	2018-10-24 11:17:13	2018-10-24	9
6260	2	2101	2018-10-24 11:17:14	2018-10-24	9
6261	3	2101	2018-10-24 11:17:16	2018-10-24	9
6262	1	2102	2018-10-24 11:15:31	2018-10-24	9
6263	2	2102	2018-10-24 11:15:32	2018-10-24	9
6264	3	2102	2018-10-24 11:15:35	2018-10-24	9
6265	1	2103	2018-10-24 11:15:27	2018-10-24	9
6266	2	2103	2018-10-24 11:15:29	2018-10-24	9
6267	3	2103	2018-10-24 11:15:32	2018-10-24	9
6268	1	2104	2018-10-24 11:01:29	2018-10-24	9
6269	2	2104	2018-10-24 11:01:31	2018-10-24	9
6270	3	2104	2018-10-24 11:01:34	2018-10-24	9
6271	1	2105	2018-10-24 10:59:21	2018-10-24	8
6272	2	2105	2018-10-24 10:59:23	2018-10-24	8
6273	3	2105	2018-10-24 10:59:26	2018-10-24	8
6274	1	2106	2018-10-24 10:55:43	2018-10-24	8
6275	2	2106	2018-10-24 10:55:45	2018-10-24	8
6276	3	2106	2018-10-24 14:08:50	2018-10-24	12
6277	1	2107	2018-10-24 10:59:21	2018-10-24	8
6278	2	2107	2018-10-24 10:59:23	2018-10-24	8
6279	3	2107	2018-10-24 14:16:37	2018-10-24	12
6280	1	2108	2018-10-24 10:42:37	2018-10-24	8
6281	2	2108	2018-10-24 10:42:39	2018-10-24	8
6282	3	2108	2018-10-24 10:42:48	2018-10-24	8
6283	1	2109	2018-10-24 10:55:33	2018-10-24	8
6284	2	2109	2018-10-24 10:55:36	2018-10-24	8
6285	3	2109	2018-10-24 10:55:39	2018-10-24	8
6286	1	2110	2018-10-24 10:28:05	2018-10-24	8
6287	2	2110	2018-10-24 10:28:07	2018-10-24	8
6288	3	2110	2018-10-24 10:28:09	2018-10-24	8
6289	1	2111	2018-10-24 10:25:21	2018-10-24	8
6290	2	2111	2018-10-24 10:25:23	2018-10-24	8
6291	3	2111	2018-10-24 10:25:25	2018-10-24	8
6292	1	2112	2018-10-24 10:24:14	2018-10-24	8
6293	2	2112	2018-10-24 10:24:16	2018-10-24	8
6294	3	2112	2018-10-24 10:24:18	2018-10-24	8
6295	1	2113	2018-10-24 10:23:30	2018-10-24	8
6296	2	2113	2018-10-24 10:23:32	2018-10-24	8
6297	3	2113	2018-10-24 10:23:34	2018-10-24	8
6298	1	2114	2018-10-24 10:22:27	2018-10-24	8
6299	2	2114	2018-10-24 10:22:29	2018-10-24	8
6300	3	2114	2018-10-24 10:22:30	2018-10-24	8
6301	1	2115	2018-10-24 10:22:40	2018-10-24	8
6302	2	2115	2018-10-24 10:22:43	2018-10-24	8
6303	3	2115	2018-10-24 10:22:46	2018-10-24	8
6304	1	2116	2018-10-24 10:08:23	2018-10-24	8
6305	2	2116	2018-10-24 10:08:25	2018-10-24	8
6306	3	2116	2018-10-24 10:08:27	2018-10-24	8
6307	1	2117	2018-10-24 10:06:08	2018-10-24	8
6308	2	2117	2018-10-24 10:06:10	2018-10-24	8
6309	3	2117	2018-10-24 10:06:13	2018-10-24	8
6310	1	2118	2018-10-24 09:57:31	2018-10-24	7
6311	2	2118	2018-10-24 09:57:33	2018-10-24	7
6312	3	2118	2018-10-24 09:57:35	2018-10-24	7
6313	1	2119	2018-10-24 09:56:50	2018-10-24	7
6314	2	2119	2018-10-24 09:56:52	2018-10-24	7
6315	3	2119	2018-10-24 09:56:54	2018-10-24	7
6316	1	2120	2018-10-24 09:56:30	2018-10-24	7
6317	2	2120	2018-10-24 09:56:31	2018-10-24	7
6318	3	2120	2018-10-24 09:56:33	2018-10-24	7
6319	1	2121	2018-10-24 09:56:11	2018-10-24	7
6320	2	2121	2018-10-24 09:56:13	2018-10-24	7
6321	3	2121	2018-10-24 09:56:15	2018-10-24	7
6322	1	2122	2018-10-24 09:53:57	2018-10-24	7
6323	2	2122	2018-10-24 09:53:59	2018-10-24	7
6324	3	2122	2018-10-24 09:54:01	2018-10-24	7
6325	1	2123	2018-10-24 09:55:06	2018-10-24	7
6326	2	2123	2018-10-24 09:55:07	2018-10-24	7
6327	3	2123	2018-10-24 09:55:09	2018-10-24	7
6328	1	2124	2018-10-24 09:50:53	2018-10-24	7
6329	2	2124	2018-10-24 09:50:54	2018-10-24	7
6330	3	2124	2018-10-24 13:42:22	2018-10-24	11
6331	1	2125	2018-10-24 09:44:49	2018-10-24	7
6332	2	2125	2018-10-24 09:44:51	2018-10-24	7
6333	3	2125	2018-10-24 09:44:53	2018-10-24	7
6334	1	2126	2018-10-24 09:47:27	2018-10-24	7
6335	2	2126	2018-10-24 09:47:30	2018-10-24	7
6336	3	2126	2018-10-29 09:31:43	2018-10-29	8
6337	1	2127	2018-10-24 09:44:06	2018-10-24	7
6338	2	2127	2018-10-24 09:44:08	2018-10-24	7
6339	3	2127	2018-10-24 09:44:09	2018-10-24	7
6340	1	2128	2018-10-24 09:45:32	2018-10-24	7
6341	2	2128	2018-10-24 09:45:34	2018-10-24	7
6342	3	2128	2018-10-24 09:45:36	2018-10-24	7
6343	1	2129	2018-10-24 09:36:51	2018-10-24	7
6344	2	2129	2018-10-24 09:36:53	2018-10-24	7
6345	3	2129	2018-10-24 14:30:28	2018-10-24	12
6346	1	2130	2018-10-24 09:36:41	2018-10-24	7
6347	2	2130	2018-10-24 09:36:43	2018-10-24	7
6348	3	2130	2018-10-24 13:38:25	2018-10-24	11
6349	1	2131	2018-10-24 09:34:01	2018-10-24	7
6350	2	2131	2018-10-24 09:34:04	2018-10-24	7
6351	3	2131	2018-10-24 11:35:52	2018-10-24	9
6352	1	2132	2018-10-24 09:30:37	2018-10-24	7
6353	2	2132	2018-10-24 09:30:40	2018-10-24	7
6354	3	2132	2018-10-24 09:30:43	2018-10-24	7
6355	1	2133	2018-10-24 09:23:30	2018-10-24	7
6356	2	2133	2018-10-24 09:23:33	2018-10-24	7
6357	3	2133	2018-10-24 09:23:36	2018-10-24	7
6358	1	2134	2018-10-24 09:22:44	2018-10-24	7
6359	2	2134	2018-10-24 09:22:47	2018-10-24	7
6360	3	2134	2018-10-24 09:22:50	2018-10-24	7
6361	1	2135	2018-10-24 09:19:07	2018-10-24	7
6362	2	2135	2018-10-24 09:19:09	2018-10-24	7
6363	3	2135	2018-10-24 10:43:26	2018-10-24	8
6364	1	2136	2018-10-24 09:16:36	2018-10-24	7
6365	2	2136	2018-10-24 09:16:39	2018-10-24	7
6366	3	2136	2018-10-24 09:16:41	2018-10-24	7
6367	1	2137	2018-10-24 09:14:59	2018-10-24	7
6368	2	2137	2018-10-24 09:15:03	2018-10-24	7
6369	3	2137	2018-10-24 09:15:05	2018-10-24	7
6370	1	2138	2018-10-24 09:14:26	2018-10-24	7
6371	2	2138	2018-10-24 09:14:28	2018-10-24	7
6372	3	2138	2018-10-24 09:14:29	2018-10-24	7
6373	1	2139	2018-10-24 09:09:40	2018-10-24	7
6374	2	2139	2018-10-24 09:09:42	2018-10-24	7
6375	3	2139	2018-10-24 09:19:59	2018-10-24	7
6376	1	2140	2018-10-23 19:00:27	2018-10-23	17
6377	2	2140	2018-10-23 19:00:30	2018-10-23	17
6378	3	2140	2018-10-24 14:36:08	2018-10-24	12
6379	1	2141	2018-10-23 17:45:00	2018-10-23	15
6380	2	2141	2018-10-23 17:45:02	2018-10-23	15
6381	3	2141	2018-10-24 10:51:55	2018-10-24	8
6382	1	2142	2018-10-23 17:28:57	2018-10-23	15
6383	2	2142	2018-10-23 17:28:59	2018-10-23	15
6384	3	2142	2018-10-24 11:57:17	2018-10-24	9
6385	1	2143	2018-10-23 16:57:45	2018-10-23	14
6386	2	2143	2018-10-23 16:57:47	2018-10-23	14
6387	3	2143	2018-10-24 07:38:10	2018-10-24	5
6388	1	2144	2018-10-23 16:50:07	2018-10-23	14
6389	2	2144	2018-10-23 16:50:09	2018-10-23	14
6390	3	2144	2018-10-23 16:50:11	2018-10-23	14
6391	1	2145	2018-10-23 16:55:23	2018-10-23	14
6392	2	2145	2018-10-23 16:55:25	2018-10-23	14
6393	3	2145	2018-10-24 07:44:10	2018-10-24	5
6394	1	2146	2018-10-23 16:46:51	2018-10-23	14
6395	2	2146	2018-10-23 16:46:55	2018-10-23	14
6396	3	2146	2018-10-23 16:46:57	2018-10-23	14
6397	1	2147	2018-10-23 16:44:19	2018-10-23	14
6398	2	2147	2018-10-23 16:44:21	2018-10-23	14
6399	3	2147	2018-10-23 16:44:23	2018-10-23	14
6400	1	2148	2018-10-23 16:42:44	2018-10-23	14
6401	2	2148	2018-10-23 16:42:47	2018-10-23	14
6402	3	2148	2018-11-08 11:13:47	2018-11-08	10
6403	1	2149	2018-10-23 16:33:14	2018-10-23	14
6404	2	2149	2018-10-23 16:33:16	2018-10-23	14
6405	3	2149	2018-10-23 16:33:19	2018-10-23	14
6406	1	2150	2018-10-23 16:29:52	2018-10-23	14
6407	2	2150	2018-10-23 16:29:54	2018-10-23	14
6408	3	2150	2018-10-23 16:29:56	2018-10-23	14
6409	1	2151	2018-10-23 16:27:34	2018-10-23	14
6410	2	2151	2018-10-23 16:27:36	2018-10-23	14
6411	3	2151	2018-10-23 16:27:38	2018-10-23	14
6412	1	2152	2018-10-23 16:37:23	2018-10-23	14
6413	2	2152	2018-10-23 16:37:25	2018-10-23	14
6414	3	2152	2018-10-23 16:37:26	2018-10-23	14
6415	1	2153	2018-10-23 16:17:52	2018-10-23	14
6416	2	2153	2018-10-23 16:17:55	2018-10-23	14
6417	3	2153	2018-11-08 11:12:37	2018-11-08	10
6418	1	2154	2018-10-23 16:04:23	2018-10-23	14
6419	2	2154	2018-10-23 16:04:25	2018-10-23	14
6420	1	2155	2018-10-23 15:57:54	2018-10-23	13
6421	2	2155	2018-10-23 15:57:57	2018-10-23	13
6422	3	2155	2018-10-24 12:01:01	2018-10-24	10
6423	1	2156	2018-10-23 16:01:16	2018-10-23	14
6424	2	2156	2018-10-23 16:01:19	2018-10-23	14
6425	3	2156	2018-10-23 16:06:59	2018-10-23	14
6426	1	2157	2018-10-23 15:54:14	2018-10-23	13
6427	2	2157	2018-10-23 15:54:17	2018-10-23	13
6428	3	2157	2018-10-23 15:54:19	2018-10-23	13
6429	1	2158	2018-10-23 15:45:07	2018-10-23	13
6430	2	2158	2018-10-23 15:45:10	2018-10-23	13
6431	3	2158	2018-10-24 08:00:03	2018-10-24	6
6432	1	2159	2018-10-23 15:35:27	2018-10-23	13
6433	2	2159	2018-10-23 15:35:29	2018-10-23	13
6434	3	2159	2018-10-23 15:43:54	2018-10-23	13
6435	1	2160	2018-10-23 15:20:53	2018-10-23	13
6436	2	2160	2018-10-23 15:20:56	2018-10-23	13
6437	3	2160	2018-10-23 15:20:59	2018-10-23	13
6438	1	2161	2018-10-23 15:19:29	2018-10-23	13
6439	2	2161	2018-10-23 15:19:31	2018-10-23	13
6440	3	2161	2018-11-06 11:35:09	2018-11-06	10
6441	1	2162	2018-10-23 15:17:09	2018-10-23	13
6442	2	2162	2018-10-23 15:17:11	2018-10-23	13
6443	3	2162	2018-10-23 15:17:13	2018-10-23	13
6444	1	2163	2018-10-23 15:18:40	2018-10-23	13
6445	2	2163	2018-10-23 15:18:43	2018-10-23	13
6446	3	2163	2018-10-23 15:18:46	2018-10-23	13
6447	1	2164	2018-10-23 15:14:43	2018-10-23	13
6448	2	2164	2018-10-23 15:14:45	2018-10-23	13
6449	3	2164	2018-10-23 15:14:48	2018-10-23	13
6450	1	2165	2018-10-23 14:46:30	2018-10-23	12
6451	2	2165	2018-10-23 14:46:32	2018-10-23	12
6452	3	2165	2018-10-23 16:12:53	2018-10-23	14
6453	1	2166	2018-10-23 14:46:19	2018-10-23	12
6454	2	2166	2018-10-23 14:46:23	2018-10-23	12
6455	3	2166	2018-11-08 11:19:26	2018-11-08	10
6456	1	2167	2018-10-23 14:43:46	2018-10-23	12
6457	2	2167	2018-10-23 14:43:48	2018-10-23	12
6458	3	2167	2018-12-05 16:34:00	2018-12-05	15
6459	1	2168	2018-10-23 14:37:48	2018-10-23	12
6460	2	2168	2018-10-23 14:37:51	2018-10-23	12
6461	3	2168	2018-10-24 10:37:39	2018-10-24	8
6462	1	2169	2018-10-23 14:35:26	2018-10-23	12
6463	2	2169	2018-10-23 14:35:28	2018-10-23	12
6464	3	2169	2018-10-23 15:50:53	2018-10-23	13
6465	1	2170	2018-10-23 14:29:57	2018-10-23	12
6466	2	2170	2018-10-23 14:29:59	2018-10-23	12
6467	3	2170	2018-10-23 15:59:29	2018-10-23	13
6468	1	2171	2018-10-23 14:25:00	2018-10-23	12
6469	2	2171	2018-10-23 14:25:02	2018-10-23	12
6470	3	2171	2018-10-23 15:29:49	2018-10-23	13
6471	1	2172	2018-10-23 14:13:54	2018-10-23	12
6472	2	2172	2018-10-23 14:13:56	2018-10-23	12
6473	3	2172	2018-10-23 14:28:25	2018-10-23	12
6474	1	2173	2018-10-23 14:12:04	2018-10-23	12
6475	2	2173	2018-10-23 14:12:06	2018-10-23	12
6476	3	2173	2018-10-23 15:19:48	2018-10-23	13
6477	1	2174	2018-10-23 14:09:18	2018-10-23	12
6478	2	2174	2018-10-23 14:09:21	2018-10-23	12
6479	3	2174	2018-10-23 14:41:26	2018-10-23	12
6480	1	2175	2018-10-23 14:07:26	2018-10-23	12
6481	2	2175	2018-10-23 14:07:28	2018-10-23	12
6482	3	2175	2018-10-23 14:39:28	2018-10-23	12
6483	1	2176	2018-10-23 13:05:14	2018-10-23	11
6484	2	2176	2018-10-23 13:05:16	2018-10-23	11
6485	3	2176	2018-10-23 13:10:08	2018-10-23	11
6486	1	2177	2018-10-23 12:34:55	2018-10-23	10
6487	2	2177	2018-10-23 12:34:57	2018-10-23	10
6488	3	2177	2018-10-23 12:34:58	2018-10-23	10
6489	1	2178	2018-10-23 12:33:31	2018-10-23	10
6490	2	2178	2018-10-23 12:33:33	2018-10-23	10
6491	3	2178	2018-10-23 12:33:35	2018-10-23	10
6492	1	2179	2018-10-23 12:23:15	2018-10-23	10
6493	2	2179	2018-10-23 12:23:17	2018-10-23	10
6494	3	2179	2018-11-06 11:41:31	2018-11-06	10
6495	1	2180	2018-10-23 12:19:00	2018-10-23	10
6496	2	2180	2018-10-23 12:19:02	2018-10-23	10
6497	3	2180	2018-10-23 12:55:23	2018-10-23	10
6498	1	2181	2018-10-23 12:14:12	2018-10-23	10
6499	2	2181	2018-10-23 12:14:13	2018-10-23	10
6500	3	2181	2018-10-23 12:16:02	2018-10-23	10
6501	1	2182	2018-10-23 12:08:32	2018-10-23	10
6502	2	2182	2018-10-23 12:08:34	2018-10-23	10
6503	3	2182	2018-10-23 12:29:50	2018-10-23	10
6504	1	2183	2018-10-23 12:05:08	2018-10-23	10
6505	2	2183	2018-10-23 12:05:09	2018-10-23	10
6506	3	2183	2018-10-23 12:09:49	2018-10-23	10
6507	1	2184	2018-10-23 11:59:12	2018-10-23	9
6508	2	2184	2018-10-23 11:59:14	2018-10-23	9
6509	3	2184	2018-10-23 11:59:16	2018-10-23	9
6510	1	2185	2018-10-23 11:58:01	2018-10-23	9
6511	2	2185	2018-10-23 11:58:04	2018-10-23	9
6512	3	2185	2018-10-23 11:58:07	2018-10-23	9
6513	1	2186	2018-10-23 11:56:14	2018-10-23	9
6514	2	2186	2018-10-23 11:56:16	2018-10-23	9
6515	3	2186	2018-10-23 11:56:17	2018-10-23	9
6516	1	2187	2018-10-23 11:53:38	2018-10-23	9
6517	2	2187	2018-10-23 11:53:39	2018-10-23	9
6518	3	2187	2018-10-23 11:53:41	2018-10-23	9
6519	1	2188	2018-10-23 11:52:40	2018-10-23	9
6520	2	2188	2018-10-23 11:52:42	2018-10-23	9
6521	3	2188	2018-10-23 11:52:43	2018-10-23	9
6522	1	2189	2018-10-23 11:49:33	2018-10-23	9
6523	2	2189	2018-10-23 11:49:34	2018-10-23	9
6524	3	2189	2018-10-23 11:49:36	2018-10-23	9
6525	1	2190	2018-10-23 11:48:18	2018-10-23	9
6526	2	2190	2018-10-23 11:48:19	2018-10-23	9
6527	3	2190	2018-10-30 10:56:39	2018-10-30	9
6528	1	2191	2018-10-23 11:44:32	2018-10-23	9
6529	2	2191	2018-10-23 11:44:34	2018-10-23	9
6530	3	2191	2018-10-23 12:22:32	2018-10-23	10
6531	1	2192	2018-10-23 11:41:46	2018-10-23	9
6532	2	2192	2018-10-23 11:41:49	2018-10-23	9
6533	3	2192	2018-10-23 11:41:51	2018-10-23	9
6534	1	2193	2018-10-23 11:34:33	2018-10-23	9
6535	2	2193	2018-10-23 11:34:36	2018-10-23	9
6536	3	2193	2018-10-23 11:58:10	2018-10-23	9
6537	1	2194	2018-10-23 11:30:21	2018-10-23	9
6538	2	2194	2018-10-23 11:30:23	2018-10-23	9
6539	3	2194	2018-10-23 11:30:25	2018-10-23	9
6540	1	2195	2018-10-23 11:28:06	2018-10-23	9
6541	2	2195	2018-10-23 11:28:07	2018-10-23	9
6542	3	2195	2018-10-23 11:58:41	2018-10-23	9
6543	1	2196	2018-10-23 11:29:14	2018-10-23	9
6544	2	2196	2018-10-23 11:29:16	2018-10-23	9
6545	3	2196	2018-10-23 11:53:31	2018-10-23	9
6546	1	2197	2018-10-23 11:26:33	2018-10-23	9
6547	2	2197	2018-10-23 11:26:35	2018-10-23	9
6548	3	2197	2018-10-23 11:41:41	2018-10-23	9
6549	1	2198	2018-10-23 11:23:05	2018-10-23	9
6550	2	2198	2018-10-23 11:23:08	2018-10-23	9
6551	3	2198	2018-10-23 11:23:11	2018-10-23	9
6552	1	2199	2018-10-23 11:19:40	2018-10-23	9
6553	2	2199	2018-10-23 11:19:42	2018-10-23	9
6554	3	2199	2018-10-23 11:19:44	2018-10-23	9
6555	1	2200	2018-10-23 11:17:45	2018-10-23	9
6556	2	2200	2018-10-23 11:17:46	2018-10-23	9
6557	3	2200	2018-10-23 11:17:48	2018-10-23	9
6558	1	2201	2018-10-23 11:11:15	2018-10-23	9
6559	2	2201	2018-10-23 11:11:17	2018-10-23	9
6560	3	2201	2018-10-23 11:11:18	2018-10-23	9
6561	1	2202	2018-10-23 11:12:17	2018-10-23	9
6562	2	2202	2018-10-23 11:12:19	2018-10-23	9
6563	3	2202	2018-12-06 09:29:03	2018-12-06	8
6564	1	2203	2018-10-23 11:08:57	2018-10-23	9
6565	2	2203	2018-10-23 11:08:59	2018-10-23	9
6566	3	2203	2018-10-23 11:43:45	2018-10-23	9
6567	1	2204	2018-10-23 11:04:26	2018-10-23	9
6568	2	2204	2018-10-23 11:04:27	2018-10-23	9
6569	3	2204	2018-10-23 11:20:34	2018-10-23	9
6570	1	2205	2018-10-23 11:00:36	2018-10-23	9
6571	2	2205	2018-10-23 11:00:39	2018-10-23	9
6572	3	2205	2018-10-23 11:00:41	2018-10-23	9
6573	1	2206	2018-10-23 10:59:16	2018-10-23	8
6574	2	2206	2018-10-23 10:59:17	2018-10-23	8
6575	3	2206	2018-10-23 11:10:52	2018-10-23	9
6576	1	2207	2018-10-23 10:56:24	2018-10-23	8
6577	2	2207	2018-10-23 10:56:26	2018-10-23	8
6578	3	2207	2018-10-23 10:56:28	2018-10-23	8
6579	1	2208	2018-10-23 10:52:41	2018-10-23	8
6580	2	2208	2018-10-23 10:52:42	2018-10-23	8
6581	3	2208	2018-10-23 10:52:44	2018-10-23	8
6582	1	2209	2018-10-23 10:50:50	2018-10-23	8
6583	2	2209	2018-10-23 10:50:52	2018-10-23	8
6584	3	2209	2018-10-23 10:50:54	2018-10-23	8
6585	1	2210	2018-10-23 10:52:45	2018-10-23	8
6586	2	2210	2018-10-23 10:52:48	2018-10-23	8
6587	3	2210	2018-10-23 11:38:56	2018-10-23	9
6588	1	2211	2018-10-23 10:44:51	2018-10-23	8
6589	2	2211	2018-10-23 10:44:53	2018-10-23	8
6590	3	2211	2018-10-23 10:44:54	2018-10-23	8
6591	1	2212	2018-10-23 10:42:24	2018-10-23	8
6592	2	2212	2018-10-23 10:42:27	2018-10-23	8
6593	3	2212	2018-10-23 10:42:29	2018-10-23	8
6594	1	2213	2018-10-23 10:40:47	2018-10-23	8
6595	2	2213	2018-10-23 10:40:49	2018-10-23	8
6596	3	2213	2018-10-23 11:02:57	2018-10-23	9
6597	1	2214	2018-10-23 10:37:10	2018-10-23	8
6598	2	2214	2018-10-23 10:37:12	2018-10-23	8
6599	3	2214	2018-10-23 10:37:14	2018-10-23	8
6600	1	2215	2018-10-23 10:27:30	2018-10-23	8
6601	2	2215	2018-10-23 10:27:33	2018-10-23	8
6602	3	2215	2018-10-23 10:27:35	2018-10-23	8
6603	1	2216	2018-10-23 10:27:15	2018-10-23	8
6604	2	2216	2018-10-23 10:27:17	2018-10-23	8
6605	3	2216	2018-10-23 10:37:45	2018-10-23	8
6606	1	2217	2018-10-23 10:21:59	2018-10-23	8
6607	2	2217	2018-10-23 10:22:02	2018-10-23	8
6608	3	2217	2018-10-23 10:22:05	2018-10-23	8
6609	1	2218	2018-10-23 10:19:54	2018-10-23	8
6610	2	2218	2018-10-23 10:19:56	2018-10-23	8
6611	3	2218	2018-10-23 10:19:57	2018-10-23	8
6612	1	2219	2018-10-23 10:17:27	2018-10-23	8
6613	2	2219	2018-10-23 10:17:29	2018-10-23	8
6614	3	2219	2018-10-23 10:17:31	2018-10-23	8
6615	1	2220	2018-10-23 10:17:51	2018-10-23	8
6616	2	2220	2018-10-23 10:17:53	2018-10-23	8
6617	3	2220	2018-10-23 10:23:08	2018-10-23	8
6618	1	2221	2018-10-23 10:13:13	2018-10-23	8
6619	2	2221	2018-10-23 10:13:15	2018-10-23	8
6620	3	2221	2018-10-23 10:13:17	2018-10-23	8
6621	1	2222	2018-10-23 10:12:10	2018-10-23	8
6622	2	2222	2018-10-23 10:12:12	2018-10-23	8
6623	3	2222	2018-10-23 10:16:19	2018-10-23	8
6624	1	2223	2018-10-23 10:05:15	2018-10-23	8
6625	2	2223	2018-10-23 10:05:17	2018-10-23	8
6626	3	2223	2018-10-23 10:40:41	2018-10-23	8
6627	1	2224	2018-10-23 10:07:12	2018-10-23	8
6628	2	2224	2018-10-23 10:07:15	2018-10-23	8
6629	3	2224	2018-10-23 10:48:51	2018-10-23	8
6630	1	2225	2018-10-23 10:01:50	2018-10-23	8
6631	2	2225	2018-10-23 10:01:53	2018-10-23	8
6632	3	2225	2018-10-23 10:01:55	2018-10-23	8
6633	1	2226	2018-10-23 09:57:06	2018-10-23	7
6634	2	2226	2018-10-23 09:57:08	2018-10-23	7
6635	3	2226	2018-12-05 16:23:57	2018-12-05	15
6636	1	2227	2018-10-23 09:46:58	2018-10-23	7
6637	2	2227	2018-10-23 09:47:00	2018-10-23	7
6638	3	2227	2018-10-23 09:47:03	2018-10-23	7
6639	1	2228	2018-10-23 09:47:19	2018-10-23	7
6640	2	2228	2018-10-23 09:47:21	2018-10-23	7
6641	3	2228	2018-10-23 09:47:23	2018-10-23	7
6642	1	2229	2018-10-23 09:44:42	2018-10-23	7
6643	2	2229	2018-10-23 09:44:46	2018-10-23	7
6644	3	2229	2018-10-23 09:44:48	2018-10-23	7
6645	1	2230	2018-10-23 10:18:04	2018-10-23	8
6646	2	2230	2018-10-23 10:18:09	2018-10-23	8
6647	3	2230	2018-10-23 10:40:00	2018-10-23	8
6648	1	2231	2018-10-23 09:43:31	2018-10-23	7
6649	2	2231	2018-10-23 09:43:33	2018-10-23	7
6650	3	2231	2018-10-23 09:49:47	2018-10-23	7
6651	1	2232	2018-10-23 09:31:50	2018-10-23	7
6652	2	2232	2018-10-23 09:31:53	2018-10-23	7
6653	3	2232	2018-10-23 09:31:55	2018-10-23	7
6654	1	2233	2018-10-23 09:32:43	2018-10-23	7
6655	2	2233	2018-10-23 09:32:46	2018-10-23	7
6656	3	2233	2018-11-08 10:33:00	2018-11-08	9
6657	1	2234	2018-10-23 09:30:26	2018-10-23	7
6658	2	2234	2018-10-23 09:30:27	2018-10-23	7
6659	3	2234	2018-10-23 09:30:29	2018-10-23	7
6660	1	2235	2018-10-23 09:29:07	2018-10-23	7
6661	2	2235	2018-10-23 09:29:09	2018-10-23	7
6662	3	2235	2018-10-23 09:31:11	2018-10-23	7
6663	1	2236	2018-10-23 09:25:58	2018-10-23	7
6664	2	2236	2018-10-23 09:26:00	2018-10-23	7
6665	3	2236	2018-10-23 09:26:02	2018-10-23	7
6666	1	2237	2018-10-23 09:16:52	2018-10-23	7
6667	2	2237	2018-10-23 09:16:54	2018-10-23	7
6668	3	2237	2018-10-23 09:16:55	2018-10-23	7
6669	1	2238	2018-10-23 09:15:06	2018-10-23	7
6670	2	2238	2018-10-23 09:15:10	2018-10-23	7
6671	3	2238	2018-10-23 09:15:36	2018-10-23	7
6672	1	2239	2018-10-23 09:12:39	2018-10-23	7
6673	2	2239	2018-10-23 09:12:41	2018-10-23	7
6674	3	2239	2018-10-23 09:12:43	2018-10-23	7
6675	1	2240	2018-10-23 09:11:55	2018-10-23	7
6676	2	2240	2018-10-23 09:11:58	2018-10-23	7
6677	3	2240	2018-10-23 10:25:53	2018-10-23	8
6678	1	2241	2018-10-23 09:05:45	2018-10-23	7
6679	2	2241	2018-10-23 09:05:46	2018-10-23	7
6680	3	2241	2018-10-23 09:05:48	2018-10-23	7
6681	1	2242	2018-10-23 09:05:28	2018-10-23	7
6682	2	2242	2018-10-23 09:05:29	2018-10-23	7
6683	3	2242	2018-10-23 09:28:10	2018-10-23	7
6684	1	2243	2018-10-23 09:01:39	2018-10-23	7
6685	2	2243	2018-10-23 09:01:41	2018-10-23	7
6686	3	2243	2018-10-23 09:01:43	2018-10-23	7
6687	1	2244	2018-10-23 09:03:03	2018-10-23	7
6688	2	2244	2018-10-23 09:03:06	2018-10-23	7
6689	3	2244	2018-11-08 10:26:29	2018-11-08	9
6690	1	2245	2018-10-23 08:57:45	2018-10-23	6
6691	2	2245	2018-10-23 08:57:47	2018-10-23	6
6692	3	2245	2018-10-23 08:57:49	2018-10-23	6
6693	1	2246	2018-10-23 08:57:32	2018-10-23	6
6694	2	2246	2018-10-23 08:57:34	2018-10-23	6
6695	3	2246	2018-10-23 09:07:29	2018-10-23	7
6696	1	2247	2018-10-23 08:55:14	2018-10-23	6
6697	2	2247	2018-10-23 08:55:15	2018-10-23	6
6698	3	2247	2018-10-23 08:55:17	2018-10-23	6
6699	1	2248	2018-10-23 08:52:26	2018-10-23	6
6700	2	2248	2018-10-23 08:52:28	2018-10-23	6
6701	3	2248	2018-10-23 08:52:29	2018-10-23	6
6702	1	2249	2018-10-23 08:50:08	2018-10-23	6
6703	2	2249	2018-10-23 08:50:11	2018-10-23	6
6704	3	2249	2018-10-23 08:50:12	2018-10-23	6
6705	1	2250	2018-10-23 08:40:19	2018-10-23	6
6706	2	2250	2018-10-23 08:40:21	2018-10-23	6
6707	3	2250	2018-10-23 08:40:23	2018-10-23	6
6708	1	2251	2018-10-23 08:38:53	2018-10-23	6
6709	2	2251	2018-10-23 08:38:55	2018-10-23	6
6710	3	2251	2018-10-23 08:38:57	2018-10-23	6
6711	1	2252	2018-10-23 08:33:31	2018-10-23	6
6712	2	2252	2018-10-23 08:33:33	2018-10-23	6
6713	3	2252	2018-10-23 08:33:35	2018-10-23	6
6714	1	2253	2018-10-23 08:29:58	2018-10-23	6
6715	2	2253	2018-10-23 08:30:02	2018-10-23	6
6716	3	2253	2018-10-23 08:30:04	2018-10-23	6
6717	1	2254	2018-10-22 17:00:22	2018-10-22	15
6718	2	2254	2018-10-22 17:00:24	2018-10-22	15
6719	3	2254	2018-10-23 10:01:00	2018-10-23	8
6720	1	2255	2018-10-22 16:45:00	2018-10-22	14
6721	2	2255	2018-10-22 16:45:02	2018-10-22	14
6722	3	2255	2018-10-23 08:12:56	2018-10-23	6
6723	1	2256	2018-10-22 16:40:31	2018-10-22	14
6724	2	2256	2018-10-22 16:40:35	2018-10-22	14
6725	3	2256	2018-10-22 16:40:38	2018-10-22	14
6726	1	2257	2018-10-22 16:32:54	2018-10-22	14
6727	2	2257	2018-10-22 16:32:57	2018-10-22	14
6728	3	2257	2018-11-08 10:39:51	2018-11-08	9
6729	1	2258	2018-10-22 16:25:25	2018-10-22	14
6730	2	2258	2018-10-22 16:25:26	2018-10-22	14
6731	3	2258	2018-10-22 16:25:28	2018-10-22	14
6732	1	2259	2018-10-22 16:18:13	2018-10-22	14
6733	2	2259	2018-10-22 16:18:16	2018-10-22	14
6734	3	2259	2018-10-22 16:18:18	2018-10-22	14
6735	1	2260	2018-10-22 16:07:37	2018-10-22	14
6736	2	2260	2018-10-22 16:07:38	2018-10-22	14
6737	3	2260	2018-10-22 16:07:40	2018-10-22	14
6738	1	2261	2018-10-22 16:04:31	2018-10-22	14
6739	2	2261	2018-10-22 16:04:34	2018-10-22	14
6740	3	2261	2018-10-22 16:04:36	2018-10-22	14
6741	1	2262	2018-10-22 16:03:47	2018-10-22	14
6742	2	2262	2018-10-22 16:03:50	2018-10-22	14
6743	3	2262	2018-10-22 16:03:52	2018-10-22	14
6744	1	2263	2018-10-22 16:02:02	2018-10-22	14
6745	2	2263	2018-10-22 16:02:06	2018-10-22	14
6746	3	2263	2018-10-22 16:02:09	2018-10-22	14
6747	1	2264	2018-10-22 16:01:59	2018-10-22	14
6748	2	2264	2018-10-22 16:02:01	2018-10-22	14
6749	3	2264	2018-10-23 08:52:04	2018-10-23	6
6750	1	2265	2018-10-22 15:59:16	2018-10-22	13
6751	2	2265	2018-10-22 15:59:18	2018-10-22	13
6752	3	2265	2018-10-22 15:59:20	2018-10-22	13
6753	1	2266	2018-10-22 15:55:38	2018-10-22	13
6754	2	2266	2018-10-22 15:55:40	2018-10-22	13
6755	3	2266	2018-10-22 15:55:42	2018-10-22	13
6756	1	2267	2018-10-22 15:54:10	2018-10-22	13
6757	2	2267	2018-10-22 15:54:14	2018-10-22	13
6758	3	2267	2018-10-22 15:54:16	2018-10-22	13
6759	1	2268	2018-10-22 15:51:03	2018-10-22	13
6760	2	2268	2018-10-22 15:51:06	2018-10-22	13
6761	3	2268	2018-11-08 10:42:28	2018-11-08	9
6762	1	2269	2018-10-22 15:46:15	2018-10-22	13
6763	2	2269	2018-10-22 15:46:17	2018-10-22	13
6764	3	2269	2018-10-22 15:46:19	2018-10-22	13
6765	1	2270	2018-10-22 15:46:01	2018-10-22	13
6766	2	2270	2018-10-22 15:46:03	2018-10-22	13
6767	3	2270	2018-10-22 15:46:04	2018-10-22	13
6768	1	2271	2018-10-22 15:44:44	2018-10-22	13
6769	2	2271	2018-10-22 15:44:46	2018-10-22	13
6770	3	2271	2018-10-22 15:44:48	2018-10-22	13
6771	1	2272	2018-10-22 15:42:23	2018-10-22	13
6772	2	2272	2018-10-22 15:42:25	2018-10-22	13
6773	3	2272	2018-10-22 15:50:31	2018-10-22	13
6774	1	2273	2018-10-22 15:29:58	2018-10-22	13
6775	2	2273	2018-10-22 15:29:59	2018-10-22	13
6776	3	2273	2018-10-22 16:46:45	2018-10-22	14
6777	1	2274	2018-10-22 15:29:49	2018-10-22	13
6778	2	2274	2018-10-22 15:29:51	2018-10-22	13
6779	3	2274	2018-10-22 15:36:01	2018-10-22	13
6780	1	2275	2018-10-22 15:25:59	2018-10-22	13
6781	2	2275	2018-10-22 15:26:01	2018-10-22	13
6782	3	2275	2018-10-22 15:26:03	2018-10-22	13
6783	1	2276	2018-10-22 15:52:15	2018-10-22	13
6784	2	2276	2018-10-22 15:52:18	2018-10-22	13
6785	3	2276	2018-10-22 16:01:14	2018-10-22	14
6786	1	2277	2018-10-22 15:22:51	2018-10-22	13
6787	2	2277	2018-10-22 15:22:55	2018-10-22	13
6788	3	2277	2018-10-22 15:22:57	2018-10-22	13
6789	1	2278	2018-10-22 15:08:44	2018-10-22	13
6790	2	2278	2018-10-22 15:08:46	2018-10-22	13
6791	3	2278	2018-10-22 15:08:48	2018-10-22	13
6792	1	2279	2018-10-22 15:07:52	2018-10-22	13
6793	2	2279	2018-10-22 15:07:54	2018-10-22	13
6794	3	2279	2018-10-22 15:07:55	2018-10-22	13
6795	1	2280	2018-10-22 15:05:19	2018-10-22	13
6796	2	2280	2018-10-22 15:05:21	2018-10-22	13
6797	3	2280	2018-10-22 15:05:23	2018-10-22	13
6798	1	2281	2018-10-22 15:03:06	2018-10-22	13
6799	2	2281	2018-10-22 15:03:08	2018-10-22	13
6800	3	2281	2018-10-23 08:56:36	2018-10-23	6
6801	1	2282	2018-10-22 14:53:45	2018-10-22	12
6802	2	2282	2018-10-22 14:53:48	2018-10-22	12
6803	3	2282	2018-10-22 14:53:51	2018-10-22	12
6804	1	2283	2018-10-22 14:53:58	2018-10-22	12
6805	2	2283	2018-10-22 14:54:00	2018-10-22	12
6806	3	2283	2018-10-22 15:32:26	2018-10-22	13
6807	1	2284	2018-10-22 14:50:02	2018-10-22	12
6808	2	2284	2018-10-22 14:50:04	2018-10-22	12
6809	3	2284	2018-10-23 10:42:57	2018-10-23	8
6810	1	2285	2018-10-22 14:48:31	2018-10-22	12
6811	2	2285	2018-10-22 14:48:33	2018-10-22	12
6812	3	2285	2018-10-22 15:21:53	2018-10-22	13
6813	1	2286	2018-10-22 14:40:13	2018-10-22	12
6814	2	2286	2018-10-22 14:40:15	2018-10-22	12
6815	3	2286	2018-10-22 15:33:10	2018-10-22	13
6816	1	2287	2018-10-22 14:35:42	2018-10-22	12
6817	2	2287	2018-10-22 14:35:44	2018-10-22	12
6818	3	2287	2018-10-22 15:17:31	2018-10-22	13
6819	1	2288	2018-10-22 14:27:25	2018-10-22	12
6820	2	2288	2018-10-22 14:27:26	2018-10-22	12
6821	3	2288	2018-11-08 10:44:33	2018-11-08	9
6822	1	2289	2018-10-22 14:20:03	2018-10-22	12
6823	2	2289	2018-10-22 14:20:06	2018-10-22	12
6824	3	2289	2018-10-22 14:20:09	2018-10-22	12
6825	1	2290	2018-10-22 14:21:46	2018-10-22	12
6826	2	2290	2018-10-22 14:21:48	2018-10-22	12
6827	3	2290	2018-10-22 14:22:52	2018-10-22	12
6828	1	2291	2018-10-22 14:19:43	2018-10-22	12
6829	2	2291	2018-10-22 14:19:45	2018-10-22	12
6830	3	2291	2018-10-22 14:19:46	2018-10-22	12
6831	1	2292	2018-10-22 14:16:55	2018-10-22	12
6832	2	2292	2018-10-22 14:16:59	2018-10-22	12
6833	3	2292	2018-10-22 14:17:02	2018-10-22	12
6834	1	2293	2018-10-22 14:16:26	2018-10-22	12
6835	2	2293	2018-10-22 14:16:29	2018-10-22	12
6836	3	2293	2018-10-22 14:16:32	2018-10-22	12
6837	1	2294	2018-10-22 14:12:09	2018-10-22	12
6838	2	2294	2018-10-22 14:12:12	2018-10-22	12
6839	3	2294	2018-10-22 15:20:39	2018-10-22	13
6840	1	2295	2018-10-22 14:11:49	2018-10-22	12
6841	2	2295	2018-10-22 14:11:52	2018-10-22	12
6842	3	2295	2018-10-22 14:23:47	2018-10-22	12
6843	1	2296	2018-10-22 14:08:01	2018-10-22	12
6844	2	2296	2018-10-22 14:08:03	2018-10-22	12
6845	3	2296	2018-10-22 14:08:05	2018-10-22	12
6846	1	2297	2018-10-22 14:05:24	2018-10-22	12
6847	2	2297	2018-10-22 14:05:26	2018-10-22	12
6848	3	2297	2018-10-22 14:05:28	2018-10-22	12
6849	1	2298	2018-10-22 14:03:07	2018-10-22	12
6850	2	2298	2018-10-22 14:03:09	2018-10-22	12
6851	3	2298	2018-10-22 14:03:10	2018-10-22	12
6852	1	2299	2018-10-22 13:56:15	2018-10-22	11
6853	2	2299	2018-10-22 13:56:18	2018-10-22	11
6854	3	2299	2018-11-06 11:31:58	2018-11-06	10
6855	1	2300	2018-10-22 12:24:08	2018-10-22	10
6856	2	2300	2018-10-22 12:24:11	2018-10-22	10
6857	3	2300	2018-10-22 14:21:58	2018-10-22	12
6858	1	2301	2018-10-22 12:12:08	2018-10-22	10
6859	2	2301	2018-10-22 12:12:11	2018-10-22	10
6860	3	2301	2018-10-22 12:12:13	2018-10-22	10
6861	1	2302	2018-10-22 12:04:48	2018-10-22	10
6862	2	2302	2018-10-22 12:04:50	2018-10-22	10
6863	3	2302	2018-10-22 12:04:52	2018-10-22	10
6864	1	2303	2018-10-22 11:58:01	2018-10-22	9
6865	2	2303	2018-10-22 11:58:03	2018-10-22	9
6866	3	2303	2018-10-22 11:58:05	2018-10-22	9
6867	1	2304	2018-10-22 12:06:40	2018-10-22	10
6868	2	2304	2018-10-22 12:06:43	2018-10-22	10
6869	3	2304	2018-10-22 13:33:50	2018-10-22	11
6870	1	2305	2018-10-22 11:48:09	2018-10-22	9
6871	2	2305	2018-10-22 11:48:11	2018-10-22	9
6872	3	2305	2018-10-22 12:18:38	2018-10-22	10
6873	1	2306	2018-10-22 11:44:35	2018-10-22	9
6874	2	2306	2018-10-22 11:44:38	2018-10-22	9
6875	3	2306	2018-10-22 11:44:41	2018-10-22	9
6876	1	2307	2018-10-22 11:45:54	2018-10-22	9
6877	2	2307	2018-10-22 11:45:56	2018-10-22	9
6878	3	2307	2018-10-23 08:21:30	2018-10-23	6
6879	1	2308	2018-10-22 11:42:37	2018-10-22	9
6880	2	2308	2018-10-22 11:42:40	2018-10-22	9
6881	3	2308	2018-10-22 11:42:43	2018-10-22	9
6882	1	2309	2018-10-22 11:39:01	2018-10-22	9
6883	2	2309	2018-10-22 11:39:03	2018-10-22	9
6884	3	2309	2018-10-22 12:19:06	2018-10-22	10
6885	1	2310	2018-10-22 11:31:35	2018-10-22	9
6886	2	2310	2018-10-22 11:31:36	2018-10-22	9
6887	3	2310	2018-10-22 11:31:38	2018-10-22	9
6888	1	2311	2018-10-22 11:28:58	2018-10-22	9
6889	2	2311	2018-10-22 11:29:02	2018-10-22	9
6890	3	2311	2018-10-22 11:29:05	2018-10-22	9
6891	1	2312	2018-10-22 11:27:24	2018-10-22	9
6892	2	2312	2018-10-22 11:27:27	2018-10-22	9
6893	3	2312	2018-10-22 11:27:56	2018-10-22	9
6894	1	2313	2018-10-22 11:21:23	2018-10-22	9
6895	2	2313	2018-10-22 11:21:25	2018-10-22	9
6896	3	2313	2018-10-22 11:21:27	2018-10-22	9
6897	1	2314	2018-10-22 11:17:23	2018-10-22	9
6898	2	2314	2018-10-22 11:17:25	2018-10-22	9
6899	3	2314	2018-10-22 11:29:49	2018-10-22	9
6900	1	2315	2018-10-22 11:14:09	2018-10-22	9
6901	2	2315	2018-10-22 11:14:13	2018-10-22	9
6902	3	2315	2018-10-22 11:14:20	2018-10-22	9
6903	1	2316	2018-10-22 11:12:01	2018-10-22	9
6904	2	2316	2018-10-22 11:12:02	2018-10-22	9
6905	3	2316	2018-10-22 11:12:04	2018-10-22	9
6906	1	2317	2018-10-22 11:09:58	2018-10-22	9
6907	2	2317	2018-10-22 11:10:01	2018-10-22	9
6908	3	2317	2018-10-22 11:59:20	2018-10-22	9
6909	1	2318	2018-10-22 11:07:10	2018-10-22	9
6910	2	2318	2018-10-22 11:07:12	2018-10-22	9
6911	3	2318	2018-10-22 11:07:14	2018-10-22	9
6912	1	2319	2018-10-22 11:10:29	2018-10-22	9
6913	2	2319	2018-10-22 11:10:32	2018-10-22	9
6914	3	2319	2018-10-23 08:34:21	2018-10-23	6
6915	1	2320	2018-10-22 11:00:32	2018-10-22	9
6916	2	2320	2018-10-22 11:00:34	2018-10-22	9
6917	3	2320	2018-10-22 11:00:35	2018-10-22	9
6918	1	2321	2018-10-22 10:59:42	2018-10-22	8
6919	2	2321	2018-10-22 10:59:44	2018-10-22	8
6920	3	2321	2018-10-22 10:59:46	2018-10-22	8
6921	1	2322	2018-10-22 10:54:49	2018-10-22	8
6922	2	2322	2018-10-22 10:54:51	2018-10-22	8
6923	3	2322	2018-10-22 10:54:53	2018-10-22	8
6924	1	2323	2018-10-22 10:53:56	2018-10-22	8
6925	2	2323	2018-10-22 10:53:57	2018-10-22	8
6926	3	2323	2018-10-22 10:53:59	2018-10-22	8
6927	1	2324	2018-10-22 10:51:26	2018-10-22	8
6928	2	2324	2018-10-22 10:51:27	2018-10-22	8
6929	3	2324	2018-10-22 10:51:29	2018-10-22	8
6930	1	2325	2018-10-22 10:47:39	2018-10-22	8
6931	2	2325	2018-10-22 10:47:42	2018-10-22	8
6932	3	2325	2018-10-22 10:47:45	2018-10-22	8
6933	1	2326	2018-10-22 10:50:06	2018-10-22	8
6934	2	2326	2018-10-22 10:50:08	2018-10-22	8
6935	3	2326	2018-10-23 10:46:02	2018-10-23	8
6936	1	2327	2018-10-22 10:33:02	2018-10-22	8
6937	2	2327	2018-10-22 10:33:04	2018-10-22	8
6938	3	2327	2018-10-22 10:33:05	2018-10-22	8
6939	1	2328	2018-10-22 10:32:11	2018-10-22	8
6940	2	2328	2018-10-22 10:32:14	2018-10-22	8
6941	3	2328	2018-10-22 10:32:17	2018-10-22	8
6942	1	2329	2018-10-22 10:24:36	2018-10-22	8
6943	2	2329	2018-10-22 10:24:38	2018-10-22	8
6944	3	2329	2018-10-22 10:24:40	2018-10-22	8
6945	1	2330	2018-10-22 10:19:59	2018-10-22	8
6946	2	2330	2018-10-22 10:20:01	2018-10-22	8
6947	3	2330	2018-10-22 10:20:03	2018-10-22	8
6948	1	2331	2018-10-22 10:11:53	2018-10-22	8
6949	2	2331	2018-10-22 10:11:55	2018-10-22	8
6950	3	2331	2018-10-22 10:11:57	2018-10-22	8
6951	1	2332	2018-10-22 10:10:38	2018-10-22	8
6952	2	2332	2018-10-22 10:10:40	2018-10-22	8
6953	3	2332	2018-10-22 10:10:41	2018-10-22	8
6954	1	2333	2018-10-22 10:13:07	2018-10-22	8
6955	2	2333	2018-10-22 10:13:09	2018-10-22	8
6956	3	2333	2018-10-22 10:53:18	2018-10-22	8
6957	1	2334	2018-10-22 10:08:45	2018-10-22	8
6958	2	2334	2018-10-22 10:08:48	2018-10-22	8
6959	3	2334	2018-10-22 10:19:20	2018-10-22	8
6960	1	2335	2018-10-22 10:05:00	2018-10-22	8
6961	2	2335	2018-10-22 10:05:02	2018-10-22	8
6962	3	2335	2018-10-22 10:05:04	2018-10-22	8
6963	1	2336	2018-10-22 10:03:58	2018-10-22	8
6964	2	2336	2018-10-22 10:04:00	2018-10-22	8
6965	3	2336	2018-10-22 10:04:02	2018-10-22	8
6966	1	2337	2018-10-22 09:58:43	2018-10-22	7
6967	2	2337	2018-10-22 09:58:45	2018-10-22	7
6968	3	2337	2018-10-22 10:20:10	2018-10-22	8
6969	1	2338	2018-10-22 09:54:35	2018-10-22	7
6970	2	2338	2018-10-22 09:54:38	2018-10-22	7
6971	3	2338	2018-10-22 09:54:41	2018-10-22	7
6972	1	2339	2018-10-22 09:54:03	2018-10-22	7
6973	2	2339	2018-10-22 09:54:05	2018-10-22	7
6974	3	2339	2018-10-22 09:54:07	2018-10-22	7
6975	1	2340	2018-10-22 09:52:47	2018-10-22	7
6976	2	2340	2018-10-22 09:52:50	2018-10-22	7
6977	3	2340	2018-10-22 09:52:52	2018-10-22	7
6978	1	2341	2018-10-22 09:51:41	2018-10-22	7
6979	2	2341	2018-10-22 09:51:43	2018-10-22	7
6980	3	2341	2018-10-22 09:51:45	2018-10-22	7
6981	1	2342	2018-10-22 09:47:30	2018-10-22	7
6982	2	2342	2018-10-22 09:47:33	2018-10-22	7
6983	3	2342	2018-10-23 10:13:10	2018-10-23	8
6984	1	2343	2018-10-22 09:44:15	2018-10-22	7
6985	2	2343	2018-10-22 09:44:17	2018-10-22	7
6986	3	2343	2018-10-22 09:44:18	2018-10-22	7
6987	1	2344	2018-10-22 09:38:49	2018-10-22	7
6988	2	2344	2018-10-22 09:38:51	2018-10-22	7
6989	3	2344	2018-10-22 09:38:53	2018-10-22	7
6990	1	2345	2018-10-22 09:36:41	2018-10-22	7
6991	2	2345	2018-10-22 09:36:43	2018-10-22	7
6992	3	2345	2018-10-22 09:37:01	2018-10-22	7
6993	1	2346	2018-10-22 09:36:22	2018-10-22	7
6994	2	2346	2018-10-22 09:36:24	2018-10-22	7
6995	3	2346	2018-10-22 09:36:25	2018-10-22	7
6996	1	2347	2018-10-22 09:34:02	2018-10-22	7
6997	2	2347	2018-10-22 09:34:05	2018-10-22	7
6998	3	2347	2018-10-22 10:59:52	2018-10-22	8
6999	1	2348	2018-10-22 09:31:05	2018-10-22	7
7000	2	2348	2018-10-22 09:31:07	2018-10-22	7
7001	3	2348	2018-10-22 09:31:09	2018-10-22	7
7002	1	2349	2018-10-22 09:29:31	2018-10-22	7
7003	2	2349	2018-10-22 09:29:33	2018-10-22	7
7004	3	2349	2018-10-22 10:49:21	2018-10-22	8
7005	1	2350	2018-10-22 09:24:52	2018-10-22	7
7006	2	2350	2018-10-22 09:24:53	2018-10-22	7
7007	3	2350	2018-10-22 09:24:55	2018-10-22	7
7008	1	2351	2018-10-22 09:22:29	2018-10-22	7
7009	2	2351	2018-10-22 09:22:30	2018-10-22	7
7010	3	2351	2018-10-22 09:22:32	2018-10-22	7
7011	1	2352	2018-10-22 09:23:11	2018-10-22	7
7012	2	2352	2018-10-22 09:23:13	2018-10-22	7
7013	3	2352	2018-10-22 09:31:05	2018-10-22	7
7014	1	2353	2018-10-22 09:20:19	2018-10-22	7
7015	2	2353	2018-10-22 09:20:21	2018-10-22	7
7016	3	2353	2018-10-22 09:20:23	2018-10-22	7
7017	1	2354	2018-10-22 09:19:06	2018-10-22	7
7018	2	2354	2018-10-22 09:19:08	2018-10-22	7
7019	3	2354	2018-10-22 09:19:10	2018-10-22	7
7020	1	2355	2018-10-22 09:19:16	2018-10-22	7
7021	2	2355	2018-10-22 09:19:17	2018-10-22	7
7022	3	2355	2018-10-22 09:19:19	2018-10-22	7
7023	1	2356	2018-10-22 09:08:33	2018-10-22	7
7024	2	2356	2018-10-22 09:08:34	2018-10-22	7
7025	3	2356	2018-10-22 09:08:36	2018-10-22	7
7026	1	2357	2018-10-22 09:22:04	2018-10-22	7
7027	2	2357	2018-10-22 09:22:08	2018-10-22	7
7028	3	2357	2018-11-06 11:25:32	2018-11-06	10
7029	1	2358	2018-10-22 09:04:06	2018-10-22	7
7030	2	2358	2018-10-22 09:04:08	2018-10-22	7
7031	3	2358	2018-10-22 09:04:10	2018-10-22	7
7032	1	2359	2018-10-22 09:02:21	2018-10-22	7
7033	2	2359	2018-10-22 09:02:24	2018-10-22	7
7034	3	2359	2018-10-22 09:02:26	2018-10-22	7
7035	1	2360	2018-10-22 08:59:33	2018-10-22	6
7036	2	2360	2018-10-22 08:59:35	2018-10-22	6
7037	3	2360	2018-10-22 10:24:51	2018-10-22	8
7038	1	2361	2018-10-22 08:58:27	2018-10-22	6
7039	2	2361	2018-10-22 08:58:29	2018-10-22	6
7040	3	2361	2018-10-22 11:51:53	2018-10-22	9
7041	1	2362	2018-10-22 08:40:20	2018-10-22	6
7042	2	2362	2018-10-22 08:40:23	2018-10-22	6
7043	3	2362	2018-10-22 09:04:22	2018-10-22	7
7044	1	2363	2018-10-22 08:34:19	2018-10-22	6
7045	2	2363	2018-10-22 08:34:21	2018-10-22	6
7046	3	2363	2018-10-22 08:34:22	2018-10-22	6
7047	1	2364	2018-10-22 07:56:55	2018-10-22	5
7048	2	2364	2018-10-22 07:56:58	2018-10-22	5
7049	3	2364	2018-10-22 07:58:15	2018-10-22	5
7050	1	2365	2018-10-22 07:46:00	2018-10-22	5
7051	2	2365	2018-10-22 07:46:02	2018-10-22	5
7052	3	2365	2018-11-06 12:07:02	2018-11-06	11
7053	1	2366	2018-10-21 18:16:27	2018-10-21	16
7054	2	2366	2018-10-21 18:16:30	2018-10-21	16
7055	3	2366	2018-10-22 08:28:14	2018-10-22	6
7056	1	2367	2018-10-21 16:20:16	2018-10-21	14
7057	2	2367	2018-10-21 16:20:19	2018-10-21	14
7058	1	2368	2018-10-19 23:34:05	2018-10-19	21
7059	2	2368	2018-10-19 23:34:07	2018-10-19	21
7060	3	2368	2018-11-08 10:46:44	2018-11-08	9
7061	1	2369	2018-10-19 16:50:17	2018-10-19	14
7062	2	2369	2018-10-19 16:50:18	2018-10-19	14
7063	3	2369	2018-10-19 16:50:20	2018-10-19	14
7064	1	2370	2018-10-19 16:28:54	2018-10-19	14
7065	2	2370	2018-10-19 16:28:56	2018-10-19	14
7066	3	2370	2018-10-19 16:28:58	2018-10-19	14
7067	1	2371	2018-10-19 16:27:56	2018-10-19	14
7068	2	2371	2018-10-19 16:27:58	2018-10-19	14
7069	1	2372	2018-10-19 16:23:10	2018-10-19	14
7070	2	2372	2018-10-19 16:23:13	2018-10-19	14
7071	3	2372	2018-10-19 16:23:16	2018-10-19	14
7072	1	2373	2018-10-19 16:22:22	2018-10-19	14
7073	2	2373	2018-10-19 16:22:23	2018-10-19	14
7074	3	2373	2018-10-19 16:22:25	2018-10-19	14
7075	1	2374	2018-10-19 15:52:34	2018-10-19	13
7076	2	2374	2018-10-19 15:52:36	2018-10-19	13
7077	3	2374	2018-10-19 15:52:38	2018-10-19	13
7078	1	2375	2018-10-19 15:53:08	2018-10-19	13
7079	2	2375	2018-10-19 15:53:12	2018-10-19	13
7080	3	2375	2018-11-08 10:49:30	2018-11-08	9
7081	1	2376	2018-10-19 15:50:01	2018-10-19	13
7082	2	2376	2018-10-19 15:50:03	2018-10-19	13
7083	3	2376	2018-10-19 15:50:04	2018-10-19	13
7084	1	2377	2018-10-19 15:47:22	2018-10-19	13
7085	2	2377	2018-10-19 15:47:24	2018-10-19	13
7086	3	2377	2018-10-19 15:47:26	2018-10-19	13
7087	1	2378	2018-10-19 15:45:12	2018-10-19	13
7088	2	2378	2018-10-19 15:45:14	2018-10-19	13
7089	3	2378	2018-10-19 15:45:16	2018-10-19	13
7090	1	2379	2018-10-19 15:44:33	2018-10-19	13
7091	2	2379	2018-10-19 15:44:34	2018-10-19	13
7092	3	2379	2018-10-19 15:44:36	2018-10-19	13
7093	1	2380	2018-10-19 15:25:17	2018-10-19	13
7094	2	2380	2018-10-19 15:25:20	2018-10-19	13
7095	3	2380	2018-10-19 15:25:23	2018-10-19	13
7096	1	2381	2018-10-19 15:24:52	2018-10-19	13
7097	2	2381	2018-10-19 15:24:54	2018-10-19	13
7098	3	2381	2018-10-19 15:24:56	2018-10-19	13
7099	1	2382	2018-10-19 15:28:56	2018-10-19	13
7100	2	2382	2018-10-19 15:28:58	2018-10-19	13
7101	3	2382	2018-10-22 10:00:02	2018-10-22	8
7102	1	2383	2018-10-19 15:12:23	2018-10-19	13
7103	2	2383	2018-10-19 15:12:25	2018-10-19	13
7104	3	2383	2018-10-19 15:12:27	2018-10-19	13
7105	1	2384	2018-10-19 15:11:05	2018-10-19	13
7106	2	2384	2018-10-19 15:11:08	2018-10-19	13
7107	3	2384	2018-10-23 11:34:03	2018-10-23	9
7108	1	2385	2018-10-19 14:56:18	2018-10-19	12
7109	2	2385	2018-10-19 14:56:21	2018-10-19	12
7110	3	2385	2018-10-19 14:56:22	2018-10-19	12
7111	1	2386	2018-10-19 14:41:33	2018-10-19	12
7112	2	2386	2018-10-19 14:41:35	2018-10-19	12
7113	3	2386	2018-10-22 08:25:30	2018-10-22	6
7114	1	2387	2018-10-19 14:39:12	2018-10-19	12
7115	2	2387	2018-10-19 14:39:15	2018-10-19	12
7116	3	2387	2018-10-19 14:39:18	2018-10-19	12
7117	1	2388	2018-10-19 14:34:41	2018-10-19	12
7118	2	2388	2018-10-19 14:34:42	2018-10-19	12
7119	3	2388	2018-11-08 10:51:35	2018-11-08	9
7120	1	2389	2018-10-19 14:28:18	2018-10-19	12
7121	2	2389	2018-10-19 14:28:22	2018-10-19	12
7122	3	2389	2018-10-19 14:28:25	2018-10-19	12
7123	1	2390	2018-10-19 14:24:43	2018-10-19	12
7124	2	2390	2018-10-19 14:24:45	2018-10-19	12
7125	3	2390	2018-10-19 14:24:46	2018-10-19	12
7126	1	2391	2018-10-19 14:23:14	2018-10-19	12
7127	2	2391	2018-10-19 14:23:17	2018-10-19	12
7128	3	2391	2018-10-19 14:23:19	2018-10-19	12
7129	1	2392	2018-10-19 14:13:15	2018-10-19	12
7130	2	2392	2018-10-19 14:13:19	2018-10-19	12
7131	3	2392	2018-10-19 14:13:21	2018-10-19	12
7132	1	2393	2018-10-19 12:27:26	2018-10-19	10
7133	2	2393	2018-10-19 12:27:28	2018-10-19	10
7134	3	2393	2018-10-19 12:27:30	2018-10-19	10
7135	1	2394	2018-10-19 12:07:08	2018-10-19	10
7136	2	2394	2018-10-19 12:07:10	2018-10-19	10
7137	3	2394	2018-10-19 12:07:12	2018-10-19	10
7138	1	2395	2018-10-19 11:57:15	2018-10-19	9
7139	2	2395	2018-10-19 11:57:17	2018-10-19	9
7140	3	2395	2018-10-19 11:57:19	2018-10-19	9
7141	1	2396	2018-10-19 11:57:38	2018-10-19	9
7142	2	2396	2018-10-19 11:57:41	2018-10-19	9
7143	3	2396	2018-10-19 11:57:43	2018-10-19	9
7144	1	2397	2018-10-19 11:48:40	2018-10-19	9
7145	2	2397	2018-10-19 11:48:42	2018-10-19	9
7146	3	2397	2018-10-19 11:48:44	2018-10-19	9
7147	1	2398	2018-10-19 11:48:13	2018-10-19	9
7148	2	2398	2018-10-19 11:48:15	2018-10-19	9
7149	3	2398	2018-10-19 11:48:17	2018-10-19	9
7150	1	2399	2018-10-19 11:45:29	2018-10-19	9
7151	2	2399	2018-10-19 11:45:32	2018-10-19	9
7152	3	2399	2018-10-19 14:01:27	2018-10-19	12
7153	1	2400	2018-10-19 11:43:47	2018-10-19	9
7154	2	2400	2018-10-19 11:43:50	2018-10-19	9
7155	3	2400	2018-10-22 09:57:00	2018-10-22	7
7156	1	2401	2018-10-19 11:39:37	2018-10-19	9
7157	2	2401	2018-10-19 11:39:39	2018-10-19	9
7158	3	2401	2018-10-19 11:56:21	2018-10-19	9
7159	1	2402	2018-10-19 11:35:37	2018-10-19	9
7160	2	2402	2018-10-19 11:35:39	2018-10-19	9
7161	3	2402	2018-10-19 11:35:41	2018-10-19	9
7162	1	2403	2018-10-19 11:24:25	2018-10-19	9
7163	2	2403	2018-10-19 11:24:28	2018-10-19	9
7164	3	2403	2018-10-22 09:56:03	2018-10-22	7
7165	1	2404	2018-10-19 11:13:36	2018-10-19	9
7166	2	2404	2018-10-19 11:13:38	2018-10-19	9
7167	3	2404	2018-10-22 09:50:23	2018-10-22	7
7168	1	2405	2018-10-19 11:13:30	2018-10-19	9
7169	2	2405	2018-10-19 11:13:33	2018-10-19	9
7170	3	2405	2018-10-19 14:45:55	2018-10-19	12
7171	1	2406	2018-10-19 11:10:00	2018-10-19	9
7172	2	2406	2018-10-19 11:10:04	2018-10-19	9
7173	3	2406	2018-10-22 08:11:40	2018-10-22	6
7174	1	2407	2018-10-19 11:08:22	2018-10-19	9
7175	2	2407	2018-10-19 11:08:23	2018-10-19	9
7176	3	2407	2018-10-22 10:04:12	2018-10-22	8
7177	1	2408	2018-10-19 11:03:52	2018-10-19	9
7178	2	2408	2018-10-19 11:03:54	2018-10-19	9
7179	3	2408	2018-10-19 11:03:56	2018-10-19	9
7180	1	2409	2018-10-19 10:56:20	2018-10-19	8
7181	2	2409	2018-10-19 10:56:22	2018-10-19	8
7182	3	2409	2018-10-19 10:56:24	2018-10-19	8
7183	1	2410	2018-10-19 10:56:30	2018-10-19	8
7184	2	2410	2018-10-19 10:56:33	2018-10-19	8
7185	3	2410	2018-11-08 10:55:10	2018-11-08	9
7186	1	2411	2018-10-19 10:56:44	2018-10-19	8
7187	2	2411	2018-10-19 10:56:46	2018-10-19	8
7188	3	2411	2018-10-22 10:04:49	2018-10-22	8
7189	1	2412	2018-10-19 10:42:36	2018-10-19	8
7190	2	2412	2018-10-19 10:42:39	2018-10-19	8
7191	3	2412	2018-11-08 11:08:05	2018-11-08	10
7192	1	2413	2018-10-19 10:40:01	2018-10-19	8
7193	2	2413	2018-10-19 10:40:03	2018-10-19	8
7194	3	2413	2018-10-19 10:40:05	2018-10-19	8
7195	1	2414	2018-10-19 10:35:42	2018-10-19	8
7196	2	2414	2018-10-19 10:35:44	2018-10-19	8
7197	3	2414	2018-10-19 10:35:46	2018-10-19	8
7198	1	2415	2018-10-19 10:34:20	2018-10-19	8
7199	2	2415	2018-10-19 10:34:23	2018-10-19	8
7200	3	2415	2018-10-22 10:05:16	2018-10-22	8
7201	1	2416	2018-10-19 10:29:39	2018-10-19	8
7202	2	2416	2018-10-19 10:29:41	2018-10-19	8
7203	3	2416	2018-10-19 10:29:43	2018-10-19	8
7204	1	2417	2018-10-19 10:25:55	2018-10-19	8
7205	2	2417	2018-10-19 10:25:57	2018-10-19	8
7206	3	2417	2018-10-19 10:25:59	2018-10-19	8
7207	1	2418	2018-10-19 10:25:20	2018-10-19	8
7208	2	2418	2018-10-19 10:25:22	2018-10-19	8
7209	3	2418	2018-10-19 10:25:24	2018-10-19	8
7210	1	2419	2018-10-19 10:27:34	2018-10-19	8
7211	2	2419	2018-10-19 10:27:35	2018-10-19	8
7212	3	2419	2018-10-19 10:27:37	2018-10-19	8
7213	1	2420	2018-10-19 10:19:01	2018-10-19	8
7214	2	2420	2018-10-19 10:19:03	2018-10-19	8
7215	3	2420	2018-10-19 10:19:05	2018-10-19	8
7216	1	2421	2018-10-19 10:11:17	2018-10-19	8
7217	2	2421	2018-10-19 10:11:19	2018-10-19	8
7218	3	2421	2018-10-19 10:11:21	2018-10-19	8
7219	1	2422	2018-10-19 10:09:42	2018-10-19	8
7220	2	2422	2018-10-19 10:09:44	2018-10-19	8
7221	3	2422	2018-10-19 10:09:46	2018-10-19	8
7222	1	2423	2018-10-19 10:08:22	2018-10-19	8
7223	2	2423	2018-10-19 10:08:24	2018-10-19	8
7224	3	2423	2018-10-19 10:08:26	2018-10-19	8
7225	1	2424	2018-10-19 10:07:24	2018-10-19	8
7226	2	2424	2018-10-19 10:07:26	2018-10-19	8
7227	3	2424	2018-10-19 10:07:28	2018-10-19	8
7228	1	2425	2018-10-19 09:58:35	2018-10-19	7
7229	2	2425	2018-10-19 09:58:36	2018-10-19	7
7230	3	2425	2018-10-19 09:58:38	2018-10-19	7
7231	1	2426	2018-10-19 09:51:57	2018-10-19	7
7232	2	2426	2018-10-19 09:52:00	2018-10-19	7
7233	3	2426	2018-10-19 09:52:02	2018-10-19	7
7234	1	2427	2018-10-19 09:47:11	2018-10-19	7
7235	2	2427	2018-10-19 09:47:12	2018-10-19	7
7236	3	2427	2018-10-19 09:47:14	2018-10-19	7
7237	1	2428	2018-10-19 09:46:39	2018-10-19	7
7238	2	2428	2018-10-19 09:46:41	2018-10-19	7
7239	3	2428	2018-10-19 09:46:43	2018-10-19	7
7240	1	2429	2018-10-19 09:48:44	2018-10-19	7
7241	2	2429	2018-10-19 09:48:46	2018-10-19	7
7242	3	2429	2018-10-19 10:02:21	2018-10-19	8
7243	1	2430	2018-10-19 09:46:05	2018-10-19	7
7244	2	2430	2018-10-19 09:46:06	2018-10-19	7
7245	3	2430	2018-10-19 09:46:08	2018-10-19	7
7246	1	2431	2018-10-19 09:41:54	2018-10-19	7
7247	2	2431	2018-10-19 09:41:56	2018-10-19	7
7248	3	2431	2018-10-19 09:41:58	2018-10-19	7
7249	1	2432	2018-10-19 09:40:59	2018-10-19	7
7250	2	2432	2018-10-19 09:41:01	2018-10-19	7
7251	3	2432	2018-10-19 09:41:03	2018-10-19	7
7252	1	2433	2018-10-19 09:40:35	2018-10-19	7
7253	2	2433	2018-10-19 09:40:37	2018-10-19	7
7254	3	2433	2018-10-19 09:40:39	2018-10-19	7
7255	1	2434	2018-10-19 09:43:17	2018-10-19	7
7256	2	2434	2018-10-19 09:43:20	2018-10-19	7
7257	3	2434	2018-10-19 10:36:41	2018-10-19	8
7258	1	2435	2018-10-19 09:35:41	2018-10-19	7
7259	2	2435	2018-10-19 09:35:43	2018-10-19	7
7260	3	2435	2018-10-19 09:35:45	2018-10-19	7
7261	1	2436	2018-10-19 09:37:28	2018-10-19	7
7262	2	2436	2018-10-19 09:37:30	2018-10-19	7
7263	3	2436	2018-10-22 09:53:21	2018-10-22	7
7264	1	2437	2018-10-19 09:33:56	2018-10-19	7
7265	2	2437	2018-10-19 09:33:58	2018-10-19	7
7266	3	2437	2018-10-19 09:34:00	2018-10-19	7
7267	1	2438	2018-10-19 09:33:15	2018-10-19	7
7268	2	2438	2018-10-19 09:33:17	2018-10-19	7
7269	3	2438	2018-10-19 09:33:19	2018-10-19	7
7270	1	2439	2018-10-19 09:32:26	2018-10-19	7
7271	2	2439	2018-10-19 09:32:28	2018-10-19	7
7272	3	2439	2018-10-19 09:32:30	2018-10-19	7
7273	1	2440	2018-10-19 09:27:20	2018-10-19	7
7274	2	2440	2018-10-19 09:27:22	2018-10-19	7
7275	3	2440	2018-10-19 09:27:24	2018-10-19	7
7276	1	2441	2018-10-19 09:18:07	2018-10-19	7
7277	2	2441	2018-10-19 09:18:10	2018-10-19	7
7278	3	2441	2018-10-19 09:18:13	2018-10-19	7
7279	1	2442	2018-10-19 09:17:10	2018-10-19	7
7280	2	2442	2018-10-19 09:17:13	2018-10-19	7
7281	3	2442	2018-10-19 10:24:37	2018-10-19	8
7282	1	2443	2018-10-19 09:15:35	2018-10-19	7
7283	2	2443	2018-10-19 09:15:38	2018-10-19	7
7284	3	2443	2018-10-19 10:29:44	2018-10-19	8
7285	1	2444	2018-10-19 09:13:49	2018-10-19	7
7286	2	2444	2018-10-19 09:13:51	2018-10-19	7
7287	3	2444	2018-10-19 09:13:53	2018-10-19	7
7288	1	2445	2018-10-19 09:12:06	2018-10-19	7
7289	2	2445	2018-10-19 09:12:08	2018-10-19	7
7290	3	2445	2018-10-19 09:12:10	2018-10-19	7
7291	1	2446	2018-10-19 09:10:06	2018-10-19	7
7292	2	2446	2018-10-19 09:10:07	2018-10-19	7
7293	3	2446	2018-10-19 09:10:09	2018-10-19	7
7294	1	2447	2018-10-19 09:09:08	2018-10-19	7
7295	2	2447	2018-10-19 09:09:10	2018-10-19	7
7296	3	2447	2018-10-19 09:09:12	2018-10-19	7
7297	1	2448	2018-10-19 09:07:51	2018-10-19	7
7298	2	2448	2018-10-19 09:07:53	2018-10-19	7
7299	3	2448	2018-10-22 09:39:58	2018-10-22	7
7300	1	2449	2018-10-19 09:04:07	2018-10-19	7
7301	2	2449	2018-10-19 09:04:10	2018-10-19	7
7302	3	2449	2018-10-19 09:04:13	2018-10-19	7
7303	1	2450	2018-10-19 08:38:11	2018-10-19	6
7304	2	2450	2018-10-19 08:38:13	2018-10-19	6
7305	3	2450	2018-10-19 08:38:15	2018-10-19	6
7306	1	2451	2018-10-19 08:33:43	2018-10-19	6
7307	2	2451	2018-10-19 08:33:45	2018-10-19	6
7308	3	2451	2018-10-22 10:05:37	2018-10-22	8
7309	1	2452	2018-10-18 16:49:30	2018-10-18	14
7310	2	2452	2018-10-18 16:49:31	2018-10-18	14
7311	3	2452	2018-10-22 10:45:48	2018-10-22	8
7312	1	2453	2018-10-18 16:44:59	2018-10-18	14
7313	2	2453	2018-10-18 16:45:00	2018-10-18	14
7314	3	2453	2018-10-18 16:45:03	2018-10-18	14
7315	1	2454	2018-10-18 16:46:46	2018-10-18	14
7316	2	2454	2018-10-18 16:46:47	2018-10-18	14
7317	3	2454	2018-10-18 17:01:22	2018-10-18	15
7318	1	2455	2018-10-18 16:42:31	2018-10-18	14
7319	2	2455	2018-10-18 16:42:33	2018-10-18	14
7320	3	2455	2018-10-19 08:17:47	2018-10-19	6
7321	1	2456	2018-10-18 16:37:17	2018-10-18	14
7322	2	2456	2018-10-18 16:37:19	2018-10-18	14
7323	3	2456	2018-10-22 08:13:59	2018-10-22	6
7324	1	2457	2018-10-18 16:37:09	2018-10-18	14
7325	2	2457	2018-10-18 16:37:11	2018-10-18	14
7326	3	2457	2018-10-19 08:24:56	2018-10-19	6
7327	1	2458	2018-10-18 16:27:06	2018-10-18	14
7328	2	2458	2018-10-18 16:27:08	2018-10-18	14
7329	3	2458	2018-10-18 16:27:10	2018-10-18	14
7330	1	2459	2018-10-18 16:26:27	2018-10-18	14
7331	2	2459	2018-10-18 16:26:30	2018-10-18	14
7332	3	2459	2018-10-18 16:26:33	2018-10-18	14
7333	1	2460	2018-10-18 16:16:23	2018-10-18	14
7334	2	2460	2018-10-18 16:16:25	2018-10-18	14
7335	1	2461	2018-10-18 16:05:34	2018-10-18	14
7336	2	2461	2018-10-18 16:05:37	2018-10-18	14
7337	3	2461	2018-10-19 14:03:42	2018-10-19	12
7338	1	2462	2018-10-18 16:04:41	2018-10-18	14
7339	2	2462	2018-10-18 16:04:44	2018-10-18	14
7340	3	2462	2018-10-18 16:04:47	2018-10-18	14
7341	1	2463	2018-10-18 16:01:23	2018-10-18	14
7342	2	2463	2018-10-18 16:01:25	2018-10-18	14
7343	3	2463	2018-10-18 16:01:26	2018-10-18	14
7344	1	2464	2018-10-18 15:57:26	2018-10-18	13
7345	2	2464	2018-10-18 15:57:29	2018-10-18	13
7346	3	2464	2018-10-18 16:04:36	2018-10-18	14
7347	1	2465	2018-10-18 15:48:09	2018-10-18	13
7348	2	2465	2018-10-18 15:48:11	2018-10-18	13
7349	3	2465	2018-10-19 08:52:00	2018-10-19	6
7350	1	2466	2018-10-18 15:35:56	2018-10-18	13
7351	2	2466	2018-10-18 15:35:57	2018-10-18	13
7352	3	2466	2018-10-18 15:35:59	2018-10-18	13
7353	1	2467	2018-10-18 15:36:43	2018-10-18	13
7354	2	2467	2018-10-18 15:36:46	2018-10-18	13
7355	3	2467	2018-10-19 09:58:58	2018-10-19	7
7356	1	2468	2018-10-18 15:30:55	2018-10-18	13
7357	2	2468	2018-10-18 15:30:57	2018-10-18	13
7358	3	2468	2018-10-18 15:30:59	2018-10-18	13
7359	1	2469	2018-10-18 15:25:40	2018-10-18	13
7360	2	2469	2018-10-18 15:25:41	2018-10-18	13
7361	3	2469	2018-10-18 15:36:55	2018-10-18	13
7362	1	2470	2018-10-18 15:22:38	2018-10-18	13
7363	2	2470	2018-10-18 15:22:40	2018-10-18	13
7364	3	2470	2018-10-18 15:22:42	2018-10-18	13
7365	1	2471	2018-10-18 15:20:12	2018-10-18	13
7366	2	2471	2018-10-18 15:20:16	2018-10-18	13
7367	3	2471	2018-10-19 07:51:23	2018-10-19	5
7368	1	2472	2018-10-18 15:04:56	2018-10-18	13
7369	2	2472	2018-10-18 15:04:58	2018-10-18	13
7370	3	2472	2018-10-18 15:05:00	2018-10-18	13
7371	1	2473	2018-10-18 15:00:20	2018-10-18	13
7372	2	2473	2018-10-18 15:00:22	2018-10-18	13
7373	3	2473	2018-10-18 15:07:48	2018-10-18	13
7374	1	2474	2018-10-18 14:43:07	2018-10-18	12
7375	2	2474	2018-10-18 14:43:09	2018-10-18	12
7376	3	2474	2018-10-18 14:43:11	2018-10-18	12
7377	1	2475	2018-10-18 14:43:33	2018-10-18	12
7378	2	2475	2018-10-18 14:43:36	2018-10-18	12
7379	3	2475	2018-10-18 14:43:39	2018-10-18	12
7380	1	2476	2018-10-18 14:36:18	2018-10-18	12
7381	2	2476	2018-10-18 14:36:21	2018-10-18	12
7382	3	2476	2018-11-08 10:57:00	2018-11-08	9
7383	1	2477	2018-10-18 14:30:30	2018-10-18	12
7384	2	2477	2018-10-18 14:30:31	2018-10-18	12
7385	3	2477	2018-10-18 14:30:33	2018-10-18	12
7386	1	2478	2018-10-18 14:31:48	2018-10-18	12
7387	2	2478	2018-10-18 14:31:51	2018-10-18	12
7388	3	2478	2018-10-18 14:31:53	2018-10-18	12
7389	1	2479	2018-10-18 14:29:32	2018-10-18	12
7390	2	2479	2018-10-18 14:29:34	2018-10-18	12
7391	3	2479	2018-10-18 14:29:36	2018-10-18	12
7392	1	2480	2018-10-18 14:28:04	2018-10-18	12
7393	2	2480	2018-10-18 14:28:07	2018-10-18	12
7394	3	2480	2018-10-18 14:36:42	2018-10-18	12
7395	1	2481	2018-10-18 14:28:57	2018-10-18	12
7396	2	2481	2018-10-18 14:28:59	2018-10-18	12
7397	3	2481	2018-10-18 14:30:48	2018-10-18	12
7398	1	2482	2018-10-18 14:20:16	2018-10-18	12
7399	2	2482	2018-10-18 14:20:18	2018-10-18	12
7400	3	2482	2018-11-08 15:51:58	2018-11-08	14
7401	1	2483	2018-10-18 14:16:58	2018-10-18	12
7402	2	2483	2018-10-18 14:17:00	2018-10-18	12
7403	3	2483	2018-10-18 14:17:02	2018-10-18	12
7404	1	2484	2018-10-18 14:16:13	2018-10-18	12
7405	2	2484	2018-10-18 14:16:15	2018-10-18	12
7406	3	2484	2018-10-18 14:16:17	2018-10-18	12
7407	1	2485	2018-10-18 13:39:45	2018-10-18	11
7408	2	2485	2018-10-18 13:39:47	2018-10-18	11
7409	3	2485	2018-10-18 13:39:50	2018-10-18	11
7410	1	2486	2018-10-18 13:30:57	2018-10-18	11
7411	2	2486	2018-10-18 13:30:59	2018-10-18	11
7412	3	2486	2018-10-18 14:43:31	2018-10-18	12
7413	1	2487	2018-10-18 12:24:45	2018-10-18	10
7414	2	2487	2018-10-18 12:24:47	2018-10-18	10
7415	3	2487	2018-10-18 12:24:49	2018-10-18	10
7416	1	2488	2018-10-18 12:11:01	2018-10-18	10
7417	2	2488	2018-10-18 12:11:04	2018-10-18	10
7418	3	2488	2018-10-18 12:11:07	2018-10-18	10
7419	1	2489	2018-10-18 11:55:51	2018-10-18	9
7420	2	2489	2018-10-18 11:55:54	2018-10-18	9
7421	3	2489	2018-10-18 11:55:56	2018-10-18	9
7422	1	2490	2018-10-18 11:44:54	2018-10-18	9
7423	2	2490	2018-10-18 11:44:55	2018-10-18	9
7424	3	2490	2018-10-18 11:44:57	2018-10-18	9
7425	1	2491	2018-10-18 11:43:47	2018-10-18	9
7426	2	2491	2018-10-18 11:43:49	2018-10-18	9
7427	3	2491	2018-10-18 11:43:51	2018-10-18	9
7428	1	2492	2018-10-18 11:39:26	2018-10-18	9
7429	2	2492	2018-10-18 11:39:28	2018-10-18	9
7430	3	2492	2018-10-18 11:39:30	2018-10-18	9
7431	1	2493	2018-10-18 11:39:48	2018-10-18	9
7432	2	2493	2018-10-18 11:39:51	2018-10-18	9
7433	3	2493	2018-10-18 14:45:46	2018-10-18	12
7434	1	2494	2018-10-18 11:38:44	2018-10-18	9
7435	2	2494	2018-10-18 11:38:45	2018-10-18	9
7436	3	2494	2018-10-18 11:38:48	2018-10-18	9
7437	1	2495	2018-10-18 11:50:35	2018-10-18	9
7438	2	2495	2018-10-18 11:50:36	2018-10-18	9
7439	3	2495	2018-10-18 11:50:38	2018-10-18	9
7440	1	2496	2018-10-18 11:36:42	2018-10-18	9
7441	2	2496	2018-10-18 11:36:46	2018-10-18	9
7442	3	2496	2018-10-18 11:36:49	2018-10-18	9
7443	1	2497	2018-10-18 11:26:42	2018-10-18	9
7444	2	2497	2018-10-18 11:26:45	2018-10-18	9
7445	3	2497	2018-10-18 11:26:48	2018-10-18	9
7446	1	2498	2018-10-18 11:25:53	2018-10-18	9
7447	2	2498	2018-10-18 11:25:55	2018-10-18	9
7448	3	2498	2018-10-18 11:45:55	2018-10-18	9
7449	1	2499	2018-10-18 11:19:26	2018-10-18	9
7450	2	2499	2018-10-18 11:19:29	2018-10-18	9
7451	3	2499	2018-10-18 14:42:10	2018-10-18	12
7452	1	2500	2018-10-18 11:16:53	2018-10-18	9
7453	2	2500	2018-10-18 11:16:55	2018-10-18	9
7454	3	2500	2018-10-18 11:16:57	2018-10-18	9
7455	1	2501	2018-10-18 11:12:07	2018-10-18	9
7456	2	2501	2018-10-18 11:12:13	2018-10-18	9
7457	3	2501	2018-10-18 11:12:16	2018-10-18	9
7458	1	2502	2018-10-18 11:08:58	2018-10-18	9
7459	2	2502	2018-10-18 11:09:02	2018-10-18	9
7460	3	2502	2018-10-18 11:09:05	2018-10-18	9
7461	1	2503	2018-10-18 11:09:23	2018-10-18	9
7462	2	2503	2018-10-18 11:09:25	2018-10-18	9
7463	3	2503	2018-10-18 11:09:27	2018-10-18	9
7464	1	2504	2018-10-18 11:06:33	2018-10-18	9
7465	2	2504	2018-10-18 11:06:36	2018-10-18	9
7466	3	2504	2018-10-18 11:06:38	2018-10-18	9
7467	1	2505	2018-10-18 11:02:26	2018-10-18	9
7468	2	2505	2018-10-18 11:02:28	2018-10-18	9
7469	3	2505	2018-10-18 11:02:31	2018-10-18	9
7470	1	2506	2018-10-18 10:48:00	2018-10-18	8
7471	2	2506	2018-10-18 10:48:02	2018-10-18	8
7472	3	2506	2018-10-18 10:48:03	2018-10-18	8
7473	1	2507	2018-10-18 10:45:55	2018-10-18	8
7474	2	2507	2018-10-18 10:45:57	2018-10-18	8
7475	3	2507	2018-10-18 10:45:58	2018-10-18	8
7476	1	2508	2018-10-18 10:48:54	2018-10-18	8
7477	2	2508	2018-10-18 10:48:57	2018-10-18	8
7478	3	2508	2018-10-18 10:49:00	2018-10-18	8
7479	1	2509	2018-10-18 10:43:54	2018-10-18	8
7480	2	2509	2018-10-18 10:43:57	2018-10-18	8
7481	3	2509	2018-10-18 10:44:00	2018-10-18	8
7482	1	2510	2018-10-18 10:42:42	2018-10-18	8
7483	2	2510	2018-10-18 10:42:45	2018-10-18	8
7484	3	2510	2018-10-18 13:55:23	2018-10-18	11
7485	1	2511	2018-10-18 10:39:37	2018-10-18	8
7486	2	2511	2018-10-18 10:39:40	2018-10-18	8
7487	3	2511	2018-10-18 14:28:51	2018-10-18	12
7488	1	2512	2018-10-18 10:33:14	2018-10-18	8
7489	2	2512	2018-10-18 10:33:16	2018-10-18	8
7490	3	2512	2018-10-18 10:58:05	2018-10-18	8
7491	1	2513	2018-10-18 10:33:12	2018-10-18	8
7492	2	2513	2018-10-18 10:33:14	2018-10-18	8
7493	1	2514	2018-10-18 10:31:14	2018-10-18	8
7494	2	2514	2018-10-18 10:31:17	2018-10-18	8
7495	3	2514	2018-10-18 10:31:20	2018-10-18	8
7496	1	2515	2018-10-18 10:31:12	2018-10-18	8
7497	2	2515	2018-10-18 10:31:15	2018-10-18	8
7498	3	2515	2018-10-18 12:03:18	2018-10-18	10
7499	1	2516	2018-10-18 10:25:49	2018-10-18	8
7500	2	2516	2018-10-18 10:25:51	2018-10-18	8
7501	3	2516	2018-10-18 10:25:52	2018-10-18	8
7502	1	2517	2018-10-18 10:07:13	2018-10-18	8
7503	2	2517	2018-10-18 10:07:15	2018-10-18	8
7504	3	2517	2018-10-18 10:07:17	2018-10-18	8
7505	1	2518	2018-10-18 10:02:02	2018-10-18	8
7506	2	2518	2018-10-18 10:02:05	2018-10-18	8
7507	3	2518	2018-10-18 10:02:07	2018-10-18	8
7508	1	2519	2018-10-18 10:01:44	2018-10-18	8
7509	2	2519	2018-10-18 10:01:46	2018-10-18	8
7510	3	2519	2018-10-18 10:01:48	2018-10-18	8
7511	1	2520	2018-10-18 10:00:12	2018-10-18	8
7512	2	2520	2018-10-18 10:00:14	2018-10-18	8
7513	3	2520	2018-10-18 10:00:15	2018-10-18	8
7514	1	2521	2018-10-18 10:02:54	2018-10-18	8
7515	2	2521	2018-10-18 10:02:57	2018-10-18	8
7516	3	2521	2018-10-18 14:47:36	2018-10-18	12
7517	1	2522	2018-10-18 09:53:30	2018-10-18	7
7518	2	2522	2018-10-18 09:53:32	2018-10-18	7
7519	3	2522	2018-10-23 10:31:01	2018-10-23	8
7520	1	2523	2018-10-18 09:56:19	2018-10-18	7
7521	2	2523	2018-10-18 09:56:21	2018-10-18	7
7522	3	2523	2018-10-18 10:24:33	2018-10-18	8
7523	1	2524	2018-10-18 09:44:41	2018-10-18	7
7524	2	2524	2018-10-18 09:44:43	2018-10-18	7
7525	3	2524	2018-10-18 09:44:45	2018-10-18	7
7526	1	2525	2018-10-18 09:44:15	2018-10-18	7
7527	2	2525	2018-10-18 09:44:17	2018-10-18	7
7528	3	2525	2018-10-18 09:44:19	2018-10-18	7
7529	1	2526	2018-10-18 09:49:10	2018-10-18	7
7530	2	2526	2018-10-18 09:49:13	2018-10-18	7
7531	3	2526	2018-10-18 14:25:55	2018-10-18	12
7532	1	2527	2018-10-18 09:38:25	2018-10-18	7
7533	2	2527	2018-10-18 09:38:27	2018-10-18	7
7534	3	2527	2018-10-18 09:38:29	2018-10-18	7
7535	1	2528	2018-10-18 11:31:54	2018-10-18	9
7536	2	2528	2018-10-18 11:31:59	2018-10-18	9
7537	3	2528	2018-10-18 13:52:28	2018-10-18	11
7538	1	2529	2018-10-18 09:36:55	2018-10-18	7
7539	2	2529	2018-10-18 09:36:58	2018-10-18	7
7540	3	2529	2018-10-18 09:48:59	2018-10-18	7
7541	1	2530	2018-10-18 09:31:46	2018-10-18	7
7542	2	2530	2018-10-18 09:31:48	2018-10-18	7
7543	3	2530	2018-10-18 09:31:50	2018-10-18	7
7544	1	2531	2018-10-18 09:24:53	2018-10-18	7
7545	2	2531	2018-10-18 09:24:56	2018-10-18	7
7546	3	2531	2018-10-18 12:04:37	2018-10-18	10
7547	1	2532	2018-10-18 09:26:14	2018-10-18	7
7548	2	2532	2018-10-18 09:26:18	2018-10-18	7
7549	3	2532	2018-10-18 09:26:20	2018-10-18	7
7550	1	2533	2018-10-18 09:22:30	2018-10-18	7
7551	2	2533	2018-10-18 09:22:32	2018-10-18	7
7552	3	2533	2018-10-18 09:22:34	2018-10-18	7
7553	1	2534	2018-10-18 09:20:06	2018-10-18	7
7554	2	2534	2018-10-18 09:20:08	2018-10-18	7
7555	3	2534	2018-10-18 09:20:10	2018-10-18	7
7556	1	2535	2018-10-18 09:17:55	2018-10-18	7
7557	2	2535	2018-10-18 09:17:57	2018-10-18	7
7558	3	2535	2018-10-18 09:17:59	2018-10-18	7
7559	1	2536	2018-10-18 09:17:07	2018-10-18	7
7560	2	2536	2018-10-18 09:17:10	2018-10-18	7
7561	3	2536	2018-10-18 12:02:08	2018-10-18	10
7562	1	2537	2018-10-18 09:15:22	2018-10-18	7
7563	2	2537	2018-10-18 09:15:24	2018-10-18	7
7564	3	2537	2018-10-18 09:15:26	2018-10-18	7
7565	1	2538	2018-10-18 09:16:32	2018-10-18	7
7566	2	2538	2018-10-18 09:16:35	2018-10-18	7
7567	3	2538	2018-10-18 09:16:37	2018-10-18	7
7568	1	2539	2018-10-18 09:12:18	2018-10-18	7
7569	2	2539	2018-10-18 09:12:21	2018-10-18	7
7570	3	2539	2018-10-18 09:12:23	2018-10-18	7
7571	1	2540	2018-10-18 09:00:07	2018-10-18	7
7572	2	2540	2018-10-18 09:00:08	2018-10-18	7
7573	3	2540	2018-10-18 09:00:10	2018-10-18	7
7574	1	2541	2018-10-18 09:03:36	2018-10-18	7
7575	2	2541	2018-10-18 09:03:38	2018-10-18	7
7576	3	2541	2018-10-18 09:10:16	2018-10-18	7
7577	1	2542	2018-10-18 08:58:22	2018-10-18	6
7578	2	2542	2018-10-18 08:58:23	2018-10-18	6
7579	3	2542	2018-10-18 08:58:25	2018-10-18	6
7580	1	2543	2018-10-18 08:59:20	2018-10-18	6
7581	2	2543	2018-10-18 08:59:22	2018-10-18	6
7582	3	2543	2018-10-18 08:59:24	2018-10-18	6
7583	1	2544	2018-10-18 08:57:37	2018-10-18	6
7584	2	2544	2018-10-18 08:57:38	2018-10-18	6
7585	3	2544	2018-10-18 11:30:57	2018-10-18	9
7586	1	2545	2018-10-18 08:50:25	2018-10-18	6
7587	2	2545	2018-10-18 08:50:28	2018-10-18	6
7588	3	2545	2018-10-23 09:01:21	2018-10-23	7
7589	1	2546	2018-10-18 08:46:43	2018-10-18	6
7590	2	2546	2018-10-18 08:46:45	2018-10-18	6
7591	3	2546	2018-10-18 08:46:47	2018-10-18	6
7592	1	2547	2018-10-18 08:43:37	2018-10-18	6
7593	2	2547	2018-10-18 08:43:39	2018-10-18	6
7594	3	2547	2018-10-18 08:43:40	2018-10-18	6
7595	1	2548	2018-10-18 08:44:56	2018-10-18	6
7596	2	2548	2018-10-18 08:44:59	2018-10-18	6
7597	3	2548	2018-10-18 10:08:48	2018-10-18	8
7598	1	2549	2018-10-18 08:42:03	2018-10-18	6
7599	2	2549	2018-10-18 08:42:06	2018-10-18	6
7600	3	2549	2018-10-18 14:52:32	2018-10-18	12
7601	1	2550	2018-10-18 08:38:44	2018-10-18	6
7602	2	2550	2018-10-18 08:38:46	2018-10-18	6
7603	3	2550	2018-10-18 08:38:48	2018-10-18	6
7604	1	2551	2018-10-18 08:36:56	2018-10-18	6
7605	2	2551	2018-10-18 08:36:58	2018-10-18	6
7606	3	2551	2018-10-18 08:37:00	2018-10-18	6
7607	1	2552	2018-10-18 08:29:42	2018-10-18	6
7608	2	2552	2018-10-18 08:29:46	2018-10-18	6
7609	3	2552	2018-10-18 13:54:54	2018-10-18	11
7610	1	2553	2018-10-18 08:00:02	2018-10-18	6
7611	2	2553	2018-10-18 08:00:05	2018-10-18	6
7612	3	2553	2018-10-18 14:39:29	2018-10-18	12
7613	1	2554	2018-10-18 07:54:09	2018-10-18	5
7614	2	2554	2018-10-18 07:54:13	2018-10-18	5
7615	3	2554	2018-10-18 14:49:39	2018-10-18	12
7616	1	2555	2018-10-18 07:47:51	2018-10-18	5
7617	2	2555	2018-10-18 07:47:53	2018-10-18	5
7618	3	2555	2018-10-18 13:53:17	2018-10-18	11
7619	1	2556	2018-10-17 16:57:42	2018-10-17	14
7620	2	2556	2018-10-17 16:57:44	2018-10-17	14
7621	3	2556	2018-10-18 09:15:30	2018-10-18	7
7622	1	2557	2018-10-17 16:56:26	2018-10-17	14
7623	2	2557	2018-10-17 16:56:29	2018-10-17	14
7624	3	2557	2018-10-18 13:44:31	2018-10-18	11
7625	1	2558	2018-10-17 16:53:57	2018-10-17	14
7626	2	2558	2018-10-17 16:53:58	2018-10-17	14
7627	3	2558	2018-10-17 16:54:00	2018-10-17	14
7628	1	2559	2018-10-17 16:46:07	2018-10-17	14
7629	2	2559	2018-10-17 16:46:08	2018-10-17	14
7630	3	2559	2018-10-17 16:46:10	2018-10-17	14
7631	1	2560	2018-10-17 16:44:06	2018-10-17	14
7632	2	2560	2018-10-17 16:44:08	2018-10-17	14
7633	3	2560	2018-10-18 09:47:44	2018-10-18	7
7634	1	2561	2018-10-17 16:33:24	2018-10-17	14
7635	2	2561	2018-10-17 16:33:26	2018-10-17	14
7636	3	2561	2018-10-17 16:33:27	2018-10-17	14
7637	1	2562	2018-10-17 16:29:15	2018-10-17	14
7638	2	2562	2018-10-17 16:29:17	2018-10-17	14
7639	3	2562	2018-10-18 13:43:18	2018-10-18	11
7640	1	2563	2018-10-17 16:27:54	2018-10-17	14
7641	2	2563	2018-10-17 16:27:57	2018-10-17	14
7642	3	2563	2018-10-18 13:41:00	2018-10-18	11
7643	1	2564	2018-10-17 16:26:29	2018-10-17	14
7644	2	2564	2018-10-17 16:26:32	2018-10-17	14
7645	3	2564	2018-10-18 14:50:13	2018-10-18	12
7646	1	2565	2018-10-17 16:24:34	2018-10-17	14
7647	2	2565	2018-10-17 16:24:36	2018-10-17	14
7648	3	2565	2018-10-17 16:24:38	2018-10-17	14
7649	1	2566	2018-10-17 16:12:35	2018-10-17	14
7650	2	2566	2018-10-17 16:12:38	2018-10-17	14
7651	3	2566	2018-11-08 11:03:34	2018-11-08	10
7652	1	2567	2018-10-17 16:11:20	2018-10-17	14
7653	2	2567	2018-10-17 16:11:22	2018-10-17	14
7654	3	2567	2018-10-19 14:14:10	2018-10-19	12
7655	1	2568	2018-10-17 16:10:33	2018-10-17	14
7656	2	2568	2018-10-17 16:10:35	2018-10-17	14
7657	3	2568	2018-10-18 08:32:33	2018-10-18	6
7658	1	2569	2018-10-17 16:09:05	2018-10-17	14
7659	2	2569	2018-10-17 16:09:06	2018-10-17	14
7660	3	2569	2018-10-18 13:37:46	2018-10-18	11
7661	1	2570	2018-10-17 16:20:06	2018-10-17	14
7662	2	2570	2018-10-17 16:20:09	2018-10-17	14
7663	3	2570	2018-10-18 08:34:31	2018-10-18	6
7664	1	2571	2018-10-17 16:00:57	2018-10-17	14
7665	2	2571	2018-10-17 16:00:58	2018-10-17	14
7666	3	2571	2018-10-17 16:01:01	2018-10-17	14
7667	1	2572	2018-10-17 15:59:47	2018-10-17	13
7668	2	2572	2018-10-17 15:59:50	2018-10-17	13
7669	3	2572	2018-10-17 15:59:52	2018-10-17	13
7670	1	2573	2018-10-17 15:53:34	2018-10-17	13
7671	2	2573	2018-10-17 15:53:36	2018-10-17	13
7672	3	2573	2018-10-17 15:53:38	2018-10-17	13
7673	1	2574	2018-10-17 15:43:38	2018-10-17	13
7674	2	2574	2018-10-17 15:43:41	2018-10-17	13
7675	3	2574	2018-10-17 15:43:44	2018-10-17	13
7676	1	2575	2018-10-17 15:42:55	2018-10-17	13
7677	2	2575	2018-10-17 15:42:59	2018-10-17	13
7678	3	2575	2018-10-18 08:46:42	2018-10-18	6
7679	1	2576	2018-10-17 15:39:13	2018-10-17	13
7680	2	2576	2018-10-17 15:39:15	2018-10-17	13
7681	3	2576	2018-10-17 15:39:17	2018-10-17	13
7682	1	2577	2018-10-17 15:33:57	2018-10-17	13
7683	2	2577	2018-10-17 15:33:59	2018-10-17	13
7684	3	2577	2018-10-17 15:34:01	2018-10-17	13
7685	1	2578	2018-10-17 15:33:55	2018-10-17	13
7686	2	2578	2018-10-17 15:33:57	2018-10-17	13
7687	3	2578	2018-10-17 15:33:59	2018-10-17	13
7688	1	2579	2018-10-17 15:31:52	2018-10-17	13
7689	2	2579	2018-10-17 15:31:54	2018-10-17	13
7690	3	2579	2018-10-17 15:31:56	2018-10-17	13
7691	1	2580	2018-10-17 15:31:21	2018-10-17	13
7692	2	2580	2018-10-17 15:31:23	2018-10-17	13
7693	3	2580	2018-10-17 15:59:11	2018-10-17	13
7694	1	2581	2018-10-17 15:31:17	2018-10-17	13
7695	2	2581	2018-10-17 15:31:19	2018-10-17	13
7696	3	2581	2018-10-22 12:02:19	2018-10-22	10
7697	1	2582	2018-10-17 15:26:30	2018-10-17	13
7698	2	2582	2018-10-17 15:26:32	2018-10-17	13
7699	3	2582	2018-10-17 15:26:33	2018-10-17	13
7700	1	2583	2018-10-17 15:22:53	2018-10-17	13
7701	2	2583	2018-10-17 15:22:55	2018-10-17	13
7702	3	2583	2018-10-17 15:22:57	2018-10-17	13
7703	1	2584	2018-10-17 15:25:25	2018-10-17	13
7704	2	2584	2018-10-17 15:25:28	2018-10-17	13
7705	3	2584	2018-10-18 08:49:05	2018-10-18	6
7706	1	2585	2018-10-17 15:12:35	2018-10-17	13
7707	2	2585	2018-10-17 15:12:36	2018-10-17	13
7708	3	2585	2018-10-17 15:12:38	2018-10-17	13
7709	1	2586	2018-10-17 15:10:16	2018-10-17	13
7710	2	2586	2018-10-17 15:10:17	2018-10-17	13
7711	3	2586	2018-10-17 15:10:19	2018-10-17	13
7712	1	2587	2018-10-17 15:08:45	2018-10-17	13
7713	2	2587	2018-10-17 15:08:48	2018-10-17	13
7714	3	2587	2018-10-18 09:06:55	2018-10-18	7
7715	1	2588	2018-10-17 15:08:46	2018-10-17	13
7716	2	2588	2018-10-17 15:08:47	2018-10-17	13
7717	3	2588	2018-10-17 15:55:53	2018-10-17	13
7718	1	2589	2018-10-17 15:09:04	2018-10-17	13
7719	2	2589	2018-10-17 15:09:07	2018-10-17	13
7720	3	2589	2018-10-18 13:36:43	2018-10-18	11
7721	1	2590	2018-10-17 14:57:17	2018-10-17	12
7722	2	2590	2018-10-17 14:57:19	2018-10-17	12
7723	3	2590	2018-10-17 14:57:21	2018-10-17	12
7724	1	2591	2018-10-17 14:59:35	2018-10-17	12
7725	2	2591	2018-10-17 14:59:38	2018-10-17	12
7726	3	2591	2018-10-18 08:52:54	2018-10-18	6
7727	1	2592	2018-10-17 14:56:12	2018-10-17	12
7728	2	2592	2018-10-17 14:56:14	2018-10-17	12
7729	3	2592	2018-10-17 14:56:16	2018-10-17	12
7730	1	2593	2018-10-17 14:55:29	2018-10-17	12
7731	2	2593	2018-10-17 14:55:32	2018-10-17	12
7732	3	2593	2018-10-18 08:25:20	2018-10-18	6
7733	1	2594	2018-10-17 14:54:34	2018-10-17	12
7734	2	2594	2018-10-17 14:54:36	2018-10-17	12
7735	3	2594	2018-10-18 13:33:58	2018-10-18	11
7736	1	2595	2018-10-17 14:48:19	2018-10-17	12
7737	2	2595	2018-10-17 14:48:21	2018-10-17	12
7738	3	2595	2018-10-17 14:48:23	2018-10-17	12
7739	1	2596	2018-10-17 14:48:48	2018-10-17	12
7740	2	2596	2018-10-17 14:48:50	2018-10-17	12
7741	3	2596	2018-10-18 13:32:11	2018-10-18	11
7742	1	2597	2018-10-17 14:38:41	2018-10-17	12
7743	2	2597	2018-10-17 14:38:43	2018-10-17	12
7744	3	2597	2018-10-17 14:38:44	2018-10-17	12
7745	1	2598	2018-10-17 14:45:38	2018-10-17	12
7746	2	2598	2018-10-17 14:45:42	2018-10-17	12
7747	3	2598	2018-10-17 14:45:44	2018-10-17	12
7748	1	2599	2018-10-17 14:29:14	2018-10-17	12
7749	2	2599	2018-10-17 14:29:16	2018-10-17	12
7750	3	2599	2018-10-17 14:29:18	2018-10-17	12
7751	1	2600	2018-10-17 14:29:01	2018-10-17	12
7752	2	2600	2018-10-17 14:29:03	2018-10-17	12
7753	3	2600	2018-10-17 14:29:05	2018-10-17	12
7754	1	2601	2018-10-17 14:32:28	2018-10-17	12
7755	2	2601	2018-10-17 14:32:29	2018-10-17	12
7756	3	2601	2018-10-18 13:39:57	2018-10-18	11
7757	1	2602	2018-10-17 14:30:53	2018-10-17	12
7758	2	2602	2018-10-17 14:30:56	2018-10-17	12
7759	3	2602	2018-10-18 13:23:18	2018-10-18	11
7760	1	2603	2018-10-17 14:27:13	2018-10-17	12
7761	2	2603	2018-10-17 14:27:15	2018-10-17	12
7762	3	2603	2018-10-17 14:27:16	2018-10-17	12
7763	1	2604	2018-10-17 14:24:10	2018-10-17	12
7764	2	2604	2018-10-17 14:24:12	2018-10-17	12
7765	3	2604	2018-10-17 14:24:14	2018-10-17	12
7766	1	2605	2018-10-17 14:23:17	2018-10-17	12
7767	2	2605	2018-10-17 14:23:20	2018-10-17	12
7768	3	2605	2018-10-17 14:23:23	2018-10-17	12
7769	1	2606	2018-10-17 14:22:57	2018-10-17	12
7770	2	2606	2018-10-17 14:22:59	2018-10-17	12
7771	3	2606	2018-10-19 12:04:47	2018-10-19	10
7772	1	2607	2018-10-17 14:18:22	2018-10-17	12
7773	2	2607	2018-10-17 14:18:24	2018-10-17	12
7774	3	2607	2018-10-17 14:18:25	2018-10-17	12
7775	1	2608	2018-10-17 14:16:43	2018-10-17	12
7776	2	2608	2018-10-17 14:16:45	2018-10-17	12
7777	3	2608	2018-10-17 14:16:47	2018-10-17	12
7778	1	2609	2018-10-17 14:12:29	2018-10-17	12
7779	2	2609	2018-10-17 14:12:30	2018-10-17	12
7780	3	2609	2018-10-18 13:21:27	2018-10-18	11
7781	1	2610	2018-10-17 14:10:12	2018-10-17	12
7782	2	2610	2018-10-17 14:10:14	2018-10-17	12
7783	3	2610	2018-10-17 14:10:16	2018-10-17	12
7784	1	2611	2018-10-17 14:06:53	2018-10-17	12
7785	2	2611	2018-10-17 14:06:56	2018-10-17	12
7786	3	2611	2018-10-17 14:06:57	2018-10-17	12
7787	1	2612	2018-10-17 14:05:43	2018-10-17	12
7788	2	2612	2018-10-17 14:05:45	2018-10-17	12
7789	3	2612	2018-10-17 14:05:47	2018-10-17	12
7790	1	2613	2018-10-17 14:06:13	2018-10-17	12
7791	2	2613	2018-10-17 14:06:16	2018-10-17	12
7792	3	2613	2018-10-18 14:31:29	2018-10-18	12
7793	1	2614	2018-10-17 14:05:44	2018-10-17	12
7794	2	2614	2018-10-17 14:05:47	2018-10-17	12
7795	3	2614	2018-10-18 08:42:58	2018-10-18	6
7796	1	2615	2018-10-17 14:03:17	2018-10-17	12
7797	2	2615	2018-10-17 14:03:20	2018-10-17	12
7798	3	2615	2018-10-17 14:03:23	2018-10-17	12
7799	1	2616	2018-10-17 13:32:16	2018-10-17	11
7800	2	2616	2018-10-17 13:32:18	2018-10-17	11
7801	3	2616	2018-10-19 12:01:11	2018-10-19	10
7802	1	2617	2018-10-17 13:12:15	2018-10-17	11
7803	2	2617	2018-10-17 13:12:17	2018-10-17	11
7804	3	2617	2018-10-17 13:21:35	2018-10-17	11
7805	1	2618	2018-10-17 12:08:28	2018-10-17	10
7806	2	2618	2018-10-17 12:08:30	2018-10-17	10
7807	3	2618	2018-10-18 13:13:30	2018-10-18	11
7808	1	2619	2018-10-17 12:05:29	2018-10-17	10
7809	2	2619	2018-10-17 12:05:31	2018-10-17	10
7810	3	2619	2018-10-18 13:07:37	2018-10-18	11
7811	1	2620	2018-10-17 12:00:53	2018-10-17	10
7812	2	2620	2018-10-17 12:00:55	2018-10-17	10
7813	3	2620	2018-10-18 08:54:54	2018-10-18	6
7814	1	2621	2018-10-17 11:53:58	2018-10-17	9
7815	2	2621	2018-10-17 11:54:00	2018-10-17	9
7816	3	2621	2018-10-17 11:54:02	2018-10-17	9
7817	1	2622	2018-10-17 11:51:41	2018-10-17	9
7818	2	2622	2018-10-17 11:51:42	2018-10-17	9
7819	3	2622	2018-10-17 11:51:44	2018-10-17	9
7820	1	2623	2018-10-17 11:52:31	2018-10-17	9
7821	2	2623	2018-10-17 11:52:33	2018-10-17	9
7822	3	2623	2018-10-19 11:37:30	2018-10-19	9
7823	1	2624	2018-10-17 11:51:57	2018-10-17	9
7824	2	2624	2018-10-17 11:52:02	2018-10-17	9
7825	3	2624	2018-10-17 13:49:52	2018-10-17	11
7826	1	2625	2018-10-17 11:42:09	2018-10-17	9
7827	2	2625	2018-10-17 11:42:12	2018-10-17	9
7828	3	2625	2018-10-19 11:59:30	2018-10-19	9
7829	1	2626	2018-10-17 11:39:27	2018-10-17	9
7830	2	2626	2018-10-17 11:39:28	2018-10-17	9
7831	3	2626	2018-10-17 13:51:11	2018-10-17	11
7832	1	2627	2018-10-17 11:37:43	2018-10-17	9
7833	2	2627	2018-10-17 11:37:47	2018-10-17	9
7834	3	2627	2018-10-18 11:54:18	2018-10-18	9
7835	1	2628	2018-10-17 11:33:02	2018-10-17	9
7836	2	2628	2018-10-17 11:33:03	2018-10-17	9
7837	3	2628	2018-10-17 11:33:06	2018-10-17	9
7838	1	2629	2018-10-17 11:37:15	2018-10-17	9
7839	2	2629	2018-10-17 11:37:18	2018-10-17	9
7840	3	2629	2018-10-19 11:58:17	2018-10-19	9
7841	1	2630	2018-10-17 11:32:40	2018-10-17	9
7842	2	2630	2018-10-17 11:32:42	2018-10-17	9
7843	3	2630	2018-10-18 11:26:46	2018-10-18	9
7844	1	2631	2018-10-17 11:32:04	2018-10-17	9
7845	2	2631	2018-10-17 11:32:06	2018-10-17	9
7846	3	2631	2018-10-17 11:57:19	2018-10-17	9
7847	1	2632	2018-10-17 11:30:03	2018-10-17	9
7848	2	2632	2018-10-17 11:30:05	2018-10-17	9
7849	3	2632	2018-10-17 11:30:07	2018-10-17	9
7850	1	2633	2018-10-17 11:29:15	2018-10-17	9
7851	2	2633	2018-10-17 11:29:16	2018-10-17	9
7852	3	2633	2018-10-19 14:12:54	2018-10-19	12
7853	1	2634	2018-10-17 11:27:36	2018-10-17	9
7854	2	2634	2018-10-17 11:27:38	2018-10-17	9
7855	3	2634	2018-10-17 12:01:35	2018-10-17	10
7856	1	2635	2018-10-17 11:30:54	2018-10-17	9
7857	2	2635	2018-10-17 11:30:57	2018-10-17	9
7858	3	2635	2018-10-17 11:31:00	2018-10-17	9
7859	1	2636	2018-10-17 11:25:54	2018-10-17	9
7860	2	2636	2018-10-17 11:25:56	2018-10-17	9
7861	3	2636	2018-10-17 11:25:58	2018-10-17	9
7862	1	2637	2018-10-17 11:21:34	2018-10-17	9
7863	2	2637	2018-10-17 11:21:37	2018-10-17	9
7864	3	2637	2018-10-18 11:17:56	2018-10-18	9
7865	1	2638	2018-10-17 11:13:33	2018-10-17	9
7866	2	2638	2018-10-17 11:13:35	2018-10-17	9
7867	3	2638	2018-10-17 11:13:37	2018-10-17	9
7868	1	2639	2018-10-17 11:11:14	2018-10-17	9
7869	2	2639	2018-10-17 11:11:16	2018-10-17	9
7870	3	2639	2018-10-17 11:11:18	2018-10-17	9
7871	1	2640	2018-10-17 11:11:07	2018-10-17	9
7872	2	2640	2018-10-17 11:11:09	2018-10-17	9
7873	3	2640	2018-10-17 11:11:10	2018-10-17	9
7874	1	2641	2018-10-17 11:11:15	2018-10-17	9
7875	2	2641	2018-10-17 11:11:17	2018-10-17	9
7876	3	2641	2018-10-23 10:32:40	2018-10-23	8
7877	1	2642	2018-10-17 11:05:00	2018-10-17	9
7878	2	2642	2018-10-17 11:05:03	2018-10-17	9
7879	3	2642	2018-10-17 11:17:58	2018-10-17	9
7880	1	2643	2018-10-17 11:02:53	2018-10-17	9
7881	2	2643	2018-10-17 11:02:56	2018-10-17	9
7882	3	2643	2018-10-17 11:23:33	2018-10-17	9
7883	1	2644	2018-10-17 10:59:06	2018-10-17	8
7884	2	2644	2018-10-17 10:59:08	2018-10-17	8
7885	3	2644	2018-10-17 10:59:10	2018-10-17	8
7886	1	2645	2018-10-17 10:59:54	2018-10-17	8
7887	2	2645	2018-10-17 10:59:57	2018-10-17	8
7888	3	2645	2018-10-17 14:16:44	2018-10-17	12
7889	1	2646	2018-10-17 11:00:27	2018-10-17	9
7890	2	2646	2018-10-17 11:00:28	2018-10-17	9
7891	3	2646	2018-10-17 11:16:28	2018-10-17	9
7892	1	2647	2018-10-17 10:57:34	2018-10-17	8
7893	2	2647	2018-10-17 10:57:36	2018-10-17	8
7894	3	2647	2018-10-17 10:57:38	2018-10-17	8
7895	1	2648	2018-10-17 10:57:21	2018-10-17	8
7896	2	2648	2018-10-17 10:57:23	2018-10-17	8
7897	3	2648	2018-10-17 10:57:25	2018-10-17	8
7898	1	2649	2018-10-17 10:55:48	2018-10-17	8
7899	2	2649	2018-10-17 10:55:50	2018-10-17	8
7900	3	2649	2018-10-17 10:55:52	2018-10-17	8
7901	1	2650	2018-10-17 10:56:16	2018-10-17	8
7902	2	2650	2018-10-17 10:56:18	2018-10-17	8
7903	3	2650	2018-10-17 11:19:33	2018-10-17	9
7904	1	2651	2018-10-17 10:57:34	2018-10-17	8
7905	2	2651	2018-10-17 10:57:38	2018-10-17	8
7906	3	2651	2018-10-18 10:32:12	2018-10-18	8
7907	1	2652	2018-10-17 10:49:47	2018-10-17	8
7908	2	2652	2018-10-17 10:49:49	2018-10-17	8
7909	3	2652	2018-10-17 10:49:51	2018-10-17	8
7910	1	2653	2018-10-17 10:50:34	2018-10-17	8
7911	2	2653	2018-10-17 10:50:37	2018-10-17	8
7912	3	2653	2018-10-17 10:50:39	2018-10-17	8
7913	1	2654	2018-10-17 10:49:11	2018-10-17	8
7914	2	2654	2018-10-17 10:49:14	2018-10-17	8
7915	3	2654	2018-10-17 10:49:17	2018-10-17	8
7916	1	2655	2018-10-17 10:47:38	2018-10-17	8
7917	2	2655	2018-10-17 10:47:40	2018-10-17	8
7918	3	2655	2018-10-17 10:47:41	2018-10-17	8
7919	1	2656	2018-10-17 10:43:13	2018-10-17	8
7920	2	2656	2018-10-17 10:43:15	2018-10-17	8
7921	3	2656	2018-10-17 10:43:17	2018-10-17	8
7922	1	2657	2018-10-17 10:36:47	2018-10-17	8
7923	2	2657	2018-10-17 10:36:48	2018-10-17	8
7924	3	2657	2018-10-17 11:06:46	2018-10-17	9
7925	1	2658	2018-10-17 10:34:35	2018-10-17	8
7926	2	2658	2018-10-17 10:34:36	2018-10-17	8
7927	3	2658	2018-10-17 10:34:38	2018-10-17	8
7928	1	2659	2018-10-17 10:31:54	2018-10-17	8
7929	2	2659	2018-10-17 10:31:55	2018-10-17	8
7930	3	2659	2018-10-17 10:31:58	2018-10-17	8
7931	1	2660	2018-10-17 10:30:40	2018-10-17	8
7932	2	2660	2018-10-17 10:30:41	2018-10-17	8
7933	3	2660	2018-10-17 11:28:57	2018-10-17	9
7934	1	2661	2018-10-17 10:29:04	2018-10-17	8
7935	2	2661	2018-10-17 10:29:06	2018-10-17	8
7936	3	2661	2018-10-17 10:29:08	2018-10-17	8
7937	1	2662	2018-10-17 10:27:26	2018-10-17	8
7938	2	2662	2018-10-17 10:27:29	2018-10-17	8
7939	3	2662	2018-10-17 11:29:42	2018-10-17	9
7940	1	2663	2018-10-17 10:26:43	2018-10-17	8
7941	2	2663	2018-10-17 10:26:46	2018-10-17	8
7942	3	2663	2018-10-17 10:28:33	2018-10-17	8
7943	1	2664	2018-10-17 10:25:02	2018-10-17	8
7944	2	2664	2018-10-17 10:25:04	2018-10-17	8
7945	3	2664	2018-10-17 10:25:06	2018-10-17	8
7946	1	2665	2018-10-17 10:23:14	2018-10-17	8
7947	2	2665	2018-10-17 10:23:15	2018-10-17	8
7948	3	2665	2018-10-17 10:23:17	2018-10-17	8
7949	1	2666	2018-10-17 10:21:24	2018-10-17	8
7950	2	2666	2018-10-17 10:21:26	2018-10-17	8
7951	3	2666	2018-10-17 10:21:28	2018-10-17	8
7952	1	2667	2018-10-17 10:18:38	2018-10-17	8
7953	2	2667	2018-10-17 10:18:42	2018-10-17	8
7954	3	2667	2018-10-17 10:18:44	2018-10-17	8
7955	1	2668	2018-10-17 10:19:04	2018-10-17	8
7956	2	2668	2018-10-17 10:19:06	2018-10-17	8
7957	3	2668	2018-10-17 10:19:09	2018-10-17	8
7958	1	2669	2018-10-17 10:16:31	2018-10-17	8
7959	2	2669	2018-10-17 10:16:33	2018-10-17	8
7960	3	2669	2018-10-17 10:16:34	2018-10-17	8
7961	1	2670	2018-10-17 10:13:56	2018-10-17	8
7962	2	2670	2018-10-17 10:13:58	2018-10-17	8
7963	3	2670	2018-10-17 10:14:00	2018-10-17	8
7964	1	2671	2018-10-17 10:12:25	2018-10-17	8
7965	2	2671	2018-10-17 10:12:27	2018-10-17	8
7966	3	2671	2018-10-17 10:12:29	2018-10-17	8
7967	1	2672	2018-10-17 10:10:43	2018-10-17	8
7968	2	2672	2018-10-17 10:10:45	2018-10-17	8
7969	3	2672	2018-10-17 10:10:47	2018-10-17	8
7970	1	2673	2018-10-17 10:10:13	2018-10-17	8
7971	2	2673	2018-10-17 10:10:15	2018-10-17	8
7972	3	2673	2018-10-18 09:07:25	2018-10-18	7
7973	1	2674	2018-10-17 10:08:50	2018-10-17	8
7974	2	2674	2018-10-17 10:08:53	2018-10-17	8
7975	3	2674	2018-10-18 09:06:59	2018-10-18	7
7976	1	2675	2018-10-17 10:06:50	2018-10-17	8
7977	2	2675	2018-10-17 10:06:51	2018-10-17	8
7978	3	2675	2018-10-18 09:04:11	2018-10-18	7
7979	1	2676	2018-10-17 10:02:54	2018-10-17	8
7980	2	2676	2018-10-17 10:02:56	2018-10-17	8
7981	3	2676	2018-10-17 10:02:57	2018-10-17	8
7982	1	2677	2018-10-17 10:03:32	2018-10-17	8
7983	2	2677	2018-10-17 10:03:36	2018-10-17	8
7984	3	2677	2018-10-18 10:26:01	2018-10-18	8
7985	1	2678	2018-10-17 09:58:51	2018-10-17	7
7986	2	2678	2018-10-17 09:58:52	2018-10-17	7
7987	3	2678	2018-10-17 09:58:54	2018-10-17	7
7988	1	2679	2018-10-17 09:58:02	2018-10-17	7
7989	2	2679	2018-10-17 09:58:05	2018-10-17	7
7990	3	2679	2018-10-17 09:58:07	2018-10-17	7
7991	1	2680	2018-10-17 10:00:30	2018-10-17	8
7992	2	2680	2018-10-17 10:00:33	2018-10-17	8
7993	3	2680	2018-10-19 09:13:05	2018-10-19	7
7994	1	2681	2018-10-17 09:56:03	2018-10-17	7
7995	2	2681	2018-10-17 09:56:05	2018-10-17	7
7996	3	2681	2018-10-17 09:56:07	2018-10-17	7
7997	1	2682	2018-10-17 09:56:19	2018-10-17	7
7998	2	2682	2018-10-17 09:56:23	2018-10-17	7
7999	3	2682	2018-10-18 08:55:30	2018-10-18	6
8000	1	2683	2018-10-17 09:53:07	2018-10-17	7
8001	2	2683	2018-10-17 09:53:09	2018-10-17	7
8002	3	2683	2018-10-17 09:53:10	2018-10-17	7
8003	1	2684	2018-10-17 09:48:53	2018-10-17	7
8004	2	2684	2018-10-17 09:48:54	2018-10-17	7
8005	3	2684	2018-10-17 09:48:56	2018-10-17	7
8006	1	2685	2018-10-17 09:47:51	2018-10-17	7
8007	2	2685	2018-10-17 09:47:53	2018-10-17	7
8008	3	2685	2018-10-17 09:47:55	2018-10-17	7
8009	1	2686	2018-10-17 09:50:14	2018-10-17	7
8010	2	2686	2018-10-17 09:50:16	2018-10-17	7
8011	3	2686	2018-10-17 09:50:18	2018-10-17	7
8012	1	2687	2018-10-17 09:47:00	2018-10-17	7
8013	2	2687	2018-10-17 09:47:02	2018-10-17	7
8014	3	2687	2018-10-17 10:13:39	2018-10-17	8
8015	1	2688	2018-10-17 09:45:50	2018-10-17	7
8016	2	2688	2018-10-17 09:45:52	2018-10-17	7
8017	3	2688	2018-10-17 09:48:24	2018-10-17	7
8018	1	2689	2018-10-17 09:42:32	2018-10-17	7
8019	2	2689	2018-10-17 09:42:34	2018-10-17	7
8020	3	2689	2018-10-17 09:42:36	2018-10-17	7
8021	1	2690	2018-10-17 09:38:52	2018-10-17	7
8022	2	2690	2018-10-17 09:38:54	2018-10-17	7
8023	3	2690	2018-10-17 09:38:56	2018-10-17	7
8024	1	2691	2018-10-17 09:40:28	2018-10-17	7
8025	2	2691	2018-10-17 09:40:30	2018-10-17	7
8026	3	2691	2018-10-17 10:54:13	2018-10-17	8
8027	1	2692	2018-10-17 09:36:50	2018-10-17	7
8028	2	2692	2018-10-17 09:36:53	2018-10-17	7
8029	3	2692	2018-10-17 09:36:55	2018-10-17	7
8030	1	2693	2018-10-17 09:34:54	2018-10-17	7
8031	2	2693	2018-10-17 09:34:56	2018-10-17	7
8032	3	2693	2018-10-17 09:34:58	2018-10-17	7
8033	1	2694	2018-10-17 09:33:25	2018-10-17	7
8034	2	2694	2018-10-17 09:33:28	2018-10-17	7
8035	3	2694	2018-10-18 08:56:48	2018-10-18	6
8036	1	2695	2018-10-17 09:34:26	2018-10-17	7
8037	2	2695	2018-10-17 09:34:29	2018-10-17	7
8038	3	2695	2018-10-17 10:49:02	2018-10-17	8
8039	1	2696	2018-10-17 09:30:01	2018-10-17	7
8040	2	2696	2018-10-17 09:30:04	2018-10-17	7
8041	3	2696	2018-10-17 09:30:06	2018-10-17	7
8042	1	2697	2018-10-17 09:30:34	2018-10-17	7
8043	2	2697	2018-10-17 09:30:35	2018-10-17	7
8044	3	2697	2018-10-17 10:37:53	2018-10-17	8
8045	1	2698	2018-10-17 09:26:26	2018-10-17	7
8046	2	2698	2018-10-17 09:26:29	2018-10-17	7
8047	3	2698	2018-10-17 09:33:35	2018-10-17	7
8048	1	2699	2018-10-17 09:24:28	2018-10-17	7
8049	2	2699	2018-10-17 09:24:30	2018-10-17	7
8050	3	2699	2018-10-17 11:44:40	2018-10-17	9
8051	1	2700	2018-10-17 09:21:35	2018-10-17	7
8052	2	2700	2018-10-17 09:21:37	2018-10-17	7
8053	3	2700	2018-10-17 09:21:39	2018-10-17	7
8054	1	2701	2018-10-17 09:22:03	2018-10-17	7
8055	2	2701	2018-10-17 09:22:06	2018-10-17	7
8056	3	2701	2018-10-17 09:31:24	2018-10-17	7
8057	1	2702	2018-10-17 09:14:46	2018-10-17	7
8058	2	2702	2018-10-17 09:14:47	2018-10-17	7
8059	3	2702	2018-10-17 09:14:50	2018-10-17	7
8060	1	2703	2018-10-17 09:14:05	2018-10-17	7
8061	2	2703	2018-10-17 09:14:08	2018-10-17	7
8062	3	2703	2018-10-17 09:23:24	2018-10-17	7
8063	1	2704	2018-10-17 09:11:24	2018-10-17	7
8064	2	2704	2018-10-17 09:11:26	2018-10-17	7
8065	3	2704	2018-10-17 09:11:27	2018-10-17	7
8066	1	2705	2018-10-17 09:10:06	2018-10-17	7
8067	2	2705	2018-10-17 09:10:09	2018-10-17	7
8068	3	2705	2018-10-18 09:23:20	2018-10-18	7
8069	1	2706	2018-10-17 09:09:25	2018-10-17	7
8070	2	2706	2018-10-17 09:09:28	2018-10-17	7
8071	3	2706	2018-10-18 14:05:13	2018-10-18	12
8072	1	2707	2018-10-17 09:06:06	2018-10-17	7
8073	2	2707	2018-10-17 09:06:08	2018-10-17	7
8074	3	2707	2018-10-17 09:06:09	2018-10-17	7
8075	1	2708	2018-10-17 09:07:32	2018-10-17	7
8076	2	2708	2018-10-17 09:07:34	2018-10-17	7
8077	3	2708	2018-10-17 09:07:36	2018-10-17	7
8078	1	2709	2018-10-17 09:02:18	2018-10-17	7
8079	2	2709	2018-10-17 09:02:19	2018-10-17	7
8080	3	2709	2018-10-17 09:02:21	2018-10-17	7
8081	1	2710	2018-10-17 09:03:16	2018-10-17	7
8082	2	2710	2018-10-17 09:03:17	2018-10-17	7
8083	3	2710	2018-10-17 09:03:19	2018-10-17	7
8084	1	2711	2018-10-17 08:54:53	2018-10-17	6
8085	2	2711	2018-10-17 08:54:55	2018-10-17	6
8086	3	2711	2018-10-18 09:17:40	2018-10-18	7
8087	1	2712	2018-10-17 08:48:47	2018-10-17	6
8088	2	2712	2018-10-17 08:48:49	2018-10-17	6
8089	3	2712	2018-10-17 08:48:51	2018-10-17	6
8090	1	2713	2018-10-17 08:49:45	2018-10-17	6
8091	2	2713	2018-10-17 08:49:48	2018-10-17	6
8092	3	2713	2018-10-19 10:09:55	2018-10-19	8
8093	1	2714	2018-10-17 08:46:26	2018-10-17	6
8094	2	2714	2018-10-17 08:46:28	2018-10-17	6
8095	3	2714	2018-10-17 08:46:29	2018-10-17	6
8096	1	2715	2018-10-17 09:01:08	2018-10-17	7
8097	2	2715	2018-10-17 09:01:12	2018-10-17	7
8098	3	2715	2018-10-17 09:51:29	2018-10-17	7
8099	1	2716	2018-10-17 08:47:04	2018-10-17	6
8100	2	2716	2018-10-17 08:47:07	2018-10-17	6
8101	3	2716	2018-10-17 09:01:14	2018-10-17	7
8102	1	2717	2018-10-17 08:43:45	2018-10-17	6
8103	2	2717	2018-10-17 08:43:47	2018-10-17	6
8104	3	2717	2018-10-17 08:43:49	2018-10-17	6
8105	1	2718	2018-10-17 08:34:02	2018-10-17	6
8106	2	2718	2018-10-17 08:34:05	2018-10-17	6
8107	3	2718	2018-10-17 08:59:06	2018-10-17	6
8108	1	2719	2018-10-17 07:57:44	2018-10-17	5
8109	2	2719	2018-10-17 07:57:47	2018-10-17	5
8110	3	2719	2018-10-17 10:32:32	2018-10-17	8
8111	1	2720	2018-10-17 07:54:55	2018-10-17	5
8112	2	2720	2018-10-17 07:54:59	2018-10-17	5
8113	3	2720	2018-10-17 10:31:31	2018-10-17	8
8114	1	2721	2018-10-17 07:52:53	2018-10-17	5
8115	2	2721	2018-10-17 07:52:55	2018-10-17	5
8116	3	2721	2018-10-17 10:29:27	2018-10-17	8
8117	1	2722	2018-10-17 05:44:18	2018-10-17	3
8118	2	2722	2018-10-17 05:44:20	2018-10-17	3
8119	3	2722	2018-10-17 09:02:57	2018-10-17	7
8120	1	2723	2018-10-16 23:43:55	2018-10-16	21
8121	2	2723	2018-10-16 23:43:59	2018-10-16	21
8122	3	2723	2018-10-17 10:35:23	2018-10-17	8
8123	1	2724	2018-10-16 16:58:05	2018-10-16	14
8124	2	2724	2018-10-16 16:58:08	2018-10-16	14
8125	3	2724	2018-10-17 07:45:17	2018-10-17	5
8126	1	2725	2018-10-16 16:50:13	2018-10-16	14
8127	2	2725	2018-10-16 16:50:16	2018-10-16	14
8128	3	2725	2018-10-17 08:31:59	2018-10-17	6
8129	1	2726	2018-10-16 16:45:20	2018-10-16	14
8130	2	2726	2018-10-16 16:45:22	2018-10-16	14
8131	3	2726	2018-10-16 16:45:24	2018-10-16	14
8132	1	2727	2018-10-16 16:43:36	2018-10-16	14
8133	2	2727	2018-10-16 16:43:39	2018-10-16	14
8134	3	2727	2018-10-16 16:43:41	2018-10-16	14
8135	1	2728	2018-10-16 16:41:11	2018-10-16	14
8136	2	2728	2018-10-16 16:41:13	2018-10-16	14
8137	3	2728	2018-10-16 16:41:15	2018-10-16	14
8138	1	2729	2018-10-16 16:40:17	2018-10-16	14
8139	2	2729	2018-10-16 16:40:20	2018-10-16	14
8140	3	2729	2018-10-16 16:40:23	2018-10-16	14
8141	1	2730	2018-10-16 16:39:49	2018-10-16	14
8142	2	2730	2018-10-16 16:39:51	2018-10-16	14
8143	3	2730	2018-10-16 16:39:53	2018-10-16	14
8144	1	2731	2018-10-16 16:29:08	2018-10-16	14
8145	2	2731	2018-10-16 16:29:10	2018-10-16	14
8146	3	2731	2018-10-16 16:29:12	2018-10-16	14
8147	1	2732	2018-10-16 16:33:52	2018-10-16	14
8148	2	2732	2018-10-16 16:33:56	2018-10-16	14
8149	3	2732	2018-10-17 08:03:09	2018-10-17	6
8150	1	2733	2018-10-16 16:28:04	2018-10-16	14
8151	2	2733	2018-10-16 16:28:06	2018-10-16	14
8152	3	2733	2018-10-16 16:28:08	2018-10-16	14
8153	1	2734	2018-10-16 16:26:38	2018-10-16	14
8154	2	2734	2018-10-16 16:26:40	2018-10-16	14
8155	3	2734	2018-10-17 10:25:41	2018-10-17	8
8156	1	2735	2018-10-16 16:23:12	2018-10-16	14
8157	2	2735	2018-10-16 16:23:15	2018-10-16	14
8158	3	2735	2018-10-16 16:23:17	2018-10-16	14
8159	1	2736	2018-10-16 16:18:19	2018-10-16	14
8160	2	2736	2018-10-16 16:18:23	2018-10-16	14
8161	3	2736	2018-10-16 16:18:30	2018-10-16	14
8162	1	2737	2018-10-16 16:19:23	2018-10-16	14
8163	2	2737	2018-10-16 16:19:25	2018-10-16	14
8164	3	2737	2018-10-16 16:25:29	2018-10-16	14
8165	1	2738	2018-10-16 16:13:12	2018-10-16	14
8166	2	2738	2018-10-16 16:13:15	2018-10-16	14
8167	3	2738	2018-10-16 16:13:50	2018-10-16	14
8168	1	2739	2018-10-16 16:12:54	2018-10-16	14
8169	2	2739	2018-10-16 16:12:58	2018-10-16	14
8170	3	2739	2018-10-17 11:31:49	2018-10-17	9
8171	1	2740	2018-10-16 16:03:48	2018-10-16	14
8172	2	2740	2018-10-16 16:03:51	2018-10-16	14
8173	3	2740	2018-10-16 16:16:10	2018-10-16	14
8174	1	2741	2018-10-16 16:01:09	2018-10-16	14
8175	2	2741	2018-10-16 16:01:12	2018-10-16	14
8176	3	2741	2018-10-17 10:23:20	2018-10-17	8
8177	1	2742	2018-10-16 15:57:10	2018-10-16	13
8178	2	2742	2018-10-16 15:57:12	2018-10-16	13
8179	3	2742	2018-10-16 15:57:13	2018-10-16	13
8180	1	2743	2018-10-16 15:50:27	2018-10-16	13
8181	2	2743	2018-10-16 15:50:29	2018-10-16	13
8182	3	2743	2018-10-16 15:50:30	2018-10-16	13
8183	1	2744	2018-10-16 15:47:32	2018-10-16	13
8184	2	2744	2018-10-16 15:47:35	2018-10-16	13
8185	3	2744	2018-10-16 15:57:52	2018-10-16	13
8186	1	2745	2018-10-16 15:42:43	2018-10-16	13
8187	2	2745	2018-10-16 15:42:44	2018-10-16	13
8188	3	2745	2018-10-17 08:07:08	2018-10-17	6
8189	1	2746	2018-10-16 15:35:57	2018-10-16	13
8190	2	2746	2018-10-16 15:36:00	2018-10-16	13
8191	3	2746	2018-10-16 15:36:04	2018-10-16	13
8192	1	2747	2018-10-16 15:33:20	2018-10-16	13
8193	2	2747	2018-10-16 15:33:22	2018-10-16	13
8194	3	2747	2018-10-16 16:14:11	2018-10-16	14
8195	1	2748	2018-10-16 15:27:37	2018-10-16	13
8196	2	2748	2018-10-16 15:27:39	2018-10-16	13
8197	3	2748	2018-10-16 15:27:40	2018-10-16	13
8198	1	2749	2018-10-16 15:31:07	2018-10-16	13
8199	2	2749	2018-10-16 15:31:09	2018-10-16	13
8200	3	2749	2018-10-16 15:39:08	2018-10-16	13
8201	1	2750	2018-10-16 15:24:52	2018-10-16	13
8202	2	2750	2018-10-16 15:24:54	2018-10-16	13
8203	3	2750	2018-10-18 15:16:09	2018-10-18	13
8204	1	2751	2018-10-16 15:23:21	2018-10-16	13
8205	2	2751	2018-10-16 15:23:23	2018-10-16	13
8206	3	2751	2018-10-22 08:41:53	2018-10-22	6
8207	1	2752	2018-10-16 15:14:10	2018-10-16	13
8208	2	2752	2018-10-16 15:14:11	2018-10-16	13
8209	3	2752	2018-10-16 15:14:13	2018-10-16	13
8210	1	2753	2018-10-16 15:10:04	2018-10-16	13
8211	2	2753	2018-10-16 15:10:05	2018-10-16	13
8212	3	2753	2018-10-16 15:10:07	2018-10-16	13
8213	1	2754	2018-10-16 15:09:11	2018-10-16	13
8214	2	2754	2018-10-16 15:09:13	2018-10-16	13
8215	3	2754	2018-10-17 09:22:48	2018-10-17	7
8216	1	2755	2018-10-16 15:03:10	2018-10-16	13
8217	2	2755	2018-10-16 15:03:11	2018-10-16	13
8218	3	2755	2018-10-16 15:03:13	2018-10-16	13
8219	1	2756	2018-10-16 14:56:09	2018-10-16	12
8220	2	2756	2018-10-16 14:56:10	2018-10-16	12
8221	3	2756	2018-10-16 14:56:12	2018-10-16	12
8222	1	2757	2018-10-16 14:53:15	2018-10-16	12
8223	2	2757	2018-10-16 14:53:17	2018-10-16	12
8224	3	2757	2018-10-17 09:28:36	2018-10-17	7
8225	1	2758	2018-10-16 14:48:37	2018-10-16	12
8226	2	2758	2018-10-16 14:48:39	2018-10-16	12
8227	3	2758	2018-10-16 14:48:41	2018-10-16	12
8228	1	2759	2018-10-16 14:57:07	2018-10-16	12
8229	2	2759	2018-10-16 14:57:10	2018-10-16	12
8230	3	2759	2018-10-16 15:22:23	2018-10-16	13
8231	1	2760	2018-10-16 14:34:49	2018-10-16	12
8232	2	2760	2018-10-16 14:34:53	2018-10-16	12
8233	3	2760	2018-10-17 09:08:33	2018-10-17	7
8234	1	2761	2018-10-16 14:34:43	2018-10-16	12
8235	2	2761	2018-10-16 14:34:46	2018-10-16	12
8236	3	2761	2018-10-17 09:24:17	2018-10-17	7
8237	1	2762	2018-10-16 14:36:06	2018-10-16	12
8238	2	2762	2018-10-16 14:36:08	2018-10-16	12
8239	3	2762	2018-10-23 10:30:06	2018-10-23	8
8240	1	2763	2018-10-16 14:29:03	2018-10-16	12
8241	2	2763	2018-10-16 14:29:05	2018-10-16	12
8242	3	2763	2018-10-17 07:53:14	2018-10-17	5
8243	1	2764	2018-10-16 14:25:18	2018-10-16	12
8244	2	2764	2018-10-16 14:25:20	2018-10-16	12
8245	3	2764	2018-10-16 14:25:22	2018-10-16	12
8246	1	2765	2018-10-16 14:24:29	2018-10-16	12
8247	2	2765	2018-10-16 14:24:31	2018-10-16	12
8248	3	2765	2018-10-17 08:23:50	2018-10-17	6
8249	1	2766	2018-10-16 14:21:55	2018-10-16	12
8250	2	2766	2018-10-16 14:21:57	2018-10-16	12
8251	3	2766	2018-10-16 14:21:59	2018-10-16	12
8252	1	2767	2018-10-16 14:21:22	2018-10-16	12
8253	2	2767	2018-10-16 14:21:25	2018-10-16	12
8254	3	2767	2018-10-16 14:21:28	2018-10-16	12
8255	1	2768	2018-10-16 14:20:14	2018-10-16	12
8256	2	2768	2018-10-16 14:20:16	2018-10-16	12
8257	3	2768	2018-10-16 14:39:08	2018-10-16	12
8258	1	2769	2018-10-16 14:20:43	2018-10-16	12
8259	2	2769	2018-10-16 14:20:47	2018-10-16	12
8260	3	2769	2018-10-16 14:44:49	2018-10-16	12
8261	1	2770	2018-10-16 14:16:35	2018-10-16	12
8262	2	2770	2018-10-16 14:16:37	2018-10-16	12
8263	3	2770	2018-10-16 14:16:39	2018-10-16	12
8264	1	2771	2018-10-16 14:12:59	2018-10-16	12
8265	2	2771	2018-10-16 14:13:00	2018-10-16	12
8266	3	2771	2018-10-16 14:13:02	2018-10-16	12
8267	1	2772	2018-10-16 14:11:56	2018-10-16	12
8268	2	2772	2018-10-16 14:11:58	2018-10-16	12
8269	3	2772	2018-10-16 14:12:00	2018-10-16	12
8270	1	2773	2018-10-16 14:10:39	2018-10-16	12
8271	2	2773	2018-10-16 14:10:41	2018-10-16	12
8272	3	2773	2018-10-16 14:10:43	2018-10-16	12
8273	1	2774	2018-10-16 14:10:04	2018-10-16	12
8274	2	2774	2018-10-16 14:10:06	2018-10-16	12
8275	3	2774	2018-10-16 14:10:08	2018-10-16	12
8276	1	2775	2018-10-16 14:10:13	2018-10-16	12
8277	2	2775	2018-10-16 14:10:17	2018-10-16	12
8278	3	2775	2018-10-16 14:10:20	2018-10-16	12
8279	1	2776	2018-10-16 14:02:53	2018-10-16	12
8280	2	2776	2018-10-16 14:02:55	2018-10-16	12
8281	3	2776	2018-10-16 14:02:57	2018-10-16	12
8282	1	2777	2018-10-16 12:59:36	2018-10-16	10
8283	2	2777	2018-10-16 12:59:39	2018-10-16	10
8284	3	2777	2018-10-17 10:21:08	2018-10-17	8
8285	1	2778	2018-10-16 12:29:25	2018-10-16	10
8286	2	2778	2018-10-16 12:29:28	2018-10-16	10
8287	3	2778	2018-10-16 12:29:31	2018-10-16	10
8288	1	2779	2018-10-16 12:11:36	2018-10-16	10
8289	2	2779	2018-10-16 12:11:38	2018-10-16	10
8290	3	2779	2018-10-16 15:15:09	2018-10-16	13
8291	1	2780	2018-10-16 12:07:48	2018-10-16	10
8292	2	2780	2018-10-16 12:07:50	2018-10-16	10
8293	3	2780	2018-10-18 11:30:05	2018-10-18	9
8294	1	2781	2018-10-16 12:03:27	2018-10-16	10
8295	2	2781	2018-10-16 12:03:29	2018-10-16	10
8296	3	2781	2018-10-17 09:27:16	2018-10-17	7
8297	1	2782	2018-10-16 12:00:11	2018-10-16	10
8298	2	2782	2018-10-16 12:00:13	2018-10-16	10
8299	3	2782	2018-10-16 12:00:15	2018-10-16	10
8300	1	2783	2018-10-16 12:06:48	2018-10-16	10
8301	2	2783	2018-10-16 12:06:51	2018-10-16	10
8302	3	2783	2018-10-16 13:24:01	2018-10-16	11
8303	1	2784	2018-10-16 11:53:21	2018-10-16	9
8304	2	2784	2018-10-16 11:53:25	2018-10-16	9
8305	3	2784	2018-10-16 14:34:03	2018-10-16	12
8306	1	2785	2018-10-16 11:58:45	2018-10-16	9
8307	2	2785	2018-10-16 11:58:48	2018-10-16	9
8308	3	2785	2018-10-16 13:02:56	2018-10-16	11
8309	1	2786	2018-10-16 11:49:41	2018-10-16	9
8310	2	2786	2018-10-16 11:49:43	2018-10-16	9
8311	3	2786	2018-10-16 11:49:45	2018-10-16	9
8312	1	2787	2018-10-16 11:47:21	2018-10-16	9
8313	2	2787	2018-10-16 11:47:23	2018-10-16	9
8314	3	2787	2018-10-16 11:47:25	2018-10-16	9
8315	1	2788	2018-10-16 11:45:23	2018-10-16	9
8316	2	2788	2018-10-16 11:45:25	2018-10-16	9
8317	3	2788	2018-10-16 11:45:26	2018-10-16	9
8318	1	2789	2018-10-16 11:39:03	2018-10-16	9
8319	2	2789	2018-10-16 11:39:05	2018-10-16	9
8320	3	2789	2018-10-16 11:39:06	2018-10-16	9
8321	1	2790	2018-10-16 11:38:10	2018-10-16	9
8322	2	2790	2018-10-16 11:38:13	2018-10-16	9
8323	3	2790	2018-10-16 11:38:16	2018-10-16	9
8324	1	2791	2018-10-16 11:38:40	2018-10-16	9
8325	2	2791	2018-10-16 11:38:43	2018-10-16	9
8326	3	2791	2018-10-16 11:47:12	2018-10-16	9
8327	2	2791	2018-10-16 11:50:30	2018-10-16	9
8328	1	2791	2018-10-16 11:50:30	2018-10-16	9
8329	2	2791	2018-10-16 11:50:32	2018-10-16	9
8330	3	2791	2018-10-16 13:43:55	2018-10-16	11
8331	1	2792	2018-10-16 11:36:48	2018-10-16	9
8332	2	2792	2018-10-16 11:36:50	2018-10-16	9
8333	3	2792	2018-10-16 11:53:23	2018-10-16	9
8334	1	2793	2018-10-16 11:36:29	2018-10-16	9
8335	2	2793	2018-10-16 11:36:32	2018-10-16	9
8336	3	2793	2018-10-16 11:56:00	2018-10-16	9
8337	1	2794	2018-10-16 11:32:43	2018-10-16	9
8338	2	2794	2018-10-16 11:32:45	2018-10-16	9
8339	3	2794	2018-10-16 11:32:46	2018-10-16	9
8340	1	2795	2018-10-16 11:32:51	2018-10-16	9
8341	2	2795	2018-10-16 11:32:53	2018-10-16	9
8342	3	2795	2018-10-16 11:52:26	2018-10-16	9
8343	1	2796	2018-10-16 11:30:01	2018-10-16	9
8344	2	2796	2018-10-16 11:30:05	2018-10-16	9
8345	3	2796	2018-10-16 11:30:08	2018-10-16	9
8346	1	2797	2018-10-16 11:23:40	2018-10-16	9
8347	2	2797	2018-10-16 11:23:41	2018-10-16	9
8348	3	2797	2018-10-16 13:18:10	2018-10-16	11
8349	1	2798	2018-10-16 11:22:21	2018-10-16	9
8350	2	2798	2018-10-16 11:22:23	2018-10-16	9
8351	3	2798	2018-10-16 11:22:25	2018-10-16	9
8352	1	2799	2018-10-16 11:21:41	2018-10-16	9
8353	2	2799	2018-10-16 11:21:43	2018-10-16	9
8354	3	2799	2018-10-16 11:21:45	2018-10-16	9
8355	1	2800	2018-10-16 11:24:17	2018-10-16	9
8356	2	2800	2018-10-16 11:24:18	2018-10-16	9
8357	3	2800	2018-10-16 11:24:20	2018-10-16	9
8358	1	2801	2018-10-16 11:17:59	2018-10-16	9
8359	2	2801	2018-10-16 11:18:02	2018-10-16	9
8360	3	2801	2018-10-16 11:18:05	2018-10-16	9
8361	1	2802	2018-10-16 11:15:46	2018-10-16	9
8362	2	2802	2018-10-16 11:15:49	2018-10-16	9
8363	3	2802	2018-10-16 11:44:54	2018-10-16	9
8364	1	2803	2018-10-16 11:11:57	2018-10-16	9
8365	2	2803	2018-10-16 11:11:59	2018-10-16	9
8366	3	2803	2018-10-16 11:12:01	2018-10-16	9
8367	1	2804	2018-10-16 11:11:16	2018-10-16	9
8368	2	2804	2018-10-16 11:11:19	2018-10-16	9
8369	3	2804	2018-10-16 11:11:21	2018-10-16	9
8370	1	2805	2018-10-16 11:02:39	2018-10-16	9
8371	2	2805	2018-10-16 11:02:43	2018-10-16	9
8372	3	2805	2018-10-16 13:15:43	2018-10-16	11
8373	1	2806	2018-10-16 11:02:20	2018-10-16	9
8374	2	2806	2018-10-16 11:02:22	2018-10-16	9
8375	3	2806	2018-10-18 08:31:49	2018-10-18	6
8376	1	2807	2018-10-16 10:55:29	2018-10-16	8
8377	2	2807	2018-10-16 10:55:31	2018-10-16	8
8378	3	2807	2018-10-16 11:49:12	2018-10-16	9
8379	1	2808	2018-10-16 11:33:40	2018-10-16	9
8380	2	2808	2018-10-16 11:33:43	2018-10-16	9
8381	3	2808	2018-10-16 11:50:11	2018-10-16	9
8382	1	2809	2018-10-16 10:49:52	2018-10-16	8
8383	2	2809	2018-10-16 10:49:55	2018-10-16	8
8384	3	2809	2018-10-16 10:49:58	2018-10-16	8
8385	1	2810	2018-10-16 10:49:03	2018-10-16	8
8386	2	2810	2018-10-16 10:49:04	2018-10-16	8
8387	3	2810	2018-10-16 10:50:08	2018-10-16	8
8388	1	2811	2018-10-16 10:40:52	2018-10-16	8
8389	2	2811	2018-10-16 10:40:56	2018-10-16	8
8390	3	2811	2018-10-16 13:19:16	2018-10-16	11
8391	1	2812	2018-10-16 10:34:59	2018-10-16	8
8392	2	2812	2018-10-16 10:35:01	2018-10-16	8
8393	3	2812	2018-10-16 10:35:03	2018-10-16	8
8394	1	2813	2018-10-16 10:36:26	2018-10-16	8
8395	2	2813	2018-10-16 10:36:29	2018-10-16	8
8396	3	2813	2018-10-16 12:07:08	2018-10-16	10
8397	1	2814	2018-10-16 10:28:58	2018-10-16	8
8398	2	2814	2018-10-16 10:29:00	2018-10-16	8
8399	3	2814	2018-10-16 10:29:06	2018-10-16	8
8400	1	2815	2018-10-16 10:29:41	2018-10-16	8
8401	2	2815	2018-10-16 10:29:44	2018-10-16	8
8402	3	2815	2018-10-16 11:03:11	2018-10-16	9
8403	1	2816	2018-10-16 10:28:05	2018-10-16	8
8404	2	2816	2018-10-16 10:28:09	2018-10-16	8
8405	3	2816	2018-10-16 10:35:29	2018-10-16	8
8406	1	2817	2018-10-16 10:24:00	2018-10-16	8
8407	2	2817	2018-10-16 10:24:02	2018-10-16	8
8408	3	2817	2018-10-16 10:24:04	2018-10-16	8
8409	1	2818	2018-10-16 10:23:40	2018-10-16	8
8410	2	2818	2018-10-16 10:23:42	2018-10-16	8
8411	3	2818	2018-10-16 10:23:44	2018-10-16	8
8412	1	2819	2018-10-16 10:26:17	2018-10-16	8
8413	2	2819	2018-10-16 10:26:19	2018-10-16	8
8414	3	2819	2018-10-16 10:36:07	2018-10-16	8
8415	1	2820	2018-10-16 10:25:24	2018-10-16	8
8416	2	2820	2018-10-16 10:25:26	2018-10-16	8
8417	3	2820	2018-10-16 11:07:21	2018-10-16	9
8418	1	2821	2018-10-16 10:20:07	2018-10-16	8
8419	2	2821	2018-10-16 10:20:09	2018-10-16	8
8420	3	2821	2018-10-16 10:34:01	2018-10-16	8
8421	1	2822	2018-10-16 10:16:11	2018-10-16	8
8422	2	2822	2018-10-16 10:16:13	2018-10-16	8
8423	3	2822	2018-10-16 10:16:15	2018-10-16	8
8424	1	2823	2018-10-16 10:16:42	2018-10-16	8
8425	2	2823	2018-10-16 10:16:45	2018-10-16	8
8426	3	2823	2018-10-16 10:47:44	2018-10-16	8
8427	1	2824	2018-10-16 10:10:55	2018-10-16	8
8428	2	2824	2018-10-16 10:10:58	2018-10-16	8
8429	3	2824	2018-10-16 10:11:01	2018-10-16	8
8430	1	2825	2018-10-16 10:06:13	2018-10-16	8
8431	2	2825	2018-10-16 10:06:15	2018-10-16	8
8432	3	2825	2018-10-16 10:06:17	2018-10-16	8
8433	1	2826	2018-10-16 10:06:41	2018-10-16	8
8434	2	2826	2018-10-16 10:06:44	2018-10-16	8
8435	3	2826	2018-10-18 10:27:56	2018-10-18	8
8436	1	2827	2018-10-16 10:05:47	2018-10-16	8
8437	2	2827	2018-10-16 10:05:49	2018-10-16	8
8438	3	2827	2018-10-17 10:36:18	2018-10-17	8
8439	1	2828	2018-10-16 10:02:42	2018-10-16	8
8440	2	2828	2018-10-16 10:02:44	2018-10-16	8
8441	3	2828	2018-10-17 09:23:23	2018-10-17	7
8442	1	2829	2018-10-16 09:59:59	2018-10-16	7
8443	2	2829	2018-10-16 10:00:00	2018-10-16	8
8444	3	2829	2018-10-16 10:00:04	2018-10-16	8
8445	1	2830	2018-10-16 10:01:12	2018-10-16	8
8446	2	2830	2018-10-16 10:01:16	2018-10-16	8
8447	3	2830	2018-10-16 10:22:26	2018-10-16	8
8448	1	2831	2018-10-16 09:57:39	2018-10-16	7
8449	2	2831	2018-10-16 09:57:40	2018-10-16	7
8450	3	2831	2018-10-16 11:06:58	2018-10-16	9
8451	1	2832	2018-10-16 09:56:29	2018-10-16	7
8452	2	2832	2018-10-16 09:56:30	2018-10-16	7
8453	3	2832	2018-10-16 10:02:09	2018-10-16	8
8454	1	2833	2018-10-16 09:58:06	2018-10-16	7
8455	2	2833	2018-10-16 09:58:09	2018-10-16	7
8456	3	2833	2018-10-19 08:46:55	2018-10-19	6
8457	1	2834	2018-10-16 09:51:02	2018-10-16	7
8458	2	2834	2018-10-16 09:51:04	2018-10-16	7
8459	3	2834	2018-10-16 10:20:38	2018-10-16	8
8460	1	2835	2018-10-16 09:49:33	2018-10-16	7
8461	2	2835	2018-10-16 09:49:37	2018-10-16	7
8462	3	2835	2018-10-16 10:12:19	2018-10-16	8
8463	1	2836	2018-10-16 09:48:58	2018-10-16	7
8464	2	2836	2018-10-16 09:49:01	2018-10-16	7
8465	3	2836	2018-10-16 11:19:22	2018-10-16	9
8466	1	2837	2018-10-16 09:47:09	2018-10-16	7
8467	2	2837	2018-10-16 09:47:11	2018-10-16	7
8468	3	2837	2018-10-16 09:47:13	2018-10-16	7
8469	1	2838	2018-10-16 09:46:26	2018-10-16	7
8470	2	2838	2018-10-16 09:46:29	2018-10-16	7
8471	3	2838	2018-10-16 09:46:32	2018-10-16	7
8472	1	2839	2018-10-16 09:43:39	2018-10-16	7
8473	2	2839	2018-10-16 09:43:40	2018-10-16	7
8474	3	2839	2018-10-16 09:43:42	2018-10-16	7
8475	1	2840	2018-10-16 09:40:27	2018-10-16	7
8476	2	2840	2018-10-16 09:40:29	2018-10-16	7
8477	3	2840	2018-10-16 09:40:31	2018-10-16	7
8478	1	2841	2018-10-16 09:40:19	2018-10-16	7
8479	2	2841	2018-10-16 09:40:21	2018-10-16	7
8480	3	2841	2018-10-16 10:26:00	2018-10-16	8
8481	1	2842	2018-10-16 09:45:31	2018-10-16	7
8482	2	2842	2018-10-16 09:45:32	2018-10-16	7
8483	3	2842	2018-10-16 11:27:25	2018-10-16	9
8484	1	2843	2018-10-16 09:33:51	2018-10-16	7
8485	2	2843	2018-10-16 09:33:53	2018-10-16	7
8486	3	2843	2018-10-16 09:33:55	2018-10-16	7
8487	1	2844	2018-10-16 09:35:04	2018-10-16	7
8488	2	2844	2018-10-16 09:35:07	2018-10-16	7
8489	3	2844	2018-10-16 09:38:18	2018-10-16	7
8490	1	2845	2018-10-16 09:32:29	2018-10-16	7
8491	2	2845	2018-10-16 09:32:30	2018-10-16	7
8492	3	2845	2018-10-16 09:32:32	2018-10-16	7
8493	1	2846	2018-10-16 09:30:47	2018-10-16	7
8494	2	2846	2018-10-16 09:30:49	2018-10-16	7
8495	3	2846	2018-10-16 09:30:51	2018-10-16	7
8496	1	2847	2018-10-16 09:29:34	2018-10-16	7
8497	2	2847	2018-10-16 09:29:36	2018-10-16	7
8498	3	2847	2018-10-16 09:29:37	2018-10-16	7
8499	1	2848	2018-10-16 09:27:45	2018-10-16	7
8500	2	2848	2018-10-16 09:27:48	2018-10-16	7
8501	3	2848	2018-10-16 09:27:51	2018-10-16	7
8502	1	2849	2018-10-16 09:27:25	2018-10-16	7
8503	2	2849	2018-10-16 09:27:28	2018-10-16	7
8504	3	2849	2018-10-16 09:33:44	2018-10-16	7
8505	1	2850	2018-10-16 09:24:17	2018-10-16	7
8506	2	2850	2018-10-16 09:24:19	2018-10-16	7
8507	3	2850	2018-10-16 09:24:20	2018-10-16	7
8508	1	2851	2018-10-16 09:23:25	2018-10-16	7
8509	2	2851	2018-10-16 09:23:27	2018-10-16	7
8510	3	2851	2018-10-16 09:23:29	2018-10-16	7
8511	1	2852	2018-10-16 09:23:49	2018-10-16	7
8512	2	2852	2018-10-16 09:23:50	2018-10-16	7
8513	3	2852	2018-10-16 09:23:52	2018-10-16	7
8514	1	2853	2018-10-16 09:19:55	2018-10-16	7
8515	2	2853	2018-10-16 09:19:57	2018-10-16	7
8516	3	2853	2018-10-16 10:18:31	2018-10-16	8
8517	1	2854	2018-10-16 09:17:12	2018-10-16	7
8518	2	2854	2018-10-16 09:17:14	2018-10-16	7
8519	3	2854	2018-10-16 09:17:16	2018-10-16	7
8520	1	2855	2018-10-16 09:15:26	2018-10-16	7
8521	2	2855	2018-10-16 09:15:28	2018-10-16	7
8522	3	2855	2018-10-16 09:15:30	2018-10-16	7
8523	1	2856	2018-10-16 09:10:23	2018-10-16	7
8524	2	2856	2018-10-16 09:10:25	2018-10-16	7
8525	3	2856	2018-10-16 09:10:27	2018-10-16	7
8526	1	2857	2018-10-16 09:11:24	2018-10-16	7
8527	2	2857	2018-10-16 09:11:25	2018-10-16	7
8528	3	2857	2018-10-16 09:11:27	2018-10-16	7
8529	1	2858	2018-10-16 09:08:36	2018-10-16	7
8530	2	2858	2018-10-16 09:08:40	2018-10-16	7
8531	3	2858	2018-10-16 09:08:42	2018-10-16	7
8532	1	2859	2018-10-16 09:07:55	2018-10-16	7
8533	2	2859	2018-10-16 09:07:57	2018-10-16	7
8534	3	2859	2018-10-16 09:07:59	2018-10-16	7
8535	1	2860	2018-10-16 09:09:10	2018-10-16	7
8536	2	2860	2018-10-16 09:09:13	2018-10-16	7
8537	3	2860	2018-10-16 09:20:08	2018-10-16	7
8538	1	2861	2018-10-16 09:06:29	2018-10-16	7
8539	2	2861	2018-10-16 09:06:32	2018-10-16	7
8540	3	2861	2018-10-16 09:31:26	2018-10-16	7
8541	1	2862	2018-10-16 09:03:38	2018-10-16	7
8542	2	2862	2018-10-16 09:03:41	2018-10-16	7
8543	3	2862	2018-10-16 10:27:06	2018-10-16	8
8544	1	2863	2018-10-16 09:00:23	2018-10-16	7
8545	2	2863	2018-10-16 09:00:26	2018-10-16	7
8546	3	2863	2018-10-16 09:00:28	2018-10-16	7
8547	1	2864	2018-10-16 08:59:58	2018-10-16	6
8548	2	2864	2018-10-16 09:00:03	2018-10-16	7
8549	3	2864	2018-10-16 09:00:06	2018-10-16	7
8550	1	2865	2018-10-16 08:56:20	2018-10-16	6
8551	2	2865	2018-10-16 08:56:22	2018-10-16	6
8552	3	2865	2018-10-16 08:56:24	2018-10-16	6
8553	1	2866	2018-10-16 08:58:05	2018-10-16	6
8554	2	2866	2018-10-16 08:58:09	2018-10-16	6
8555	3	2866	2018-10-16 11:16:54	2018-10-16	9
8556	1	2867	2018-10-16 08:53:23	2018-10-16	6
8557	2	2867	2018-10-16 08:53:25	2018-10-16	6
8558	3	2867	2018-10-16 08:55:34	2018-10-16	6
8559	1	2868	2018-10-16 08:51:26	2018-10-16	6
8560	2	2868	2018-10-16 08:51:28	2018-10-16	6
8561	3	2868	2018-10-16 08:51:30	2018-10-16	6
8562	1	2869	2018-10-16 08:49:41	2018-10-16	6
8563	2	2869	2018-10-16 08:49:43	2018-10-16	6
8564	3	2869	2018-10-16 08:49:45	2018-10-16	6
8565	1	2870	2018-10-16 08:49:58	2018-10-16	6
8566	2	2870	2018-10-16 08:50:00	2018-10-16	6
8567	3	2870	2018-10-16 11:13:25	2018-10-16	9
8568	1	2871	2018-10-16 08:47:06	2018-10-16	6
8569	2	2871	2018-10-16 08:47:08	2018-10-16	6
8570	3	2871	2018-10-16 11:12:03	2018-10-16	9
8571	1	2872	2018-10-16 08:43:31	2018-10-16	6
8572	2	2872	2018-10-16 08:43:34	2018-10-16	6
8573	3	2872	2018-10-16 09:05:13	2018-10-16	7
8574	1	2873	2018-10-16 08:38:15	2018-10-16	6
8575	2	2873	2018-10-16 08:38:18	2018-10-16	6
8576	3	2873	2018-10-16 10:23:59	2018-10-16	8
8577	1	2874	2018-10-16 08:32:44	2018-10-16	6
8578	2	2874	2018-10-16 08:32:45	2018-10-16	6
8579	3	2874	2018-10-16 08:32:48	2018-10-16	6
8580	1	2875	2018-10-16 07:07:45	2018-10-16	5
8581	2	2875	2018-10-16 07:07:47	2018-10-16	5
8582	3	2875	2018-10-16 10:56:19	2018-10-16	8
8583	1	2876	2018-10-15 16:57:30	2018-10-15	14
8584	2	2876	2018-10-15 16:57:32	2018-10-15	14
8585	3	2876	2018-10-15 16:57:33	2018-10-15	14
8586	1	2877	2018-10-15 16:56:48	2018-10-15	14
8587	2	2877	2018-10-15 16:56:49	2018-10-15	14
8588	3	2877	2018-10-16 08:16:02	2018-10-16	6
8589	1	2878	2018-10-15 16:56:13	2018-10-15	14
8590	2	2878	2018-10-15 16:56:14	2018-10-15	14
8591	3	2878	2018-10-15 16:56:16	2018-10-15	14
8592	1	2879	2018-10-15 16:45:39	2018-10-15	14
8593	2	2879	2018-10-15 16:45:42	2018-10-15	14
8594	3	2879	2018-10-15 16:45:45	2018-10-15	14
8595	1	2880	2018-10-15 16:40:28	2018-10-15	14
8596	2	2880	2018-10-15 16:40:30	2018-10-15	14
8597	3	2880	2018-10-17 17:38:33	2018-10-17	15
8598	1	2881	2018-10-15 16:39:12	2018-10-15	14
8599	2	2881	2018-10-15 16:39:14	2018-10-15	14
8600	3	2881	2018-10-15 16:39:16	2018-10-15	14
8601	1	2882	2018-10-15 16:36:37	2018-10-15	14
8602	2	2882	2018-10-15 16:36:38	2018-10-15	14
8603	3	2882	2018-10-15 16:36:40	2018-10-15	14
8604	1	2883	2018-10-15 16:36:16	2018-10-15	14
8605	2	2883	2018-10-15 16:36:19	2018-10-15	14
8606	3	2883	2018-10-15 16:39:49	2018-10-15	14
8607	1	2884	2018-10-15 16:29:50	2018-10-15	14
8608	2	2884	2018-10-15 16:29:54	2018-10-15	14
8609	3	2884	2018-10-15 16:29:56	2018-10-15	14
8610	1	2885	2018-10-15 16:25:53	2018-10-15	14
8611	2	2885	2018-10-15 16:25:54	2018-10-15	14
8612	3	2885	2018-10-16 11:03:53	2018-10-16	9
8613	1	2886	2018-10-15 16:22:58	2018-10-15	14
8614	2	2886	2018-10-15 16:22:59	2018-10-15	14
8615	3	2886	2018-10-16 07:51:26	2018-10-16	5
8616	1	2887	2018-10-15 16:21:36	2018-10-15	14
8617	2	2887	2018-10-15 16:21:38	2018-10-15	14
8618	3	2887	2018-10-16 08:52:32	2018-10-16	6
8619	1	2888	2018-10-15 16:15:20	2018-10-15	14
8620	2	2888	2018-10-15 16:15:22	2018-10-15	14
8621	3	2888	2018-10-15 16:15:24	2018-10-15	14
8622	1	2889	2018-10-15 16:03:59	2018-10-15	14
8623	2	2889	2018-10-15 16:04:01	2018-10-15	14
8624	1	2890	2018-10-15 16:00:59	2018-10-15	14
8625	2	2890	2018-10-15 16:01:01	2018-10-15	14
8626	3	2890	2018-10-16 08:19:33	2018-10-16	6
8627	1	2891	2018-10-15 16:00:50	2018-10-15	14
8628	2	2891	2018-10-15 16:00:52	2018-10-15	14
8629	3	2891	2018-10-15 16:10:13	2018-10-15	14
8630	1	2892	2018-10-15 15:55:24	2018-10-15	13
8631	2	2892	2018-10-15 15:55:26	2018-10-15	13
8632	3	2892	2018-10-15 15:57:45	2018-10-15	13
8633	1	2893	2018-10-15 15:49:00	2018-10-15	13
8634	2	2893	2018-10-15 15:49:01	2018-10-15	13
8635	3	2893	2018-10-15 15:49:25	2018-10-15	13
8636	1	2894	2018-10-15 15:46:37	2018-10-15	13
8637	2	2894	2018-10-15 15:46:40	2018-10-15	13
8638	3	2894	2018-10-15 15:46:43	2018-10-15	13
8639	1	2895	2018-10-15 15:46:41	2018-10-15	13
8640	2	2895	2018-10-15 15:46:43	2018-10-15	13
8641	3	2895	2018-10-15 15:46:45	2018-10-15	13
8642	1	2896	2018-10-15 15:43:57	2018-10-15	13
8643	2	2896	2018-10-15 15:44:00	2018-10-15	13
8644	3	2896	2018-10-15 15:51:18	2018-10-15	13
8645	1	2897	2018-10-15 15:43:29	2018-10-15	13
8646	2	2897	2018-10-15 15:43:31	2018-10-15	13
8647	3	2897	2018-10-15 15:43:33	2018-10-15	13
8648	1	2898	2018-10-15 15:38:41	2018-10-15	13
8649	2	2898	2018-10-15 15:38:43	2018-10-15	13
8650	3	2898	2018-10-16 09:44:01	2018-10-16	7
8651	1	2899	2018-10-15 15:38:39	2018-10-15	13
8652	2	2899	2018-10-15 15:38:42	2018-10-15	13
8653	3	2899	2018-10-15 15:38:45	2018-10-15	13
8654	1	2900	2018-10-15 15:26:10	2018-10-15	13
8655	2	2900	2018-10-15 15:26:11	2018-10-15	13
8656	3	2900	2018-10-15 15:26:13	2018-10-15	13
8657	1	2901	2018-10-15 15:17:41	2018-10-15	13
8658	2	2901	2018-10-15 15:17:43	2018-10-15	13
8659	3	2901	2018-10-15 15:17:44	2018-10-15	13
8660	1	2902	2018-10-15 15:24:47	2018-10-15	13
8661	2	2902	2018-10-15 15:24:48	2018-10-15	13
8662	3	2902	2018-10-16 09:17:51	2018-10-16	7
8663	1	2903	2018-10-15 15:13:45	2018-10-15	13
8664	2	2903	2018-10-15 15:13:47	2018-10-15	13
8665	3	2903	2018-10-15 15:13:49	2018-10-15	13
8666	1	2904	2018-10-15 15:14:42	2018-10-15	13
8667	2	2904	2018-10-15 15:14:44	2018-10-15	13
8668	3	2904	2018-10-16 09:27:58	2018-10-16	7
8669	1	2905	2018-10-15 15:10:45	2018-10-15	13
8670	2	2905	2018-10-15 15:10:48	2018-10-15	13
8671	3	2905	2018-10-15 15:10:50	2018-10-15	13
8672	1	2906	2018-10-15 15:07:57	2018-10-15	13
8673	2	2906	2018-10-15 15:07:59	2018-10-15	13
8674	3	2906	2018-10-15 15:08:01	2018-10-15	13
8675	1	2907	2018-10-15 15:07:15	2018-10-15	13
8676	2	2907	2018-10-15 15:07:17	2018-10-15	13
8677	3	2907	2018-10-15 15:07:18	2018-10-15	13
8678	1	2908	2018-10-15 15:06:32	2018-10-15	13
8679	2	2908	2018-10-15 15:06:35	2018-10-15	13
8680	3	2908	2018-10-15 15:06:38	2018-10-15	13
8681	1	2909	2018-10-15 15:07:15	2018-10-15	13
8682	2	2909	2018-10-15 15:07:16	2018-10-15	13
8683	3	2909	2018-10-15 15:13:51	2018-10-15	13
8684	1	2910	2018-10-15 15:00:44	2018-10-15	13
8685	2	2910	2018-10-15 15:00:47	2018-10-15	13
8686	3	2910	2018-10-15 15:05:14	2018-10-15	13
8687	1	2911	2018-10-15 14:59:26	2018-10-15	12
8688	2	2911	2018-10-15 14:59:27	2018-10-15	12
8689	3	2911	2018-10-15 14:59:29	2018-10-15	12
8690	1	2912	2018-10-15 14:42:27	2018-10-15	12
8691	2	2912	2018-10-15 14:42:29	2018-10-15	12
8692	3	2912	2018-10-16 09:44:54	2018-10-16	7
8693	1	2913	2018-10-15 14:39:34	2018-10-15	12
8694	2	2913	2018-10-15 14:39:35	2018-10-15	12
8695	3	2913	2018-10-15 14:39:37	2018-10-15	12
8696	1	2914	2018-10-15 14:38:41	2018-10-15	12
8697	2	2914	2018-10-15 14:38:43	2018-10-15	12
8698	3	2914	2018-10-15 14:44:02	2018-10-15	12
8699	1	2915	2018-10-15 14:35:21	2018-10-15	12
8700	2	2915	2018-10-15 14:35:23	2018-10-15	12
8701	3	2915	2018-10-15 14:48:08	2018-10-15	12
8702	1	2916	2018-10-15 14:34:16	2018-10-15	12
8703	2	2916	2018-10-15 14:34:19	2018-10-15	12
8704	3	2916	2018-10-15 14:34:21	2018-10-15	12
8705	1	2917	2018-10-15 14:32:22	2018-10-15	12
8706	2	2917	2018-10-15 14:32:25	2018-10-15	12
8707	3	2917	2018-10-15 14:47:43	2018-10-15	12
8708	1	2918	2018-10-15 14:29:16	2018-10-15	12
8709	2	2918	2018-10-15 14:29:17	2018-10-15	12
8710	3	2918	2018-10-15 14:29:19	2018-10-15	12
8711	1	2919	2018-10-15 14:27:10	2018-10-15	12
8712	2	2919	2018-10-15 14:27:13	2018-10-15	12
8713	3	2919	2018-10-15 14:27:16	2018-10-15	12
8714	1	2920	2018-10-15 14:26:11	2018-10-15	12
8715	2	2920	2018-10-15 14:26:14	2018-10-15	12
8716	3	2920	2018-10-15 14:26:17	2018-10-15	12
8717	1	2921	2018-10-15 14:23:46	2018-10-15	12
8718	2	2921	2018-10-15 14:23:48	2018-10-15	12
8719	3	2921	2018-10-15 14:30:57	2018-10-15	12
8720	1	2922	2018-10-15 14:20:51	2018-10-15	12
8721	2	2922	2018-10-15 14:20:53	2018-10-15	12
8722	3	2922	2018-10-15 14:20:55	2018-10-15	12
8723	1	2923	2018-10-15 14:40:30	2018-10-15	12
8724	2	2923	2018-10-15 14:40:32	2018-10-15	12
8725	3	2923	2018-10-16 11:15:03	2018-10-16	9
8726	1	2924	2018-10-15 14:16:15	2018-10-15	12
8727	2	2924	2018-10-15 14:16:17	2018-10-15	12
8728	3	2924	2018-10-15 14:16:19	2018-10-15	12
8729	1	2925	2018-10-15 14:14:51	2018-10-15	12
8730	2	2925	2018-10-15 14:14:53	2018-10-15	12
8731	3	2925	2018-10-15 14:14:55	2018-10-15	12
8732	1	2926	2018-10-15 14:11:14	2018-10-15	12
8733	2	2926	2018-10-15 14:11:18	2018-10-15	12
8734	3	2926	2018-10-16 08:14:14	2018-10-16	6
8735	1	2927	2018-10-15 14:08:36	2018-10-15	12
8736	2	2927	2018-10-15 14:08:37	2018-10-15	12
8737	3	2927	2018-10-15 14:08:39	2018-10-15	12
8738	1	2928	2018-10-15 14:12:52	2018-10-15	12
8739	2	2928	2018-10-15 14:12:54	2018-10-15	12
8740	3	2928	2018-10-15 14:12:56	2018-10-15	12
8741	1	2929	2018-10-15 14:08:47	2018-10-15	12
8742	2	2929	2018-10-15 14:08:48	2018-10-15	12
8743	3	2929	2018-10-15 14:20:36	2018-10-15	12
8744	1	2930	2018-10-15 12:31:56	2018-10-15	10
8745	2	2930	2018-10-15 12:31:59	2018-10-15	10
8746	3	2930	2018-10-18 10:37:37	2018-10-18	8
8747	1	2931	2018-10-15 12:27:34	2018-10-15	10
8748	2	2931	2018-10-15 12:27:36	2018-10-15	10
8749	3	2931	2018-10-15 12:27:38	2018-10-15	10
8750	1	2932	2018-10-15 12:28:22	2018-10-15	10
8751	2	2932	2018-10-15 12:28:24	2018-10-15	10
8752	3	2932	2018-10-15 13:46:51	2018-10-15	11
8753	1	2933	2018-10-15 12:25:15	2018-10-15	10
8754	2	2933	2018-10-15 12:25:17	2018-10-15	10
8755	3	2933	2018-10-15 12:26:42	2018-10-15	10
8756	1	2934	2018-10-15 12:23:02	2018-10-15	10
8757	2	2934	2018-10-15 12:23:05	2018-10-15	10
8758	3	2934	2018-10-15 13:42:51	2018-10-15	11
8759	1	2935	2018-10-15 12:19:30	2018-10-15	10
8760	2	2935	2018-10-15 12:19:33	2018-10-15	10
8761	3	2935	2018-10-15 13:38:46	2018-10-15	11
8762	1	2936	2018-10-15 11:54:53	2018-10-15	9
8763	2	2936	2018-10-15 11:54:55	2018-10-15	9
8764	3	2936	2018-10-18 11:58:48	2018-10-18	9
8765	1	2937	2018-10-15 11:52:48	2018-10-15	9
8766	2	2937	2018-10-15 11:52:52	2018-10-15	9
8767	3	2937	2018-10-15 12:23:17	2018-10-15	10
8768	1	2938	2018-10-15 11:50:29	2018-10-15	9
8769	2	2938	2018-10-15 11:50:32	2018-10-15	9
8770	3	2938	2018-10-15 12:00:02	2018-10-15	10
8771	1	2939	2018-10-15 11:47:16	2018-10-15	9
8772	2	2939	2018-10-15 11:47:20	2018-10-15	9
8773	3	2939	2018-10-15 11:48:47	2018-10-15	9
8774	1	2940	2018-10-15 11:43:17	2018-10-15	9
8775	2	2940	2018-10-15 11:43:19	2018-10-15	9
8776	3	2940	2018-10-16 08:49:23	2018-10-16	6
8777	1	2941	2018-10-15 11:41:11	2018-10-15	9
8778	2	2941	2018-10-15 11:41:13	2018-10-15	9
8779	3	2941	2018-10-15 11:41:14	2018-10-15	9
8780	1	2942	2018-10-15 11:36:53	2018-10-15	9
8781	2	2942	2018-10-15 11:36:55	2018-10-15	9
8782	3	2942	2018-10-15 11:36:57	2018-10-15	9
8783	1	2943	2018-10-15 11:36:09	2018-10-15	9
8784	2	2943	2018-10-15 11:36:11	2018-10-15	9
8785	3	2943	2018-10-15 11:36:13	2018-10-15	9
8786	1	2944	2018-10-15 11:35:19	2018-10-15	9
8787	2	2944	2018-10-15 11:35:21	2018-10-15	9
8788	3	2944	2018-10-15 12:45:17	2018-10-15	10
8789	1	2945	2018-10-15 11:34:54	2018-10-15	9
8790	2	2945	2018-10-15 11:34:56	2018-10-15	9
8791	3	2945	2018-10-16 09:52:26	2018-10-16	7
8792	1	2946	2018-10-15 11:32:46	2018-10-15	9
8793	2	2946	2018-10-15 11:32:48	2018-10-15	9
8794	3	2946	2018-10-15 11:32:49	2018-10-15	9
8795	1	2947	2018-10-15 11:32:10	2018-10-15	9
8796	2	2947	2018-10-15 11:32:12	2018-10-15	9
8797	3	2947	2018-10-15 11:32:14	2018-10-15	9
8798	1	2948	2018-10-15 11:30:19	2018-10-15	9
8799	2	2948	2018-10-15 11:30:21	2018-10-15	9
8800	3	2948	2018-10-18 14:53:49	2018-10-18	12
8801	1	2949	2018-10-15 11:30:38	2018-10-15	9
8802	2	2949	2018-10-15 11:30:41	2018-10-15	9
8803	3	2949	2018-10-15 14:19:01	2018-10-15	12
8804	1	2950	2018-10-15 11:28:43	2018-10-15	9
8805	2	2950	2018-10-15 11:28:45	2018-10-15	9
8806	3	2950	2018-10-15 11:28:47	2018-10-15	9
8807	1	2951	2018-10-15 11:27:24	2018-10-15	9
8808	2	2951	2018-10-15 11:27:25	2018-10-15	9
8809	3	2951	2018-10-15 11:27:27	2018-10-15	9
8810	1	2952	2018-10-15 11:26:36	2018-10-15	9
8811	2	2952	2018-10-15 11:26:39	2018-10-15	9
8812	3	2952	2018-10-15 11:26:42	2018-10-15	9
8813	1	2953	2018-10-15 11:25:24	2018-10-15	9
8814	2	2953	2018-10-15 11:25:26	2018-10-15	9
8815	3	2953	2018-10-15 11:25:28	2018-10-15	9
8816	1	2954	2018-10-15 11:23:59	2018-10-15	9
8817	2	2954	2018-10-15 11:24:01	2018-10-15	9
8818	3	2954	2018-10-15 11:24:03	2018-10-15	9
8819	1	2955	2018-10-15 11:26:20	2018-10-15	9
8820	2	2955	2018-10-15 11:26:21	2018-10-15	9
8821	3	2955	2018-10-15 14:16:39	2018-10-15	12
8822	1	2956	2018-10-15 11:18:33	2018-10-15	9
8823	2	2956	2018-10-15 11:18:36	2018-10-15	9
8824	3	2956	2018-10-15 11:18:39	2018-10-15	9
8825	1	2957	2018-10-15 11:16:38	2018-10-15	9
8826	2	2957	2018-10-15 11:16:39	2018-10-15	9
8827	3	2957	2018-10-15 11:16:41	2018-10-15	9
8828	1	2958	2018-10-15 11:14:32	2018-10-15	9
8829	2	2958	2018-10-15 11:14:36	2018-10-15	9
8830	3	2958	2018-10-15 11:14:49	2018-10-15	9
8831	1	2959	2018-10-15 11:14:14	2018-10-15	9
8832	2	2959	2018-10-15 11:14:16	2018-10-15	9
8833	3	2959	2018-10-15 11:18:07	2018-10-15	9
8834	1	2960	2018-10-15 11:09:16	2018-10-15	9
8835	2	2960	2018-10-15 11:09:19	2018-10-15	9
8836	3	2960	2018-10-15 11:45:39	2018-10-15	9
8837	1	2961	2018-10-15 11:06:07	2018-10-15	9
8838	2	2961	2018-10-15 11:06:08	2018-10-15	9
8839	3	2961	2018-10-15 11:27:58	2018-10-15	9
8840	1	2962	2018-10-15 11:06:18	2018-10-15	9
8841	2	2962	2018-10-15 11:06:21	2018-10-15	9
8842	3	2962	2018-10-15 12:33:45	2018-10-15	10
8843	1	2963	2018-10-15 11:05:53	2018-10-15	9
8844	2	2963	2018-10-15 11:05:55	2018-10-15	9
8845	3	2963	2018-10-15 11:05:57	2018-10-15	9
8846	1	2964	2018-10-15 11:02:47	2018-10-15	9
8847	2	2964	2018-10-15 11:02:49	2018-10-15	9
8848	3	2964	2018-10-15 11:02:50	2018-10-15	9
8849	1	2965	2018-10-15 11:01:09	2018-10-15	9
8850	2	2965	2018-10-15 11:01:11	2018-10-15	9
8851	3	2965	2018-10-15 11:01:13	2018-10-15	9
8852	1	2966	2018-10-15 11:00:57	2018-10-15	9
8853	2	2966	2018-10-15 11:01:00	2018-10-15	9
8854	3	2966	2018-10-15 11:01:02	2018-10-15	9
8855	1	2967	2018-10-15 11:01:09	2018-10-15	9
8856	2	2967	2018-10-15 11:01:11	2018-10-15	9
8857	3	2967	2018-10-15 11:20:06	2018-10-15	9
8858	1	2968	2018-10-15 10:57:55	2018-10-15	8
8859	2	2968	2018-10-15 10:57:57	2018-10-15	8
8860	3	2968	2018-10-15 10:57:59	2018-10-15	8
8861	1	2969	2018-10-15 10:57:05	2018-10-15	8
8862	2	2969	2018-10-15 10:57:07	2018-10-15	8
8863	3	2969	2018-10-15 10:57:09	2018-10-15	8
8864	1	2970	2018-10-15 10:55:47	2018-10-15	8
8865	2	2970	2018-10-15 10:55:51	2018-10-15	8
8866	3	2970	2018-10-15 11:14:25	2018-10-15	9
8867	1	2971	2018-10-15 10:54:05	2018-10-15	8
8868	2	2971	2018-10-15 10:54:07	2018-10-15	8
8869	3	2971	2018-10-16 10:00:06	2018-10-16	8
8870	1	2972	2018-10-15 10:52:27	2018-10-15	8
8871	2	2972	2018-10-15 10:52:28	2018-10-15	8
8872	3	2972	2018-10-15 10:52:30	2018-10-15	8
8873	1	2973	2018-10-15 10:50:13	2018-10-15	8
8874	2	2973	2018-10-15 10:50:15	2018-10-15	8
8875	3	2973	2018-10-15 11:17:29	2018-10-15	9
8876	1	2974	2018-10-15 10:46:28	2018-10-15	8
8877	2	2974	2018-10-15 10:46:30	2018-10-15	8
8878	3	2974	2018-10-15 10:46:32	2018-10-15	8
8879	1	2975	2018-10-15 10:43:37	2018-10-15	8
8880	2	2975	2018-10-15 10:43:39	2018-10-15	8
8881	3	2975	2018-10-15 10:43:41	2018-10-15	8
8882	1	2976	2018-10-15 10:43:39	2018-10-15	8
8883	2	2976	2018-10-15 10:43:41	2018-10-15	8
8884	3	2976	2018-10-15 11:01:34	2018-10-15	9
8885	1	2977	2018-10-15 10:42:51	2018-10-15	8
8886	2	2977	2018-10-15 10:42:53	2018-10-15	8
8887	3	2977	2018-10-15 10:55:41	2018-10-15	8
8888	1	2978	2018-10-15 10:40:39	2018-10-15	8
8889	2	2978	2018-10-15 10:40:41	2018-10-15	8
8890	3	2978	2018-10-15 10:40:42	2018-10-15	8
8891	1	2979	2018-10-15 10:31:15	2018-10-15	8
8892	2	2979	2018-10-15 10:31:17	2018-10-15	8
8893	3	2979	2018-10-15 10:31:19	2018-10-15	8
8894	1	2980	2018-10-15 10:38:00	2018-10-15	8
8895	2	2980	2018-10-15 10:38:02	2018-10-15	8
8896	3	2980	2018-10-15 11:41:36	2018-10-15	9
8897	1	2981	2018-10-15 10:28:30	2018-10-15	8
8898	2	2981	2018-10-15 10:28:33	2018-10-15	8
8899	3	2981	2018-10-15 10:50:43	2018-10-15	8
8900	1	2982	2018-10-15 10:05:28	2018-10-15	8
8901	2	2982	2018-10-15 10:05:30	2018-10-15	8
8902	3	2982	2018-10-15 10:05:32	2018-10-15	8
8903	1	2983	2018-10-15 10:03:03	2018-10-15	8
8904	2	2983	2018-10-15 10:03:04	2018-10-15	8
8905	3	2983	2018-10-15 10:03:06	2018-10-15	8
8906	1	2984	2018-10-15 10:02:14	2018-10-15	8
8907	2	2984	2018-10-15 10:02:16	2018-10-15	8
8908	3	2984	2018-10-15 10:02:18	2018-10-15	8
8909	1	2985	2018-10-15 09:56:48	2018-10-15	7
8910	2	2985	2018-10-15 09:56:50	2018-10-15	7
8911	3	2985	2018-10-15 12:04:47	2018-10-15	10
8912	1	2986	2018-10-15 09:57:23	2018-10-15	7
8913	2	2986	2018-10-15 09:57:26	2018-10-15	7
8914	3	2986	2018-10-15 14:57:47	2018-10-15	12
8915	1	2987	2018-10-15 10:00:08	2018-10-15	8
8916	2	2987	2018-10-15 10:00:11	2018-10-15	8
8917	3	2987	2018-10-16 08:48:06	2018-10-16	6
8918	1	2988	2018-10-15 09:52:13	2018-10-15	7
8919	2	2988	2018-10-15 09:52:15	2018-10-15	7
8920	3	2988	2018-10-15 09:52:17	2018-10-15	7
8921	1	2989	2018-10-15 09:49:12	2018-10-15	7
8922	2	2989	2018-10-15 09:49:14	2018-10-15	7
8923	3	2989	2018-10-15 09:49:16	2018-10-15	7
8924	1	2990	2018-10-15 09:47:24	2018-10-15	7
8925	2	2990	2018-10-15 09:47:27	2018-10-15	7
8926	3	2990	2018-10-15 12:03:21	2018-10-15	10
8927	1	2991	2018-10-15 09:44:16	2018-10-15	7
8928	2	2991	2018-10-15 09:44:19	2018-10-15	7
8929	3	2991	2018-10-15 11:03:52	2018-10-15	9
8930	1	2992	2018-10-15 09:42:29	2018-10-15	7
8931	2	2992	2018-10-15 09:42:31	2018-10-15	7
8932	3	2992	2018-10-15 09:42:33	2018-10-15	7
8933	1	2993	2018-10-15 09:40:57	2018-10-15	7
8934	2	2993	2018-10-15 09:41:00	2018-10-15	7
8935	3	2993	2018-10-15 09:41:01	2018-10-15	7
8936	1	2994	2018-10-15 09:37:23	2018-10-15	7
8937	2	2994	2018-10-15 09:37:25	2018-10-15	7
8938	3	2994	2018-10-15 09:37:27	2018-10-15	7
8939	1	2995	2018-10-15 09:37:07	2018-10-15	7
8940	2	2995	2018-10-15 09:37:09	2018-10-15	7
8941	3	2995	2018-10-15 12:06:50	2018-10-15	10
8942	1	2996	2018-10-15 09:36:20	2018-10-15	7
8943	2	2996	2018-10-15 09:36:22	2018-10-15	7
8944	3	2996	2018-10-15 09:51:24	2018-10-15	7
8945	1	2997	2018-10-15 09:35:59	2018-10-15	7
8946	2	2997	2018-10-15 09:36:02	2018-10-15	7
8947	3	2997	2018-10-15 15:52:30	2018-10-15	13
8948	1	2998	2018-10-15 09:30:51	2018-10-15	7
8949	2	2998	2018-10-15 09:30:53	2018-10-15	7
8950	3	2998	2018-10-15 09:30:55	2018-10-15	7
8951	1	2999	2018-10-15 09:33:44	2018-10-15	7
8952	2	2999	2018-10-15 09:33:46	2018-10-15	7
8953	3	2999	2018-10-15 10:48:15	2018-10-15	8
8954	1	3000	2018-10-15 09:21:14	2018-10-15	7
8955	2	3000	2018-10-15 09:21:16	2018-10-15	7
8956	3	3000	2018-10-15 09:21:18	2018-10-15	7
8957	1	3001	2018-10-15 09:23:39	2018-10-15	7
8958	2	3001	2018-10-15 09:23:42	2018-10-15	7
8959	3	3001	2018-10-15 09:48:56	2018-10-15	7
8960	1	3002	2018-10-15 09:13:11	2018-10-15	7
8961	2	3002	2018-10-15 09:13:13	2018-10-15	7
8962	3	3002	2018-10-15 09:13:14	2018-10-15	7
8963	1	3003	2018-10-15 09:10:44	2018-10-15	7
8964	2	3003	2018-10-15 09:10:46	2018-10-15	7
8965	3	3003	2018-10-15 09:31:51	2018-10-15	7
8966	1	3004	2018-10-15 09:10:08	2018-10-15	7
8967	2	3004	2018-10-15 09:10:12	2018-10-15	7
8968	3	3004	2018-10-15 09:10:14	2018-10-15	7
8969	1	3005	2018-10-15 09:04:39	2018-10-15	7
8970	2	3005	2018-10-15 09:04:40	2018-10-15	7
8971	3	3005	2018-10-15 09:04:42	2018-10-15	7
8972	1	3006	2018-10-15 09:03:38	2018-10-15	7
8973	2	3006	2018-10-15 09:03:40	2018-10-15	7
8974	3	3006	2018-10-15 09:03:42	2018-10-15	7
8975	1	3007	2018-10-15 09:03:53	2018-10-15	7
8976	2	3007	2018-10-15 09:03:55	2018-10-15	7
8977	3	3007	2018-10-15 09:03:57	2018-10-15	7
8978	1	3008	2018-10-15 09:02:23	2018-10-15	7
8979	2	3008	2018-10-15 09:02:24	2018-10-15	7
8980	3	3008	2018-10-15 09:02:26	2018-10-15	7
8981	1	3009	2018-10-15 09:03:47	2018-10-15	7
8982	2	3009	2018-10-15 09:03:49	2018-10-15	7
8983	3	3009	2018-10-15 10:34:18	2018-10-15	8
8984	1	3010	2018-10-15 08:54:31	2018-10-15	6
8985	2	3010	2018-10-15 08:54:33	2018-10-15	6
8986	3	3010	2018-10-15 08:54:34	2018-10-15	6
8987	1	3011	2018-10-15 08:55:57	2018-10-15	6
8988	2	3011	2018-10-15 08:56:00	2018-10-15	6
8989	3	3011	2018-10-15 11:32:42	2018-10-15	9
8990	1	3012	2018-10-15 08:53:05	2018-10-15	6
8991	2	3012	2018-10-15 08:53:06	2018-10-15	6
8992	3	3012	2018-10-15 09:29:42	2018-10-15	7
8993	1	3013	2018-10-15 08:49:10	2018-10-15	6
8994	2	3013	2018-10-15 08:49:13	2018-10-15	6
8995	3	3013	2018-10-15 11:07:51	2018-10-15	9
8996	1	3014	2018-10-15 08:44:58	2018-10-15	6
8997	2	3014	2018-10-15 08:45:01	2018-10-15	6
8998	3	3014	2018-10-15 08:55:47	2018-10-15	6
8999	1	3015	2018-10-15 08:38:40	2018-10-15	6
9000	2	3015	2018-10-15 08:38:44	2018-10-15	6
9001	3	3015	2018-10-15 08:38:46	2018-10-15	6
9002	1	3016	2018-10-15 08:39:51	2018-10-15	6
9003	2	3016	2018-10-15 08:39:54	2018-10-15	6
9004	3	3016	2018-10-16 08:17:01	2018-10-16	6
9005	1	3017	2018-10-15 07:55:37	2018-10-15	5
9006	2	3017	2018-10-15 07:55:38	2018-10-15	5
9007	3	3017	2018-10-15 11:39:51	2018-10-15	9
9008	1	3018	2018-10-15 07:51:17	2018-10-15	5
9009	2	3018	2018-10-15 07:51:19	2018-10-15	5
9010	3	3018	2018-10-15 11:28:48	2018-10-15	9
9011	1	3019	2018-10-15 07:47:35	2018-10-15	5
9012	2	3019	2018-10-15 07:47:39	2018-10-15	5
9013	3	3019	2018-10-15 11:27:22	2018-10-15	9
9014	1	3020	2018-10-15 00:31:55	2018-10-14	22
9015	2	3020	2018-10-15 00:31:58	2018-10-14	22
9016	3	3020	2018-10-15 14:39:31	2018-10-15	12
9017	1	3021	2018-10-14 22:01:04	2018-10-14	20
9018	2	3021	2018-10-14 22:01:07	2018-10-14	20
9019	3	3021	2018-10-15 14:24:13	2018-10-15	12
9020	1	3022	2018-10-14 20:11:56	2018-10-14	18
9021	2	3022	2018-10-14 20:11:58	2018-10-14	18
9022	3	3022	2018-10-15 10:19:40	2018-10-15	8
9023	1	3023	2018-10-14 15:45:14	2018-10-14	13
9024	2	3023	2018-10-14 15:45:15	2018-10-14	13
9025	3	3023	2018-10-16 10:55:00	2018-10-16	8
9026	1	3024	2018-10-14 13:23:01	2018-10-14	11
9027	2	3024	2018-10-14 13:23:03	2018-10-14	11
9028	3	3024	2018-10-15 14:37:17	2018-10-15	12
9029	1	3025	2018-10-13 21:12:51	2018-10-13	19
9030	2	3025	2018-10-13 21:12:54	2018-10-13	19
9031	1	3026	2018-10-13 14:30:58	2018-10-13	12
9032	2	3026	2018-10-13 14:31:00	2018-10-13	12
9033	3	3026	2018-10-15 14:08:14	2018-10-15	12
9034	1	3027	2018-10-12 16:56:44	2018-10-12	14
9035	2	3027	2018-10-12 16:56:46	2018-10-12	14
9036	3	3027	2018-10-12 16:56:49	2018-10-12	14
9037	1	3028	2018-10-12 16:55:46	2018-10-12	14
9038	2	3028	2018-10-12 16:55:49	2018-10-12	14
9039	3	3028	2018-10-15 11:25:15	2018-10-15	9
9040	1	3029	2018-10-12 16:50:22	2018-10-12	14
9041	2	3029	2018-10-12 16:50:24	2018-10-12	14
9042	3	3029	2018-10-12 16:50:26	2018-10-12	14
9043	1	3030	2018-10-12 16:48:15	2018-10-12	14
9044	2	3030	2018-10-12 16:48:16	2018-10-12	14
9045	3	3030	2018-10-15 09:25:22	2018-10-15	7
9046	1	3031	2018-10-12 16:35:38	2018-10-12	14
9047	2	3031	2018-10-12 16:35:40	2018-10-12	14
9048	3	3031	2018-10-15 09:22:57	2018-10-15	7
9049	1	3032	2018-10-12 16:15:46	2018-10-12	14
9050	2	3032	2018-10-12 16:15:48	2018-10-12	14
9051	3	3032	2018-10-12 16:15:50	2018-10-12	14
9052	1	3033	2018-10-12 16:06:56	2018-10-12	14
9053	2	3033	2018-10-12 16:06:59	2018-10-12	14
9054	3	3033	2018-10-15 09:15:44	2018-10-15	7
9055	1	3034	2018-10-12 16:05:00	2018-10-12	14
9056	2	3034	2018-10-12 16:05:03	2018-10-12	14
9057	3	3034	2018-10-12 16:05:05	2018-10-12	14
9058	1	3035	2018-10-12 15:54:13	2018-10-12	13
9059	2	3035	2018-10-12 15:54:15	2018-10-12	13
9060	3	3035	2018-10-12 15:54:17	2018-10-12	13
9061	1	3036	2018-10-12 15:53:00	2018-10-12	13
9062	2	3036	2018-10-12 15:53:03	2018-10-12	13
9063	3	3036	2018-10-12 15:53:05	2018-10-12	13
9064	1	3037	2018-10-12 15:53:29	2018-10-12	13
9065	2	3037	2018-10-12 15:53:31	2018-10-12	13
9066	3	3037	2018-10-15 09:09:15	2018-10-15	7
9067	1	3038	2018-10-12 15:49:59	2018-10-12	13
9068	2	3038	2018-10-12 15:50:01	2018-10-12	13
9069	3	3038	2018-10-12 15:50:03	2018-10-12	13
9070	1	3039	2018-10-12 15:49:58	2018-10-12	13
9071	2	3039	2018-10-12 15:50:02	2018-10-12	13
9072	3	3039	2018-10-12 16:22:53	2018-10-12	14
9073	1	3040	2018-10-12 15:45:54	2018-10-12	13
9074	2	3040	2018-10-12 15:45:57	2018-10-12	13
9075	3	3040	2018-10-12 16:10:50	2018-10-12	14
9076	1	3041	2018-10-12 15:38:38	2018-10-12	13
9077	2	3041	2018-10-12 15:38:40	2018-10-12	13
9078	3	3041	2018-10-12 15:38:41	2018-10-12	13
9079	1	3042	2018-10-12 15:39:47	2018-10-12	13
9080	2	3042	2018-10-12 15:39:49	2018-10-12	13
9081	3	3042	2018-10-15 09:20:11	2018-10-15	7
9082	1	3043	2018-10-12 15:40:23	2018-10-12	13
9083	2	3043	2018-10-12 15:40:24	2018-10-12	13
9084	3	3043	2018-10-15 11:22:08	2018-10-15	9
9085	1	3044	2018-10-12 15:26:05	2018-10-12	13
9086	2	3044	2018-10-12 15:26:06	2018-10-12	13
9087	3	3044	2018-10-15 09:18:52	2018-10-15	7
9088	1	3045	2018-10-12 15:21:15	2018-10-12	13
9089	2	3045	2018-10-12 15:21:17	2018-10-12	13
9090	3	3045	2018-10-15 09:15:52	2018-10-15	7
9091	1	3046	2018-10-12 15:18:57	2018-10-12	13
9092	2	3046	2018-10-12 15:18:59	2018-10-12	13
9093	3	3046	2018-10-15 11:15:23	2018-10-15	9
9094	1	3047	2018-10-12 15:08:42	2018-10-12	13
9095	2	3047	2018-10-12 15:08:45	2018-10-12	13
9096	3	3047	2018-10-15 12:01:59	2018-10-15	10
9097	1	3048	2018-10-12 15:06:18	2018-10-12	13
9098	2	3048	2018-10-12 15:06:19	2018-10-12	13
9099	3	3048	2018-10-16 09:00:48	2018-10-16	7
9100	1	3049	2018-10-12 15:03:56	2018-10-12	13
9101	2	3049	2018-10-12 15:03:58	2018-10-12	13
9102	3	3049	2018-10-12 15:04:00	2018-10-12	13
9103	1	3050	2018-10-12 15:06:05	2018-10-12	13
9104	2	3050	2018-10-12 15:06:08	2018-10-12	13
9105	3	3050	2018-10-12 15:06:10	2018-10-12	13
9106	1	3051	2018-10-12 14:59:20	2018-10-12	12
9107	2	3051	2018-10-12 14:59:22	2018-10-12	12
9108	3	3051	2018-10-12 14:59:26	2018-10-12	12
9109	1	3052	2018-10-12 14:53:47	2018-10-12	12
9110	2	3052	2018-10-12 14:53:48	2018-10-12	12
9111	3	3052	2018-10-12 14:53:50	2018-10-12	12
9112	1	3053	2018-10-12 14:52:47	2018-10-12	12
9113	2	3053	2018-10-12 14:52:49	2018-10-12	12
9114	3	3053	2018-10-12 14:52:51	2018-10-12	12
9115	1	3054	2018-10-12 14:41:44	2018-10-12	12
9116	2	3054	2018-10-12 14:41:47	2018-10-12	12
9117	3	3054	2018-10-15 09:29:31	2018-10-15	7
9118	1	3055	2018-10-12 14:37:37	2018-10-12	12
9119	2	3055	2018-10-12 14:37:39	2018-10-12	12
9120	3	3055	2018-10-12 14:37:41	2018-10-12	12
9121	1	3056	2018-10-12 14:31:18	2018-10-12	12
9122	2	3056	2018-10-12 14:31:20	2018-10-12	12
9123	3	3056	2018-10-12 14:31:21	2018-10-12	12
9124	1	3057	2018-10-12 14:35:59	2018-10-12	12
9125	2	3057	2018-10-12 14:36:01	2018-10-12	12
9126	3	3057	2018-10-17 08:10:42	2018-10-17	6
9127	1	3058	2018-10-12 14:30:34	2018-10-12	12
9128	2	3058	2018-10-12 14:30:37	2018-10-12	12
9129	3	3058	2018-10-12 14:30:39	2018-10-12	12
9130	1	3059	2018-10-12 14:27:54	2018-10-12	12
9131	2	3059	2018-10-12 14:27:56	2018-10-12	12
9132	3	3059	2018-10-12 14:27:57	2018-10-12	12
9133	1	3060	2018-10-12 14:22:35	2018-10-12	12
9134	2	3060	2018-10-12 14:22:37	2018-10-12	12
9135	3	3060	2018-10-12 14:22:39	2018-10-12	12
9136	1	3061	2018-10-12 14:21:10	2018-10-12	12
9137	2	3061	2018-10-12 14:21:11	2018-10-12	12
9138	3	3061	2018-10-12 14:21:13	2018-10-12	12
9139	1	3062	2018-10-12 14:19:23	2018-10-12	12
9140	2	3062	2018-10-12 14:19:25	2018-10-12	12
9141	3	3062	2018-10-12 14:19:27	2018-10-12	12
9142	1	3063	2018-10-12 14:20:02	2018-10-12	12
9143	2	3063	2018-10-12 14:20:04	2018-10-12	12
9144	3	3063	2018-10-15 09:13:47	2018-10-15	7
9145	1	3064	2018-10-12 14:10:33	2018-10-12	12
9146	2	3064	2018-10-12 14:10:35	2018-10-12	12
9147	3	3064	2018-10-12 14:10:37	2018-10-12	12
9148	1	3065	2018-10-12 14:11:05	2018-10-12	12
9149	2	3065	2018-10-12 14:11:07	2018-10-12	12
9150	3	3065	2018-10-12 14:11:10	2018-10-12	12
9151	1	3066	2018-10-12 14:06:37	2018-10-12	12
9152	2	3066	2018-10-12 14:06:40	2018-10-12	12
9153	3	3066	2018-10-12 15:08:01	2018-10-12	13
9154	1	3067	2018-10-12 14:06:38	2018-10-12	12
9155	2	3067	2018-10-12 14:06:42	2018-10-12	12
9156	3	3067	2018-10-12 14:06:44	2018-10-12	12
9157	1	3068	2018-10-12 13:19:23	2018-10-12	11
9158	2	3068	2018-10-12 13:19:24	2018-10-12	11
9159	3	3068	2018-10-12 13:25:18	2018-10-12	11
9160	1	3069	2018-10-12 13:17:27	2018-10-12	11
9161	2	3069	2018-10-12 13:17:30	2018-10-12	11
9162	3	3069	2018-10-15 09:09:13	2018-10-15	7
9163	1	3070	2018-10-12 13:14:40	2018-10-12	11
9164	2	3070	2018-10-12 13:14:43	2018-10-12	11
9165	3	3070	2018-10-12 13:25:39	2018-10-12	11
9166	1	3071	2018-10-12 12:59:47	2018-10-12	10
9167	2	3071	2018-10-12 12:59:49	2018-10-12	10
9168	3	3071	2018-10-16 11:22:21	2018-10-16	9
9169	1	3072	2018-10-12 12:12:15	2018-10-12	10
9170	2	3072	2018-10-12 12:12:17	2018-10-12	10
9171	3	3072	2018-10-12 12:12:19	2018-10-12	10
9172	1	3073	2018-10-12 11:56:21	2018-10-12	9
9173	2	3073	2018-10-12 11:56:23	2018-10-12	9
9174	3	3073	2018-10-12 12:03:15	2018-10-12	10
9175	1	3074	2018-10-12 11:45:20	2018-10-12	9
9176	2	3074	2018-10-12 11:45:22	2018-10-12	9
9177	3	3074	2018-10-12 11:45:23	2018-10-12	9
9178	1	3075	2018-10-12 11:43:54	2018-10-12	9
9179	2	3075	2018-10-12 11:43:56	2018-10-12	9
9180	3	3075	2018-10-12 11:43:58	2018-10-12	9
9181	1	3076	2018-10-12 11:42:27	2018-10-12	9
9182	2	3076	2018-10-12 11:42:29	2018-10-12	9
9183	3	3076	2018-10-15 09:02:20	2018-10-15	7
9184	1	3077	2018-10-12 11:46:05	2018-10-12	9
9185	2	3077	2018-10-12 11:46:07	2018-10-12	9
9186	3	3077	2018-10-15 09:07:08	2018-10-15	7
9187	1	3078	2018-10-12 11:38:22	2018-10-12	9
9188	2	3078	2018-10-12 11:38:24	2018-10-12	9
9189	3	3078	2018-10-15 11:12:06	2018-10-15	9
9190	1	3079	2018-10-12 11:37:26	2018-10-12	9
9191	2	3079	2018-10-12 11:37:28	2018-10-12	9
9192	3	3079	2018-10-16 10:00:47	2018-10-16	8
9193	1	3080	2018-10-12 11:33:15	2018-10-12	9
9194	2	3080	2018-10-12 11:33:17	2018-10-12	9
9195	3	3080	2018-10-12 11:49:51	2018-10-12	9
9196	1	3081	2018-10-12 11:28:13	2018-10-12	9
9197	2	3081	2018-10-12 11:28:16	2018-10-12	9
9198	3	3081	2018-10-12 11:28:18	2018-10-12	9
9199	1	3082	2018-10-12 11:27:38	2018-10-12	9
9200	2	3082	2018-10-12 11:27:39	2018-10-12	9
9201	3	3082	2018-10-15 12:20:31	2018-10-15	10
9202	1	3083	2018-10-12 11:18:57	2018-10-12	9
9203	2	3083	2018-10-12 11:18:59	2018-10-12	9
9204	3	3083	2018-10-15 09:39:22	2018-10-15	7
9205	1	3084	2018-10-12 11:13:50	2018-10-12	9
9206	2	3084	2018-10-12 11:13:51	2018-10-12	9
9207	3	3084	2018-10-12 11:13:53	2018-10-12	9
9208	1	3085	2018-10-12 11:13:55	2018-10-12	9
9209	2	3085	2018-10-12 11:13:57	2018-10-12	9
9210	3	3085	2018-10-12 12:05:36	2018-10-12	10
9211	1	3086	2018-10-12 11:11:14	2018-10-12	9
9212	2	3086	2018-10-12 11:11:15	2018-10-12	9
9213	3	3086	2018-10-15 08:47:49	2018-10-15	6
9214	1	3087	2018-10-12 11:07:34	2018-10-12	9
9215	2	3087	2018-10-12 11:07:36	2018-10-12	9
9216	3	3087	2018-10-12 11:07:38	2018-10-12	9
9217	1	3088	2018-10-12 11:10:11	2018-10-12	9
9218	2	3088	2018-10-12 11:10:14	2018-10-12	9
9219	3	3088	2018-10-12 11:10:17	2018-10-12	9
9220	1	3089	2018-10-12 11:07:14	2018-10-12	9
9221	2	3089	2018-10-12 11:07:16	2018-10-12	9
9222	1	3090	2018-10-12 11:04:43	2018-10-12	9
9223	2	3090	2018-10-12 11:04:46	2018-10-12	9
9224	3	3090	2018-10-12 11:04:49	2018-10-12	9
9225	1	3091	2018-10-12 11:05:10	2018-10-12	9
9226	2	3091	2018-10-12 11:05:13	2018-10-12	9
9227	3	3091	2018-10-12 11:05:15	2018-10-12	9
9228	1	3092	2018-10-12 10:59:54	2018-10-12	8
9229	2	3092	2018-10-12 10:59:56	2018-10-12	8
9230	3	3092	2018-10-12 10:59:58	2018-10-12	8
9231	1	3093	2018-10-12 11:00:50	2018-10-12	9
9232	2	3093	2018-10-12 11:00:52	2018-10-12	9
9233	3	3093	2018-10-15 09:50:28	2018-10-15	7
9234	1	3094	2018-10-12 10:48:59	2018-10-12	8
9235	2	3094	2018-10-12 10:49:01	2018-10-12	8
9236	3	3094	2018-10-12 10:49:03	2018-10-12	8
9237	1	3095	2018-10-12 11:04:17	2018-10-12	9
9238	2	3095	2018-10-12 11:04:19	2018-10-12	9
9239	3	3095	2018-10-15 08:44:28	2018-10-15	6
9240	1	3096	2018-10-12 10:35:59	2018-10-12	8
9241	2	3096	2018-10-12 10:36:02	2018-10-12	8
9242	3	3096	2018-10-15 09:01:07	2018-10-15	7
9243	1	3097	2018-10-12 10:33:14	2018-10-12	8
9244	2	3097	2018-10-12 10:33:16	2018-10-12	8
9245	3	3097	2018-10-12 10:33:18	2018-10-12	8
9246	1	3098	2018-10-12 10:31:25	2018-10-12	8
9247	2	3098	2018-10-12 10:31:27	2018-10-12	8
9248	3	3098	2018-10-12 12:21:13	2018-10-12	10
9249	1	3099	2018-10-12 10:34:32	2018-10-12	8
9250	2	3099	2018-10-12 10:34:35	2018-10-12	8
9251	3	3099	2018-10-15 08:39:01	2018-10-15	6
9252	1	3100	2018-10-12 10:21:43	2018-10-12	8
9253	2	3100	2018-10-12 10:21:46	2018-10-12	8
9254	3	3100	2018-10-12 10:21:48	2018-10-12	8
9255	1	3101	2018-10-12 10:21:17	2018-10-12	8
9256	2	3101	2018-10-12 10:21:19	2018-10-12	8
9257	3	3101	2018-10-15 11:08:18	2018-10-15	9
9258	1	3102	2018-10-12 10:21:01	2018-10-12	8
9259	2	3102	2018-10-12 10:21:03	2018-10-12	8
9260	3	3102	2018-10-12 10:21:05	2018-10-12	8
9261	1	3103	2018-10-12 10:19:04	2018-10-12	8
9262	2	3103	2018-10-12 10:19:06	2018-10-12	8
9263	3	3103	2018-10-15 08:51:44	2018-10-15	6
9264	1	3104	2018-10-12 10:16:54	2018-10-12	8
9265	2	3104	2018-10-12 10:16:56	2018-10-12	8
9266	3	3104	2018-10-12 10:16:58	2018-10-12	8
9267	1	3105	2018-10-12 10:15:27	2018-10-12	8
9268	2	3105	2018-10-12 10:15:29	2018-10-12	8
9269	3	3105	2018-10-12 10:15:30	2018-10-12	8
9270	1	3106	2018-10-12 10:13:44	2018-10-12	8
9271	2	3106	2018-10-12 10:13:46	2018-10-12	8
9272	3	3106	2018-10-15 11:17:29	2018-10-15	9
9273	1	3107	2018-10-12 10:11:43	2018-10-12	8
9274	2	3107	2018-10-12 10:11:47	2018-10-12	8
9275	3	3107	2018-10-15 11:06:31	2018-10-15	9
9276	1	3108	2018-10-12 10:06:31	2018-10-12	8
9277	2	3108	2018-10-12 10:06:33	2018-10-12	8
9278	3	3108	2018-10-12 10:06:35	2018-10-12	8
9279	1	3109	2018-10-12 10:05:47	2018-10-12	8
9280	2	3109	2018-10-12 10:05:49	2018-10-12	8
9281	3	3109	2018-10-12 10:09:21	2018-10-12	8
9282	1	3110	2018-10-12 10:05:06	2018-10-12	8
9283	2	3110	2018-10-12 10:05:08	2018-10-12	8
9284	3	3110	2018-10-15 08:46:54	2018-10-15	6
9285	1	3111	2018-10-12 10:00:45	2018-10-12	8
9286	2	3111	2018-10-12 10:00:47	2018-10-12	8
9287	3	3111	2018-10-12 10:00:49	2018-10-12	8
9288	1	3112	2018-10-12 10:01:21	2018-10-12	8
9289	2	3112	2018-10-12 10:01:22	2018-10-12	8
9290	1	3113	2018-10-12 09:59:12	2018-10-12	7
9291	2	3113	2018-10-12 09:59:15	2018-10-12	7
9292	3	3113	2018-10-12 09:59:16	2018-10-12	7
9293	1	3114	2018-10-12 09:55:25	2018-10-12	7
9294	2	3114	2018-10-12 09:55:26	2018-10-12	7
9295	3	3114	2018-10-15 08:39:38	2018-10-15	6
9296	1	3115	2018-10-12 09:53:44	2018-10-12	7
9297	2	3115	2018-10-12 09:53:46	2018-10-12	7
9298	3	3115	2018-10-15 09:46:03	2018-10-15	7
9299	1	3116	2018-10-12 09:50:00	2018-10-12	7
9300	2	3116	2018-10-12 09:50:02	2018-10-12	7
9301	3	3116	2018-10-12 09:50:05	2018-10-12	7
9302	1	3117	2018-10-12 09:49:02	2018-10-12	7
9303	2	3117	2018-10-12 09:49:04	2018-10-12	7
9304	3	3117	2018-10-12 09:49:05	2018-10-12	7
9305	1	3118	2018-10-12 09:46:26	2018-10-12	7
9306	2	3118	2018-10-12 09:46:27	2018-10-12	7
9307	3	3118	2018-10-12 09:46:29	2018-10-12	7
9308	1	3119	2018-10-12 09:45:26	2018-10-12	7
9309	2	3119	2018-10-12 09:45:28	2018-10-12	7
9310	3	3119	2018-10-12 09:45:30	2018-10-12	7
9311	1	3120	2018-10-12 09:53:18	2018-10-12	7
9312	2	3120	2018-10-12 09:53:21	2018-10-12	7
9313	3	3120	2018-10-12 11:52:27	2018-10-12	9
9314	1	3121	2018-10-12 09:38:46	2018-10-12	7
9315	2	3121	2018-10-12 09:38:48	2018-10-12	7
9316	3	3121	2018-10-12 09:50:56	2018-10-12	7
9317	1	3122	2018-10-12 09:22:01	2018-10-12	7
9318	2	3122	2018-10-12 09:22:03	2018-10-12	7
9319	3	3122	2018-10-12 11:16:52	2018-10-12	9
9320	1	3123	2018-10-12 09:15:57	2018-10-12	7
9321	2	3123	2018-10-12 09:15:59	2018-10-12	7
9322	3	3123	2018-10-12 09:16:01	2018-10-12	7
9323	1	3124	2018-10-12 09:14:03	2018-10-12	7
9324	2	3124	2018-10-12 09:14:04	2018-10-12	7
9325	3	3124	2018-10-12 09:14:06	2018-10-12	7
9326	1	3125	2018-10-12 09:14:18	2018-10-12	7
9327	2	3125	2018-10-12 09:14:19	2018-10-12	7
9328	3	3125	2018-10-12 09:14:21	2018-10-12	7
9329	1	3126	2018-10-12 09:13:09	2018-10-12	7
9330	2	3126	2018-10-12 09:13:11	2018-10-12	7
9331	3	3126	2018-10-12 11:16:37	2018-10-12	9
9332	1	3127	2018-10-12 09:08:25	2018-10-12	7
9333	2	3127	2018-10-12 09:08:26	2018-10-12	7
9334	3	3127	2018-10-12 11:44:23	2018-10-12	9
9335	1	3128	2018-10-12 09:05:19	2018-10-12	7
9336	2	3128	2018-10-12 09:05:21	2018-10-12	7
9337	3	3128	2018-10-12 09:05:22	2018-10-12	7
9338	1	3129	2018-10-12 08:56:18	2018-10-12	6
9339	2	3129	2018-10-12 08:56:20	2018-10-12	6
9340	3	3129	2018-10-12 08:56:22	2018-10-12	6
9341	1	3130	2018-10-12 09:05:33	2018-10-12	7
9342	2	3130	2018-10-12 09:05:35	2018-10-12	7
9343	3	3130	2018-10-12 11:15:25	2018-10-12	9
9344	1	3131	2018-10-12 08:48:07	2018-10-12	6
9345	2	3131	2018-10-12 08:48:09	2018-10-12	6
9346	3	3131	2018-10-12 08:48:10	2018-10-12	6
9347	1	3132	2018-10-12 08:46:28	2018-10-12	6
9348	2	3132	2018-10-12 08:46:30	2018-10-12	6
9349	3	3132	2018-10-12 08:46:31	2018-10-12	6
9350	1	3133	2018-10-12 08:44:52	2018-10-12	6
9351	2	3133	2018-10-12 08:44:54	2018-10-12	6
9352	3	3133	2018-10-12 08:44:55	2018-10-12	6
9353	1	3134	2018-10-12 08:41:44	2018-10-12	6
9354	2	3134	2018-10-12 08:41:46	2018-10-12	6
9355	3	3134	2018-10-15 09:41:36	2018-10-15	7
9356	1	3135	2018-10-12 08:35:48	2018-10-12	6
9357	2	3135	2018-10-12 08:35:50	2018-10-12	6
9358	3	3135	2018-10-12 08:43:32	2018-10-12	6
9359	1	3136	2018-10-12 04:58:53	2018-10-12	2
9360	2	3136	2018-10-12 04:58:55	2018-10-12	2
9361	3	3136	2018-10-15 09:37:37	2018-10-15	7
9362	1	3137	2018-10-11 16:49:26	2018-10-11	14
9363	2	3137	2018-10-11 16:49:28	2018-10-11	14
9364	3	3137	2018-10-11 16:49:30	2018-10-11	14
9365	1	3138	2018-10-11 16:47:23	2018-10-11	14
9366	2	3138	2018-10-11 16:47:25	2018-10-11	14
9367	3	3138	2018-10-11 17:25:56	2018-10-11	15
9368	1	3139	2018-10-11 16:45:33	2018-10-11	14
9369	2	3139	2018-10-11 16:45:35	2018-10-11	14
9370	3	3139	2018-10-11 16:45:37	2018-10-11	14
9371	1	3140	2018-10-11 16:44:54	2018-10-11	14
9372	2	3140	2018-10-11 16:44:56	2018-10-11	14
9373	3	3140	2018-10-11 16:44:58	2018-10-11	14
9374	1	3141	2018-10-11 16:43:59	2018-10-11	14
9375	2	3141	2018-10-11 16:44:01	2018-10-11	14
9376	3	3141	2018-10-15 10:21:12	2018-10-15	8
9377	1	3142	2018-10-11 16:36:03	2018-10-11	14
9378	2	3142	2018-10-11 16:36:05	2018-10-11	14
9379	3	3142	2018-10-11 16:36:07	2018-10-11	14
9380	1	3143	2018-10-11 16:32:30	2018-10-11	14
9381	2	3143	2018-10-11 16:32:31	2018-10-11	14
9382	3	3143	2018-10-11 16:32:33	2018-10-11	14
9383	1	3144	2018-10-11 16:21:37	2018-10-11	14
9384	2	3144	2018-10-11 16:21:39	2018-10-11	14
9385	3	3144	2018-10-11 16:21:41	2018-10-11	14
9386	1	3145	2018-10-11 16:00:20	2018-10-11	14
9387	2	3145	2018-10-11 16:00:22	2018-10-11	14
9388	3	3145	2018-10-12 08:33:37	2018-10-12	6
9389	1	3146	2018-10-11 15:57:13	2018-10-11	13
9390	2	3146	2018-10-11 15:57:14	2018-10-11	13
9391	3	3146	2018-10-11 15:57:16	2018-10-11	13
9392	1	3147	2018-10-11 15:49:11	2018-10-11	13
9393	2	3147	2018-10-11 15:49:13	2018-10-11	13
9394	3	3147	2018-10-11 15:49:15	2018-10-11	13
9395	1	3148	2018-10-11 15:47:29	2018-10-11	13
9396	2	3148	2018-10-11 15:47:31	2018-10-11	13
9397	3	3148	2018-10-11 15:47:33	2018-10-11	13
9398	1	3149	2018-10-11 15:45:30	2018-10-11	13
9399	2	3149	2018-10-11 15:45:32	2018-10-11	13
9400	3	3149	2018-10-11 15:45:34	2018-10-11	13
9401	1	3150	2018-10-11 15:44:38	2018-10-11	13
9402	2	3150	2018-10-11 15:44:40	2018-10-11	13
9403	3	3150	2018-10-11 15:44:53	2018-10-11	13
9404	1	3151	2018-10-11 15:46:45	2018-10-11	13
9405	2	3151	2018-10-11 15:46:47	2018-10-11	13
9406	3	3151	2018-10-11 15:46:49	2018-10-11	13
9407	1	3152	2018-10-11 15:43:44	2018-10-11	13
9408	2	3152	2018-10-11 15:43:46	2018-10-11	13
9409	3	3152	2018-10-11 16:10:38	2018-10-11	14
9410	1	3153	2018-10-11 15:28:56	2018-10-11	13
9411	2	3153	2018-10-11 15:28:58	2018-10-11	13
9412	3	3153	2018-10-11 15:29:00	2018-10-11	13
9413	1	3154	2018-10-11 15:30:19	2018-10-11	13
9414	2	3154	2018-10-11 15:30:21	2018-10-11	13
9415	3	3154	2018-10-12 09:33:56	2018-10-12	7
9416	1	3155	2018-10-11 15:28:17	2018-10-11	13
9417	2	3155	2018-10-11 15:28:19	2018-10-11	13
9418	3	3155	2018-10-11 15:28:21	2018-10-11	13
9419	1	3156	2018-10-11 15:26:48	2018-10-11	13
9420	2	3156	2018-10-11 15:26:51	2018-10-11	13
9421	3	3156	2018-10-11 15:55:44	2018-10-11	13
9422	1	3157	2018-10-11 15:21:36	2018-10-11	13
9423	2	3157	2018-10-11 15:21:38	2018-10-11	13
9424	3	3157	2018-10-11 15:30:51	2018-10-11	13
9425	1	3158	2018-10-11 15:20:53	2018-10-11	13
9426	2	3158	2018-10-11 15:20:56	2018-10-11	13
9427	3	3158	2018-10-11 15:20:58	2018-10-11	13
9428	1	3159	2018-10-11 15:19:34	2018-10-11	13
9429	2	3159	2018-10-11 15:19:36	2018-10-11	13
9430	3	3159	2018-10-11 15:19:38	2018-10-11	13
9431	1	3160	2018-10-11 15:19:36	2018-10-11	13
9432	2	3160	2018-10-11 15:19:39	2018-10-11	13
9433	3	3160	2018-10-15 11:04:05	2018-10-15	9
9434	1	3161	2018-10-11 15:18:07	2018-10-11	13
9435	2	3161	2018-10-11 15:18:10	2018-10-11	13
9436	3	3161	2018-10-11 15:31:17	2018-10-11	13
9437	1	3162	2018-10-11 15:13:06	2018-10-11	13
9438	2	3162	2018-10-11 15:13:08	2018-10-11	13
9439	3	3162	2018-10-11 15:13:10	2018-10-11	13
9440	1	3163	2018-10-11 15:12:28	2018-10-11	13
9441	2	3163	2018-10-11 15:12:31	2018-10-11	13
9442	3	3163	2018-10-11 15:14:57	2018-10-11	13
9443	1	3164	2018-10-11 15:05:55	2018-10-11	13
9444	2	3164	2018-10-11 15:05:57	2018-10-11	13
9445	3	3164	2018-10-11 15:05:59	2018-10-11	13
9446	1	3165	2018-10-11 14:57:30	2018-10-11	12
9447	2	3165	2018-10-11 14:57:32	2018-10-11	12
9448	3	3165	2018-10-11 14:57:34	2018-10-11	12
9449	1	3166	2018-10-11 14:55:50	2018-10-11	12
9450	2	3166	2018-10-11 14:55:52	2018-10-11	12
9451	3	3166	2018-10-11 14:55:54	2018-10-11	12
9452	1	3167	2018-10-11 14:48:13	2018-10-11	12
9453	2	3167	2018-10-11 14:48:15	2018-10-11	12
9454	3	3167	2018-10-11 14:48:17	2018-10-11	12
9455	1	3168	2018-10-11 14:45:57	2018-10-11	12
9456	2	3168	2018-10-11 14:45:59	2018-10-11	12
9457	3	3168	2018-10-11 15:09:04	2018-10-11	13
9458	1	3169	2018-10-11 14:36:57	2018-10-11	12
9459	2	3169	2018-10-11 14:36:59	2018-10-11	12
9460	3	3169	2018-10-11 14:37:00	2018-10-11	12
9461	1	3170	2018-10-11 14:35:16	2018-10-11	12
9462	2	3170	2018-10-11 14:35:17	2018-10-11	12
9463	3	3170	2018-10-15 11:02:35	2018-10-15	9
9464	1	3171	2018-10-11 14:29:56	2018-10-11	12
9465	2	3171	2018-10-11 14:29:59	2018-10-11	12
9466	3	3171	2018-10-11 15:57:06	2018-10-11	13
9467	1	3172	2018-10-11 14:27:59	2018-10-11	12
9468	2	3172	2018-10-11 14:28:02	2018-10-11	12
9469	3	3172	2018-10-11 14:28:05	2018-10-11	12
9470	1	3173	2018-10-11 14:22:24	2018-10-11	12
9471	2	3173	2018-10-11 14:22:26	2018-10-11	12
9472	3	3173	2018-10-11 14:22:28	2018-10-11	12
9473	1	3174	2018-10-11 14:25:40	2018-10-11	12
9474	2	3174	2018-10-11 14:25:41	2018-10-11	12
9475	3	3174	2018-10-11 15:10:33	2018-10-11	13
9476	1	3175	2018-10-11 14:16:26	2018-10-11	12
9477	2	3175	2018-10-11 14:16:28	2018-10-11	12
9478	3	3175	2018-10-11 14:16:30	2018-10-11	12
9479	1	3176	2018-10-11 14:15:52	2018-10-11	12
9480	2	3176	2018-10-11 14:15:53	2018-10-11	12
9481	3	3176	2018-10-11 14:15:55	2018-10-11	12
9482	1	3177	2018-10-11 14:13:46	2018-10-11	12
9483	2	3177	2018-10-11 14:13:48	2018-10-11	12
9484	3	3177	2018-10-11 14:13:50	2018-10-11	12
9485	1	3178	2018-10-11 14:11:22	2018-10-11	12
9486	2	3178	2018-10-11 14:11:24	2018-10-11	12
9487	3	3178	2018-10-11 14:11:26	2018-10-11	12
9488	1	3179	2018-10-11 14:11:32	2018-10-11	12
9489	2	3179	2018-10-11 14:11:34	2018-10-11	12
9490	3	3179	2018-10-15 12:09:18	2018-10-15	10
9491	1	3180	2018-10-11 14:08:58	2018-10-11	12
9492	2	3180	2018-10-11 14:09:00	2018-10-11	12
9493	1	3181	2018-10-11 14:05:08	2018-10-11	12
9494	2	3181	2018-10-11 14:05:10	2018-10-11	12
9495	3	3181	2018-10-11 14:05:12	2018-10-11	12
9496	1	3182	2018-10-11 14:05:13	2018-10-11	12
9497	2	3182	2018-10-11 14:05:15	2018-10-11	12
9498	3	3182	2018-10-11 14:05:17	2018-10-11	12
9499	1	3183	2018-10-11 12:34:22	2018-10-11	10
9500	2	3183	2018-10-11 12:34:24	2018-10-11	10
9501	3	3183	2018-10-11 14:09:16	2018-10-11	12
9502	1	3184	2018-10-11 12:29:12	2018-10-11	10
9503	2	3184	2018-10-11 12:29:14	2018-10-11	10
9504	3	3184	2018-10-11 13:36:32	2018-10-11	11
9505	1	3185	2018-10-11 12:27:52	2018-10-11	10
9506	2	3185	2018-10-11 12:27:54	2018-10-11	10
9507	3	3185	2018-10-11 14:07:39	2018-10-11	12
9508	1	3186	2018-10-11 12:22:12	2018-10-11	10
9509	2	3186	2018-10-11 12:22:15	2018-10-11	10
9510	3	3186	2018-10-11 15:51:53	2018-10-11	13
9511	1	3187	2018-10-11 12:19:01	2018-10-11	10
9512	2	3187	2018-10-11 12:19:03	2018-10-11	10
9513	3	3187	2018-10-11 14:04:21	2018-10-11	12
9514	1	3188	2018-10-11 12:09:42	2018-10-11	10
9515	2	3188	2018-10-11 12:09:44	2018-10-11	10
9516	3	3188	2018-10-11 12:09:46	2018-10-11	10
9517	1	3189	2018-10-11 11:55:47	2018-10-11	9
9518	2	3189	2018-10-11 11:55:49	2018-10-11	9
9519	3	3189	2018-10-11 12:07:14	2018-10-11	10
9520	1	3190	2018-10-11 11:47:27	2018-10-11	9
9521	2	3190	2018-10-11 11:47:29	2018-10-11	9
9522	3	3190	2018-10-11 11:47:31	2018-10-11	9
9523	1	3191	2018-10-11 11:42:54	2018-10-11	9
9524	2	3191	2018-10-11 11:42:56	2018-10-11	9
9525	3	3191	2018-10-11 13:39:25	2018-10-11	11
9526	1	3192	2018-10-11 11:40:22	2018-10-11	9
9527	2	3192	2018-10-11 11:40:24	2018-10-11	9
9528	3	3192	2018-10-11 11:40:26	2018-10-11	9
9529	1	3193	2018-10-11 11:43:20	2018-10-11	9
9530	2	3193	2018-10-11 11:43:24	2018-10-11	9
9531	3	3193	2018-10-15 10:07:46	2018-10-15	8
9532	1	3194	2018-10-11 11:40:39	2018-10-11	9
9533	2	3194	2018-10-11 11:40:41	2018-10-11	9
9534	3	3194	2018-10-11 14:49:16	2018-10-11	12
9535	1	3195	2018-10-11 11:36:16	2018-10-11	9
9536	2	3195	2018-10-11 11:36:18	2018-10-11	9
9537	3	3195	2018-10-12 11:38:39	2018-10-12	9
9538	1	3196	2018-10-11 11:31:56	2018-10-11	9
9539	2	3196	2018-10-11 11:31:57	2018-10-11	9
9540	3	3196	2018-10-11 11:40:16	2018-10-11	9
9541	1	3197	2018-10-11 11:26:00	2018-10-11	9
9542	2	3197	2018-10-11 11:26:01	2018-10-11	9
9543	3	3197	2018-10-11 11:26:03	2018-10-11	9
9544	1	3198	2018-10-11 11:24:10	2018-10-11	9
9545	2	3198	2018-10-11 11:24:12	2018-10-11	9
9546	3	3198	2018-10-11 11:24:14	2018-10-11	9
9547	1	3199	2018-10-11 11:23:31	2018-10-11	9
9548	2	3199	2018-10-11 11:23:33	2018-10-11	9
9549	3	3199	2018-10-11 11:23:35	2018-10-11	9
9550	1	3200	2018-10-11 11:19:54	2018-10-11	9
9551	2	3200	2018-10-11 11:19:56	2018-10-11	9
9552	3	3200	2018-10-11 11:19:58	2018-10-11	9
9553	1	3201	2018-10-11 11:21:15	2018-10-11	9
9554	2	3201	2018-10-11 11:21:17	2018-10-11	9
9555	3	3201	2018-10-11 13:41:51	2018-10-11	11
9556	1	3202	2018-10-11 11:29:12	2018-10-11	9
9557	2	3202	2018-10-11 11:29:14	2018-10-11	9
9558	3	3202	2018-10-11 12:05:50	2018-10-11	10
9559	1	3203	2018-10-11 11:14:37	2018-10-11	9
9560	2	3203	2018-10-11 11:14:40	2018-10-11	9
9561	3	3203	2018-10-11 11:26:57	2018-10-11	9
9562	1	3204	2018-10-11 11:00:36	2018-10-11	9
9563	2	3204	2018-10-11 11:00:37	2018-10-11	9
9564	3	3204	2018-10-11 11:00:40	2018-10-11	9
9565	1	3205	2018-10-11 11:00:09	2018-10-11	9
9566	2	3205	2018-10-11 11:00:11	2018-10-11	9
9567	3	3205	2018-10-11 11:06:43	2018-10-11	9
9568	1	3206	2018-10-11 10:53:09	2018-10-11	8
9569	2	3206	2018-10-11 10:53:11	2018-10-11	8
9570	3	3206	2018-10-11 10:53:13	2018-10-11	8
9571	1	3207	2018-10-11 10:59:26	2018-10-11	8
9572	2	3207	2018-10-11 10:59:28	2018-10-11	8
9573	3	3207	2018-10-11 14:26:53	2018-10-11	12
9574	1	3208	2018-10-11 10:51:58	2018-10-11	8
9575	2	3208	2018-10-11 10:52:00	2018-10-11	8
9576	3	3208	2018-10-11 10:52:02	2018-10-11	8
9577	1	3209	2018-10-11 10:50:58	2018-10-11	8
9578	2	3209	2018-10-11 10:51:00	2018-10-11	8
9579	3	3209	2018-10-11 10:51:09	2018-10-11	8
9580	1	3210	2018-10-11 10:50:45	2018-10-11	8
9581	2	3210	2018-10-11 10:50:47	2018-10-11	8
9582	3	3210	2018-10-11 10:50:49	2018-10-11	8
9583	1	3211	2018-10-11 10:50:30	2018-10-11	8
9584	2	3211	2018-10-11 10:50:32	2018-10-11	8
9585	3	3211	2018-10-12 11:30:04	2018-10-12	9
9586	1	3212	2018-10-11 10:38:19	2018-10-11	8
9587	2	3212	2018-10-11 10:38:20	2018-10-11	8
9588	3	3212	2018-10-15 10:57:30	2018-10-15	8
9589	1	3213	2018-10-11 10:35:30	2018-10-11	8
9590	2	3213	2018-10-11 10:35:33	2018-10-11	8
9591	3	3213	2018-10-11 10:35:36	2018-10-11	8
9592	1	3214	2018-10-11 10:34:39	2018-10-11	8
9593	2	3214	2018-10-11 10:34:41	2018-10-11	8
9594	3	3214	2018-10-11 10:34:42	2018-10-11	8
9595	1	3215	2018-10-11 10:36:37	2018-10-11	8
9596	2	3215	2018-10-11 10:36:38	2018-10-11	8
9597	3	3215	2018-10-11 10:36:40	2018-10-11	8
9598	1	3216	2018-10-11 10:32:13	2018-10-11	8
9599	2	3216	2018-10-11 10:32:15	2018-10-11	8
9600	3	3216	2018-10-11 11:10:12	2018-10-11	9
9601	1	3217	2018-10-11 10:33:15	2018-10-11	8
9602	2	3217	2018-10-11 10:33:18	2018-10-11	8
9603	3	3217	2018-10-11 10:33:21	2018-10-11	8
9604	1	3218	2018-10-11 10:30:20	2018-10-11	8
9605	2	3218	2018-10-11 10:30:21	2018-10-11	8
9606	3	3218	2018-10-11 10:30:23	2018-10-11	8
9607	1	3219	2018-10-11 10:26:53	2018-10-11	8
9608	2	3219	2018-10-11 10:26:55	2018-10-11	8
9609	3	3219	2018-10-11 10:26:57	2018-10-11	8
9610	1	3220	2018-10-11 10:28:52	2018-10-11	8
9611	2	3220	2018-10-11 10:28:55	2018-10-11	8
9612	3	3220	2018-10-11 11:17:48	2018-10-11	9
9613	1	3221	2018-10-11 10:25:12	2018-10-11	8
9614	2	3221	2018-10-11 10:25:15	2018-10-11	8
9615	3	3221	2018-10-11 11:32:13	2018-10-11	9
9616	1	3222	2018-10-11 10:19:34	2018-10-11	8
9617	2	3222	2018-10-11 10:19:36	2018-10-11	8
9618	3	3222	2018-10-11 10:19:38	2018-10-11	8
9619	1	3223	2018-10-11 10:15:14	2018-10-11	8
9620	2	3223	2018-10-11 10:15:16	2018-10-11	8
9621	3	3223	2018-10-11 10:15:49	2018-10-11	8
9622	1	3224	2018-10-11 10:20:49	2018-10-11	8
9623	2	3224	2018-10-11 10:20:52	2018-10-11	8
9624	3	3224	2018-10-11 15:46:27	2018-10-11	13
9625	1	3225	2018-10-11 10:16:50	2018-10-11	8
9626	2	3225	2018-10-11 10:16:52	2018-10-11	8
9627	3	3225	2018-10-11 10:26:17	2018-10-11	8
9628	1	3226	2018-10-11 09:58:22	2018-10-11	7
9629	2	3226	2018-10-11 09:58:24	2018-10-11	7
9630	3	3226	2018-10-11 09:58:26	2018-10-11	7
9631	1	3227	2018-10-11 09:50:57	2018-10-11	7
9632	2	3227	2018-10-11 09:50:59	2018-10-11	7
9633	3	3227	2018-10-12 11:21:21	2018-10-12	9
9634	1	3228	2018-10-11 09:45:20	2018-10-11	7
9635	2	3228	2018-10-11 09:45:21	2018-10-11	7
9636	3	3228	2018-10-11 09:45:23	2018-10-11	7
9637	1	3229	2018-10-11 09:45:14	2018-10-11	7
9638	2	3229	2018-10-11 09:45:16	2018-10-11	7
9639	3	3229	2018-10-11 09:45:18	2018-10-11	7
9640	1	3230	2018-10-11 09:43:40	2018-10-11	7
9641	2	3230	2018-10-11 09:43:42	2018-10-11	7
9642	3	3230	2018-10-11 09:43:44	2018-10-11	7
9643	1	3231	2018-10-11 09:36:08	2018-10-11	7
9644	2	3231	2018-10-11 09:36:10	2018-10-11	7
9645	3	3231	2018-10-11 09:36:12	2018-10-11	7
9646	1	3232	2018-10-11 09:34:45	2018-10-11	7
9647	2	3232	2018-10-11 09:34:47	2018-10-11	7
9648	3	3232	2018-10-11 09:34:49	2018-10-11	7
9649	1	3233	2018-10-11 09:32:15	2018-10-11	7
9650	2	3233	2018-10-11 09:32:17	2018-10-11	7
9651	3	3233	2018-10-11 09:32:19	2018-10-11	7
9652	1	3234	2018-10-11 09:24:33	2018-10-11	7
9653	2	3234	2018-10-11 09:24:35	2018-10-11	7
9654	3	3234	2018-10-11 15:41:55	2018-10-11	13
9655	1	3235	2018-10-11 09:22:37	2018-10-11	7
9656	2	3235	2018-10-11 09:22:39	2018-10-11	7
9657	3	3235	2018-10-11 09:22:41	2018-10-11	7
9658	1	3236	2018-10-11 09:16:37	2018-10-11	7
9659	2	3236	2018-10-11 09:16:38	2018-10-11	7
9660	3	3236	2018-10-11 09:16:40	2018-10-11	7
9661	1	3237	2018-10-11 09:14:51	2018-10-11	7
9662	2	3237	2018-10-11 09:14:53	2018-10-11	7
9663	3	3237	2018-10-11 09:14:55	2018-10-11	7
9664	1	3238	2018-10-11 09:11:31	2018-10-11	7
9665	2	3238	2018-10-11 09:11:33	2018-10-11	7
9666	3	3238	2018-10-11 09:11:35	2018-10-11	7
9667	1	3239	2018-10-11 09:07:12	2018-10-11	7
9668	2	3239	2018-10-11 09:07:14	2018-10-11	7
9669	3	3239	2018-10-15 09:10:14	2018-10-15	7
9670	1	3240	2018-10-11 09:05:24	2018-10-11	7
9671	2	3240	2018-10-11 09:05:25	2018-10-11	7
9672	3	3240	2018-10-11 09:05:28	2018-10-11	7
9673	1	3241	2018-10-11 09:04:14	2018-10-11	7
9674	2	3241	2018-10-11 09:04:15	2018-10-11	7
9675	3	3241	2018-10-11 09:04:17	2018-10-11	7
9676	1	3242	2018-10-11 09:02:07	2018-10-11	7
9677	2	3242	2018-10-11 09:02:09	2018-10-11	7
9678	3	3242	2018-10-11 09:02:11	2018-10-11	7
9679	1	3243	2018-10-11 09:01:11	2018-10-11	7
9680	2	3243	2018-10-11 09:01:13	2018-10-11	7
9681	3	3243	2018-10-11 09:30:07	2018-10-11	7
9682	1	3244	2018-10-11 08:56:36	2018-10-11	6
9683	2	3244	2018-10-11 08:56:38	2018-10-11	6
9684	3	3244	2018-10-11 08:56:40	2018-10-11	6
9685	1	3245	2018-10-11 09:05:34	2018-10-11	7
9686	2	3245	2018-10-11 09:05:36	2018-10-11	7
9687	3	3245	2018-10-11 09:42:25	2018-10-11	7
9688	1	3246	2018-10-11 08:52:33	2018-10-11	6
9689	2	3246	2018-10-11 08:52:35	2018-10-11	6
9690	3	3246	2018-10-15 09:32:45	2018-10-15	7
9691	1	3247	2018-10-11 08:53:19	2018-10-11	6
9692	2	3247	2018-10-11 08:53:22	2018-10-11	6
9693	3	3247	2018-10-11 09:22:56	2018-10-11	7
9694	1	3248	2018-10-11 08:49:58	2018-10-11	6
9695	2	3248	2018-10-11 08:50:00	2018-10-11	6
9696	3	3248	2018-10-11 08:50:03	2018-10-11	6
9697	1	3249	2018-10-11 08:49:33	2018-10-11	6
9698	2	3249	2018-10-11 08:49:35	2018-10-11	6
9699	3	3249	2018-10-11 09:05:31	2018-10-11	7
9700	1	3250	2018-10-11 08:44:22	2018-10-11	6
9701	2	3250	2018-10-11 08:44:24	2018-10-11	6
9702	3	3250	2018-10-11 08:44:26	2018-10-11	6
9703	1	3251	2018-10-11 08:42:18	2018-10-11	6
9704	2	3251	2018-10-11 08:42:20	2018-10-11	6
9705	3	3251	2018-10-11 08:42:22	2018-10-11	6
9706	1	3252	2018-10-11 08:34:12	2018-10-11	6
9707	2	3252	2018-10-11 08:34:14	2018-10-11	6
9708	3	3252	2018-10-11 08:34:16	2018-10-11	6
9709	1	3253	2018-10-11 07:47:45	2018-10-11	5
9710	2	3253	2018-10-11 07:47:48	2018-10-11	5
9711	3	3253	2018-10-11 09:45:34	2018-10-11	7
9712	1	3254	2018-10-11 07:40:40	2018-10-11	5
9713	2	3254	2018-10-11 07:40:42	2018-10-11	5
9714	3	3254	2018-10-11 07:42:55	2018-10-11	5
9715	1	3255	2018-10-10 16:57:52	2018-10-10	14
9716	2	3255	2018-10-10 16:57:53	2018-10-10	14
9717	3	3255	2018-10-10 16:57:55	2018-10-10	14
9718	1	3256	2018-10-10 16:53:03	2018-10-10	14
9719	2	3256	2018-10-10 16:53:05	2018-10-10	14
9720	3	3256	2018-10-11 15:43:15	2018-10-11	13
9721	1	3257	2018-10-10 16:47:11	2018-10-10	14
9722	2	3257	2018-10-10 16:47:13	2018-10-10	14
9723	3	3257	2018-10-10 16:47:16	2018-10-10	14
9724	1	3258	2018-10-10 16:45:25	2018-10-10	14
9725	2	3258	2018-10-10 16:45:29	2018-10-10	14
9726	3	3258	2018-10-10 16:45:31	2018-10-10	14
9727	1	3259	2018-10-10 16:40:11	2018-10-10	14
9728	2	3259	2018-10-10 16:40:13	2018-10-10	14
9729	3	3259	2018-10-10 16:40:15	2018-10-10	14
9730	1	3260	2018-10-10 16:33:17	2018-10-10	14
9731	2	3260	2018-10-10 16:33:19	2018-10-10	14
9732	3	3260	2018-10-10 16:33:21	2018-10-10	14
9733	1	3261	2018-10-10 16:28:45	2018-10-10	14
9734	2	3261	2018-10-10 16:28:47	2018-10-10	14
9735	3	3261	2018-10-10 16:28:48	2018-10-10	14
9736	1	3262	2018-10-10 16:27:36	2018-10-10	14
9737	2	3262	2018-10-10 16:27:38	2018-10-10	14
9738	3	3262	2018-10-10 16:27:39	2018-10-10	14
9739	1	3263	2018-10-10 16:27:47	2018-10-10	14
9740	2	3263	2018-10-10 16:27:48	2018-10-10	14
9741	3	3263	2018-10-10 16:27:56	2018-10-10	14
9742	1	3264	2018-10-10 16:23:28	2018-10-10	14
9743	2	3264	2018-10-10 16:23:30	2018-10-10	14
9744	3	3264	2018-10-10 16:23:31	2018-10-10	14
9745	1	3265	2018-10-10 16:17:28	2018-10-10	14
9746	2	3265	2018-10-10 16:17:31	2018-10-10	14
9747	3	3265	2018-10-10 16:17:33	2018-10-10	14
9748	1	3266	2018-10-10 16:17:53	2018-10-10	14
9749	2	3266	2018-10-10 16:17:56	2018-10-10	14
9750	3	3266	2018-10-10 16:17:59	2018-10-10	14
9751	1	3267	2018-10-10 16:18:00	2018-10-10	14
9752	2	3267	2018-10-10 16:18:02	2018-10-10	14
9753	3	3267	2018-10-11 15:38:05	2018-10-11	13
9754	1	3268	2018-10-10 16:13:25	2018-10-10	14
9755	2	3268	2018-10-10 16:13:27	2018-10-10	14
9756	3	3268	2018-10-11 08:23:42	2018-10-11	6
9757	1	3269	2018-10-10 15:59:05	2018-10-10	13
9758	2	3269	2018-10-10 15:59:07	2018-10-10	13
9759	3	3269	2018-10-10 15:59:08	2018-10-10	13
9760	1	3270	2018-10-10 15:58:57	2018-10-10	13
9761	2	3270	2018-10-10 15:59:00	2018-10-10	13
9762	3	3270	2018-10-10 15:59:03	2018-10-10	13
9763	1	3271	2018-10-10 15:54:00	2018-10-10	13
9764	2	3271	2018-10-10 15:54:03	2018-10-10	13
9765	3	3271	2018-10-10 15:54:04	2018-10-10	13
9766	1	3272	2018-10-10 15:50:39	2018-10-10	13
9767	2	3272	2018-10-10 15:50:40	2018-10-10	13
9768	3	3272	2018-10-10 15:50:43	2018-10-10	13
9769	1	3273	2018-10-10 15:49:22	2018-10-10	13
9770	2	3273	2018-10-10 15:49:23	2018-10-10	13
9771	3	3273	2018-10-10 15:49:25	2018-10-10	13
9772	1	3274	2018-10-10 15:43:29	2018-10-10	13
9773	2	3274	2018-10-10 15:43:32	2018-10-10	13
9774	3	3274	2018-10-10 16:01:01	2018-10-10	14
9775	1	3275	2018-10-10 15:33:55	2018-10-10	13
9776	2	3275	2018-10-10 15:33:57	2018-10-10	13
9777	3	3275	2018-10-10 15:33:59	2018-10-10	13
9778	1	3276	2018-10-10 15:33:57	2018-10-10	13
9779	2	3276	2018-10-10 15:33:59	2018-10-10	13
9780	3	3276	2018-10-10 15:34:01	2018-10-10	13
9781	1	3277	2018-10-10 15:31:19	2018-10-10	13
9782	2	3277	2018-10-10 15:31:21	2018-10-10	13
9783	3	3277	2018-10-10 15:31:22	2018-10-10	13
9784	1	3278	2018-10-10 15:30:05	2018-10-10	13
9785	2	3278	2018-10-10 15:30:07	2018-10-10	13
9786	3	3278	2018-10-10 15:30:09	2018-10-10	13
9787	1	3279	2018-10-10 15:24:06	2018-10-10	13
9788	2	3279	2018-10-10 15:24:08	2018-10-10	13
9789	3	3279	2018-10-11 08:52:19	2018-10-11	6
9790	1	3280	2018-10-10 15:20:00	2018-10-10	13
9791	2	3280	2018-10-10 15:20:02	2018-10-10	13
9792	3	3280	2018-10-10 15:20:04	2018-10-10	13
9793	1	3281	2018-10-10 15:16:12	2018-10-10	13
9794	2	3281	2018-10-10 15:16:13	2018-10-10	13
9795	3	3281	2018-10-10 15:16:15	2018-10-10	13
9796	1	3282	2018-10-10 15:09:56	2018-10-10	13
9797	2	3282	2018-10-10 15:09:58	2018-10-10	13
9798	3	3282	2018-10-10 15:09:59	2018-10-10	13
9799	1	3283	2018-10-10 15:09:34	2018-10-10	13
9800	2	3283	2018-10-10 15:09:38	2018-10-10	13
9801	3	3283	2018-10-11 08:24:50	2018-10-11	6
9802	1	3284	2018-10-10 15:07:09	2018-10-10	13
9803	2	3284	2018-10-10 15:07:11	2018-10-10	13
9804	3	3284	2018-10-10 15:07:13	2018-10-10	13
9805	1	3285	2018-10-10 14:58:23	2018-10-10	12
9806	2	3285	2018-10-10 14:58:25	2018-10-10	12
9807	3	3285	2018-10-10 14:58:26	2018-10-10	12
9808	1	3286	2018-10-10 14:55:37	2018-10-10	12
9809	2	3286	2018-10-10 14:55:39	2018-10-10	12
9810	3	3286	2018-10-10 14:55:41	2018-10-10	12
9811	1	3287	2018-10-10 14:54:23	2018-10-10	12
9812	2	3287	2018-10-10 14:54:24	2018-10-10	12
9813	3	3287	2018-10-10 14:54:26	2018-10-10	12
9814	1	3288	2018-10-10 14:48:00	2018-10-10	12
9815	2	3288	2018-10-10 14:48:02	2018-10-10	12
9816	3	3288	2018-10-10 14:48:04	2018-10-10	12
9817	1	3289	2018-10-10 14:51:32	2018-10-10	12
9818	2	3289	2018-10-10 14:51:34	2018-10-10	12
9819	3	3289	2018-10-10 14:51:36	2018-10-10	12
9820	1	3290	2018-10-10 14:42:18	2018-10-10	12
9821	2	3290	2018-10-10 14:42:20	2018-10-10	12
9822	3	3290	2018-10-10 14:42:22	2018-10-10	12
9823	1	3291	2018-10-10 14:44:09	2018-10-10	12
9824	2	3291	2018-10-10 14:44:11	2018-10-10	12
9825	3	3291	2018-10-11 08:00:04	2018-10-11	6
9826	1	3292	2018-10-10 14:45:03	2018-10-10	12
9827	2	3292	2018-10-10 14:45:05	2018-10-10	12
9828	3	3292	2018-10-10 14:45:07	2018-10-10	12
9829	1	3293	2018-10-10 14:35:16	2018-10-10	12
9830	2	3293	2018-10-10 14:35:18	2018-10-10	12
9831	3	3293	2018-10-10 14:35:20	2018-10-10	12
9832	1	3294	2018-10-10 14:34:33	2018-10-10	12
9833	2	3294	2018-10-10 14:34:35	2018-10-10	12
9834	3	3294	2018-10-11 15:18:36	2018-10-11	13
9835	1	3295	2018-10-10 14:35:04	2018-10-10	12
9836	2	3295	2018-10-10 14:35:06	2018-10-10	12
9837	3	3295	2018-10-11 15:36:02	2018-10-11	13
9838	1	3296	2018-10-10 14:28:47	2018-10-10	12
9839	2	3296	2018-10-10 14:28:49	2018-10-10	12
9840	3	3296	2018-10-10 14:28:51	2018-10-10	12
9841	1	3297	2018-10-10 14:27:32	2018-10-10	12
9842	2	3297	2018-10-10 14:27:33	2018-10-10	12
9843	3	3297	2018-10-10 14:27:36	2018-10-10	12
9844	1	3298	2018-10-10 14:26:46	2018-10-10	12
9845	2	3298	2018-10-10 14:26:48	2018-10-10	12
9846	3	3298	2018-10-10 14:26:49	2018-10-10	12
9847	1	3299	2018-10-10 14:24:56	2018-10-10	12
9848	2	3299	2018-10-10 14:24:58	2018-10-10	12
9849	3	3299	2018-10-10 14:25:00	2018-10-10	12
9850	1	3300	2018-10-10 14:22:12	2018-10-10	12
9851	2	3300	2018-10-10 14:22:14	2018-10-10	12
9852	3	3300	2018-10-10 14:22:16	2018-10-10	12
9853	1	3301	2018-10-10 14:21:30	2018-10-10	12
9854	2	3301	2018-10-10 14:21:33	2018-10-10	12
9855	3	3301	2018-10-10 14:21:35	2018-10-10	12
9856	1	3302	2018-10-10 14:25:26	2018-10-10	12
9857	2	3302	2018-10-10 14:25:27	2018-10-10	12
9858	3	3302	2018-10-12 11:24:04	2018-10-12	9
9859	1	3303	2018-10-10 14:20:30	2018-10-10	12
9860	2	3303	2018-10-10 14:20:32	2018-10-10	12
9861	3	3303	2018-10-10 14:20:34	2018-10-10	12
9862	1	3304	2018-10-10 14:19:25	2018-10-10	12
9863	2	3304	2018-10-10 14:19:27	2018-10-10	12
9864	3	3304	2018-10-10 14:19:29	2018-10-10	12
9865	1	3305	2018-10-10 14:19:33	2018-10-10	12
9866	2	3305	2018-10-10 14:19:35	2018-10-10	12
9867	3	3305	2018-10-10 14:19:37	2018-10-10	12
9868	1	3306	2018-10-10 14:14:43	2018-10-10	12
9869	2	3306	2018-10-10 14:14:45	2018-10-10	12
9870	3	3306	2018-10-10 14:14:47	2018-10-10	12
9871	1	3307	2018-10-10 14:16:16	2018-10-10	12
9872	2	3307	2018-10-10 14:16:19	2018-10-10	12
9873	3	3307	2018-10-11 15:14:15	2018-10-11	13
9874	1	3308	2018-10-10 14:08:07	2018-10-10	12
9875	2	3308	2018-10-10 14:08:10	2018-10-10	12
9876	3	3308	2018-10-10 14:08:12	2018-10-10	12
9877	1	3309	2018-10-10 14:06:19	2018-10-10	12
9878	2	3309	2018-10-10 14:06:21	2018-10-10	12
9879	3	3309	2018-10-10 14:06:23	2018-10-10	12
9880	1	3310	2018-10-10 14:04:32	2018-10-10	12
9881	2	3310	2018-10-10 14:04:33	2018-10-10	12
9882	3	3310	2018-10-10 14:04:35	2018-10-10	12
9883	1	3311	2018-10-10 14:03:19	2018-10-10	12
9884	2	3311	2018-10-10 14:03:21	2018-10-10	12
9885	3	3311	2018-10-10 14:03:22	2018-10-10	12
9886	1	3312	2018-10-10 13:31:27	2018-10-10	11
9887	2	3312	2018-10-10 13:31:29	2018-10-10	11
9888	3	3312	2018-10-11 09:42:58	2018-10-11	7
9889	1	3313	2018-10-10 11:57:30	2018-10-10	9
9890	2	3313	2018-10-10 11:57:33	2018-10-10	9
9891	1	3314	2018-10-10 11:53:21	2018-10-10	9
9892	2	3314	2018-10-10 11:53:23	2018-10-10	9
9893	3	3314	2018-10-10 11:53:25	2018-10-10	9
9894	1	3315	2018-10-10 11:50:00	2018-10-10	9
9895	2	3315	2018-10-10 11:50:02	2018-10-10	9
9896	3	3315	2018-10-11 09:15:18	2018-10-11	7
9897	1	3316	2018-10-10 11:44:40	2018-10-10	9
9898	2	3316	2018-10-10 11:44:42	2018-10-10	9
9899	3	3316	2018-10-10 11:44:44	2018-10-10	9
9900	1	3317	2018-10-10 11:30:52	2018-10-10	9
9901	2	3317	2018-10-10 11:30:55	2018-10-10	9
9902	3	3317	2018-10-10 11:30:57	2018-10-10	9
9903	1	3318	2018-10-10 11:31:26	2018-10-10	9
9904	2	3318	2018-10-10 11:31:27	2018-10-10	9
9905	3	3318	2018-10-11 15:10:39	2018-10-11	13
9906	1	3319	2018-10-10 11:23:43	2018-10-10	9
9907	2	3319	2018-10-10 11:23:45	2018-10-10	9
9908	3	3319	2018-10-10 11:23:47	2018-10-10	9
9909	1	3320	2018-10-10 11:21:27	2018-10-10	9
9910	2	3320	2018-10-10 11:21:29	2018-10-10	9
9911	3	3320	2018-10-11 11:08:57	2018-10-11	9
9912	1	3321	2018-10-10 11:16:02	2018-10-10	9
9913	2	3321	2018-10-10 11:16:04	2018-10-10	9
9914	1	3322	2018-10-10 11:13:03	2018-10-10	9
9915	2	3322	2018-10-10 11:13:05	2018-10-10	9
9916	3	3322	2018-10-11 09:49:43	2018-10-11	7
9917	1	3323	2018-10-10 11:08:08	2018-10-10	9
9918	2	3323	2018-10-10 11:08:11	2018-10-10	9
9919	3	3323	2018-10-10 11:51:23	2018-10-10	9
9920	1	3324	2018-10-10 11:05:09	2018-10-10	9
9921	2	3324	2018-10-10 11:05:11	2018-10-10	9
9922	3	3324	2018-10-10 11:05:14	2018-10-10	9
9923	1	3325	2018-10-10 11:03:50	2018-10-10	9
9924	2	3325	2018-10-10 11:03:52	2018-10-10	9
9925	3	3325	2018-10-10 11:03:54	2018-10-10	9
9926	1	3326	2018-10-10 11:02:55	2018-10-10	9
9927	2	3326	2018-10-10 11:02:57	2018-10-10	9
9928	3	3326	2018-10-10 11:02:59	2018-10-10	9
9929	1	3327	2018-10-10 11:04:49	2018-10-10	9
9930	2	3327	2018-10-10 11:04:51	2018-10-10	9
9931	3	3327	2018-10-11 15:08:34	2018-10-11	13
9932	1	3328	2018-10-10 11:01:50	2018-10-10	9
9933	2	3328	2018-10-10 11:01:52	2018-10-10	9
9934	3	3328	2018-10-10 11:01:54	2018-10-10	9
9935	1	3329	2018-10-10 11:02:47	2018-10-10	9
9936	2	3329	2018-10-10 11:02:49	2018-10-10	9
9937	3	3329	2018-10-11 15:06:34	2018-10-11	13
9938	1	3330	2018-10-10 11:00:52	2018-10-10	9
9939	2	3330	2018-10-10 11:00:53	2018-10-10	9
9940	3	3330	2018-10-10 11:00:55	2018-10-10	9
9941	1	3331	2018-10-10 11:00:15	2018-10-10	9
9942	2	3331	2018-10-10 11:00:17	2018-10-10	9
9943	3	3331	2018-10-10 11:00:19	2018-10-10	9
9944	1	3332	2018-10-10 11:00:39	2018-10-10	9
9945	2	3332	2018-10-10 11:00:42	2018-10-10	9
9946	3	3332	2018-10-10 11:34:59	2018-10-10	9
9947	1	3333	2018-10-10 10:57:53	2018-10-10	8
9948	2	3333	2018-10-10 10:57:55	2018-10-10	8
9949	3	3333	2018-10-10 10:57:57	2018-10-10	8
9950	1	3334	2018-10-10 10:55:27	2018-10-10	8
9951	2	3334	2018-10-10 10:55:29	2018-10-10	8
9952	3	3334	2018-10-10 10:55:31	2018-10-10	8
9953	1	3335	2018-10-10 10:55:43	2018-10-10	8
9954	2	3335	2018-10-10 10:55:45	2018-10-10	8
9955	3	3335	2018-10-10 10:55:47	2018-10-10	8
9956	1	3336	2018-10-10 10:46:01	2018-10-10	8
9957	2	3336	2018-10-10 10:46:03	2018-10-10	8
9958	3	3336	2018-10-10 10:46:05	2018-10-10	8
9959	1	3337	2018-10-10 10:45:31	2018-10-10	8
9960	2	3337	2018-10-10 10:45:33	2018-10-10	8
9961	3	3337	2018-10-10 10:45:35	2018-10-10	8
9962	1	3338	2018-10-10 10:43:01	2018-10-10	8
9963	2	3338	2018-10-10 10:43:03	2018-10-10	8
9964	3	3338	2018-10-11 15:00:16	2018-10-11	13
9965	1	3339	2018-10-10 10:39:23	2018-10-10	8
9966	2	3339	2018-10-10 10:39:25	2018-10-10	8
9967	3	3339	2018-10-11 09:19:42	2018-10-11	7
9968	1	3340	2018-10-10 10:37:01	2018-10-10	8
9969	2	3340	2018-10-10 10:37:03	2018-10-10	8
9970	3	3340	2018-10-10 12:02:52	2018-10-10	10
9971	1	3341	2018-10-10 10:35:25	2018-10-10	8
9972	2	3341	2018-10-10 10:35:28	2018-10-10	8
9973	3	3341	2018-10-12 11:31:06	2018-10-12	9
9974	1	3342	2018-10-10 10:34:37	2018-10-10	8
9975	2	3342	2018-10-10 10:34:39	2018-10-10	8
9976	3	3342	2018-10-12 11:34:36	2018-10-12	9
9977	1	3343	2018-10-10 10:30:25	2018-10-10	8
9978	2	3343	2018-10-10 10:30:27	2018-10-10	8
9979	3	3343	2018-10-10 10:30:30	2018-10-10	8
9980	1	3344	2018-10-10 10:29:15	2018-10-10	8
9981	2	3344	2018-10-10 10:29:17	2018-10-10	8
9982	3	3344	2018-10-10 10:29:19	2018-10-10	8
9983	1	3345	2018-10-10 10:22:58	2018-10-10	8
9984	2	3345	2018-10-10 10:22:59	2018-10-10	8
9985	3	3345	2018-10-10 10:23:01	2018-10-10	8
9986	1	3346	2018-10-10 10:23:35	2018-10-10	8
9987	2	3346	2018-10-10 10:23:37	2018-10-10	8
9988	3	3346	2018-10-10 10:53:54	2018-10-10	8
9989	1	3347	2018-10-10 10:19:00	2018-10-10	8
9990	2	3347	2018-10-10 10:19:02	2018-10-10	8
9991	3	3347	2018-10-10 10:19:04	2018-10-10	8
9992	1	3348	2018-10-10 10:18:04	2018-10-10	8
9993	2	3348	2018-10-10 10:18:06	2018-10-10	8
9994	3	3348	2018-10-11 09:32:59	2018-10-11	7
9995	1	3349	2018-10-10 10:17:58	2018-10-10	8
9996	2	3349	2018-10-10 10:18:01	2018-10-10	8
9997	1	3350	2018-10-10 10:12:28	2018-10-10	8
9998	2	3350	2018-10-10 10:12:31	2018-10-10	8
9999	3	3350	2018-10-10 10:12:34	2018-10-10	8
10000	1	3351	2018-10-10 10:11:01	2018-10-10	8
10001	2	3351	2018-10-10 10:11:03	2018-10-10	8
10002	3	3351	2018-10-10 10:42:17	2018-10-10	8
10003	1	3352	2018-10-10 10:07:40	2018-10-10	8
10004	2	3352	2018-10-10 10:07:44	2018-10-10	8
10005	1	3353	2018-10-10 10:04:24	2018-10-10	8
10006	2	3353	2018-10-10 10:04:27	2018-10-10	8
10007	3	3353	2018-10-10 10:04:29	2018-10-10	8
10008	1	3354	2018-10-10 10:03:34	2018-10-10	8
10009	2	3354	2018-10-10 10:03:35	2018-10-10	8
10010	3	3354	2018-10-10 10:03:38	2018-10-10	8
10011	1	3355	2018-10-10 10:00:58	2018-10-10	8
10012	2	3355	2018-10-10 10:01:00	2018-10-10	8
10013	3	3355	2018-10-10 10:01:01	2018-10-10	8
10014	1	3356	2018-10-10 10:00:05	2018-10-10	8
10015	2	3356	2018-10-10 10:00:07	2018-10-10	8
10016	3	3356	2018-10-10 10:00:09	2018-10-10	8
10017	1	3357	2018-10-10 09:57:48	2018-10-10	7
10018	2	3357	2018-10-10 09:57:49	2018-10-10	7
10019	3	3357	2018-10-10 09:57:51	2018-10-10	7
10020	1	3358	2018-10-10 09:48:25	2018-10-10	7
10021	2	3358	2018-10-10 09:48:27	2018-10-10	7
10022	3	3358	2018-10-10 09:48:29	2018-10-10	7
10023	1	3359	2018-10-10 09:48:58	2018-10-10	7
10024	2	3359	2018-10-10 09:49:01	2018-10-10	7
10025	3	3359	2018-10-10 09:49:04	2018-10-10	7
10026	1	3360	2018-10-10 09:46:11	2018-10-10	7
10027	2	3360	2018-10-10 09:46:13	2018-10-10	7
10028	3	3360	2018-10-10 09:46:15	2018-10-10	7
10029	1	3361	2018-10-10 09:42:09	2018-10-10	7
10030	2	3361	2018-10-10 09:42:12	2018-10-10	7
10031	3	3361	2018-10-10 09:42:14	2018-10-10	7
10032	1	3362	2018-10-10 09:45:02	2018-10-10	7
10033	2	3362	2018-10-10 09:45:06	2018-10-10	7
10034	3	3362	2018-10-10 09:49:05	2018-10-10	7
10035	1	3363	2018-10-10 09:41:17	2018-10-10	7
10036	2	3363	2018-10-10 09:41:19	2018-10-10	7
10037	3	3363	2018-10-10 09:41:21	2018-10-10	7
10038	1	3364	2018-10-10 09:40:32	2018-10-10	7
10039	2	3364	2018-10-10 09:40:34	2018-10-10	7
10040	3	3364	2018-10-10 09:40:36	2018-10-10	7
10041	1	3365	2018-10-10 09:38:06	2018-10-10	7
10042	2	3365	2018-10-10 09:38:10	2018-10-10	7
10043	3	3365	2018-10-10 11:30:02	2018-10-10	9
10044	1	3366	2018-10-10 09:33:52	2018-10-10	7
10045	2	3366	2018-10-10 09:33:54	2018-10-10	7
10046	3	3366	2018-10-10 09:33:56	2018-10-10	7
10047	1	3367	2018-10-10 09:29:06	2018-10-10	7
10048	2	3367	2018-10-10 09:29:08	2018-10-10	7
10049	3	3367	2018-10-10 09:46:02	2018-10-10	7
10050	1	3368	2018-10-10 09:23:22	2018-10-10	7
10051	2	3368	2018-10-10 09:23:26	2018-10-10	7
10052	3	3368	2018-10-10 11:26:55	2018-10-10	9
10053	1	3369	2018-10-10 09:21:34	2018-10-10	7
10054	2	3369	2018-10-10 09:21:36	2018-10-10	7
10055	3	3369	2018-10-10 09:21:38	2018-10-10	7
10056	1	3370	2018-10-10 09:20:20	2018-10-10	7
10057	2	3370	2018-10-10 09:20:22	2018-10-10	7
10058	3	3370	2018-10-10 09:20:24	2018-10-10	7
10059	1	3371	2018-10-10 09:19:03	2018-10-10	7
10060	2	3371	2018-10-10 09:19:05	2018-10-10	7
10061	3	3371	2018-10-10 09:19:07	2018-10-10	7
10062	1	3372	2018-10-10 09:20:31	2018-10-10	7
10063	2	3372	2018-10-10 09:20:34	2018-10-10	7
10064	3	3372	2018-10-11 09:27:45	2018-10-11	7
10065	1	3373	2018-10-10 09:16:18	2018-10-10	7
10066	2	3373	2018-10-10 09:16:20	2018-10-10	7
10067	3	3373	2018-10-10 09:16:22	2018-10-10	7
10068	1	3374	2018-10-10 09:09:11	2018-10-10	7
10069	2	3374	2018-10-10 09:09:14	2018-10-10	7
10070	3	3374	2018-10-10 09:09:16	2018-10-10	7
10071	1	3375	2018-10-10 09:09:07	2018-10-10	7
10072	2	3375	2018-10-10 09:09:10	2018-10-10	7
10073	3	3375	2018-10-10 09:15:17	2018-10-10	7
10074	1	3376	2018-10-10 09:07:56	2018-10-10	7
10075	2	3376	2018-10-10 09:07:58	2018-10-10	7
10076	3	3376	2018-10-10 09:08:00	2018-10-10	7
10077	1	3377	2018-10-10 09:04:50	2018-10-10	7
10078	2	3377	2018-10-10 09:04:52	2018-10-10	7
10079	3	3377	2018-10-10 09:04:53	2018-10-10	7
10080	1	3378	2018-10-10 08:56:49	2018-10-10	6
10081	2	3378	2018-10-10 08:56:51	2018-10-10	6
10082	3	3378	2018-10-10 08:56:53	2018-10-10	6
10083	1	3379	2018-10-10 08:53:23	2018-10-10	6
10084	2	3379	2018-10-10 08:53:25	2018-10-10	6
10085	3	3379	2018-10-10 08:53:26	2018-10-10	6
10086	1	3380	2018-10-10 08:52:47	2018-10-10	6
10087	2	3380	2018-10-10 08:52:48	2018-10-10	6
10088	3	3380	2018-10-10 08:52:50	2018-10-10	6
10089	1	3381	2018-10-10 08:46:37	2018-10-10	6
10090	2	3381	2018-10-10 08:46:39	2018-10-10	6
10091	3	3381	2018-10-10 08:46:40	2018-10-10	6
10092	1	3382	2018-10-10 08:45:56	2018-10-10	6
10093	2	3382	2018-10-10 08:46:00	2018-10-10	6
10094	3	3382	2018-10-10 08:55:44	2018-10-10	6
10095	1	3383	2018-10-10 08:42:34	2018-10-10	6
10096	2	3383	2018-10-10 08:42:36	2018-10-10	6
10097	3	3383	2018-10-10 08:42:38	2018-10-10	6
10098	1	3384	2018-10-10 08:37:32	2018-10-10	6
10099	2	3384	2018-10-10 08:37:34	2018-10-10	6
10100	3	3384	2018-10-12 11:22:45	2018-10-12	9
10101	1	3385	2018-10-10 08:36:37	2018-10-10	6
10102	2	3385	2018-10-10 08:36:40	2018-10-10	6
10103	3	3385	2018-10-10 10:09:05	2018-10-10	8
10104	1	3386	2018-10-10 08:28:41	2018-10-10	6
10105	2	3386	2018-10-10 08:28:43	2018-10-10	6
10106	3	3386	2018-10-10 08:28:50	2018-10-10	6
10107	1	3387	2018-10-10 07:55:04	2018-10-10	5
10108	2	3387	2018-10-10 07:55:07	2018-10-10	5
10109	1	3388	2018-10-10 07:45:47	2018-10-10	5
10110	2	3388	2018-10-10 07:45:49	2018-10-10	5
10111	3	3388	2018-10-10 07:47:52	2018-10-10	5
10112	1	3389	2018-10-10 07:43:38	2018-10-10	5
10113	2	3389	2018-10-10 07:43:42	2018-10-10	5
10114	3	3389	2018-10-10 11:25:32	2018-10-10	9
10115	1	3390	2018-10-10 07:40:53	2018-10-10	5
10116	2	3390	2018-10-10 07:40:56	2018-10-10	5
10117	3	3390	2018-10-10 09:34:40	2018-10-10	7
10118	1	3391	2018-10-09 16:50:24	2018-10-09	14
10119	2	3391	2018-10-09 16:50:25	2018-10-09	14
10120	3	3391	2018-10-09 16:50:27	2018-10-09	14
10121	1	3392	2018-10-09 16:48:48	2018-10-09	14
10122	2	3392	2018-10-09 16:48:51	2018-10-09	14
10123	3	3392	2018-10-10 08:39:30	2018-10-10	6
10124	1	3393	2018-10-09 16:44:43	2018-10-09	14
10125	2	3393	2018-10-09 16:44:44	2018-10-09	14
10126	3	3393	2018-10-09 16:44:46	2018-10-09	14
10127	1	3394	2018-10-09 16:41:36	2018-10-09	14
10128	2	3394	2018-10-09 16:41:37	2018-10-09	14
10129	3	3394	2018-10-09 16:41:39	2018-10-09	14
10130	1	3395	2018-10-09 16:37:14	2018-10-09	14
10131	2	3395	2018-10-09 16:37:16	2018-10-09	14
10132	3	3395	2018-10-09 16:37:18	2018-10-09	14
10133	1	3396	2018-10-09 16:31:22	2018-10-09	14
10134	2	3396	2018-10-09 16:31:24	2018-10-09	14
10135	3	3396	2018-10-09 16:31:27	2018-10-09	14
10136	1	3397	2018-10-09 16:28:46	2018-10-09	14
10137	2	3397	2018-10-09 16:28:48	2018-10-09	14
10138	3	3397	2018-10-15 09:34:44	2018-10-15	7
10139	1	3398	2018-10-09 16:27:11	2018-10-09	14
10140	2	3398	2018-10-09 16:27:13	2018-10-09	14
10141	3	3398	2018-10-09 16:27:14	2018-10-09	14
10142	1	3399	2018-10-09 16:29:01	2018-10-09	14
10143	2	3399	2018-10-09 16:29:04	2018-10-09	14
10144	3	3399	2018-10-10 08:31:56	2018-10-10	6
10145	1	3400	2018-10-09 16:14:31	2018-10-09	14
10146	2	3400	2018-10-09 16:14:32	2018-10-09	14
10147	3	3400	2018-10-10 10:09:54	2018-10-10	8
10148	1	3401	2018-10-09 16:04:19	2018-10-09	14
10149	2	3401	2018-10-09 16:04:20	2018-10-09	14
10150	3	3401	2018-10-09 16:04:21	2018-10-09	14
10151	1	3402	2018-10-09 16:06:11	2018-10-09	14
10152	2	3402	2018-10-09 16:06:12	2018-10-09	14
10153	3	3402	2018-10-09 16:06:13	2018-10-09	14
10154	1	3403	2018-10-09 16:03:37	2018-10-09	14
10155	2	3403	2018-10-09 16:03:38	2018-10-09	14
10156	3	3403	2018-10-09 16:03:39	2018-10-09	14
10157	1	3404	2018-10-09 16:01:06	2018-10-09	14
10158	2	3404	2018-10-09 16:01:07	2018-10-09	14
10159	3	3404	2018-10-09 16:01:08	2018-10-09	14
10160	1	3405	2018-10-09 16:00:47	2018-10-09	14
10161	2	3405	2018-10-09 16:00:48	2018-10-09	14
10162	3	3405	2018-10-09 16:00:49	2018-10-09	14
10163	1	3406	2018-10-09 16:00:15	2018-10-09	14
10164	2	3406	2018-10-09 16:00:16	2018-10-09	14
10165	3	3406	2018-10-09 16:00:17	2018-10-09	14
10166	1	3407	2018-10-09 15:59:49	2018-10-09	13
10167	2	3407	2018-10-09 15:59:49	2018-10-09	13
10168	3	3407	2018-10-09 15:59:50	2018-10-09	13
10169	1	3408	2018-10-09 15:58:58	2018-10-09	13
10170	2	3408	2018-10-09 15:58:59	2018-10-09	13
10171	3	3408	2018-10-09 15:59:03	2018-10-09	13
10172	1	3409	2018-10-09 15:57:49	2018-10-09	13
10173	2	3409	2018-10-09 15:57:51	2018-10-09	13
10174	3	3409	2018-10-09 16:09:55	2018-10-09	14
10175	1	3410	2018-10-09 15:53:02	2018-10-09	13
10176	2	3410	2018-10-09 15:53:03	2018-10-09	13
10177	3	3410	2018-10-09 15:53:40	2018-10-09	13
10178	1	3411	2018-10-09 15:47:19	2018-10-09	13
10179	2	3411	2018-10-09 15:47:20	2018-10-09	13
10180	3	3411	2018-10-09 16:14:44	2018-10-09	14
10181	1	3412	2018-10-09 15:47:07	2018-10-09	13
10182	2	3412	2018-10-09 15:47:09	2018-10-09	13
10183	3	3412	2018-10-09 16:12:43	2018-10-09	14
10184	1	3413	2018-10-09 15:39:58	2018-10-09	13
10185	2	3413	2018-10-09 15:39:59	2018-10-09	13
10186	3	3413	2018-10-09 15:40:00	2018-10-09	13
10187	1	3414	2018-10-09 15:44:43	2018-10-09	13
10188	2	3414	2018-10-09 15:44:45	2018-10-09	13
10189	3	3414	2018-10-10 11:23:03	2018-10-10	9
10190	1	3415	2018-10-09 15:39:11	2018-10-09	13
10191	2	3415	2018-10-09 15:39:12	2018-10-09	13
10192	3	3415	2018-10-09 15:45:35	2018-10-09	13
10193	1	3416	2018-10-09 15:36:59	2018-10-09	13
10194	2	3416	2018-10-09 15:37:00	2018-10-09	13
10195	3	3416	2018-10-09 15:37:01	2018-10-09	13
10196	1	3417	2018-10-09 15:33:16	2018-10-09	13
10197	2	3417	2018-10-09 15:33:17	2018-10-09	13
10198	3	3417	2018-10-10 09:58:29	2018-10-10	7
10199	1	3418	2018-10-09 15:30:43	2018-10-09	13
10200	2	3418	2018-10-09 15:30:44	2018-10-09	13
10201	3	3418	2018-10-09 15:43:27	2018-10-09	13
10202	1	3419	2018-10-09 15:27:16	2018-10-09	13
10203	2	3419	2018-10-09 15:27:17	2018-10-09	13
10204	3	3419	2018-10-10 09:57:23	2018-10-10	7
10205	1	3420	2018-10-09 15:24:22	2018-10-09	13
10206	2	3420	2018-10-09 15:24:23	2018-10-09	13
10207	3	3420	2018-10-11 09:00:08	2018-10-11	7
10208	1	3421	2018-10-09 15:16:35	2018-10-09	13
10209	2	3421	2018-10-09 15:16:36	2018-10-09	13
10210	3	3421	2018-10-09 15:16:37	2018-10-09	13
10211	1	3422	2018-10-09 15:16:44	2018-10-09	13
10212	2	3422	2018-10-09 15:16:46	2018-10-09	13
10213	3	3422	2018-10-09 15:16:47	2018-10-09	13
10214	1	3423	2018-10-09 15:15:56	2018-10-09	13
10215	2	3423	2018-10-09 15:15:57	2018-10-09	13
10216	3	3423	2018-10-09 15:15:58	2018-10-09	13
10217	1	3424	2018-10-09 14:53:20	2018-10-09	12
10218	2	3424	2018-10-09 14:53:21	2018-10-09	12
10219	3	3424	2018-10-09 14:53:22	2018-10-09	12
10220	1	3425	2018-10-09 14:50:42	2018-10-09	12
10221	2	3425	2018-10-09 14:50:43	2018-10-09	12
10222	3	3425	2018-10-09 14:50:44	2018-10-09	12
10223	1	3426	2018-10-09 14:49:22	2018-10-09	12
10224	2	3426	2018-10-09 14:49:23	2018-10-09	12
10225	3	3426	2018-10-09 14:49:24	2018-10-09	12
10226	1	3427	2018-10-09 14:41:22	2018-10-09	12
10227	2	3427	2018-10-09 14:41:23	2018-10-09	12
10228	3	3427	2018-10-09 14:41:24	2018-10-09	12
10229	1	3428	2018-10-09 14:40:53	2018-10-09	12
10230	2	3428	2018-10-09 14:40:54	2018-10-09	12
10231	3	3428	2018-10-09 14:40:55	2018-10-09	12
10232	1	3429	2018-10-09 14:39:48	2018-10-09	12
10233	2	3429	2018-10-09 14:39:49	2018-10-09	12
10234	3	3429	2018-10-09 14:39:50	2018-10-09	12
10235	1	3430	2018-10-09 14:40:20	2018-10-09	12
10236	2	3430	2018-10-09 14:40:22	2018-10-09	12
10237	3	3430	2018-10-09 16:23:16	2018-10-09	14
10238	1	3431	2018-10-09 14:41:11	2018-10-09	12
10239	2	3431	2018-10-09 14:41:12	2018-10-09	12
10240	3	3431	2018-10-09 15:36:46	2018-10-09	13
10241	1	3432	2018-10-09 14:40:14	2018-10-09	12
10242	2	3432	2018-10-09 14:40:15	2018-10-09	12
10243	3	3432	2018-10-09 15:04:09	2018-10-09	13
10244	1	3433	2018-10-09 14:39:18	2018-10-09	12
10245	2	3433	2018-10-09 14:39:19	2018-10-09	12
10246	3	3433	2018-10-09 14:39:20	2018-10-09	12
10247	1	3434	2018-10-09 16:51:57	2018-10-09	14
10248	2	3434	2018-10-09 16:51:59	2018-10-09	14
10249	3	3434	2018-10-09 16:52:01	2018-10-09	14
10250	1	3435	2018-10-09 14:31:31	2018-10-09	12
10251	2	3435	2018-10-09 14:31:32	2018-10-09	12
10252	3	3435	2018-10-09 14:31:33	2018-10-09	12
10253	1	3436	2018-10-09 14:31:31	2018-10-09	12
10254	2	3436	2018-10-09 14:31:32	2018-10-09	12
10255	3	3436	2018-10-09 14:31:34	2018-10-09	12
10256	1	3437	2018-10-09 14:22:51	2018-10-09	12
10257	2	3437	2018-10-09 14:22:53	2018-10-09	12
10258	3	3437	2018-10-10 08:16:43	2018-10-10	6
10259	1	3438	2018-10-09 14:19:48	2018-10-09	12
10260	2	3438	2018-10-09 14:19:49	2018-10-09	12
10261	3	3438	2018-10-09 14:19:50	2018-10-09	12
10262	1	3439	2018-10-09 14:19:37	2018-10-09	12
10263	2	3439	2018-10-09 14:19:38	2018-10-09	12
10264	3	3439	2018-10-09 14:19:39	2018-10-09	12
10265	1	3440	2018-10-09 14:18:26	2018-10-09	12
10266	2	3440	2018-10-09 14:18:27	2018-10-09	12
10267	3	3440	2018-10-09 14:18:28	2018-10-09	12
10268	1	3441	2018-10-09 14:18:33	2018-10-09	12
10269	2	3441	2018-10-09 14:18:35	2018-10-09	12
10270	3	3441	2018-10-09 15:41:33	2018-10-09	13
10271	1	3442	2018-10-09 14:16:10	2018-10-09	12
10272	2	3442	2018-10-09 14:16:11	2018-10-09	12
10273	3	3442	2018-10-09 14:16:12	2018-10-09	12
10274	1	3443	2018-10-09 14:14:54	2018-10-09	12
10275	2	3443	2018-10-09 14:14:55	2018-10-09	12
10276	3	3443	2018-10-09 14:14:56	2018-10-09	12
10277	1	3444	2018-10-09 14:12:43	2018-10-09	12
10278	2	3444	2018-10-09 14:12:44	2018-10-09	12
10279	3	3444	2018-10-09 14:12:44	2018-10-09	12
10280	1	3445	2018-10-09 14:11:49	2018-10-09	12
10281	2	3445	2018-10-09 14:11:50	2018-10-09	12
10282	3	3445	2018-10-09 14:11:51	2018-10-09	12
10283	1	3446	2018-10-09 14:07:52	2018-10-09	12
10284	2	3446	2018-10-09 14:07:53	2018-10-09	12
10285	3	3446	2018-10-09 14:07:54	2018-10-09	12
10286	1	3447	2018-10-09 14:07:12	2018-10-09	12
10287	2	3447	2018-10-09 14:07:13	2018-10-09	12
10288	3	3447	2018-10-09 14:07:14	2018-10-09	12
10289	1	3448	2018-10-09 14:06:50	2018-10-09	12
10290	2	3448	2018-10-09 14:06:52	2018-10-09	12
10291	3	3448	2018-10-09 14:22:36	2018-10-09	12
10292	1	3449	2018-10-09 14:03:57	2018-10-09	12
10293	2	3449	2018-10-09 14:03:58	2018-10-09	12
10294	3	3449	2018-10-09 14:03:59	2018-10-09	12
10295	1	3450	2018-10-09 13:56:10	2018-10-09	11
10296	2	3450	2018-10-09 13:56:11	2018-10-09	11
10297	3	3450	2018-10-10 11:21:02	2018-10-10	9
10298	1	3451	2018-10-09 13:48:31	2018-10-09	11
10299	2	3451	2018-10-09 13:48:32	2018-10-09	11
10300	3	3451	2018-10-09 14:02:57	2018-10-09	12
10301	1	3452	2018-10-09 12:14:05	2018-10-09	10
10302	2	3452	2018-10-09 12:14:06	2018-10-09	10
10303	3	3452	2018-10-09 12:51:05	2018-10-09	10
10304	1	3453	2018-10-09 12:12:02	2018-10-09	10
10305	2	3453	2018-10-09 12:12:03	2018-10-09	10
10306	3	3453	2018-10-09 12:12:04	2018-10-09	10
10307	1	3454	2018-10-09 12:09:50	2018-10-09	10
10308	2	3454	2018-10-09 12:09:51	2018-10-09	10
10309	3	3454	2018-10-09 12:09:52	2018-10-09	10
10310	1	3455	2018-10-09 12:06:47	2018-10-09	10
10311	2	3455	2018-10-09 12:06:48	2018-10-09	10
10312	3	3455	2018-10-09 12:06:49	2018-10-09	10
10313	1	3456	2018-10-09 12:05:48	2018-10-09	10
10314	2	3456	2018-10-09 12:05:49	2018-10-09	10
10315	3	3456	2018-10-10 08:19:34	2018-10-10	6
10316	1	3457	2018-10-09 12:01:01	2018-10-09	10
10317	2	3457	2018-10-09 12:01:03	2018-10-09	10
10318	3	3457	2018-10-09 12:01:04	2018-10-09	10
10319	1	3458	2018-10-09 11:59:48	2018-10-09	9
10320	2	3458	2018-10-09 11:59:49	2018-10-09	9
10321	3	3458	2018-10-09 11:59:50	2018-10-09	9
10322	1	3459	2018-10-09 12:00:31	2018-10-09	10
10323	2	3459	2018-10-09 12:00:32	2018-10-09	10
10324	3	3459	2018-10-09 12:05:33	2018-10-09	10
10325	1	3460	2018-10-09 11:52:23	2018-10-09	9
10326	2	3460	2018-10-09 11:52:23	2018-10-09	9
10327	3	3460	2018-10-09 11:52:25	2018-10-09	9
10328	1	3461	2018-10-09 11:53:39	2018-10-09	9
10329	2	3461	2018-10-09 11:53:41	2018-10-09	9
10330	3	3461	2018-10-10 09:16:43	2018-10-10	7
10331	1	3462	2018-10-09 11:58:47	2018-10-09	9
10332	2	3462	2018-10-09 11:58:48	2018-10-09	9
10333	3	3462	2018-10-10 09:42:13	2018-10-10	7
10334	1	3463	2018-10-09 11:49:13	2018-10-09	9
10335	2	3463	2018-10-09 11:49:14	2018-10-09	9
10336	3	3463	2018-10-09 11:49:15	2018-10-09	9
10337	1	3464	2018-10-09 11:49:05	2018-10-09	9
10338	2	3464	2018-10-09 11:49:06	2018-10-09	9
10339	3	3464	2018-10-09 11:49:07	2018-10-09	9
10340	1	3465	2018-10-09 11:48:18	2018-10-09	9
10341	2	3465	2018-10-09 11:48:19	2018-10-09	9
10342	3	3465	2018-10-09 12:09:49	2018-10-09	10
10343	1	3466	2018-10-09 11:47:52	2018-10-09	9
10344	2	3466	2018-10-09 11:47:53	2018-10-09	9
10345	3	3466	2018-10-11 09:17:13	2018-10-11	7
10346	1	3467	2018-10-09 11:45:28	2018-10-09	9
10347	2	3467	2018-10-09 11:45:29	2018-10-09	9
10348	3	3467	2018-10-09 15:54:58	2018-10-09	13
10349	1	3468	2018-10-09 11:43:24	2018-10-09	9
10350	2	3468	2018-10-09 11:43:25	2018-10-09	9
10351	3	3468	2018-10-09 12:34:25	2018-10-09	10
10352	1	3469	2018-10-09 11:41:51	2018-10-09	9
10353	2	3469	2018-10-09 11:41:52	2018-10-09	9
10354	3	3469	2018-10-09 15:08:32	2018-10-09	13
10355	1	3470	2018-10-09 11:39:32	2018-10-09	9
10356	2	3470	2018-10-09 11:39:33	2018-10-09	9
10357	3	3470	2018-10-09 11:39:34	2018-10-09	9
10358	1	3471	2018-10-09 11:37:01	2018-10-09	9
10359	2	3471	2018-10-09 11:37:02	2018-10-09	9
10360	3	3471	2018-10-09 11:37:03	2018-10-09	9
10361	1	3472	2018-10-09 11:36:40	2018-10-09	9
10362	2	3472	2018-10-09 11:36:41	2018-10-09	9
10363	3	3472	2018-10-09 11:36:42	2018-10-09	9
10364	1	3473	2018-10-09 11:35:52	2018-10-09	9
10365	2	3473	2018-10-09 11:35:53	2018-10-09	9
10366	3	3473	2018-10-09 15:46:33	2018-10-09	13
10367	1	3474	2018-10-09 11:32:26	2018-10-09	9
10368	2	3474	2018-10-09 11:32:27	2018-10-09	9
10369	3	3474	2018-10-09 11:32:28	2018-10-09	9
10370	1	3475	2018-10-09 11:29:13	2018-10-09	9
10371	2	3475	2018-10-09 11:29:15	2018-10-09	9
10372	3	3475	2018-10-09 11:29:16	2018-10-09	9
10373	1	3476	2018-10-09 11:26:06	2018-10-09	9
10374	2	3476	2018-10-09 11:26:07	2018-10-09	9
10375	3	3476	2018-10-09 11:26:08	2018-10-09	9
10376	1	3477	2018-10-09 11:23:34	2018-10-09	9
10377	2	3477	2018-10-09 11:23:35	2018-10-09	9
10378	3	3477	2018-10-09 11:23:36	2018-10-09	9
10379	1	3478	2018-10-09 11:24:46	2018-10-09	9
10380	2	3478	2018-10-09 11:24:46	2018-10-09	9
10381	3	3478	2018-10-10 10:01:58	2018-10-10	8
10382	1	3479	2018-10-09 11:25:30	2018-10-09	9
10383	2	3479	2018-10-09 11:25:31	2018-10-09	9
10384	3	3479	2018-10-09 11:49:33	2018-10-09	9
10385	1	3480	2018-10-09 11:20:17	2018-10-09	9
10386	2	3480	2018-10-09 11:20:18	2018-10-09	9
10387	3	3480	2018-10-09 11:20:19	2018-10-09	9
10388	1	3481	2018-10-09 11:18:41	2018-10-09	9
10389	2	3481	2018-10-09 11:18:42	2018-10-09	9
10390	3	3481	2018-10-09 11:34:07	2018-10-09	9
10391	1	3482	2018-10-09 11:16:59	2018-10-09	9
10392	2	3482	2018-10-09 11:17:00	2018-10-09	9
10393	3	3482	2018-10-09 11:33:47	2018-10-09	9
10394	1	3483	2018-10-09 11:15:05	2018-10-09	9
10395	2	3483	2018-10-09 11:15:07	2018-10-09	9
10396	3	3483	2018-10-09 11:39:13	2018-10-09	9
10397	1	3484	2018-10-09 11:15:13	2018-10-09	9
10398	2	3484	2018-10-09 11:15:14	2018-10-09	9
10399	3	3484	2018-10-09 11:15:15	2018-10-09	9
10400	1	3485	2018-10-09 11:11:59	2018-10-09	9
10401	2	3485	2018-10-09 11:12:01	2018-10-09	9
10402	3	3485	2018-10-09 12:32:37	2018-10-09	10
10403	1	3486	2018-10-09 11:09:40	2018-10-09	9
10404	2	3486	2018-10-09 11:09:41	2018-10-09	9
10405	3	3486	2018-10-09 11:09:42	2018-10-09	9
10406	1	3487	2018-10-09 11:07:34	2018-10-09	9
10407	2	3487	2018-10-09 11:07:35	2018-10-09	9
10408	3	3487	2018-10-09 11:07:36	2018-10-09	9
10409	1	3488	2018-10-09 11:02:58	2018-10-09	9
10410	2	3488	2018-10-09 11:02:59	2018-10-09	9
10411	3	3488	2018-10-09 11:03:00	2018-10-09	9
10412	1	3489	2018-10-09 11:01:29	2018-10-09	9
10413	2	3489	2018-10-09 11:01:30	2018-10-09	9
10414	3	3489	2018-10-09 12:46:57	2018-10-09	10
10415	1	3490	2018-10-09 10:58:44	2018-10-09	8
10416	2	3490	2018-10-09 10:58:45	2018-10-09	8
10417	3	3490	2018-10-09 10:58:46	2018-10-09	8
10418	1	3491	2018-10-09 10:58:05	2018-10-09	8
10419	2	3491	2018-10-09 10:58:06	2018-10-09	8
10420	3	3491	2018-10-09 10:58:07	2018-10-09	8
10421	1	3492	2018-10-09 10:56:42	2018-10-09	8
10422	2	3492	2018-10-09 10:56:42	2018-10-09	8
10423	3	3492	2018-10-09 10:56:43	2018-10-09	8
10424	1	3493	2018-10-09 10:56:06	2018-10-09	8
10425	2	3493	2018-10-09 10:56:07	2018-10-09	8
10426	3	3493	2018-10-09 10:56:08	2018-10-09	8
10427	1	3494	2018-10-09 10:55:36	2018-10-09	8
10428	2	3494	2018-10-09 10:55:37	2018-10-09	8
10429	3	3494	2018-10-09 10:55:38	2018-10-09	8
10430	1	3495	2018-10-09 10:50:57	2018-10-09	8
10431	2	3495	2018-10-09 10:50:58	2018-10-09	8
10432	3	3495	2018-10-09 10:50:59	2018-10-09	8
10433	1	3496	2018-10-09 10:45:57	2018-10-09	8
10434	2	3496	2018-10-09 10:45:58	2018-10-09	8
10435	3	3496	2018-10-09 10:45:59	2018-10-09	8
10436	1	3497	2018-10-09 10:41:26	2018-10-09	8
10437	2	3497	2018-10-09 10:41:27	2018-10-09	8
10438	3	3497	2018-10-09 10:41:28	2018-10-09	8
10439	1	3498	2018-10-09 10:39:11	2018-10-09	8
10440	2	3498	2018-10-09 10:39:12	2018-10-09	8
10441	3	3498	2018-10-09 10:39:13	2018-10-09	8
10442	1	3499	2018-10-09 10:34:58	2018-10-09	8
10443	2	3499	2018-10-09 10:34:59	2018-10-09	8
10444	3	3499	2018-10-09 10:35:00	2018-10-09	8
10445	1	3500	2018-10-09 10:33:42	2018-10-09	8
10446	2	3500	2018-10-09 10:33:43	2018-10-09	8
10447	3	3500	2018-10-09 10:33:44	2018-10-09	8
10448	1	3501	2018-10-09 10:33:09	2018-10-09	8
10449	2	3501	2018-10-09 10:33:09	2018-10-09	8
10450	3	3501	2018-10-09 10:33:11	2018-10-09	8
10451	1	3502	2018-10-09 10:32:08	2018-10-09	8
10452	2	3502	2018-10-09 10:32:09	2018-10-09	8
10453	3	3502	2018-10-09 10:32:10	2018-10-09	8
10454	1	3503	2018-10-09 10:30:21	2018-10-09	8
10455	2	3503	2018-10-09 10:30:22	2018-10-09	8
10456	3	3503	2018-10-09 10:30:23	2018-10-09	8
10457	1	3504	2018-10-09 10:29:30	2018-10-09	8
10458	2	3504	2018-10-09 10:29:31	2018-10-09	8
10459	3	3504	2018-10-09 10:29:32	2018-10-09	8
10460	1	3505	2018-10-09 10:29:07	2018-10-09	8
10461	2	3505	2018-10-09 10:29:08	2018-10-09	8
10462	3	3505	2018-10-09 10:29:09	2018-10-09	8
10463	1	3506	2018-10-09 10:28:56	2018-10-09	8
10464	2	3506	2018-10-09 10:28:57	2018-10-09	8
10465	3	3506	2018-10-09 10:28:58	2018-10-09	8
10466	1	3507	2018-10-09 10:28:28	2018-10-09	8
10467	2	3507	2018-10-09 10:28:28	2018-10-09	8
10468	3	3507	2018-10-09 10:28:29	2018-10-09	8
10469	1	3508	2018-10-09 10:25:45	2018-10-09	8
10470	2	3508	2018-10-09 10:25:46	2018-10-09	8
10471	3	3508	2018-10-09 10:25:47	2018-10-09	8
10472	1	3509	2018-10-09 10:25:22	2018-10-09	8
10473	2	3509	2018-10-09 10:25:23	2018-10-09	8
10474	3	3509	2018-10-09 10:25:24	2018-10-09	8
10475	1	3510	2018-10-09 10:24:47	2018-10-09	8
10476	2	3510	2018-10-09 10:24:47	2018-10-09	8
10477	3	3510	2018-10-09 10:24:48	2018-10-09	8
10478	1	3511	2018-10-09 10:24:06	2018-10-09	8
10479	2	3511	2018-10-09 10:24:07	2018-10-09	8
10480	3	3511	2018-10-09 10:24:08	2018-10-09	8
10481	1	3512	2018-10-09 10:23:38	2018-10-09	8
10482	2	3512	2018-10-09 10:23:39	2018-10-09	8
10483	3	3512	2018-10-09 10:23:40	2018-10-09	8
10484	1	3513	2018-10-09 10:20:57	2018-10-09	8
10485	2	3513	2018-10-09 10:20:58	2018-10-09	8
10486	3	3513	2018-10-09 10:20:59	2018-10-09	8
10487	1	3514	2018-10-09 10:19:45	2018-10-09	8
10488	2	3514	2018-10-09 10:19:46	2018-10-09	8
10489	3	3514	2018-10-09 10:19:47	2018-10-09	8
10490	1	3515	2018-10-09 10:15:23	2018-10-09	8
10491	2	3515	2018-10-09 10:15:24	2018-10-09	8
10492	3	3515	2018-10-10 11:18:16	2018-10-10	9
10493	1	3516	2018-10-09 10:07:46	2018-10-09	8
10494	2	3516	2018-10-09 10:07:47	2018-10-09	8
10495	3	3516	2018-10-09 10:07:48	2018-10-09	8
10496	1	3517	2018-10-09 10:07:14	2018-10-09	8
10497	2	3517	2018-10-09 10:07:15	2018-10-09	8
10498	3	3517	2018-10-09 10:07:16	2018-10-09	8
10499	1	3518	2018-10-09 10:06:55	2018-10-09	8
10500	2	3518	2018-10-09 10:06:56	2018-10-09	8
10501	3	3518	2018-10-09 10:06:57	2018-10-09	8
10502	1	3519	2018-10-09 10:04:39	2018-10-09	8
10503	2	3519	2018-10-09 10:04:40	2018-10-09	8
10504	3	3519	2018-10-09 10:04:41	2018-10-09	8
10505	1	3520	2018-10-09 10:02:48	2018-10-09	8
10506	2	3520	2018-10-09 10:02:49	2018-10-09	8
10507	3	3520	2018-10-09 10:02:50	2018-10-09	8
10508	1	3521	2018-10-09 10:02:14	2018-10-09	8
10509	2	3521	2018-10-09 10:02:14	2018-10-09	8
10510	3	3521	2018-10-09 10:21:02	2018-10-09	8
10511	1	3522	2018-10-09 10:03:55	2018-10-09	8
10512	2	3522	2018-10-09 10:03:56	2018-10-09	8
10513	3	3522	2018-10-09 10:03:57	2018-10-09	8
10514	1	3523	2018-10-09 09:59:58	2018-10-09	7
10515	2	3523	2018-10-09 09:59:59	2018-10-09	7
10516	3	3523	2018-10-09 10:31:50	2018-10-09	8
10517	1	3524	2018-10-09 09:57:01	2018-10-09	7
10518	2	3524	2018-10-09 09:57:02	2018-10-09	7
10519	3	3524	2018-10-09 09:57:03	2018-10-09	7
10520	1	3525	2018-10-09 09:58:19	2018-10-09	7
10521	2	3525	2018-10-09 09:58:19	2018-10-09	7
10522	3	3525	2018-10-09 10:01:37	2018-10-09	8
10523	1	3526	2018-10-09 09:56:41	2018-10-09	7
10524	2	3526	2018-10-09 09:56:42	2018-10-09	7
10525	3	3526	2018-10-09 09:56:43	2018-10-09	7
10526	1	3527	2018-10-09 09:57:29	2018-10-09	7
10527	2	3527	2018-10-09 09:57:30	2018-10-09	7
10528	3	3527	2018-10-09 10:18:34	2018-10-09	8
10529	1	3528	2018-10-09 09:55:14	2018-10-09	7
10530	2	3528	2018-10-09 09:55:15	2018-10-09	7
10531	3	3528	2018-10-09 09:55:16	2018-10-09	7
10532	1	3529	2018-10-09 09:56:37	2018-10-09	7
10533	2	3529	2018-10-09 09:56:37	2018-10-09	7
10534	3	3529	2018-10-09 09:56:38	2018-10-09	7
10535	1	3530	2018-10-09 09:54:09	2018-10-09	7
10536	2	3530	2018-10-09 09:54:10	2018-10-09	7
10537	3	3530	2018-10-09 11:57:35	2018-10-09	9
10538	1	3531	2018-10-09 09:50:27	2018-10-09	7
10539	2	3531	2018-10-09 09:50:28	2018-10-09	7
10540	3	3531	2018-10-09 09:50:29	2018-10-09	7
10541	1	3532	2018-10-09 09:47:59	2018-10-09	7
10542	2	3532	2018-10-09 09:48:00	2018-10-09	7
10543	3	3532	2018-10-09 09:48:01	2018-10-09	7
10544	1	3533	2018-10-09 09:47:15	2018-10-09	7
10545	2	3533	2018-10-09 09:47:16	2018-10-09	7
10546	3	3533	2018-10-09 09:47:16	2018-10-09	7
10547	1	3534	2018-10-09 09:44:16	2018-10-09	7
10548	2	3534	2018-10-09 09:44:18	2018-10-09	7
10549	3	3534	2018-10-11 08:53:45	2018-10-11	6
10550	1	3535	2018-10-09 09:45:22	2018-10-09	7
10551	2	3535	2018-10-09 09:45:23	2018-10-09	7
10552	3	3535	2018-10-09 09:45:24	2018-10-09	7
10553	1	3536	2018-10-09 09:41:50	2018-10-09	7
10554	2	3536	2018-10-09 09:41:52	2018-10-09	7
10555	3	3536	2018-10-09 09:41:53	2018-10-09	7
10556	1	3537	2018-10-09 09:41:13	2018-10-09	7
10557	2	3537	2018-10-09 09:41:14	2018-10-09	7
10558	3	3537	2018-10-09 09:41:15	2018-10-09	7
10559	1	3538	2018-10-09 09:40:26	2018-10-09	7
10560	2	3538	2018-10-09 09:40:27	2018-10-09	7
10561	3	3538	2018-10-09 09:40:28	2018-10-09	7
10562	1	3539	2018-10-09 09:35:58	2018-10-09	7
10563	2	3539	2018-10-09 09:35:58	2018-10-09	7
10564	3	3539	2018-10-09 09:35:59	2018-10-09	7
10565	1	3540	2018-10-09 09:35:13	2018-10-09	7
10566	2	3540	2018-10-09 09:35:14	2018-10-09	7
10567	3	3540	2018-10-09 09:35:15	2018-10-09	7
10568	1	3541	2018-10-09 09:34:06	2018-10-09	7
10569	2	3541	2018-10-09 09:34:07	2018-10-09	7
10570	3	3541	2018-10-09 09:34:08	2018-10-09	7
10571	1	3542	2018-10-09 09:33:30	2018-10-09	7
10572	2	3542	2018-10-09 09:33:30	2018-10-09	7
10573	3	3542	2018-10-09 09:33:31	2018-10-09	7
10574	1	3543	2018-10-09 09:34:59	2018-10-09	7
10575	2	3543	2018-10-09 09:34:59	2018-10-09	7
10576	3	3543	2018-10-09 09:35:00	2018-10-09	7
10577	1	3544	2018-10-09 09:32:21	2018-10-09	7
10578	2	3544	2018-10-09 09:32:22	2018-10-09	7
10579	3	3544	2018-10-09 09:32:23	2018-10-09	7
10580	1	3545	2018-10-09 09:31:49	2018-10-09	7
10581	2	3545	2018-10-09 09:31:50	2018-10-09	7
10582	3	3545	2018-10-09 09:31:51	2018-10-09	7
10583	1	3546	2018-10-09 09:27:52	2018-10-09	7
10584	2	3546	2018-10-09 09:27:53	2018-10-09	7
10585	3	3546	2018-10-09 09:27:54	2018-10-09	7
10586	1	3547	2018-10-09 09:22:29	2018-10-09	7
10587	2	3547	2018-10-09 09:22:30	2018-10-09	7
10588	3	3547	2018-10-09 09:22:31	2018-10-09	7
10589	1	3548	2018-10-09 09:17:41	2018-10-09	7
10590	2	3548	2018-10-09 09:17:42	2018-10-09	7
10591	3	3548	2018-10-09 09:17:43	2018-10-09	7
10592	1	3549	2018-10-09 09:15:30	2018-10-09	7
10593	2	3549	2018-10-09 09:15:31	2018-10-09	7
10594	3	3549	2018-10-10 11:14:39	2018-10-10	9
10595	1	3550	2018-10-09 09:14:05	2018-10-09	7
10596	2	3550	2018-10-09 09:14:06	2018-10-09	7
10597	3	3550	2018-10-09 09:14:07	2018-10-09	7
10598	1	3551	2018-10-09 09:13:27	2018-10-09	7
10599	2	3551	2018-10-09 09:13:28	2018-10-09	7
10600	3	3551	2018-10-09 09:13:29	2018-10-09	7
10601	1	3552	2018-10-09 09:12:32	2018-10-09	7
10602	2	3552	2018-10-09 09:12:33	2018-10-09	7
10603	3	3552	2018-10-09 09:12:34	2018-10-09	7
10604	1	3553	2018-10-09 09:11:10	2018-10-09	7
10605	2	3553	2018-10-09 09:11:11	2018-10-09	7
10606	3	3553	2018-10-09 09:11:12	2018-10-09	7
10607	1	3554	2018-10-09 09:09:06	2018-10-09	7
10608	2	3554	2018-10-09 09:09:07	2018-10-09	7
10609	3	3554	2018-10-09 09:09:08	2018-10-09	7
10610	1	3555	2018-10-09 09:08:55	2018-10-09	7
10611	2	3555	2018-10-09 09:08:56	2018-10-09	7
10612	3	3555	2018-10-09 09:08:57	2018-10-09	7
10613	1	3556	2018-10-09 09:08:31	2018-10-09	7
10614	2	3556	2018-10-09 09:08:32	2018-10-09	7
10615	3	3556	2018-10-09 09:08:33	2018-10-09	7
10616	1	3557	2018-10-09 09:08:26	2018-10-09	7
10617	2	3557	2018-10-09 09:08:27	2018-10-09	7
10618	3	3557	2018-10-09 09:08:28	2018-10-09	7
10619	1	3558	2018-10-09 09:07:01	2018-10-09	7
10620	2	3558	2018-10-09 09:07:02	2018-10-09	7
10621	3	3558	2018-10-09 09:07:03	2018-10-09	7
10622	1	3559	2018-10-09 09:06:27	2018-10-09	7
10623	2	3559	2018-10-09 09:06:29	2018-10-09	7
10624	3	3559	2018-10-09 09:06:30	2018-10-09	7
10625	1	3560	2018-10-09 09:06:40	2018-10-09	7
10626	2	3560	2018-10-09 09:06:41	2018-10-09	7
10627	3	3560	2018-10-09 09:22:26	2018-10-09	7
10628	1	3561	2018-10-09 09:01:41	2018-10-09	7
10629	2	3561	2018-10-09 09:01:42	2018-10-09	7
10630	3	3561	2018-10-09 09:01:43	2018-10-09	7
10631	1	3562	2018-10-09 09:00:57	2018-10-09	7
10632	2	3562	2018-10-09 09:00:58	2018-10-09	7
10633	3	3562	2018-10-09 09:00:59	2018-10-09	7
10634	1	3563	2018-10-09 09:00:18	2018-10-09	7
10635	2	3563	2018-10-09 09:00:19	2018-10-09	7
10636	3	3563	2018-10-09 09:00:20	2018-10-09	7
10637	1	3564	2018-10-09 08:59:18	2018-10-09	6
10638	2	3564	2018-10-09 08:59:19	2018-10-09	6
10639	3	3564	2018-10-09 08:59:20	2018-10-09	6
10640	1	3565	2018-10-09 08:58:47	2018-10-09	6
10641	2	3565	2018-10-09 08:58:48	2018-10-09	6
10642	3	3565	2018-10-09 08:58:49	2018-10-09	6
10643	1	3566	2018-10-09 08:56:35	2018-10-09	6
10644	2	3566	2018-10-09 08:56:35	2018-10-09	6
10645	3	3566	2018-10-09 08:56:37	2018-10-09	6
10646	1	3567	2018-10-09 08:55:57	2018-10-09	6
10647	2	3567	2018-10-09 08:55:58	2018-10-09	6
10648	3	3567	2018-10-09 08:55:59	2018-10-09	6
10649	1	3568	2018-10-09 08:53:49	2018-10-09	6
10650	2	3568	2018-10-09 08:53:51	2018-10-09	6
10651	3	3568	2018-10-09 13:34:38	2018-10-09	11
10652	1	3569	2018-10-09 08:51:50	2018-10-09	6
10653	2	3569	2018-10-09 08:51:51	2018-10-09	6
10654	3	3569	2018-10-09 12:06:34	2018-10-09	10
10655	1	3570	2018-10-09 08:48:48	2018-10-09	6
10656	2	3570	2018-10-09 08:48:49	2018-10-09	6
10657	3	3570	2018-10-09 08:48:50	2018-10-09	6
10658	1	3571	2018-10-09 08:48:06	2018-10-09	6
10659	2	3571	2018-10-09 08:48:08	2018-10-09	6
10660	3	3571	2018-10-09 08:48:09	2018-10-09	6
10661	1	3572	2018-10-09 08:41:32	2018-10-09	6
10662	2	3572	2018-10-09 08:41:33	2018-10-09	6
10663	3	3572	2018-10-09 08:41:34	2018-10-09	6
10664	1	3573	2018-10-09 08:40:14	2018-10-09	6
10665	2	3573	2018-10-09 08:40:15	2018-10-09	6
10666	3	3573	2018-10-09 08:40:16	2018-10-09	6
10667	1	3574	2018-10-09 08:38:26	2018-10-09	6
10668	2	3574	2018-10-09 08:38:27	2018-10-09	6
10669	3	3574	2018-10-09 08:38:28	2018-10-09	6
10670	1	3575	2018-10-09 08:38:39	2018-10-09	6
10671	2	3575	2018-10-09 08:38:40	2018-10-09	6
10672	3	3575	2018-10-09 08:38:41	2018-10-09	6
10673	1	3576	2018-10-09 08:37:53	2018-10-09	6
10674	2	3576	2018-10-09 08:37:54	2018-10-09	6
10675	3	3576	2018-10-09 08:37:55	2018-10-09	6
10676	1	3577	2018-10-08 17:00:10	2018-10-08	15
10677	2	3577	2018-10-08 17:00:11	2018-10-08	15
10678	3	3577	2018-10-08 17:00:12	2018-10-08	15
10679	1	3578	2018-10-08 17:00:07	2018-10-08	15
10680	2	3578	2018-10-08 17:00:09	2018-10-08	15
10681	3	3578	2018-10-08 17:00:10	2018-10-08	15
10682	1	3579	2018-10-08 16:58:46	2018-10-08	14
10683	2	3579	2018-10-08 16:58:47	2018-10-08	14
10684	3	3579	2018-10-08 16:58:48	2018-10-08	14
10685	1	3580	2018-10-08 16:48:38	2018-10-08	14
10686	2	3580	2018-10-08 16:48:39	2018-10-08	14
10687	3	3580	2018-10-08 16:48:40	2018-10-08	14
10688	1	3581	2018-10-08 16:39:09	2018-10-08	14
10689	2	3581	2018-10-08 16:39:10	2018-10-08	14
10690	3	3581	2018-10-09 08:45:45	2018-10-09	6
10691	1	3582	2018-10-08 16:31:53	2018-10-08	14
10692	2	3582	2018-10-08 16:31:54	2018-10-08	14
10693	3	3582	2018-10-08 16:31:55	2018-10-08	14
10694	1	3583	2018-10-08 16:30:26	2018-10-08	14
10695	2	3583	2018-10-08 16:30:27	2018-10-08	14
10696	3	3583	2018-10-08 16:30:28	2018-10-08	14
10697	1	3584	2018-10-08 16:18:00	2018-10-08	14
10698	2	3584	2018-10-08 16:18:02	2018-10-08	14
10699	3	3584	2018-10-08 16:22:10	2018-10-08	14
10700	1	3585	2018-10-08 16:16:40	2018-10-08	14
10701	2	3585	2018-10-08 16:16:41	2018-10-08	14
10702	3	3585	2018-10-08 16:16:42	2018-10-08	14
10703	1	3586	2018-10-08 16:15:56	2018-10-08	14
10704	2	3586	2018-10-08 16:15:57	2018-10-08	14
10705	3	3586	2018-10-08 16:15:58	2018-10-08	14
10706	1	3587	2018-10-08 16:15:50	2018-10-08	14
10707	2	3587	2018-10-08 16:15:51	2018-10-08	14
10708	3	3587	2018-10-08 16:15:52	2018-10-08	14
10709	1	3588	2018-10-08 16:15:18	2018-10-08	14
10710	2	3588	2018-10-08 16:15:18	2018-10-08	14
10711	3	3588	2018-10-08 16:15:19	2018-10-08	14
10712	1	3589	2018-10-08 16:14:52	2018-10-08	14
10713	2	3589	2018-10-08 16:14:53	2018-10-08	14
10714	3	3589	2018-10-08 16:14:54	2018-10-08	14
10715	1	3590	2018-10-08 16:14:36	2018-10-08	14
10716	2	3590	2018-10-08 16:14:37	2018-10-08	14
10717	3	3590	2018-10-08 16:14:38	2018-10-08	14
10718	1	3591	2018-10-08 16:14:59	2018-10-08	14
10719	2	3591	2018-10-08 16:15:00	2018-10-08	14
10720	3	3591	2018-10-10 11:12:47	2018-10-10	9
10721	1	3592	2018-10-08 16:11:15	2018-10-08	14
10722	2	3592	2018-10-08 16:11:16	2018-10-08	14
10723	3	3592	2018-10-08 16:11:17	2018-10-08	14
10724	1	3593	2018-10-08 16:00:20	2018-10-08	14
10725	2	3593	2018-10-08 16:00:21	2018-10-08	14
10726	3	3593	2018-10-08 16:00:22	2018-10-08	14
10727	1	3594	2018-10-08 16:00:06	2018-10-08	14
10728	2	3594	2018-10-08 16:00:07	2018-10-08	14
10729	3	3594	2018-10-08 16:00:08	2018-10-08	14
10730	1	3595	2018-10-08 16:01:03	2018-10-08	14
10731	2	3595	2018-10-08 16:01:05	2018-10-08	14
10732	3	3595	2018-10-09 12:27:53	2018-10-09	10
10733	1	3596	2018-10-08 15:57:25	2018-10-08	13
10734	2	3596	2018-10-08 15:57:27	2018-10-08	13
10735	3	3596	2018-10-08 15:57:28	2018-10-08	13
10736	1	3597	2018-10-08 15:56:08	2018-10-08	13
10737	2	3597	2018-10-08 15:56:09	2018-10-08	13
10738	3	3597	2018-10-08 15:56:10	2018-10-08	13
10739	1	3598	2018-10-08 15:58:15	2018-10-08	13
10740	2	3598	2018-10-08 15:58:16	2018-10-08	13
10741	3	3598	2018-10-09 09:33:56	2018-10-09	7
10742	1	3599	2018-10-08 15:51:14	2018-10-08	13
10743	2	3599	2018-10-08 15:51:15	2018-10-08	13
10744	3	3599	2018-10-08 15:51:16	2018-10-08	13
10745	1	3600	2018-10-08 15:50:42	2018-10-08	13
10746	2	3600	2018-10-08 15:50:42	2018-10-08	13
10747	3	3600	2018-10-08 15:50:43	2018-10-08	13
10748	1	3601	2018-10-08 15:46:37	2018-10-08	13
10749	2	3601	2018-10-08 15:46:39	2018-10-08	13
10750	3	3601	2018-10-08 15:46:40	2018-10-08	13
10751	1	3602	2018-10-08 15:42:14	2018-10-08	13
10752	2	3602	2018-10-08 15:42:16	2018-10-08	13
10753	3	3602	2018-10-09 12:12:02	2018-10-09	10
10754	1	3603	2018-10-08 15:40:43	2018-10-08	13
10755	2	3603	2018-10-08 15:40:45	2018-10-08	13
10756	3	3603	2018-10-08 16:18:14	2018-10-08	14
10757	1	3604	2018-10-08 15:31:46	2018-10-08	13
10758	2	3604	2018-10-08 15:31:47	2018-10-08	13
10759	3	3604	2018-10-08 15:31:48	2018-10-08	13
10760	1	3605	2018-10-08 15:26:23	2018-10-08	13
10761	2	3605	2018-10-08 15:26:24	2018-10-08	13
10762	3	3605	2018-10-08 15:26:25	2018-10-08	13
10763	1	3606	2018-10-08 15:22:30	2018-10-08	13
10764	2	3606	2018-10-08 15:22:31	2018-10-08	13
10765	3	3606	2018-10-08 15:22:33	2018-10-08	13
10766	1	3607	2018-10-08 15:19:22	2018-10-08	13
10767	2	3607	2018-10-08 15:19:24	2018-10-08	13
10768	3	3607	2018-10-08 15:19:25	2018-10-08	13
10769	1	3608	2018-10-08 15:18:02	2018-10-08	13
10770	2	3608	2018-10-08 15:18:03	2018-10-08	13
10771	3	3608	2018-10-08 15:18:04	2018-10-08	13
10772	1	3609	2018-10-08 15:14:40	2018-10-08	13
10773	2	3609	2018-10-08 15:14:41	2018-10-08	13
10774	3	3609	2018-10-08 15:14:42	2018-10-08	13
10775	1	3610	2018-10-08 15:07:56	2018-10-08	13
10776	2	3610	2018-10-08 15:07:57	2018-10-08	13
10777	3	3610	2018-10-08 15:07:59	2018-10-08	13
10778	1	3611	2018-10-08 15:06:46	2018-10-08	13
10779	2	3611	2018-10-08 15:06:47	2018-10-08	13
10780	3	3611	2018-10-08 15:06:48	2018-10-08	13
10781	1	3612	2018-10-08 14:54:40	2018-10-08	12
10782	2	3612	2018-10-08 14:54:41	2018-10-08	12
10783	3	3612	2018-10-08 14:54:42	2018-10-08	12
10784	1	3613	2018-10-08 14:54:48	2018-10-08	12
10785	2	3613	2018-10-08 14:54:49	2018-10-08	12
10786	3	3613	2018-10-08 14:54:50	2018-10-08	12
10787	1	3614	2018-10-08 14:54:16	2018-10-08	12
10788	2	3614	2018-10-08 14:54:17	2018-10-08	12
10789	3	3614	2018-10-08 14:54:18	2018-10-08	12
10790	1	3615	2018-10-08 14:53:47	2018-10-08	12
10791	2	3615	2018-10-08 14:53:48	2018-10-08	12
10792	3	3615	2018-10-08 14:53:49	2018-10-08	12
10793	1	3616	2018-10-08 14:45:58	2018-10-08	12
10794	2	3616	2018-10-08 14:46:00	2018-10-08	12
10795	3	3616	2018-10-08 14:46:01	2018-10-08	12
10796	1	3617	2018-10-08 14:46:00	2018-10-08	12
10797	2	3617	2018-10-08 14:46:01	2018-10-08	12
10798	3	3617	2018-10-08 14:46:02	2018-10-08	12
10799	1	3618	2018-10-08 14:43:43	2018-10-08	12
10800	2	3618	2018-10-08 14:43:43	2018-10-08	12
10801	3	3618	2018-10-08 14:43:44	2018-10-08	12
10802	1	3619	2018-10-08 14:41:16	2018-10-08	12
10803	2	3619	2018-10-08 14:41:17	2018-10-08	12
10804	3	3619	2018-10-08 14:41:18	2018-10-08	12
10805	1	3620	2018-10-08 14:36:36	2018-10-08	12
10806	2	3620	2018-10-08 14:36:37	2018-10-08	12
10807	3	3620	2018-10-08 14:36:38	2018-10-08	12
10808	1	3621	2018-10-08 14:30:00	2018-10-08	12
10809	2	3621	2018-10-08 14:30:02	2018-10-08	12
10810	3	3621	2018-10-10 11:10:12	2018-10-10	9
10811	1	3622	2018-10-08 14:20:31	2018-10-08	12
10812	2	3622	2018-10-08 14:20:32	2018-10-08	12
10813	3	3622	2018-10-08 14:20:33	2018-10-08	12
10814	1	3623	2018-10-08 14:17:53	2018-10-08	12
10815	2	3623	2018-10-08 14:17:53	2018-10-08	12
10816	3	3623	2018-10-08 14:17:54	2018-10-08	12
10817	1	3624	2018-10-08 14:15:06	2018-10-08	12
10818	2	3624	2018-10-08 14:15:06	2018-10-08	12
10819	3	3624	2018-10-08 14:15:13	2018-10-08	12
10820	1	3625	2018-10-08 14:15:10	2018-10-08	12
10821	2	3625	2018-10-08 14:15:11	2018-10-08	12
10822	3	3625	2018-10-08 14:15:12	2018-10-08	12
10823	1	3626	2018-10-08 14:14:40	2018-10-08	12
10824	2	3626	2018-10-08 14:14:41	2018-10-08	12
10825	3	3626	2018-10-08 14:14:42	2018-10-08	12
10826	1	3627	2018-10-08 14:17:00	2018-10-08	12
10827	2	3627	2018-10-08 14:17:01	2018-10-08	12
10828	3	3627	2018-10-09 10:13:39	2018-10-09	8
10829	1	3628	2018-10-08 14:12:58	2018-10-08	12
10830	2	3628	2018-10-08 14:12:59	2018-10-08	12
10831	3	3628	2018-10-08 14:13:00	2018-10-08	12
10832	1	3629	2018-10-08 14:12:07	2018-10-08	12
10833	2	3629	2018-10-08 14:12:09	2018-10-08	12
10834	3	3629	2018-10-08 14:12:10	2018-10-08	12
10835	1	3630	2018-10-08 14:11:11	2018-10-08	12
10836	2	3630	2018-10-08 14:11:12	2018-10-08	12
10837	3	3630	2018-10-08 14:12:39	2018-10-08	12
10838	1	3631	2018-10-08 14:10:32	2018-10-08	12
10839	2	3631	2018-10-08 14:10:33	2018-10-08	12
10840	3	3631	2018-10-08 14:10:34	2018-10-08	12
10841	1	3632	2018-10-08 14:07:21	2018-10-08	12
10842	2	3632	2018-10-08 14:07:21	2018-10-08	12
10843	3	3632	2018-10-08 14:07:22	2018-10-08	12
10844	1	3633	2018-10-08 14:06:49	2018-10-08	12
10845	2	3633	2018-10-08 14:06:50	2018-10-08	12
10846	3	3633	2018-10-08 14:06:51	2018-10-08	12
10847	1	3634	2018-10-08 14:06:42	2018-10-08	12
10848	2	3634	2018-10-08 14:06:43	2018-10-08	12
10849	3	3634	2018-10-08 14:06:44	2018-10-08	12
10850	1	3635	2018-10-08 14:07:01	2018-10-08	12
10851	2	3635	2018-10-08 14:07:02	2018-10-08	12
10852	3	3635	2018-10-08 14:07:03	2018-10-08	12
10853	1	3636	2018-10-08 12:21:48	2018-10-08	10
10854	2	3636	2018-10-08 12:21:49	2018-10-08	10
10855	3	3636	2018-10-09 12:15:53	2018-10-09	10
10856	1	3637	2018-10-08 11:54:20	2018-10-08	9
10857	2	3637	2018-10-08 11:54:21	2018-10-08	9
10858	3	3637	2018-10-08 11:54:22	2018-10-08	9
10859	1	3638	2018-10-08 11:51:29	2018-10-08	9
10860	2	3638	2018-10-08 11:51:30	2018-10-08	9
10861	3	3638	2018-10-08 11:51:31	2018-10-08	9
10862	1	3639	2018-10-08 11:44:39	2018-10-08	9
10863	2	3639	2018-10-08 11:44:40	2018-10-08	9
10864	3	3639	2018-10-08 11:44:41	2018-10-08	9
10865	1	3640	2018-10-08 11:41:11	2018-10-08	9
10866	2	3640	2018-10-08 11:41:12	2018-10-08	9
10867	3	3640	2018-10-08 11:41:13	2018-10-08	9
10868	1	3641	2018-10-08 11:29:04	2018-10-08	9
10869	2	3641	2018-10-08 11:29:06	2018-10-08	9
10870	3	3641	2018-10-08 11:29:07	2018-10-08	9
10871	1	3642	2018-10-08 11:26:57	2018-10-08	9
10872	2	3642	2018-10-08 11:26:58	2018-10-08	9
10873	3	3642	2018-10-08 11:26:59	2018-10-08	9
10874	1	3643	2018-10-08 11:18:08	2018-10-08	9
10875	2	3643	2018-10-08 11:18:09	2018-10-08	9
10876	3	3643	2018-10-08 11:18:10	2018-10-08	9
10877	1	3644	2018-10-08 11:14:50	2018-10-08	9
10878	2	3644	2018-10-08 11:14:51	2018-10-08	9
10879	3	3644	2018-10-08 11:14:52	2018-10-08	9
10880	1	3645	2018-10-08 11:11:57	2018-10-08	9
10881	2	3645	2018-10-08 11:11:58	2018-10-08	9
10882	3	3645	2018-10-08 11:11:59	2018-10-08	9
10883	1	3646	2018-10-08 11:09:16	2018-10-08	9
10884	2	3646	2018-10-08 11:09:17	2018-10-08	9
10885	3	3646	2018-10-08 11:09:18	2018-10-08	9
10886	1	3647	2018-10-08 11:08:07	2018-10-08	9
10887	2	3647	2018-10-08 11:08:09	2018-10-08	9
10888	3	3647	2018-10-08 11:08:10	2018-10-08	9
10889	1	3648	2018-10-08 11:06:14	2018-10-08	9
10890	2	3648	2018-10-08 11:06:15	2018-10-08	9
10891	3	3648	2018-10-08 11:06:16	2018-10-08	9
10892	1	3649	2018-10-08 11:05:55	2018-10-08	9
10893	2	3649	2018-10-08 11:05:56	2018-10-08	9
10894	3	3649	2018-10-08 11:05:57	2018-10-08	9
10895	1	3650	2018-10-08 11:09:14	2018-10-08	9
10896	2	3650	2018-10-08 11:09:15	2018-10-08	9
10897	3	3650	2018-10-08 11:31:08	2018-10-08	9
10898	1	3651	2018-10-08 11:02:45	2018-10-08	9
10899	2	3651	2018-10-08 11:02:46	2018-10-08	9
10900	3	3651	2018-10-08 11:02:47	2018-10-08	9
10901	1	3652	2018-10-08 11:05:14	2018-10-08	9
10902	2	3652	2018-10-08 11:05:15	2018-10-08	9
10903	3	3652	2018-10-08 11:05:16	2018-10-08	9
10904	1	3653	2018-10-08 10:56:51	2018-10-08	8
10905	2	3653	2018-10-08 10:56:52	2018-10-08	8
10906	3	3653	2018-10-08 10:56:53	2018-10-08	8
10907	1	3654	2018-10-08 10:56:30	2018-10-08	8
10908	2	3654	2018-10-08 10:56:31	2018-10-08	8
10909	3	3654	2018-10-08 10:56:32	2018-10-08	8
10910	1	3655	2018-10-08 10:57:31	2018-10-08	8
10911	2	3655	2018-10-08 10:57:32	2018-10-08	8
10912	3	3655	2018-10-09 12:04:42	2018-10-09	10
10913	1	3656	2018-10-08 10:54:48	2018-10-08	8
10914	2	3656	2018-10-08 10:54:49	2018-10-08	8
10915	3	3656	2018-10-08 10:54:50	2018-10-08	8
10916	1	3657	2018-10-08 10:52:12	2018-10-08	8
10917	2	3657	2018-10-08 10:52:13	2018-10-08	8
10918	3	3657	2018-10-15 09:47:35	2018-10-15	7
10919	1	3658	2018-10-08 10:49:32	2018-10-08	8
10920	2	3658	2018-10-08 10:49:33	2018-10-08	8
10921	3	3658	2018-10-08 10:49:34	2018-10-08	8
10922	1	3659	2018-10-08 10:54:17	2018-10-08	8
10923	2	3659	2018-10-08 10:54:17	2018-10-08	8
10924	3	3659	2018-10-08 10:54:18	2018-10-08	8
10925	1	3660	2018-10-08 10:50:16	2018-10-08	8
10926	2	3660	2018-10-08 10:50:18	2018-10-08	8
10927	3	3660	2018-10-08 11:14:42	2018-10-08	9
10928	1	3661	2018-10-08 10:46:38	2018-10-08	8
10929	2	3661	2018-10-08 10:46:38	2018-10-08	8
10930	3	3661	2018-10-08 10:46:40	2018-10-08	8
10931	1	3662	2018-10-08 10:46:14	2018-10-08	8
10932	2	3662	2018-10-08 10:46:15	2018-10-08	8
10933	3	3662	2018-10-08 10:46:16	2018-10-08	8
10934	1	3663	2018-10-08 10:45:30	2018-10-08	8
10935	2	3663	2018-10-08 10:45:31	2018-10-08	8
10936	3	3663	2018-10-08 10:45:32	2018-10-08	8
10937	1	3664	2018-10-08 10:45:02	2018-10-08	8
10938	2	3664	2018-10-08 10:45:04	2018-10-08	8
10939	3	3664	2018-10-08 10:48:52	2018-10-08	8
10940	1	3665	2018-10-08 10:43:21	2018-10-08	8
10941	2	3665	2018-10-08 10:43:22	2018-10-08	8
10942	3	3665	2018-10-08 10:43:23	2018-10-08	8
10943	1	3666	2018-10-08 10:43:24	2018-10-08	8
10944	2	3666	2018-10-08 10:43:25	2018-10-08	8
10945	3	3666	2018-10-08 10:43:26	2018-10-08	8
10946	1	3667	2018-10-08 10:42:38	2018-10-08	8
10947	2	3667	2018-10-08 10:42:39	2018-10-08	8
10948	3	3667	2018-10-08 10:42:40	2018-10-08	8
10949	1	3668	2018-10-08 10:46:02	2018-10-08	8
10950	2	3668	2018-10-08 10:46:03	2018-10-08	8
10951	3	3668	2018-10-08 10:46:04	2018-10-08	8
10952	1	3669	2018-10-08 10:40:59	2018-10-08	8
10953	2	3669	2018-10-08 10:41:00	2018-10-08	8
10954	3	3669	2018-10-08 10:41:01	2018-10-08	8
10955	1	3670	2018-10-08 10:40:09	2018-10-08	8
10956	2	3670	2018-10-08 10:40:10	2018-10-08	8
10957	3	3670	2018-10-08 10:40:11	2018-10-08	8
10958	1	3671	2018-10-08 10:35:46	2018-10-08	8
10959	2	3671	2018-10-08 10:35:47	2018-10-08	8
10960	3	3671	2018-10-08 10:35:48	2018-10-08	8
10961	1	3672	2018-10-08 10:33:15	2018-10-08	8
10962	2	3672	2018-10-08 10:33:16	2018-10-08	8
10963	3	3672	2018-10-08 10:33:17	2018-10-08	8
10964	1	3673	2018-10-08 10:32:52	2018-10-08	8
10965	2	3673	2018-10-08 10:32:53	2018-10-08	8
10966	3	3673	2018-10-08 10:32:54	2018-10-08	8
10967	1	3674	2018-10-08 10:31:55	2018-10-08	8
10968	2	3674	2018-10-08 10:31:57	2018-10-08	8
10969	3	3674	2018-10-10 11:08:13	2018-10-10	9
10970	1	3675	2018-10-08 10:29:51	2018-10-08	8
10971	2	3675	2018-10-08 10:29:52	2018-10-08	8
10972	3	3675	2018-10-08 10:29:54	2018-10-08	8
10973	1	3676	2018-10-08 10:29:55	2018-10-08	8
10974	2	3676	2018-10-08 10:29:56	2018-10-08	8
10975	3	3676	2018-10-08 10:29:57	2018-10-08	8
10976	1	3677	2018-10-08 10:31:33	2018-10-08	8
10977	2	3677	2018-10-08 10:31:34	2018-10-08	8
10978	3	3677	2018-10-08 14:48:40	2018-10-08	12
10979	1	3678	2018-10-08 10:28:55	2018-10-08	8
10980	2	3678	2018-10-08 10:28:56	2018-10-08	8
10981	3	3678	2018-10-08 10:28:57	2018-10-08	8
10982	1	3679	2018-10-08 10:24:17	2018-10-08	8
10983	2	3679	2018-10-08 10:24:18	2018-10-08	8
10984	3	3679	2018-10-08 10:24:19	2018-10-08	8
10985	1	3680	2018-10-08 10:21:55	2018-10-08	8
10986	2	3680	2018-10-08 10:21:56	2018-10-08	8
10987	3	3680	2018-10-08 10:21:57	2018-10-08	8
10988	1	3681	2018-10-08 10:21:05	2018-10-08	8
10989	2	3681	2018-10-08 10:21:06	2018-10-08	8
10990	3	3681	2018-10-08 10:21:07	2018-10-08	8
10991	1	3682	2018-10-08 10:15:11	2018-10-08	8
10992	2	3682	2018-10-08 10:15:12	2018-10-08	8
10993	3	3682	2018-10-08 10:15:13	2018-10-08	8
10994	1	3683	2018-10-08 10:14:25	2018-10-08	8
10995	2	3683	2018-10-08 10:14:26	2018-10-08	8
10996	3	3683	2018-10-08 10:14:27	2018-10-08	8
10997	1	3684	2018-10-08 10:14:33	2018-10-08	8
10998	2	3684	2018-10-08 10:14:34	2018-10-08	8
10999	3	3684	2018-10-08 10:14:35	2018-10-08	8
11000	1	3685	2018-10-08 10:12:23	2018-10-08	8
11001	2	3685	2018-10-08 10:12:24	2018-10-08	8
11002	3	3685	2018-10-08 10:12:25	2018-10-08	8
11003	1	3686	2018-10-08 10:13:03	2018-10-08	8
11004	2	3686	2018-10-08 10:13:04	2018-10-08	8
11005	3	3686	2018-10-08 10:19:20	2018-10-08	8
11006	1	3687	2018-10-08 10:09:29	2018-10-08	8
11007	2	3687	2018-10-08 10:09:30	2018-10-08	8
11008	3	3687	2018-10-08 10:09:31	2018-10-08	8
11009	1	3688	2018-10-08 10:02:41	2018-10-08	8
11010	2	3688	2018-10-08 10:02:42	2018-10-08	8
11011	3	3688	2018-10-08 10:02:43	2018-10-08	8
11012	1	3689	2018-10-08 10:01:12	2018-10-08	8
11013	2	3689	2018-10-08 10:01:13	2018-10-08	8
11014	3	3689	2018-10-08 10:01:14	2018-10-08	8
11015	1	3690	2018-10-08 09:59:00	2018-10-08	7
11016	2	3690	2018-10-08 09:59:01	2018-10-08	7
11017	3	3690	2018-10-08 09:59:02	2018-10-08	7
11018	1	3691	2018-10-08 09:53:55	2018-10-08	7
11019	2	3691	2018-10-08 09:53:56	2018-10-08	7
11020	3	3691	2018-10-08 09:53:57	2018-10-08	7
11021	1	3692	2018-10-08 09:51:41	2018-10-08	7
11022	2	3692	2018-10-08 09:51:42	2018-10-08	7
11023	3	3692	2018-10-08 09:51:43	2018-10-08	7
11024	1	3693	2018-10-08 09:51:03	2018-10-08	7
11025	2	3693	2018-10-08 09:51:04	2018-10-08	7
11026	3	3693	2018-10-08 09:51:05	2018-10-08	7
11027	1	3694	2018-10-08 09:51:02	2018-10-08	7
11028	2	3694	2018-10-08 09:51:03	2018-10-08	7
11029	3	3694	2018-10-08 09:51:04	2018-10-08	7
11030	1	3695	2018-10-08 09:51:23	2018-10-08	7
11031	2	3695	2018-10-08 09:51:24	2018-10-08	7
11032	3	3695	2018-10-08 09:51:25	2018-10-08	7
11033	1	3696	2018-10-08 09:50:04	2018-10-08	7
11034	2	3696	2018-10-08 09:50:05	2018-10-08	7
11035	3	3696	2018-10-08 09:50:06	2018-10-08	7
11036	1	3697	2018-10-08 09:50:17	2018-10-08	7
11037	2	3697	2018-10-08 09:50:19	2018-10-08	7
11038	3	3697	2018-10-08 11:15:13	2018-10-08	9
11039	1	3698	2018-10-08 09:48:33	2018-10-08	7
11040	2	3698	2018-10-08 09:48:34	2018-10-08	7
11041	3	3698	2018-10-08 09:48:35	2018-10-08	7
11042	1	3699	2018-10-08 09:45:46	2018-10-08	7
11043	2	3699	2018-10-08 09:45:47	2018-10-08	7
11044	3	3699	2018-10-08 09:45:48	2018-10-08	7
11045	1	3700	2018-10-08 09:45:16	2018-10-08	7
11046	2	3700	2018-10-08 09:45:17	2018-10-08	7
11047	3	3700	2018-10-08 09:45:18	2018-10-08	7
11048	1	3701	2018-10-08 09:46:08	2018-10-08	7
11049	2	3701	2018-10-08 09:46:09	2018-10-08	7
11050	3	3701	2018-10-08 09:46:10	2018-10-08	7
11051	1	3702	2018-10-08 09:43:01	2018-10-08	7
11052	2	3702	2018-10-08 09:43:02	2018-10-08	7
11053	3	3702	2018-10-08 09:43:03	2018-10-08	7
11054	1	3703	2018-10-08 09:42:20	2018-10-08	7
11055	2	3703	2018-10-08 09:42:21	2018-10-08	7
11056	3	3703	2018-10-08 09:42:22	2018-10-08	7
11057	1	3704	2018-10-08 09:37:11	2018-10-08	7
11058	2	3704	2018-10-08 09:37:13	2018-10-08	7
11059	3	3704	2018-10-09 12:11:34	2018-10-09	10
11060	1	3705	2018-10-08 09:34:04	2018-10-08	7
11061	2	3705	2018-10-08 09:34:06	2018-10-08	7
11062	3	3705	2018-11-06 12:15:24	2018-11-06	11
11063	1	3706	2018-10-08 09:30:49	2018-10-08	7
11064	2	3706	2018-10-08 09:30:50	2018-10-08	7
11065	3	3706	2018-10-08 09:30:51	2018-10-08	7
11066	1	3707	2018-10-08 09:29:28	2018-10-08	7
11067	2	3707	2018-10-08 09:29:29	2018-10-08	7
11068	3	3707	2018-10-08 09:29:30	2018-10-08	7
11069	1	3708	2018-10-08 09:27:25	2018-10-08	7
11070	2	3708	2018-10-08 09:27:26	2018-10-08	7
11071	3	3708	2018-10-08 09:27:27	2018-10-08	7
11072	1	3709	2018-10-08 09:25:44	2018-10-08	7
11073	2	3709	2018-10-08 09:25:45	2018-10-08	7
11074	3	3709	2018-10-08 09:25:46	2018-10-08	7
11075	1	3710	2018-10-08 09:23:55	2018-10-08	7
11076	2	3710	2018-10-08 09:23:56	2018-10-08	7
11077	3	3710	2018-10-08 09:23:57	2018-10-08	7
11078	1	3711	2018-10-08 09:17:08	2018-10-08	7
11079	2	3711	2018-10-08 09:17:09	2018-10-08	7
11080	3	3711	2018-10-08 09:17:10	2018-10-08	7
11081	1	3712	2018-10-08 09:18:25	2018-10-08	7
11082	2	3712	2018-10-08 09:18:26	2018-10-08	7
11083	3	3712	2018-10-08 09:18:40	2018-10-08	7
11084	1	3713	2018-10-08 09:15:10	2018-10-08	7
11085	2	3713	2018-10-08 09:15:11	2018-10-08	7
11086	3	3713	2018-10-08 09:15:12	2018-10-08	7
11087	1	3714	2018-10-08 09:13:55	2018-10-08	7
11088	2	3714	2018-10-08 09:13:56	2018-10-08	7
11089	3	3714	2018-10-08 09:13:57	2018-10-08	7
11090	1	3715	2018-10-08 09:12:21	2018-10-08	7
11091	2	3715	2018-10-08 09:12:22	2018-10-08	7
11092	3	3715	2018-10-08 09:12:23	2018-10-08	7
11093	1	3716	2018-10-08 09:09:31	2018-10-08	7
11094	2	3716	2018-10-08 09:09:32	2018-10-08	7
11095	3	3716	2018-10-08 09:09:33	2018-10-08	7
11096	1	3717	2018-10-08 09:09:31	2018-10-08	7
11097	2	3717	2018-10-08 09:09:33	2018-10-08	7
11098	3	3717	2018-10-08 09:11:01	2018-10-08	7
11099	1	3718	2018-10-08 09:07:31	2018-10-08	7
11100	2	3718	2018-10-08 09:07:32	2018-10-08	7
11101	3	3718	2018-10-08 09:07:33	2018-10-08	7
11102	1	3719	2018-10-08 09:07:21	2018-10-08	7
11103	2	3719	2018-10-08 09:07:22	2018-10-08	7
11104	3	3719	2018-10-08 09:07:23	2018-10-08	7
11105	1	3720	2018-10-08 09:05:54	2018-10-08	7
11106	2	3720	2018-10-08 09:05:56	2018-10-08	7
11107	3	3720	2018-10-08 09:05:57	2018-10-08	7
11108	1	3721	2018-10-08 09:04:55	2018-10-08	7
11109	2	3721	2018-10-08 09:04:57	2018-10-08	7
11110	3	3721	2018-10-08 09:06:31	2018-10-08	7
11111	1	3722	2018-10-08 09:04:22	2018-10-08	7
11112	2	3722	2018-10-08 09:04:23	2018-10-08	7
11113	3	3722	2018-10-08 09:04:24	2018-10-08	7
11114	1	3723	2018-10-08 09:06:10	2018-10-08	7
11115	2	3723	2018-10-08 09:06:12	2018-10-08	7
11116	3	3723	2018-10-08 09:29:40	2018-10-08	7
11117	1	3724	2018-10-08 09:02:36	2018-10-08	7
11118	2	3724	2018-10-08 09:02:37	2018-10-08	7
11119	3	3724	2018-10-08 09:02:38	2018-10-08	7
11120	1	3725	2018-10-08 08:59:46	2018-10-08	6
11121	2	3725	2018-10-08 08:59:47	2018-10-08	6
11122	3	3725	2018-10-08 08:59:48	2018-10-08	6
11123	1	3726	2018-10-08 08:54:23	2018-10-08	6
11124	2	3726	2018-10-08 08:54:24	2018-10-08	6
11125	3	3726	2018-10-08 08:54:25	2018-10-08	6
11126	1	3727	2018-10-08 08:44:41	2018-10-08	6
11127	2	3727	2018-10-08 08:44:43	2018-10-08	6
11128	3	3727	2018-10-11 10:19:16	2018-10-11	8
11129	1	3728	2018-10-08 08:41:16	2018-10-08	6
11130	2	3728	2018-10-08 08:41:16	2018-10-08	6
11131	3	3728	2018-10-09 12:00:40	2018-10-09	10
11132	1	3729	2018-10-08 08:40:20	2018-10-08	6
11133	2	3729	2018-10-08 08:40:21	2018-10-08	6
11134	3	3729	2018-10-08 08:40:22	2018-10-08	6
11135	1	3730	2018-10-08 08:39:50	2018-10-08	6
11136	2	3730	2018-10-08 08:39:51	2018-10-08	6
11137	3	3730	2018-10-08 08:39:52	2018-10-08	6
11138	1	3731	2018-10-08 08:37:14	2018-10-08	6
11139	2	3731	2018-10-08 08:37:15	2018-10-08	6
11140	3	3731	2018-10-08 08:37:16	2018-10-08	6
11141	1	3732	2018-10-08 08:34:18	2018-10-08	6
11142	2	3732	2018-10-08 08:34:19	2018-10-08	6
11143	3	3732	2018-10-08 08:34:20	2018-10-08	6
11144	1	3733	2018-10-08 08:36:02	2018-10-08	6
11145	2	3733	2018-10-08 08:36:04	2018-10-08	6
11146	3	3733	2018-10-08 08:38:21	2018-10-08	6
11147	1	3734	2018-10-08 08:33:40	2018-10-08	6
11148	2	3734	2018-10-08 08:33:41	2018-10-08	6
11149	3	3734	2018-10-08 08:33:42	2018-10-08	6
11150	1	3735	2018-10-08 08:44:58	2018-10-08	6
11151	2	3735	2018-10-08 08:45:00	2018-10-08	6
11152	3	3735	2018-10-08 10:02:55	2018-10-08	8
11153	1	3736	2018-10-08 08:27:58	2018-10-08	6
11154	2	3736	2018-10-08 08:27:59	2018-10-08	6
11155	3	3736	2018-10-08 08:28:08	2018-10-08	6
11156	1	3737	2018-10-08 08:24:45	2018-10-08	6
11157	2	3737	2018-10-08 08:24:46	2018-10-08	6
11158	3	3737	2018-10-08 08:25:17	2018-10-08	6
11159	1	3738	2018-10-08 08:21:01	2018-10-08	6
11160	2	3738	2018-10-08 08:21:03	2018-10-08	6
11161	3	3738	2018-10-08 13:23:13	2018-10-08	11
11162	1	3739	2018-10-08 07:58:07	2018-10-08	5
11163	2	3739	2018-10-08 07:58:08	2018-10-08	5
11164	3	3739	2018-10-09 12:05:45	2018-10-09	10
11165	1	3740	2018-10-08 07:53:12	2018-10-08	5
11166	2	3740	2018-10-08 07:53:13	2018-10-08	5
11167	3	3740	2018-10-09 11:58:01	2018-10-09	9
11168	1	3741	2018-10-08 07:43:29	2018-10-08	5
11169	2	3741	2018-10-08 07:43:30	2018-10-08	5
11170	3	3741	2018-10-08 08:37:20	2018-10-08	6
11171	1	3742	2018-10-08 07:39:18	2018-10-08	5
11172	2	3742	2018-10-08 07:39:20	2018-10-08	5
11173	3	3742	2018-10-10 09:16:16	2018-10-10	7
11174	1	3743	2018-10-05 17:46:58	2018-10-05	15
11175	2	3743	2018-10-05 17:47:02	2018-10-05	15
11176	3	3743	2018-10-05 17:51:28	2018-10-05	15
11177	2	3744	2018-10-05 12:08:09	2018-10-05	10
11178	3	3744	2018-10-05 13:03:03	2018-10-05	11
11179	1	3745	2018-10-08 12:17:29	2018-10-08	10
11180	2	3745	2018-10-08 12:17:31	2018-10-08	10
11181	3	3745	2018-10-08 12:17:32	2018-10-08	10
11182	2	3746	2018-10-05 11:59:25	2018-10-05	9
11183	3	3746	2018-10-05 13:06:26	2018-10-05	11
11184	2	3747	2018-10-05 11:54:55	2018-10-05	9
11185	3	3747	2018-10-11 17:25:39	2018-10-11	15
11186	2	3748	2018-10-05 11:53:24	2018-10-05	9
11187	3	3748	2018-10-23 11:31:30	2018-10-23	9
11188	2	3749	2018-10-05 11:49:03	2018-10-05	9
11189	3	3749	2018-10-11 17:25:27	2018-10-11	15
11190	2	3750	2018-10-05 11:13:55	2018-10-05	9
11191	3	3750	2018-10-05 11:13:57	2018-10-05	9
11192	2	3751	2018-10-05 11:13:38	2018-10-05	9
11193	3	3751	2018-10-05 11:13:39	2018-10-05	9
11194	2	3752	2018-10-05 11:13:15	2018-10-05	9
11195	3	3752	2018-10-05 11:13:17	2018-10-05	9
11196	2	3753	2018-10-05 11:12:42	2018-10-05	9
11197	3	3753	2018-10-05 11:12:43	2018-10-05	9
11198	2	3754	2018-10-05 11:10:49	2018-10-05	9
11199	3	3754	2018-10-05 11:10:51	2018-10-05	9
11200	2	3755	2018-10-05 11:10:09	2018-10-05	9
11201	3	3755	2018-10-05 11:10:11	2018-10-05	9
11202	2	3756	2018-10-05 11:04:45	2018-10-05	9
11203	3	3756	2018-10-05 11:04:47	2018-10-05	9
11204	2	3757	2018-10-05 11:03:33	2018-10-05	9
11205	3	3757	2018-10-05 11:03:35	2018-10-05	9
11206	2	3758	2018-10-05 11:03:10	2018-10-05	9
11207	3	3758	2018-10-05 11:03:12	2018-10-05	9
11208	2	3759	2018-10-05 11:01:46	2018-10-05	9
11209	3	3759	2018-10-05 11:01:48	2018-10-05	9
11210	2	3760	2018-10-05 10:55:08	2018-10-05	8
11211	3	3760	2018-10-05 10:55:10	2018-10-05	8
11212	2	3761	2018-10-05 10:55:43	2018-10-05	8
11213	3	3761	2018-10-11 17:25:12	2018-10-11	15
11214	2	3762	2018-10-05 10:51:10	2018-10-05	8
11215	3	3762	2018-10-05 14:21:41	2018-10-05	12
11216	2	3763	2018-10-05 10:50:13	2018-10-05	8
11217	3	3763	2018-10-05 10:50:15	2018-10-05	8
11218	2	3764	2018-10-05 10:59:21	2018-10-05	8
11219	3	3764	2018-10-15 11:06:03	2018-10-15	9
11220	2	3765	2018-10-05 10:49:57	2018-10-05	8
11221	3	3765	2018-10-05 10:49:59	2018-10-05	8
11222	2	3766	2018-10-05 10:48:35	2018-10-05	8
11223	3	3766	2018-10-05 10:48:36	2018-10-05	8
11224	2	3767	2018-10-05 10:46:12	2018-10-05	8
11225	3	3767	2018-10-05 10:46:14	2018-10-05	8
11226	2	3768	2018-10-05 10:44:27	2018-10-05	8
11227	3	3768	2018-10-05 10:44:29	2018-10-05	8
11228	2	3769	2018-10-05 10:43:50	2018-10-05	8
11229	3	3769	2018-10-05 10:43:52	2018-10-05	8
11230	2	3770	2018-10-05 10:44:27	2018-10-05	8
11231	3	3770	2018-10-05 10:44:29	2018-10-05	8
11232	2	3771	2018-10-05 10:39:25	2018-10-05	8
11233	3	3771	2018-10-05 10:39:26	2018-10-05	8
11234	2	3772	2018-10-05 10:36:51	2018-10-05	8
11235	3	3772	2018-10-05 10:36:53	2018-10-05	8
11236	2	3773	2018-10-05 10:36:36	2018-10-05	8
11237	3	3773	2018-10-05 10:36:38	2018-10-05	8
11238	2	3774	2018-10-05 10:35:44	2018-10-05	8
11239	3	3774	2018-10-05 10:35:46	2018-10-05	8
11240	2	3775	2018-10-05 10:35:48	2018-10-05	8
11241	3	3775	2018-10-05 10:35:50	2018-10-05	8
11242	2	3776	2018-10-05 10:36:55	2018-10-05	8
11243	3	3776	2018-10-05 10:37:34	2018-10-05	8
11244	2	3777	2018-10-05 10:34:49	2018-10-05	8
11245	3	3777	2018-10-05 10:34:51	2018-10-05	8
11246	2	3778	2018-10-05 10:31:22	2018-10-05	8
11247	3	3778	2018-10-05 10:31:24	2018-10-05	8
11248	2	3779	2018-10-05 10:30:27	2018-10-05	8
11249	3	3779	2018-10-05 10:30:29	2018-10-05	8
11250	2	3780	2018-10-05 10:29:26	2018-10-05	8
11251	3	3780	2018-10-05 10:29:27	2018-10-05	8
11252	2	3781	2018-10-05 10:29:05	2018-10-05	8
11253	3	3781	2018-10-05 10:29:07	2018-10-05	8
11254	2	3782	2018-10-05 10:25:44	2018-10-05	8
11255	3	3782	2018-10-05 10:25:46	2018-10-05	8
11256	2	3783	2018-10-05 10:25:31	2018-10-05	8
11257	3	3783	2018-10-05 10:25:33	2018-10-05	8
11258	2	3784	2018-10-05 10:26:33	2018-10-05	8
11259	3	3784	2018-10-05 10:26:35	2018-10-05	8
11260	2	3785	2018-10-05 10:24:35	2018-10-05	8
11261	3	3785	2018-10-05 10:24:37	2018-10-05	8
11262	2	3786	2018-10-05 10:22:53	2018-10-05	8
11263	3	3786	2018-10-05 10:22:55	2018-10-05	8
11264	2	3787	2018-10-05 10:22:19	2018-10-05	8
11265	3	3787	2018-10-05 10:22:20	2018-10-05	8
11266	2	3788	2018-10-05 10:23:54	2018-10-05	8
11267	3	3788	2018-10-05 10:23:55	2018-10-05	8
11268	2	3789	2018-10-05 10:19:07	2018-10-05	8
11269	3	3789	2018-10-05 10:19:09	2018-10-05	8
11270	2	3790	2018-10-05 10:18:23	2018-10-05	8
11271	3	3790	2018-10-05 10:18:25	2018-10-05	8
11272	2	3791	2018-10-05 10:14:24	2018-10-05	8
11273	3	3791	2018-10-05 10:14:26	2018-10-05	8
11274	2	3792	2018-10-05 10:12:15	2018-10-05	8
11275	3	3792	2018-10-05 10:12:17	2018-10-05	8
11276	2	3793	2018-10-05 10:11:15	2018-10-05	8
11277	3	3793	2018-10-05 10:11:17	2018-10-05	8
11278	2	3794	2018-10-05 10:10:32	2018-10-05	8
11279	3	3794	2018-10-05 10:10:34	2018-10-05	8
11280	2	3795	2018-10-05 10:07:58	2018-10-05	8
11281	3	3795	2018-10-05 10:08:00	2018-10-05	8
11282	2	3796	2018-10-05 10:06:55	2018-10-05	8
11283	3	3796	2018-10-05 10:06:57	2018-10-05	8
11284	2	3797	2018-10-05 10:06:43	2018-10-05	8
11285	3	3797	2018-10-05 10:06:44	2018-10-05	8
11286	2	3798	2018-10-05 10:05:38	2018-10-05	8
11287	3	3798	2018-10-05 10:05:40	2018-10-05	8
11288	2	3799	2018-10-05 10:03:55	2018-10-05	8
11289	3	3799	2018-10-05 10:03:57	2018-10-05	8
11290	2	3800	2018-10-05 10:04:46	2018-10-05	8
11291	3	3800	2018-10-11 11:26:08	2018-10-11	9
11292	2	3801	2018-10-05 10:04:57	2018-10-05	8
11293	3	3801	2018-10-05 11:26:38	2018-10-05	9
11294	2	3802	2018-10-05 09:57:20	2018-10-05	7
11295	3	3802	2018-10-05 09:57:22	2018-10-05	7
11296	2	3803	2018-10-05 09:54:42	2018-10-05	7
11297	3	3803	2018-10-05 09:54:44	2018-10-05	7
11298	2	3804	2018-10-05 09:51:59	2018-10-05	7
11299	3	3804	2018-10-05 09:52:01	2018-10-05	7
11300	2	3805	2018-10-05 09:49:26	2018-10-05	7
11301	3	3805	2018-10-05 09:49:28	2018-10-05	7
11302	2	3806	2018-10-05 09:46:35	2018-10-05	7
11303	3	3806	2018-10-05 09:46:37	2018-10-05	7
11304	2	3807	2018-10-05 09:45:02	2018-10-05	7
11305	3	3807	2018-10-05 09:45:04	2018-10-05	7
11306	2	3808	2018-10-05 09:45:00	2018-10-05	7
11307	3	3808	2018-10-05 09:45:02	2018-10-05	7
11308	2	3809	2018-10-05 09:43:44	2018-10-05	7
11309	3	3809	2018-10-05 09:43:46	2018-10-05	7
11310	2	3810	2018-10-05 09:41:54	2018-10-05	7
11311	3	3810	2018-10-05 09:41:56	2018-10-05	7
11312	2	3811	2018-10-05 09:40:03	2018-10-05	7
11313	3	3811	2018-10-05 09:40:05	2018-10-05	7
11314	2	3812	2018-10-05 09:30:44	2018-10-05	7
11315	3	3812	2018-10-05 09:30:46	2018-10-05	7
11316	2	3813	2018-10-05 09:30:12	2018-10-05	7
11317	3	3813	2018-10-05 09:30:14	2018-10-05	7
11318	2	3814	2018-10-05 09:29:22	2018-10-05	7
11319	3	3814	2018-10-05 09:29:24	2018-10-05	7
11320	2	3815	2018-10-05 09:28:02	2018-10-05	7
11321	3	3815	2018-10-05 09:28:03	2018-10-05	7
11322	2	3816	2018-10-05 09:26:14	2018-10-05	7
11323	3	3816	2018-10-05 09:26:15	2018-10-05	7
11324	2	3817	2018-10-05 09:25:41	2018-10-05	7
11325	3	3817	2018-10-05 09:25:43	2018-10-05	7
11326	2	3818	2018-10-05 09:25:02	2018-10-05	7
11327	3	3818	2018-10-05 09:25:04	2018-10-05	7
11328	2	3819	2018-10-05 09:23:44	2018-10-05	7
11329	3	3819	2018-10-05 09:23:46	2018-10-05	7
11330	2	3820	2018-10-05 09:22:33	2018-10-05	7
11331	3	3820	2018-10-05 09:22:35	2018-10-05	7
11332	2	3821	2018-10-05 09:17:12	2018-10-05	7
11333	3	3821	2018-10-05 09:17:14	2018-10-05	7
11334	2	3822	2018-10-05 09:17:16	2018-10-05	7
11335	3	3822	2018-10-05 09:17:18	2018-10-05	7
11336	2	3823	2018-10-05 09:16:48	2018-10-05	7
11337	3	3823	2018-10-05 09:16:49	2018-10-05	7
11338	2	3824	2018-10-05 09:14:40	2018-10-05	7
11339	3	3824	2018-10-05 09:14:42	2018-10-05	7
11340	2	3825	2018-10-05 09:14:40	2018-10-05	7
11341	3	3825	2018-10-05 09:14:42	2018-10-05	7
11342	2	3826	2018-10-05 09:14:07	2018-10-05	7
11343	3	3826	2018-10-05 09:14:09	2018-10-05	7
11344	2	3827	2018-10-05 09:12:57	2018-10-05	7
11345	3	3827	2018-10-05 09:12:59	2018-10-05	7
11346	2	3828	2018-10-05 09:12:44	2018-10-05	7
11347	3	3828	2018-10-05 09:12:46	2018-10-05	7
11348	2	3829	2018-10-05 09:09:36	2018-10-05	7
11349	3	3829	2018-10-05 09:09:38	2018-10-05	7
11350	2	3830	2018-10-05 09:09:03	2018-10-05	7
11351	3	3830	2018-10-05 09:09:05	2018-10-05	7
11352	2	3831	2018-10-05 09:09:05	2018-10-05	7
11353	3	3831	2018-10-05 09:09:07	2018-10-05	7
11354	2	3832	2018-10-05 09:09:07	2018-10-05	7
11355	3	3832	2018-10-05 09:09:09	2018-10-05	7
11356	2	3833	2018-10-05 09:07:05	2018-10-05	7
11357	3	3833	2018-10-05 09:07:07	2018-10-05	7
11358	2	3834	2018-10-05 09:03:08	2018-10-05	7
11359	3	3834	2018-10-05 09:03:10	2018-10-05	7
11360	2	3835	2018-10-05 09:02:44	2018-10-05	7
11361	3	3835	2018-10-05 09:02:46	2018-10-05	7
11362	2	3836	2018-10-05 09:01:36	2018-10-05	7
11363	3	3836	2018-10-05 09:01:38	2018-10-05	7
11364	2	3837	2018-10-05 09:01:38	2018-10-05	7
11365	3	3837	2018-10-05 09:01:40	2018-10-05	7
11366	2	3838	2018-10-05 09:01:29	2018-10-05	7
11367	3	3838	2018-10-05 09:01:32	2018-10-05	7
11368	2	3839	2018-10-05 09:00:10	2018-10-05	7
11369	3	3839	2018-10-05 09:00:12	2018-10-05	7
11370	2	3840	2018-10-05 08:58:46	2018-10-05	6
11371	3	3840	2018-10-05 08:58:48	2018-10-05	6
11372	2	3841	2018-10-05 09:00:54	2018-10-05	7
11373	3	3841	2018-10-05 09:00:56	2018-10-05	7
11374	2	3842	2018-10-05 08:56:44	2018-10-05	6
11375	3	3842	2018-10-05 08:56:46	2018-10-05	6
11376	2	3843	2018-10-05 08:57:51	2018-10-05	6
11377	3	3843	2018-10-05 09:57:47	2018-10-05	7
11378	2	3844	2018-10-05 08:49:32	2018-10-05	6
11379	3	3844	2018-10-05 08:49:34	2018-10-05	6
11380	2	3845	2018-10-05 08:51:10	2018-10-05	6
11381	3	3845	2018-10-05 10:15:12	2018-10-05	8
11382	2	3846	2018-10-05 08:43:49	2018-10-05	6
11383	3	3846	2018-10-05 08:43:50	2018-10-05	6
11384	2	3847	2018-10-05 08:39:56	2018-10-05	6
11385	3	3847	2018-10-05 08:39:58	2018-10-05	6
11386	2	3848	2018-10-05 08:39:32	2018-10-05	6
11387	3	3848	2018-10-05 08:39:34	2018-10-05	6
11388	2	3849	2018-10-05 07:49:06	2018-10-05	5
11389	1	3849	2018-10-10 14:35:09	2018-10-10	12
11390	2	3849	2018-10-10 14:35:11	2018-10-10	12
11391	3	3849	2018-10-10 15:17:39	2018-10-10	13
11392	2	3850	2018-10-04 16:51:06	2018-10-04	14
11393	3	3850	2018-10-04 16:51:08	2018-10-04	14
11394	2	3851	2018-10-04 16:49:22	2018-10-04	14
11395	3	3851	2018-10-04 16:49:24	2018-10-04	14
11396	2	3852	2018-10-04 16:45:28	2018-10-04	14
11397	3	3852	2018-10-16 09:58:31	2018-10-16	7
11398	2	3853	2018-10-04 16:36:48	2018-10-04	14
11399	3	3853	2018-10-04 16:36:50	2018-10-04	14
11400	2	3854	2018-10-04 16:27:07	2018-10-04	14
11401	3	3854	2018-10-04 16:27:08	2018-10-04	14
11402	2	3855	2018-10-04 16:24:32	2018-10-04	14
11403	3	3855	2018-10-04 16:24:34	2018-10-04	14
11404	2	3856	2018-10-04 16:21:49	2018-10-04	14
11405	3	3856	2018-10-04 16:21:51	2018-10-04	14
11406	2	3857	2018-10-04 16:19:39	2018-10-04	14
11407	3	3857	2018-10-04 16:19:41	2018-10-04	14
11408	2	3858	2018-10-04 16:16:42	2018-10-04	14
11409	3	3858	2018-10-04 16:16:44	2018-10-04	14
11410	2	3859	2018-10-04 16:16:07	2018-10-04	14
11411	1	3859	2018-10-08 15:19:07	2018-10-08	13
11412	2	3859	2018-10-08 15:19:08	2018-10-08	13
11413	3	3859	2018-10-08 16:17:12	2018-10-08	14
11414	2	3860	2018-10-04 16:10:22	2018-10-04	14
11415	3	3860	2018-10-04 16:10:24	2018-10-04	14
11416	2	3861	2018-10-04 16:10:00	2018-10-04	14
11417	3	3861	2018-10-04 16:10:03	2018-10-04	14
11418	2	3862	2018-10-04 16:04:38	2018-10-04	14
11419	3	3862	2018-10-04 16:04:40	2018-10-04	14
11420	2	3863	2018-10-04 16:03:39	2018-10-04	14
11421	3	3863	2018-10-04 16:03:41	2018-10-04	14
11422	2	3864	2018-10-04 15:52:40	2018-10-04	13
11423	3	3864	2018-10-04 15:52:42	2018-10-04	13
11424	2	3865	2018-10-04 15:50:50	2018-10-04	13
11425	3	3865	2018-10-04 15:50:52	2018-10-04	13
11426	2	3866	2018-10-04 15:47:51	2018-10-04	13
11427	3	3866	2018-10-04 15:47:53	2018-10-04	13
11428	2	3867	2018-10-04 15:46:37	2018-10-04	13
11429	3	3867	2018-10-04 15:46:39	2018-10-04	13
11430	2	3868	2018-10-04 15:45:43	2018-10-04	13
11431	3	3868	2018-10-04 15:45:45	2018-10-04	13
11432	2	3869	2018-10-04 15:44:57	2018-10-04	13
11433	3	3869	2018-10-04 15:44:59	2018-10-04	13
11434	2	3870	2018-10-04 15:31:32	2018-10-04	13
11435	3	3870	2018-10-04 15:31:33	2018-10-04	13
11436	2	3871	2018-10-04 15:30:47	2018-10-04	13
11437	3	3871	2018-10-04 15:30:49	2018-10-04	13
11438	2	3872	2018-10-04 15:25:50	2018-10-04	13
11439	3	3872	2018-10-04 15:25:52	2018-10-04	13
11440	2	3873	2018-10-04 15:24:43	2018-10-04	13
11441	3	3873	2018-10-04 15:24:44	2018-10-04	13
11442	2	3874	2018-10-04 15:24:14	2018-10-04	13
11443	3	3874	2018-10-04 15:24:15	2018-10-04	13
11444	2	3875	2018-10-04 15:12:03	2018-10-04	13
11445	3	3875	2018-10-04 15:12:05	2018-10-04	13
11446	2	3876	2018-10-04 15:11:13	2018-10-04	13
11447	3	3876	2018-10-04 15:11:15	2018-10-04	13
11448	2	3877	2018-10-04 15:09:54	2018-10-04	13
11449	3	3877	2018-10-04 15:09:55	2018-10-04	13
11450	2	3878	2018-10-04 15:08:46	2018-10-04	13
11451	3	3878	2018-10-04 15:08:55	2018-10-04	13
11452	2	3879	2018-10-04 15:06:46	2018-10-04	13
11453	3	3879	2018-10-04 15:06:48	2018-10-04	13
11454	2	3880	2018-10-04 15:06:09	2018-10-04	13
11455	3	3880	2018-10-04 15:06:11	2018-10-04	13
11456	2	3881	2018-10-04 15:03:00	2018-10-04	13
11457	3	3881	2018-10-04 15:03:01	2018-10-04	13
11458	2	3882	2018-10-04 14:59:00	2018-10-04	12
11459	3	3882	2018-10-04 14:59:02	2018-10-04	12
11460	2	3883	2018-10-04 15:01:51	2018-10-04	13
11461	3	3883	2018-10-11 11:51:24	2018-10-11	9
11462	2	3884	2018-10-04 14:55:05	2018-10-04	12
11463	3	3884	2018-10-04 14:55:07	2018-10-04	12
11464	2	3885	2018-10-04 14:54:42	2018-10-04	12
11465	3	3885	2018-10-04 14:54:44	2018-10-04	12
11466	2	3886	2018-10-04 14:54:31	2018-10-04	12
11467	3	3886	2018-10-04 14:54:33	2018-10-04	12
11468	2	3887	2018-10-04 14:52:12	2018-10-04	12
11469	3	3887	2018-10-05 08:20:24	2018-10-05	6
11470	2	3888	2018-10-04 14:52:18	2018-10-04	12
11471	3	3888	2018-10-04 14:52:20	2018-10-04	12
11472	2	3889	2018-10-04 14:49:50	2018-10-04	12
11473	3	3889	2018-10-04 14:49:52	2018-10-04	12
11474	2	3890	2018-10-04 14:49:27	2018-10-04	12
11475	3	3890	2018-10-04 14:49:29	2018-10-04	12
11476	2	3891	2018-10-04 14:48:50	2018-10-04	12
11477	1	3891	2018-10-08 15:05:42	2018-10-08	13
11478	2	3891	2018-10-08 15:05:43	2018-10-08	13
11479	3	3891	2018-10-08 15:06:40	2018-10-08	13
11480	2	3892	2018-10-04 14:44:58	2018-10-04	12
11481	3	3892	2018-10-04 14:45:01	2018-10-04	12
11482	2	3893	2018-10-04 14:33:58	2018-10-04	12
11483	3	3893	2018-10-04 14:34:00	2018-10-04	12
11484	2	3894	2018-10-04 14:26:40	2018-10-04	12
11485	3	3894	2018-10-04 14:26:41	2018-10-04	12
11486	2	3895	2018-10-04 14:24:13	2018-10-04	12
11487	3	3895	2018-10-04 14:24:15	2018-10-04	12
11488	2	3896	2018-10-04 14:23:45	2018-10-04	12
11489	3	3896	2018-10-04 14:23:47	2018-10-04	12
11490	2	3897	2018-10-04 14:23:50	2018-10-04	12
11491	3	3897	2018-10-04 14:23:52	2018-10-04	12
11492	2	3898	2018-10-04 14:23:05	2018-10-04	12
11493	3	3898	2018-10-04 14:23:07	2018-10-04	12
11494	2	3899	2018-10-04 14:20:49	2018-10-04	12
11495	1	3899	2018-10-08 15:19:30	2018-10-08	13
11496	2	3899	2018-10-08 15:19:31	2018-10-08	13
11497	3	3899	2018-10-08 15:57:13	2018-10-08	13
11498	2	3900	2018-10-04 14:18:53	2018-10-04	12
11499	3	3900	2018-10-04 14:18:55	2018-10-04	12
11500	2	3901	2018-10-04 14:18:23	2018-10-04	12
11501	3	3901	2018-10-04 14:18:25	2018-10-04	12
11502	2	3902	2018-10-04 14:17:12	2018-10-04	12
11503	3	3902	2018-10-04 14:17:13	2018-10-04	12
11504	2	3903	2018-10-04 14:17:30	2018-10-04	12
11505	3	3903	2018-10-04 14:17:32	2018-10-04	12
11506	2	3904	2018-10-04 14:16:19	2018-10-04	12
11507	3	3904	2018-10-04 14:16:21	2018-10-04	12
11508	2	3905	2018-10-04 14:15:24	2018-10-04	12
11509	3	3905	2018-10-04 14:15:26	2018-10-04	12
11510	2	3906	2018-10-04 14:14:19	2018-10-04	12
11511	3	3906	2018-10-04 14:14:21	2018-10-04	12
11512	2	3907	2018-10-04 14:13:51	2018-10-04	12
11513	3	3907	2018-10-04 14:13:53	2018-10-04	12
11514	2	3908	2018-10-04 14:12:58	2018-10-04	12
11515	3	3908	2018-10-04 14:13:00	2018-10-04	12
11516	2	3909	2018-10-04 14:09:17	2018-10-04	12
11517	3	3909	2018-10-04 14:09:19	2018-10-04	12
11518	2	3910	2018-10-04 14:03:36	2018-10-04	12
11519	3	3910	2018-10-04 14:03:39	2018-10-04	12
11520	2	3911	2018-10-04 14:02:57	2018-10-04	12
11521	3	3911	2018-10-04 14:02:59	2018-10-04	12
11522	2	3912	2018-10-04 14:01:57	2018-10-04	12
11523	3	3912	2018-10-04 14:01:59	2018-10-04	12
11524	2	3913	2018-10-04 13:51:45	2018-10-04	11
11525	3	3913	2018-10-05 08:29:05	2018-10-05	6
11526	2	3914	2018-10-04 13:50:34	2018-10-04	11
11527	3	3914	2018-10-11 17:25:03	2018-10-11	15
11528	2	3915	2018-10-04 12:21:46	2018-10-04	10
11529	3	3915	2018-10-04 12:21:49	2018-10-04	10
11530	2	3916	2018-10-04 12:09:17	2018-10-04	10
11531	3	3916	2018-10-04 12:09:18	2018-10-04	10
11532	2	3917	2018-10-04 12:03:05	2018-10-04	10
11533	1	3917	2018-10-08 15:19:55	2018-10-08	13
11534	2	3917	2018-10-08 15:19:56	2018-10-08	13
11535	3	3917	2018-10-08 15:57:33	2018-10-08	13
11536	2	3918	2018-10-04 11:54:50	2018-10-04	9
11537	3	3918	2018-10-04 11:54:52	2018-10-04	9
11538	2	3919	2018-10-04 11:54:50	2018-10-04	9
11539	3	3919	2018-10-04 11:54:52	2018-10-04	9
11540	2	3920	2018-10-04 11:51:29	2018-10-04	9
11541	3	3920	2018-10-04 12:13:31	2018-10-04	10
11542	2	3921	2018-10-04 11:46:30	2018-10-04	9
11543	3	3921	2018-10-04 11:46:32	2018-10-04	9
11544	2	3922	2018-10-04 11:43:40	2018-10-04	9
11545	3	3922	2018-10-04 11:43:42	2018-10-04	9
11546	2	3923	2018-10-04 11:42:50	2018-10-04	9
11547	3	3923	2018-10-04 11:42:52	2018-10-04	9
11548	2	3924	2018-10-04 11:37:38	2018-10-04	9
11549	3	3924	2018-10-04 11:37:40	2018-10-04	9
11550	2	3925	2018-10-04 11:36:01	2018-10-04	9
11551	3	3925	2018-10-04 11:36:03	2018-10-04	9
11552	2	3926	2018-10-04 11:35:03	2018-10-04	9
11553	3	3926	2018-10-04 11:35:04	2018-10-04	9
11554	2	3927	2018-10-04 11:31:03	2018-10-04	9
11555	3	3927	2018-10-04 11:31:05	2018-10-04	9
11556	2	3928	2018-10-04 11:29:13	2018-10-04	9
11557	3	3928	2018-10-04 11:29:15	2018-10-04	9
11558	2	3929	2018-10-04 11:28:38	2018-10-04	9
11559	3	3929	2018-10-04 11:28:40	2018-10-04	9
11560	2	3930	2018-10-04 11:23:29	2018-10-04	9
11561	3	3930	2018-10-04 11:23:32	2018-10-04	9
11562	2	3931	2018-10-04 11:21:26	2018-10-04	9
11563	3	3931	2018-10-04 11:21:29	2018-10-04	9
11564	2	3932	2018-10-04 11:20:41	2018-10-04	9
11565	3	3932	2018-10-04 11:20:43	2018-10-04	9
11566	2	3933	2018-10-04 11:19:36	2018-10-04	9
11567	3	3933	2018-10-04 11:19:38	2018-10-04	9
11568	2	3934	2018-10-04 11:18:04	2018-10-04	9
11569	3	3934	2018-10-04 11:18:05	2018-10-04	9
11570	2	3935	2018-10-04 11:15:10	2018-10-04	9
11571	3	3935	2018-10-04 11:15:12	2018-10-04	9
11572	2	3936	2018-10-04 11:10:36	2018-10-04	9
11573	3	3936	2018-10-04 11:10:37	2018-10-04	9
11574	2	3937	2018-10-04 11:10:19	2018-10-04	9
11575	3	3937	2018-10-04 11:10:20	2018-10-04	9
11576	2	3938	2018-10-04 11:08:58	2018-10-04	9
11577	3	3938	2018-10-04 11:09:00	2018-10-04	9
11578	2	3939	2018-10-04 11:07:28	2018-10-04	9
11579	3	3939	2018-10-04 11:07:30	2018-10-04	9
11580	2	3940	2018-10-04 11:06:35	2018-10-04	9
11581	3	3940	2018-10-04 11:06:36	2018-10-04	9
11582	2	3941	2018-10-04 11:02:24	2018-10-04	9
11583	3	3941	2018-10-04 11:02:25	2018-10-04	9
11584	2	3942	2018-10-04 10:59:11	2018-10-04	8
11585	3	3942	2018-10-04 10:59:13	2018-10-04	8
11586	2	3943	2018-10-04 10:59:02	2018-10-04	8
11587	3	3943	2018-10-04 10:59:04	2018-10-04	8
11588	2	3944	2018-10-04 10:53:39	2018-10-04	8
11589	3	3944	2018-10-04 10:53:41	2018-10-04	8
11590	2	3945	2018-10-04 10:48:48	2018-10-04	8
11591	3	3945	2018-10-04 10:48:50	2018-10-04	8
11592	2	3946	2018-10-04 10:44:18	2018-10-04	8
11593	3	3946	2018-10-04 10:44:20	2018-10-04	8
11594	2	3947	2018-10-04 10:42:37	2018-10-04	8
11595	3	3947	2018-10-04 10:42:39	2018-10-04	8
11596	2	3948	2018-10-04 10:41:39	2018-10-04	8
11597	3	3948	2018-10-04 10:41:41	2018-10-04	8
11598	2	3949	2018-10-04 10:41:54	2018-10-04	8
11599	3	3949	2018-10-04 10:41:55	2018-10-04	8
11600	2	3950	2018-10-04 10:40:26	2018-10-04	8
11601	3	3950	2018-10-04 10:40:28	2018-10-04	8
11602	2	3951	2018-10-04 10:39:42	2018-10-04	8
11603	3	3951	2018-10-04 10:39:44	2018-10-04	8
11604	2	3952	2018-10-04 10:37:11	2018-10-04	8
11605	3	3952	2018-10-04 10:37:13	2018-10-04	8
11606	2	3953	2018-10-04 10:32:49	2018-10-04	8
11607	3	3953	2018-10-04 10:32:51	2018-10-04	8
11608	2	3954	2018-10-04 10:32:40	2018-10-04	8
11609	3	3954	2018-10-04 10:32:42	2018-10-04	8
11610	2	3955	2018-10-04 10:34:11	2018-10-04	8
11611	3	3955	2018-10-04 10:38:10	2018-10-04	8
11612	2	3956	2018-10-04 10:30:02	2018-10-04	8
11613	3	3956	2018-10-04 10:30:04	2018-10-04	8
11614	2	3957	2018-10-04 10:27:33	2018-10-04	8
11615	3	3957	2018-10-04 10:27:35	2018-10-04	8
11616	2	3958	2018-10-04 10:23:09	2018-10-04	8
11617	3	3958	2018-10-04 10:23:11	2018-10-04	8
11618	2	3959	2018-10-04 10:20:14	2018-10-04	8
11619	3	3959	2018-10-04 10:20:16	2018-10-04	8
11620	2	3960	2018-10-04 10:18:51	2018-10-04	8
11621	3	3960	2018-10-04 10:18:53	2018-10-04	8
11622	2	3961	2018-10-04 10:17:56	2018-10-04	8
11623	3	3961	2018-10-04 10:17:58	2018-10-04	8
11624	2	3962	2018-10-04 10:17:38	2018-10-04	8
11625	1	3962	2018-10-08 15:20:15	2018-10-08	13
11626	2	3962	2018-10-08 15:20:16	2018-10-08	13
11627	3	3962	2018-10-08 15:57:51	2018-10-08	13
11628	2	3963	2018-10-04 10:11:31	2018-10-04	8
11629	3	3963	2018-10-04 10:11:32	2018-10-04	8
11630	2	3964	2018-10-04 10:06:08	2018-10-04	8
11631	3	3964	2018-10-04 10:06:10	2018-10-04	8
11632	2	3965	2018-10-04 10:04:45	2018-10-04	8
11633	3	3965	2018-10-04 10:04:47	2018-10-04	8
11634	2	3966	2018-10-04 10:04:51	2018-10-04	8
11635	3	3966	2018-10-04 10:04:53	2018-10-04	8
11636	2	3967	2018-10-04 10:03:13	2018-10-04	8
11637	3	3967	2018-10-04 10:03:15	2018-10-04	8
11638	2	3968	2018-10-04 09:59:24	2018-10-04	7
11639	3	3968	2018-10-04 09:59:26	2018-10-04	7
11640	2	3969	2018-10-04 09:58:31	2018-10-04	7
11641	3	3969	2018-10-04 09:58:32	2018-10-04	7
11642	2	3970	2018-10-04 09:56:22	2018-10-04	7
11643	3	3970	2018-10-04 09:56:24	2018-10-04	7
11644	2	3971	2018-10-04 09:55:49	2018-10-04	7
11645	3	3971	2018-10-04 09:55:51	2018-10-04	7
11646	2	3972	2018-10-04 09:55:45	2018-10-04	7
11647	3	3972	2018-10-04 10:05:16	2018-10-04	8
11648	2	3973	2018-10-04 09:52:39	2018-10-04	7
11649	3	3973	2018-10-04 09:52:41	2018-10-04	7
11650	2	3974	2018-10-04 09:52:08	2018-10-04	7
11651	3	3974	2018-10-04 09:52:10	2018-10-04	7
11652	2	3975	2018-10-04 09:54:34	2018-10-04	7
11653	3	3975	2018-10-04 10:21:37	2018-10-04	8
11654	2	3976	2018-10-04 09:47:46	2018-10-04	7
11655	3	3976	2018-10-04 09:47:48	2018-10-04	7
11656	2	3977	2018-10-04 09:33:54	2018-10-04	7
11657	3	3977	2018-10-04 09:33:56	2018-10-04	7
11658	2	3978	2018-10-04 09:33:36	2018-10-04	7
11659	3	3978	2018-10-04 09:33:38	2018-10-04	7
11660	2	3979	2018-10-04 09:37:47	2018-10-04	7
11661	3	3979	2018-10-23 10:29:14	2018-10-23	8
11662	2	3980	2018-10-04 09:28:50	2018-10-04	7
11663	3	3980	2018-10-04 09:28:52	2018-10-04	7
11664	2	3981	2018-10-04 09:28:28	2018-10-04	7
11665	3	3981	2018-10-04 09:28:29	2018-10-04	7
11666	2	3982	2018-10-04 09:21:10	2018-10-04	7
11667	3	3982	2018-10-04 09:21:12	2018-10-04	7
11668	2	3983	2018-10-04 09:20:37	2018-10-04	7
11669	3	3983	2018-10-04 09:20:39	2018-10-04	7
11670	2	3984	2018-10-04 09:18:57	2018-10-04	7
11671	3	3984	2018-10-04 09:18:59	2018-10-04	7
11672	2	3985	2018-10-04 09:17:33	2018-10-04	7
11673	3	3985	2018-10-04 09:17:35	2018-10-04	7
11674	2	3986	2018-10-04 09:16:19	2018-10-04	7
11675	3	3986	2018-10-04 09:16:21	2018-10-04	7
11676	2	3987	2018-10-04 09:15:29	2018-10-04	7
11677	3	3987	2018-10-04 09:15:30	2018-10-04	7
11678	2	3988	2018-10-04 09:12:18	2018-10-04	7
11679	3	3988	2018-10-04 09:14:26	2018-10-04	7
11680	2	3989	2018-10-04 09:09:57	2018-10-04	7
11681	3	3989	2018-10-04 09:09:59	2018-10-04	7
11682	2	3990	2018-10-04 09:11:33	2018-10-04	7
11683	3	3990	2018-10-04 09:11:35	2018-10-04	7
11684	2	3991	2018-10-04 09:05:46	2018-10-04	7
11685	3	3991	2018-10-04 09:05:48	2018-10-04	7
11686	2	3992	2018-10-04 09:05:02	2018-10-04	7
11687	3	3992	2018-10-04 09:05:04	2018-10-04	7
11688	2	3993	2018-10-04 09:04:14	2018-10-04	7
11689	3	3993	2018-10-04 09:04:17	2018-10-04	7
11690	2	3994	2018-10-04 09:03:06	2018-10-04	7
11691	3	3994	2018-10-04 09:03:08	2018-10-04	7
11692	2	3995	2018-10-04 09:01:43	2018-10-04	7
11693	3	3995	2018-10-04 09:01:44	2018-10-04	7
11694	2	3996	2018-10-04 09:01:33	2018-10-04	7
11695	3	3996	2018-10-04 09:01:35	2018-10-04	7
11696	2	3997	2018-10-04 09:01:19	2018-10-04	7
11697	3	3997	2018-10-04 09:01:21	2018-10-04	7
11698	2	3998	2018-10-04 09:00:12	2018-10-04	7
11699	3	3998	2018-10-04 09:00:14	2018-10-04	7
11700	2	3999	2018-10-04 08:56:54	2018-10-04	6
11701	3	3999	2018-10-04 08:56:56	2018-10-04	6
11702	2	4000	2018-10-04 08:56:08	2018-10-04	6
11703	3	4000	2018-10-04 08:56:10	2018-10-04	6
11704	2	4001	2018-10-04 08:51:34	2018-10-04	6
11705	3	4001	2018-10-04 08:51:36	2018-10-04	6
11706	2	4002	2018-10-04 08:49:42	2018-10-04	6
11707	3	4002	2018-10-04 08:49:44	2018-10-04	6
11708	2	4003	2018-10-04 08:49:18	2018-10-04	6
11709	3	4003	2018-10-04 08:49:19	2018-10-04	6
11710	2	4004	2018-10-04 08:45:13	2018-10-04	6
11711	3	4004	2018-10-04 08:45:14	2018-10-04	6
11712	2	4005	2018-10-04 08:44:46	2018-10-04	6
11713	3	4005	2018-10-04 08:44:48	2018-10-04	6
11714	2	4006	2018-10-04 08:44:17	2018-10-04	6
11715	3	4006	2018-10-04 08:44:18	2018-10-04	6
11716	2	4007	2018-10-04 07:44:55	2018-10-04	5
11717	3	4007	2018-10-04 07:59:49	2018-10-04	5
11718	2	4008	2018-10-03 17:03:23	2018-10-03	15
11719	3	4008	2018-10-03 17:03:24	2018-10-03	15
11720	2	4009	2018-10-03 17:02:45	2018-10-03	15
11721	3	4009	2018-10-03 17:02:47	2018-10-03	15
11722	2	4010	2018-10-03 17:00:00	2018-10-03	15
11723	3	4010	2018-10-03 17:00:03	2018-10-03	15
11724	2	4011	2018-10-03 16:54:56	2018-10-03	14
11725	3	4011	2018-10-04 11:26:34	2018-10-04	9
11726	2	4012	2018-10-03 16:56:36	2018-10-03	14
11727	3	4012	2018-10-04 08:34:56	2018-10-04	6
11728	2	4013	2018-10-03 16:52:52	2018-10-03	14
11729	3	4013	2018-10-03 16:52:54	2018-10-03	14
11730	2	4014	2018-10-03 16:49:24	2018-10-03	14
11731	3	4014	2018-10-03 16:49:26	2018-10-03	14
11732	2	4015	2018-10-03 16:50:49	2018-10-03	14
11733	3	4015	2018-10-11 11:51:55	2018-10-11	9
11734	2	4016	2018-10-03 16:39:58	2018-10-03	14
11735	3	4016	2018-10-03 16:40:00	2018-10-03	14
11736	2	4017	2018-10-03 16:36:14	2018-10-03	14
11737	3	4017	2018-10-03 16:36:16	2018-10-03	14
11738	2	4018	2018-10-03 16:34:31	2018-10-03	14
11739	3	4018	2018-10-03 16:34:32	2018-10-03	14
11740	2	4019	2018-10-03 16:35:08	2018-10-03	14
11741	3	4019	2018-10-03 16:35:09	2018-10-03	14
11742	2	4020	2018-10-03 16:28:54	2018-10-03	14
11743	3	4020	2018-10-03 16:28:56	2018-10-03	14
11744	2	4021	2018-10-03 16:21:11	2018-10-03	14
11745	3	4021	2018-10-03 16:21:13	2018-10-03	14
11746	2	4022	2018-10-03 16:24:17	2018-10-03	14
11747	3	4022	2018-10-04 08:45:40	2018-10-04	6
11748	2	4023	2018-10-03 16:20:18	2018-10-03	14
11749	3	4023	2018-10-03 16:20:20	2018-10-03	14
11750	2	4024	2018-10-03 16:19:27	2018-10-03	14
11751	3	4024	2018-10-04 08:50:38	2018-10-04	6
11752	2	4025	2018-10-03 16:16:10	2018-10-03	14
11753	3	4025	2018-10-03 16:16:12	2018-10-03	14
11754	2	4026	2018-10-03 16:11:11	2018-10-03	14
11755	3	4026	2018-10-03 16:11:13	2018-10-03	14
11756	2	4027	2018-10-03 16:11:53	2018-10-03	14
11757	3	4027	2018-10-04 10:20:39	2018-10-04	8
11758	2	4028	2018-10-03 16:07:07	2018-10-03	14
11759	3	4028	2018-10-03 16:07:09	2018-10-03	14
11760	2	4029	2018-10-03 16:06:19	2018-10-03	14
11761	3	4029	2018-10-03 16:06:21	2018-10-03	14
11762	2	4030	2018-10-03 16:05:40	2018-10-03	14
11763	3	4030	2018-10-03 16:05:42	2018-10-03	14
11764	2	4031	2018-10-03 16:04:48	2018-10-03	14
11765	3	4031	2018-10-03 16:05:12	2018-10-03	14
11766	2	4032	2018-10-03 16:04:10	2018-10-03	14
11767	3	4032	2018-10-11 17:24:36	2018-10-11	15
11768	2	4033	2018-10-03 16:02:42	2018-10-03	14
11769	3	4033	2018-10-03 16:02:44	2018-10-03	14
11770	2	4034	2018-10-03 16:02:03	2018-10-03	14
11771	3	4034	2018-10-03 16:02:28	2018-10-03	14
11772	2	4035	2018-10-03 16:00:10	2018-10-03	14
11773	3	4035	2018-10-03 16:00:12	2018-10-03	14
11774	2	4036	2018-10-03 15:57:29	2018-10-03	13
11775	3	4036	2018-10-03 15:57:31	2018-10-03	13
11776	2	4037	2018-10-03 15:57:17	2018-10-03	13
11777	3	4037	2018-10-03 15:57:18	2018-10-03	13
11778	2	4038	2018-10-03 15:55:49	2018-10-03	13
11779	3	4038	2018-10-03 15:55:51	2018-10-03	13
11780	2	4039	2018-10-03 15:49:18	2018-10-03	13
11781	3	4039	2018-10-03 15:49:20	2018-10-03	13
11782	2	4040	2018-10-03 15:46:35	2018-10-03	13
11783	3	4040	2018-10-03 15:46:37	2018-10-03	13
11784	2	4041	2018-10-03 15:40:33	2018-10-03	13
11785	3	4041	2018-10-03 15:40:35	2018-10-03	13
11786	2	4042	2018-10-03 15:40:20	2018-10-03	13
11787	3	4042	2018-10-03 15:40:22	2018-10-03	13
11788	2	4043	2018-10-03 15:38:47	2018-10-03	13
11789	3	4043	2018-10-03 15:38:48	2018-10-03	13
11790	2	4044	2018-10-03 15:35:20	2018-10-03	13
11791	3	4044	2018-10-03 15:35:22	2018-10-03	13
11792	2	4045	2018-10-03 15:34:44	2018-10-03	13
11793	3	4045	2018-10-03 15:34:46	2018-10-03	13
11794	2	4046	2018-10-03 15:33:41	2018-10-03	13
11795	3	4046	2018-10-03 15:33:43	2018-10-03	13
11796	2	4047	2018-10-03 15:32:43	2018-10-03	13
11797	3	4047	2018-10-03 15:57:32	2018-10-03	13
11798	2	4048	2018-10-03 15:26:25	2018-10-03	13
11799	3	4048	2018-10-03 15:26:27	2018-10-03	13
11800	2	4049	2018-10-03 15:25:10	2018-10-03	13
11801	3	4049	2018-10-03 15:25:12	2018-10-03	13
11802	2	4050	2018-10-03 15:22:28	2018-10-03	13
11803	3	4050	2018-10-03 15:22:30	2018-10-03	13
11804	2	4051	2018-10-03 15:21:58	2018-10-03	13
11805	3	4051	2018-10-03 15:21:59	2018-10-03	13
11806	2	4052	2018-10-03 15:19:37	2018-10-03	13
11807	3	4052	2018-10-03 15:19:39	2018-10-03	13
11808	2	4053	2018-10-03 15:19:39	2018-10-03	13
11809	3	4053	2018-10-03 16:03:16	2018-10-03	14
11810	2	4054	2018-10-03 15:17:50	2018-10-03	13
11811	3	4054	2018-10-03 15:17:52	2018-10-03	13
11812	2	4055	2018-10-03 15:17:22	2018-10-03	13
11813	3	4055	2018-10-03 16:54:03	2018-10-03	14
11814	2	4056	2018-10-03 15:12:38	2018-10-03	13
11815	3	4056	2018-10-04 10:28:30	2018-10-04	8
11816	2	4057	2018-10-03 15:08:33	2018-10-03	13
11817	3	4057	2018-10-03 15:08:35	2018-10-03	13
11818	2	4058	2018-10-03 15:07:09	2018-10-03	13
11819	3	4058	2018-10-03 15:07:11	2018-10-03	13
11820	2	4059	2018-10-03 15:06:56	2018-10-03	13
11821	3	4059	2018-10-03 15:06:58	2018-10-03	13
11822	2	4060	2018-10-03 15:06:01	2018-10-03	13
11823	3	4060	2018-10-03 15:06:03	2018-10-03	13
11824	2	4061	2018-10-03 15:03:07	2018-10-03	13
11825	3	4061	2018-10-04 08:50:14	2018-10-04	6
11826	2	4062	2018-10-03 14:58:28	2018-10-03	12
11827	3	4062	2018-10-03 14:58:30	2018-10-03	12
11828	2	4063	2018-10-03 14:56:07	2018-10-03	12
11829	3	4063	2018-10-03 14:56:09	2018-10-03	12
11830	2	4064	2018-10-03 14:55:50	2018-10-03	12
11831	3	4064	2018-10-03 14:55:52	2018-10-03	12
11832	2	4065	2018-10-03 14:55:48	2018-10-03	12
11833	3	4065	2018-10-03 14:55:50	2018-10-03	12
11834	2	4066	2018-10-03 14:51:14	2018-10-03	12
11835	3	4066	2018-10-03 14:51:16	2018-10-03	12
11836	2	4067	2018-10-03 14:46:18	2018-10-03	12
11837	3	4067	2018-10-03 14:46:20	2018-10-03	12
11838	2	4068	2018-10-03 14:46:20	2018-10-03	12
11839	3	4068	2018-10-03 14:46:22	2018-10-03	12
11840	2	4069	2018-10-03 14:44:06	2018-10-03	12
11841	3	4069	2018-10-03 14:44:08	2018-10-03	12
11842	2	4070	2018-10-03 14:41:30	2018-10-03	12
11843	3	4070	2018-10-03 14:41:32	2018-10-03	12
11844	2	4071	2018-10-03 14:38:55	2018-10-03	12
11845	3	4071	2018-10-03 14:38:57	2018-10-03	12
11846	2	4072	2018-10-03 14:41:36	2018-10-03	12
11847	3	4072	2018-10-03 14:41:38	2018-10-03	12
11848	2	4073	2018-10-03 14:26:45	2018-10-03	12
11849	3	4073	2018-10-03 14:26:47	2018-10-03	12
11850	2	4074	2018-10-03 14:22:46	2018-10-03	12
11851	3	4074	2018-10-03 14:22:48	2018-10-03	12
11852	2	4075	2018-10-03 14:21:27	2018-10-03	12
11853	3	4075	2018-10-03 14:21:29	2018-10-03	12
11854	2	4076	2018-10-03 14:20:30	2018-10-03	12
11855	3	4076	2018-10-03 14:20:31	2018-10-03	12
11856	2	4077	2018-10-03 14:13:30	2018-10-03	12
11857	3	4077	2018-10-03 14:13:32	2018-10-03	12
11858	2	4078	2018-10-03 14:15:50	2018-10-03	12
11859	3	4078	2018-10-03 14:15:52	2018-10-03	12
11860	2	4079	2018-10-03 14:10:58	2018-10-03	12
11861	3	4079	2018-10-03 14:10:59	2018-10-03	12
11862	2	4080	2018-10-03 14:08:56	2018-10-03	12
11863	3	4080	2018-10-03 14:10:32	2018-10-03	12
11864	2	4081	2018-10-03 14:08:28	2018-10-03	12
11865	3	4081	2018-10-03 14:08:30	2018-10-03	12
11866	2	4082	2018-10-03 14:05:41	2018-10-03	12
11867	3	4082	2018-10-03 14:05:43	2018-10-03	12
11868	2	4083	2018-10-03 14:06:25	2018-10-03	12
11869	3	4083	2018-10-03 14:06:27	2018-10-03	12
11870	2	4084	2018-10-03 14:04:55	2018-10-03	12
11871	3	4084	2018-10-03 14:04:57	2018-10-03	12
11872	2	4085	2018-10-03 14:04:05	2018-10-03	12
11873	3	4085	2018-10-03 14:04:07	2018-10-03	12
11874	2	4086	2018-10-03 14:02:59	2018-10-03	12
11875	3	4086	2018-10-03 14:03:01	2018-10-03	12
11876	2	4087	2018-10-03 12:27:17	2018-10-03	10
11877	3	4087	2018-10-03 12:27:19	2018-10-03	10
11878	2	4088	2018-10-03 12:16:27	2018-10-03	10
11879	3	4088	2018-10-03 12:16:29	2018-10-03	10
11880	2	4089	2018-10-03 12:11:12	2018-10-03	10
11881	1	4089	2018-10-08 15:20:31	2018-10-08	13
11882	2	4089	2018-10-08 15:20:32	2018-10-08	13
11883	3	4089	2018-10-08 15:58:10	2018-10-08	13
11884	2	4090	2018-10-03 12:05:21	2018-10-03	10
11885	3	4090	2018-10-04 08:53:03	2018-10-04	6
11886	2	4091	2018-10-03 12:02:24	2018-10-03	10
11887	3	4091	2018-10-03 12:02:26	2018-10-03	10
11888	2	4092	2018-10-03 11:59:24	2018-10-03	9
11889	3	4092	2018-10-03 11:59:26	2018-10-03	9
11890	2	4093	2018-10-03 11:57:58	2018-10-03	9
11891	3	4093	2018-10-03 11:58:00	2018-10-03	9
11892	2	4094	2018-10-03 11:58:19	2018-10-03	9
11893	3	4094	2018-10-03 11:58:21	2018-10-03	9
11894	2	4095	2018-10-03 11:58:47	2018-10-03	9
11895	3	4095	2018-10-03 11:58:49	2018-10-03	9
11896	2	4096	2018-10-03 11:55:19	2018-10-03	9
11897	3	4096	2018-10-03 11:55:20	2018-10-03	9
11898	2	4097	2018-10-03 11:54:44	2018-10-03	9
11899	3	4097	2018-10-04 08:43:56	2018-10-04	6
11900	2	4098	2018-10-03 11:49:56	2018-10-03	9
11901	3	4098	2018-10-03 11:49:58	2018-10-03	9
11902	2	4099	2018-10-03 11:51:49	2018-10-03	9
11903	3	4099	2018-10-03 11:51:51	2018-10-03	9
11904	2	4100	2018-10-03 11:49:39	2018-10-03	9
11905	3	4100	2018-10-04 08:33:06	2018-10-04	6
11906	2	4101	2018-10-03 11:45:50	2018-10-03	9
11907	3	4101	2018-10-04 08:53:20	2018-10-04	6
11908	2	4102	2018-10-03 11:39:27	2018-10-03	9
11909	3	4102	2018-10-03 11:39:29	2018-10-03	9
11910	2	4103	2018-10-03 11:41:09	2018-10-03	9
11911	3	4103	2018-10-03 11:41:11	2018-10-03	9
11912	2	4104	2018-10-03 11:38:54	2018-10-03	9
11913	3	4104	2018-10-03 11:38:55	2018-10-03	9
11914	2	4105	2018-10-03 11:36:57	2018-10-03	9
11915	3	4105	2018-10-03 11:36:58	2018-10-03	9
11916	2	4106	2018-10-03 11:35:00	2018-10-03	9
11917	3	4106	2018-10-03 11:35:02	2018-10-03	9
11918	2	4107	2018-10-03 11:32:03	2018-10-03	9
11919	3	4107	2018-10-03 11:32:04	2018-10-03	9
11920	2	4108	2018-10-03 11:31:08	2018-10-03	9
11921	3	4108	2018-10-03 11:31:09	2018-10-03	9
11922	2	4109	2018-10-03 11:28:32	2018-10-03	9
11923	3	4109	2018-10-03 11:28:34	2018-10-03	9
11924	2	4110	2018-10-03 11:27:01	2018-10-03	9
11925	3	4110	2018-10-03 11:27:03	2018-10-03	9
11926	2	4111	2018-10-03 11:25:34	2018-10-03	9
11927	3	4111	2018-10-03 11:25:36	2018-10-03	9
11928	2	4112	2018-10-03 11:21:14	2018-10-03	9
11929	3	4112	2018-10-04 08:31:20	2018-10-04	6
11930	2	4113	2018-10-03 11:17:15	2018-10-03	9
11931	3	4113	2018-10-03 11:17:17	2018-10-03	9
11932	2	4114	2018-10-03 11:19:37	2018-10-03	9
11933	3	4114	2018-10-04 08:09:03	2018-10-04	6
11934	2	4115	2018-10-03 11:17:26	2018-10-03	9
11935	3	4115	2018-10-03 11:17:28	2018-10-03	9
11936	2	4116	2018-10-03 11:15:52	2018-10-03	9
11937	3	4116	2018-10-03 11:15:54	2018-10-03	9
11938	2	4117	2018-10-03 11:15:04	2018-10-03	9
11939	3	4117	2018-10-03 11:15:06	2018-10-03	9
11940	2	4118	2018-10-03 11:14:33	2018-10-03	9
11941	3	4118	2018-10-03 11:14:35	2018-10-03	9
11942	2	4119	2018-10-03 11:15:05	2018-10-03	9
11943	3	4119	2018-10-03 11:15:06	2018-10-03	9
11944	2	4120	2018-10-03 11:13:59	2018-10-03	9
11945	3	4120	2018-10-03 11:14:01	2018-10-03	9
11946	2	4121	2018-10-03 11:09:27	2018-10-03	9
11947	3	4121	2018-10-03 11:09:29	2018-10-03	9
11948	2	4122	2018-10-03 11:07:47	2018-10-03	9
11949	3	4122	2018-10-03 11:07:49	2018-10-03	9
11950	2	4123	2018-10-03 11:02:18	2018-10-03	9
11951	3	4123	2018-10-03 11:02:20	2018-10-03	9
11952	2	4124	2018-10-03 11:01:37	2018-10-03	9
11953	3	4124	2018-10-03 11:01:39	2018-10-03	9
11954	2	4125	2018-10-03 11:00:43	2018-10-03	9
11955	3	4125	2018-10-03 11:00:45	2018-10-03	9
11956	2	4126	2018-10-03 10:59:12	2018-10-03	8
11957	3	4126	2018-10-03 10:59:14	2018-10-03	8
11958	2	4127	2018-10-03 10:56:40	2018-10-03	8
11959	3	4127	2018-10-03 10:56:42	2018-10-03	8
11960	2	4128	2018-10-03 10:56:30	2018-10-03	8
11961	3	4128	2018-10-03 10:56:32	2018-10-03	8
11962	2	4129	2018-10-03 10:54:52	2018-10-03	8
11963	3	4129	2018-10-03 10:54:54	2018-10-03	8
11964	2	4130	2018-10-03 10:53:47	2018-10-03	8
11965	3	4130	2018-10-03 10:53:49	2018-10-03	8
11966	2	4131	2018-10-03 10:54:07	2018-10-03	8
11967	3	4131	2018-10-03 10:54:09	2018-10-03	8
11968	2	4132	2018-10-03 10:53:23	2018-10-03	8
11969	3	4132	2018-10-03 10:53:25	2018-10-03	8
11970	2	4133	2018-10-03 10:50:53	2018-10-03	8
11971	3	4133	2018-10-03 10:50:55	2018-10-03	8
11972	2	4134	2018-10-03 10:49:56	2018-10-03	8
11973	3	4134	2018-10-03 10:49:58	2018-10-03	8
11974	2	4135	2018-10-03 10:46:55	2018-10-03	8
11975	3	4135	2018-10-03 10:46:57	2018-10-03	8
11976	2	4136	2018-10-03 10:43:31	2018-10-03	8
11977	3	4136	2018-10-03 10:43:33	2018-10-03	8
11978	2	4137	2018-10-03 10:40:59	2018-10-03	8
11979	3	4137	2018-10-03 10:41:01	2018-10-03	8
11980	2	4138	2018-10-03 10:40:00	2018-10-03	8
11981	3	4138	2018-10-03 10:40:03	2018-10-03	8
11982	2	4139	2018-10-03 10:38:50	2018-10-03	8
11983	3	4139	2018-10-03 10:38:52	2018-10-03	8
11984	2	4140	2018-10-03 10:41:28	2018-10-03	8
11985	3	4140	2018-10-03 10:41:30	2018-10-03	8
11986	2	4141	2018-10-03 10:37:29	2018-10-03	8
11987	3	4141	2018-10-03 10:37:31	2018-10-03	8
11988	2	4142	2018-10-03 10:37:11	2018-10-03	8
11989	3	4142	2018-10-03 10:37:13	2018-10-03	8
11990	2	4143	2018-10-03 11:04:09	2018-10-03	9
11991	3	4143	2018-10-03 11:04:11	2018-10-03	9
11992	2	4144	2018-10-03 10:31:29	2018-10-03	8
11993	3	4144	2018-10-03 10:31:31	2018-10-03	8
11994	2	4145	2018-10-03 10:29:47	2018-10-03	8
11995	3	4145	2018-10-03 10:29:48	2018-10-03	8
11996	2	4146	2018-10-03 10:28:29	2018-10-03	8
11997	3	4146	2018-10-03 10:28:31	2018-10-03	8
11998	2	4147	2018-10-03 10:28:39	2018-10-03	8
11999	3	4147	2018-10-03 10:28:41	2018-10-03	8
12000	2	4148	2018-10-03 10:26:14	2018-10-03	8
12001	3	4148	2018-10-03 10:26:15	2018-10-03	8
12002	2	4149	2018-10-03 10:25:01	2018-10-03	8
12003	3	4149	2018-10-03 10:25:03	2018-10-03	8
12004	2	4150	2018-10-03 10:24:26	2018-10-03	8
12005	3	4150	2018-10-03 10:24:28	2018-10-03	8
12006	2	4151	2018-10-03 10:23:18	2018-10-03	8
12007	3	4151	2018-10-03 10:23:20	2018-10-03	8
12008	2	4152	2018-10-03 10:21:55	2018-10-03	8
12009	3	4152	2018-10-03 10:21:57	2018-10-03	8
12010	2	4153	2018-10-03 10:21:44	2018-10-03	8
12011	3	4153	2018-10-03 10:21:46	2018-10-03	8
12012	2	4154	2018-10-03 10:23:07	2018-10-03	8
12013	3	4154	2018-10-03 10:23:09	2018-10-03	8
12014	2	4155	2018-10-03 10:21:13	2018-10-03	8
12015	3	4155	2018-10-03 10:21:19	2018-10-03	8
12016	2	4156	2018-10-03 10:20:30	2018-10-03	8
12017	3	4156	2018-10-03 10:20:32	2018-10-03	8
12018	2	4157	2018-10-03 10:19:41	2018-10-03	8
12019	3	4157	2018-10-03 10:19:43	2018-10-03	8
12020	2	4158	2018-10-03 10:19:21	2018-10-03	8
12021	3	4158	2018-10-03 10:19:23	2018-10-03	8
12022	2	4159	2018-10-03 10:17:55	2018-10-03	8
12023	3	4159	2018-10-03 10:17:58	2018-10-03	8
12024	2	4160	2018-10-03 10:10:51	2018-10-03	8
12025	3	4160	2018-10-03 10:10:53	2018-10-03	8
12026	2	4161	2018-10-03 10:10:25	2018-10-03	8
12027	3	4161	2018-10-03 10:10:27	2018-10-03	8
12028	2	4162	2018-10-03 10:11:21	2018-10-03	8
12029	3	4162	2018-10-03 10:11:24	2018-10-03	8
12030	2	4163	2018-10-03 10:07:48	2018-10-03	8
12031	3	4163	2018-10-03 10:07:50	2018-10-03	8
12032	2	4164	2018-10-03 10:02:51	2018-10-03	8
12033	3	4164	2018-10-03 10:02:53	2018-10-03	8
12034	2	4165	2018-10-03 09:57:05	2018-10-03	7
12035	3	4165	2018-10-03 09:57:07	2018-10-03	7
12036	2	4166	2018-10-03 09:51:03	2018-10-03	7
12037	3	4166	2018-10-03 09:51:05	2018-10-03	7
12038	2	4167	2018-10-03 09:50:35	2018-10-03	7
12039	3	4167	2018-10-03 09:50:36	2018-10-03	7
12040	2	4168	2018-10-03 09:49:04	2018-10-03	7
12041	3	4168	2018-10-03 09:49:06	2018-10-03	7
12042	2	4169	2018-10-03 09:49:20	2018-10-03	7
12043	3	4169	2018-10-05 13:07:31	2018-10-05	11
12044	2	4170	2018-10-03 09:47:06	2018-10-03	7
12045	3	4170	2018-10-03 09:47:08	2018-10-03	7
12046	2	4171	2018-10-03 09:45:15	2018-10-03	7
12047	3	4171	2018-10-03 09:45:17	2018-10-03	7
12048	2	4172	2018-10-03 09:41:45	2018-10-03	7
12049	3	4172	2018-10-03 09:41:47	2018-10-03	7
12050	2	4173	2018-10-03 09:37:21	2018-10-03	7
12051	3	4173	2018-10-03 09:37:23	2018-10-03	7
12052	2	4174	2018-10-03 09:36:52	2018-10-03	7
12053	3	4174	2018-10-03 09:36:54	2018-10-03	7
12054	2	4175	2018-10-03 09:35:28	2018-10-03	7
12055	3	4175	2018-10-03 09:55:49	2018-10-03	7
12056	2	4176	2018-10-03 09:33:35	2018-10-03	7
12057	3	4176	2018-10-03 09:33:37	2018-10-03	7
12058	2	4177	2018-10-03 09:32:49	2018-10-03	7
12059	3	4177	2018-10-03 09:32:51	2018-10-03	7
12060	2	4178	2018-10-03 09:32:45	2018-10-03	7
12061	3	4178	2018-10-03 10:53:19	2018-10-03	8
12062	2	4179	2018-10-03 09:30:19	2018-10-03	7
12063	3	4179	2018-10-03 09:30:21	2018-10-03	7
12064	2	4180	2018-10-03 09:26:06	2018-10-03	7
12065	3	4180	2018-10-03 09:26:08	2018-10-03	7
12066	2	4181	2018-10-03 09:25:25	2018-10-03	7
12067	3	4181	2018-10-03 09:25:27	2018-10-03	7
12068	2	4182	2018-10-03 09:22:48	2018-10-03	7
12069	3	4182	2018-10-03 09:22:50	2018-10-03	7
12070	2	4183	2018-10-03 09:22:15	2018-10-03	7
12071	3	4183	2018-10-03 09:22:17	2018-10-03	7
12072	2	4184	2018-10-03 09:20:05	2018-10-03	7
12073	3	4184	2018-10-03 09:20:07	2018-10-03	7
12074	2	4185	2018-10-03 09:23:01	2018-10-03	7
12075	3	4185	2018-10-05 13:02:43	2018-10-05	11
12076	2	4186	2018-10-03 09:18:19	2018-10-03	7
12077	3	4186	2018-10-03 09:18:20	2018-10-03	7
12078	2	4187	2018-10-03 09:17:34	2018-10-03	7
12079	3	4187	2018-10-03 09:17:36	2018-10-03	7
12080	2	4188	2018-10-03 09:16:53	2018-10-03	7
12081	3	4188	2018-10-03 09:16:55	2018-10-03	7
12082	2	4189	2018-10-03 09:16:01	2018-10-03	7
12083	3	4189	2018-10-03 09:16:03	2018-10-03	7
12084	2	4190	2018-10-03 09:16:08	2018-10-03	7
12085	3	4190	2018-10-03 09:16:10	2018-10-03	7
12086	2	4191	2018-10-03 09:16:45	2018-10-03	7
12087	3	4191	2018-10-03 10:01:44	2018-10-03	8
12088	2	4192	2018-10-03 09:15:12	2018-10-03	7
12089	3	4192	2018-10-03 09:15:14	2018-10-03	7
12090	2	4193	2018-10-03 09:13:40	2018-10-03	7
12091	3	4193	2018-10-03 09:13:42	2018-10-03	7
12092	2	4194	2018-10-03 09:13:14	2018-10-03	7
12093	3	4194	2018-10-03 09:13:16	2018-10-03	7
12094	2	4195	2018-10-03 09:06:50	2018-10-03	7
12095	3	4195	2018-10-03 09:06:52	2018-10-03	7
12096	2	4196	2018-10-03 09:03:59	2018-10-03	7
12097	3	4196	2018-10-03 09:04:01	2018-10-03	7
12098	2	4197	2018-10-03 09:02:27	2018-10-03	7
12099	3	4197	2018-10-03 09:02:29	2018-10-03	7
12100	2	4198	2018-10-03 08:55:44	2018-10-03	6
12101	3	4198	2018-10-03 08:55:46	2018-10-03	6
12102	2	4199	2018-10-03 08:52:21	2018-10-03	6
12103	3	4199	2018-10-03 10:00:17	2018-10-03	8
12104	2	4200	2018-10-03 08:48:25	2018-10-03	6
12105	3	4200	2018-10-03 08:48:27	2018-10-03	6
12106	2	4201	2018-10-03 08:45:27	2018-10-03	6
12107	3	4201	2018-10-03 08:45:29	2018-10-03	6
12108	2	4202	2018-10-03 08:43:16	2018-10-03	6
12109	3	4202	2018-10-03 08:43:18	2018-10-03	6
12110	2	4203	2018-10-03 08:41:52	2018-10-03	6
12111	3	4203	2018-10-03 08:41:54	2018-10-03	6
12112	2	4204	2018-10-03 08:41:33	2018-10-03	6
12113	3	4204	2018-10-03 08:41:35	2018-10-03	6
12114	2	4205	2018-10-03 08:38:25	2018-10-03	6
12115	3	4205	2018-10-03 09:45:13	2018-10-03	7
12116	2	4206	2018-10-03 08:38:21	2018-10-03	6
12117	3	4206	2018-10-03 08:38:23	2018-10-03	6
12118	2	4207	2018-10-03 08:35:42	2018-10-03	6
12119	3	4207	2018-10-03 08:35:44	2018-10-03	6
12120	2	4208	2018-10-03 08:19:30	2018-10-03	6
12121	3	4208	2018-10-03 08:57:54	2018-10-03	6
12122	2	4209	2018-10-02 16:52:22	2018-10-02	14
12123	3	4209	2018-10-02 16:52:24	2018-10-02	14
12124	2	4210	2018-10-02 16:53:53	2018-10-02	14
12125	3	4210	2018-10-03 09:01:10	2018-10-03	7
12126	2	4211	2018-10-02 16:45:43	2018-10-02	14
12127	3	4211	2018-10-02 16:45:45	2018-10-02	14
12128	2	4212	2018-10-02 16:43:36	2018-10-02	14
12129	3	4212	2018-10-02 16:43:38	2018-10-02	14
12130	2	4213	2018-10-02 16:35:22	2018-10-02	14
12131	3	4213	2018-10-02 16:35:24	2018-10-02	14
12132	2	4214	2018-10-02 16:32:37	2018-10-02	14
12133	3	4214	2018-10-03 14:46:04	2018-10-03	12
12134	2	4215	2018-10-02 16:26:12	2018-10-02	14
12135	1	4215	2018-10-08 15:17:21	2018-10-08	13
12136	2	4215	2018-10-08 15:17:22	2018-10-08	13
12137	3	4215	2018-10-08 15:56:31	2018-10-08	13
12138	2	4216	2018-10-02 16:23:16	2018-10-02	14
12139	3	4216	2018-10-02 16:34:43	2018-10-02	14
12140	2	4217	2018-10-02 16:23:29	2018-10-02	14
12141	3	4217	2018-10-03 08:29:44	2018-10-03	6
12142	2	4218	2018-10-02 16:12:41	2018-10-02	14
12143	3	4218	2018-10-02 16:12:43	2018-10-02	14
12144	2	4219	2018-10-02 16:12:07	2018-10-02	14
12145	1	4219	2018-10-08 15:21:19	2018-10-08	13
12146	2	4219	2018-10-08 15:21:20	2018-10-08	13
12147	3	4219	2018-10-08 15:58:40	2018-10-08	13
12148	2	4220	2018-10-02 16:04:54	2018-10-02	14
12149	3	4220	2018-10-02 16:04:56	2018-10-02	14
12150	2	4221	2018-10-02 15:45:36	2018-10-02	13
12151	3	4221	2018-10-02 15:45:38	2018-10-02	13
12152	2	4222	2018-10-02 15:42:59	2018-10-02	13
12153	3	4222	2018-10-02 15:49:17	2018-10-02	13
12154	2	4223	2018-10-02 15:34:41	2018-10-02	13
12155	3	4223	2018-10-02 15:34:42	2018-10-02	13
12156	2	4224	2018-10-02 15:29:29	2018-10-02	13
12157	3	4224	2018-10-02 15:29:31	2018-10-02	13
12158	2	4225	2018-10-02 15:29:55	2018-10-02	13
12159	3	4225	2018-10-02 15:29:57	2018-10-02	13
12160	2	4226	2018-10-02 15:25:50	2018-10-02	13
12161	3	4226	2018-10-02 15:25:52	2018-10-02	13
12162	2	4227	2018-10-02 15:10:51	2018-10-02	13
12163	3	4227	2018-10-02 15:10:53	2018-10-02	13
12164	2	4228	2018-10-02 15:05:35	2018-10-02	13
12165	3	4228	2018-10-02 15:05:37	2018-10-02	13
12166	2	4229	2018-10-02 15:03:43	2018-10-02	13
12167	3	4229	2018-10-02 15:03:45	2018-10-02	13
12168	2	4230	2018-10-02 15:00:47	2018-10-02	13
12169	3	4230	2018-10-03 08:34:22	2018-10-03	6
12170	2	4231	2018-10-02 14:57:18	2018-10-02	12
12171	3	4231	2018-10-02 14:57:20	2018-10-02	12
12172	2	4232	2018-10-02 14:56:53	2018-10-02	12
12173	3	4232	2018-10-02 14:56:55	2018-10-02	12
12174	2	4233	2018-10-02 14:56:00	2018-10-02	12
12175	3	4233	2018-10-02 14:56:02	2018-10-02	12
12176	2	4234	2018-10-02 14:55:43	2018-10-02	12
12177	3	4234	2018-10-02 14:55:45	2018-10-02	12
12178	2	4235	2018-10-02 14:54:45	2018-10-02	12
12179	3	4235	2018-10-02 14:54:47	2018-10-02	12
12180	2	4236	2018-10-02 14:59:32	2018-10-02	12
12181	3	4236	2018-10-02 14:59:34	2018-10-02	12
12182	2	4237	2018-10-02 14:54:00	2018-10-02	12
12183	3	4237	2018-10-02 14:54:02	2018-10-02	12
12184	2	4238	2018-10-02 14:47:18	2018-10-02	12
12185	3	4238	2018-10-02 14:47:20	2018-10-02	12
12186	2	4239	2018-10-02 14:39:00	2018-10-02	12
12187	3	4239	2018-10-02 14:39:02	2018-10-02	12
12188	2	4240	2018-10-02 14:31:18	2018-10-02	12
12189	3	4240	2018-10-02 14:31:20	2018-10-02	12
12190	2	4241	2018-10-02 14:31:41	2018-10-02	12
12191	3	4241	2018-10-02 14:31:43	2018-10-02	12
12192	2	4242	2018-10-02 14:29:05	2018-10-02	12
12193	3	4242	2018-10-02 14:29:07	2018-10-02	12
12194	2	4243	2018-10-02 14:24:55	2018-10-02	12
12195	3	4243	2018-10-02 14:24:57	2018-10-02	12
12196	2	4244	2018-10-02 14:21:44	2018-10-02	12
12197	3	4244	2018-10-02 14:21:46	2018-10-02	12
12198	2	4245	2018-10-02 14:14:06	2018-10-02	12
12199	3	4245	2018-10-02 14:14:08	2018-10-02	12
12200	2	4246	2018-10-02 14:09:10	2018-10-02	12
12201	3	4246	2018-10-02 14:09:12	2018-10-02	12
12202	2	4247	2018-10-02 14:08:35	2018-10-02	12
12203	3	4247	2018-10-02 14:08:37	2018-10-02	12
12204	2	4248	2018-10-02 14:06:21	2018-10-02	12
12205	3	4248	2018-10-02 14:06:23	2018-10-02	12
12206	2	4249	2018-10-02 14:05:15	2018-10-02	12
12207	3	4249	2018-10-02 14:05:17	2018-10-02	12
12208	2	4250	2018-10-02 14:04:30	2018-10-02	12
12209	3	4250	2018-10-02 14:04:32	2018-10-02	12
12210	2	4251	2018-10-02 14:04:48	2018-10-02	12
12211	3	4251	2018-10-02 14:04:50	2018-10-02	12
12212	2	4252	2018-10-02 12:52:23	2018-10-02	10
12213	3	4252	2018-10-02 12:55:00	2018-10-02	10
12214	2	4253	2018-10-02 12:28:55	2018-10-02	10
12215	3	4253	2018-10-02 12:28:56	2018-10-02	10
12216	2	4254	2018-10-02 12:19:22	2018-10-02	10
12217	3	4254	2018-10-02 13:47:25	2018-10-02	11
12218	2	4255	2018-10-02 12:16:47	2018-10-02	10
12219	3	4255	2018-10-02 12:18:27	2018-10-02	10
12220	2	4256	2018-10-02 12:03:07	2018-10-02	10
12221	3	4256	2018-10-02 15:51:58	2018-10-02	13
12222	2	4257	2018-10-02 11:54:34	2018-10-02	9
12223	3	4257	2018-10-02 11:54:36	2018-10-02	9
12224	2	4258	2018-10-02 11:50:09	2018-10-02	9
12225	3	4258	2018-10-02 11:50:11	2018-10-02	9
12226	2	4259	2018-10-02 11:45:48	2018-10-02	9
12227	3	4259	2018-10-02 11:45:49	2018-10-02	9
12228	2	4260	2018-10-02 11:45:17	2018-10-02	9
12229	3	4260	2018-10-02 11:45:19	2018-10-02	9
12230	2	4261	2018-10-02 11:42:43	2018-10-02	9
12231	3	4261	2018-10-02 11:42:44	2018-10-02	9
12232	2	4262	2018-10-02 11:42:06	2018-10-02	9
12233	3	4262	2018-10-02 11:42:08	2018-10-02	9
12234	2	4263	2018-10-02 11:42:53	2018-10-02	9
12235	3	4263	2018-10-03 14:46:20	2018-10-03	12
12236	2	4264	2018-10-02 11:39:35	2018-10-02	9
12237	3	4264	2018-10-02 11:39:36	2018-10-02	9
12238	2	4265	2018-10-02 11:35:30	2018-10-02	9
12239	3	4265	2018-10-02 11:35:32	2018-10-02	9
12240	2	4266	2018-10-02 11:33:00	2018-10-02	9
12241	3	4266	2018-10-02 11:46:54	2018-10-02	9
12242	2	4267	2018-10-02 11:29:44	2018-10-02	9
12243	3	4267	2018-10-02 11:29:46	2018-10-02	9
12244	2	4268	2018-10-02 11:28:54	2018-10-02	9
12245	3	4268	2018-10-03 10:48:55	2018-10-03	8
12246	2	4269	2018-10-02 11:20:55	2018-10-02	9
12247	3	4269	2018-10-02 11:20:56	2018-10-02	9
12248	2	4270	2018-10-02 11:19:51	2018-10-02	9
12249	3	4270	2018-10-02 11:19:53	2018-10-02	9
12250	2	4271	2018-10-02 11:15:45	2018-10-02	9
12251	3	4271	2018-10-02 11:15:47	2018-10-02	9
12252	2	4272	2018-10-02 11:10:03	2018-10-02	9
12253	3	4272	2018-10-02 11:10:05	2018-10-02	9
12254	2	4273	2018-10-02 11:08:21	2018-10-02	9
12255	3	4273	2018-10-02 11:08:23	2018-10-02	9
12256	2	4274	2018-10-02 11:07:34	2018-10-02	9
12257	3	4274	2018-10-02 11:07:35	2018-10-02	9
12258	2	4275	2018-10-02 11:06:42	2018-10-02	9
12259	3	4275	2018-10-02 11:06:44	2018-10-02	9
12260	2	4276	2018-10-02 10:59:17	2018-10-02	8
12261	3	4276	2018-10-02 10:59:19	2018-10-02	8
12262	2	4277	2018-10-02 10:59:17	2018-10-02	8
12263	3	4277	2018-10-02 10:59:19	2018-10-02	8
12264	2	4278	2018-10-02 10:52:57	2018-10-02	8
12265	3	4278	2018-10-02 11:44:07	2018-10-02	9
12266	2	4279	2018-10-02 10:48:14	2018-10-02	8
12267	3	4279	2018-10-02 10:48:16	2018-10-02	8
12268	2	4280	2018-10-02 10:49:18	2018-10-02	8
12269	3	4280	2018-10-02 11:14:57	2018-10-02	9
12270	2	4281	2018-10-02 10:46:44	2018-10-02	8
12271	3	4281	2018-10-02 10:46:46	2018-10-02	8
12272	2	4282	2018-10-02 10:39:59	2018-10-02	8
12273	3	4282	2018-10-02 10:40:01	2018-10-02	8
12274	2	4283	2018-10-02 10:39:26	2018-10-02	8
12275	3	4283	2018-10-02 10:39:28	2018-10-02	8
12276	2	4284	2018-10-02 10:35:51	2018-10-02	8
12277	3	4284	2018-10-03 11:04:07	2018-10-03	9
12278	2	4285	2018-10-02 10:31:47	2018-10-02	8
12279	3	4285	2018-10-03 11:05:56	2018-10-03	9
12280	2	4286	2018-10-02 10:27:42	2018-10-02	8
12281	3	4286	2018-10-02 10:27:44	2018-10-02	8
12282	2	4287	2018-10-02 10:26:46	2018-10-02	8
12283	3	4287	2018-10-02 10:26:48	2018-10-02	8
12284	2	4288	2018-10-02 10:24:54	2018-10-02	8
12285	3	4288	2018-10-02 10:24:56	2018-10-02	8
12286	2	4289	2018-10-02 10:24:11	2018-10-02	8
12287	3	4289	2018-10-02 10:24:13	2018-10-02	8
12288	2	4290	2018-10-02 10:23:28	2018-10-02	8
12289	3	4290	2018-10-02 10:23:30	2018-10-02	8
12290	2	4291	2018-10-02 10:21:45	2018-10-02	8
12291	3	4291	2018-10-02 10:21:47	2018-10-02	8
12292	2	4292	2018-10-02 10:19:56	2018-10-02	8
12293	3	4292	2018-10-02 10:19:57	2018-10-02	8
12294	2	4293	2018-10-02 10:14:55	2018-10-02	8
12295	3	4293	2018-10-02 10:14:57	2018-10-02	8
12296	2	4294	2018-10-02 10:11:44	2018-10-02	8
12297	3	4294	2018-10-02 10:11:46	2018-10-02	8
12298	2	4295	2018-10-02 10:10:38	2018-10-02	8
12299	3	4295	2018-10-02 10:10:40	2018-10-02	8
12300	2	4296	2018-10-02 10:12:49	2018-10-02	8
12301	3	4296	2018-10-04 08:37:08	2018-10-04	6
12302	2	4297	2018-10-02 10:10:07	2018-10-02	8
12303	3	4297	2018-10-02 10:10:09	2018-10-02	8
12304	2	4298	2018-10-02 10:08:47	2018-10-02	8
12305	3	4298	2018-10-02 10:08:49	2018-10-02	8
12306	2	4299	2018-10-02 10:05:44	2018-10-02	8
12307	3	4299	2018-10-02 10:05:46	2018-10-02	8
12308	2	4300	2018-10-02 10:05:24	2018-10-02	8
12309	3	4300	2018-10-02 10:05:26	2018-10-02	8
12310	2	4301	2018-10-02 10:04:26	2018-10-02	8
12311	3	4301	2018-10-02 10:04:28	2018-10-02	8
12312	2	4302	2018-10-02 10:04:00	2018-10-02	8
12313	3	4302	2018-10-02 10:04:02	2018-10-02	8
12314	2	4303	2018-10-02 09:59:55	2018-10-02	7
12315	3	4303	2018-10-03 10:53:10	2018-10-03	8
12316	2	4304	2018-10-02 09:53:50	2018-10-02	7
12317	3	4304	2018-10-02 09:53:52	2018-10-02	7
12318	2	4305	2018-10-02 09:54:09	2018-10-02	7
12319	3	4305	2018-10-02 11:42:08	2018-10-02	9
12320	2	4306	2018-10-02 09:52:42	2018-10-02	7
12321	3	4306	2018-10-02 09:52:44	2018-10-02	7
12322	2	4307	2018-10-02 09:51:39	2018-10-02	7
12323	3	4307	2018-10-02 09:51:41	2018-10-02	7
12324	2	4308	2018-10-02 09:52:30	2018-10-02	7
12325	3	4308	2018-10-02 11:43:08	2018-10-02	9
12326	2	4309	2018-10-02 09:51:28	2018-10-02	7
12327	3	4309	2018-10-02 09:51:30	2018-10-02	7
12328	2	4310	2018-10-02 09:50:39	2018-10-02	7
12329	3	4310	2018-10-02 09:50:41	2018-10-02	7
12330	2	4311	2018-10-02 09:49:58	2018-10-02	7
12331	3	4311	2018-10-02 09:50:00	2018-10-02	7
12332	2	4312	2018-10-02 09:50:20	2018-10-02	7
12333	3	4312	2018-10-02 10:59:20	2018-10-02	8
12334	2	4313	2018-10-02 09:47:51	2018-10-02	7
12335	3	4313	2018-10-02 09:47:53	2018-10-02	7
12336	2	4314	2018-10-02 09:44:02	2018-10-02	7
12337	3	4314	2018-10-02 09:44:04	2018-10-02	7
12338	2	4315	2018-10-02 09:41:47	2018-10-02	7
12339	3	4315	2018-10-02 09:41:49	2018-10-02	7
12340	2	4316	2018-10-02 09:40:10	2018-10-02	7
12341	3	4316	2018-10-02 09:40:12	2018-10-02	7
12342	2	4317	2018-10-02 09:37:55	2018-10-02	7
12343	3	4317	2018-10-02 09:37:56	2018-10-02	7
12344	2	4318	2018-10-02 09:33:17	2018-10-02	7
12345	3	4318	2018-10-02 09:33:19	2018-10-02	7
12346	2	4319	2018-10-02 09:32:07	2018-10-02	7
12347	3	4319	2018-10-02 09:32:09	2018-10-02	7
12348	2	4320	2018-10-02 09:28:21	2018-10-02	7
12349	3	4320	2018-10-02 09:28:22	2018-10-02	7
12350	2	4321	2018-10-02 09:31:08	2018-10-02	7
12351	3	4321	2018-10-02 11:21:38	2018-10-02	9
12352	2	4322	2018-10-02 09:26:58	2018-10-02	7
12353	3	4322	2018-10-02 09:27:01	2018-10-02	7
12354	2	4323	2018-10-02 09:23:07	2018-10-02	7
12355	3	4323	2018-10-02 09:23:09	2018-10-02	7
12356	2	4324	2018-10-02 09:22:22	2018-10-02	7
12357	3	4324	2018-10-02 09:22:24	2018-10-02	7
12358	2	4325	2018-10-02 09:20:44	2018-10-02	7
12359	3	4325	2018-10-02 09:20:45	2018-10-02	7
12360	2	4326	2018-10-02 09:18:10	2018-10-02	7
12361	3	4326	2018-10-02 09:18:12	2018-10-02	7
12362	2	4327	2018-10-02 09:17:08	2018-10-02	7
12363	3	4327	2018-10-02 09:17:10	2018-10-02	7
12364	2	4328	2018-10-02 09:17:05	2018-10-02	7
12365	3	4328	2018-10-02 09:17:07	2018-10-02	7
12366	2	4329	2018-10-02 09:13:58	2018-10-02	7
12367	3	4329	2018-10-02 09:14:00	2018-10-02	7
12368	2	4330	2018-10-02 09:14:36	2018-10-02	7
12369	3	4330	2018-10-02 09:14:38	2018-10-02	7
12370	2	4331	2018-10-02 09:12:37	2018-10-02	7
12371	3	4331	2018-10-02 09:12:39	2018-10-02	7
12372	2	4332	2018-10-02 09:12:02	2018-10-02	7
12373	3	4332	2018-10-02 09:12:04	2018-10-02	7
12374	2	4333	2018-10-02 09:10:44	2018-10-02	7
12375	3	4333	2018-10-02 09:10:46	2018-10-02	7
12376	2	4334	2018-10-02 09:06:39	2018-10-02	7
12377	3	4334	2018-10-02 09:06:41	2018-10-02	7
12378	2	4335	2018-10-02 09:02:32	2018-10-02	7
12379	3	4335	2018-10-02 09:02:34	2018-10-02	7
12380	2	4336	2018-10-02 08:59:44	2018-10-02	6
12381	3	4336	2018-10-02 08:59:46	2018-10-02	6
12382	2	4337	2018-10-02 08:58:42	2018-10-02	6
12383	3	4337	2018-10-02 08:58:44	2018-10-02	6
12384	2	4338	2018-10-02 08:58:04	2018-10-02	6
12385	3	4338	2018-10-02 08:58:05	2018-10-02	6
12386	2	4339	2018-10-02 08:56:48	2018-10-02	6
12387	3	4339	2018-10-02 08:56:50	2018-10-02	6
12388	2	4340	2018-10-02 08:56:09	2018-10-02	6
12389	3	4340	2018-10-02 08:56:11	2018-10-02	6
12390	2	4341	2018-10-02 08:55:41	2018-10-02	6
12391	3	4341	2018-10-02 08:55:43	2018-10-02	6
12392	2	4342	2018-10-02 08:55:15	2018-10-02	6
12393	3	4342	2018-10-02 08:55:17	2018-10-02	6
12394	2	4343	2018-10-02 08:54:40	2018-10-02	6
12395	3	4343	2018-10-02 08:54:42	2018-10-02	6
12396	2	4344	2018-10-02 08:47:43	2018-10-02	6
12397	3	4344	2018-10-02 08:47:45	2018-10-02	6
12398	2	4345	2018-10-01 16:50:03	2018-10-01	14
12399	3	4345	2018-10-01 16:50:05	2018-10-01	14
12400	2	4346	2018-10-01 16:47:16	2018-10-01	14
12401	3	4346	2018-10-01 16:47:18	2018-10-01	14
12402	2	4347	2018-10-01 16:46:11	2018-10-01	14
12403	3	4347	2018-10-01 16:46:13	2018-10-01	14
12404	2	4348	2018-10-01 16:45:40	2018-10-01	14
12405	3	4348	2018-10-01 16:45:42	2018-10-01	14
12406	2	4349	2018-10-01 16:42:07	2018-10-01	14
12407	3	4349	2018-10-01 16:42:09	2018-10-01	14
12408	2	4350	2018-10-01 16:29:15	2018-10-01	14
12409	3	4350	2018-10-01 16:29:17	2018-10-01	14
12410	2	4351	2018-10-01 16:27:56	2018-10-01	14
12411	3	4351	2018-10-01 16:27:57	2018-10-01	14
12412	2	4352	2018-10-01 16:25:23	2018-10-01	14
12413	3	4352	2018-10-02 09:41:09	2018-10-02	7
12414	2	4353	20