import responses
from django.contrib.auth.models import User
from django.core.management import call_command

from eo_gestion.eo_facture.models import Client
from eo_gestion.eo_redmine.models import Project


@responses.activate
def test_update_project(db, settings):
    settings.REDMINE_BASE_URL = 'http://redmine.example.com/'

    client = Client.objects.create(nom='client 1')
    cpf = User.objects.create(username='jdoe')

    responses.get(
        'http://redmine.example.com/users.json',
        json={'total_count': 1, 'users': [{'id': 1, 'login': 'jdoe'}]},
    )

    responses.get(
        'http://redmine.example.com/projects.json',
        json={
            'total_count': 2,
            'projects': [
                {
                    'id': 1,
                    'name': 'project clients',
                    'status': 1,
                },
                {
                    'id': 2,
                    'name': 'projet du client 1',
                    'parent': {
                        'id': 1,
                        'name': 'projets clients',
                    },
                    'status': 1,
                },
            ],
        },
    )

    responses.get(
        'http://redmine.example.com/projects/2/memberships.json',
        json={
            'total_count': 1,
            'memberships': [
                {
                    'user': {
                        'id': 1,
                    },
                    'roles': [{'name': 'CPF'}],
                }
            ],
        },
    )

    assert not Project.objects.count()

    call_command('update-projects')

    assert Project.objects.count()
    assert not client.concerned.exists()

    project = Project.objects.get()
    project.clients.add(client)

    call_command('update-projects')
    assert set(client.concerned.all()) == {cpf}
    assert set(project.cpfs.all()) == {cpf}

    responses.replace(
        responses.GET,
        'http://redmine.example.com/projects/2/memberships.json',
        json={
            'total_count': 0,
            'memberships': [],
        },
    )
    call_command('update-projects')
    assert set(client.concerned.all()) == {cpf}
    assert set(project.cpfs.all()) == set()
