# barbacompta - invoicing for dummies
# Copyright (C) 2019-2020 Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pytest


@pytest.fixture
def homepage(app):
    response = app.get('/').follow()

    response.form.set('username', 'admin')
    response.form.set('password', 'admin')

    return response.form.submit().follow()


def test_misc(homepage):
    clients = homepage.click('Clients')
    str(clients)
    ajouter_un_client = homepage.click('Ajouter un client')
    str(ajouter_un_client)
    contrats = homepage.click('Contrats')
    contrat_2c210afd24c11596eeaf94bfb = contrats.click('2c210afd24c11596eeaf94bfb', href='change')
    str(contrat_2c210afd24c11596eeaf94bfb)
    ajouter_un_contrat = homepage.click('Ajouter un contrat')
    str(ajouter_un_contrat)
    compte_en_banque = homepage.click('Compte en banque')
    str(compte_en_banque)
    factures = homepage.click('Factures')
    factures_00137 = factures.click('F20190137')
    str(factures_00137)
    rapid = factures.click('Rapid')
    str(rapid)


def test_ods_export(app):
    response = app.get('/eo_facture/facture/').follow()

    response.form.set('username', 'admin')
    response.form.set('password', 'admin')

    factures = response.form.submit().follow()

    response = factures.click('Export ODS')
    assert 'factures.ods' in response['Content-Disposition']


def test_odt_export(app):
    response = app.get('/eo_facture/contrat/').follow()
    response.form.set('username', 'admin')
    response.form.set('password', 'admin')

    contracts = response.form.submit().follow()
    form = contracts.forms['changelist-form']
    for i in range(5):
        form.set('_selected_action', True, index=i)
    form['action'] = 'export_references_as_fodt'
    res = form.submit('Go')
    assert res.status_code == 200
    assert res.content_type == 'application/vnd.oasis.opendocument.text'


def test_zip_export(app):
    response = app.get('/eo_facture/facture/').follow()
    response.form.set('username', 'admin')
    response.form.set('password', 'admin')

    factures = response.form.submit().follow()
    form = factures.forms['changelist-form']
    for i in range(5):
        form.set('_selected_action', True, index=i)
    form['action'] = 'export_invoices_as_zip'
    res = form.submit('Go')
    assert res.status_code == 200
    assert res.content_type == 'application/zip'


def test_previsionnel_par_client(homepage):
    table = set()
    for tr in homepage.pyquery('table#table-previsional-income-by-client tr').items():
        table.add(frozenset(td.text() for td in tr.find('td').items()))
    expected = [
        ['81,85', '0,00', '0,00\xa0%', '100,00\xa0%', 'bf6c03cf2f40c', '26\xa0022,00', '0,94\xa0%'],
        ['21\xa0455,00', '0,00', '0,77\xa0%', '100,00\xa0%', '0,00\xa0%', '76,89', '9b6b4'],
        ['3\xa0500,00', '0,00', '0,00\xa0%', '100,00\xa0%', '73fd3cf7de', '72,42', '0,13\xa0%'],
        [
            '4,79\xa0%',
            '132\xa0675,00',
            '34,37',
            '97,78\xa0%',
            'b70305f',
            '2\xa0950,00',
            '2,22\xa0%',
            '129\xa0725,00',
        ],
        [
            '0,00',
            '3,21\xa0%',
            '88\xa0750,00',
            '100,00\xa0%',
            '0,00\xa0%',
            '71,62',
            '3e44a97d7946a958ebbf696ab54c',
        ],
        [
            '68,31',
            'd384f2a467ea1ba1017428a0576e62d9',
            '0,00',
            '2,17\xa0%',
            '100,00\xa0%',
            '0,00\xa0%',
            '60\xa0040,00',
        ],
        ['10\xa0500,00', '0,38\xa0%', '0,00', 'c1418af1', '100,00\xa0%', '0,00\xa0%', '83,12'],
        [
            'c3f42bb0d75d379',
            '29,58',
            '32,95\xa0%',
            '6\xa0100,85',
            '2\xa0997,65',
            '9\xa0098,50',
            '67,05\xa0%',
            '0,33\xa0%',
        ],
        [
            '25f81',
            '37,98',
            '31\xa0670,00',
            '2\xa0000,00',
            '94,06\xa0%',
            '33\xa0670,00',
            '5,94\xa0%',
            '1,22\xa0%',
        ],
        ['0,00', '0,78\xa0%', '0,00\xa0%', '100,00\xa0%', '21\xa0700,00', '11,65', 'ab41680aef75'],
        [
            '10,87',
            '81,27\xa0%',
            '42\xa0244,20',
            '18,73\xa0%',
            '8,15\xa0%',
            '225\xa0587,42',
            '183\xa0343,22',
            '39330e7522883a',
        ],
        ['0,19\xa0%', '0,00', '0,00\xa0%', '100,00\xa0%', '5\xa0295,00', '72,62', 'c7d7be8d5badfec12747fd96'],
        [
            '6\xa0000,00',
            '0,34\xa0%',
            '3\xa0305,00',
            '35,52\xa0%',
            '64,48\xa0%',
            '9\xa0305,00',
            '28,25',
            'c86e6f2c0dc710d9',
        ],
        ['0,68\xa0%', '0,00', '0031c', '18\xa0705,67', '100,00\xa0%', '0,00\xa0%', '72,30'],
        ['b86f135514068ee335', '48,79', '40\xa0962,00', '0,00', '0,00\xa0%', '100,00\xa0%', '1,48\xa0%'],
        [
            '1,20\xa0%',
            '140,00',
            '32\xa0977,00',
            '0ae83ac8',
            '44,08',
            '33\xa0117,00',
            '99,58\xa0%',
            '0,42\xa0%',
        ],
        [
            '12,60\xa0%',
            '0,30\xa0%',
            '7\xa0283,00',
            '8\xa0333,00',
            '87,40\xa0%',
            '38,28',
            '060d0',
            '1\xa0050,00',
        ],
        [
            '0,00',
            '9\xa0100,00',
            '82,74',
            '100,00\xa0%',
            '0,00\xa0%',
            '0,33\xa0%',
            '17a589db260721da2cf236d767fd',
        ],
        ['0,00', '100,00\xa0%', '16\xa0900,00', '91,02', '0,00\xa0%', '3a1512781a0a53', '0,61\xa0%'],
        ['3\xa0270,00', '0,00', '0,00\xa0%', '100,00\xa0%', '0,12\xa0%', '55c1c1ce4c022b4b13', '57,72'],
        ['0,00', '59,04', '0,00\xa0%', '100,00\xa0%', '1,32\xa0%', '36\xa0618,55', '4678b4'],
        ['0,00', '0,00\xa0%', '100,00\xa0%', 'c1ceda049dc', '1,77\xa0%', '50,55', '48\xa0926,85'],
        [
            '0,00',
            '0,15\xa0%',
            '0,00\xa0%',
            '100,00\xa0%',
            '16812c10bf8bd5e5c5f8eb6e8249dad7',
            '27,28',
            '4\xa0017,50',
        ],
        ['82,41', '0,00', '100,00\xa0%', '0,35\xa0%', '537970', '0,00\xa0%', '9\xa0600,00'],
        ['84,24', '0,00', '0,00\xa0%', '100,00\xa0%', '606f0f602285ede7', '25\xa0025,00', '0,90\xa0%'],
        ['0,00', '1,81\xa0%', '0,00\xa0%', '100,00\xa0%', '57,60', '50\xa0022,60', 'c56e9'],
        ['0,56\xa0%', '80,91', '0,00', '9c64b7cf63f9776', '100,00\xa0%', '0,00\xa0%', '15\xa0530,00'],
        [
            '49\xa0700,00',
            '1,79\xa0%',
            '88,26\xa0%',
            '5\xa0833,33',
            'a2fc8232d6d8f180e24c323b0cfdf',
            '11,74\xa0%',
            '43\xa0866,67',
            '25,76',
        ],
        [
            '29\xa0467,23',
            '36,76',
            '7,62\xa0%',
            '1,06\xa0%',
            '92,38\xa0%',
            '2\xa0246,72',
            '27\xa0220,51',
            '2d231fc85753765a0e',
        ],
        ['0,00', 'f291cca', '0,00\xa0%', '100,00\xa0%', '80,35', '11\xa0620,00', '0,42\xa0%'],
        [
            '63,76',
            '0,00',
            '0,00\xa0%',
            '100,00\xa0%',
            '30\xa0850,00',
            '1,11\xa0%',
            '11ac1ba60a1360c6203d1ab0f127f8c',
        ],
        [
            '1,00\xa0%',
            '88,94\xa0%',
            '3\xa0075,00',
            '11,06\xa0%',
            '24\xa0725,00',
            '71fddac221466eabc717114a',
            '27\xa0800,00',
            '29,25',
        ],
        ['0,00', '0,39\xa0%', '100,00\xa0%', '10\xa0925,00', '51,15', '0,00\xa0%', '4224ed042b1ce6fb174187'],
        ['11\xa0000,00', '071d6d5d4360a12dbba47d8', '0,00', '0,00\xa0%', '100,00\xa0%', '0,40\xa0%', '97,49'],
        ['62da650c65d031a7db5f0', '0,00', '0,11\xa0%', '100,00\xa0%', '0,00\xa0%', '3\xa0000,00', '50,76'],
        [
            '23\xa0930,00',
            '12,51',
            '0,86\xa0%',
            '43,59\xa0%',
            '10\xa0430,00',
            '13\xa0500,00',
            '3c4c0ae8165b90b7345e21f0792c',
            '56,41\xa0%',
        ],
        ['6905d1362215cf', '0,00', '0,23\xa0%', '6\xa0250,00', '100,00\xa0%', '0,00\xa0%', '99,25'],
        [
            '17\xa0220,00',
            '1,28\xa0%',
            '42,89',
            '98,72\xa0%',
            '17\xa0000,00',
            '0,62\xa0%',
            '220,00',
            'c39a42e4d',
        ],
        ['4ba22', '0,00', '0,43\xa0%', '100,00\xa0%', '78,95', '0,00\xa0%', '12\xa0000,00'],
        [
            '562,50',
            '97,67\xa0%',
            '24\xa0150,00',
            '0,87\xa0%',
            '23\xa0587,50',
            '39,15',
            '20ac5dd97b21b6ef0655d32',
            '2,33\xa0%',
        ],
        [
            '387,50',
            '42,27',
            '1,23\xa0%',
            '34\xa0162,50',
            '33\xa0775,00',
            '1,13\xa0%',
            'd8d2821cf1099d',
            '98,87\xa0%',
        ],
        ['0,56\xa0%', '0,00', '15\xa0500,00', '0,00\xa0%', '100,00\xa0%', '145a75400ea1fdea919b4bb', '73,95'],
        ['0,00', '82,07', '100,00\xa0%', '0,00\xa0%', '2\xa0500,00', '2a2bf548', '0,09\xa0%'],
        ['097b81431de83d2574751e1', '99,03', '0,00', '1,53\xa0%', '100,00\xa0%', '0,00\xa0%', '42\xa0450,00'],
        [
            '66,14',
            '0,00',
            '65\xa0850,00',
            '0,00\xa0%',
            '100,00\xa0%',
            '2,38\xa0%',
            '1d7aa901995f387c568b241ec9ff3b9',
        ],
        ['0,00', '859599', '13\xa0000,00', '100,00\xa0%', '0,00\xa0%', '90,41', '0,47\xa0%'],
        [
            '50,65',
            '0,10\xa0%',
            '0,00',
            'eb717ca47398b60ed80e776f0a49e1b0',
            '100,00\xa0%',
            '0,00\xa0%',
            '2\xa0700,00',
        ],
        ['28\xa0100,00', '0,00', '1,01\xa0%', '100,00\xa0%', '8ddc', '0,00\xa0%', '74,97'],
        ['45\xa0024,00', '78,52', '0,00', '1,63\xa0%', '100,00\xa0%', '0,00\xa0%', 'c0d3570ac1dd16122'],
        ['79,93', '0,00', '0,97\xa0%', '100,00\xa0%', '0,00\xa0%', '26\xa0948,60', 'e9c25'],
        [
            '0,00',
            '100,00\xa0%',
            '0,00\xa0%',
            '65fe9bf71bff6963c7d0ac6dd3c7019',
            '89,94',
            '4,73\xa0%',
            '131\xa0000,00',
        ],
        [
            'c3fa6dd02523abaab4e28b6e0cd',
            '0,00',
            '0,00\xa0%',
            '100,00\xa0%',
            '19,67',
            '0,33\xa0%',
            '9\xa0000,00',
        ],
        [
            '0,00',
            '62,65',
            '0,00\xa0%',
            '100,00\xa0%',
            '1,62\xa0%',
            '44\xa0800,00',
            'e2858d3c9294aca375a348223a45f4a6',
        ],
        ['0,00', '6e9dec375', '7\xa0800,00', '0,00\xa0%', '100,00\xa0%', '0,28\xa0%', '100,00'],
        [
            '5\xa0050,00',
            '69,16\xa0%',
            '8194d71612a5a4b5bfdf91d582327764',
            '16\xa0375,00',
            '26,36',
            '0,59\xa0%',
            '11\xa0325,00',
            '30,84\xa0%',
        ],
        [
            '19\xa0584,10',
            '85,79\xa0%',
            '2\xa0782,75',
            '16\xa0801,35',
            '14,21\xa0%',
            'f98dd57ae4ac158c7',
            '0,71\xa0%',
            '35,08',
        ],
        ['3\xa0025,00', '0,00', 'c16b09ce5ff9d6b4', '0,11\xa0%', '100,00\xa0%', '0,00\xa0%', '68,42'],
        [
            '0,00',
            '61,03',
            '0,43\xa0%',
            '100,00\xa0%',
            '0,00\xa0%',
            '11\xa0900,00',
            'a5698cdc6933401679600275e748347',
        ],
        ['92,41', '0,68\xa0%', '18\xa0939,00', '0,00', 'b5367a456', '100,00\xa0%', '0,00\xa0%'],
        [
            '2c210afd24c11596eeaf94bfb',
            '73,39',
            '0,00',
            '100,00\xa0%',
            '0,78\xa0%',
            '21\xa0500,00',
            '0,00\xa0%',
        ],
        ['53,75', 'b5be1e99', '0,00', '1,81\xa0%', '0,00\xa0%', '100,00\xa0%', '50\xa0000,00'],
        [
            '75\xa0293,75',
            '2,72\xa0%',
            '2,72',
            '41,97\xa0%',
            '58,03\xa0%',
            '43\xa0693,75',
            '31\xa0600,00',
            '1562966',
        ],
        ['75,94', '0,00', '0,97\xa0%', '100,00\xa0%', '0,00\xa0%', '20539332989c51', '26\xa0887,50'],
        [
            '180\xa0020,82',
            '19,34',
            '9\xa0000,00',
            '95,24\xa0%',
            '189\xa0020,82',
            '20a8226446',
            '6,83\xa0%',
            '4,76\xa0%',
        ],
        ['0,00', '12\xa0090,00', '0,00\xa0%', '100,00\xa0%', 'b4a8eec84', '60,60', '0,44\xa0%'],
        ['0,00', '70\xa0975,50', 'c85fb096c1da3d8', '100,00\xa0%', '2,56\xa0%', '0,00\xa0%', '47,31'],
        [
            '462a',
            '2,57\xa0%',
            '64\xa0150,00',
            '9,92\xa0%',
            '90,08\xa0%',
            '23,97',
            '71\xa0212,50',
            '7\xa0062,50',
        ],
        [
            '27,13',
            '76,78\xa0%',
            '16\xa0510,00',
            '4\xa0992,00',
            '23,22\xa0%',
            '0,78\xa0%',
            'dad006dc0bd5',
            '21\xa0502,00',
        ],
        [
            '862d8ff3b51af23d64285c43',
            '0,00',
            '1,56\xa0%',
            '43\xa0078,00',
            '0,00\xa0%',
            '100,00\xa0%',
            '97,10',
        ],
        [
            '0,79\xa0%',
            '0,00',
            '0,00\xa0%',
            '100,00\xa0%',
            '21\xa0900,00',
            'dac8bff8ffc95f131ac0dafcdfb36',
            '51,95',
        ],
        [
            '0,93\xa0%',
            '0,00',
            '0,00\xa0%',
            '100,00\xa0%',
            '0b1b26cacc602dff7219586676ad0f5d',
            '25\xa0712,50',
            '60,16',
        ],
        [
            '0,00',
            'd59aa5f7223458e5b33eb29a696',
            '93,31',
            '100,00\xa0%',
            '24\xa0960,00',
            '0,00\xa0%',
            '0,90\xa0%',
        ],
        [
            '80,00\xa0%',
            '0,63\xa0%',
            '27,91',
            '17\xa0500,00',
            '14\xa0000,00',
            '24d5',
            '20,00\xa0%',
            '3\xa0500,00',
        ],
        ['0,22\xa0%', '0,00', '83,34', '100,00\xa0%', '0,00\xa0%', '6\xa0050,00', '0973e3a7ebd843d1'],
        [
            '',
            '92,59\xa0%',
            '2\xa0563\xa0571,60',
            '205\xa0312,65',
            'Total',
            '100,00\xa0%',
            '2\xa0768\xa0884,25',
            '7,41\xa0%',
        ],
        [
            '17,32\xa0%',
            'cda12ba676314a6f47402aa83b1ed830',
            '21,40',
            '82,68\xa0%',
            '39\xa0650,00',
            '1,73\xa0%',
            '47\xa0957,50',
            '8\xa0307,50',
        ],
        [
            '1,79\xa0%',
            '0,00',
            '100,00\xa0%',
            '0,00\xa0%',
            '452f3d5ed41b3014fcf146d8c',
            '49\xa0682,50',
            '95,11',
        ],
        ['61b30ef8276e4d851b7', '0,10\xa0%', '0,00', '2\xa0750,00', '0,00\xa0%', '100,00\xa0%', '35,18'],
        ['44,74', '18\xa0275,00', '0,00', '0,00\xa0%', '100,00\xa0%', 'df2caae86e4be66bcc07', '0,66\xa0%'],
        [
            '12\xa0880,00',
            '0,00',
            '0,00\xa0%',
            '100,00\xa0%',
            '99,72',
            '94e3b765f0ef1a6321eb2b508400',
            '0,47\xa0%',
        ],
        [
            '95,54',
            '0,00',
            '0,43\xa0%',
            '100,00\xa0%',
            '0,00\xa0%',
            '3f77270a86964516d7625644',
            '12\xa0000,00',
        ],
        [
            '11\xa0850,00',
            '35,70',
            '82,58\xa0%',
            '0,52\xa0%',
            '14\xa0350,00',
            '212f2acf453fb5a7dc',
            '2\xa0500,00',
            '17,42\xa0%',
        ],
        ['0,00', '0,39\xa0%', '0,00\xa0%', '100,00\xa0%', '10\xa0700,00', '85,21', 'e8b13'],
        ['84,82', '0,00', '0,58\xa0%', '0,00\xa0%', '100,00\xa0%', '16\xa0000,00', '687d'],
        ['0,00', '76,12', '0,00\xa0%', '100,00\xa0%', '5\xa0000,00', '0,18\xa0%', '4b09a7c766dad6d6c3c85'],
        [
            '0,00',
            '55,80',
            'd5381e9ca259c32f4ae7abbf3ed61899',
            '2,05\xa0%',
            '100,00\xa0%',
            '0,00\xa0%',
            '56\xa0641,66',
        ],
        [
            'd03745646eedce1389c895c7b',
            '0,00',
            '0,23\xa0%',
            '0,00\xa0%',
            '100,00\xa0%',
            '91,73',
            '6\xa0500,00',
        ],
        [
            '99,15\xa0%',
            '51\xa0723,75',
            '1,88\xa0%',
            '444,75',
            '41,03',
            'd76cfe37',
            '0,85\xa0%',
            '52\xa0168,50',
        ],
        ['0,00', '81,98', '3\xa0650,00', '100,00\xa0%', '0,00\xa0%', 'f66253e5a', '0,13\xa0%'],
        ['91,49', '0,00', '0,00\xa0%', '100,00\xa0%', '13\xa0100,00', 'a7d5', '0,47\xa0%'],
        ['0,19\xa0%', '0,00', '5\xa0250,00', 'a511e6', '100,00\xa0%', '0,00\xa0%', '59,23'],
    ]

    assert table == {frozenset(x) for x in expected}
