# Generated by Django 2.2.9 on 2020-02-04 09:08

from django.db import migrations, models

import eo_gestion.chorus.validators


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='Structure',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.CharField(max_length=80)),
                ('full_identifier', models.CharField(max_length=78, unique=True)),
                (
                    'siret',
                    models.CharField(
                        db_index=True, max_length=14, validators=[eo_gestion.chorus.validators.validate_siret]
                    ),
                ),
                ('service_code', models.CharField(blank=True, default='', max_length=64)),
                ('service_name', models.CharField(blank=True, default='', max_length=80)),
                ('email', models.EmailField(max_length=254, null=True)),
                ('engagement_obligatoire', models.BooleanField()),
            ],
            options={
                'ordering': ('name', 'service_name'),
            },
        ),
        migrations.CreateModel(
            name='Update',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('success', models.BooleanField(default=False)),
                ('message', models.TextField()),
            ],
        ),
        migrations.AddIndex(
            model_name='structure',
            index=models.Index(fields=['name', 'service_name'], name='name_idx'),
        ),
    ]
