# Generated by Django 3.2.18 on 2024-04-17 09:54

from django.contrib.auth import hashers
from django.db import migrations


def hash_existing(apps, schema_editor):
    APIClient = apps.get_model('authentic2', 'APIClient')
    for client in APIClient.objects.all():
        try:
            hashers.identify_hasher(client.password)
        except ValueError:
            client.password = hashers.make_password(client.password)
            client.save()


def fake_hash_reverse(apps, schema_editor):
    APIClient = apps.get_model('authentic2', 'APIClient')
    for dummy in APIClient.objects.all():
        raise NotImplementedError('Not reversible')


class Migration(migrations.Migration):
    dependencies = [
        ('authentic2', '0050_initialize_users_advanced_configuration'),
    ]

    operations = [
        migrations.RunPython(hash_existing, fake_hash_reverse),
    ]
