# Generated by Django 2.2.23 on 2022-01-27 08:03


from django.db import migrations, models


def set_email_verified_date(apps, schema_editor):
    User = apps.get_model('custom_user', 'User')
    qs = User.objects.filter(email_verified=True, email_verified_date__isnull=True)
    # set all unknown dates to date joined
    qs.update(email_verified_date=models.F('date_joined'))


class Migration(migrations.Migration):
    dependencies = [
        ('custom_user', '0027_user_deactivation_reason'),
    ]

    operations = [
        migrations.AddField(
            model_name='user',
            name='email_verified_date',
            field=models.DateTimeField(
                default=None, blank=True, null=True, verbose_name='email verified date'
            ),
        ),
        migrations.RunPython(set_email_verified_date, migrations.RunPython.noop),
    ]
