from django.utils.translation import gettext_lazy as _

from authentic2.apps.journal.models import EventTypeDefinition


class OIDCBackendErrorEvent(EventTypeDefinition):
    name = 'auth.oidc.claim_error'
    label = _('OIDC authentication error')

    @classmethod
    def record(cls, *, user, session, claim, source_name, missing=True, data=None):
        data = data or {}
        data.update({'claim': claim, 'source': source_name, 'missing': missing})
        return super().record(user=user, session=session, data=data)

    @classmethod
    def get_message(cls, event, context):
        if event.get_data('missing'):
            msg = _('Missconfigured account, missing required claim %(claim)s in %(source)s')
        else:
            msg = _('Missconfigured account, invalid value for required claim %(claim)s in %(source)s')
        return msg % {'claim': event.get_data('claim'), 'source': event.get_data('source')}
