# Generated by Django 2.2.15 on 2020-08-23 16:56

import django
import django.contrib.postgres.fields
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models
from django.db.models import JSONField
from django.utils import timezone


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('authentic2', '0027_remove_deleteduser'),
        ('sessions', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='EventType',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.SlugField(max_length=256, unique=True, verbose_name='name')),
            ],
            options={
                'verbose_name': 'event type',
                'verbose_name_plural': 'event types',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                (
                    'timestamp',
                    models.DateTimeField(
                        default=timezone.now, editable=False, blank=True, verbose_name='timestamp'
                    ),
                ),
                (
                    'reference_ids',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.BigIntegerField(),
                        null=True,
                        size=None,
                        verbose_name='reference ids',
                    ),
                ),
                (
                    'reference_ct_ids',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.IntegerField(),
                        null=True,
                        size=None,
                        verbose_name='reference ct ids',
                    ),
                ),
                ('data', JSONField(null=True, verbose_name='data')),
                (
                    'session',
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to='sessions.Session',
                        verbose_name='session',
                    ),
                ),
                (
                    'type',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='journal.EventType',
                        verbose_name='type',
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name='user',
                    ),
                ),
            ],
            options={
                'verbose_name': 'event',
                'verbose_name_plural': 'events',
                'ordering': ('timestamp', 'id'),
            },
        ),
        migrations.RunSQL(
            [
                'CREATE INDEX journal_event_timestamp_id_idx ON journal_event USING BRIN("timestamp", "id");',
                'CREATE INDEX journal_event_reference_ids_idx ON journal_event USING GIN("reference_ids");',
                'CREATE INDEX journal_event_reference_ct_ids_idx ON journal_event USING'
                ' GIN("reference_ct_ids");',
            ],
            [
                'DROP INDEX journal_event_reference_ct_ids_idx;',
                'DROP INDEX journal_event_reference_ids_idx;',
                'DROP INDEX journal_event_timestamp_id_idx;',
            ],
        ),
    ]
