from django.conf import settings
from django.db import migrations


def migrate_a2_setting_registration_email_blacklist(apps, schema_editor):
    if not getattr(settings, 'A2_REGISTRATION_EMAIL_BLACKLIST', []):
        return

    LoginPasswordAuthenticator = apps.get_model('authenticators', 'LoginPasswordAuthenticator')
    authenticator, _ = LoginPasswordAuthenticator.objects.get_or_create(
        defaults={'enabled': True, 'slug': 'password-authenticator'}
    )
    authenticator.registration_forbidden_email_domains += [
        domain
        for domain in settings.A2_REGISTRATION_EMAIL_BLACKLIST
        if domain not in authenticator.registration_forbidden_email_domains
    ]
    authenticator.save()


class Migration(migrations.Migration):
    dependencies = [
        ('authenticators', '0023_baseauthenticator_button_image'),
    ]

    operations = [
        migrations.RunPython(
            migrate_a2_setting_registration_email_blacklist, reverse_code=migrations.RunPython.noop
        ),
    ]
