# Generated by Django 2.2.26 on 2022-05-17 14:24

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import authentic2.utils.evaluate


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.RBAC_OU_MODEL),
        ('a2_rbac', '0036_delete_roleattribute'),
    ]

    operations = [
        migrations.CreateModel(
            name='BaseAuthenticator',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('uuid', models.CharField(default=uuid.uuid4, editable=False, max_length=255, unique=True)),
                ('name', models.CharField(max_length=128, blank=True, verbose_name='Name')),
                ('slug', models.SlugField(unique=True)),
                ('order', models.IntegerField(default=0, verbose_name='Order', editable=False)),
                ('enabled', models.BooleanField(default=False, editable=False)),
                (
                    'show_condition',
                    models.CharField(
                        blank=True,
                        default='',
                        help_text=(
                            'Condition controlling authenticator display. '
                            'For example, "is_for_backoffice()" would show the authenticator only for backoffice access, '
                            '"is_for_frontoffice()" would show the authenticator only for frontoffice access. '
                            'Advanced configuration can be performed, for example "is_for_backoffice() or remote_addr == \'1.2.3.4\'" '
                            'would hide the authenticator from frontoffice users except if they come from the specified IP address. '
                            'Available variables include service_ou_slug, service_slug, remote_addr, login_hint and headers.'
                        ),
                        max_length=1024,
                        verbose_name='Show condition',
                        validators=[authentic2.utils.evaluate.condition_validator],
                    ),
                ),
                (
                    'ou',
                    models.ForeignKey(
                        null=True,
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.RBAC_OU_MODEL,
                        verbose_name='organizational unit',
                    ),
                ),
            ],
            options={
                'ordering': ('-enabled', 'order', 'name', 'slug', 'ou'),
            },
        ),
    ]
