# Generated by Django 2.2.26 on 2022-10-11 13:36

from django.db import migrations


def copy_operations_data(apps, schema_editor):
    OldOperation = apps.get_model('django_rbac', 'Operation')
    NewOperation = apps.get_model('a2_rbac', 'Operation')
    Permission = apps.get_model('a2_rbac', 'Permission')

    operation_map = {}
    for operation in OldOperation.objects.all():
        operation_map[operation.pk], _ = NewOperation.objects.get_or_create(slug=operation.slug)

    for permission in Permission.objects.all():
        permission.operation_new = operation_map[permission.operation_id]
        permission.save()


def reverse_copy_operations_data(apps, schema_editor):
    OldOperation = apps.get_model('django_rbac', 'Operation')
    NewOperation = apps.get_model('a2_rbac', 'Operation')
    Permission = apps.get_model('a2_rbac', 'Permission')

    operation_map = {}
    for operation in NewOperation.objects.all():
        operation_map[operation.pk], _ = OldOperation.objects.get_or_create(slug=operation.slug)

    for permission in Permission.objects.all():
        permission.operation = operation_map[permission.operation_new_id]
        permission.save()


class Migration(migrations.Migration):
    dependencies = [
        ('a2_rbac', '0031_new_operation_model'),
        ('django_rbac', '0009_auto_20221004_1343'),
    ]

    operations = [
        migrations.RunPython(copy_operations_data, reverse_code=reverse_copy_operations_data),
    ]
