# Generated by Django 2.2.27 on 2022-04-07 16:31

from django.db import migrations, models

from authentic2.migrations import DropPartialIndexes


class Migration(migrations.Migration):
    dependencies = [
        ('authentic2', '0039_add_unique_attribute_constraint'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('a2_rbac', '0028_ou_home_url'),
        ('a2_rbac', '0027_auto_20220331_1521'),
    ]

    operations = [
        DropPartialIndexes(
            'Role',
            'a2_rbac_role',
            'a2_rbac_role_unique_idx',
            ('ou_id', 'service_id'),
            ('slug',),
            null_columns=('admin_scope_ct_id',),
        ),
        DropPartialIndexes(
            'Role',
            'a2_rbac_role',
            'a2_rbac_role_name_unique_idx',
            ('ou_id',),
            ('name',),
            null_columns=('admin_scope_ct_id',),
        ),
        DropPartialIndexes(
            'Permission',
            'a2_rbac_permission',
            'a2_rbac_permission_null_ou_unique_idx',
            ('ou_id',),
            ('operation_id', 'target_ct_id', 'target_id'),
        ),
        migrations.AddConstraint(
            model_name='permission',
            constraint=models.UniqueConstraint(
                condition=models.Q(ou__isnull=True),
                fields=('operation', 'target_ct', 'target_id'),
                name='null_ou_uniq_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='role',
            constraint=models.UniqueConstraint(
                condition=models.Q(admin_scope_ct__isnull=True),
                fields=('ou', 'service', 'slug'),
                name='slug_uniq_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='role',
            constraint=models.UniqueConstraint(
                condition=models.Q(admin_scope_ct__isnull=True),
                fields=('ou', 'service', 'name'),
                name='name_uniq_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='role',
            constraint=models.UniqueConstraint(
                condition=models.Q(('admin_scope_ct__isnull', True), ('service__isnull', True)),
                fields=('ou', 'slug'),
                name='null_service_slug_uniq_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='role',
            constraint=models.UniqueConstraint(
                condition=models.Q(('admin_scope_ct__isnull', True), ('ou__isnull', True)),
                fields=('service', 'slug'),
                name='null_ou_slug_uniq_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='role',
            constraint=models.UniqueConstraint(
                condition=models.Q(
                    ('admin_scope_ct__isnull', True), ('ou__isnull', True), ('service__isnull', True)
                ),
                fields=('slug',),
                name='null_ou_service_slug_uniq_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='role',
            constraint=models.UniqueConstraint(
                condition=models.Q(('admin_scope_ct__isnull', True), ('service__isnull', True)),
                fields=('ou', 'name'),
                name='null_service_name_uniq_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='role',
            constraint=models.UniqueConstraint(
                condition=models.Q(('admin_scope_ct__isnull', True), ('ou__isnull', True)),
                fields=('service', 'name'),
                name='null_ou_name_uniq_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='role',
            constraint=models.UniqueConstraint(
                condition=models.Q(
                    ('admin_scope_ct__isnull', True), ('ou__isnull', True), ('service__isnull', True)
                ),
                fields=('name',),
                name='null_ou_service_name_uniq_idx',
            ),
        ),
    ]
