# Generated by Django 2.2.28 on 2022-04-13 13:04

from django.conf import settings
from django.db import migrations


def create_login_password_authenticator(apps, schema_editor):
    kwargs_settings = getattr(settings, 'AUTH_FRONTENDS_KWARGS', {})
    password_settings = kwargs_settings.get('password', {})

    LoginPasswordAuthenticator = apps.get_model('authenticators', 'LoginPasswordAuthenticator')
    LoginPasswordAuthenticator.objects.update_or_create(
        slug='password-authenticator',
        defaults={
            'order': password_settings.get('priority', 0),
            'show_condition': password_settings.get('show_condition') or '',
            'enabled': getattr(settings, 'A2_AUTH_PASSWORD_ENABLE', True),
            'remember_me': getattr(settings, 'A2_USER_REMEMBER_ME', None),
            'include_ou_selector': getattr(settings, 'A2_LOGIN_FORM_OU_SELECTOR', False),
        },
    )


class Migration(migrations.Migration):
    dependencies = [
        ('authenticators', '0002_loginpasswordauthenticator'),
    ]

    operations = [
        migrations.RunPython(create_login_password_authenticator, reverse_code=migrations.RunPython.noop),
    ]
