# Generated by Django 2.2.28 on 2022-04-13 14:32

import django.db.models.deletion
from django.db import migrations, models
from django.db.migrations.operations.base import Operation


class AlterModelBase(Operation):
    def __init__(self, model_name, base_name):
        self.model_name = model_name
        self.base_name = base_name

    def state_forwards(self, app_label, state):
        model_state = state.models[app_label, self.model_name]
        model_state.bases = (self.base_name,)
        state.reload_model(app_label, self.model_name, delay=True)

    def database_forwards(self, app_label, schema_editor, from_state, to_state):
        pass

    def database_backwards(self, app_label, schema_editor, from_state, to_state):
        pass


class Migration(migrations.Migration):
    dependencies = [
        ('authentic2_auth_oidc', '0010_auto_20220413_1622'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='oidcprovider',
            name='id',
        ),
        migrations.RemoveField(
            model_name='oidcprovider',
            name='name',
        ),
        migrations.RemoveField(
            model_name='oidcprovider',
            name='ou',
        ),
        migrations.RemoveField(
            model_name='oidcprovider',
            name='show',
        ),
        migrations.RemoveField(
            model_name='oidcprovider',
            name='slug',
        ),
        migrations.AlterField(
            model_name='oidcprovider',
            name='baseauthenticator_ptr',
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to='authenticators.BaseAuthenticator',
            ),
        ),
        AlterModelBase('oidcprovider', 'authenticators.baseauthenticator'),
    ]
