# Generated by Django 3.2.18 on 2023-06-01 15:44

from django.conf import settings
from django.db import migrations


def migrate_a2_accept_authentication_settings(apps, schema_editor):
    LoginPasswordAuthenticator = apps.get_model('authenticators', 'LoginPasswordAuthenticator')
    authenticator, _ = LoginPasswordAuthenticator.objects.get_or_create(
        slug='password-authenticator',
        defaults={'enabled': True},
    )
    authenticator.accept_email_authentication = getattr(settings, 'A2_ACCEPT_EMAIL_AUTHENTICATION', True)
    authenticator.accept_phone_authentication = getattr(settings, 'A2_ACCEPT_PHONE_AUTHENTICATION', False)
    authenticator.save()


class Migration(migrations.Migration):
    dependencies = [
        ('authenticators', '0010_auto_20230614_1017'),
    ]

    operations = [
        migrations.RunPython(
            migrate_a2_accept_authentication_settings, reverse_code=migrations.RunPython.noop
        ),
    ]
