# Generated by Django 4.2.15 on 2025-05-22 08:10

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import authentic2_idp_oidc.models


class Migration(migrations.Migration):

    dependencies = [
        ('custom_user', '0037_user_first_name_last_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('authentic2_idp_oidc', '0022_oidcclient_uses_refresh_tokens'),
    ]

    operations = [
        migrations.CreateModel(
            name='OIDCRefreshToken',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'uuid',
                    models.CharField(
                        db_index=True,
                        default=authentic2_idp_oidc.models.generate_uuid,
                        max_length=128,
                        verbose_name='uuid',
                    ),
                ),
                ('scopes', models.TextField(verbose_name='scopes')),
                (
                    'created',
                    models.DateTimeField(auto_now_add=True, verbose_name='created'),
                ),
                ('expired', models.DateTimeField(null=True, verbose_name='expire')),
                (
                    'client',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='authentic2_idp_oidc.oidcclient',
                        verbose_name='client',
                    ),
                ),
                (
                    'profile',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to='custom_user.profile',
                        verbose_name='profile',
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name='user',
                    ),
                ),
                (
                    'refresh_token',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to='authentic2_idp_oidc.oidcrefreshtoken',
                        verbose_name='refresh token',
                    ),
                ),
            ],
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='oidcaccesstoken',
            name='refresh_token',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to='authentic2_idp_oidc.oidcrefreshtoken',
                verbose_name='refresh token',
            ),
        ),
    ]
