# Generated by Django 2.2.26 on 2022-06-15 15:00

import django
import django.db.models.deletion
from django.db import migrations, models
from django.db.models import JSONField

import authentic2_auth_saml.models
from authentic2_auth_saml.models import NAME_ID_FORMAT_CHOICES


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('authenticators', '0003_auto_20220413_1504'),
    ]

    operations = [
        migrations.CreateModel(
            name='SAMLAuthenticator',
            fields=[
                (
                    'baseauthenticator_ptr',
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to='authenticators.BaseAuthenticator',
                    ),
                ),
                ('metadata_url', models.URLField(blank=True, max_length=300, verbose_name='Metadata URL')),
                (
                    'metadata_cache_time',
                    models.PositiveSmallIntegerField(default=3600, verbose_name='Metadata cache time'),
                ),
                (
                    'metadata_http_timeout',
                    models.PositiveSmallIntegerField(default=10, verbose_name='Metadata HTTP timeout'),
                ),
                (
                    'metadata_path',
                    models.CharField(
                        blank=True,
                        help_text='Absolute path to the IdP metadata file.',
                        max_length=300,
                        verbose_name='Metadata file path',
                    ),
                ),
                (
                    'metadata',
                    models.TextField(
                        blank=True,
                        validators=[authentic2_auth_saml.models.validate_metadata],
                        verbose_name='Metadata (XML)',
                    ),
                ),
                (
                    'provision',
                    models.BooleanField(
                        default=True, verbose_name='Create user if their username does not already exists'
                    ),
                ),
                (
                    'verify_ssl_certificate',
                    models.BooleanField(
                        default=True,
                        help_text=(
                            'Verify SSL certificate when doing HTTP requests, used when resolving artifacts.'
                        ),
                        verbose_name='Verify SSL certificate',
                    ),
                ),
                (
                    'transient_federation_attribute',
                    models.CharField(
                        blank=True,
                        help_text=(
                            'Name of an attribute to use in replacement of the NameID content when the NameID'
                            ' format is transient.'
                        ),
                        max_length=64,
                        verbose_name='Transient federation attribute',
                    ),
                ),
                (
                    'realm',
                    models.CharField(
                        default='saml',
                        help_text='The default realm to associate to user, can be used in username template.',
                        max_length=32,
                        verbose_name='Realm (realm)',
                    ),
                ),
                (
                    'username_template',
                    models.CharField(
                        default='{attributes[name_id_content]}@{realm}',
                        help_text=(
                            'The template to build and/or retrieve a user from its username based on received'
                            ' attributes, the syntax is the one from the str.format() method of Python.'
                            ' Available variables are realm, idp (current settings for the idp issuing the'
                            ' assertion), attributes. The default value is'
                            ' {attributes[name_id_content]}@{realm}. Another example could be'
                            ' {atttributes[uid][0]} to set the passed username as the username of the newly'
                            ' created user.'
                        ),
                        max_length=128,
                        verbose_name='Username template',
                    ),
                ),
                (
                    'name_id_policy_format',
                    models.CharField(
                        blank=True,
                        help_text='The NameID format to request.',
                        max_length=64,
                        verbose_name='NameID policy format',
                        choices=NAME_ID_FORMAT_CHOICES,
                    ),
                ),
                (
                    'name_id_policy_allow_create',
                    models.BooleanField(default=True, verbose_name='NameID policy allow create'),
                ),
                (
                    'force_authn',
                    models.BooleanField(
                        default=False,
                        help_text='Force authentication on each authentication request.',
                        verbose_name='Force authn',
                    ),
                ),
                (
                    'add_authnrequest_next_url_extension',
                    models.BooleanField(default=False, verbose_name='Add authnrequest next url extension'),
                ),
                (
                    'group_attribute',
                    models.CharField(
                        blank=True,
                        help_text=(
                            'Name of the SAML attribute to map to Django group names (for example "role").'
                        ),
                        max_length=32,
                        verbose_name='Group attribute',
                    ),
                ),
                (
                    'create_group',
                    models.BooleanField(
                        default=True,
                        help_text='Create group or only assign existing groups.',
                        verbose_name='Create group',
                    ),
                ),
                (
                    'error_url',
                    models.URLField(
                        blank=True,
                        help_text=(
                            'URL for the continue link when authentication fails. If not set, the RelayState'
                            ' is used. If there is no RelayState, application default login redirect URL is'
                            ' used.'
                        ),
                        verbose_name='Error URL',
                    ),
                ),
                (
                    'error_redirect_after_timeout',
                    models.PositiveSmallIntegerField(
                        default=120,
                        help_text=(
                            'Timeout in seconds before automatically redirecting the user to the continue URL'
                            ' when authentication has failed.'
                        ),
                        verbose_name='Error redirect after timeout',
                    ),
                ),
                (
                    'authn_classref',
                    models.CharField(
                        blank=True,
                        help_text=(
                            'Authorized authentication class references, separated by commas. Empty value'
                            ' means everything is authorized. Authentication class reference must be obtained'
                            ' from the identity provider but should come from the SAML 2.0 specification.'
                        ),
                        max_length=512,
                        verbose_name='Authn classref',
                    ),
                ),
                (
                    'login_hints',
                    models.CharField(
                        blank=True,
                        help_text='Comma separated list.',
                        max_length=512,
                        verbose_name='Login hints',
                    ),
                ),
                (
                    'lookup_by_attributes',
                    JSONField(
                        blank=True,
                        default=list,
                        help_text=(
                            'Allow looking for user with some SAML attributes if the received NameID is still'
                            ' unknown. It must be a list of dictionnaries with two mandatory keys'
                            ' `user_field` and `saml_attribute`. The optionnal key `ignore-case` should be a'
                            ' boolean indicating if the match is case-insensitive (default is to respect the'
                            ' case).'
                        ),
                        verbose_name='Lookup by attributes',
                    ),
                ),
                (
                    'a2_attribute_mapping',
                    JSONField(
                        blank=True,
                        default=list,
                        help_text=(
                            'Copy incoming SAML attributes to user attributes, for example for example'
                            ' [{"attribute": "email", "saml_attribute": "mail", "mandatory": false}].'
                        ),
                        verbose_name='Attribute mapping',
                    ),
                ),
                (
                    'attribute_mapping',
                    JSONField(
                        blank=True,
                        default=dict,
                        help_text=(
                            'Maps templates based on SAML attributes to field of the user model, for example'
                            ' {"email": "attributes[mail][0]"}.'
                        ),
                        verbose_name='Attribute mapping (deprecated)',
                    ),
                ),
                (
                    'superuser_mapping',
                    JSONField(
                        blank=True,
                        default=dict,
                        editable=False,
                        help_text=(
                            'Gives superuser flags to user if a SAML attribute contains a given value, for'
                            ' example {"roles": "Admin"}.'
                        ),
                        verbose_name='Superuser mapping',
                    ),
                ),
            ],
            options={
                'verbose_name': 'SAML',
            },
            bases=('authenticators.baseauthenticator',),
        ),
    ]
