# Generated by Django 2.2.24 on 2022-02-21 14:09

import uuid

import django
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models
from django.db.models import JSONField


class Migration(migrations.Migration):
    dependencies = [
        ('custom_user', '0028_user_email_verified_date'),
    ]

    operations = [
        migrations.CreateModel(
            name='ProfileType',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                (
                    'uuid',
                    models.UUIDField(verbose_name='UUID', unique=True, default=uuid.uuid4, editable=False),
                ),
                ('name', models.CharField(max_length=64, verbose_name='name')),
                ('slug', models.SlugField(max_length=64, unique=True, verbose_name='slug')),
            ],
            options={
                'verbose_name': 'profile type',
                'verbose_name_plural': 'profile types',
                'ordering': ('name', 'slug'),
            },
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                (
                    'identifier',
                    models.CharField(default='', max_length=256, verbose_name='identifier'),
                ),
                (
                    'data',
                    JSONField(blank=True, null=True, verbose_name='data'),
                ),
                (
                    'profile_type',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='profiles',
                        to='custom_user.ProfileType',
                        verbose_name='profile type',
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='profiles',
                        to=settings.AUTH_USER_MODEL,
                        verbose_name='user',
                    ),
                ),
            ],
            options={
                'verbose_name': 'profile',
                'verbose_name_plural': 'profiles',
                'ordering': ('user', 'profile_type'),
                'unique_together': {('user', 'profile_type', 'identifier')},
            },
        ),
    ]
