# Generated by Django 2.2.26 on 2022-08-18 16:32

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.RBAC_ROLE_MODEL),
        ('authentic2_auth_saml', '0004_remove_samlauthenticator_login_hints'),
    ]

    operations = [
        migrations.CreateModel(
            name='SetAttributeAction',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('attribute', models.CharField(max_length=256, verbose_name='User field')),
                ('saml_attribute', models.CharField(max_length=1024, verbose_name='SAML attribute name')),
                (
                    'mandatory',
                    models.BooleanField(
                        default=False,
                        help_text='Login will also be denied if attribute has more than one value.',
                        verbose_name='Deny login if attribute is missing',
                    ),
                ),
                (
                    'authenticator',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='set_attribute_actions',
                        to='authentic2_auth_saml.SAMLAuthenticator',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Set an attribute',
                'verbose_name_plural': 'Set attributes',
                'default_related_name': 'set_attribute_actions',
            },
        ),
        migrations.CreateModel(
            name='SAMLAttributeLookup',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('user_field', models.CharField(max_length=256, verbose_name='User field')),
                ('saml_attribute', models.CharField(max_length=1024, verbose_name='SAML attribute')),
                ('ignore_case', models.BooleanField(default=False, verbose_name='Ignore case')),
                (
                    'authenticator',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='attribute_lookups',
                        to='authentic2_auth_saml.SAMLAuthenticator',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Attribute lookup',
                'verbose_name_plural': 'Lookup by attributes',
                'default_related_name': 'attribute_lookups',
            },
        ),
        migrations.CreateModel(
            name='RenameAttributeAction',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('from_name', models.CharField(max_length=1024, verbose_name='From')),
                ('to_name', models.CharField(max_length=64, verbose_name='To')),
                (
                    'authenticator',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='rename_attribute_actions',
                        to='authentic2_auth_saml.SAMLAuthenticator',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Rename an attribute',
                'verbose_name_plural': 'Rename attributes',
                'default_related_name': 'rename_attribute_actions',
            },
        ),
        migrations.CreateModel(
            name='AddRoleAction',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                (
                    'condition',
                    models.CharField(
                        blank=True, editable=False, max_length=256, verbose_name='Condition (unused)'
                    ),
                ),
                (
                    'mandatory',
                    models.BooleanField(default=False, editable=False, verbose_name='Mandatory (unused)'),
                ),
                (
                    'authenticator',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='add_role_actions',
                        to='authentic2_auth_saml.SAMLAuthenticator',
                    ),
                ),
                (
                    'role',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='add_role_actions',
                        to=settings.RBAC_ROLE_MODEL,
                        verbose_name='Role',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Add a role',
                'verbose_name_plural': 'Add roles',
                'default_related_name': 'add_role_actions',
            },
        ),
    ]
