from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ('auth', '0002_auto_20150323_1720'),
    ]

    operations = [
        migrations.CreateModel(
            name='AttributeItem',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                (
                    'attribute_name',
                    models.CharField(
                        default=('OpenLDAProotDSE', 'OpenLDAProotDSE'),
                        max_length=100,
                        verbose_name='Attribute name',
                        choices=[
                            ('OpenLDAProotDSE', 'OpenLDAProotDSE'),
                            ('aRecord', 'aRecord'),
                            ('administrativeRole', 'administrativeRole'),
                            ('alias', 'alias'),
                            ('aliasedObjectName', 'aliasedObjectName'),
                            ('altServer', 'altServer'),
                            ('associatedDomain', 'associatedDomain'),
                            ('associatedName', 'associatedName'),
                            ('attributeTypes', 'attributeTypes'),
                            ('audio', 'audio'),
                            ('authPassword', 'authPassword'),
                            ('authorityRevocationList', 'authorityRevocationList'),
                            ('authzFrom', 'authzFrom'),
                            ('authzTo', 'authzTo'),
                            ('bootFile', 'bootFile'),
                            ('bootParameter', 'bootParameter'),
                            ('buildingName', 'buildingName'),
                            ('businessCategory', 'businessCategory'),
                            ('c', 'c'),
                            ('cACertificate', 'cACertificate'),
                            ('cNAMERecord', 'cNAMERecord'),
                            ('carLicense', 'carLicense'),
                            ('certificateRevocationList', 'certificateRevocationList'),
                            ('children', 'children'),
                            ('cn', 'cn'),
                            ('co', 'co'),
                            ('collectiveAttributeSubentries', 'collectiveAttributeSubentries'),
                            ('collectiveAttributeSubentry', 'collectiveAttributeSubentry'),
                            ('collectiveExclusions', 'collectiveExclusions'),
                            ('configContext', 'configContext'),
                            ('contextCSN', 'contextCSN'),
                            ('createTimestamp', 'createTimestamp'),
                            ('creatorsName', 'creatorsName'),
                            ('crossCertificatePair', 'crossCertificatePair'),
                            ('dITContentRules', 'dITContentRules'),
                            ('dITRedirect', 'dITRedirect'),
                            ('dITStructureRules', 'dITStructureRules'),
                            ('dSAQuality', 'dSAQuality'),
                            ('dc', 'dc'),
                            ('deltaRevocationList', 'deltaRevocationList'),
                            ('departmentNumber', 'departmentNumber'),
                            ('description', 'description'),
                            ('destinationIndicator', 'destinationIndicator'),
                            ('displayName', 'displayName'),
                            ('distinguishedName', 'distinguishedName'),
                            ('dmdName', 'dmdName'),
                            ('dnQualifier', 'dnQualifier'),
                            ('documentAuthor', 'documentAuthor'),
                            ('documentIdentifier', 'documentIdentifier'),
                            ('documentLocation', 'documentLocation'),
                            ('documentPublisher', 'documentPublisher'),
                            ('documentTitle', 'documentTitle'),
                            ('documentVersion', 'documentVersion'),
                            ('drink', 'drink'),
                            ('dynamicObject', 'dynamicObject'),
                            ('dynamicSubtrees', 'dynamicSubtrees'),
                            ('eduOrgHomePageURI', 'eduOrgHomePageURI'),
                            ('eduOrgIdentityAuthNPolicyURI', 'eduOrgIdentityAuthNPolicyURI'),
                            ('eduOrgLegalName', 'eduOrgLegalName'),
                            ('eduOrgSuperiorURI', 'eduOrgSuperiorURI'),
                            ('eduOrgWhitePagesURI', 'eduOrgWhitePagesURI'),
                            ('eduPersonAffiliation', 'eduPersonAffiliation'),
                            ('eduPersonAssurance', 'eduPersonAssurance'),
                            ('eduPersonEntitlement', 'eduPersonEntitlement'),
                            ('eduPersonNickname', 'eduPersonNickname'),
                            ('eduPersonOrgDN', 'eduPersonOrgDN'),
                            ('eduPersonOrgUnitDN', 'eduPersonOrgUnitDN'),
                            ('eduPersonPrimaryAffiliation', 'eduPersonPrimaryAffiliation'),
                            ('eduPersonPrimaryOrgUnitDN', 'eduPersonPrimaryOrgUnitDN'),
                            ('eduPersonPrincipalName', 'eduPersonPrincipalName'),
                            ('eduPersonScopedAffiliation', 'eduPersonScopedAffiliation'),
                            ('eduPersonTargetedID', 'eduPersonTargetedID'),
                            ('email', 'email'),
                            ('employeeNumber', 'employeeNumber'),
                            ('employeeType', 'employeeType'),
                            ('enhancedSearchGuide', 'enhancedSearchGuide'),
                            ('entry', 'entry'),
                            ('entryCSN', 'entryCSN'),
                            ('entryDN', 'entryDN'),
                            ('entryTtl', 'entryTtl'),
                            ('entryUUID', 'entryUUID'),
                            ('extensibleObject', 'extensibleObject'),
                            ('fax', 'fax'),
                            ('gecos', 'gecos'),
                            ('generationQualifier', 'generationQualifier'),
                            ('gidNumber', 'gidNumber'),
                            ('givenName', 'givenName'),
                            ('glue', 'glue'),
                            ('hasSubordinates', 'hasSubordinates'),
                            ('homeDirectory', 'homeDirectory'),
                            ('homePhone', 'homePhone'),
                            ('homePostalAddress', 'homePostalAddress'),
                            ('host', 'host'),
                            ('houseIdentifier', 'houseIdentifier'),
                            ('info', 'info'),
                            ('initials', 'initials'),
                            ('internationaliSDNNumber', 'internationaliSDNNumber'),
                            ('ipHostNumber', 'ipHostNumber'),
                            ('ipNetmaskNumber', 'ipNetmaskNumber'),
                            ('ipNetworkNumber', 'ipNetworkNumber'),
                            ('ipProtocolNumber', 'ipProtocolNumber'),
                            ('ipServicePort', 'ipServicePort'),
                            ('ipServiceProtocolSUPname', 'ipServiceProtocolSUPname'),
                            ('janetMailbox', 'janetMailbox'),
                            ('jpegPhoto', 'jpegPhoto'),
                            ('knowledgeInformation', 'knowledgeInformation'),
                            ('l', 'l'),
                            ('labeledURI', 'labeledURI'),
                            ('ldapSyntaxes', 'ldapSyntaxes'),
                            ('loginShell', 'loginShell'),
                            ('mDRecord', 'mDRecord'),
                            ('mXRecord', 'mXRecord'),
                            ('macAddress', 'macAddress'),
                            ('mail', 'mail'),
                            ('mailForwardingAddress', 'mailForwardingAddress'),
                            ('mailHost', 'mailHost'),
                            ('mailLocalAddress', 'mailLocalAddress'),
                            ('mailPreferenceOption', 'mailPreferenceOption'),
                            ('mailRoutingAddress', 'mailRoutingAddress'),
                            ('manager', 'manager'),
                            ('matchingRuleUse', 'matchingRuleUse'),
                            ('matchingRules', 'matchingRules'),
                            ('member', 'member'),
                            ('memberNisNetgroup', 'memberNisNetgroup'),
                            ('memberUid', 'memberUid'),
                            ('mobile', 'mobile'),
                            ('modifiersName', 'modifiersName'),
                            ('modifyTimestamp', 'modifyTimestamp'),
                            ('monitorContext', 'monitorContext'),
                            ('nSRecord', 'nSRecord'),
                            ('name', 'name'),
                            ('nameForms', 'nameForms'),
                            ('namingCSN', 'namingCSN'),
                            ('namingContexts', 'namingContexts'),
                            ('nisMapEntry', 'nisMapEntry'),
                            ('nisMapNameSUPname', 'nisMapNameSUPname'),
                            ('nisNetgroupTriple', 'nisNetgroupTriple'),
                            ('o', 'o'),
                            ('objectClass', 'objectClass'),
                            ('objectClasses', 'objectClasses'),
                            ('oncRpcNumber', 'oncRpcNumber'),
                            ('organizationalStatus', 'organizationalStatus'),
                            ('otherMailbox', 'otherMailbox'),
                            ('ou', 'ou'),
                            ('owner', 'owner'),
                            ('pager', 'pager'),
                            ('personalSignature', 'personalSignature'),
                            ('personalTitle', 'personalTitle'),
                            ('photo', 'photo'),
                            ('physicalDeliveryOfficeName', 'physicalDeliveryOfficeName'),
                            ('postOfficeBox', 'postOfficeBox'),
                            ('postalAddress', 'postalAddress'),
                            ('postalCode', 'postalCode'),
                            ('preferredDeliveryMethod', 'preferredDeliveryMethod'),
                            ('preferredLanguage', 'preferredLanguage'),
                            ('presentationAddress', 'presentationAddress'),
                            ('protocolInformation', 'protocolInformation'),
                            ('pseudonym', 'pseudonym'),
                            ('ref', 'ref'),
                            ('referral', 'referral'),
                            ('registeredAddress', 'registeredAddress'),
                            ('rfc822MailMember', 'rfc822MailMember'),
                            ('role', 'role'),
                            ('roleOccupant', 'roleOccupant'),
                            ('roomNumber', 'roomNumber'),
                            ('sOARecord', 'sOARecord'),
                            ('schacHomeOrganization', 'schacHomeOrganization'),
                            ('schacHomeOrganizationType', 'schacHomeOrganizationType'),
                            ('searchGuide', 'searchGuide'),
                            ('secretary', 'secretary'),
                            ('seeAlso', 'seeAlso'),
                            ('serialNumber', 'serialNumber'),
                            ('shadowExpire', 'shadowExpire'),
                            ('shadowFlag', 'shadowFlag'),
                            ('shadowInactive', 'shadowInactive'),
                            ('shadowLastChange', 'shadowLastChange'),
                            ('shadowMax', 'shadowMax'),
                            ('shadowMin', 'shadowMin'),
                            ('shadowWarning', 'shadowWarning'),
                            ('singleLevelQuality', 'singleLevelQuality'),
                            ('sn', 'sn'),
                            ('st', 'st'),
                            ('street', 'street'),
                            ('structuralObjectClass', 'structuralObjectClass'),
                            ('subentry', 'subentry'),
                            ('subschema', 'subschema'),
                            ('subschemaSubentry', 'subschemaSubentry'),
                            ('subtreeMaximumQuality', 'subtreeMaximumQuality'),
                            ('subtreeMinimumQuality', 'subtreeMinimumQuality'),
                            ('subtreeSpecification', 'subtreeSpecification'),
                            ('supannActivite', 'supannActivite'),
                            ('supannAffectation', 'supannAffectation'),
                            ('supannAliasLogin', 'supannAliasLogin'),
                            ('supannAutreMail', 'supannAutreMail'),
                            ('supannAutreTelephone', 'supannAutreTelephone'),
                            ('supannCivilite', 'supannCivilite'),
                            ('supannCodeEntite', 'supannCodeEntite'),
                            ('supannCodeEntiteParent', 'supannCodeEntiteParent'),
                            ('supannCodeINE', 'supannCodeINE'),
                            ('supannEmpCorps', 'supannEmpCorps'),
                            ('supannEmpId', 'supannEmpId'),
                            ('supannEntiteAffectation', 'supannEntiteAffectation'),
                            ('supannEntiteAffectationPrincipale', 'supannEntiteAffectationPrincipale'),
                            ('supannEtablissement', 'supannEtablissement'),
                            ('supannEtuAnneeInscription', 'supannEtuAnneeInscription'),
                            ('supannEtuCursusAnnee', 'supannEtuCursusAnnee'),
                            ('supannEtuDiplome', 'supannEtuDiplome'),
                            ('supannEtuElementPedagogique', 'supannEtuElementPedagogique'),
                            ('supannEtuEtape', 'supannEtuEtape'),
                            ('supannEtuId', 'supannEtuId'),
                            ('supannEtuInscription', 'supannEtuInscription'),
                            ('supannEtuRegimeInscription', 'supannEtuRegimeInscription'),
                            ('supannEtuSecteurDisciplinaire', 'supannEtuSecteurDisciplinaire'),
                            ('supannEtuTypeDiplome', 'supannEtuTypeDiplome'),
                            ('supannGroupeAdminDN', 'supannGroupeAdminDN'),
                            ('supannGroupeDateFin', 'supannGroupeDateFin'),
                            ('supannGroupeLecteurDN', 'supannGroupeLecteurDN'),
                            ('supannListeRouge', 'supannListeRouge'),
                            ('supannMailPerso', 'supannMailPerso'),
                            ('supannOrganisme', 'supannOrganisme'),
                            ('supannParrainDN', 'supannParrainDN'),
                            ('supannRefId', 'supannRefId'),
                            ('supannRole', 'supannRole'),
                            ('supannRoleEntite', 'supannRoleEntite'),
                            ('supannRoleGenerique', 'supannRoleGenerique'),
                            ('supannTypeEntite', 'supannTypeEntite'),
                            ('supannTypeEntiteAffectation', 'supannTypeEntiteAffectation'),
                            ('superiorUUID', 'superiorUUID'),
                            ('supportedAlgorithms', 'supportedAlgorithms'),
                            ('supportedApplicationContext', 'supportedApplicationContext'),
                            ('supportedAuthPasswordSchemes', 'supportedAuthPasswordSchemes'),
                            ('supportedControl', 'supportedControl'),
                            ('supportedExtension', 'supportedExtension'),
                            ('supportedFeatures', 'supportedFeatures'),
                            ('supportedLDAPVersion', 'supportedLDAPVersion'),
                            ('supportedSASLMechanisms', 'supportedSASLMechanisms'),
                            ('syncConsumerSubentry', 'syncConsumerSubentry'),
                            ('syncProviderSubentry', 'syncProviderSubentry'),
                            ('syncTimestamp', 'syncTimestamp'),
                            ('syncreplCookie', 'syncreplCookie'),
                            ('telephoneNumber', 'telephoneNumber'),
                            ('teletexTerminalIdentifier', 'teletexTerminalIdentifier'),
                            ('telexNumber', 'telexNumber'),
                            ('textEncodedORAddress', 'textEncodedORAddress'),
                            ('title', 'title'),
                            ('top', 'top'),
                            ('uid', 'uid'),
                            ('uidNumber', 'uidNumber'),
                            ('uniqueIdentifier', 'uniqueIdentifier'),
                            ('uniqueMember', 'uniqueMember'),
                            ('userCertificate', 'userCertificate'),
                            ('userClass', 'userClass'),
                            ('userPKCS12', 'userPKCS12'),
                            ('userPassword', 'userPassword'),
                            ('userSMIMECertificate', 'userSMIMECertificate'),
                            ('vendorName', 'vendorName'),
                            ('vendorVersion', 'vendorVersion'),
                            ('x121Address', 'x121Address'),
                            ('x500UniqueIdentifier', 'x500UniqueIdentifier'),
                        ],
                    ),
                ),
                (
                    'output_name_format',
                    models.CharField(
                        default=('urn:oasis:names:tc:SAML:2.0:attrname-format:uri', 'SAMLv2 URI'),
                        max_length=100,
                        verbose_name='Output name format',
                        choices=[
                            ('urn:oasis:names:tc:SAML:2.0:attrname-format:uri', 'SAMLv2 URI'),
                            ('urn:oasis:names:tc:SAML:2.0:attrname-format:basic', 'SAMLv2 BASIC'),
                        ],
                    ),
                ),
                (
                    'output_namespace',
                    models.CharField(
                        default=('Default', 'Default'),
                        max_length=100,
                        verbose_name='Output namespace',
                        choices=[
                            ('Default', 'Default'),
                            (
                                'http://schemas.xmlsoap.org/ws/2005/05/identity/claims',
                                'http://schemas.xmlsoap.org/ws/2005/05/identity/claims',
                            ),
                        ],
                    ),
                ),
                ('required', models.BooleanField(default=False, verbose_name='Required')),
            ],
            options={
                'verbose_name': 'attribute list item',
                'verbose_name_plural': 'attribute list items',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='AttributeList',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('name', models.CharField(unique=True, max_length=100, verbose_name='Name')),
                (
                    'attributes',
                    models.ManyToManyField(
                        related_name='attributes of the list',
                        null=True,
                        verbose_name='Attributes',
                        to='attribute_aggregator.AttributeItem',
                        blank=True,
                    ),
                ),
            ],
            options={
                'verbose_name': 'attribute list',
                'verbose_name_plural': 'attribute lists',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='AttributeSource',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('name', models.CharField(unique=True, max_length=200, verbose_name='Name')),
                (
                    'namespace',
                    models.CharField(
                        default=('Default', 'Default'),
                        max_length=100,
                        verbose_name='Namespace',
                        choices=[
                            ('Default', 'Default'),
                            (
                                'http://schemas.xmlsoap.org/ws/2005/05/identity/claims',
                                'http://schemas.xmlsoap.org/ws/2005/05/identity/claims',
                            ),
                        ],
                    ),
                ),
            ],
            options={
                'verbose_name': 'attribute source',
                'verbose_name_plural': 'attribute sources',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='LdapSource',
            fields=[
                (
                    'attributesource_ptr',
                    models.OneToOneField(
                        parent_link=True,
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        to='attribute_aggregator.AttributeSource',
                        on_delete=models.CASCADE,
                    ),
                ),
                ('server', models.CharField(unique=True, max_length=200, verbose_name='Server')),
                ('user', models.CharField(max_length=200, null=True, verbose_name='User', blank=True)),
                (
                    'password',
                    models.CharField(max_length=200, null=True, verbose_name='Password', blank=True),
                ),
                ('base', models.CharField(max_length=200, verbose_name='Base')),
                ('port', models.IntegerField(default=389, verbose_name='Port')),
                ('ldaps', models.BooleanField(default=False, verbose_name='LDAPS')),
                ('certificate', models.TextField(verbose_name='Certificate', blank=True)),
                (
                    'is_auth_backend',
                    models.BooleanField(default=False, verbose_name='Is it used for authentication?'),
                ),
            ],
            options={
                'verbose_name': 'ldap attribute source',
                'verbose_name_plural': 'ldap attribute sources',
            },
            bases=('attribute_aggregator.attributesource',),
        ),
        migrations.CreateModel(
            name='UserAliasInSource',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('name', models.CharField(max_length=200, verbose_name='Name')),
                (
                    'source',
                    models.ForeignKey(
                        verbose_name='attribute source',
                        to='attribute_aggregator.AttributeSource',
                        on_delete=models.CASCADE,
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        related_name='user_alias_in_source',
                        verbose_name='user',
                        to='auth.User',
                        on_delete=models.CASCADE,
                    ),
                ),
            ],
            options={
                'verbose_name': 'user alias from source',
                'verbose_name_plural': 'user aliases from source',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='UserAttributeProfile',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('data', models.TextField(null=True, blank=True)),
                (
                    'user',
                    models.OneToOneField(
                        related_name='user_attribute_profile',
                        null=True,
                        blank=True,
                        to='auth.User',
                        on_delete=models.CASCADE,
                    ),
                ),
            ],
            options={
                'verbose_name': 'user attribute profile',
                'verbose_name_plural': 'user attribute profiles',
            },
            bases=(models.Model,),
        ),
        migrations.AlterUniqueTogether(
            name='useraliasinsource',
            unique_together={('name', 'source')},
        ),
        migrations.AddField(
            model_name='attributeitem',
            name='source',
            field=models.ForeignKey(
                verbose_name='Attribute source',
                blank=True,
                to='attribute_aggregator.AttributeSource',
                null=True,
                on_delete=models.CASCADE,
            ),
            preserve_default=True,
        ),
    ]
