# Generated by Django 3.2.18 on 2023-06-01 15:44

from django.conf import settings
from django.db import migrations


def migrate_registration_open(apps, schema_editor):
    LoginPasswordAuthenticator = apps.get_model('authenticators', 'LoginPasswordAuthenticator')
    authenticator = LoginPasswordAuthenticator.objects.get_or_create(
        slug='password-authenticator',
        defaults={'enabled': True},
    )[0]
    authenticator.registration_open = getattr(settings, 'REGISTRATION_OPEN', True)
    authenticator.save()


class Migration(migrations.Migration):
    dependencies = [
        ('authenticators', '0006_loginpasswordauthenticator_registration_open'),
    ]

    operations = [
        migrations.RunPython(migrate_registration_open, reverse_code=migrations.RunPython.noop),
    ]
