# Generated by Django 2.2.28 on 2022-05-25 10:26

import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import migrations, models

import authentic2_auth_fc.models


class Migration(migrations.Migration):
    dependencies = [
        ('authenticators', '0003_auto_20220413_1504'),
        ('authentic2_auth_fc', '0004_fcaccount_order2'),
    ]

    operations = [
        migrations.CreateModel(
            name='FcAuthenticator',
            fields=[
                (
                    'baseauthenticator_ptr',
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to='authenticators.BaseAuthenticator',
                    ),
                ),
                (
                    'platform',
                    models.CharField(
                        choices=[
                            ('prod', 'Production'),
                            ('test', 'Integration'),
                            ('tnew', 'Integration with new URLs (for version 2 only)'),
                        ],
                        default='test',
                        max_length=4,
                        verbose_name='Platform',
                    ),
                ),
                (
                    'client_id',
                    models.CharField(max_length=256, verbose_name='Client ID'),
                ),
                ('client_secret', models.CharField(max_length=256, verbose_name='Client Secret')),
                (
                    'scopes',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(
                            choices=[
                                ('given_name', 'given name (given_name)'),
                                ('gender', 'gender (gender)'),
                                ('birthdate', 'birthdate (birthdate)'),
                                ('birthcountry', 'birthcountry (birthcountry)'),
                                ('birthplace', 'birthplace (birthplace)'),
                                ('family_name', 'family name (family_name)'),
                                ('email', 'email (email)'),
                                ('preferred_username', 'usual family name (preferred_username)'),
                                ('identite_pivot', 'core identity (identite_pivot)'),
                                ('profile', 'profile (profile)'),
                                ('birth', 'birth profile (birth)'),
                                ('rnipp_given_name', 'given name (from the RNIPP)'),
                                ('rnipp_family_name', 'family name (from the RNIPP)'),
                                ('rnipp_gender', 'gender (from the RNIPP)'),
                                ('rnipp_birthcountry', 'birthcountry (from the RNIPP)'),
                                ('rnipp_birthplace', 'birthplace (from the RNIPP)'),
                                ('rnipp_birthdate', 'birthdate (from the RNIPP)'),
                                ('rnipp_profile', 'profile (from the RNIPP)'),
                                ('rnipp_identite_pivot', 'core identity (from the RNIPP)'),
                            ],
                            max_length=32,
                        ),
                        default=authentic2_auth_fc.models.get_default_scopes,
                        size=None,
                        verbose_name='Scopes',
                    ),
                ),
            ],
            options={
                'verbose_name': 'FranceConnect',
            },
            bases=('authenticators.baseauthenticator',),
        ),
    ]
