(function () {
  window.a2_js_seconds_until = function () {
      var spans = document.getElementsByClassName('js-seconds-until');
      if (! spans.length) {
        return;
      }
      var span = spans[0];
      var timeout_id;
      var initial_time = Date.now();
      var until = initial_time + parseInt(span.textContent) * 1000;

      function decrease_seconds() {
        var now = Date.now();
        var duration = (until - now) / 1000;
        if (duration < 1) {
          var target_selector = span.getAttribute('data-target');
          if (target_selector) {
            var target = document.querySelector(target_selector);
            var replace = span.getAttribute('data-replace');
            if (replace) {
              target.innerHtml = '';
              target.textContent = replace;
              if (target.href) {
                  target.href = '';
              }
            } else {
              /* remove the target */
              target.parentNode.removeChild(target);
            }
          } else {
            /* remove the container */
            span.parentNode.parentNode.removeChild(span.parentNode);
          }
          clearInterval(timeout_id);
        } else {
          /* decrease seconds before retry */
          span.textContent = Math.floor(duration).toString();
        }
      }
      timeout_id = setInterval(decrease_seconds, 500);
  }
  window.a2_js_seconds_until();
})()
