# Generated by Django 3.2.18 on 2023-04-03 15:18

import uuid

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import ants_hub.data.models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='Collectivite',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name='ID'
                    ),
                ),
                ('nom', ants_hub.data.models.CharField(verbose_name='Nom')),
                (
                    'source_id',
                    ants_hub.data.models.CharField(verbose_name='Identifiant de la collectivité à la source'),
                ),
                ('url', ants_hub.data.models.URLField(verbose_name='URL du portail')),
                ('logo_url', ants_hub.data.models.URLField(blank=True, verbose_name='URL du logo')),
                (
                    'rdv_url',
                    ants_hub.data.models.URLField(blank=True, verbose_name='URL de prise de rendez-vous '),
                ),
                (
                    'gestion_url',
                    ants_hub.data.models.URLField(blank=True, verbose_name='URL de gestion des rendez-vous'),
                ),
                (
                    'annulation_url',
                    ants_hub.data.models.URLField(
                        blank=True, verbose_name="URL d'annulation des rendez-vous"
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Création')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Dernière mise à jour')),
            ],
            options={
                'verbose_name': 'collectivité',
                'verbose_name_plural': 'collectivités',
                'db_table': 'ants_hub_collectivite',
            },
        ),
        migrations.CreateModel(
            name='Lieu',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name='ID'
                    ),
                ),
                ('nom', ants_hub.data.models.CharField(verbose_name='Nom')),
                ('source_id', ants_hub.data.models.CharField(verbose_name='Identifiant du lieu à la source')),
                ('numero_rue', ants_hub.data.models.CharField(verbose_name='Numéro rue')),
                ('code_postal', ants_hub.data.models.CharField(verbose_name='Code postal')),
                ('ville', ants_hub.data.models.CharField(verbose_name='Ville')),
                ('longitude', models.FloatField(verbose_name='Longitude')),
                ('latitude', models.FloatField(verbose_name='Latitude')),
                ('url', ants_hub.data.models.URLField(blank=True, verbose_name='URL du portail')),
                ('logo_url', ants_hub.data.models.URLField(blank=True, verbose_name='URL du logo')),
                (
                    'rdv_url',
                    ants_hub.data.models.URLField(blank=True, verbose_name='URL de prise de rendez-vous '),
                ),
                (
                    'gestion_url',
                    ants_hub.data.models.URLField(blank=True, verbose_name='URL de gestion des rendez-vous'),
                ),
                (
                    'annulation_url',
                    ants_hub.data.models.URLField(
                        blank=True, verbose_name="URL d'annulation des rendez-vous"
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Création')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Dernière mise à jour')),
                (
                    'collectivite',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='lieux',
                        to='data.collectivite',
                        verbose_name='Collectivité',
                    ),
                ),
            ],
            options={
                'verbose_name': 'lieu',
                'verbose_name_plural': 'lieux',
                'db_table': 'ants_hub_lieu',
                'unique_together': {('collectivite', 'nom'), ('collectivite', 'source_id')},
            },
        ),
        migrations.CreateModel(
            name='Raccordement',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        verbose_name='UUID',
                    ),
                ),
                ('name', ants_hub.data.models.CharField(unique=True, verbose_name='Nom')),
                (
                    'apikey',
                    ants_hub.data.models.CharField(
                        default=ants_hub.data.models.generate_apikey,
                        help_text='Écrire "NEW" pour en générer une nouvelle.',
                        unique=True,
                        verbose_name='API key',
                    ),
                ),
                (
                    'apikey_digest',
                    models.UUIDField(db_index=True, editable=False, verbose_name="Condensat de l'API key"),
                ),
                ('notes', models.TextField(blank=True, verbose_name='Notes')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Création')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Dernière mise à jour')),
            ],
            options={
                'verbose_name': 'raccordement',
                'verbose_name_plural': 'raccordements',
                'db_table': 'ants_hub_raccordement',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='RendezVous',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        verbose_name='UUID',
                    ),
                ),
                (
                    'identifiant_predemande',
                    ants_hub.data.models.CharField(db_index=True, verbose_name='Identifiant de prédemande'),
                ),
                ('date', models.DateTimeField(verbose_name='Date')),
                (
                    'gestion_url',
                    ants_hub.data.models.URLField(blank=True, verbose_name='URL de gestion des rendez-vous'),
                ),
                (
                    'annulation_url',
                    ants_hub.data.models.URLField(
                        blank=True, verbose_name="URL d'annulation des rendez-vous"
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Création')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Dernière mise à jour')),
                (
                    'lieu',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='rdvs',
                        to='data.lieu',
                        verbose_name='Lieu',
                    ),
                ),
            ],
            options={
                'verbose_name': 'rendez-vous',
                'verbose_name_plural': 'rendez-vous',
                'db_table': 'ants_hub_rendez_vous',
            },
        ),
        migrations.AddField(
            model_name='collectivite',
            name='raccordement',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name='collectivites',
                to='data.raccordement',
                verbose_name='Raccordement',
            ),
        ),
        migrations.CreateModel(
            name='Plage',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name='ID'
                    ),
                ),
                ('date', models.DateField(verbose_name='Date')),
                ('horaires', ants_hub.data.models.HoraireField(verbose_name='Horaires')),
                ('duree', models.SmallIntegerField(verbose_name='Durée')),
                (
                    'type_de_rdv',
                    ants_hub.data.models.TypeDeRdvField(
                        choices=[(1, 'CNI'), (2, 'PASSPORT'), (3, 'CNI-PASSPORT')],
                        verbose_name='Type de rendez-vous',
                    ),
                ),
                (
                    'personnes',
                    models.SmallIntegerField(
                        default=1,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(5),
                        ],
                        verbose_name='Nombre de personnes maximum',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Création')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Dernière mise à jour')),
                (
                    'lieu',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='plages',
                        to='data.lieu',
                        verbose_name='Lieu',
                    ),
                ),
            ],
            options={
                'verbose_name': 'plage',
                'verbose_name_plural': 'plages',
                'db_table': 'ants_hub_plage',
                'unique_together': {('type_de_rdv', 'date', 'lieu')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='collectivite',
            unique_together={('raccordement', 'nom'), ('raccordement', 'source_id')},
        ),
    ]
